<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_agent_search = new b_account_info_agent_search();

// Run the page
$b_account_info_agent_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_agent_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($b_account_info_agent_search->IsModal) { ?>
var fb_account_info_agentsearch = currentAdvancedSearchForm = new ew.Form("fb_account_info_agentsearch", "search");
<?php } else { ?>
var fb_account_info_agentsearch = currentForm = new ew.Form("fb_account_info_agentsearch", "search");
<?php } ?>

// Form_CustomValidate event
fb_account_info_agentsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_info_agentsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_info_agentsearch.lists["x_b_type"] = <?php echo $b_account_info_agent_search->b_type->Lookup->toClientList() ?>;
fb_account_info_agentsearch.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_agent_search->b_type->options(FALSE, TRUE)) ?>;
fb_account_info_agentsearch.lists["x_grp"] = <?php echo $b_account_info_agent_search->grp->Lookup->toClientList() ?>;
fb_account_info_agentsearch.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_agent_search->grp->lookupOptions()) ?>;
fb_account_info_agentsearch.lists["x_account_type"] = <?php echo $b_account_info_agent_search->account_type->Lookup->toClientList() ?>;
fb_account_info_agentsearch.lists["x_account_type"].options = <?php echo JsonEncode($b_account_info_agent_search->account_type->lookupOptions()) ?>;
fb_account_info_agentsearch.lists["x_status"] = <?php echo $b_account_info_agent_search->status->Lookup->toClientList() ?>;
fb_account_info_agentsearch.lists["x_status"].options = <?php echo JsonEncode($b_account_info_agent_search->status->lookupOptions()) ?>;
fb_account_info_agentsearch.autoSuggests["x_status"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_info_agentsearch.lists["x_agent"] = <?php echo $b_account_info_agent_search->agent->Lookup->toClientList() ?>;
fb_account_info_agentsearch.lists["x_agent"].options = <?php echo JsonEncode($b_account_info_agent_search->agent->lookupOptions()) ?>;
fb_account_info_agentsearch.lists["x_frequency"] = <?php echo $b_account_info_agent_search->frequency->Lookup->toClientList() ?>;
fb_account_info_agentsearch.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_agent_search->frequency->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fb_account_info_agentsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_aadhaar_no");
	if (elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}[0-9]{4}[0-9]{4}$/))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->aadhaar_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_mobile");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->mobile->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->status->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pan_no");
	if (elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->pan_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_loan_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->loan_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_int_40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->int_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_disbursement_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->disbursement_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_emi_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->emi_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_no_of_emi");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->no_of_emi->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_otp_delivery_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->otp_delivery_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_otp_verify_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->otp_verify_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_info_agent_search->showPageHeader(); ?>
<?php
$b_account_info_agent_search->showMessage();
?>
<form name="fb_account_info_agentsearch" id="fb_account_info_agentsearch" class="<?php echo $b_account_info_agent_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_agent_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_agent_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info_agent">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$b_account_info_agent_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($b_account_info_agent->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label for="x_b_type" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_b_type"><?php echo $b_account_info_agent->b_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_b_type" id="z_b_type" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->b_type->cellAttributes() ?>>
			<span id="el_b_account_info_agent_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_b_type" data-value-separator="<?php echo $b_account_info_agent->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $b_account_info_agent->b_type->editAttributes() ?>>
		<?php echo $b_account_info_agent->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_grp"><?php echo $b_account_info_agent->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->grp->cellAttributes() ?>>
			<span id="el_b_account_info_agent_grp">
<?php $b_account_info_agent->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$b_account_info_agent->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_grp" data-value-separator="<?php echo $b_account_info_agent->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $b_account_info_agent->grp->editAttributes() ?>>
		<?php echo $b_account_info_agent->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $b_account_info_agent->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->account_type->Visible) { // account_type ?>
	<div id="r_account_type" class="form-group row">
		<label for="x_account_type" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_account_type"><?php echo $b_account_info_agent->account_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_account_type" id="z_account_type" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->account_type->cellAttributes() ?>>
			<span id="el_b_account_info_agent_account_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_account_type" data-value-separator="<?php echo $b_account_info_agent->account_type->displayValueSeparatorAttribute() ?>" id="x_account_type" name="x_account_type"<?php echo $b_account_info_agent->account_type->editAttributes() ?>>
		<?php echo $b_account_info_agent->account_type->selectOptionListHtml("x_account_type") ?>
	</select>
</div>
<?php echo $b_account_info_agent->account_type->Lookup->getParamTag("p_x_account_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label for="x_aadhaar_no" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_aadhaar_no"><?php echo $b_account_info_agent->aadhaar_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->aadhaar_no->cellAttributes() ?>>
			<span id="el_b_account_info_agent_aadhaar_no">
<input type="text" data-table="b_account_info_agent" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($b_account_info_agent->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->aadhaar_no->EditValue ?>"<?php echo $b_account_info_agent->aadhaar_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->account_no->Visible) { // account_no ?>
	<div id="r_account_no" class="form-group row">
		<label for="x_account_no" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_account_no"><?php echo $b_account_info_agent->account_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_account_no" id="z_account_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->account_no->cellAttributes() ?>>
			<span id="el_b_account_info_agent_account_no">
<input type="text" data-table="b_account_info_agent" data-field="x_account_no" name="x_account_no" id="x_account_no" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($b_account_info_agent->account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->account_no->EditValue ?>"<?php echo $b_account_info_agent->account_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label for="x_formal_name" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_formal_name"><?php echo $b_account_info_agent->formal_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->formal_name->cellAttributes() ?>>
			<span id="el_b_account_info_agent_formal_name">
<input type="text" data-table="b_account_info_agent" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info_agent->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->formal_name->EditValue ?>"<?php echo $b_account_info_agent->formal_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_mobile"><?php echo $b_account_info_agent->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mobile" id="z_mobile" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->mobile->cellAttributes() ?>>
			<span id="el_b_account_info_agent_mobile">
<input type="text" data-table="b_account_info_agent" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info_agent->mobile->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->mobile->EditValue ?>"<?php echo $b_account_info_agent->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent__email"><?php echo $b_account_info_agent->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->_email->cellAttributes() ?>>
			<span id="el_b_account_info_agent__email">
<input type="text" data-table="b_account_info_agent" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info_agent->_email->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->_email->EditValue ?>"<?php echo $b_account_info_agent->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_image"><?php echo $b_account_info_agent->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->image->cellAttributes() ?>>
			<span id="el_b_account_info_agent_image">
<input type="text" data-table="b_account_info_agent" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($b_account_info_agent->image->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->image->EditValue ?>"<?php echo $b_account_info_agent->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_status"><?php echo $b_account_info_agent->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->status->cellAttributes() ?>>
			<span id="el_b_account_info_agent_status">
<?php
$wrkonchange = "" . trim(@$b_account_info_agent->status->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$b_account_info_agent->status->EditAttrs["onchange"] = "";
?>
<span id="as_x_status" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_status" id="sv_x_status" value="<?php echo RemoveHtml($b_account_info_agent->status->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->status->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($b_account_info_agent->status->getPlaceHolder()) ?>"<?php echo $b_account_info_agent->status->editAttributes() ?>>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_status" data-value-separator="<?php echo $b_account_info_agent->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info_agent->status->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fb_account_info_agentsearch.createAutoSuggest({"id":"x_status","forceSelect":true});
</script>
<?php echo $b_account_info_agent->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label for="x_pan_no" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_pan_no"><?php echo $b_account_info_agent->pan_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->pan_no->cellAttributes() ?>>
			<span id="el_b_account_info_agent_pan_no">
<input type="text" data-table="b_account_info_agent" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info_agent->pan_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->pan_no->EditValue ?>"<?php echo $b_account_info_agent->pan_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_id_proof"><?php echo $b_account_info_agent->id_proof->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_id_proof" id="z_id_proof" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->id_proof->cellAttributes() ?>>
			<span id="el_b_account_info_agent_id_proof">
<input type="text" data-table="b_account_info_agent" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($b_account_info_agent->id_proof->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->id_proof->EditValue ?>"<?php echo $b_account_info_agent->id_proof->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label for="x_agent" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_agent"><?php echo $b_account_info_agent->agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_agent" id="z_agent" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->agent->cellAttributes() ?>>
			<span id="el_b_account_info_agent_agent">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$b_account_info_agent->userIDAllow("search")) { // Non system admin ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_agent" data-value-separator="<?php echo $b_account_info_agent->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info_agent->agent->editAttributes() ?>>
		<?php echo $b_account_info_agent->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info_agent->agent->Lookup->getParamTag("p_x_agent") ?>
<?php } else { ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_agent" data-value-separator="<?php echo $b_account_info_agent->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info_agent->agent->editAttributes() ?>>
		<?php echo $b_account_info_agent->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info_agent->agent->Lookup->getParamTag("p_x_agent") ?>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label for="x_other_details" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_other_details"><?php echo $b_account_info_agent->other_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other_details" id="z_other_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->other_details->cellAttributes() ?>>
			<span id="el_b_account_info_agent_other_details">
<input type="text" data-table="b_account_info_agent" data-field="x_other_details" name="x_other_details" id="x_other_details" size="35" placeholder="<?php echo HtmlEncode($b_account_info_agent->other_details->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->other_details->EditValue ?>"<?php echo $b_account_info_agent->other_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->loan_amount->Visible) { // loan_amount ?>
	<div id="r_loan_amount" class="form-group row">
		<label for="x_loan_amount" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_loan_amount"><?php echo $b_account_info_agent->loan_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_loan_amount" id="z_loan_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->loan_amount->cellAttributes() ?>>
			<span id="el_b_account_info_agent_loan_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->loan_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->loan_amount->EditValue ?>"<?php echo $b_account_info_agent->loan_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->int_40->Visible) { // int_@ ?>
	<div id="r_int_40" class="form-group row">
		<label for="x_int_40" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_int_40"><?php echo $b_account_info_agent->int_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_int_40" id="z_int_40" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->int_40->cellAttributes() ?>>
			<span id="el_b_account_info_agent_int_40">
<input type="text" data-table="b_account_info_agent" data-field="x_int_40" name="x_int_40" id="x_int_40" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->int_40->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->int_40->EditValue ?>"<?php echo $b_account_info_agent->int_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->disbursement_amount->Visible) { // disbursement_amount ?>
	<div id="r_disbursement_amount" class="form-group row">
		<label for="x_disbursement_amount" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_disbursement_amount"><?php echo $b_account_info_agent->disbursement_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_disbursement_amount" id="z_disbursement_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->disbursement_amount->cellAttributes() ?>>
			<span id="el_b_account_info_agent_disbursement_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->disbursement_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->disbursement_amount->EditValue ?>"<?php echo $b_account_info_agent->disbursement_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->emi_amount->Visible) { // emi_amount ?>
	<div id="r_emi_amount" class="form-group row">
		<label for="x_emi_amount" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_emi_amount"><?php echo $b_account_info_agent->emi_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emi_amount" id="z_emi_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->emi_amount->cellAttributes() ?>>
			<span id="el_b_account_info_agent_emi_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->emi_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->emi_amount->EditValue ?>"<?php echo $b_account_info_agent->emi_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label for="x_no_of_emi" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_no_of_emi"><?php echo $b_account_info_agent->no_of_emi->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no_of_emi" id="z_no_of_emi" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->no_of_emi->cellAttributes() ?>>
			<span id="el_b_account_info_agent_no_of_emi">
<input type="text" data-table="b_account_info_agent" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->no_of_emi->EditValue ?>"<?php echo $b_account_info_agent->no_of_emi->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->frequency->Visible) { // frequency ?>
	<div id="r_frequency" class="form-group row">
		<label for="x_frequency" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_frequency"><?php echo $b_account_info_agent->frequency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_frequency" id="z_frequency" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->frequency->cellAttributes() ?>>
			<span id="el_b_account_info_agent_frequency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_frequency" data-value-separator="<?php echo $b_account_info_agent->frequency->displayValueSeparatorAttribute() ?>" id="x_frequency" name="x_frequency"<?php echo $b_account_info_agent->frequency->editAttributes() ?>>
		<?php echo $b_account_info_agent->frequency->selectOptionListHtml("x_frequency") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_operator"><?php echo $b_account_info_agent->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->operator->cellAttributes() ?>>
			<span id="el_b_account_info_agent_operator">
<input type="text" data-table="b_account_info_agent" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->operator->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->operator->EditValue ?>"<?php echo $b_account_info_agent->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_datetime"><?php echo $b_account_info_agent->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->datetime->cellAttributes() ?>>
			<span id="el_b_account_info_agent_datetime">
<input type="text" data-table="b_account_info_agent" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($b_account_info_agent->datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->datetime->EditValue ?>"<?php echo $b_account_info_agent->datetime->editAttributes() ?>>
<?php if (!$b_account_info_agent->datetime->ReadOnly && !$b_account_info_agent->datetime->Disabled && !isset($b_account_info_agent->datetime->EditAttrs["readonly"]) && !isset($b_account_info_agent->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_info_agentsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
	<div id="r_otp_delivery_datetime" class="form-group row">
		<label for="x_otp_delivery_datetime" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_otp_delivery_datetime"><?php echo $b_account_info_agent->otp_delivery_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_otp_delivery_datetime" id="z_otp_delivery_datetime" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->otp_delivery_datetime->cellAttributes() ?>>
			<span id="el_b_account_info_agent_otp_delivery_datetime">
<input type="text" data-table="b_account_info_agent" data-field="x_otp_delivery_datetime" name="x_otp_delivery_datetime" id="x_otp_delivery_datetime" placeholder="<?php echo HtmlEncode($b_account_info_agent->otp_delivery_datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->otp_delivery_datetime->EditValue ?>"<?php echo $b_account_info_agent->otp_delivery_datetime->editAttributes() ?>>
<?php if (!$b_account_info_agent->otp_delivery_datetime->ReadOnly && !$b_account_info_agent->otp_delivery_datetime->Disabled && !isset($b_account_info_agent->otp_delivery_datetime->EditAttrs["readonly"]) && !isset($b_account_info_agent->otp_delivery_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_info_agentsearch", "x_otp_delivery_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
	<div id="r_otp_verify_datetime" class="form-group row">
		<label for="x_otp_verify_datetime" class="<?php echo $b_account_info_agent_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent_otp_verify_datetime"><?php echo $b_account_info_agent->otp_verify_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_otp_verify_datetime" id="z_otp_verify_datetime" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_agent_search->RightColumnClass ?>"><div<?php echo $b_account_info_agent->otp_verify_datetime->cellAttributes() ?>>
			<span id="el_b_account_info_agent_otp_verify_datetime">
<input type="text" data-table="b_account_info_agent" data-field="x_otp_verify_datetime" name="x_otp_verify_datetime" id="x_otp_verify_datetime" placeholder="<?php echo HtmlEncode($b_account_info_agent->otp_verify_datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->otp_verify_datetime->EditValue ?>"<?php echo $b_account_info_agent->otp_verify_datetime->editAttributes() ?>>
<?php if (!$b_account_info_agent->otp_verify_datetime->ReadOnly && !$b_account_info_agent->otp_verify_datetime->Disabled && !isset($b_account_info_agent->otp_verify_datetime->EditAttrs["readonly"]) && !isset($b_account_info_agent->otp_verify_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_info_agentsearch", "x_otp_verify_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_account_info_agent_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_account_info_agent_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_info_agent_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_account_info_agent_search->terminate();
?>