<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_agent_update = new b_account_info_agent_update();

// Run the page
$b_account_info_agent_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_agent_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fb_account_info_agentupdate = currentForm = new ew.Form("fb_account_info_agentupdate", "update");

// Validate form
fb_account_info_agentupdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($b_account_info_agent_update->b_type->Required) { ?>
			elm = this.getElements("x" + infix + "_b_type");
			uelm = this.getElements("u" + infix + "_b_type");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->b_type->caption(), $b_account_info_agent->b_type->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			uelm = this.getElements("u" + infix + "_grp");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->grp->caption(), $b_account_info_agent->grp->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->account_type->Required) { ?>
			elm = this.getElements("x" + infix + "_account_type");
			uelm = this.getElements("u" + infix + "_account_type");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->account_type->caption(), $b_account_info_agent->account_type->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			uelm = this.getElements("u" + infix + "_aadhaar_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->aadhaar_no->caption(), $b_account_info_agent->aadhaar_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_account_no");
			uelm = this.getElements("u" + infix + "_account_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->account_no->caption(), $b_account_info_agent->account_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			uelm = this.getElements("u" + infix + "_formal_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->formal_name->caption(), $b_account_info_agent->formal_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			uelm = this.getElements("u" + infix + "_mobile");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->mobile->caption(), $b_account_info_agent->mobile->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			uelm = this.getElements("u" + infix + "__email");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->_email->caption(), $b_account_info_agent->_email->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			uelm = this.getElements("u" + infix + "__email");
			if (uelm && uelm.checked && elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->_email->errorMessage()) ?>");
		<?php if ($b_account_info_agent_update->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			uelm = this.getElements("u" + infix + "_image");
			if (uelm && uelm.checked) {
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->image->caption(), $b_account_info_agent->image->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			uelm = this.getElements("u" + infix + "_status");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->status->caption(), $b_account_info_agent->status->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			uelm = this.getElements("u" + infix + "_status");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->status->errorMessage()) ?>");
		<?php if ($b_account_info_agent_update->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			uelm = this.getElements("u" + infix + "_pan_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->pan_no->caption(), $b_account_info_agent->pan_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->id_proof->Required) { ?>
			felm = this.getElements("x" + infix + "_id_proof");
			elm = this.getElements("fn_x" + infix + "_id_proof");
			uelm = this.getElements("u" + infix + "_id_proof");
			if (uelm && uelm.checked) {
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->id_proof->caption(), $b_account_info_agent->id_proof->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->agent->Required) { ?>
			elm = this.getElements("x" + infix + "_agent");
			uelm = this.getElements("u" + infix + "_agent");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->agent->caption(), $b_account_info_agent->agent->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			uelm = this.getElements("u" + infix + "_other_details");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->other_details->caption(), $b_account_info_agent->other_details->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->loan_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			uelm = this.getElements("u" + infix + "_loan_amount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->loan_amount->caption(), $b_account_info_agent->loan_amount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			uelm = this.getElements("u" + infix + "_loan_amount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->loan_amount->errorMessage()) ?>");
		<?php if ($b_account_info_agent_update->int_40->Required) { ?>
			elm = this.getElements("x" + infix + "_int_40");
			uelm = this.getElements("u" + infix + "_int_40");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->int_40->caption(), $b_account_info_agent->int_40->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_int_40");
			uelm = this.getElements("u" + infix + "_int_40");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->int_40->errorMessage()) ?>");
		<?php if ($b_account_info_agent_update->disbursement_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			uelm = this.getElements("u" + infix + "_disbursement_amount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->disbursement_amount->caption(), $b_account_info_agent->disbursement_amount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			uelm = this.getElements("u" + infix + "_disbursement_amount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->disbursement_amount->errorMessage()) ?>");
		<?php if ($b_account_info_agent_update->emi_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			uelm = this.getElements("u" + infix + "_emi_amount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->emi_amount->caption(), $b_account_info_agent->emi_amount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			uelm = this.getElements("u" + infix + "_emi_amount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->emi_amount->errorMessage()) ?>");
		<?php if ($b_account_info_agent_update->no_of_emi->Required) { ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			uelm = this.getElements("u" + infix + "_no_of_emi");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->no_of_emi->caption(), $b_account_info_agent->no_of_emi->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			uelm = this.getElements("u" + infix + "_no_of_emi");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->no_of_emi->errorMessage()) ?>");
		<?php if ($b_account_info_agent_update->frequency->Required) { ?>
			elm = this.getElements("x" + infix + "_frequency");
			uelm = this.getElements("u" + infix + "_frequency");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->frequency->caption(), $b_account_info_agent->frequency->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			uelm = this.getElements("u" + infix + "_operator");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->operator->caption(), $b_account_info_agent->operator->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_agent_update->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			uelm = this.getElements("u" + infix + "_datetime");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->datetime->caption(), $b_account_info_agent->datetime->RequiredErrorMessage)) ?>");
			}
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fb_account_info_agentupdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_info_agentupdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_info_agentupdate.lists["x_b_type"] = <?php echo $b_account_info_agent_update->b_type->Lookup->toClientList() ?>;
fb_account_info_agentupdate.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_agent_update->b_type->options(FALSE, TRUE)) ?>;
fb_account_info_agentupdate.lists["x_grp"] = <?php echo $b_account_info_agent_update->grp->Lookup->toClientList() ?>;
fb_account_info_agentupdate.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_agent_update->grp->lookupOptions()) ?>;
fb_account_info_agentupdate.lists["x_account_type"] = <?php echo $b_account_info_agent_update->account_type->Lookup->toClientList() ?>;
fb_account_info_agentupdate.lists["x_account_type"].options = <?php echo JsonEncode($b_account_info_agent_update->account_type->lookupOptions()) ?>;
fb_account_info_agentupdate.lists["x_status"] = <?php echo $b_account_info_agent_update->status->Lookup->toClientList() ?>;
fb_account_info_agentupdate.lists["x_status"].options = <?php echo JsonEncode($b_account_info_agent_update->status->lookupOptions()) ?>;
fb_account_info_agentupdate.autoSuggests["x_status"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_info_agentupdate.lists["x_agent"] = <?php echo $b_account_info_agent_update->agent->Lookup->toClientList() ?>;
fb_account_info_agentupdate.lists["x_agent"].options = <?php echo JsonEncode($b_account_info_agent_update->agent->lookupOptions()) ?>;
fb_account_info_agentupdate.lists["x_frequency"] = <?php echo $b_account_info_agent_update->frequency->Lookup->toClientList() ?>;
fb_account_info_agentupdate.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_agent_update->frequency->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_info_agent_update->showPageHeader(); ?>
<?php
$b_account_info_agent_update->showMessage();
?>
<form name="fb_account_info_agentupdate" id="fb_account_info_agentupdate" class="<?php echo $b_account_info_agent_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_agent_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_agent_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info_agent">
<?php if ($b_account_info_agent->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$b_account_info_agent_update->IsModal ?>">
<?php foreach ($b_account_info_agent_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_b_account_info_agentupdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $b_account_info_agent_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($b_account_info_agent->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label for="x_b_type" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_b_type" id="u_b_type" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->b_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_b_type" id="u_b_type" value="<?php echo $b_account_info_agent->b_type->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->b_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_b_type"><?php echo $b_account_info_agent->b_type->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->b_type->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_b_type" data-value-separator="<?php echo $b_account_info_agent->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $b_account_info_agent->b_type->editAttributes() ?>>
		<?php echo $b_account_info_agent->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_b_type">
<span<?php echo $b_account_info_agent->b_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->b_type->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_b_type" name="x_b_type" id="x_b_type" value="<?php echo HtmlEncode($b_account_info_agent->b_type->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->b_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->account_type->Visible) { // account_type ?>
	<div id="r_account_type" class="form-group row">
		<label for="x_account_type" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_account_type" id="u_account_type" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->account_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_account_type" id="u_account_type" value="<?php echo $b_account_info_agent->account_type->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->account_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_account_type"><?php echo $b_account_info_agent->account_type->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->account_type->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_account_type">
<?php $b_account_info_agent->account_type->EditAttrs["onchange"] = "ew.autoFill(this);" . @$b_account_info_agent->account_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_account_type" data-value-separator="<?php echo $b_account_info_agent->account_type->displayValueSeparatorAttribute() ?>" id="x_account_type" name="x_account_type"<?php echo $b_account_info_agent->account_type->editAttributes() ?>>
		<?php echo $b_account_info_agent->account_type->selectOptionListHtml("x_account_type") ?>
	</select>
</div>
<?php echo $b_account_info_agent->account_type->Lookup->getParamTag("p_x_account_type") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_account_type">
<span<?php echo $b_account_info_agent->account_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->account_type->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_account_type" name="x_account_type" id="x_account_type" value="<?php echo HtmlEncode($b_account_info_agent->account_type->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->account_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->account_no->Visible) { // account_no ?>
	<div id="r_account_no" class="form-group row">
		<label for="x_account_no" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_account_no" id="u_account_no" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->account_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_account_no" id="u_account_no" value="<?php echo $b_account_info_agent->account_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->account_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_account_no"><?php echo $b_account_info_agent->account_no->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->account_no->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_account_no">
<input type="text" data-table="b_account_info_agent" data-field="x_account_no" name="x_account_no" id="x_account_no" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($b_account_info_agent->account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->account_no->EditValue ?>"<?php echo $b_account_info_agent->account_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_account_no">
<span<?php echo $b_account_info_agent->account_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->account_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_account_no" name="x_account_no" id="x_account_no" value="<?php echo HtmlEncode($b_account_info_agent->account_no->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u__email" id="u__email" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->_email->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u__email" id="u__email" value="<?php echo $b_account_info_agent->_email->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->_email->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u__email"><?php echo $b_account_info_agent->_email->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->_email->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent__email">
<input type="text" data-table="b_account_info_agent" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info_agent->_email->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->_email->EditValue ?>"<?php echo $b_account_info_agent->_email->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent__email">
<span<?php echo $b_account_info_agent->_email->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->_email->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x__email" name="x__email" id="x__email" value="<?php echo HtmlEncode($b_account_info_agent->_email->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_image" id="u_image" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_image" id="u_image" value="<?php echo $b_account_info_agent->image->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_image"><?php echo $b_account_info_agent->image->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->image->cellAttributes() ?>>
<span id="el_b_account_info_agent_image">
<div id="fd_x_image">
<span title="<?php echo $b_account_info_agent->image->title() ? $b_account_info_agent->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info_agent->image->ReadOnly || $b_account_info_agent->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info_agent" data-field="x_image" name="x_image" id="x_image"<?php echo $b_account_info_agent->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $b_account_info_agent->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $b_account_info_agent->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $b_account_info_agent->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info_agent->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_status" id="u_status" value="<?php echo $b_account_info_agent->status->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_status"><?php echo $b_account_info_agent->status->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->status->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_status">
<?php
$wrkonchange = "" . trim(@$b_account_info_agent->status->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$b_account_info_agent->status->EditAttrs["onchange"] = "";
?>
<span id="as_x_status" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_status" id="sv_x_status" value="<?php echo RemoveHtml($b_account_info_agent->status->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->status->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($b_account_info_agent->status->getPlaceHolder()) ?>"<?php echo $b_account_info_agent->status->editAttributes() ?>>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_status" data-value-separator="<?php echo $b_account_info_agent->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info_agent->status->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fb_account_info_agentupdate.createAutoSuggest({"id":"x_status","forceSelect":true});
</script>
<?php echo $b_account_info_agent->status->Lookup->getParamTag("p_x_status") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_status">
<span<?php echo $b_account_info_agent->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->status->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_status" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info_agent->status->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_id_proof" id="u_id_proof" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->id_proof->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_id_proof" id="u_id_proof" value="<?php echo $b_account_info_agent->id_proof->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->id_proof->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_id_proof"><?php echo $b_account_info_agent->id_proof->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->id_proof->cellAttributes() ?>>
<span id="el_b_account_info_agent_id_proof">
<div id="fd_x_id_proof">
<span title="<?php echo $b_account_info_agent->id_proof->title() ? $b_account_info_agent->id_proof->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info_agent->id_proof->ReadOnly || $b_account_info_agent->id_proof->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info_agent" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" multiple="multiple"<?php echo $b_account_info_agent->id_proof->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?php echo $b_account_info_agent->id_proof->Upload->FileName ?>">
<?php if (Post("fa_x_id_proof") == "0") { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="1">
<?php } ?>
<input type="hidden" name="fs_x_id_proof" id= "fs_x_id_proof" value="255">
<input type="hidden" name="fx_x_id_proof" id= "fx_x_id_proof" value="<?php echo $b_account_info_agent->id_proof->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_id_proof" id= "fm_x_id_proof" value="<?php echo $b_account_info_agent->id_proof->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_id_proof" id= "fc_x_id_proof" value="<?php echo $b_account_info_agent->id_proof->UploadMaxFileCount ?>">
</div>
<table id="ft_x_id_proof" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info_agent->id_proof->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label for="x_agent" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_agent" id="u_agent" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->agent->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_agent" id="u_agent" value="<?php echo $b_account_info_agent->agent->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->agent->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_agent"><?php echo $b_account_info_agent->agent->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->agent->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$b_account_info_agent->userIDAllow("update")) { // Non system admin ?>
<span id="el_b_account_info_agent_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_agent" data-value-separator="<?php echo $b_account_info_agent->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info_agent->agent->editAttributes() ?>>
		<?php echo $b_account_info_agent->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info_agent->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_agent" data-value-separator="<?php echo $b_account_info_agent->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info_agent->agent->editAttributes() ?>>
		<?php echo $b_account_info_agent->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info_agent->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el_b_account_info_agent_agent">
<span<?php echo $b_account_info_agent->agent->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->agent->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_agent" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($b_account_info_agent->agent->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label for="x_other_details" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_other_details" id="u_other_details" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->other_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_other_details" id="u_other_details" value="<?php echo $b_account_info_agent->other_details->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->other_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_other_details"><?php echo $b_account_info_agent->other_details->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->other_details->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_other_details">
<textarea data-table="b_account_info_agent" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($b_account_info_agent->other_details->getPlaceHolder()) ?>"<?php echo $b_account_info_agent->other_details->editAttributes() ?>><?php echo $b_account_info_agent->other_details->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_other_details">
<span<?php echo $b_account_info_agent->other_details->viewAttributes() ?>>
<?php echo $b_account_info_agent->other_details->ViewValue ?></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_other_details" name="x_other_details" id="x_other_details" value="<?php echo HtmlEncode($b_account_info_agent->other_details->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->loan_amount->Visible) { // loan_amount ?>
	<div id="r_loan_amount" class="form-group row">
		<label for="x_loan_amount" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_loan_amount" id="u_loan_amount" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->loan_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_loan_amount" id="u_loan_amount" value="<?php echo $b_account_info_agent->loan_amount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->loan_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_loan_amount"><?php echo $b_account_info_agent->loan_amount->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->loan_amount->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_loan_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->loan_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->loan_amount->EditValue ?>"<?php echo $b_account_info_agent->loan_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_loan_amount">
<span<?php echo $b_account_info_agent->loan_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->loan_amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" value="<?php echo HtmlEncode($b_account_info_agent->loan_amount->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->loan_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->int_40->Visible) { // int_@ ?>
	<div id="r_int_40" class="form-group row">
		<label for="x_int_40" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_int_40" id="u_int_40" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->int_40->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_int_40" id="u_int_40" value="<?php echo $b_account_info_agent->int_40->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->int_40->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_int_40"><?php echo $b_account_info_agent->int_40->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->int_40->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_int_40">
<input type="text" data-table="b_account_info_agent" data-field="x_int_40" name="x_int_40" id="x_int_40" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->int_40->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->int_40->EditValue ?>"<?php echo $b_account_info_agent->int_40->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_int_40">
<span<?php echo $b_account_info_agent->int_40->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->int_40->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_int_40" name="x_int_40" id="x_int_40" value="<?php echo HtmlEncode($b_account_info_agent->int_40->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->int_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->disbursement_amount->Visible) { // disbursement_amount ?>
	<div id="r_disbursement_amount" class="form-group row">
		<label for="x_disbursement_amount" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_disbursement_amount" id="u_disbursement_amount" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->disbursement_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_disbursement_amount" id="u_disbursement_amount" value="<?php echo $b_account_info_agent->disbursement_amount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->disbursement_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_disbursement_amount"><?php echo $b_account_info_agent->disbursement_amount->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->disbursement_amount->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_disbursement_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->disbursement_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->disbursement_amount->EditValue ?>"<?php echo $b_account_info_agent->disbursement_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_disbursement_amount">
<span<?php echo $b_account_info_agent->disbursement_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->disbursement_amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" value="<?php echo HtmlEncode($b_account_info_agent->disbursement_amount->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->disbursement_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->emi_amount->Visible) { // emi_amount ?>
	<div id="r_emi_amount" class="form-group row">
		<label for="x_emi_amount" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_emi_amount" id="u_emi_amount" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->emi_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_emi_amount" id="u_emi_amount" value="<?php echo $b_account_info_agent->emi_amount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->emi_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_emi_amount"><?php echo $b_account_info_agent->emi_amount->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->emi_amount->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_emi_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->emi_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->emi_amount->EditValue ?>"<?php echo $b_account_info_agent->emi_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_emi_amount">
<span<?php echo $b_account_info_agent->emi_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->emi_amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" value="<?php echo HtmlEncode($b_account_info_agent->emi_amount->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->emi_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label for="x_no_of_emi" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_no_of_emi" id="u_no_of_emi" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->no_of_emi->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_no_of_emi" id="u_no_of_emi" value="<?php echo $b_account_info_agent->no_of_emi->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->no_of_emi->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_no_of_emi"><?php echo $b_account_info_agent->no_of_emi->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->no_of_emi->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_no_of_emi">
<input type="text" data-table="b_account_info_agent" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->no_of_emi->EditValue ?>"<?php echo $b_account_info_agent->no_of_emi->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_no_of_emi">
<span<?php echo $b_account_info_agent->no_of_emi->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->no_of_emi->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" value="<?php echo HtmlEncode($b_account_info_agent->no_of_emi->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->no_of_emi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->frequency->Visible) { // frequency ?>
	<div id="r_frequency" class="form-group row">
		<label for="x_frequency" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_frequency" id="u_frequency" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->frequency->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_frequency" id="u_frequency" value="<?php echo $b_account_info_agent->frequency->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->frequency->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_frequency"><?php echo $b_account_info_agent->frequency->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->frequency->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<span id="el_b_account_info_agent_frequency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_frequency" data-value-separator="<?php echo $b_account_info_agent->frequency->displayValueSeparatorAttribute() ?>" id="x_frequency" name="x_frequency"<?php echo $b_account_info_agent->frequency->editAttributes() ?>>
		<?php echo $b_account_info_agent->frequency->selectOptionListHtml("x_frequency") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent_frequency">
<span<?php echo $b_account_info_agent->frequency->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->frequency->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_frequency" name="x_frequency" id="x_frequency" value="<?php echo HtmlEncode($b_account_info_agent->frequency->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->frequency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_operator" id="u_operator" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_operator" id="u_operator" value="<?php echo $b_account_info_agent->operator->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_operator"><?php echo $b_account_info_agent->operator->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->operator->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<?php } else { ?>
<span id="el_b_account_info_agent_operator">
<span<?php echo $b_account_info_agent->operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($b_account_info_agent->operator->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $b_account_info_agent_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<input type="checkbox" name="u_datetime" id="u_datetime" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info_agent->datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_datetime" id="u_datetime" value="<?php echo $b_account_info_agent->datetime->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info_agent->datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_datetime"><?php echo $b_account_info_agent->datetime->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_agent_update->RightColumnClass ?>"><div<?php echo $b_account_info_agent->datetime->cellAttributes() ?>>
<?php if (!$b_account_info_agent->isConfirm()) { ?>
<?php } else { ?>
<span id="el_b_account_info_agent_datetime">
<span<?php echo $b_account_info_agent->datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info_agent->datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($b_account_info_agent->datetime->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info_agent->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$b_account_info_agent_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $b_account_info_agent_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$b_account_info_agent->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $b_account_info_agent_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_info_agent_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_account_info_agent_update->terminate();
?>