<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_edit = new b_account_info_edit();

// Run the page
$b_account_info_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fb_account_infoedit = currentForm = new ew.Form("fb_account_infoedit", "edit");

// Validate form
fb_account_infoedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($b_account_info_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->id->caption(), $b_account_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->b_type->Required) { ?>
			elm = this.getElements("x" + infix + "_b_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->b_type->caption(), $b_account_info->b_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->grp->caption(), $b_account_info->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->branch->Required) { ?>
			elm = this.getElements("x" + infix + "_branch");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->branch->caption(), $b_account_info->branch->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->category->caption(), $b_account_info->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->account_type->Required) { ?>
			elm = this.getElements("x" + infix + "_account_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->account_type->caption(), $b_account_info->account_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_account_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->account_type->errorMessage()) ?>");
		<?php if ($b_account_info_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->type->caption(), $b_account_info->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->formal_name->caption(), $b_account_info->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->mobile->caption(), $b_account_info->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->mobile->errorMessage()) ?>");
		<?php if ($b_account_info_edit->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->_email->caption(), $b_account_info->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->_email->errorMessage()) ?>");
		<?php if ($b_account_info_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info->image->caption(), $b_account_info->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->sign_image->Required) { ?>
			felm = this.getElements("x" + infix + "_sign_image");
			elm = this.getElements("fn_x" + infix + "_sign_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info->sign_image->caption(), $b_account_info->sign_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->status->caption(), $b_account_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->status->errorMessage()) ?>");
		<?php if ($b_account_info_edit->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->aadhaar_no->caption(), $b_account_info->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->aadhaar_no->errorMessage()) ?>");
		<?php if ($b_account_info_edit->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->pan_no->caption(), $b_account_info->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->pan_no->errorMessage()) ?>");
		<?php if ($b_account_info_edit->id_proof->Required) { ?>
			felm = this.getElements("x" + infix + "_id_proof");
			elm = this.getElements("fn_x" + infix + "_id_proof");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info->id_proof->caption(), $b_account_info->id_proof->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->agent->Required) { ?>
			elm = this.getElements("x" + infix + "_agent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->agent->caption(), $b_account_info->agent->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->other_details->caption(), $b_account_info->other_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->bank_name->caption(), $b_account_info->bank_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->bank_ifsc_code->caption(), $b_account_info->bank_ifsc_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->bank_account_no->caption(), $b_account_info->bank_account_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_account_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->account_no->caption(), $b_account_info->account_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->loan_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->loan_amount->caption(), $b_account_info->loan_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->loan_amount->errorMessage()) ?>");
		<?php if ($b_account_info_edit->emi_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->emi_amount->caption(), $b_account_info->emi_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->emi_amount->errorMessage()) ?>");
		<?php if ($b_account_info_edit->frequency->Required) { ?>
			elm = this.getElements("x" + infix + "_frequency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->frequency->caption(), $b_account_info->frequency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->disbursement_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->disbursement_amount->caption(), $b_account_info->disbursement_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->disbursement_amount->errorMessage()) ?>");
		<?php if ($b_account_info_edit->d_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_d_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->d_operator->caption(), $b_account_info->d_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->d_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_d_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->d_datetime->caption(), $b_account_info->d_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->no_of_emi->Required) { ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->no_of_emi->caption(), $b_account_info->no_of_emi->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->no_of_emi->errorMessage()) ?>");
		<?php if ($b_account_info_edit->fund_o->Required) { ?>
			elm = this.getElements("x" + infix + "_fund_o");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->fund_o->caption(), $b_account_info->fund_o->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_fund_o");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->fund_o->errorMessage()) ?>");
		<?php if ($b_account_info_edit->fund_o_no->Required) { ?>
			elm = this.getElements("x" + infix + "_fund_o_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->fund_o_no->caption(), $b_account_info->fund_o_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_edit->int_40->Required) { ?>
			elm = this.getElements("x" + infix + "_int_40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->int_40->caption(), $b_account_info->int_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_int_40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->int_40->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fb_account_infoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_infoedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_infoedit.lists["x_b_type"] = <?php echo $b_account_info_edit->b_type->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_edit->b_type->options(FALSE, TRUE)) ?>;
fb_account_infoedit.lists["x_grp"] = <?php echo $b_account_info_edit->grp->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_edit->grp->lookupOptions()) ?>;
fb_account_infoedit.lists["x_branch"] = <?php echo $b_account_info_edit->branch->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_branch"].options = <?php echo JsonEncode($b_account_info_edit->branch->lookupOptions()) ?>;
fb_account_infoedit.lists["x_category"] = <?php echo $b_account_info_edit->category->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_category"].options = <?php echo JsonEncode($b_account_info_edit->category->options(FALSE, TRUE)) ?>;
fb_account_infoedit.lists["x_type"] = <?php echo $b_account_info_edit->type->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_type"].options = <?php echo JsonEncode($b_account_info_edit->type->lookupOptions()) ?>;
fb_account_infoedit.lists["x_status"] = <?php echo $b_account_info_edit->status->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_status"].options = <?php echo JsonEncode($b_account_info_edit->status->lookupOptions()) ?>;
fb_account_infoedit.autoSuggests["x_status"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_infoedit.lists["x_agent"] = <?php echo $b_account_info_edit->agent->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_agent"].options = <?php echo JsonEncode($b_account_info_edit->agent->lookupOptions()) ?>;
fb_account_infoedit.lists["x_frequency"] = <?php echo $b_account_info_edit->frequency->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_edit->frequency->options(FALSE, TRUE)) ?>;
fb_account_infoedit.lists["x_fund_o_no"] = <?php echo $b_account_info_edit->fund_o_no->Lookup->toClientList() ?>;
fb_account_infoedit.lists["x_fund_o_no"].options = <?php echo JsonEncode($b_account_info_edit->fund_o_no->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_info_edit->showPageHeader(); ?>
<?php
$b_account_info_edit->showMessage();
?>
<?php if (!$b_account_info_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_info_edit->Pager)) $b_account_info_edit->Pager = new PrevNextPager($b_account_info_edit->StartRec, $b_account_info_edit->DisplayRecs, $b_account_info_edit->TotalRecs, $b_account_info_edit->AutoHidePager) ?>
<?php if ($b_account_info_edit->Pager->RecordCount > 0 && $b_account_info_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_info_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_info_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_info_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_info_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_info_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_info_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fb_account_infoedit" id="fb_account_infoedit" class="<?php echo $b_account_info_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$b_account_info_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($b_account_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_b_account_info_id" for="x_id" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->id->caption() ?><?php echo ($b_account_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->id->cellAttributes() ?>>
<span id="el_b_account_info_id">
<span<?php echo $b_account_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($b_account_info->id->CurrentValue) ?>">
<?php echo $b_account_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label id="elh_b_account_info_b_type" for="x_b_type" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->b_type->caption() ?><?php echo ($b_account_info->b_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->b_type->cellAttributes() ?>>
<span id="el_b_account_info_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_b_type" data-value-separator="<?php echo $b_account_info->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $b_account_info->b_type->editAttributes() ?>>
		<?php echo $b_account_info->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
<?php echo $b_account_info->b_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_b_account_info_grp" for="x_grp" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->grp->caption() ?><?php echo ($b_account_info->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->grp->cellAttributes() ?>>
<span id="el_b_account_info_grp">
<span<?php echo $b_account_info->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($b_account_info->grp->CurrentValue) ?>">
<?php echo $b_account_info->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->branch->Visible) { // branch ?>
	<div id="r_branch" class="form-group row">
		<label id="elh_b_account_info_branch" for="x_branch" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->branch->caption() ?><?php echo ($b_account_info->branch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->branch->cellAttributes() ?>>
<span id="el_b_account_info_branch">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_branch" data-value-separator="<?php echo $b_account_info->branch->displayValueSeparatorAttribute() ?>" id="x_branch" name="x_branch"<?php echo $b_account_info->branch->editAttributes() ?>>
		<?php echo $b_account_info->branch->selectOptionListHtml("x_branch") ?>
	</select>
</div>
<?php echo $b_account_info->branch->Lookup->getParamTag("p_x_branch") ?>
</span>
<?php echo $b_account_info->branch->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_b_account_info_category" for="x_category" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->category->caption() ?><?php echo ($b_account_info->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->category->cellAttributes() ?>>
<span id="el_b_account_info_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_category" data-value-separator="<?php echo $b_account_info->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $b_account_info->category->editAttributes() ?>>
		<?php echo $b_account_info->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
</span>
<?php echo $b_account_info->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->account_type->Visible) { // account_type ?>
	<div id="r_account_type" class="form-group row">
		<label id="elh_b_account_info_account_type" for="x_account_type" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->account_type->caption() ?><?php echo ($b_account_info->account_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->account_type->cellAttributes() ?>>
<span id="el_b_account_info_account_type">
<input type="text" data-table="b_account_info" data-field="x_account_type" name="x_account_type" id="x_account_type" size="30" placeholder="<?php echo HtmlEncode($b_account_info->account_type->getPlaceHolder()) ?>" value="<?php echo $b_account_info->account_type->EditValue ?>"<?php echo $b_account_info->account_type->editAttributes() ?>>
</span>
<?php echo $b_account_info->account_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_b_account_info_type" for="x_type" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->type->caption() ?><?php echo ($b_account_info->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->type->cellAttributes() ?>>
<span id="el_b_account_info_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_type" data-value-separator="<?php echo $b_account_info->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $b_account_info->type->editAttributes() ?>>
		<?php echo $b_account_info->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $b_account_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
<?php echo $b_account_info->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_b_account_info_formal_name" for="x_formal_name" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->formal_name->caption() ?><?php echo ($b_account_info->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->formal_name->cellAttributes() ?>>
<span id="el_b_account_info_formal_name">
<input type="text" data-table="b_account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info->formal_name->EditValue ?>"<?php echo $b_account_info->formal_name->editAttributes() ?>>
</span>
<?php echo $b_account_info->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_b_account_info_mobile" for="x_mobile" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->mobile->caption() ?><?php echo ($b_account_info->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->mobile->cellAttributes() ?>>
<span id="el_b_account_info_mobile">
<input type="text" data-table="b_account_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info->mobile->getPlaceHolder()) ?>" value="<?php echo $b_account_info->mobile->EditValue ?>"<?php echo $b_account_info->mobile->editAttributes() ?>>
</span>
<?php echo $b_account_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_b_account_info__email" for="x__email" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->_email->caption() ?><?php echo ($b_account_info->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->_email->cellAttributes() ?>>
<span id="el_b_account_info__email">
<input type="text" data-table="b_account_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info->_email->getPlaceHolder()) ?>" value="<?php echo $b_account_info->_email->EditValue ?>"<?php echo $b_account_info->_email->editAttributes() ?>>
</span>
<?php echo $b_account_info->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_b_account_info_image" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->image->caption() ?><?php echo ($b_account_info->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->image->cellAttributes() ?>>
<span id="el_b_account_info_image">
<div id="fd_x_image">
<span title="<?php echo $b_account_info->image->title() ? $b_account_info->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info->image->ReadOnly || $b_account_info->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info" data-field="x_image" name="x_image" id="x_image"<?php echo $b_account_info->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $b_account_info->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $b_account_info->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $b_account_info->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->sign_image->Visible) { // sign_image ?>
	<div id="r_sign_image" class="form-group row">
		<label id="elh_b_account_info_sign_image" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->sign_image->caption() ?><?php echo ($b_account_info->sign_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->sign_image->cellAttributes() ?>>
<span id="el_b_account_info_sign_image">
<div id="fd_x_sign_image">
<span title="<?php echo $b_account_info->sign_image->title() ? $b_account_info->sign_image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info->sign_image->ReadOnly || $b_account_info->sign_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info" data-field="x_sign_image" name="x_sign_image" id="x_sign_image" multiple="multiple"<?php echo $b_account_info->sign_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_sign_image" id= "fn_x_sign_image" value="<?php echo $b_account_info->sign_image->Upload->FileName ?>">
<?php if (Post("fa_x_sign_image") == "0") { ?>
<input type="hidden" name="fa_x_sign_image" id= "fa_x_sign_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_sign_image" id= "fa_x_sign_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_sign_image" id= "fs_x_sign_image" value="255">
<input type="hidden" name="fx_x_sign_image" id= "fx_x_sign_image" value="<?php echo $b_account_info->sign_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_sign_image" id= "fm_x_sign_image" value="<?php echo $b_account_info->sign_image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_sign_image" id= "fc_x_sign_image" value="<?php echo $b_account_info->sign_image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_sign_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info->sign_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_b_account_info_status" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->status->caption() ?><?php echo ($b_account_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->status->cellAttributes() ?>>
<span id="el_b_account_info_status">
<?php
$wrkonchange = "" . trim(@$b_account_info->status->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$b_account_info->status->EditAttrs["onchange"] = "";
?>
<span id="as_x_status" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_status" id="sv_x_status" value="<?php echo RemoveHtml($b_account_info->status->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($b_account_info->status->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($b_account_info->status->getPlaceHolder()) ?>"<?php echo $b_account_info->status->editAttributes() ?>>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_status" data-value-separator="<?php echo $b_account_info->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info->status->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fb_account_infoedit.createAutoSuggest({"id":"x_status","forceSelect":true});
</script>
<?php echo $b_account_info->status->Lookup->getParamTag("p_x_status") ?>
</span>
<?php echo $b_account_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label id="elh_b_account_info_aadhaar_no" for="x_aadhaar_no" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->aadhaar_no->caption() ?><?php echo ($b_account_info->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->aadhaar_no->cellAttributes() ?>>
<span id="el_b_account_info_aadhaar_no">
<input type="text" data-table="b_account_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($b_account_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->aadhaar_no->EditValue ?>"<?php echo $b_account_info->aadhaar_no->editAttributes() ?>>
</span>
<?php echo $b_account_info->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label id="elh_b_account_info_pan_no" for="x_pan_no" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->pan_no->caption() ?><?php echo ($b_account_info->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->pan_no->cellAttributes() ?>>
<span id="el_b_account_info_pan_no">
<input type="text" data-table="b_account_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->pan_no->EditValue ?>"<?php echo $b_account_info->pan_no->editAttributes() ?>>
</span>
<?php echo $b_account_info->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label id="elh_b_account_info_id_proof" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->id_proof->caption() ?><?php echo ($b_account_info->id_proof->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->id_proof->cellAttributes() ?>>
<span id="el_b_account_info_id_proof">
<div id="fd_x_id_proof">
<span title="<?php echo $b_account_info->id_proof->title() ? $b_account_info->id_proof->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info->id_proof->ReadOnly || $b_account_info->id_proof->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" multiple="multiple"<?php echo $b_account_info->id_proof->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?php echo $b_account_info->id_proof->Upload->FileName ?>">
<?php if (Post("fa_x_id_proof") == "0") { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="1">
<?php } ?>
<input type="hidden" name="fs_x_id_proof" id= "fs_x_id_proof" value="255">
<input type="hidden" name="fx_x_id_proof" id= "fx_x_id_proof" value="<?php echo $b_account_info->id_proof->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_id_proof" id= "fm_x_id_proof" value="<?php echo $b_account_info->id_proof->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_id_proof" id= "fc_x_id_proof" value="<?php echo $b_account_info->id_proof->UploadMaxFileCount ?>">
</div>
<table id="ft_x_id_proof" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info->id_proof->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label id="elh_b_account_info_agent" for="x_agent" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->agent->caption() ?><?php echo ($b_account_info->agent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->agent->cellAttributes() ?>>
<span id="el_b_account_info_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_agent" data-value-separator="<?php echo $b_account_info->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info->agent->editAttributes() ?>>
		<?php echo $b_account_info->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php echo $b_account_info->agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label id="elh_b_account_info_other_details" for="x_other_details" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->other_details->caption() ?><?php echo ($b_account_info->other_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->other_details->cellAttributes() ?>>
<span id="el_b_account_info_other_details">
<input type="text" data-table="b_account_info" data-field="x_other_details" name="x_other_details" id="x_other_details" placeholder="<?php echo HtmlEncode($b_account_info->other_details->getPlaceHolder()) ?>" value="<?php echo $b_account_info->other_details->EditValue ?>"<?php echo $b_account_info->other_details->editAttributes() ?>>
</span>
<?php echo $b_account_info->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label id="elh_b_account_info_bank_name" for="x_bank_name" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->bank_name->caption() ?><?php echo ($b_account_info->bank_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->bank_name->cellAttributes() ?>>
<span id="el_b_account_info_bank_name">
<input type="text" data-table="b_account_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($b_account_info->bank_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_name->EditValue ?>"<?php echo $b_account_info->bank_name->editAttributes() ?>>
</span>
<?php echo $b_account_info->bank_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label id="elh_b_account_info_bank_ifsc_code" for="x_bank_ifsc_code" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->bank_ifsc_code->caption() ?><?php echo ($b_account_info->bank_ifsc_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->bank_ifsc_code->cellAttributes() ?>>
<span id="el_b_account_info_bank_ifsc_code">
<input type="text" data-table="b_account_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($b_account_info->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_ifsc_code->EditValue ?>"<?php echo $b_account_info->bank_ifsc_code->editAttributes() ?>>
</span>
<?php echo $b_account_info->bank_ifsc_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label id="elh_b_account_info_bank_account_no" for="x_bank_account_no" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->bank_account_no->caption() ?><?php echo ($b_account_info->bank_account_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->bank_account_no->cellAttributes() ?>>
<span id="el_b_account_info_bank_account_no">
<input type="text" data-table="b_account_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($b_account_info->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_account_no->EditValue ?>"<?php echo $b_account_info->bank_account_no->editAttributes() ?>>
</span>
<?php echo $b_account_info->bank_account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->account_no->Visible) { // account_no ?>
	<div id="r_account_no" class="form-group row">
		<label id="elh_b_account_info_account_no" for="x_account_no" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->account_no->caption() ?><?php echo ($b_account_info->account_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->account_no->cellAttributes() ?>>
<span id="el_b_account_info_account_no">
<span<?php echo $b_account_info->account_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->account_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_account_no" name="x_account_no" id="x_account_no" value="<?php echo HtmlEncode($b_account_info->account_no->CurrentValue) ?>">
<?php echo $b_account_info->account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->loan_amount->Visible) { // loan_amount ?>
	<div id="r_loan_amount" class="form-group row">
		<label id="elh_b_account_info_loan_amount" for="x_loan_amount" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->loan_amount->caption() ?><?php echo ($b_account_info->loan_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->loan_amount->cellAttributes() ?>>
<span id="el_b_account_info_loan_amount">
<input type="text" data-table="b_account_info" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->loan_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->loan_amount->EditValue ?>"<?php echo $b_account_info->loan_amount->editAttributes() ?>>
</span>
<?php echo $b_account_info->loan_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->emi_amount->Visible) { // emi_amount ?>
	<div id="r_emi_amount" class="form-group row">
		<label id="elh_b_account_info_emi_amount" for="x_emi_amount" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->emi_amount->caption() ?><?php echo ($b_account_info->emi_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->emi_amount->cellAttributes() ?>>
<span id="el_b_account_info_emi_amount">
<input type="text" data-table="b_account_info" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->emi_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->emi_amount->EditValue ?>"<?php echo $b_account_info->emi_amount->editAttributes() ?>>
</span>
<?php echo $b_account_info->emi_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->frequency->Visible) { // frequency ?>
	<div id="r_frequency" class="form-group row">
		<label id="elh_b_account_info_frequency" for="x_frequency" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->frequency->caption() ?><?php echo ($b_account_info->frequency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->frequency->cellAttributes() ?>>
<span id="el_b_account_info_frequency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_frequency" data-value-separator="<?php echo $b_account_info->frequency->displayValueSeparatorAttribute() ?>" id="x_frequency" name="x_frequency"<?php echo $b_account_info->frequency->editAttributes() ?>>
		<?php echo $b_account_info->frequency->selectOptionListHtml("x_frequency") ?>
	</select>
</div>
</span>
<?php echo $b_account_info->frequency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->disbursement_amount->Visible) { // disbursement_amount ?>
	<div id="r_disbursement_amount" class="form-group row">
		<label id="elh_b_account_info_disbursement_amount" for="x_disbursement_amount" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->disbursement_amount->caption() ?><?php echo ($b_account_info->disbursement_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->disbursement_amount->cellAttributes() ?>>
<span id="el_b_account_info_disbursement_amount">
<input type="text" data-table="b_account_info" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->disbursement_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->disbursement_amount->EditValue ?>"<?php echo $b_account_info->disbursement_amount->editAttributes() ?>>
</span>
<?php echo $b_account_info->disbursement_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label id="elh_b_account_info_no_of_emi" for="x_no_of_emi" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->no_of_emi->caption() ?><?php echo ($b_account_info->no_of_emi->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->no_of_emi->cellAttributes() ?>>
<span id="el_b_account_info_no_of_emi">
<input type="text" data-table="b_account_info" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_info->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_info->no_of_emi->EditValue ?>"<?php echo $b_account_info->no_of_emi->editAttributes() ?>>
</span>
<?php echo $b_account_info->no_of_emi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->fund_o->Visible) { // fund_o ?>
	<div id="r_fund_o" class="form-group row">
		<label id="elh_b_account_info_fund_o" for="x_fund_o" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->fund_o->caption() ?><?php echo ($b_account_info->fund_o->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->fund_o->cellAttributes() ?>>
<span id="el_b_account_info_fund_o">
<input type="text" data-table="b_account_info" data-field="x_fund_o" name="x_fund_o" id="x_fund_o" size="30" placeholder="<?php echo HtmlEncode($b_account_info->fund_o->getPlaceHolder()) ?>" value="<?php echo $b_account_info->fund_o->EditValue ?>"<?php echo $b_account_info->fund_o->editAttributes() ?>>
</span>
<?php echo $b_account_info->fund_o->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->fund_o_no->Visible) { // fund_o_no ?>
	<div id="r_fund_o_no" class="form-group row">
		<label id="elh_b_account_info_fund_o_no" for="x_fund_o_no" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->fund_o_no->caption() ?><?php echo ($b_account_info->fund_o_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->fund_o_no->cellAttributes() ?>>
<span id="el_b_account_info_fund_o_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_fund_o_no" data-value-separator="<?php echo $b_account_info->fund_o_no->displayValueSeparatorAttribute() ?>" id="x_fund_o_no" name="x_fund_o_no"<?php echo $b_account_info->fund_o_no->editAttributes() ?>>
		<?php echo $b_account_info->fund_o_no->selectOptionListHtml("x_fund_o_no") ?>
	</select>
</div>
<?php echo $b_account_info->fund_o_no->Lookup->getParamTag("p_x_fund_o_no") ?>
</span>
<?php echo $b_account_info->fund_o_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->int_40->Visible) { // int_@ ?>
	<div id="r_int_40" class="form-group row">
		<label id="elh_b_account_info_int_40" for="x_int_40" class="<?php echo $b_account_info_edit->LeftColumnClass ?>"><?php echo $b_account_info->int_40->caption() ?><?php echo ($b_account_info->int_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_edit->RightColumnClass ?>"><div<?php echo $b_account_info->int_40->cellAttributes() ?>>
<span id="el_b_account_info_int_40">
<input type="text" data-table="b_account_info" data-field="x_int_40" name="x_int_40" id="x_int_40" size="30" placeholder="<?php echo HtmlEncode($b_account_info->int_40->getPlaceHolder()) ?>" value="<?php echo $b_account_info->int_40->EditValue ?>"<?php echo $b_account_info->int_40->editAttributes() ?>>
</span>
<?php echo $b_account_info->int_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_account_info_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_account_info_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $b_account_info_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$b_account_info_edit->IsModal) { ?>
<?php if (!isset($b_account_info_edit->Pager)) $b_account_info_edit->Pager = new PrevNextPager($b_account_info_edit->StartRec, $b_account_info_edit->DisplayRecs, $b_account_info_edit->TotalRecs, $b_account_info_edit->AutoHidePager) ?>
<?php if ($b_account_info_edit->Pager->RecordCount > 0 && $b_account_info_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_info_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_info_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_info_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_info_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_info_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_info_edit->pageUrl() ?>start=<?php echo $b_account_info_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_info_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$b_account_info_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");\

$('#x_aadhaar_no').attr('type', 'number');
$('#x_mobile').attr('type', 'number');
$('#x_otp').attr('type', 'number');
$('#x_no_of_emi').attr('type', 'number');
		var grp = $("#x_grp").val();
		if (grp == 130101)
		{
			$("#r_loan_amount").show();
			$("#r_emi_amount").show();
			$("#r_disbursement_amount").show();
			$("#r_frequency").show();
			$("#r_fund_o").hide();
			$("#r_fund_o_no").hide();
			$("#r_no_of_emi").hide();
		}
		else if (grp == 130102)
		{
			$("#r_loan_amount").show();
			$("#r_emi_amount").show();
			$("#r_disbursement_amount").show();
			$("#r_frequency").show();
			$("#r_fund_o").show();
			$("#r_fund_o_no").show();
			$("#r_no_of_emi").show();
		}
		else if (grp == 230401)
		{
			$("#r_loan_amount").hide();
			$("#r_emi_amount").hide();
			$("#r_disbursement_amount").hide();
			$("#r_frequency").hide();
			$("#r_fund_o").hide();
			$("#r_fund_o_no").hide();
			$("#r_no_of_emi").hide();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$b_account_info_edit->terminate();
?>