<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_list = new b_account_info_list();

// Run the page
$b_account_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$b_account_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fb_account_infolist = currentForm = new ew.Form("fb_account_infolist", "list");
fb_account_infolist.formKeyCountName = '<?php echo $b_account_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
fb_account_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_infolist.lists["x_b_type"] = <?php echo $b_account_info_list->b_type->Lookup->toClientList() ?>;
fb_account_infolist.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_list->b_type->options(FALSE, TRUE)) ?>;
fb_account_infolist.lists["x_grp"] = <?php echo $b_account_info_list->grp->Lookup->toClientList() ?>;
fb_account_infolist.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_list->grp->lookupOptions()) ?>;
fb_account_infolist.lists["x_branch"] = <?php echo $b_account_info_list->branch->Lookup->toClientList() ?>;
fb_account_infolist.lists["x_branch"].options = <?php echo JsonEncode($b_account_info_list->branch->lookupOptions()) ?>;
fb_account_infolist.lists["x_type"] = <?php echo $b_account_info_list->type->Lookup->toClientList() ?>;
fb_account_infolist.lists["x_type"].options = <?php echo JsonEncode($b_account_info_list->type->lookupOptions()) ?>;
fb_account_infolist.lists["x_agent"] = <?php echo $b_account_info_list->agent->Lookup->toClientList() ?>;
fb_account_infolist.lists["x_agent"].options = <?php echo JsonEncode($b_account_info_list->agent->lookupOptions()) ?>;
fb_account_infolist.lists["x_frequency"] = <?php echo $b_account_info_list->frequency->Lookup->toClientList() ?>;
fb_account_infolist.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_list->frequency->options(FALSE, TRUE)) ?>;
fb_account_infolist.lists["x_fund_o_no"] = <?php echo $b_account_info_list->fund_o_no->Lookup->toClientList() ?>;
fb_account_infolist.lists["x_fund_o_no"].options = <?php echo JsonEncode($b_account_info_list->fund_o_no->lookupOptions()) ?>;

// Form object for search
var fb_account_infolistsrch = currentSearchForm = new ew.Form("fb_account_infolistsrch");

// Validate function for search
fb_account_infolistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fb_account_infolistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_infolistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_infolistsrch.lists["x_agent"] = <?php echo $b_account_info_list->agent->Lookup->toClientList() ?>;
fb_account_infolistsrch.lists["x_agent"].options = <?php echo JsonEncode($b_account_info_list->agent->lookupOptions()) ?>;

// Filters
fb_account_infolistsrch.filterList = <?php echo $b_account_info_list->getFilterList() ?>;

// Init search panel as collapsed
fb_account_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$b_account_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($b_account_info_list->TotalRecs > 0 && $b_account_info_list->ExportOptions->visible()) { ?>
<?php $b_account_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_info_list->ImportOptions->visible()) { ?>
<?php $b_account_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_info_list->SearchOptions->visible()) { ?>
<?php $b_account_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_info_list->FilterOptions->visible()) { ?>
<?php $b_account_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$b_account_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$b_account_info->isExport() && !$b_account_info->CurrentAction) { ?>
<form name="fb_account_infolistsrch" id="fb_account_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($b_account_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fb_account_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="b_account_info">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$b_account_info_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$b_account_info->RowType = ROWTYPE_SEARCH;

// Render row
$b_account_info->resetAttributes();
$b_account_info_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($b_account_info->formal_name->Visible) { // formal_name ?>
	<div id="xsc_formal_name" class="ew-cell form-group">
		<label for="x_formal_name" class="ew-search-caption ew-label"><?php echo $b_account_info->formal_name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="b_account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info->formal_name->EditValue ?>"<?php echo $b_account_info->formal_name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($b_account_info->agent->Visible) { // agent ?>
	<div id="xsc_agent" class="ew-cell form-group">
		<label for="x_agent" class="ew-search-caption ew-label"><?php echo $b_account_info->agent->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_agent" id="z_agent" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_agent" data-value-separator="<?php echo $b_account_info->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info->agent->editAttributes() ?>>
		<?php echo $b_account_info->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
	</div>
<?php } ?>
<?php if ($b_account_info->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $b_account_info->datetime->caption() ?></label>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="b_account_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($b_account_info->datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info->datetime->EditValue ?>"<?php echo $b_account_info->datetime->editAttributes() ?>>
<?php if (!$b_account_info->datetime->ReadOnly && !$b_account_info->datetime->Disabled && !isset($b_account_info->datetime->EditAttrs["readonly"]) && !isset($b_account_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_infolistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_datetime style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_datetime style="d-none"">
<input type="text" data-table="b_account_info" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($b_account_info->datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info->datetime->EditValue2 ?>"<?php echo $b_account_info->datetime->editAttributes() ?>>
<?php if (!$b_account_info->datetime->ReadOnly && !$b_account_info->datetime->Disabled && !isset($b_account_info->datetime->EditAttrs["readonly"]) && !isset($b_account_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_infolistsrch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($b_account_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($b_account_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $b_account_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($b_account_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($b_account_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($b_account_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($b_account_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $b_account_info_list->showPageHeader(); ?>
<?php
$b_account_info_list->showMessage();
?>
<?php if ($b_account_info_list->TotalRecs > 0 || $b_account_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($b_account_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> b_account_info">
<?php if (!$b_account_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$b_account_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_info_list->Pager)) $b_account_info_list->Pager = new PrevNextPager($b_account_info_list->StartRec, $b_account_info_list->DisplayRecs, $b_account_info_list->TotalRecs, $b_account_info_list->AutoHidePager) ?>
<?php if ($b_account_info_list->Pager->RecordCount > 0 && $b_account_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_info_list->TotalRecs > 0 && (!$b_account_info_list->AutoHidePageSizeSelector || $b_account_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($b_account_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($b_account_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fb_account_infolist" id="fb_account_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_b_account_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($b_account_info_list->TotalRecs > 0 || $b_account_info->isGridEdit()) { ?>
<table id="tbl_b_account_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$b_account_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$b_account_info_list->renderListOptions();

// Render list options (header, left)
$b_account_info_list->ListOptions->render("header", "left");
?>
<?php if ($b_account_info->id->Visible) { // id ?>
	<?php if ($b_account_info->sortUrl($b_account_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $b_account_info->id->headerCellClass() ?>"><div id="elh_b_account_info_id" class="b_account_info_id"><div class="ew-table-header-caption"><?php echo $b_account_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $b_account_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->id) ?>',1);"><div id="elh_b_account_info_id" class="b_account_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->b_type->Visible) { // b_type ?>
	<?php if ($b_account_info->sortUrl($b_account_info->b_type) == "") { ?>
		<th data-name="b_type" class="<?php echo $b_account_info->b_type->headerCellClass() ?>"><div id="elh_b_account_info_b_type" class="b_account_info_b_type"><div class="ew-table-header-caption"><?php echo $b_account_info->b_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_type" class="<?php echo $b_account_info->b_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->b_type) ?>',1);"><div id="elh_b_account_info_b_type" class="b_account_info_b_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->b_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->b_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->b_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->grp->Visible) { // grp ?>
	<?php if ($b_account_info->sortUrl($b_account_info->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $b_account_info->grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_grp" class="b_account_info_grp"><div class="ew-table-header-caption"><?php echo $b_account_info->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $b_account_info->grp->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->grp) ?>',1);"><div id="elh_b_account_info_grp" class="b_account_info_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->branch->Visible) { // branch ?>
	<?php if ($b_account_info->sortUrl($b_account_info->branch) == "") { ?>
		<th data-name="branch" class="<?php echo $b_account_info->branch->headerCellClass() ?>"><div id="elh_b_account_info_branch" class="b_account_info_branch"><div class="ew-table-header-caption"><?php echo $b_account_info->branch->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="branch" class="<?php echo $b_account_info->branch->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->branch) ?>',1);"><div id="elh_b_account_info_branch" class="b_account_info_branch">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->branch->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->branch->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->branch->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->account_type->Visible) { // account_type ?>
	<?php if ($b_account_info->sortUrl($b_account_info->account_type) == "") { ?>
		<th data-name="account_type" class="<?php echo $b_account_info->account_type->headerCellClass() ?>"><div id="elh_b_account_info_account_type" class="b_account_info_account_type"><div class="ew-table-header-caption"><?php echo $b_account_info->account_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_type" class="<?php echo $b_account_info->account_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->account_type) ?>',1);"><div id="elh_b_account_info_account_type" class="b_account_info_account_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->account_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->account_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->account_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->type->Visible) { // type ?>
	<?php if ($b_account_info->sortUrl($b_account_info->type) == "") { ?>
		<th data-name="type" class="<?php echo $b_account_info->type->headerCellClass() ?>"><div id="elh_b_account_info_type" class="b_account_info_type"><div class="ew-table-header-caption"><?php echo $b_account_info->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $b_account_info->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->type) ?>',1);"><div id="elh_b_account_info_type" class="b_account_info_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->formal_name->Visible) { // formal_name ?>
	<?php if ($b_account_info->sortUrl($b_account_info->formal_name) == "") { ?>
		<th data-name="formal_name" class="<?php echo $b_account_info->formal_name->headerCellClass() ?>"><div id="elh_b_account_info_formal_name" class="b_account_info_formal_name"><div class="ew-table-header-caption"><?php echo $b_account_info->formal_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="formal_name" class="<?php echo $b_account_info->formal_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->formal_name) ?>',1);"><div id="elh_b_account_info_formal_name" class="b_account_info_formal_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->formal_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->formal_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->formal_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->mobile->Visible) { // mobile ?>
	<?php if ($b_account_info->sortUrl($b_account_info->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $b_account_info->mobile->headerCellClass() ?>"><div id="elh_b_account_info_mobile" class="b_account_info_mobile"><div class="ew-table-header-caption"><?php echo $b_account_info->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $b_account_info->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->mobile) ?>',1);"><div id="elh_b_account_info_mobile" class="b_account_info_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->agent->Visible) { // agent ?>
	<?php if ($b_account_info->sortUrl($b_account_info->agent) == "") { ?>
		<th data-name="agent" class="<?php echo $b_account_info->agent->headerCellClass() ?>"><div id="elh_b_account_info_agent" class="b_account_info_agent"><div class="ew-table-header-caption"><?php echo $b_account_info->agent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="agent" class="<?php echo $b_account_info->agent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->agent) ?>',1);"><div id="elh_b_account_info_agent" class="b_account_info_agent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->agent->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->agent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->agent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->account_no->Visible) { // account_no ?>
	<?php if ($b_account_info->sortUrl($b_account_info->account_no) == "") { ?>
		<th data-name="account_no" class="<?php echo $b_account_info->account_no->headerCellClass() ?>"><div id="elh_b_account_info_account_no" class="b_account_info_account_no"><div class="ew-table-header-caption"><?php echo $b_account_info->account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_no" class="<?php echo $b_account_info->account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->account_no) ?>',1);"><div id="elh_b_account_info_account_no" class="b_account_info_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->account_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->loan_amount->Visible) { // loan_amount ?>
	<?php if ($b_account_info->sortUrl($b_account_info->loan_amount) == "") { ?>
		<th data-name="loan_amount" class="<?php echo $b_account_info->loan_amount->headerCellClass() ?>"><div id="elh_b_account_info_loan_amount" class="b_account_info_loan_amount"><div class="ew-table-header-caption"><?php echo $b_account_info->loan_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="loan_amount" class="<?php echo $b_account_info->loan_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->loan_amount) ?>',1);"><div id="elh_b_account_info_loan_amount" class="b_account_info_loan_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->loan_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->loan_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->loan_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->emi_amount->Visible) { // emi_amount ?>
	<?php if ($b_account_info->sortUrl($b_account_info->emi_amount) == "") { ?>
		<th data-name="emi_amount" class="<?php echo $b_account_info->emi_amount->headerCellClass() ?>"><div id="elh_b_account_info_emi_amount" class="b_account_info_emi_amount"><div class="ew-table-header-caption"><?php echo $b_account_info->emi_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emi_amount" class="<?php echo $b_account_info->emi_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->emi_amount) ?>',1);"><div id="elh_b_account_info_emi_amount" class="b_account_info_emi_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->emi_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->emi_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->emi_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->frequency->Visible) { // frequency ?>
	<?php if ($b_account_info->sortUrl($b_account_info->frequency) == "") { ?>
		<th data-name="frequency" class="<?php echo $b_account_info->frequency->headerCellClass() ?>"><div id="elh_b_account_info_frequency" class="b_account_info_frequency"><div class="ew-table-header-caption"><?php echo $b_account_info->frequency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="frequency" class="<?php echo $b_account_info->frequency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->frequency) ?>',1);"><div id="elh_b_account_info_frequency" class="b_account_info_frequency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->frequency->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->frequency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->frequency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->disbursement_amount->Visible) { // disbursement_amount ?>
	<?php if ($b_account_info->sortUrl($b_account_info->disbursement_amount) == "") { ?>
		<th data-name="disbursement_amount" class="<?php echo $b_account_info->disbursement_amount->headerCellClass() ?>"><div id="elh_b_account_info_disbursement_amount" class="b_account_info_disbursement_amount"><div class="ew-table-header-caption"><?php echo $b_account_info->disbursement_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="disbursement_amount" class="<?php echo $b_account_info->disbursement_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->disbursement_amount) ?>',1);"><div id="elh_b_account_info_disbursement_amount" class="b_account_info_disbursement_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->disbursement_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->disbursement_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->disbursement_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->datetime->Visible) { // datetime ?>
	<?php if ($b_account_info->sortUrl($b_account_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $b_account_info->datetime->headerCellClass() ?>"><div id="elh_b_account_info_datetime" class="b_account_info_datetime"><div class="ew-table-header-caption"><?php echo $b_account_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $b_account_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->datetime) ?>',1);"><div id="elh_b_account_info_datetime" class="b_account_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
	<?php if ($b_account_info->sortUrl($b_account_info->otp_delivery_datetime) == "") { ?>
		<th data-name="otp_delivery_datetime" class="<?php echo $b_account_info->otp_delivery_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_otp_delivery_datetime" class="b_account_info_otp_delivery_datetime"><div class="ew-table-header-caption"><?php echo $b_account_info->otp_delivery_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="otp_delivery_datetime" class="<?php echo $b_account_info->otp_delivery_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->otp_delivery_datetime) ?>',1);"><div id="elh_b_account_info_otp_delivery_datetime" class="b_account_info_otp_delivery_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->otp_delivery_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->otp_delivery_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->otp_delivery_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
	<?php if ($b_account_info->sortUrl($b_account_info->otp_verify_datetime) == "") { ?>
		<th data-name="otp_verify_datetime" class="<?php echo $b_account_info->otp_verify_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_otp_verify_datetime" class="b_account_info_otp_verify_datetime"><div class="ew-table-header-caption"><?php echo $b_account_info->otp_verify_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="otp_verify_datetime" class="<?php echo $b_account_info->otp_verify_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->otp_verify_datetime) ?>',1);"><div id="elh_b_account_info_otp_verify_datetime" class="b_account_info_otp_verify_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->otp_verify_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->otp_verify_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->otp_verify_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->no_of_emi->Visible) { // no_of_emi ?>
	<?php if ($b_account_info->sortUrl($b_account_info->no_of_emi) == "") { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_info->no_of_emi->headerCellClass() ?>"><div id="elh_b_account_info_no_of_emi" class="b_account_info_no_of_emi"><div class="ew-table-header-caption"><?php echo $b_account_info->no_of_emi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_info->no_of_emi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->no_of_emi) ?>',1);"><div id="elh_b_account_info_no_of_emi" class="b_account_info_no_of_emi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->no_of_emi->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->no_of_emi->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->no_of_emi->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->fund_o->Visible) { // fund_o ?>
	<?php if ($b_account_info->sortUrl($b_account_info->fund_o) == "") { ?>
		<th data-name="fund_o" class="<?php echo $b_account_info->fund_o->headerCellClass() ?>"><div id="elh_b_account_info_fund_o" class="b_account_info_fund_o"><div class="ew-table-header-caption"><?php echo $b_account_info->fund_o->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fund_o" class="<?php echo $b_account_info->fund_o->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->fund_o) ?>',1);"><div id="elh_b_account_info_fund_o" class="b_account_info_fund_o">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->fund_o->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->fund_o->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->fund_o->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->fund_o_no->Visible) { // fund_o_no ?>
	<?php if ($b_account_info->sortUrl($b_account_info->fund_o_no) == "") { ?>
		<th data-name="fund_o_no" class="<?php echo $b_account_info->fund_o_no->headerCellClass() ?>"><div id="elh_b_account_info_fund_o_no" class="b_account_info_fund_o_no"><div class="ew-table-header-caption"><?php echo $b_account_info->fund_o_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fund_o_no" class="<?php echo $b_account_info->fund_o_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->fund_o_no) ?>',1);"><div id="elh_b_account_info_fund_o_no" class="b_account_info_fund_o_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->fund_o_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->fund_o_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->fund_o_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info->int_40->Visible) { // int_@ ?>
	<?php if ($b_account_info->sortUrl($b_account_info->int_40) == "") { ?>
		<th data-name="int_40" class="<?php echo $b_account_info->int_40->headerCellClass() ?>"><div id="elh_b_account_info_int_40" class="b_account_info_int_40"><div class="ew-table-header-caption"><?php echo $b_account_info->int_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="int_40" class="<?php echo $b_account_info->int_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info->SortUrl($b_account_info->int_40) ?>',1);"><div id="elh_b_account_info_int_40" class="b_account_info_int_40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info->int_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info->int_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info->int_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$b_account_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($b_account_info->ExportAll && $b_account_info->isExport()) {
	$b_account_info_list->StopRec = $b_account_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($b_account_info_list->TotalRecs > $b_account_info_list->StartRec + $b_account_info_list->DisplayRecs - 1)
		$b_account_info_list->StopRec = $b_account_info_list->StartRec + $b_account_info_list->DisplayRecs - 1;
	else
		$b_account_info_list->StopRec = $b_account_info_list->TotalRecs;
}
$b_account_info_list->RecCnt = $b_account_info_list->StartRec - 1;
if ($b_account_info_list->Recordset && !$b_account_info_list->Recordset->EOF) {
	$b_account_info_list->Recordset->moveFirst();
	$selectLimit = $b_account_info_list->UseSelectLimit;
	if (!$selectLimit && $b_account_info_list->StartRec > 1)
		$b_account_info_list->Recordset->move($b_account_info_list->StartRec - 1);
} elseif (!$b_account_info->AllowAddDeleteRow && $b_account_info_list->StopRec == 0) {
	$b_account_info_list->StopRec = $b_account_info->GridAddRowCount;
}

// Initialize aggregate
$b_account_info->RowType = ROWTYPE_AGGREGATEINIT;
$b_account_info->resetAttributes();
$b_account_info_list->renderRow();
while ($b_account_info_list->RecCnt < $b_account_info_list->StopRec) {
	$b_account_info_list->RecCnt++;
	if ($b_account_info_list->RecCnt >= $b_account_info_list->StartRec) {
		$b_account_info_list->RowCnt++;

		// Set up key count
		$b_account_info_list->KeyCount = $b_account_info_list->RowIndex;

		// Init row class and style
		$b_account_info->resetAttributes();
		$b_account_info->CssClass = "";
		if ($b_account_info->isGridAdd()) {
		} else {
			$b_account_info_list->loadRowValues($b_account_info_list->Recordset); // Load row values
		}
		$b_account_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$b_account_info->RowAttrs = array_merge($b_account_info->RowAttrs, array('data-rowindex'=>$b_account_info_list->RowCnt, 'id'=>'r' . $b_account_info_list->RowCnt . '_b_account_info', 'data-rowtype'=>$b_account_info->RowType));

		// Render row
		$b_account_info_list->renderRow();

		// Render list options
		$b_account_info_list->renderListOptions();
?>
	<tr<?php echo $b_account_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$b_account_info_list->ListOptions->render("body", "left", $b_account_info_list->RowCnt);
?>
	<?php if ($b_account_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $b_account_info->id->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_id" class="b_account_info_id">
<span<?php echo $b_account_info->id->viewAttributes() ?>>
<?php echo $b_account_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->b_type->Visible) { // b_type ?>
		<td data-name="b_type"<?php echo $b_account_info->b_type->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_b_type" class="b_account_info_b_type">
<span<?php echo $b_account_info->b_type->viewAttributes() ?>>
<?php echo $b_account_info->b_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $b_account_info->grp->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_grp" class="b_account_info_grp">
<span<?php echo $b_account_info->grp->viewAttributes() ?>>
<?php echo $b_account_info->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->branch->Visible) { // branch ?>
		<td data-name="branch"<?php echo $b_account_info->branch->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_branch" class="b_account_info_branch">
<span<?php echo $b_account_info->branch->viewAttributes() ?>>
<?php echo $b_account_info->branch->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->account_type->Visible) { // account_type ?>
		<td data-name="account_type"<?php echo $b_account_info->account_type->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_account_type" class="b_account_info_account_type">
<span<?php echo $b_account_info->account_type->viewAttributes() ?>>
<?php echo $b_account_info->account_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->type->Visible) { // type ?>
		<td data-name="type"<?php echo $b_account_info->type->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_type" class="b_account_info_type">
<span<?php echo $b_account_info->type->viewAttributes() ?>>
<?php echo $b_account_info->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name"<?php echo $b_account_info->formal_name->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_formal_name" class="b_account_info_formal_name">
<span<?php echo $b_account_info->formal_name->viewAttributes() ?>>
<?php echo $b_account_info->formal_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $b_account_info->mobile->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_mobile" class="b_account_info_mobile">
<span<?php echo $b_account_info->mobile->viewAttributes() ?>>
<?php echo $b_account_info->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->agent->Visible) { // agent ?>
		<td data-name="agent"<?php echo $b_account_info->agent->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_agent" class="b_account_info_agent">
<span<?php echo $b_account_info->agent->viewAttributes() ?>>
<?php echo $b_account_info->agent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->account_no->Visible) { // account_no ?>
		<td data-name="account_no"<?php echo $b_account_info->account_no->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_account_no" class="b_account_info_account_no">
<span<?php echo $b_account_info->account_no->viewAttributes() ?>>
<?php echo $b_account_info->account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->loan_amount->Visible) { // loan_amount ?>
		<td data-name="loan_amount"<?php echo $b_account_info->loan_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_loan_amount" class="b_account_info_loan_amount">
<span<?php echo $b_account_info->loan_amount->viewAttributes() ?>>
<?php echo $b_account_info->loan_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->emi_amount->Visible) { // emi_amount ?>
		<td data-name="emi_amount"<?php echo $b_account_info->emi_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_emi_amount" class="b_account_info_emi_amount">
<span<?php echo $b_account_info->emi_amount->viewAttributes() ?>>
<?php echo $b_account_info->emi_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->frequency->Visible) { // frequency ?>
		<td data-name="frequency"<?php echo $b_account_info->frequency->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_frequency" class="b_account_info_frequency">
<span<?php echo $b_account_info->frequency->viewAttributes() ?>>
<?php echo $b_account_info->frequency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->disbursement_amount->Visible) { // disbursement_amount ?>
		<td data-name="disbursement_amount"<?php echo $b_account_info->disbursement_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_disbursement_amount" class="b_account_info_disbursement_amount">
<span<?php echo $b_account_info->disbursement_amount->viewAttributes() ?>>
<?php echo $b_account_info->disbursement_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $b_account_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_datetime" class="b_account_info_datetime">
<span<?php echo $b_account_info->datetime->viewAttributes() ?>>
<?php echo $b_account_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
		<td data-name="otp_delivery_datetime"<?php echo $b_account_info->otp_delivery_datetime->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_otp_delivery_datetime" class="b_account_info_otp_delivery_datetime">
<span<?php echo $b_account_info->otp_delivery_datetime->viewAttributes() ?>>
<?php echo $b_account_info->otp_delivery_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
		<td data-name="otp_verify_datetime"<?php echo $b_account_info->otp_verify_datetime->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_otp_verify_datetime" class="b_account_info_otp_verify_datetime">
<span<?php echo $b_account_info->otp_verify_datetime->viewAttributes() ?>>
<?php echo $b_account_info->otp_verify_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->no_of_emi->Visible) { // no_of_emi ?>
		<td data-name="no_of_emi"<?php echo $b_account_info->no_of_emi->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_no_of_emi" class="b_account_info_no_of_emi">
<span<?php echo $b_account_info->no_of_emi->viewAttributes() ?>>
<?php echo $b_account_info->no_of_emi->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->fund_o->Visible) { // fund_o ?>
		<td data-name="fund_o"<?php echo $b_account_info->fund_o->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_fund_o" class="b_account_info_fund_o">
<span<?php echo $b_account_info->fund_o->viewAttributes() ?>>
<?php echo $b_account_info->fund_o->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->fund_o_no->Visible) { // fund_o_no ?>
		<td data-name="fund_o_no"<?php echo $b_account_info->fund_o_no->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_fund_o_no" class="b_account_info_fund_o_no">
<span<?php echo $b_account_info->fund_o_no->viewAttributes() ?>>
<?php echo $b_account_info->fund_o_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info->int_40->Visible) { // int_@ ?>
		<td data-name="int_40"<?php echo $b_account_info->int_40->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_list->RowCnt ?>_b_account_info_int_40" class="b_account_info_int_40">
<span<?php echo $b_account_info->int_40->viewAttributes() ?>>
<?php echo $b_account_info->int_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$b_account_info_list->ListOptions->render("body", "right", $b_account_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$b_account_info->isGridAdd())
		$b_account_info_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$b_account_info->RowType = ROWTYPE_AGGREGATE;
$b_account_info->resetAttributes();
$b_account_info_list->renderRow();
?>
<?php if ($b_account_info_list->TotalRecs > 0 && !$b_account_info->isGridAdd() && !$b_account_info->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$b_account_info_list->renderListOptions();

// Render list options (footer, left)
$b_account_info_list->ListOptions->render("footer", "left");
?>
	<?php if ($b_account_info->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $b_account_info->id->footerCellClass() ?>"><span id="elf_b_account_info_id" class="b_account_info_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->b_type->Visible) { // b_type ?>
		<td data-name="b_type" class="<?php echo $b_account_info->b_type->footerCellClass() ?>"><span id="elf_b_account_info_b_type" class="b_account_info_b_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $b_account_info->grp->footerCellClass() ?>"><span id="elf_b_account_info_grp" class="b_account_info_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->branch->Visible) { // branch ?>
		<td data-name="branch" class="<?php echo $b_account_info->branch->footerCellClass() ?>"><span id="elf_b_account_info_branch" class="b_account_info_branch">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->account_type->Visible) { // account_type ?>
		<td data-name="account_type" class="<?php echo $b_account_info->account_type->footerCellClass() ?>"><span id="elf_b_account_info_account_type" class="b_account_info_account_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $b_account_info->type->footerCellClass() ?>"><span id="elf_b_account_info_type" class="b_account_info_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name" class="<?php echo $b_account_info->formal_name->footerCellClass() ?>"><span id="elf_b_account_info_formal_name" class="b_account_info_formal_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->mobile->Visible) { // mobile ?>
		<td data-name="mobile" class="<?php echo $b_account_info->mobile->footerCellClass() ?>"><span id="elf_b_account_info_mobile" class="b_account_info_mobile">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->agent->Visible) { // agent ?>
		<td data-name="agent" class="<?php echo $b_account_info->agent->footerCellClass() ?>"><span id="elf_b_account_info_agent" class="b_account_info_agent">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->account_no->Visible) { // account_no ?>
		<td data-name="account_no" class="<?php echo $b_account_info->account_no->footerCellClass() ?>"><span id="elf_b_account_info_account_no" class="b_account_info_account_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->loan_amount->Visible) { // loan_amount ?>
		<td data-name="loan_amount" class="<?php echo $b_account_info->loan_amount->footerCellClass() ?>"><span id="elf_b_account_info_loan_amount" class="b_account_info_loan_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $b_account_info->loan_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->emi_amount->Visible) { // emi_amount ?>
		<td data-name="emi_amount" class="<?php echo $b_account_info->emi_amount->footerCellClass() ?>"><span id="elf_b_account_info_emi_amount" class="b_account_info_emi_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $b_account_info->emi_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->frequency->Visible) { // frequency ?>
		<td data-name="frequency" class="<?php echo $b_account_info->frequency->footerCellClass() ?>"><span id="elf_b_account_info_frequency" class="b_account_info_frequency">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->disbursement_amount->Visible) { // disbursement_amount ?>
		<td data-name="disbursement_amount" class="<?php echo $b_account_info->disbursement_amount->footerCellClass() ?>"><span id="elf_b_account_info_disbursement_amount" class="b_account_info_disbursement_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $b_account_info->disbursement_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $b_account_info->datetime->footerCellClass() ?>"><span id="elf_b_account_info_datetime" class="b_account_info_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
		<td data-name="otp_delivery_datetime" class="<?php echo $b_account_info->otp_delivery_datetime->footerCellClass() ?>"><span id="elf_b_account_info_otp_delivery_datetime" class="b_account_info_otp_delivery_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
		<td data-name="otp_verify_datetime" class="<?php echo $b_account_info->otp_verify_datetime->footerCellClass() ?>"><span id="elf_b_account_info_otp_verify_datetime" class="b_account_info_otp_verify_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->no_of_emi->Visible) { // no_of_emi ?>
		<td data-name="no_of_emi" class="<?php echo $b_account_info->no_of_emi->footerCellClass() ?>"><span id="elf_b_account_info_no_of_emi" class="b_account_info_no_of_emi">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->fund_o->Visible) { // fund_o ?>
		<td data-name="fund_o" class="<?php echo $b_account_info->fund_o->footerCellClass() ?>"><span id="elf_b_account_info_fund_o" class="b_account_info_fund_o">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->fund_o_no->Visible) { // fund_o_no ?>
		<td data-name="fund_o_no" class="<?php echo $b_account_info->fund_o_no->footerCellClass() ?>"><span id="elf_b_account_info_fund_o_no" class="b_account_info_fund_o_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_info->int_40->Visible) { // int_@ ?>
		<td data-name="int_40" class="<?php echo $b_account_info->int_40->footerCellClass() ?>"><span id="elf_b_account_info_int_40" class="b_account_info_int_40">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$b_account_info_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$b_account_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($b_account_info_list->Recordset)
	$b_account_info_list->Recordset->Close();
?>
<?php if (!$b_account_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$b_account_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_info_list->Pager)) $b_account_info_list->Pager = new PrevNextPager($b_account_info_list->StartRec, $b_account_info_list->DisplayRecs, $b_account_info_list->TotalRecs, $b_account_info_list->AutoHidePager) ?>
<?php if ($b_account_info_list->Pager->RecordCount > 0 && $b_account_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_info_list->pageUrl() ?>start=<?php echo $b_account_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_info_list->TotalRecs > 0 && (!$b_account_info_list->AutoHidePageSizeSelector || $b_account_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($b_account_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($b_account_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($b_account_info_list->TotalRecs == 0 && !$b_account_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $b_account_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$b_account_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$b_account_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$b_account_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_b_account_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$b_account_info_list->terminate();
?>