<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_search = new b_account_info_search();

// Run the page
$b_account_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($b_account_info_search->IsModal) { ?>
var fb_account_infosearch = currentAdvancedSearchForm = new ew.Form("fb_account_infosearch", "search");
<?php } else { ?>
var fb_account_infosearch = currentForm = new ew.Form("fb_account_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
fb_account_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_infosearch.lists["x_b_type"] = <?php echo $b_account_info_search->b_type->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_search->b_type->options(FALSE, TRUE)) ?>;
fb_account_infosearch.lists["x_grp"] = <?php echo $b_account_info_search->grp->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_search->grp->lookupOptions()) ?>;
fb_account_infosearch.lists["x_branch"] = <?php echo $b_account_info_search->branch->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_branch"].options = <?php echo JsonEncode($b_account_info_search->branch->lookupOptions()) ?>;
fb_account_infosearch.lists["x_category"] = <?php echo $b_account_info_search->category->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_category"].options = <?php echo JsonEncode($b_account_info_search->category->options(FALSE, TRUE)) ?>;
fb_account_infosearch.lists["x_type"] = <?php echo $b_account_info_search->type->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_type"].options = <?php echo JsonEncode($b_account_info_search->type->lookupOptions()) ?>;
fb_account_infosearch.lists["x_status"] = <?php echo $b_account_info_search->status->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_status"].options = <?php echo JsonEncode($b_account_info_search->status->lookupOptions()) ?>;
fb_account_infosearch.autoSuggests["x_status"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_infosearch.lists["x_agent"] = <?php echo $b_account_info_search->agent->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_agent"].options = <?php echo JsonEncode($b_account_info_search->agent->lookupOptions()) ?>;
fb_account_infosearch.lists["x_frequency"] = <?php echo $b_account_info_search->frequency->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_search->frequency->options(FALSE, TRUE)) ?>;
fb_account_infosearch.lists["x_fund_o_no"] = <?php echo $b_account_info_search->fund_o_no->Lookup->toClientList() ?>;
fb_account_infosearch.lists["x_fund_o_no"].options = <?php echo JsonEncode($b_account_info_search->fund_o_no->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fb_account_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_account_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->account_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_mobile");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->mobile->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->status->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_aadhaar_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->aadhaar_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pan_no");
	if (elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->pan_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_loan_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->loan_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_emi_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->emi_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_disbursement_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->disbursement_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->d_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->d_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_no_of_emi");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->no_of_emi->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_fund_o");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->fund_o->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_int_40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_info->int_40->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_info_search->showPageHeader(); ?>
<?php
$b_account_info_search->showMessage();
?>
<form name="fb_account_infosearch" id="fb_account_infosearch" class="<?php echo $b_account_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$b_account_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($b_account_info->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label for="x_b_type" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_b_type"><?php echo $b_account_info->b_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_b_type" id="z_b_type" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->b_type->cellAttributes() ?>>
			<span id="el_b_account_info_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_b_type" data-value-separator="<?php echo $b_account_info->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $b_account_info->b_type->editAttributes() ?>>
		<?php echo $b_account_info->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_grp"><?php echo $b_account_info->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->grp->cellAttributes() ?>>
			<span id="el_b_account_info_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_grp" data-value-separator="<?php echo $b_account_info->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $b_account_info->grp->editAttributes() ?>>
		<?php echo $b_account_info->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $b_account_info->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->branch->Visible) { // branch ?>
	<div id="r_branch" class="form-group row">
		<label for="x_branch" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_branch"><?php echo $b_account_info->branch->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_branch" id="z_branch" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->branch->cellAttributes() ?>>
			<span id="el_b_account_info_branch">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_branch" data-value-separator="<?php echo $b_account_info->branch->displayValueSeparatorAttribute() ?>" id="x_branch" name="x_branch"<?php echo $b_account_info->branch->editAttributes() ?>>
		<?php echo $b_account_info->branch->selectOptionListHtml("x_branch") ?>
	</select>
</div>
<?php echo $b_account_info->branch->Lookup->getParamTag("p_x_branch") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_category"><?php echo $b_account_info->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->category->cellAttributes() ?>>
			<span id="el_b_account_info_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_category" data-value-separator="<?php echo $b_account_info->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $b_account_info->category->editAttributes() ?>>
		<?php echo $b_account_info->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->account_type->Visible) { // account_type ?>
	<div id="r_account_type" class="form-group row">
		<label for="x_account_type" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_account_type"><?php echo $b_account_info->account_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_account_type" id="z_account_type" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->account_type->cellAttributes() ?>>
			<span id="el_b_account_info_account_type">
<input type="text" data-table="b_account_info" data-field="x_account_type" name="x_account_type" id="x_account_type" size="30" placeholder="<?php echo HtmlEncode($b_account_info->account_type->getPlaceHolder()) ?>" value="<?php echo $b_account_info->account_type->EditValue ?>"<?php echo $b_account_info->account_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_type"><?php echo $b_account_info->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->type->cellAttributes() ?>>
			<span id="el_b_account_info_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_type" data-value-separator="<?php echo $b_account_info->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $b_account_info->type->editAttributes() ?>>
		<?php echo $b_account_info->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $b_account_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label for="x_formal_name" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_formal_name"><?php echo $b_account_info->formal_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->formal_name->cellAttributes() ?>>
			<span id="el_b_account_info_formal_name">
<input type="text" data-table="b_account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info->formal_name->EditValue ?>"<?php echo $b_account_info->formal_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_mobile"><?php echo $b_account_info->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mobile" id="z_mobile" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->mobile->cellAttributes() ?>>
			<span id="el_b_account_info_mobile">
<input type="text" data-table="b_account_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info->mobile->getPlaceHolder()) ?>" value="<?php echo $b_account_info->mobile->EditValue ?>"<?php echo $b_account_info->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info__email"><?php echo $b_account_info->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->_email->cellAttributes() ?>>
			<span id="el_b_account_info__email">
<input type="text" data-table="b_account_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info->_email->getPlaceHolder()) ?>" value="<?php echo $b_account_info->_email->EditValue ?>"<?php echo $b_account_info->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_image"><?php echo $b_account_info->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->image->cellAttributes() ?>>
			<span id="el_b_account_info_image">
<input type="text" data-table="b_account_info" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($b_account_info->image->getPlaceHolder()) ?>" value="<?php echo $b_account_info->image->EditValue ?>"<?php echo $b_account_info->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->sign_image->Visible) { // sign_image ?>
	<div id="r_sign_image" class="form-group row">
		<label class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_sign_image"><?php echo $b_account_info->sign_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sign_image" id="z_sign_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->sign_image->cellAttributes() ?>>
			<span id="el_b_account_info_sign_image">
<input type="text" data-table="b_account_info" data-field="x_sign_image" name="x_sign_image" id="x_sign_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($b_account_info->sign_image->getPlaceHolder()) ?>" value="<?php echo $b_account_info->sign_image->EditValue ?>"<?php echo $b_account_info->sign_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_status"><?php echo $b_account_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->status->cellAttributes() ?>>
			<span id="el_b_account_info_status">
<?php
$wrkonchange = "" . trim(@$b_account_info->status->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$b_account_info->status->EditAttrs["onchange"] = "";
?>
<span id="as_x_status" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_status" id="sv_x_status" value="<?php echo RemoveHtml($b_account_info->status->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($b_account_info->status->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($b_account_info->status->getPlaceHolder()) ?>"<?php echo $b_account_info->status->editAttributes() ?>>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_status" data-value-separator="<?php echo $b_account_info->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info->status->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fb_account_infosearch.createAutoSuggest({"id":"x_status","forceSelect":true});
</script>
<?php echo $b_account_info->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label for="x_aadhaar_no" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_aadhaar_no"><?php echo $b_account_info->aadhaar_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->aadhaar_no->cellAttributes() ?>>
			<span id="el_b_account_info_aadhaar_no">
<input type="text" data-table="b_account_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($b_account_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->aadhaar_no->EditValue ?>"<?php echo $b_account_info->aadhaar_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label for="x_pan_no" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_pan_no"><?php echo $b_account_info->pan_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->pan_no->cellAttributes() ?>>
			<span id="el_b_account_info_pan_no">
<input type="text" data-table="b_account_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->pan_no->EditValue ?>"<?php echo $b_account_info->pan_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_id_proof"><?php echo $b_account_info->id_proof->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_id_proof" id="z_id_proof" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->id_proof->cellAttributes() ?>>
			<span id="el_b_account_info_id_proof">
<input type="text" data-table="b_account_info" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($b_account_info->id_proof->getPlaceHolder()) ?>" value="<?php echo $b_account_info->id_proof->EditValue ?>"<?php echo $b_account_info->id_proof->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label for="x_agent" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_agent"><?php echo $b_account_info->agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_agent" id="z_agent" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->agent->cellAttributes() ?>>
			<span id="el_b_account_info_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_agent" data-value-separator="<?php echo $b_account_info->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info->agent->editAttributes() ?>>
		<?php echo $b_account_info->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label for="x_other_details" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_other_details"><?php echo $b_account_info->other_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other_details" id="z_other_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->other_details->cellAttributes() ?>>
			<span id="el_b_account_info_other_details">
<input type="text" data-table="b_account_info" data-field="x_other_details" name="x_other_details" id="x_other_details" placeholder="<?php echo HtmlEncode($b_account_info->other_details->getPlaceHolder()) ?>" value="<?php echo $b_account_info->other_details->EditValue ?>"<?php echo $b_account_info->other_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label for="x_bank_name" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_bank_name"><?php echo $b_account_info->bank_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bank_name" id="z_bank_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->bank_name->cellAttributes() ?>>
			<span id="el_b_account_info_bank_name">
<input type="text" data-table="b_account_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($b_account_info->bank_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_name->EditValue ?>"<?php echo $b_account_info->bank_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label for="x_bank_ifsc_code" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_bank_ifsc_code"><?php echo $b_account_info->bank_ifsc_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bank_ifsc_code" id="z_bank_ifsc_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->bank_ifsc_code->cellAttributes() ?>>
			<span id="el_b_account_info_bank_ifsc_code">
<input type="text" data-table="b_account_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($b_account_info->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_ifsc_code->EditValue ?>"<?php echo $b_account_info->bank_ifsc_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label for="x_bank_account_no" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_bank_account_no"><?php echo $b_account_info->bank_account_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bank_account_no" id="z_bank_account_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->bank_account_no->cellAttributes() ?>>
			<span id="el_b_account_info_bank_account_no">
<input type="text" data-table="b_account_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($b_account_info->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_account_no->EditValue ?>"<?php echo $b_account_info->bank_account_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->account_no->Visible) { // account_no ?>
	<div id="r_account_no" class="form-group row">
		<label for="x_account_no" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_account_no"><?php echo $b_account_info->account_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_account_no" id="z_account_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->account_no->cellAttributes() ?>>
			<span id="el_b_account_info_account_no">
<input type="text" data-table="b_account_info" data-field="x_account_no" name="x_account_no" id="x_account_no" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($b_account_info->account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->account_no->EditValue ?>"<?php echo $b_account_info->account_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->loan_amount->Visible) { // loan_amount ?>
	<div id="r_loan_amount" class="form-group row">
		<label for="x_loan_amount" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_loan_amount"><?php echo $b_account_info->loan_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_loan_amount" id="z_loan_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->loan_amount->cellAttributes() ?>>
			<span id="el_b_account_info_loan_amount">
<input type="text" data-table="b_account_info" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->loan_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->loan_amount->EditValue ?>"<?php echo $b_account_info->loan_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->emi_amount->Visible) { // emi_amount ?>
	<div id="r_emi_amount" class="form-group row">
		<label for="x_emi_amount" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_emi_amount"><?php echo $b_account_info->emi_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emi_amount" id="z_emi_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->emi_amount->cellAttributes() ?>>
			<span id="el_b_account_info_emi_amount">
<input type="text" data-table="b_account_info" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->emi_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->emi_amount->EditValue ?>"<?php echo $b_account_info->emi_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->frequency->Visible) { // frequency ?>
	<div id="r_frequency" class="form-group row">
		<label for="x_frequency" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_frequency"><?php echo $b_account_info->frequency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_frequency" id="z_frequency" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->frequency->cellAttributes() ?>>
			<span id="el_b_account_info_frequency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_frequency" data-value-separator="<?php echo $b_account_info->frequency->displayValueSeparatorAttribute() ?>" id="x_frequency" name="x_frequency"<?php echo $b_account_info->frequency->editAttributes() ?>>
		<?php echo $b_account_info->frequency->selectOptionListHtml("x_frequency") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->disbursement_amount->Visible) { // disbursement_amount ?>
	<div id="r_disbursement_amount" class="form-group row">
		<label for="x_disbursement_amount" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_disbursement_amount"><?php echo $b_account_info->disbursement_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_disbursement_amount" id="z_disbursement_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->disbursement_amount->cellAttributes() ?>>
			<span id="el_b_account_info_disbursement_amount">
<input type="text" data-table="b_account_info" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->disbursement_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->disbursement_amount->EditValue ?>"<?php echo $b_account_info->disbursement_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_operator"><?php echo $b_account_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->operator->cellAttributes() ?>>
			<span id="el_b_account_info_operator">
<input type="text" data-table="b_account_info" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($b_account_info->operator->getPlaceHolder()) ?>" value="<?php echo $b_account_info->operator->EditValue ?>"<?php echo $b_account_info->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_datetime"><?php echo $b_account_info->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($b_account_info->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_b_account_info_datetime">
<input type="text" data-table="b_account_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($b_account_info->datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info->datetime->EditValue ?>"<?php echo $b_account_info->datetime->editAttributes() ?>>
<?php if (!$b_account_info->datetime->ReadOnly && !$b_account_info->datetime->Disabled && !isset($b_account_info->datetime->EditAttrs["readonly"]) && !isset($b_account_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_b_account_info_datetime" class="btw1_datetime d-none">
<input type="text" data-table="b_account_info" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($b_account_info->datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info->datetime->EditValue2 ?>"<?php echo $b_account_info->datetime->editAttributes() ?>>
<?php if (!$b_account_info->datetime->ReadOnly && !$b_account_info->datetime->Disabled && !isset($b_account_info->datetime->EditAttrs["readonly"]) && !isset($b_account_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_infosearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->d_operator->Visible) { // d_operator ?>
	<div id="r_d_operator" class="form-group row">
		<label for="x_d_operator" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_d_operator"><?php echo $b_account_info->d_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_operator" id="z_d_operator" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->d_operator->cellAttributes() ?>>
			<span id="el_b_account_info_d_operator">
<input type="text" data-table="b_account_info" data-field="x_d_operator" name="x_d_operator" id="x_d_operator" size="30" placeholder="<?php echo HtmlEncode($b_account_info->d_operator->getPlaceHolder()) ?>" value="<?php echo $b_account_info->d_operator->EditValue ?>"<?php echo $b_account_info->d_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->d_datetime->Visible) { // d_datetime ?>
	<div id="r_d_datetime" class="form-group row">
		<label for="x_d_datetime" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_d_datetime"><?php echo $b_account_info->d_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_datetime" id="z_d_datetime" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->d_datetime->cellAttributes() ?>>
			<span id="el_b_account_info_d_datetime">
<input type="text" data-table="b_account_info" data-field="x_d_datetime" name="x_d_datetime" id="x_d_datetime" placeholder="<?php echo HtmlEncode($b_account_info->d_datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_info->d_datetime->EditValue ?>"<?php echo $b_account_info->d_datetime->editAttributes() ?>>
<?php if (!$b_account_info->d_datetime->ReadOnly && !$b_account_info->d_datetime->Disabled && !isset($b_account_info->d_datetime->EditAttrs["readonly"]) && !isset($b_account_info->d_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_infosearch", "x_d_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label for="x_no_of_emi" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_no_of_emi"><?php echo $b_account_info->no_of_emi->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no_of_emi" id="z_no_of_emi" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->no_of_emi->cellAttributes() ?>>
			<span id="el_b_account_info_no_of_emi">
<input type="text" data-table="b_account_info" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_info->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_info->no_of_emi->EditValue ?>"<?php echo $b_account_info->no_of_emi->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->fund_o->Visible) { // fund_o ?>
	<div id="r_fund_o" class="form-group row">
		<label for="x_fund_o" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_fund_o"><?php echo $b_account_info->fund_o->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fund_o" id="z_fund_o" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->fund_o->cellAttributes() ?>>
			<span id="el_b_account_info_fund_o">
<input type="text" data-table="b_account_info" data-field="x_fund_o" name="x_fund_o" id="x_fund_o" size="30" placeholder="<?php echo HtmlEncode($b_account_info->fund_o->getPlaceHolder()) ?>" value="<?php echo $b_account_info->fund_o->EditValue ?>"<?php echo $b_account_info->fund_o->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->fund_o_no->Visible) { // fund_o_no ?>
	<div id="r_fund_o_no" class="form-group row">
		<label for="x_fund_o_no" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_fund_o_no"><?php echo $b_account_info->fund_o_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_fund_o_no" id="z_fund_o_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->fund_o_no->cellAttributes() ?>>
			<span id="el_b_account_info_fund_o_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_fund_o_no" data-value-separator="<?php echo $b_account_info->fund_o_no->displayValueSeparatorAttribute() ?>" id="x_fund_o_no" name="x_fund_o_no"<?php echo $b_account_info->fund_o_no->editAttributes() ?>>
		<?php echo $b_account_info->fund_o_no->selectOptionListHtml("x_fund_o_no") ?>
	</select>
</div>
<?php echo $b_account_info->fund_o_no->Lookup->getParamTag("p_x_fund_o_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->int_40->Visible) { // int_@ ?>
	<div id="r_int_40" class="form-group row">
		<label for="x_int_40" class="<?php echo $b_account_info_search->LeftColumnClass ?>"><span id="elh_b_account_info_int_40"><?php echo $b_account_info->int_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_int_40" id="z_int_40" value="="></span>
		</label>
		<div class="<?php echo $b_account_info_search->RightColumnClass ?>"><div<?php echo $b_account_info->int_40->cellAttributes() ?>>
			<span id="el_b_account_info_int_40">
<input type="text" data-table="b_account_info" data-field="x_int_40" name="x_int_40" id="x_int_40" size="30" placeholder="<?php echo HtmlEncode($b_account_info->int_40->getPlaceHolder()) ?>" value="<?php echo $b_account_info->int_40->EditValue ?>"<?php echo $b_account_info->int_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_account_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_account_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_account_info_search->terminate();
?>