<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_update = new b_account_info_update();

// Run the page
$b_account_info_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fb_account_infoupdate = currentForm = new ew.Form("fb_account_infoupdate", "update");

// Validate form
fb_account_infoupdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($b_account_info_update->b_type->Required) { ?>
			elm = this.getElements("x" + infix + "_b_type");
			uelm = this.getElements("u" + infix + "_b_type");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->b_type->caption(), $b_account_info->b_type->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			uelm = this.getElements("u" + infix + "_grp");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->grp->caption(), $b_account_info->grp->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->branch->Required) { ?>
			elm = this.getElements("x" + infix + "_branch");
			uelm = this.getElements("u" + infix + "_branch");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->branch->caption(), $b_account_info->branch->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->account_type->Required) { ?>
			elm = this.getElements("x" + infix + "_account_type");
			uelm = this.getElements("u" + infix + "_account_type");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->account_type->caption(), $b_account_info->account_type->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_account_type");
			uelm = this.getElements("u" + infix + "_account_type");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->account_type->errorMessage()) ?>");
		<?php if ($b_account_info_update->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			uelm = this.getElements("u" + infix + "_type");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->type->caption(), $b_account_info->type->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			uelm = this.getElements("u" + infix + "_formal_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->formal_name->caption(), $b_account_info->formal_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			uelm = this.getElements("u" + infix + "_mobile");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->mobile->caption(), $b_account_info->mobile->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			uelm = this.getElements("u" + infix + "_mobile");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->mobile->errorMessage()) ?>");
		<?php if ($b_account_info_update->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			uelm = this.getElements("u" + infix + "__email");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->_email->caption(), $b_account_info->_email->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			uelm = this.getElements("u" + infix + "__email");
			if (uelm && uelm.checked && elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->_email->errorMessage()) ?>");
		<?php if ($b_account_info_update->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			uelm = this.getElements("u" + infix + "_image");
			if (uelm && uelm.checked) {
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info->image->caption(), $b_account_info->image->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->sign_image->Required) { ?>
			felm = this.getElements("x" + infix + "_sign_image");
			elm = this.getElements("fn_x" + infix + "_sign_image");
			uelm = this.getElements("u" + infix + "_sign_image");
			if (uelm && uelm.checked) {
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info->sign_image->caption(), $b_account_info->sign_image->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			uelm = this.getElements("u" + infix + "_status");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->status->caption(), $b_account_info->status->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			uelm = this.getElements("u" + infix + "_status");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->status->errorMessage()) ?>");
		<?php if ($b_account_info_update->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			uelm = this.getElements("u" + infix + "_aadhaar_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->aadhaar_no->caption(), $b_account_info->aadhaar_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			uelm = this.getElements("u" + infix + "_aadhaar_no");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->aadhaar_no->errorMessage()) ?>");
		<?php if ($b_account_info_update->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			uelm = this.getElements("u" + infix + "_pan_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->pan_no->caption(), $b_account_info->pan_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_pan_no");
			uelm = this.getElements("u" + infix + "_pan_no");
			if (uelm && uelm.checked && elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->pan_no->errorMessage()) ?>");
		<?php if ($b_account_info_update->id_proof->Required) { ?>
			felm = this.getElements("x" + infix + "_id_proof");
			elm = this.getElements("fn_x" + infix + "_id_proof");
			uelm = this.getElements("u" + infix + "_id_proof");
			if (uelm && uelm.checked) {
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $b_account_info->id_proof->caption(), $b_account_info->id_proof->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->agent->Required) { ?>
			elm = this.getElements("x" + infix + "_agent");
			uelm = this.getElements("u" + infix + "_agent");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->agent->caption(), $b_account_info->agent->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			uelm = this.getElements("u" + infix + "_other_details");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->other_details->caption(), $b_account_info->other_details->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			uelm = this.getElements("u" + infix + "_bank_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->bank_name->caption(), $b_account_info->bank_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			uelm = this.getElements("u" + infix + "_bank_ifsc_code");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->bank_ifsc_code->caption(), $b_account_info->bank_ifsc_code->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			uelm = this.getElements("u" + infix + "_bank_account_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->bank_account_no->caption(), $b_account_info->bank_account_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_account_no");
			uelm = this.getElements("u" + infix + "_account_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->account_no->caption(), $b_account_info->account_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->loan_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			uelm = this.getElements("u" + infix + "_loan_amount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->loan_amount->caption(), $b_account_info->loan_amount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			uelm = this.getElements("u" + infix + "_loan_amount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->loan_amount->errorMessage()) ?>");
		<?php if ($b_account_info_update->emi_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			uelm = this.getElements("u" + infix + "_emi_amount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->emi_amount->caption(), $b_account_info->emi_amount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			uelm = this.getElements("u" + infix + "_emi_amount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->emi_amount->errorMessage()) ?>");
		<?php if ($b_account_info_update->frequency->Required) { ?>
			elm = this.getElements("x" + infix + "_frequency");
			uelm = this.getElements("u" + infix + "_frequency");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->frequency->caption(), $b_account_info->frequency->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->disbursement_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			uelm = this.getElements("u" + infix + "_disbursement_amount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->disbursement_amount->caption(), $b_account_info->disbursement_amount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			uelm = this.getElements("u" + infix + "_disbursement_amount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->disbursement_amount->errorMessage()) ?>");
		<?php if ($b_account_info_update->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			uelm = this.getElements("u" + infix + "_operator");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->operator->caption(), $b_account_info->operator->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			uelm = this.getElements("u" + infix + "_datetime");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->datetime->caption(), $b_account_info->datetime->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->d_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_d_operator");
			uelm = this.getElements("u" + infix + "_d_operator");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->d_operator->caption(), $b_account_info->d_operator->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->d_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_d_datetime");
			uelm = this.getElements("u" + infix + "_d_datetime");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->d_datetime->caption(), $b_account_info->d_datetime->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->no_of_emi->Required) { ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			uelm = this.getElements("u" + infix + "_no_of_emi");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->no_of_emi->caption(), $b_account_info->no_of_emi->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			uelm = this.getElements("u" + infix + "_no_of_emi");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->no_of_emi->errorMessage()) ?>");
		<?php if ($b_account_info_update->fund_o->Required) { ?>
			elm = this.getElements("x" + infix + "_fund_o");
			uelm = this.getElements("u" + infix + "_fund_o");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->fund_o->caption(), $b_account_info->fund_o->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_fund_o");
			uelm = this.getElements("u" + infix + "_fund_o");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->fund_o->errorMessage()) ?>");
		<?php if ($b_account_info_update->fund_o_no->Required) { ?>
			elm = this.getElements("x" + infix + "_fund_o_no");
			uelm = this.getElements("u" + infix + "_fund_o_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->fund_o_no->caption(), $b_account_info->fund_o_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($b_account_info_update->int_40->Required) { ?>
			elm = this.getElements("x" + infix + "_int_40");
			uelm = this.getElements("u" + infix + "_int_40");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info->int_40->caption(), $b_account_info->int_40->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_int_40");
			uelm = this.getElements("u" + infix + "_int_40");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info->int_40->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fb_account_infoupdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_infoupdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_infoupdate.lists["x_b_type"] = <?php echo $b_account_info_update->b_type->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_update->b_type->options(FALSE, TRUE)) ?>;
fb_account_infoupdate.lists["x_grp"] = <?php echo $b_account_info_update->grp->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_update->grp->lookupOptions()) ?>;
fb_account_infoupdate.lists["x_branch"] = <?php echo $b_account_info_update->branch->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_branch"].options = <?php echo JsonEncode($b_account_info_update->branch->lookupOptions()) ?>;
fb_account_infoupdate.lists["x_type"] = <?php echo $b_account_info_update->type->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_type"].options = <?php echo JsonEncode($b_account_info_update->type->lookupOptions()) ?>;
fb_account_infoupdate.lists["x_status"] = <?php echo $b_account_info_update->status->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_status"].options = <?php echo JsonEncode($b_account_info_update->status->lookupOptions()) ?>;
fb_account_infoupdate.autoSuggests["x_status"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_infoupdate.lists["x_agent"] = <?php echo $b_account_info_update->agent->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_agent"].options = <?php echo JsonEncode($b_account_info_update->agent->lookupOptions()) ?>;
fb_account_infoupdate.lists["x_frequency"] = <?php echo $b_account_info_update->frequency->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_update->frequency->options(FALSE, TRUE)) ?>;
fb_account_infoupdate.lists["x_fund_o_no"] = <?php echo $b_account_info_update->fund_o_no->Lookup->toClientList() ?>;
fb_account_infoupdate.lists["x_fund_o_no"].options = <?php echo JsonEncode($b_account_info_update->fund_o_no->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_info_update->showPageHeader(); ?>
<?php
$b_account_info_update->showMessage();
?>
<form name="fb_account_infoupdate" id="fb_account_infoupdate" class="<?php echo $b_account_info_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<?php if ($b_account_info->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$b_account_info_update->IsModal ?>">
<?php foreach ($b_account_info_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_b_account_infoupdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $b_account_info_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($b_account_info->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label for="x_b_type" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_b_type" id="u_b_type" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->b_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_b_type" id="u_b_type" value="<?php echo $b_account_info->b_type->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->b_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_b_type"><?php echo $b_account_info->b_type->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->b_type->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_b_type" data-value-separator="<?php echo $b_account_info->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $b_account_info->b_type->editAttributes() ?>>
		<?php echo $b_account_info->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_b_account_info_b_type">
<span<?php echo $b_account_info->b_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->b_type->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_b_type" name="x_b_type" id="x_b_type" value="<?php echo HtmlEncode($b_account_info->b_type->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->b_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->branch->Visible) { // branch ?>
	<div id="r_branch" class="form-group row">
		<label for="x_branch" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_branch" id="u_branch" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->branch->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_branch" id="u_branch" value="<?php echo $b_account_info->branch->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->branch->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_branch"><?php echo $b_account_info->branch->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->branch->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_branch">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_branch" data-value-separator="<?php echo $b_account_info->branch->displayValueSeparatorAttribute() ?>" id="x_branch" name="x_branch"<?php echo $b_account_info->branch->editAttributes() ?>>
		<?php echo $b_account_info->branch->selectOptionListHtml("x_branch") ?>
	</select>
</div>
<?php echo $b_account_info->branch->Lookup->getParamTag("p_x_branch") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_branch">
<span<?php echo $b_account_info->branch->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->branch->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_branch" name="x_branch" id="x_branch" value="<?php echo HtmlEncode($b_account_info->branch->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->branch->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->account_type->Visible) { // account_type ?>
	<div id="r_account_type" class="form-group row">
		<label for="x_account_type" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_account_type" id="u_account_type" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->account_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_account_type" id="u_account_type" value="<?php echo $b_account_info->account_type->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->account_type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_account_type"><?php echo $b_account_info->account_type->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->account_type->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_account_type">
<input type="text" data-table="b_account_info" data-field="x_account_type" name="x_account_type" id="x_account_type" size="30" placeholder="<?php echo HtmlEncode($b_account_info->account_type->getPlaceHolder()) ?>" value="<?php echo $b_account_info->account_type->EditValue ?>"<?php echo $b_account_info->account_type->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_account_type">
<span<?php echo $b_account_info->account_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->account_type->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_account_type" name="x_account_type" id="x_account_type" value="<?php echo HtmlEncode($b_account_info->account_type->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->account_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_type" id="u_type" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_type" id="u_type" value="<?php echo $b_account_info->type->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->type->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_type"><?php echo $b_account_info->type->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->type->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_type" data-value-separator="<?php echo $b_account_info->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $b_account_info->type->editAttributes() ?>>
		<?php echo $b_account_info->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $b_account_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_type">
<span<?php echo $b_account_info->type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->type->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_type" name="x_type" id="x_type" value="<?php echo HtmlEncode($b_account_info->type->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label for="x_formal_name" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_formal_name" id="u_formal_name" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->formal_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_formal_name" id="u_formal_name" value="<?php echo $b_account_info->formal_name->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->formal_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_formal_name"><?php echo $b_account_info->formal_name->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->formal_name->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_formal_name">
<input type="text" data-table="b_account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info->formal_name->EditValue ?>"<?php echo $b_account_info->formal_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_formal_name">
<span<?php echo $b_account_info->formal_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->formal_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" value="<?php echo HtmlEncode($b_account_info->formal_name->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_mobile" id="u_mobile" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->mobile->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_mobile" id="u_mobile" value="<?php echo $b_account_info->mobile->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->mobile->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_mobile"><?php echo $b_account_info->mobile->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->mobile->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_mobile">
<input type="text" data-table="b_account_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info->mobile->getPlaceHolder()) ?>" value="<?php echo $b_account_info->mobile->EditValue ?>"<?php echo $b_account_info->mobile->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_mobile">
<span<?php echo $b_account_info->mobile->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->mobile->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_mobile" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($b_account_info->mobile->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u__email" id="u__email" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->_email->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u__email" id="u__email" value="<?php echo $b_account_info->_email->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->_email->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u__email"><?php echo $b_account_info->_email->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->_email->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info__email">
<input type="text" data-table="b_account_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info->_email->getPlaceHolder()) ?>" value="<?php echo $b_account_info->_email->EditValue ?>"<?php echo $b_account_info->_email->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info__email">
<span<?php echo $b_account_info->_email->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->_email->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x__email" name="x__email" id="x__email" value="<?php echo HtmlEncode($b_account_info->_email->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_image" id="u_image" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_image" id="u_image" value="<?php echo $b_account_info->image->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_image"><?php echo $b_account_info->image->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->image->cellAttributes() ?>>
<span id="el_b_account_info_image">
<div id="fd_x_image">
<span title="<?php echo $b_account_info->image->title() ? $b_account_info->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info->image->ReadOnly || $b_account_info->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info" data-field="x_image" name="x_image" id="x_image"<?php echo $b_account_info->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $b_account_info->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $b_account_info->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $b_account_info->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->sign_image->Visible) { // sign_image ?>
	<div id="r_sign_image" class="form-group row">
		<label class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_sign_image" id="u_sign_image" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->sign_image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_sign_image" id="u_sign_image" value="<?php echo $b_account_info->sign_image->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->sign_image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_sign_image"><?php echo $b_account_info->sign_image->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->sign_image->cellAttributes() ?>>
<span id="el_b_account_info_sign_image">
<div id="fd_x_sign_image">
<span title="<?php echo $b_account_info->sign_image->title() ? $b_account_info->sign_image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info->sign_image->ReadOnly || $b_account_info->sign_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info" data-field="x_sign_image" name="x_sign_image" id="x_sign_image" multiple="multiple"<?php echo $b_account_info->sign_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_sign_image" id= "fn_x_sign_image" value="<?php echo $b_account_info->sign_image->Upload->FileName ?>">
<?php if (Post("fa_x_sign_image") == "0") { ?>
<input type="hidden" name="fa_x_sign_image" id= "fa_x_sign_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_sign_image" id= "fa_x_sign_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_sign_image" id= "fs_x_sign_image" value="255">
<input type="hidden" name="fx_x_sign_image" id= "fx_x_sign_image" value="<?php echo $b_account_info->sign_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_sign_image" id= "fm_x_sign_image" value="<?php echo $b_account_info->sign_image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_sign_image" id= "fc_x_sign_image" value="<?php echo $b_account_info->sign_image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_sign_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info->sign_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_status" id="u_status" value="<?php echo $b_account_info->status->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_status"><?php echo $b_account_info->status->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->status->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_status">
<?php
$wrkonchange = "" . trim(@$b_account_info->status->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$b_account_info->status->EditAttrs["onchange"] = "";
?>
<span id="as_x_status" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_status" id="sv_x_status" value="<?php echo RemoveHtml($b_account_info->status->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($b_account_info->status->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($b_account_info->status->getPlaceHolder()) ?>"<?php echo $b_account_info->status->editAttributes() ?>>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_status" data-value-separator="<?php echo $b_account_info->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info->status->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fb_account_infoupdate.createAutoSuggest({"id":"x_status","forceSelect":true});
</script>
<?php echo $b_account_info->status->Lookup->getParamTag("p_x_status") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_status">
<span<?php echo $b_account_info->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->status->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_status" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info->status->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label for="x_aadhaar_no" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_aadhaar_no" id="u_aadhaar_no" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->aadhaar_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_aadhaar_no" id="u_aadhaar_no" value="<?php echo $b_account_info->aadhaar_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->aadhaar_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_aadhaar_no"><?php echo $b_account_info->aadhaar_no->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->aadhaar_no->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_aadhaar_no">
<input type="text" data-table="b_account_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($b_account_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->aadhaar_no->EditValue ?>"<?php echo $b_account_info->aadhaar_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_aadhaar_no">
<span<?php echo $b_account_info->aadhaar_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->aadhaar_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" value="<?php echo HtmlEncode($b_account_info->aadhaar_no->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label for="x_pan_no" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_pan_no" id="u_pan_no" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->pan_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_pan_no" id="u_pan_no" value="<?php echo $b_account_info->pan_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->pan_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_pan_no"><?php echo $b_account_info->pan_no->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->pan_no->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_pan_no">
<input type="text" data-table="b_account_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->pan_no->EditValue ?>"<?php echo $b_account_info->pan_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_pan_no">
<span<?php echo $b_account_info->pan_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->pan_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" value="<?php echo HtmlEncode($b_account_info->pan_no->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_id_proof" id="u_id_proof" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->id_proof->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_id_proof" id="u_id_proof" value="<?php echo $b_account_info->id_proof->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->id_proof->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_id_proof"><?php echo $b_account_info->id_proof->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->id_proof->cellAttributes() ?>>
<span id="el_b_account_info_id_proof">
<div id="fd_x_id_proof">
<span title="<?php echo $b_account_info->id_proof->title() ? $b_account_info->id_proof->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($b_account_info->id_proof->ReadOnly || $b_account_info->id_proof->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="b_account_info" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" multiple="multiple"<?php echo $b_account_info->id_proof->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?php echo $b_account_info->id_proof->Upload->FileName ?>">
<?php if (Post("fa_x_id_proof") == "0") { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="1">
<?php } ?>
<input type="hidden" name="fs_x_id_proof" id= "fs_x_id_proof" value="255">
<input type="hidden" name="fx_x_id_proof" id= "fx_x_id_proof" value="<?php echo $b_account_info->id_proof->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_id_proof" id= "fm_x_id_proof" value="<?php echo $b_account_info->id_proof->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_id_proof" id= "fc_x_id_proof" value="<?php echo $b_account_info->id_proof->UploadMaxFileCount ?>">
</div>
<table id="ft_x_id_proof" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $b_account_info->id_proof->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label for="x_agent" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_agent" id="u_agent" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->agent->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_agent" id="u_agent" value="<?php echo $b_account_info->agent->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->agent->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_agent"><?php echo $b_account_info->agent->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->agent->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_agent" data-value-separator="<?php echo $b_account_info->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $b_account_info->agent->editAttributes() ?>>
		<?php echo $b_account_info->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $b_account_info->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_agent">
<span<?php echo $b_account_info->agent->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->agent->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_agent" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($b_account_info->agent->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label for="x_other_details" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_other_details" id="u_other_details" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->other_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_other_details" id="u_other_details" value="<?php echo $b_account_info->other_details->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->other_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_other_details"><?php echo $b_account_info->other_details->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->other_details->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_other_details">
<input type="text" data-table="b_account_info" data-field="x_other_details" name="x_other_details" id="x_other_details" placeholder="<?php echo HtmlEncode($b_account_info->other_details->getPlaceHolder()) ?>" value="<?php echo $b_account_info->other_details->EditValue ?>"<?php echo $b_account_info->other_details->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_other_details">
<span<?php echo $b_account_info->other_details->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->other_details->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_other_details" name="x_other_details" id="x_other_details" value="<?php echo HtmlEncode($b_account_info->other_details->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label for="x_bank_name" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_bank_name" id="u_bank_name" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->bank_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_bank_name" id="u_bank_name" value="<?php echo $b_account_info->bank_name->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->bank_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_bank_name"><?php echo $b_account_info->bank_name->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->bank_name->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_bank_name">
<input type="text" data-table="b_account_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($b_account_info->bank_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_name->EditValue ?>"<?php echo $b_account_info->bank_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_bank_name">
<span<?php echo $b_account_info->bank_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->bank_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" value="<?php echo HtmlEncode($b_account_info->bank_name->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->bank_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label for="x_bank_ifsc_code" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_bank_ifsc_code" id="u_bank_ifsc_code" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->bank_ifsc_code->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_bank_ifsc_code" id="u_bank_ifsc_code" value="<?php echo $b_account_info->bank_ifsc_code->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->bank_ifsc_code->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_bank_ifsc_code"><?php echo $b_account_info->bank_ifsc_code->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->bank_ifsc_code->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_bank_ifsc_code">
<input type="text" data-table="b_account_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($b_account_info->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_ifsc_code->EditValue ?>"<?php echo $b_account_info->bank_ifsc_code->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_bank_ifsc_code">
<span<?php echo $b_account_info->bank_ifsc_code->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->bank_ifsc_code->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" value="<?php echo HtmlEncode($b_account_info->bank_ifsc_code->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->bank_ifsc_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label for="x_bank_account_no" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_bank_account_no" id="u_bank_account_no" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->bank_account_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_bank_account_no" id="u_bank_account_no" value="<?php echo $b_account_info->bank_account_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->bank_account_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_bank_account_no"><?php echo $b_account_info->bank_account_no->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->bank_account_no->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_bank_account_no">
<input type="text" data-table="b_account_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($b_account_info->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info->bank_account_no->EditValue ?>"<?php echo $b_account_info->bank_account_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_bank_account_no">
<span<?php echo $b_account_info->bank_account_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->bank_account_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" value="<?php echo HtmlEncode($b_account_info->bank_account_no->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->bank_account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->loan_amount->Visible) { // loan_amount ?>
	<div id="r_loan_amount" class="form-group row">
		<label for="x_loan_amount" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_loan_amount" id="u_loan_amount" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->loan_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_loan_amount" id="u_loan_amount" value="<?php echo $b_account_info->loan_amount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->loan_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_loan_amount"><?php echo $b_account_info->loan_amount->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->loan_amount->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_loan_amount">
<input type="text" data-table="b_account_info" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->loan_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->loan_amount->EditValue ?>"<?php echo $b_account_info->loan_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_loan_amount">
<span<?php echo $b_account_info->loan_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->loan_amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" value="<?php echo HtmlEncode($b_account_info->loan_amount->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->loan_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->emi_amount->Visible) { // emi_amount ?>
	<div id="r_emi_amount" class="form-group row">
		<label for="x_emi_amount" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_emi_amount" id="u_emi_amount" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->emi_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_emi_amount" id="u_emi_amount" value="<?php echo $b_account_info->emi_amount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->emi_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_emi_amount"><?php echo $b_account_info->emi_amount->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->emi_amount->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_emi_amount">
<input type="text" data-table="b_account_info" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->emi_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->emi_amount->EditValue ?>"<?php echo $b_account_info->emi_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_emi_amount">
<span<?php echo $b_account_info->emi_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->emi_amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" value="<?php echo HtmlEncode($b_account_info->emi_amount->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->emi_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->frequency->Visible) { // frequency ?>
	<div id="r_frequency" class="form-group row">
		<label for="x_frequency" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_frequency" id="u_frequency" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->frequency->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_frequency" id="u_frequency" value="<?php echo $b_account_info->frequency->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->frequency->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_frequency"><?php echo $b_account_info->frequency->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->frequency->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_frequency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_frequency" data-value-separator="<?php echo $b_account_info->frequency->displayValueSeparatorAttribute() ?>" id="x_frequency" name="x_frequency"<?php echo $b_account_info->frequency->editAttributes() ?>>
		<?php echo $b_account_info->frequency->selectOptionListHtml("x_frequency") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_b_account_info_frequency">
<span<?php echo $b_account_info->frequency->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->frequency->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_frequency" name="x_frequency" id="x_frequency" value="<?php echo HtmlEncode($b_account_info->frequency->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->frequency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->disbursement_amount->Visible) { // disbursement_amount ?>
	<div id="r_disbursement_amount" class="form-group row">
		<label for="x_disbursement_amount" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_disbursement_amount" id="u_disbursement_amount" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->disbursement_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_disbursement_amount" id="u_disbursement_amount" value="<?php echo $b_account_info->disbursement_amount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->disbursement_amount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_disbursement_amount"><?php echo $b_account_info->disbursement_amount->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->disbursement_amount->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_disbursement_amount">
<input type="text" data-table="b_account_info" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info->disbursement_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info->disbursement_amount->EditValue ?>"<?php echo $b_account_info->disbursement_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_disbursement_amount">
<span<?php echo $b_account_info->disbursement_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->disbursement_amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" value="<?php echo HtmlEncode($b_account_info->disbursement_amount->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->disbursement_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_operator" id="u_operator" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_operator" id="u_operator" value="<?php echo $b_account_info->operator->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_operator"><?php echo $b_account_info->operator->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->operator->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el_b_account_info_operator">
<span<?php echo $b_account_info->operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($b_account_info->operator->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_datetime" id="u_datetime" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_datetime" id="u_datetime" value="<?php echo $b_account_info->datetime->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_datetime"><?php echo $b_account_info->datetime->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->datetime->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el_b_account_info_datetime">
<span<?php echo $b_account_info->datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($b_account_info->datetime->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->d_operator->Visible) { // d_operator ?>
	<div id="r_d_operator" class="form-group row">
		<label for="x_d_operator" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_d_operator" id="u_d_operator" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->d_operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_d_operator" id="u_d_operator" value="<?php echo $b_account_info->d_operator->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->d_operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_d_operator"><?php echo $b_account_info->d_operator->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->d_operator->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el_b_account_info_d_operator">
<span<?php echo $b_account_info->d_operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->d_operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_d_operator" name="x_d_operator" id="x_d_operator" value="<?php echo HtmlEncode($b_account_info->d_operator->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->d_operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->d_datetime->Visible) { // d_datetime ?>
	<div id="r_d_datetime" class="form-group row">
		<label for="x_d_datetime" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_d_datetime" id="u_d_datetime" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->d_datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_d_datetime" id="u_d_datetime" value="<?php echo $b_account_info->d_datetime->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->d_datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_d_datetime"><?php echo $b_account_info->d_datetime->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->d_datetime->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el_b_account_info_d_datetime">
<span<?php echo $b_account_info->d_datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->d_datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_d_datetime" name="x_d_datetime" id="x_d_datetime" value="<?php echo HtmlEncode($b_account_info->d_datetime->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->d_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label for="x_no_of_emi" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_no_of_emi" id="u_no_of_emi" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->no_of_emi->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_no_of_emi" id="u_no_of_emi" value="<?php echo $b_account_info->no_of_emi->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->no_of_emi->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_no_of_emi"><?php echo $b_account_info->no_of_emi->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->no_of_emi->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_no_of_emi">
<input type="text" data-table="b_account_info" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_info->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_info->no_of_emi->EditValue ?>"<?php echo $b_account_info->no_of_emi->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_no_of_emi">
<span<?php echo $b_account_info->no_of_emi->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->no_of_emi->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" value="<?php echo HtmlEncode($b_account_info->no_of_emi->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->no_of_emi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->fund_o->Visible) { // fund_o ?>
	<div id="r_fund_o" class="form-group row">
		<label for="x_fund_o" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_fund_o" id="u_fund_o" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->fund_o->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_fund_o" id="u_fund_o" value="<?php echo $b_account_info->fund_o->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->fund_o->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_fund_o"><?php echo $b_account_info->fund_o->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->fund_o->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_fund_o">
<input type="text" data-table="b_account_info" data-field="x_fund_o" name="x_fund_o" id="x_fund_o" size="30" placeholder="<?php echo HtmlEncode($b_account_info->fund_o->getPlaceHolder()) ?>" value="<?php echo $b_account_info->fund_o->EditValue ?>"<?php echo $b_account_info->fund_o->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_fund_o">
<span<?php echo $b_account_info->fund_o->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->fund_o->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_fund_o" name="x_fund_o" id="x_fund_o" value="<?php echo HtmlEncode($b_account_info->fund_o->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->fund_o->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->fund_o_no->Visible) { // fund_o_no ?>
	<div id="r_fund_o_no" class="form-group row">
		<label for="x_fund_o_no" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_fund_o_no" id="u_fund_o_no" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->fund_o_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_fund_o_no" id="u_fund_o_no" value="<?php echo $b_account_info->fund_o_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->fund_o_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_fund_o_no"><?php echo $b_account_info->fund_o_no->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->fund_o_no->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_fund_o_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info" data-field="x_fund_o_no" data-value-separator="<?php echo $b_account_info->fund_o_no->displayValueSeparatorAttribute() ?>" id="x_fund_o_no" name="x_fund_o_no"<?php echo $b_account_info->fund_o_no->editAttributes() ?>>
		<?php echo $b_account_info->fund_o_no->selectOptionListHtml("x_fund_o_no") ?>
	</select>
</div>
<?php echo $b_account_info->fund_o_no->Lookup->getParamTag("p_x_fund_o_no") ?>
</span>
<?php } else { ?>
<span id="el_b_account_info_fund_o_no">
<span<?php echo $b_account_info->fund_o_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->fund_o_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_fund_o_no" name="x_fund_o_no" id="x_fund_o_no" value="<?php echo HtmlEncode($b_account_info->fund_o_no->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->fund_o_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info->int_40->Visible) { // int_@ ?>
	<div id="r_int_40" class="form-group row">
		<label for="x_int_40" class="<?php echo $b_account_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$b_account_info->isConfirm()) { ?>
<input type="checkbox" name="u_int_40" id="u_int_40" class="form-check-input ew-multi-select" value="1"<?php echo ($b_account_info->int_40->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_int_40" id="u_int_40" value="<?php echo $b_account_info->int_40->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($b_account_info->int_40->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_int_40"><?php echo $b_account_info->int_40->caption() ?></label></div></label>
		<div class="<?php echo $b_account_info_update->RightColumnClass ?>"><div<?php echo $b_account_info->int_40->cellAttributes() ?>>
<?php if (!$b_account_info->isConfirm()) { ?>
<span id="el_b_account_info_int_40">
<input type="text" data-table="b_account_info" data-field="x_int_40" name="x_int_40" id="x_int_40" size="30" placeholder="<?php echo HtmlEncode($b_account_info->int_40->getPlaceHolder()) ?>" value="<?php echo $b_account_info->int_40->EditValue ?>"<?php echo $b_account_info->int_40->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_b_account_info_int_40">
<span<?php echo $b_account_info->int_40->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_account_info->int_40->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="b_account_info" data-field="x_int_40" name="x_int_40" id="x_int_40" value="<?php echo HtmlEncode($b_account_info->int_40->FormValue) ?>">
<?php } ?>
<?php echo $b_account_info->int_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$b_account_info_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $b_account_info_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$b_account_info->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $b_account_info_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_info_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_account_info_update->terminate();
?>