<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_int_log_search = new b_account_int_log_search();

// Run the page
$b_account_int_log_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_int_log_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($b_account_int_log_search->IsModal) { ?>
var fb_account_int_logsearch = currentAdvancedSearchForm = new ew.Form("fb_account_int_logsearch", "search");
<?php } else { ?>
var fb_account_int_logsearch = currentForm = new ew.Form("fb_account_int_logsearch", "search");
<?php } ?>

// Form_CustomValidate event
fb_account_int_logsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_int_logsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_int_logsearch.lists["x_account_no"] = <?php echo $b_account_int_log_search->account_no->Lookup->toClientList() ?>;
fb_account_int_logsearch.lists["x_account_no"].options = <?php echo JsonEncode($b_account_int_log_search->account_no->lookupOptions()) ?>;
fb_account_int_logsearch.autoSuggests["x_account_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_int_logsearch.lists["x_status"] = <?php echo $b_account_int_log_search->status->Lookup->toClientList() ?>;
fb_account_int_logsearch.lists["x_status"].options = <?php echo JsonEncode($b_account_int_log_search->status->options(FALSE, TRUE)) ?>;
fb_account_int_logsearch.lists["x_operator"] = <?php echo $b_account_int_log_search->operator->Lookup->toClientList() ?>;
fb_account_int_logsearch.lists["x_operator"].options = <?php echo JsonEncode($b_account_int_log_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fb_account_int_logsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_emi_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->emi_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_emi_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->emi_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_principal");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->principal->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_emi");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->emi->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_interest");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->interest->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deposited");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->deposited->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_int_log->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_int_log_search->showPageHeader(); ?>
<?php
$b_account_int_log_search->showMessage();
?>
<form name="fb_account_int_logsearch" id="fb_account_int_logsearch" class="<?php echo $b_account_int_log_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_int_log_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_int_log_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_int_log">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$b_account_int_log_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($b_account_int_log->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_id"><?php echo $b_account_int_log->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->id->cellAttributes() ?>>
			<span id="el_b_account_int_log_id">
<input type="text" data-table="b_account_int_log" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($b_account_int_log->id->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->id->EditValue ?>"<?php echo $b_account_int_log->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->account_no->Visible) { // account_no ?>
	<div id="r_account_no" class="form-group row">
		<label class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_account_no"><?php echo $b_account_int_log->account_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_account_no" id="z_account_no" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->account_no->cellAttributes() ?>>
			<span id="el_b_account_int_log_account_no">
<?php
$wrkonchange = "" . trim(@$b_account_int_log->account_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$b_account_int_log->account_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_account_no" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_account_no" id="sv_x_account_no" value="<?php echo RemoveHtml($b_account_int_log->account_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->account_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($b_account_int_log->account_no->getPlaceHolder()) ?>"<?php echo $b_account_int_log->account_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($b_account_int_log->account_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_account_no',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($b_account_int_log->account_no->ReadOnly || $b_account_int_log->account_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="b_account_int_log" data-field="x_account_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $b_account_int_log->account_no->displayValueSeparatorAttribute() ?>" name="x_account_no" id="x_account_no" value="<?php echo HtmlEncode($b_account_int_log->account_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fb_account_int_logsearch.createAutoSuggest({"id":"x_account_no","forceSelect":false});
</script>
<?php echo $b_account_int_log->account_no->Lookup->getParamTag("p_x_account_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_status"><?php echo $b_account_int_log->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->status->cellAttributes() ?>>
			<span id="el_b_account_int_log_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_int_log" data-field="x_status" data-value-separator="<?php echo $b_account_int_log->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $b_account_int_log->status->editAttributes() ?>>
		<?php echo $b_account_int_log->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->emi_no->Visible) { // emi_no ?>
	<div id="r_emi_no" class="form-group row">
		<label for="x_emi_no" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_emi_no"><?php echo $b_account_int_log->emi_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emi_no" id="z_emi_no" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->emi_no->cellAttributes() ?>>
			<span id="el_b_account_int_log_emi_no">
<input type="text" data-table="b_account_int_log" data-field="x_emi_no" name="x_emi_no" id="x_emi_no" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->emi_no->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->emi_no->EditValue ?>"<?php echo $b_account_int_log->emi_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->emi_date->Visible) { // emi_date ?>
	<div id="r_emi_date" class="form-group row">
		<label for="x_emi_date" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_emi_date"><?php echo $b_account_int_log->emi_date->caption() ?></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->emi_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_emi_date" id="z_emi_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($b_account_int_log->emi_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_b_account_int_log_emi_date">
<input type="text" data-table="b_account_int_log" data-field="x_emi_date" name="x_emi_date" id="x_emi_date" placeholder="<?php echo HtmlEncode($b_account_int_log->emi_date->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->emi_date->EditValue ?>"<?php echo $b_account_int_log->emi_date->editAttributes() ?>>
<?php if (!$b_account_int_log->emi_date->ReadOnly && !$b_account_int_log->emi_date->Disabled && !isset($b_account_int_log->emi_date->EditAttrs["readonly"]) && !isset($b_account_int_log->emi_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_int_logsearch", "x_emi_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_emi_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_b_account_int_log_emi_date" class="btw1_emi_date d-none">
<input type="text" data-table="b_account_int_log" data-field="x_emi_date" name="y_emi_date" id="y_emi_date" placeholder="<?php echo HtmlEncode($b_account_int_log->emi_date->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->emi_date->EditValue2 ?>"<?php echo $b_account_int_log->emi_date->editAttributes() ?>>
<?php if (!$b_account_int_log->emi_date->ReadOnly && !$b_account_int_log->emi_date->Disabled && !isset($b_account_int_log->emi_date->EditAttrs["readonly"]) && !isset($b_account_int_log->emi_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_int_logsearch", "y_emi_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->principal->Visible) { // principal ?>
	<div id="r_principal" class="form-group row">
		<label for="x_principal" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_principal"><?php echo $b_account_int_log->principal->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_principal" id="z_principal" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->principal->cellAttributes() ?>>
			<span id="el_b_account_int_log_principal">
<input type="text" data-table="b_account_int_log" data-field="x_principal" name="x_principal" id="x_principal" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->principal->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->principal->EditValue ?>"<?php echo $b_account_int_log->principal->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->emi->Visible) { // emi ?>
	<div id="r_emi" class="form-group row">
		<label for="x_emi" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_emi"><?php echo $b_account_int_log->emi->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emi" id="z_emi" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->emi->cellAttributes() ?>>
			<span id="el_b_account_int_log_emi">
<input type="text" data-table="b_account_int_log" data-field="x_emi" name="x_emi" id="x_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->emi->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->emi->EditValue ?>"<?php echo $b_account_int_log->emi->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->interest->Visible) { // interest ?>
	<div id="r_interest" class="form-group row">
		<label for="x_interest" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_interest"><?php echo $b_account_int_log->interest->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_interest" id="z_interest" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->interest->cellAttributes() ?>>
			<span id="el_b_account_int_log_interest">
<input type="text" data-table="b_account_int_log" data-field="x_interest" name="x_interest" id="x_interest" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->interest->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->interest->EditValue ?>"<?php echo $b_account_int_log->interest->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->deposited->Visible) { // deposited ?>
	<div id="r_deposited" class="form-group row">
		<label for="x_deposited" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_deposited"><?php echo $b_account_int_log->deposited->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_deposited" id="z_deposited" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->deposited->cellAttributes() ?>>
			<span id="el_b_account_int_log_deposited">
<input type="text" data-table="b_account_int_log" data-field="x_deposited" name="x_deposited" id="x_deposited" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->deposited->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->deposited->EditValue ?>"<?php echo $b_account_int_log->deposited->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_balance"><?php echo $b_account_int_log->balance->caption() ?></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($b_account_int_log->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_b_account_int_log_balance">
<input type="text" data-table="b_account_int_log" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->balance->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->balance->EditValue ?>"<?php echo $b_account_int_log->balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_b_account_int_log_balance" class="btw1_balance d-none">
<input type="text" data-table="b_account_int_log" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($b_account_int_log->balance->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->balance->EditValue2 ?>"<?php echo $b_account_int_log->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_description"><?php echo $b_account_int_log->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->description->cellAttributes() ?>>
			<span id="el_b_account_int_log_description">
<input type="text" data-table="b_account_int_log" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($b_account_int_log->description->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->description->EditValue ?>"<?php echo $b_account_int_log->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_operator"><?php echo $b_account_int_log->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->operator->cellAttributes() ?>>
			<span id="el_b_account_int_log_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_int_log" data-field="x_operator" data-value-separator="<?php echo $b_account_int_log->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $b_account_int_log->operator->editAttributes() ?>>
		<?php echo $b_account_int_log->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $b_account_int_log->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_int_log->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $b_account_int_log_search->LeftColumnClass ?>"><span id="elh_b_account_int_log_datetime"><?php echo $b_account_int_log->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $b_account_int_log_search->RightColumnClass ?>"><div<?php echo $b_account_int_log->datetime->cellAttributes() ?>>
			<span id="el_b_account_int_log_datetime">
<input type="text" data-table="b_account_int_log" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($b_account_int_log->datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_int_log->datetime->EditValue ?>"<?php echo $b_account_int_log->datetime->editAttributes() ?>>
<?php if (!$b_account_int_log->datetime->ReadOnly && !$b_account_int_log->datetime->Disabled && !isset($b_account_int_log->datetime->EditAttrs["readonly"]) && !isset($b_account_int_log->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_int_logsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_account_int_log_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_account_int_log_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_int_log_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_account_int_log_search->terminate();
?>