<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_type_list = new b_account_type_list();

// Run the page
$b_account_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$b_account_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fb_account_typelist = currentForm = new ew.Form("fb_account_typelist", "list");
fb_account_typelist.formKeyCountName = '<?php echo $b_account_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fb_account_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_typelist.lists["x_grp"] = <?php echo $b_account_type_list->grp->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_grp"].options = <?php echo JsonEncode($b_account_type_list->grp->lookupOptions()) ?>;
fb_account_typelist.lists["x_s_grp"] = <?php echo $b_account_type_list->s_grp->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_s_grp"].options = <?php echo JsonEncode($b_account_type_list->s_grp->lookupOptions()) ?>;
fb_account_typelist.lists["x_repay_frequency"] = <?php echo $b_account_type_list->repay_frequency->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_repay_frequency"].options = <?php echo JsonEncode($b_account_type_list->repay_frequency->options(FALSE, TRUE)) ?>;
fb_account_typelist.lists["x_one_time_charge[]"] = <?php echo $b_account_type_list->one_time_charge->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_one_time_charge[]"].options = <?php echo JsonEncode($b_account_type_list->one_time_charge->lookupOptions()) ?>;
fb_account_typelist.lists["x_action_charge[]"] = <?php echo $b_account_type_list->action_charge->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_action_charge[]"].options = <?php echo JsonEncode($b_account_type_list->action_charge->lookupOptions()) ?>;
fb_account_typelist.lists["x_month_charge[]"] = <?php echo $b_account_type_list->month_charge->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_month_charge[]"].options = <?php echo JsonEncode($b_account_type_list->month_charge->lookupOptions()) ?>;
fb_account_typelist.lists["x_quarter_charge[]"] = <?php echo $b_account_type_list->quarter_charge->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_quarter_charge[]"].options = <?php echo JsonEncode($b_account_type_list->quarter_charge->lookupOptions()) ?>;
fb_account_typelist.lists["x_annual_charge[]"] = <?php echo $b_account_type_list->annual_charge->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_annual_charge[]"].options = <?php echo JsonEncode($b_account_type_list->annual_charge->lookupOptions()) ?>;
fb_account_typelist.lists["x_status"] = <?php echo $b_account_type_list->status->Lookup->toClientList() ?>;
fb_account_typelist.lists["x_status"].options = <?php echo JsonEncode($b_account_type_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fb_account_typelistsrch = currentSearchForm = new ew.Form("fb_account_typelistsrch");

// Filters
fb_account_typelistsrch.filterList = <?php echo $b_account_type_list->getFilterList() ?>;

// Init search panel as collapsed
fb_account_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$b_account_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($b_account_type_list->TotalRecs > 0 && $b_account_type_list->ExportOptions->visible()) { ?>
<?php $b_account_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_type_list->ImportOptions->visible()) { ?>
<?php $b_account_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_type_list->SearchOptions->visible()) { ?>
<?php $b_account_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_type_list->FilterOptions->visible()) { ?>
<?php $b_account_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$b_account_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$b_account_type->isExport() && !$b_account_type->CurrentAction) { ?>
<form name="fb_account_typelistsrch" id="fb_account_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($b_account_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fb_account_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="b_account_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($b_account_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($b_account_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $b_account_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($b_account_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($b_account_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($b_account_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($b_account_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $b_account_type_list->showPageHeader(); ?>
<?php
$b_account_type_list->showMessage();
?>
<?php if ($b_account_type_list->TotalRecs > 0 || $b_account_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($b_account_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> b_account_type">
<?php if (!$b_account_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$b_account_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_type_list->Pager)) $b_account_type_list->Pager = new PrevNextPager($b_account_type_list->StartRec, $b_account_type_list->DisplayRecs, $b_account_type_list->TotalRecs, $b_account_type_list->AutoHidePager) ?>
<?php if ($b_account_type_list->Pager->RecordCount > 0 && $b_account_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_type_list->TotalRecs > 0 && (!$b_account_type_list->AutoHidePageSizeSelector || $b_account_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_account_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_account_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_account_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_account_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fb_account_typelist" id="fb_account_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_type">
<div id="gmp_b_account_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($b_account_type_list->TotalRecs > 0 || $b_account_type->isGridEdit()) { ?>
<table id="tbl_b_account_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$b_account_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$b_account_type_list->renderListOptions();

// Render list options (header, left)
$b_account_type_list->ListOptions->render("header", "left");
?>
<?php if ($b_account_type->id->Visible) { // id ?>
	<?php if ($b_account_type->sortUrl($b_account_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $b_account_type->id->headerCellClass() ?>"><div id="elh_b_account_type_id" class="b_account_type_id"><div class="ew-table-header-caption"><?php echo $b_account_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $b_account_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->id) ?>',2);"><div id="elh_b_account_type_id" class="b_account_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->grp->Visible) { // grp ?>
	<?php if ($b_account_type->sortUrl($b_account_type->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $b_account_type->grp->headerCellClass() ?>"><div id="elh_b_account_type_grp" class="b_account_type_grp"><div class="ew-table-header-caption"><?php echo $b_account_type->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $b_account_type->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->grp) ?>',2);"><div id="elh_b_account_type_grp" class="b_account_type_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->s_grp->Visible) { // s_grp ?>
	<?php if ($b_account_type->sortUrl($b_account_type->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $b_account_type->s_grp->headerCellClass() ?>"><div id="elh_b_account_type_s_grp" class="b_account_type_s_grp"><div class="ew-table-header-caption"><?php echo $b_account_type->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $b_account_type->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->s_grp) ?>',2);"><div id="elh_b_account_type_s_grp" class="b_account_type_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->description->Visible) { // description ?>
	<?php if ($b_account_type->sortUrl($b_account_type->description) == "") { ?>
		<th data-name="description" class="<?php echo $b_account_type->description->headerCellClass() ?>"><div id="elh_b_account_type_description" class="b_account_type_description"><div class="ew-table-header-caption"><?php echo $b_account_type->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $b_account_type->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->description) ?>',2);"><div id="elh_b_account_type_description" class="b_account_type_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->code->Visible) { // code ?>
	<?php if ($b_account_type->sortUrl($b_account_type->code) == "") { ?>
		<th data-name="code" class="<?php echo $b_account_type->code->headerCellClass() ?>"><div id="elh_b_account_type_code" class="b_account_type_code"><div class="ew-table-header-caption"><?php echo $b_account_type->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $b_account_type->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->code) ?>',2);"><div id="elh_b_account_type_code" class="b_account_type_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->code->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->minimum->Visible) { // minimum ?>
	<?php if ($b_account_type->sortUrl($b_account_type->minimum) == "") { ?>
		<th data-name="minimum" class="<?php echo $b_account_type->minimum->headerCellClass() ?>"><div id="elh_b_account_type_minimum" class="b_account_type_minimum"><div class="ew-table-header-caption"><?php echo $b_account_type->minimum->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="minimum" class="<?php echo $b_account_type->minimum->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->minimum) ?>',2);"><div id="elh_b_account_type_minimum" class="b_account_type_minimum">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->minimum->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->minimum->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->minimum->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->maximum->Visible) { // maximum ?>
	<?php if ($b_account_type->sortUrl($b_account_type->maximum) == "") { ?>
		<th data-name="maximum" class="<?php echo $b_account_type->maximum->headerCellClass() ?>"><div id="elh_b_account_type_maximum" class="b_account_type_maximum"><div class="ew-table-header-caption"><?php echo $b_account_type->maximum->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="maximum" class="<?php echo $b_account_type->maximum->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->maximum) ?>',2);"><div id="elh_b_account_type_maximum" class="b_account_type_maximum">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->maximum->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->maximum->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->maximum->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->int_40->Visible) { // int_@ ?>
	<?php if ($b_account_type->sortUrl($b_account_type->int_40) == "") { ?>
		<th data-name="int_40" class="<?php echo $b_account_type->int_40->headerCellClass() ?>"><div id="elh_b_account_type_int_40" class="b_account_type_int_40"><div class="ew-table-header-caption"><?php echo $b_account_type->int_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="int_40" class="<?php echo $b_account_type->int_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->int_40) ?>',2);"><div id="elh_b_account_type_int_40" class="b_account_type_int_40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->int_40->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->int_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->int_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->no_of_emi->Visible) { // no_of_emi ?>
	<?php if ($b_account_type->sortUrl($b_account_type->no_of_emi) == "") { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_type->no_of_emi->headerCellClass() ?>"><div id="elh_b_account_type_no_of_emi" class="b_account_type_no_of_emi"><div class="ew-table-header-caption"><?php echo $b_account_type->no_of_emi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_type->no_of_emi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->no_of_emi) ?>',2);"><div id="elh_b_account_type_no_of_emi" class="b_account_type_no_of_emi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->no_of_emi->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->no_of_emi->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->no_of_emi->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->repay_frequency->Visible) { // repay_frequency ?>
	<?php if ($b_account_type->sortUrl($b_account_type->repay_frequency) == "") { ?>
		<th data-name="repay_frequency" class="<?php echo $b_account_type->repay_frequency->headerCellClass() ?>"><div id="elh_b_account_type_repay_frequency" class="b_account_type_repay_frequency"><div class="ew-table-header-caption"><?php echo $b_account_type->repay_frequency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="repay_frequency" class="<?php echo $b_account_type->repay_frequency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->repay_frequency) ?>',2);"><div id="elh_b_account_type_repay_frequency" class="b_account_type_repay_frequency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->repay_frequency->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->repay_frequency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->repay_frequency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->one_time_charge->Visible) { // one_time_charge ?>
	<?php if ($b_account_type->sortUrl($b_account_type->one_time_charge) == "") { ?>
		<th data-name="one_time_charge" class="<?php echo $b_account_type->one_time_charge->headerCellClass() ?>"><div id="elh_b_account_type_one_time_charge" class="b_account_type_one_time_charge"><div class="ew-table-header-caption"><?php echo $b_account_type->one_time_charge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="one_time_charge" class="<?php echo $b_account_type->one_time_charge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->one_time_charge) ?>',2);"><div id="elh_b_account_type_one_time_charge" class="b_account_type_one_time_charge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->one_time_charge->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->one_time_charge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->one_time_charge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->action_charge->Visible) { // action_charge ?>
	<?php if ($b_account_type->sortUrl($b_account_type->action_charge) == "") { ?>
		<th data-name="action_charge" class="<?php echo $b_account_type->action_charge->headerCellClass() ?>"><div id="elh_b_account_type_action_charge" class="b_account_type_action_charge"><div class="ew-table-header-caption"><?php echo $b_account_type->action_charge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="action_charge" class="<?php echo $b_account_type->action_charge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->action_charge) ?>',2);"><div id="elh_b_account_type_action_charge" class="b_account_type_action_charge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->action_charge->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->action_charge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->action_charge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->month_charge->Visible) { // month_charge ?>
	<?php if ($b_account_type->sortUrl($b_account_type->month_charge) == "") { ?>
		<th data-name="month_charge" class="<?php echo $b_account_type->month_charge->headerCellClass() ?>"><div id="elh_b_account_type_month_charge" class="b_account_type_month_charge"><div class="ew-table-header-caption"><?php echo $b_account_type->month_charge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month_charge" class="<?php echo $b_account_type->month_charge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->month_charge) ?>',2);"><div id="elh_b_account_type_month_charge" class="b_account_type_month_charge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->month_charge->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->month_charge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->month_charge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->quarter_charge->Visible) { // quarter_charge ?>
	<?php if ($b_account_type->sortUrl($b_account_type->quarter_charge) == "") { ?>
		<th data-name="quarter_charge" class="<?php echo $b_account_type->quarter_charge->headerCellClass() ?>"><div id="elh_b_account_type_quarter_charge" class="b_account_type_quarter_charge"><div class="ew-table-header-caption"><?php echo $b_account_type->quarter_charge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quarter_charge" class="<?php echo $b_account_type->quarter_charge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->quarter_charge) ?>',2);"><div id="elh_b_account_type_quarter_charge" class="b_account_type_quarter_charge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->quarter_charge->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->quarter_charge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->quarter_charge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->annual_charge->Visible) { // annual_charge ?>
	<?php if ($b_account_type->sortUrl($b_account_type->annual_charge) == "") { ?>
		<th data-name="annual_charge" class="<?php echo $b_account_type->annual_charge->headerCellClass() ?>"><div id="elh_b_account_type_annual_charge" class="b_account_type_annual_charge"><div class="ew-table-header-caption"><?php echo $b_account_type->annual_charge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="annual_charge" class="<?php echo $b_account_type->annual_charge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->annual_charge) ?>',2);"><div id="elh_b_account_type_annual_charge" class="b_account_type_annual_charge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->annual_charge->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->annual_charge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->annual_charge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->status->Visible) { // status ?>
	<?php if ($b_account_type->sortUrl($b_account_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $b_account_type->status->headerCellClass() ?>"><div id="elh_b_account_type_status" class="b_account_type_status"><div class="ew-table-header-caption"><?php echo $b_account_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $b_account_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->status) ?>',2);"><div id="elh_b_account_type_status" class="b_account_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->operator->Visible) { // operator ?>
	<?php if ($b_account_type->sortUrl($b_account_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $b_account_type->operator->headerCellClass() ?>"><div id="elh_b_account_type_operator" class="b_account_type_operator"><div class="ew-table-header-caption"><?php echo $b_account_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $b_account_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->operator) ?>',2);"><div id="elh_b_account_type_operator" class="b_account_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_type->datetime->Visible) { // datetime ?>
	<?php if ($b_account_type->sortUrl($b_account_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $b_account_type->datetime->headerCellClass() ?>"><div id="elh_b_account_type_datetime" class="b_account_type_datetime"><div class="ew-table-header-caption"><?php echo $b_account_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $b_account_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_type->SortUrl($b_account_type->datetime) ?>',2);"><div id="elh_b_account_type_datetime" class="b_account_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$b_account_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($b_account_type->ExportAll && $b_account_type->isExport()) {
	$b_account_type_list->StopRec = $b_account_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($b_account_type_list->TotalRecs > $b_account_type_list->StartRec + $b_account_type_list->DisplayRecs - 1)
		$b_account_type_list->StopRec = $b_account_type_list->StartRec + $b_account_type_list->DisplayRecs - 1;
	else
		$b_account_type_list->StopRec = $b_account_type_list->TotalRecs;
}
$b_account_type_list->RecCnt = $b_account_type_list->StartRec - 1;
if ($b_account_type_list->Recordset && !$b_account_type_list->Recordset->EOF) {
	$b_account_type_list->Recordset->moveFirst();
	$selectLimit = $b_account_type_list->UseSelectLimit;
	if (!$selectLimit && $b_account_type_list->StartRec > 1)
		$b_account_type_list->Recordset->move($b_account_type_list->StartRec - 1);
} elseif (!$b_account_type->AllowAddDeleteRow && $b_account_type_list->StopRec == 0) {
	$b_account_type_list->StopRec = $b_account_type->GridAddRowCount;
}

// Initialize aggregate
$b_account_type->RowType = ROWTYPE_AGGREGATEINIT;
$b_account_type->resetAttributes();
$b_account_type_list->renderRow();
while ($b_account_type_list->RecCnt < $b_account_type_list->StopRec) {
	$b_account_type_list->RecCnt++;
	if ($b_account_type_list->RecCnt >= $b_account_type_list->StartRec) {
		$b_account_type_list->RowCnt++;

		// Set up key count
		$b_account_type_list->KeyCount = $b_account_type_list->RowIndex;

		// Init row class and style
		$b_account_type->resetAttributes();
		$b_account_type->CssClass = "";
		if ($b_account_type->isGridAdd()) {
		} else {
			$b_account_type_list->loadRowValues($b_account_type_list->Recordset); // Load row values
		}
		$b_account_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$b_account_type->RowAttrs = array_merge($b_account_type->RowAttrs, array('data-rowindex'=>$b_account_type_list->RowCnt, 'id'=>'r' . $b_account_type_list->RowCnt . '_b_account_type', 'data-rowtype'=>$b_account_type->RowType));

		// Render row
		$b_account_type_list->renderRow();

		// Render list options
		$b_account_type_list->renderListOptions();
?>
	<tr<?php echo $b_account_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$b_account_type_list->ListOptions->render("body", "left", $b_account_type_list->RowCnt);
?>
	<?php if ($b_account_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $b_account_type->id->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_id" class="b_account_type_id">
<span<?php echo $b_account_type->id->viewAttributes() ?>>
<?php echo $b_account_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $b_account_type->grp->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_grp" class="b_account_type_grp">
<span<?php echo $b_account_type->grp->viewAttributes() ?>>
<?php echo $b_account_type->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $b_account_type->s_grp->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_s_grp" class="b_account_type_s_grp">
<span<?php echo $b_account_type->s_grp->viewAttributes() ?>>
<?php echo $b_account_type->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->description->Visible) { // description ?>
		<td data-name="description"<?php echo $b_account_type->description->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_description" class="b_account_type_description">
<span<?php echo $b_account_type->description->viewAttributes() ?>>
<?php echo $b_account_type->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->code->Visible) { // code ?>
		<td data-name="code"<?php echo $b_account_type->code->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_code" class="b_account_type_code">
<span<?php echo $b_account_type->code->viewAttributes() ?>>
<?php echo $b_account_type->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->minimum->Visible) { // minimum ?>
		<td data-name="minimum"<?php echo $b_account_type->minimum->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_minimum" class="b_account_type_minimum">
<span<?php echo $b_account_type->minimum->viewAttributes() ?>>
<?php echo $b_account_type->minimum->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->maximum->Visible) { // maximum ?>
		<td data-name="maximum"<?php echo $b_account_type->maximum->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_maximum" class="b_account_type_maximum">
<span<?php echo $b_account_type->maximum->viewAttributes() ?>>
<?php echo $b_account_type->maximum->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->int_40->Visible) { // int_@ ?>
		<td data-name="int_40"<?php echo $b_account_type->int_40->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_int_40" class="b_account_type_int_40">
<span<?php echo $b_account_type->int_40->viewAttributes() ?>>
<?php echo $b_account_type->int_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->no_of_emi->Visible) { // no_of_emi ?>
		<td data-name="no_of_emi"<?php echo $b_account_type->no_of_emi->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_no_of_emi" class="b_account_type_no_of_emi">
<span<?php echo $b_account_type->no_of_emi->viewAttributes() ?>>
<?php echo $b_account_type->no_of_emi->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->repay_frequency->Visible) { // repay_frequency ?>
		<td data-name="repay_frequency"<?php echo $b_account_type->repay_frequency->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_repay_frequency" class="b_account_type_repay_frequency">
<span<?php echo $b_account_type->repay_frequency->viewAttributes() ?>>
<?php echo $b_account_type->repay_frequency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->one_time_charge->Visible) { // one_time_charge ?>
		<td data-name="one_time_charge"<?php echo $b_account_type->one_time_charge->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_one_time_charge" class="b_account_type_one_time_charge">
<span<?php echo $b_account_type->one_time_charge->viewAttributes() ?>>
<?php echo $b_account_type->one_time_charge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->action_charge->Visible) { // action_charge ?>
		<td data-name="action_charge"<?php echo $b_account_type->action_charge->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_action_charge" class="b_account_type_action_charge">
<span<?php echo $b_account_type->action_charge->viewAttributes() ?>>
<?php echo $b_account_type->action_charge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->month_charge->Visible) { // month_charge ?>
		<td data-name="month_charge"<?php echo $b_account_type->month_charge->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_month_charge" class="b_account_type_month_charge">
<span<?php echo $b_account_type->month_charge->viewAttributes() ?>>
<?php echo $b_account_type->month_charge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->quarter_charge->Visible) { // quarter_charge ?>
		<td data-name="quarter_charge"<?php echo $b_account_type->quarter_charge->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_quarter_charge" class="b_account_type_quarter_charge">
<span<?php echo $b_account_type->quarter_charge->viewAttributes() ?>>
<?php echo $b_account_type->quarter_charge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->annual_charge->Visible) { // annual_charge ?>
		<td data-name="annual_charge"<?php echo $b_account_type->annual_charge->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_annual_charge" class="b_account_type_annual_charge">
<span<?php echo $b_account_type->annual_charge->viewAttributes() ?>>
<?php echo $b_account_type->annual_charge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $b_account_type->status->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_status" class="b_account_type_status">
<span<?php echo $b_account_type->status->viewAttributes() ?>>
<?php echo $b_account_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $b_account_type->operator->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_operator" class="b_account_type_operator">
<span<?php echo $b_account_type->operator->viewAttributes() ?>>
<?php echo $b_account_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $b_account_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $b_account_type_list->RowCnt ?>_b_account_type_datetime" class="b_account_type_datetime">
<span<?php echo $b_account_type->datetime->viewAttributes() ?>>
<?php echo $b_account_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$b_account_type_list->ListOptions->render("body", "right", $b_account_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$b_account_type->isGridAdd())
		$b_account_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$b_account_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($b_account_type_list->Recordset)
	$b_account_type_list->Recordset->Close();
?>
<?php if (!$b_account_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$b_account_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_type_list->Pager)) $b_account_type_list->Pager = new PrevNextPager($b_account_type_list->StartRec, $b_account_type_list->DisplayRecs, $b_account_type_list->TotalRecs, $b_account_type_list->AutoHidePager) ?>
<?php if ($b_account_type_list->Pager->RecordCount > 0 && $b_account_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_type_list->pageUrl() ?>start=<?php echo $b_account_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_type_list->TotalRecs > 0 && (!$b_account_type_list->AutoHidePageSizeSelector || $b_account_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_account_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_account_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_account_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_account_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($b_account_type_list->TotalRecs == 0 && !$b_account_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $b_account_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$b_account_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$b_account_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$b_account_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_b_account_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$b_account_type_list->terminate();
?>