<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_type_search = new b_account_type_search();

// Run the page
$b_account_type_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_type_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($b_account_type_search->IsModal) { ?>
var fb_account_typesearch = currentAdvancedSearchForm = new ew.Form("fb_account_typesearch", "search");
<?php } else { ?>
var fb_account_typesearch = currentForm = new ew.Form("fb_account_typesearch", "search");
<?php } ?>

// Form_CustomValidate event
fb_account_typesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_typesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_typesearch.lists["x_location[]"] = <?php echo $b_account_type_search->location->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_location[]"].options = <?php echo JsonEncode($b_account_type_search->location->lookupOptions()) ?>;
fb_account_typesearch.lists["x_grp"] = <?php echo $b_account_type_search->grp->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_grp"].options = <?php echo JsonEncode($b_account_type_search->grp->lookupOptions()) ?>;
fb_account_typesearch.lists["x_s_grp"] = <?php echo $b_account_type_search->s_grp->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_s_grp"].options = <?php echo JsonEncode($b_account_type_search->s_grp->lookupOptions()) ?>;
fb_account_typesearch.lists["x_repay_frequency"] = <?php echo $b_account_type_search->repay_frequency->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_repay_frequency"].options = <?php echo JsonEncode($b_account_type_search->repay_frequency->options(FALSE, TRUE)) ?>;
fb_account_typesearch.lists["x_one_time_charge[]"] = <?php echo $b_account_type_search->one_time_charge->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_one_time_charge[]"].options = <?php echo JsonEncode($b_account_type_search->one_time_charge->lookupOptions()) ?>;
fb_account_typesearch.lists["x_action_charge[]"] = <?php echo $b_account_type_search->action_charge->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_action_charge[]"].options = <?php echo JsonEncode($b_account_type_search->action_charge->lookupOptions()) ?>;
fb_account_typesearch.lists["x_month_charge[]"] = <?php echo $b_account_type_search->month_charge->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_month_charge[]"].options = <?php echo JsonEncode($b_account_type_search->month_charge->lookupOptions()) ?>;
fb_account_typesearch.lists["x_quarter_charge[]"] = <?php echo $b_account_type_search->quarter_charge->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_quarter_charge[]"].options = <?php echo JsonEncode($b_account_type_search->quarter_charge->lookupOptions()) ?>;
fb_account_typesearch.lists["x_annual_charge[]"] = <?php echo $b_account_type_search->annual_charge->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_annual_charge[]"].options = <?php echo JsonEncode($b_account_type_search->annual_charge->lookupOptions()) ?>;
fb_account_typesearch.lists["x_status"] = <?php echo $b_account_type_search->status->Lookup->toClientList() ?>;
fb_account_typesearch.lists["x_status"].options = <?php echo JsonEncode($b_account_type_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fb_account_typesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_type->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_minimum");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_type->minimum->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_maximum");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_type->maximum->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_int_40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_type->int_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_no_of_emi");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_type->no_of_emi->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_type->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_type->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_type_search->showPageHeader(); ?>
<?php
$b_account_type_search->showMessage();
?>
<form name="fb_account_typesearch" id="fb_account_typesearch" class="<?php echo $b_account_type_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_type_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_type_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_type">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$b_account_type_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($b_account_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_id"><?php echo $b_account_type->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->id->cellAttributes() ?>>
			<span id="el_b_account_type_id">
<input type="text" data-table="b_account_type" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($b_account_type->id->getPlaceHolder()) ?>" value="<?php echo $b_account_type->id->EditValue ?>"<?php echo $b_account_type->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_location"><?php echo $b_account_type->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_location" id="z_location" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->location->cellAttributes() ?>>
			<span id="el_b_account_type_location">
<div id="tp_x_location" class="ew-template"><input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_location" data-value-separator="<?php echo $b_account_type->location->displayValueSeparatorAttribute() ?>" name="x_location[]" id="x_location[]" value="{value}"<?php echo $b_account_type->location->editAttributes() ?>></div>
<div id="dsl_x_location" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $b_account_type->location->checkBoxListHtml(FALSE, "x_location[]") ?>
</div></div>
<?php echo $b_account_type->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_grp"><?php echo $b_account_type->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->grp->cellAttributes() ?>>
			<span id="el_b_account_type_grp">
<?php $b_account_type->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$b_account_type->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_type" data-field="x_grp" data-value-separator="<?php echo $b_account_type->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $b_account_type->grp->editAttributes() ?>>
		<?php echo $b_account_type->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $b_account_type->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_s_grp"><?php echo $b_account_type->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->s_grp->cellAttributes() ?>>
			<span id="el_b_account_type_s_grp">
<?php $b_account_type->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$b_account_type->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_type" data-field="x_s_grp" data-value-separator="<?php echo $b_account_type->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $b_account_type->s_grp->editAttributes() ?>>
		<?php echo $b_account_type->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $b_account_type->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_description"><?php echo $b_account_type->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->description->cellAttributes() ?>>
			<span id="el_b_account_type_description">
<input type="text" data-table="b_account_type" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_type->description->getPlaceHolder()) ?>" value="<?php echo $b_account_type->description->EditValue ?>"<?php echo $b_account_type->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_code"><?php echo $b_account_type->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->code->cellAttributes() ?>>
			<span id="el_b_account_type_code">
<input type="text" data-table="b_account_type" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($b_account_type->code->getPlaceHolder()) ?>" value="<?php echo $b_account_type->code->EditValue ?>"<?php echo $b_account_type->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->minimum->Visible) { // minimum ?>
	<div id="r_minimum" class="form-group row">
		<label for="x_minimum" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_minimum"><?php echo $b_account_type->minimum->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_minimum" id="z_minimum" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->minimum->cellAttributes() ?>>
			<span id="el_b_account_type_minimum">
<input type="text" data-table="b_account_type" data-field="x_minimum" name="x_minimum" id="x_minimum" size="30" placeholder="<?php echo HtmlEncode($b_account_type->minimum->getPlaceHolder()) ?>" value="<?php echo $b_account_type->minimum->EditValue ?>"<?php echo $b_account_type->minimum->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->maximum->Visible) { // maximum ?>
	<div id="r_maximum" class="form-group row">
		<label for="x_maximum" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_maximum"><?php echo $b_account_type->maximum->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_maximum" id="z_maximum" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->maximum->cellAttributes() ?>>
			<span id="el_b_account_type_maximum">
<input type="text" data-table="b_account_type" data-field="x_maximum" name="x_maximum" id="x_maximum" size="30" placeholder="<?php echo HtmlEncode($b_account_type->maximum->getPlaceHolder()) ?>" value="<?php echo $b_account_type->maximum->EditValue ?>"<?php echo $b_account_type->maximum->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->int_40->Visible) { // int_@ ?>
	<div id="r_int_40" class="form-group row">
		<label for="x_int_40" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_int_40"><?php echo $b_account_type->int_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_int_40" id="z_int_40" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->int_40->cellAttributes() ?>>
			<span id="el_b_account_type_int_40">
<input type="text" data-table="b_account_type" data-field="x_int_40" name="x_int_40" id="x_int_40" size="30" placeholder="<?php echo HtmlEncode($b_account_type->int_40->getPlaceHolder()) ?>" value="<?php echo $b_account_type->int_40->EditValue ?>"<?php echo $b_account_type->int_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label for="x_no_of_emi" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_no_of_emi"><?php echo $b_account_type->no_of_emi->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no_of_emi" id="z_no_of_emi" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->no_of_emi->cellAttributes() ?>>
			<span id="el_b_account_type_no_of_emi">
<input type="text" data-table="b_account_type" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_type->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_type->no_of_emi->EditValue ?>"<?php echo $b_account_type->no_of_emi->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->repay_frequency->Visible) { // repay_frequency ?>
	<div id="r_repay_frequency" class="form-group row">
		<label for="x_repay_frequency" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_repay_frequency"><?php echo $b_account_type->repay_frequency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_repay_frequency" id="z_repay_frequency" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->repay_frequency->cellAttributes() ?>>
			<span id="el_b_account_type_repay_frequency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_type" data-field="x_repay_frequency" data-value-separator="<?php echo $b_account_type->repay_frequency->displayValueSeparatorAttribute() ?>" id="x_repay_frequency" name="x_repay_frequency"<?php echo $b_account_type->repay_frequency->editAttributes() ?>>
		<?php echo $b_account_type->repay_frequency->selectOptionListHtml("x_repay_frequency") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->one_time_charge->Visible) { // one_time_charge ?>
	<div id="r_one_time_charge" class="form-group row">
		<label class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_one_time_charge"><?php echo $b_account_type->one_time_charge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_one_time_charge" id="z_one_time_charge" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->one_time_charge->cellAttributes() ?>>
			<span id="el_b_account_type_one_time_charge">
<div id="tp_x_one_time_charge" class="ew-template"><input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_one_time_charge" data-value-separator="<?php echo $b_account_type->one_time_charge->displayValueSeparatorAttribute() ?>" name="x_one_time_charge[]" id="x_one_time_charge[]" value="{value}"<?php echo $b_account_type->one_time_charge->editAttributes() ?>></div>
<div id="dsl_x_one_time_charge" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $b_account_type->one_time_charge->checkBoxListHtml(FALSE, "x_one_time_charge[]") ?>
</div></div>
<?php echo $b_account_type->one_time_charge->Lookup->getParamTag("p_x_one_time_charge") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->action_charge->Visible) { // action_charge ?>
	<div id="r_action_charge" class="form-group row">
		<label class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_action_charge"><?php echo $b_account_type->action_charge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_action_charge" id="z_action_charge" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->action_charge->cellAttributes() ?>>
			<span id="el_b_account_type_action_charge">
<div id="tp_x_action_charge" class="ew-template"><input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_action_charge" data-value-separator="<?php echo $b_account_type->action_charge->displayValueSeparatorAttribute() ?>" name="x_action_charge[]" id="x_action_charge[]" value="{value}"<?php echo $b_account_type->action_charge->editAttributes() ?>></div>
<div id="dsl_x_action_charge" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $b_account_type->action_charge->checkBoxListHtml(FALSE, "x_action_charge[]") ?>
</div></div>
<?php echo $b_account_type->action_charge->Lookup->getParamTag("p_x_action_charge") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->month_charge->Visible) { // month_charge ?>
	<div id="r_month_charge" class="form-group row">
		<label class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_month_charge"><?php echo $b_account_type->month_charge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_month_charge" id="z_month_charge" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->month_charge->cellAttributes() ?>>
			<span id="el_b_account_type_month_charge">
<div id="tp_x_month_charge" class="ew-template"><input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_month_charge" data-value-separator="<?php echo $b_account_type->month_charge->displayValueSeparatorAttribute() ?>" name="x_month_charge[]" id="x_month_charge[]" value="{value}"<?php echo $b_account_type->month_charge->editAttributes() ?>></div>
<div id="dsl_x_month_charge" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $b_account_type->month_charge->checkBoxListHtml(FALSE, "x_month_charge[]") ?>
</div></div>
<?php echo $b_account_type->month_charge->Lookup->getParamTag("p_x_month_charge") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->quarter_charge->Visible) { // quarter_charge ?>
	<div id="r_quarter_charge" class="form-group row">
		<label class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_quarter_charge"><?php echo $b_account_type->quarter_charge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_quarter_charge" id="z_quarter_charge" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->quarter_charge->cellAttributes() ?>>
			<span id="el_b_account_type_quarter_charge">
<div id="tp_x_quarter_charge" class="ew-template"><input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_quarter_charge" data-value-separator="<?php echo $b_account_type->quarter_charge->displayValueSeparatorAttribute() ?>" name="x_quarter_charge[]" id="x_quarter_charge[]" value="{value}"<?php echo $b_account_type->quarter_charge->editAttributes() ?>></div>
<div id="dsl_x_quarter_charge" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $b_account_type->quarter_charge->checkBoxListHtml(FALSE, "x_quarter_charge[]") ?>
</div></div>
<?php echo $b_account_type->quarter_charge->Lookup->getParamTag("p_x_quarter_charge") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->annual_charge->Visible) { // annual_charge ?>
	<div id="r_annual_charge" class="form-group row">
		<label class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_annual_charge"><?php echo $b_account_type->annual_charge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_annual_charge" id="z_annual_charge" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->annual_charge->cellAttributes() ?>>
			<span id="el_b_account_type_annual_charge">
<div id="tp_x_annual_charge" class="ew-template"><input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_annual_charge" data-value-separator="<?php echo $b_account_type->annual_charge->displayValueSeparatorAttribute() ?>" name="x_annual_charge[]" id="x_annual_charge[]" value="{value}"<?php echo $b_account_type->annual_charge->editAttributes() ?>></div>
<div id="dsl_x_annual_charge" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $b_account_type->annual_charge->checkBoxListHtml(FALSE, "x_annual_charge[]") ?>
</div></div>
<?php echo $b_account_type->annual_charge->Lookup->getParamTag("p_x_annual_charge") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_status"><?php echo $b_account_type->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->status->cellAttributes() ?>>
			<span id="el_b_account_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_type" data-field="x_status" data-value-separator="<?php echo $b_account_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $b_account_type->status->editAttributes() ?>>
		<?php echo $b_account_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_operator"><?php echo $b_account_type->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->operator->cellAttributes() ?>>
			<span id="el_b_account_type_operator">
<input type="text" data-table="b_account_type" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($b_account_type->operator->getPlaceHolder()) ?>" value="<?php echo $b_account_type->operator->EditValue ?>"<?php echo $b_account_type->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_type->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $b_account_type_search->LeftColumnClass ?>"><span id="elh_b_account_type_datetime"><?php echo $b_account_type->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $b_account_type_search->RightColumnClass ?>"><div<?php echo $b_account_type->datetime->cellAttributes() ?>>
			<span id="el_b_account_type_datetime">
<input type="text" data-table="b_account_type" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($b_account_type->datetime->getPlaceHolder()) ?>" value="<?php echo $b_account_type->datetime->EditValue ?>"<?php echo $b_account_type->datetime->editAttributes() ?>>
<?php if (!$b_account_type->datetime->ReadOnly && !$b_account_type->datetime->Disabled && !isset($b_account_type->datetime->EditAttrs["readonly"]) && !isset($b_account_type->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_typesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_account_type_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_account_type_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_type_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_account_type_search->terminate();
?>