<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_charges_plan_list = new b_charges_plan_list();

// Run the page
$b_charges_plan_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_charges_plan_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$b_charges_plan->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fb_charges_planlist = currentForm = new ew.Form("fb_charges_planlist", "list");
fb_charges_planlist.formKeyCountName = '<?php echo $b_charges_plan_list->FormKeyCountName ?>';

// Form_CustomValidate event
fb_charges_planlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_charges_planlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_charges_planlist.lists["x_location[]"] = <?php echo $b_charges_plan_list->location->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_location[]"].options = <?php echo JsonEncode($b_charges_plan_list->location->lookupOptions()) ?>;
fb_charges_planlist.lists["x_grp[]"] = <?php echo $b_charges_plan_list->grp->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_grp[]"].options = <?php echo JsonEncode($b_charges_plan_list->grp->lookupOptions()) ?>;
fb_charges_planlist.lists["x_s_grp[]"] = <?php echo $b_charges_plan_list->s_grp->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_s_grp[]"].options = <?php echo JsonEncode($b_charges_plan_list->s_grp->lookupOptions()) ?>;
fb_charges_planlist.lists["x_plan_type"] = <?php echo $b_charges_plan_list->plan_type->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_plan_type"].options = <?php echo JsonEncode($b_charges_plan_list->plan_type->lookupOptions()) ?>;
fb_charges_planlist.lists["x_method"] = <?php echo $b_charges_plan_list->method->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_method"].options = <?php echo JsonEncode($b_charges_plan_list->method->lookupOptions()) ?>;
fb_charges_planlist.lists["x_fix"] = <?php echo $b_charges_plan_list->fix->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_fix"].options = <?php echo JsonEncode($b_charges_plan_list->fix->options(FALSE, TRUE)) ?>;
fb_charges_planlist.lists["x_status"] = <?php echo $b_charges_plan_list->status->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_status"].options = <?php echo JsonEncode($b_charges_plan_list->status->options(FALSE, TRUE)) ?>;
fb_charges_planlist.lists["x_operator"] = <?php echo $b_charges_plan_list->operator->Lookup->toClientList() ?>;
fb_charges_planlist.lists["x_operator"].options = <?php echo JsonEncode($b_charges_plan_list->operator->lookupOptions()) ?>;

// Form object for search
var fb_charges_planlistsrch = currentSearchForm = new ew.Form("fb_charges_planlistsrch");

// Validate function for search
fb_charges_planlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_charges_plan->_40->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fb_charges_planlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_charges_planlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_charges_planlistsrch.lists["x_status"] = <?php echo $b_charges_plan_list->status->Lookup->toClientList() ?>;
fb_charges_planlistsrch.lists["x_status"].options = <?php echo JsonEncode($b_charges_plan_list->status->options(FALSE, TRUE)) ?>;

// Filters
fb_charges_planlistsrch.filterList = <?php echo $b_charges_plan_list->getFilterList() ?>;

// Init search panel as collapsed
fb_charges_planlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$b_charges_plan->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($b_charges_plan_list->TotalRecs > 0 && $b_charges_plan_list->ExportOptions->visible()) { ?>
<?php $b_charges_plan_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($b_charges_plan_list->ImportOptions->visible()) { ?>
<?php $b_charges_plan_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($b_charges_plan_list->SearchOptions->visible()) { ?>
<?php $b_charges_plan_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($b_charges_plan_list->FilterOptions->visible()) { ?>
<?php $b_charges_plan_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$b_charges_plan_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$b_charges_plan->isExport() && !$b_charges_plan->CurrentAction) { ?>
<form name="fb_charges_planlistsrch" id="fb_charges_planlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($b_charges_plan_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fb_charges_planlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="b_charges_plan">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$b_charges_plan_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$b_charges_plan->RowType = ROWTYPE_SEARCH;

// Render row
$b_charges_plan->resetAttributes();
$b_charges_plan_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($b_charges_plan->_40->Visible) { // @ ?>
	<div id="xsc__40" class="ew-cell form-group">
		<label for="x__40" class="ew-search-caption ew-label"><?php echo $b_charges_plan->_40->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="b_charges_plan" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($b_charges_plan->_40->getPlaceHolder()) ?>" value="<?php echo $b_charges_plan->_40->EditValue ?>"<?php echo $b_charges_plan->_40->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($b_charges_plan->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $b_charges_plan->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_charges_plan" data-field="x_status" data-value-separator="<?php echo $b_charges_plan->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $b_charges_plan->status->editAttributes() ?>>
		<?php echo $b_charges_plan->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($b_charges_plan_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($b_charges_plan_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $b_charges_plan_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($b_charges_plan_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($b_charges_plan_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($b_charges_plan_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($b_charges_plan_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $b_charges_plan_list->showPageHeader(); ?>
<?php
$b_charges_plan_list->showMessage();
?>
<?php if ($b_charges_plan_list->TotalRecs > 0 || $b_charges_plan->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($b_charges_plan_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> b_charges_plan">
<?php if (!$b_charges_plan->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$b_charges_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_charges_plan_list->Pager)) $b_charges_plan_list->Pager = new PrevNextPager($b_charges_plan_list->StartRec, $b_charges_plan_list->DisplayRecs, $b_charges_plan_list->TotalRecs, $b_charges_plan_list->AutoHidePager) ?>
<?php if ($b_charges_plan_list->Pager->RecordCount > 0 && $b_charges_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_charges_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_charges_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_charges_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_charges_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_charges_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_charges_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_charges_plan_list->TotalRecs > 0 && (!$b_charges_plan_list->AutoHidePageSizeSelector || $b_charges_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_charges_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_charges_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_charges_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_charges_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_charges_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_charges_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_charges_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_charges_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fb_charges_planlist" id="fb_charges_planlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_charges_plan_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_charges_plan_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_charges_plan">
<div id="gmp_b_charges_plan" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($b_charges_plan_list->TotalRecs > 0 || $b_charges_plan->isGridEdit()) { ?>
<table id="tbl_b_charges_planlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$b_charges_plan_list->RowType = ROWTYPE_HEADER;

// Render list options
$b_charges_plan_list->renderListOptions();

// Render list options (header, left)
$b_charges_plan_list->ListOptions->render("header", "left");
?>
<?php if ($b_charges_plan->id->Visible) { // id ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->id) == "") { ?>
		<th data-name="id" class="<?php echo $b_charges_plan->id->headerCellClass() ?>"><div id="elh_b_charges_plan_id" class="b_charges_plan_id"><div class="ew-table-header-caption"><?php echo $b_charges_plan->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $b_charges_plan->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->id) ?>',2);"><div id="elh_b_charges_plan_id" class="b_charges_plan_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->location->Visible) { // location ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->location) == "") { ?>
		<th data-name="location" class="<?php echo $b_charges_plan->location->headerCellClass() ?>"><div id="elh_b_charges_plan_location" class="b_charges_plan_location"><div class="ew-table-header-caption"><?php echo $b_charges_plan->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $b_charges_plan->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->location) ?>',2);"><div id="elh_b_charges_plan_location" class="b_charges_plan_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->grp->Visible) { // grp ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $b_charges_plan->grp->headerCellClass() ?>"><div id="elh_b_charges_plan_grp" class="b_charges_plan_grp"><div class="ew-table-header-caption"><?php echo $b_charges_plan->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $b_charges_plan->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->grp) ?>',2);"><div id="elh_b_charges_plan_grp" class="b_charges_plan_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->s_grp->Visible) { // s_grp ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $b_charges_plan->s_grp->headerCellClass() ?>"><div id="elh_b_charges_plan_s_grp" class="b_charges_plan_s_grp"><div class="ew-table-header-caption"><?php echo $b_charges_plan->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $b_charges_plan->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->s_grp) ?>',2);"><div id="elh_b_charges_plan_s_grp" class="b_charges_plan_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->description->Visible) { // description ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->description) == "") { ?>
		<th data-name="description" class="<?php echo $b_charges_plan->description->headerCellClass() ?>"><div id="elh_b_charges_plan_description" class="b_charges_plan_description"><div class="ew-table-header-caption"><?php echo $b_charges_plan->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $b_charges_plan->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->description) ?>',2);"><div id="elh_b_charges_plan_description" class="b_charges_plan_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->plan_type->Visible) { // plan_type ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->plan_type) == "") { ?>
		<th data-name="plan_type" class="<?php echo $b_charges_plan->plan_type->headerCellClass() ?>"><div id="elh_b_charges_plan_plan_type" class="b_charges_plan_plan_type"><div class="ew-table-header-caption"><?php echo $b_charges_plan->plan_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plan_type" class="<?php echo $b_charges_plan->plan_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->plan_type) ?>',2);"><div id="elh_b_charges_plan_plan_type" class="b_charges_plan_plan_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->plan_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->plan_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->plan_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->method->Visible) { // method ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->method) == "") { ?>
		<th data-name="method" class="<?php echo $b_charges_plan->method->headerCellClass() ?>"><div id="elh_b_charges_plan_method" class="b_charges_plan_method"><div class="ew-table-header-caption"><?php echo $b_charges_plan->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $b_charges_plan->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->method) ?>',2);"><div id="elh_b_charges_plan_method" class="b_charges_plan_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->fix->Visible) { // fix ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->fix) == "") { ?>
		<th data-name="fix" class="<?php echo $b_charges_plan->fix->headerCellClass() ?>"><div id="elh_b_charges_plan_fix" class="b_charges_plan_fix"><div class="ew-table-header-caption"><?php echo $b_charges_plan->fix->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fix" class="<?php echo $b_charges_plan->fix->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->fix) ?>',2);"><div id="elh_b_charges_plan_fix" class="b_charges_plan_fix">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->fix->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->fix->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->fix->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->_40->Visible) { // @ ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $b_charges_plan->_40->headerCellClass() ?>"><div id="elh_b_charges_plan__40" class="b_charges_plan__40"><div class="ew-table-header-caption"><?php echo $b_charges_plan->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $b_charges_plan->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->_40) ?>',2);"><div id="elh_b_charges_plan__40" class="b_charges_plan__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->_40->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->min_range->Visible) { // min_range ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->min_range) == "") { ?>
		<th data-name="min_range" class="<?php echo $b_charges_plan->min_range->headerCellClass() ?>"><div id="elh_b_charges_plan_min_range" class="b_charges_plan_min_range"><div class="ew-table-header-caption"><?php echo $b_charges_plan->min_range->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="min_range" class="<?php echo $b_charges_plan->min_range->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->min_range) ?>',2);"><div id="elh_b_charges_plan_min_range" class="b_charges_plan_min_range">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->min_range->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->min_range->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->min_range->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->max_range->Visible) { // max_range ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->max_range) == "") { ?>
		<th data-name="max_range" class="<?php echo $b_charges_plan->max_range->headerCellClass() ?>"><div id="elh_b_charges_plan_max_range" class="b_charges_plan_max_range"><div class="ew-table-header-caption"><?php echo $b_charges_plan->max_range->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_range" class="<?php echo $b_charges_plan->max_range->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->max_range) ?>',2);"><div id="elh_b_charges_plan_max_range" class="b_charges_plan_max_range">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->max_range->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->max_range->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->max_range->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->status->Visible) { // status ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->status) == "") { ?>
		<th data-name="status" class="<?php echo $b_charges_plan->status->headerCellClass() ?>"><div id="elh_b_charges_plan_status" class="b_charges_plan_status"><div class="ew-table-header-caption"><?php echo $b_charges_plan->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $b_charges_plan->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->status) ?>',2);"><div id="elh_b_charges_plan_status" class="b_charges_plan_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->operator->Visible) { // operator ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $b_charges_plan->operator->headerCellClass() ?>"><div id="elh_b_charges_plan_operator" class="b_charges_plan_operator"><div class="ew-table-header-caption"><?php echo $b_charges_plan->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $b_charges_plan->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->operator) ?>',2);"><div id="elh_b_charges_plan_operator" class="b_charges_plan_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_charges_plan->datetime->Visible) { // datetime ?>
	<?php if ($b_charges_plan->sortUrl($b_charges_plan->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $b_charges_plan->datetime->headerCellClass() ?>"><div id="elh_b_charges_plan_datetime" class="b_charges_plan_datetime"><div class="ew-table-header-caption"><?php echo $b_charges_plan->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $b_charges_plan->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_charges_plan->SortUrl($b_charges_plan->datetime) ?>',2);"><div id="elh_b_charges_plan_datetime" class="b_charges_plan_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_charges_plan->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_charges_plan->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_charges_plan->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$b_charges_plan_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($b_charges_plan->ExportAll && $b_charges_plan->isExport()) {
	$b_charges_plan_list->StopRec = $b_charges_plan_list->TotalRecs;
} else {

	// Set the last record to display
	if ($b_charges_plan_list->TotalRecs > $b_charges_plan_list->StartRec + $b_charges_plan_list->DisplayRecs - 1)
		$b_charges_plan_list->StopRec = $b_charges_plan_list->StartRec + $b_charges_plan_list->DisplayRecs - 1;
	else
		$b_charges_plan_list->StopRec = $b_charges_plan_list->TotalRecs;
}
$b_charges_plan_list->RecCnt = $b_charges_plan_list->StartRec - 1;
if ($b_charges_plan_list->Recordset && !$b_charges_plan_list->Recordset->EOF) {
	$b_charges_plan_list->Recordset->moveFirst();
	$selectLimit = $b_charges_plan_list->UseSelectLimit;
	if (!$selectLimit && $b_charges_plan_list->StartRec > 1)
		$b_charges_plan_list->Recordset->move($b_charges_plan_list->StartRec - 1);
} elseif (!$b_charges_plan->AllowAddDeleteRow && $b_charges_plan_list->StopRec == 0) {
	$b_charges_plan_list->StopRec = $b_charges_plan->GridAddRowCount;
}

// Initialize aggregate
$b_charges_plan->RowType = ROWTYPE_AGGREGATEINIT;
$b_charges_plan->resetAttributes();
$b_charges_plan_list->renderRow();
while ($b_charges_plan_list->RecCnt < $b_charges_plan_list->StopRec) {
	$b_charges_plan_list->RecCnt++;
	if ($b_charges_plan_list->RecCnt >= $b_charges_plan_list->StartRec) {
		$b_charges_plan_list->RowCnt++;

		// Set up key count
		$b_charges_plan_list->KeyCount = $b_charges_plan_list->RowIndex;

		// Init row class and style
		$b_charges_plan->resetAttributes();
		$b_charges_plan->CssClass = "";
		if ($b_charges_plan->isGridAdd()) {
		} else {
			$b_charges_plan_list->loadRowValues($b_charges_plan_list->Recordset); // Load row values
		}
		$b_charges_plan->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$b_charges_plan->RowAttrs = array_merge($b_charges_plan->RowAttrs, array('data-rowindex'=>$b_charges_plan_list->RowCnt, 'id'=>'r' . $b_charges_plan_list->RowCnt . '_b_charges_plan', 'data-rowtype'=>$b_charges_plan->RowType));

		// Render row
		$b_charges_plan_list->renderRow();

		// Render list options
		$b_charges_plan_list->renderListOptions();
?>
	<tr<?php echo $b_charges_plan->rowAttributes() ?>>
<?php

// Render list options (body, left)
$b_charges_plan_list->ListOptions->render("body", "left", $b_charges_plan_list->RowCnt);
?>
	<?php if ($b_charges_plan->id->Visible) { // id ?>
		<td data-name="id"<?php echo $b_charges_plan->id->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_id" class="b_charges_plan_id">
<span<?php echo $b_charges_plan->id->viewAttributes() ?>>
<?php echo $b_charges_plan->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->location->Visible) { // location ?>
		<td data-name="location"<?php echo $b_charges_plan->location->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_location" class="b_charges_plan_location">
<span<?php echo $b_charges_plan->location->viewAttributes() ?>>
<?php echo $b_charges_plan->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $b_charges_plan->grp->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_grp" class="b_charges_plan_grp">
<span<?php echo $b_charges_plan->grp->viewAttributes() ?>>
<?php echo $b_charges_plan->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $b_charges_plan->s_grp->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_s_grp" class="b_charges_plan_s_grp">
<span<?php echo $b_charges_plan->s_grp->viewAttributes() ?>>
<?php echo $b_charges_plan->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->description->Visible) { // description ?>
		<td data-name="description"<?php echo $b_charges_plan->description->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_description" class="b_charges_plan_description">
<span<?php echo $b_charges_plan->description->viewAttributes() ?>>
<?php echo $b_charges_plan->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->plan_type->Visible) { // plan_type ?>
		<td data-name="plan_type"<?php echo $b_charges_plan->plan_type->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_plan_type" class="b_charges_plan_plan_type">
<span<?php echo $b_charges_plan->plan_type->viewAttributes() ?>>
<?php if ((!EmptyString($b_charges_plan->plan_type->getViewValue())) && $b_charges_plan->plan_type->linkAttributes() <> "") { ?>
<a<?php echo $b_charges_plan->plan_type->linkAttributes() ?>><?php echo $b_charges_plan->plan_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $b_charges_plan->plan_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->method->Visible) { // method ?>
		<td data-name="method"<?php echo $b_charges_plan->method->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_method" class="b_charges_plan_method">
<span<?php echo $b_charges_plan->method->viewAttributes() ?>>
<?php echo $b_charges_plan->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->fix->Visible) { // fix ?>
		<td data-name="fix"<?php echo $b_charges_plan->fix->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_fix" class="b_charges_plan_fix">
<span<?php echo $b_charges_plan->fix->viewAttributes() ?>>
<?php echo $b_charges_plan->fix->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $b_charges_plan->_40->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan__40" class="b_charges_plan__40">
<span<?php echo $b_charges_plan->_40->viewAttributes() ?>>
<?php echo $b_charges_plan->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->min_range->Visible) { // min_range ?>
		<td data-name="min_range"<?php echo $b_charges_plan->min_range->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_min_range" class="b_charges_plan_min_range">
<span<?php echo $b_charges_plan->min_range->viewAttributes() ?>>
<?php echo $b_charges_plan->min_range->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->max_range->Visible) { // max_range ?>
		<td data-name="max_range"<?php echo $b_charges_plan->max_range->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_max_range" class="b_charges_plan_max_range">
<span<?php echo $b_charges_plan->max_range->viewAttributes() ?>>
<?php echo $b_charges_plan->max_range->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->status->Visible) { // status ?>
		<td data-name="status"<?php echo $b_charges_plan->status->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_status" class="b_charges_plan_status">
<span<?php echo $b_charges_plan->status->viewAttributes() ?>>
<?php echo $b_charges_plan->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $b_charges_plan->operator->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_operator" class="b_charges_plan_operator">
<span<?php echo $b_charges_plan->operator->viewAttributes() ?>>
<?php echo $b_charges_plan->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_charges_plan->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $b_charges_plan->datetime->cellAttributes() ?>>
<span id="el<?php echo $b_charges_plan_list->RowCnt ?>_b_charges_plan_datetime" class="b_charges_plan_datetime">
<span<?php echo $b_charges_plan->datetime->viewAttributes() ?>>
<?php echo $b_charges_plan->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$b_charges_plan_list->ListOptions->render("body", "right", $b_charges_plan_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$b_charges_plan->isGridAdd())
		$b_charges_plan_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$b_charges_plan->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($b_charges_plan_list->Recordset)
	$b_charges_plan_list->Recordset->Close();
?>
<?php if (!$b_charges_plan->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$b_charges_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_charges_plan_list->Pager)) $b_charges_plan_list->Pager = new PrevNextPager($b_charges_plan_list->StartRec, $b_charges_plan_list->DisplayRecs, $b_charges_plan_list->TotalRecs, $b_charges_plan_list->AutoHidePager) ?>
<?php if ($b_charges_plan_list->Pager->RecordCount > 0 && $b_charges_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_charges_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_charges_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_charges_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_charges_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_charges_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_charges_plan_list->pageUrl() ?>start=<?php echo $b_charges_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_charges_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_charges_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_charges_plan_list->TotalRecs > 0 && (!$b_charges_plan_list->AutoHidePageSizeSelector || $b_charges_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_charges_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_charges_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_charges_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_charges_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_charges_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_charges_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_charges_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_charges_plan_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($b_charges_plan_list->TotalRecs == 0 && !$b_charges_plan->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $b_charges_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$b_charges_plan_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$b_charges_plan->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$b_charges_plan->isExport()) { ?>
<script>
ew.scrollableTable("gmp_b_charges_plan", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$b_charges_plan_list->terminate();
?>