<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_incentive_list = new b_incentive_list();

// Run the page
$b_incentive_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_incentive_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$b_incentive->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fb_incentivelist = currentForm = new ew.Form("fb_incentivelist", "list");
fb_incentivelist.formKeyCountName = '<?php echo $b_incentive_list->FormKeyCountName ?>';

// Form_CustomValidate event
fb_incentivelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_incentivelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_incentivelist.lists["x_category"] = <?php echo $b_incentive_list->category->Lookup->toClientList() ?>;
fb_incentivelist.lists["x_category"].options = <?php echo JsonEncode($b_incentive_list->category->lookupOptions()) ?>;
fb_incentivelist.lists["x_type"] = <?php echo $b_incentive_list->type->Lookup->toClientList() ?>;
fb_incentivelist.lists["x_type"].options = <?php echo JsonEncode($b_incentive_list->type->lookupOptions()) ?>;

// Form object for search
var fb_incentivelistsrch = currentSearchForm = new ew.Form("fb_incentivelistsrch");

// Filters
fb_incentivelistsrch.filterList = <?php echo $b_incentive_list->getFilterList() ?>;

// Init search panel as collapsed
fb_incentivelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$b_incentive->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($b_incentive_list->TotalRecs > 0 && $b_incentive_list->ExportOptions->visible()) { ?>
<?php $b_incentive_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($b_incentive_list->ImportOptions->visible()) { ?>
<?php $b_incentive_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($b_incentive_list->SearchOptions->visible()) { ?>
<?php $b_incentive_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($b_incentive_list->FilterOptions->visible()) { ?>
<?php $b_incentive_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$b_incentive_list->renderOtherOptions();
?>
<?php $b_incentive_list->showPageHeader(); ?>
<?php
$b_incentive_list->showMessage();
?>
<?php if ($b_incentive_list->TotalRecs > 0 || $b_incentive->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($b_incentive_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> b_incentive">
<?php if (!$b_incentive->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$b_incentive->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_incentive_list->Pager)) $b_incentive_list->Pager = new PrevNextPager($b_incentive_list->StartRec, $b_incentive_list->DisplayRecs, $b_incentive_list->TotalRecs, $b_incentive_list->AutoHidePager) ?>
<?php if ($b_incentive_list->Pager->RecordCount > 0 && $b_incentive_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_incentive_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_incentive_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_incentive_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_incentive_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_incentive_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_incentive_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_incentive_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_incentive_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_incentive_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_incentive_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_incentive_list->TotalRecs > 0 && (!$b_incentive_list->AutoHidePageSizeSelector || $b_incentive_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_incentive">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_incentive_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_incentive_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_incentive_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_incentive_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_incentive_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_incentive->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_incentive_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fb_incentivelist" id="fb_incentivelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_incentive_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_incentive_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_incentive">
<div id="gmp_b_incentive" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($b_incentive_list->TotalRecs > 0 || $b_incentive->isGridEdit()) { ?>
<table id="tbl_b_incentivelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$b_incentive_list->RowType = ROWTYPE_HEADER;

// Render list options
$b_incentive_list->renderListOptions();

// Render list options (header, left)
$b_incentive_list->ListOptions->render("header", "left");
?>
<?php if ($b_incentive->id->Visible) { // id ?>
	<?php if ($b_incentive->sortUrl($b_incentive->id) == "") { ?>
		<th data-name="id" class="<?php echo $b_incentive->id->headerCellClass() ?>"><div id="elh_b_incentive_id" class="b_incentive_id"><div class="ew-table-header-caption"><?php echo $b_incentive->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $b_incentive->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->id) ?>',2);"><div id="elh_b_incentive_id" class="b_incentive_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->category->Visible) { // category ?>
	<?php if ($b_incentive->sortUrl($b_incentive->category) == "") { ?>
		<th data-name="category" class="<?php echo $b_incentive->category->headerCellClass() ?>"><div id="elh_b_incentive_category" class="b_incentive_category"><div class="ew-table-header-caption"><?php echo $b_incentive->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $b_incentive->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->category) ?>',2);"><div id="elh_b_incentive_category" class="b_incentive_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->type->Visible) { // type ?>
	<?php if ($b_incentive->sortUrl($b_incentive->type) == "") { ?>
		<th data-name="type" class="<?php echo $b_incentive->type->headerCellClass() ?>"><div id="elh_b_incentive_type" class="b_incentive_type"><div class="ew-table-header-caption"><?php echo $b_incentive->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $b_incentive->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->type) ?>',2);"><div id="elh_b_incentive_type" class="b_incentive_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->target_amount->Visible) { // target_amount ?>
	<?php if ($b_incentive->sortUrl($b_incentive->target_amount) == "") { ?>
		<th data-name="target_amount" class="<?php echo $b_incentive->target_amount->headerCellClass() ?>"><div id="elh_b_incentive_target_amount" class="b_incentive_target_amount"><div class="ew-table-header-caption"><?php echo $b_incentive->target_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="target_amount" class="<?php echo $b_incentive->target_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->target_amount) ?>',2);"><div id="elh_b_incentive_target_amount" class="b_incentive_target_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->target_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->target_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->target_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->target_file->Visible) { // target_file ?>
	<?php if ($b_incentive->sortUrl($b_incentive->target_file) == "") { ?>
		<th data-name="target_file" class="<?php echo $b_incentive->target_file->headerCellClass() ?>"><div id="elh_b_incentive_target_file" class="b_incentive_target_file"><div class="ew-table-header-caption"><?php echo $b_incentive->target_file->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="target_file" class="<?php echo $b_incentive->target_file->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->target_file) ?>',2);"><div id="elh_b_incentive_target_file" class="b_incentive_target_file">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->target_file->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->target_file->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->target_file->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->file_inc->Visible) { // file_inc ?>
	<?php if ($b_incentive->sortUrl($b_incentive->file_inc) == "") { ?>
		<th data-name="file_inc" class="<?php echo $b_incentive->file_inc->headerCellClass() ?>"><div id="elh_b_incentive_file_inc" class="b_incentive_file_inc"><div class="ew-table-header-caption"><?php echo $b_incentive->file_inc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="file_inc" class="<?php echo $b_incentive->file_inc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->file_inc) ?>',2);"><div id="elh_b_incentive_file_inc" class="b_incentive_file_inc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->file_inc->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->file_inc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->file_inc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->neg_file_inc->Visible) { // neg_file_inc ?>
	<?php if ($b_incentive->sortUrl($b_incentive->neg_file_inc) == "") { ?>
		<th data-name="neg_file_inc" class="<?php echo $b_incentive->neg_file_inc->headerCellClass() ?>"><div id="elh_b_incentive_neg_file_inc" class="b_incentive_neg_file_inc"><div class="ew-table-header-caption"><?php echo $b_incentive->neg_file_inc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="neg_file_inc" class="<?php echo $b_incentive->neg_file_inc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->neg_file_inc) ?>',2);"><div id="elh_b_incentive_neg_file_inc" class="b_incentive_neg_file_inc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->neg_file_inc->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->neg_file_inc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->neg_file_inc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->inc_min_amount->Visible) { // inc_min_amount ?>
	<?php if ($b_incentive->sortUrl($b_incentive->inc_min_amount) == "") { ?>
		<th data-name="inc_min_amount" class="<?php echo $b_incentive->inc_min_amount->headerCellClass() ?>"><div id="elh_b_incentive_inc_min_amount" class="b_incentive_inc_min_amount"><div class="ew-table-header-caption"><?php echo $b_incentive->inc_min_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="inc_min_amount" class="<?php echo $b_incentive->inc_min_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->inc_min_amount) ?>',2);"><div id="elh_b_incentive_inc_min_amount" class="b_incentive_inc_min_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->inc_min_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->inc_min_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->inc_min_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->inc_max_amount->Visible) { // inc_max_amount ?>
	<?php if ($b_incentive->sortUrl($b_incentive->inc_max_amount) == "") { ?>
		<th data-name="inc_max_amount" class="<?php echo $b_incentive->inc_max_amount->headerCellClass() ?>"><div id="elh_b_incentive_inc_max_amount" class="b_incentive_inc_max_amount"><div class="ew-table-header-caption"><?php echo $b_incentive->inc_max_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="inc_max_amount" class="<?php echo $b_incentive->inc_max_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->inc_max_amount) ?>',2);"><div id="elh_b_incentive_inc_max_amount" class="b_incentive_inc_max_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->inc_max_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->inc_max_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->inc_max_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->inc_percent->Visible) { // inc_percent ?>
	<?php if ($b_incentive->sortUrl($b_incentive->inc_percent) == "") { ?>
		<th data-name="inc_percent" class="<?php echo $b_incentive->inc_percent->headerCellClass() ?>"><div id="elh_b_incentive_inc_percent" class="b_incentive_inc_percent"><div class="ew-table-header-caption"><?php echo $b_incentive->inc_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="inc_percent" class="<?php echo $b_incentive->inc_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->inc_percent) ?>',2);"><div id="elh_b_incentive_inc_percent" class="b_incentive_inc_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->inc_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->inc_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->inc_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->operator->Visible) { // operator ?>
	<?php if ($b_incentive->sortUrl($b_incentive->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $b_incentive->operator->headerCellClass() ?>"><div id="elh_b_incentive_operator" class="b_incentive_operator"><div class="ew-table-header-caption"><?php echo $b_incentive->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $b_incentive->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->operator) ?>',2);"><div id="elh_b_incentive_operator" class="b_incentive_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_incentive->datetime->Visible) { // datetime ?>
	<?php if ($b_incentive->sortUrl($b_incentive->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $b_incentive->datetime->headerCellClass() ?>"><div id="elh_b_incentive_datetime" class="b_incentive_datetime"><div class="ew-table-header-caption"><?php echo $b_incentive->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $b_incentive->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_incentive->SortUrl($b_incentive->datetime) ?>',2);"><div id="elh_b_incentive_datetime" class="b_incentive_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_incentive->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_incentive->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_incentive->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$b_incentive_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($b_incentive->ExportAll && $b_incentive->isExport()) {
	$b_incentive_list->StopRec = $b_incentive_list->TotalRecs;
} else {

	// Set the last record to display
	if ($b_incentive_list->TotalRecs > $b_incentive_list->StartRec + $b_incentive_list->DisplayRecs - 1)
		$b_incentive_list->StopRec = $b_incentive_list->StartRec + $b_incentive_list->DisplayRecs - 1;
	else
		$b_incentive_list->StopRec = $b_incentive_list->TotalRecs;
}
$b_incentive_list->RecCnt = $b_incentive_list->StartRec - 1;
if ($b_incentive_list->Recordset && !$b_incentive_list->Recordset->EOF) {
	$b_incentive_list->Recordset->moveFirst();
	$selectLimit = $b_incentive_list->UseSelectLimit;
	if (!$selectLimit && $b_incentive_list->StartRec > 1)
		$b_incentive_list->Recordset->move($b_incentive_list->StartRec - 1);
} elseif (!$b_incentive->AllowAddDeleteRow && $b_incentive_list->StopRec == 0) {
	$b_incentive_list->StopRec = $b_incentive->GridAddRowCount;
}

// Initialize aggregate
$b_incentive->RowType = ROWTYPE_AGGREGATEINIT;
$b_incentive->resetAttributes();
$b_incentive_list->renderRow();
while ($b_incentive_list->RecCnt < $b_incentive_list->StopRec) {
	$b_incentive_list->RecCnt++;
	if ($b_incentive_list->RecCnt >= $b_incentive_list->StartRec) {
		$b_incentive_list->RowCnt++;

		// Set up key count
		$b_incentive_list->KeyCount = $b_incentive_list->RowIndex;

		// Init row class and style
		$b_incentive->resetAttributes();
		$b_incentive->CssClass = "";
		if ($b_incentive->isGridAdd()) {
		} else {
			$b_incentive_list->loadRowValues($b_incentive_list->Recordset); // Load row values
		}
		$b_incentive->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$b_incentive->RowAttrs = array_merge($b_incentive->RowAttrs, array('data-rowindex'=>$b_incentive_list->RowCnt, 'id'=>'r' . $b_incentive_list->RowCnt . '_b_incentive', 'data-rowtype'=>$b_incentive->RowType));

		// Render row
		$b_incentive_list->renderRow();

		// Render list options
		$b_incentive_list->renderListOptions();
?>
	<tr<?php echo $b_incentive->rowAttributes() ?>>
<?php

// Render list options (body, left)
$b_incentive_list->ListOptions->render("body", "left", $b_incentive_list->RowCnt);
?>
	<?php if ($b_incentive->id->Visible) { // id ?>
		<td data-name="id"<?php echo $b_incentive->id->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_id" class="b_incentive_id">
<span<?php echo $b_incentive->id->viewAttributes() ?>>
<?php echo $b_incentive->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->category->Visible) { // category ?>
		<td data-name="category"<?php echo $b_incentive->category->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_category" class="b_incentive_category">
<span<?php echo $b_incentive->category->viewAttributes() ?>>
<?php echo $b_incentive->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->type->Visible) { // type ?>
		<td data-name="type"<?php echo $b_incentive->type->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_type" class="b_incentive_type">
<span<?php echo $b_incentive->type->viewAttributes() ?>>
<?php echo $b_incentive->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->target_amount->Visible) { // target_amount ?>
		<td data-name="target_amount"<?php echo $b_incentive->target_amount->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_target_amount" class="b_incentive_target_amount">
<span<?php echo $b_incentive->target_amount->viewAttributes() ?>>
<?php echo $b_incentive->target_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->target_file->Visible) { // target_file ?>
		<td data-name="target_file"<?php echo $b_incentive->target_file->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_target_file" class="b_incentive_target_file">
<span<?php echo $b_incentive->target_file->viewAttributes() ?>>
<?php echo $b_incentive->target_file->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->file_inc->Visible) { // file_inc ?>
		<td data-name="file_inc"<?php echo $b_incentive->file_inc->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_file_inc" class="b_incentive_file_inc">
<span<?php echo $b_incentive->file_inc->viewAttributes() ?>>
<?php echo $b_incentive->file_inc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->neg_file_inc->Visible) { // neg_file_inc ?>
		<td data-name="neg_file_inc"<?php echo $b_incentive->neg_file_inc->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_neg_file_inc" class="b_incentive_neg_file_inc">
<span<?php echo $b_incentive->neg_file_inc->viewAttributes() ?>>
<?php echo $b_incentive->neg_file_inc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->inc_min_amount->Visible) { // inc_min_amount ?>
		<td data-name="inc_min_amount"<?php echo $b_incentive->inc_min_amount->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_inc_min_amount" class="b_incentive_inc_min_amount">
<span<?php echo $b_incentive->inc_min_amount->viewAttributes() ?>>
<?php echo $b_incentive->inc_min_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->inc_max_amount->Visible) { // inc_max_amount ?>
		<td data-name="inc_max_amount"<?php echo $b_incentive->inc_max_amount->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_inc_max_amount" class="b_incentive_inc_max_amount">
<span<?php echo $b_incentive->inc_max_amount->viewAttributes() ?>>
<?php echo $b_incentive->inc_max_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->inc_percent->Visible) { // inc_percent ?>
		<td data-name="inc_percent"<?php echo $b_incentive->inc_percent->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_inc_percent" class="b_incentive_inc_percent">
<span<?php echo $b_incentive->inc_percent->viewAttributes() ?>>
<?php echo $b_incentive->inc_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $b_incentive->operator->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_operator" class="b_incentive_operator">
<span<?php echo $b_incentive->operator->viewAttributes() ?>>
<?php echo $b_incentive->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_incentive->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $b_incentive->datetime->cellAttributes() ?>>
<span id="el<?php echo $b_incentive_list->RowCnt ?>_b_incentive_datetime" class="b_incentive_datetime">
<span<?php echo $b_incentive->datetime->viewAttributes() ?>>
<?php echo $b_incentive->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$b_incentive_list->ListOptions->render("body", "right", $b_incentive_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$b_incentive->isGridAdd())
		$b_incentive_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$b_incentive->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($b_incentive_list->Recordset)
	$b_incentive_list->Recordset->Close();
?>
<?php if (!$b_incentive->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$b_incentive->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_incentive_list->Pager)) $b_incentive_list->Pager = new PrevNextPager($b_incentive_list->StartRec, $b_incentive_list->DisplayRecs, $b_incentive_list->TotalRecs, $b_incentive_list->AutoHidePager) ?>
<?php if ($b_incentive_list->Pager->RecordCount > 0 && $b_incentive_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_incentive_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_incentive_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_incentive_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_incentive_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_incentive_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_incentive_list->pageUrl() ?>start=<?php echo $b_incentive_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_incentive_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_incentive_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_incentive_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_incentive_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_incentive_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_incentive_list->TotalRecs > 0 && (!$b_incentive_list->AutoHidePageSizeSelector || $b_incentive_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_incentive">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_incentive_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_incentive_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_incentive_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_incentive_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_incentive_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_incentive->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_incentive_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($b_incentive_list->TotalRecs == 0 && !$b_incentive->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $b_incentive_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$b_incentive_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$b_incentive->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$b_incentive_list->terminate();
?>