<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_status_edit = new b_status_edit();

// Run the page
$b_status_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_status_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fb_statusedit = currentForm = new ew.Form("fb_statusedit", "edit");

// Validate form
fb_statusedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($b_status_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_status->id->caption(), $b_status->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_status_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_status->grp->caption(), $b_status->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_status->grp->errorMessage()) ?>");
		<?php if ($b_status_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_status->item->caption(), $b_status->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_status_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_status->status->caption(), $b_status->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_status_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_status->operator->caption(), $b_status->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_status_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_status->datetime->caption(), $b_status->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_status->datetime->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fb_statusedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_statusedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_statusedit.lists["x_status"] = <?php echo $b_status_edit->status->Lookup->toClientList() ?>;
fb_statusedit.lists["x_status"].options = <?php echo JsonEncode($b_status_edit->status->options(FALSE, TRUE)) ?>;
fb_statusedit.lists["x_operator"] = <?php echo $b_status_edit->operator->Lookup->toClientList() ?>;
fb_statusedit.lists["x_operator"].options = <?php echo JsonEncode($b_status_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_status_edit->showPageHeader(); ?>
<?php
$b_status_edit->showMessage();
?>
<form name="fb_statusedit" id="fb_statusedit" class="<?php echo $b_status_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_status_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_status_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_status">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$b_status_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($b_status->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_b_status_id" class="<?php echo $b_status_edit->LeftColumnClass ?>"><?php echo $b_status->id->caption() ?><?php echo ($b_status->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_status_edit->RightColumnClass ?>"><div<?php echo $b_status->id->cellAttributes() ?>>
<span id="el_b_status_id">
<span<?php echo $b_status->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($b_status->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="b_status" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($b_status->id->CurrentValue) ?>">
<?php echo $b_status->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_status->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_b_status_grp" for="x_grp" class="<?php echo $b_status_edit->LeftColumnClass ?>"><?php echo $b_status->grp->caption() ?><?php echo ($b_status->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_status_edit->RightColumnClass ?>"><div<?php echo $b_status->grp->cellAttributes() ?>>
<span id="el_b_status_grp">
<input type="text" data-table="b_status" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($b_status->grp->getPlaceHolder()) ?>" value="<?php echo $b_status->grp->EditValue ?>"<?php echo $b_status->grp->editAttributes() ?>>
</span>
<?php echo $b_status->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_status->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_b_status_item" for="x_item" class="<?php echo $b_status_edit->LeftColumnClass ?>"><?php echo $b_status->item->caption() ?><?php echo ($b_status->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_status_edit->RightColumnClass ?>"><div<?php echo $b_status->item->cellAttributes() ?>>
<span id="el_b_status_item">
<input type="text" data-table="b_status" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($b_status->item->getPlaceHolder()) ?>" value="<?php echo $b_status->item->EditValue ?>"<?php echo $b_status->item->editAttributes() ?>>
</span>
<?php echo $b_status->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_status->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_b_status_status" for="x_status" class="<?php echo $b_status_edit->LeftColumnClass ?>"><?php echo $b_status->status->caption() ?><?php echo ($b_status->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_status_edit->RightColumnClass ?>"><div<?php echo $b_status->status->cellAttributes() ?>>
<span id="el_b_status_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_status" data-field="x_status" data-value-separator="<?php echo $b_status->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $b_status->status->editAttributes() ?>>
		<?php echo $b_status->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $b_status->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_status->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_b_status_operator" for="x_operator" class="<?php echo $b_status_edit->LeftColumnClass ?>"><?php echo $b_status->operator->caption() ?><?php echo ($b_status->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_status_edit->RightColumnClass ?>"><div<?php echo $b_status->operator->cellAttributes() ?>>
<span id="el_b_status_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_status" data-field="x_operator" data-value-separator="<?php echo $b_status->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $b_status->operator->editAttributes() ?>>
		<?php echo $b_status->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $b_status->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
<?php echo $b_status->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_status->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_b_status_datetime" for="x_datetime" class="<?php echo $b_status_edit->LeftColumnClass ?>"><?php echo $b_status->datetime->caption() ?><?php echo ($b_status->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_status_edit->RightColumnClass ?>"><div<?php echo $b_status->datetime->cellAttributes() ?>>
<span id="el_b_status_datetime">
<input type="text" data-table="b_status" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($b_status->datetime->getPlaceHolder()) ?>" value="<?php echo $b_status->datetime->EditValue ?>"<?php echo $b_status->datetime->editAttributes() ?>>
<?php if (!$b_status->datetime->ReadOnly && !$b_status->datetime->Disabled && !isset($b_status->datetime->EditAttrs["readonly"]) && !isset($b_status->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_statusedit", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $b_status->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_status_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_status_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $b_status_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_status_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_status_edit->terminate();
?>