<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_status_list = new b_status_list();

// Run the page
$b_status_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_status_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$b_status->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fb_statuslist = currentForm = new ew.Form("fb_statuslist", "list");
fb_statuslist.formKeyCountName = '<?php echo $b_status_list->FormKeyCountName ?>';

// Form_CustomValidate event
fb_statuslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_statuslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_statuslist.lists["x_status"] = <?php echo $b_status_list->status->Lookup->toClientList() ?>;
fb_statuslist.lists["x_status"].options = <?php echo JsonEncode($b_status_list->status->options(FALSE, TRUE)) ?>;
fb_statuslist.lists["x_operator"] = <?php echo $b_status_list->operator->Lookup->toClientList() ?>;
fb_statuslist.lists["x_operator"].options = <?php echo JsonEncode($b_status_list->operator->lookupOptions()) ?>;

// Form object for search
var fb_statuslistsrch = currentSearchForm = new ew.Form("fb_statuslistsrch");

// Filters
fb_statuslistsrch.filterList = <?php echo $b_status_list->getFilterList() ?>;

// Init search panel as collapsed
fb_statuslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$b_status->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($b_status_list->TotalRecs > 0 && $b_status_list->ExportOptions->visible()) { ?>
<?php $b_status_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($b_status_list->ImportOptions->visible()) { ?>
<?php $b_status_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($b_status_list->SearchOptions->visible()) { ?>
<?php $b_status_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($b_status_list->FilterOptions->visible()) { ?>
<?php $b_status_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$b_status_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$b_status->isExport() && !$b_status->CurrentAction) { ?>
<form name="fb_statuslistsrch" id="fb_statuslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($b_status_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fb_statuslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="b_status">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($b_status_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($b_status_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $b_status_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($b_status_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($b_status_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($b_status_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($b_status_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $b_status_list->showPageHeader(); ?>
<?php
$b_status_list->showMessage();
?>
<?php if ($b_status_list->TotalRecs > 0 || $b_status->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($b_status_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> b_status">
<?php if (!$b_status->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$b_status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_status_list->Pager)) $b_status_list->Pager = new PrevNextPager($b_status_list->StartRec, $b_status_list->DisplayRecs, $b_status_list->TotalRecs, $b_status_list->AutoHidePager) ?>
<?php if ($b_status_list->Pager->RecordCount > 0 && $b_status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_status_list->TotalRecs > 0 && (!$b_status_list->AutoHidePageSizeSelector || $b_status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fb_statuslist" id="fb_statuslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_status_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_status_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_status">
<div id="gmp_b_status" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($b_status_list->TotalRecs > 0 || $b_status->isGridEdit()) { ?>
<table id="tbl_b_statuslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$b_status_list->RowType = ROWTYPE_HEADER;

// Render list options
$b_status_list->renderListOptions();

// Render list options (header, left)
$b_status_list->ListOptions->render("header", "left");
?>
<?php if ($b_status->id->Visible) { // id ?>
	<?php if ($b_status->sortUrl($b_status->id) == "") { ?>
		<th data-name="id" class="<?php echo $b_status->id->headerCellClass() ?>"><div id="elh_b_status_id" class="b_status_id"><div class="ew-table-header-caption"><?php echo $b_status->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $b_status->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_status->SortUrl($b_status->id) ?>',2);"><div id="elh_b_status_id" class="b_status_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_status->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_status->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_status->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_status->grp->Visible) { // grp ?>
	<?php if ($b_status->sortUrl($b_status->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $b_status->grp->headerCellClass() ?>"><div id="elh_b_status_grp" class="b_status_grp"><div class="ew-table-header-caption"><?php echo $b_status->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $b_status->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_status->SortUrl($b_status->grp) ?>',2);"><div id="elh_b_status_grp" class="b_status_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_status->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_status->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_status->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_status->item->Visible) { // item ?>
	<?php if ($b_status->sortUrl($b_status->item) == "") { ?>
		<th data-name="item" class="<?php echo $b_status->item->headerCellClass() ?>"><div id="elh_b_status_item" class="b_status_item"><div class="ew-table-header-caption"><?php echo $b_status->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $b_status->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_status->SortUrl($b_status->item) ?>',2);"><div id="elh_b_status_item" class="b_status_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_status->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_status->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_status->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_status->status->Visible) { // status ?>
	<?php if ($b_status->sortUrl($b_status->status) == "") { ?>
		<th data-name="status" class="<?php echo $b_status->status->headerCellClass() ?>"><div id="elh_b_status_status" class="b_status_status"><div class="ew-table-header-caption"><?php echo $b_status->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $b_status->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_status->SortUrl($b_status->status) ?>',2);"><div id="elh_b_status_status" class="b_status_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_status->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_status->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_status->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_status->operator->Visible) { // operator ?>
	<?php if ($b_status->sortUrl($b_status->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $b_status->operator->headerCellClass() ?>"><div id="elh_b_status_operator" class="b_status_operator"><div class="ew-table-header-caption"><?php echo $b_status->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $b_status->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_status->SortUrl($b_status->operator) ?>',2);"><div id="elh_b_status_operator" class="b_status_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_status->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_status->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_status->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_status->datetime->Visible) { // datetime ?>
	<?php if ($b_status->sortUrl($b_status->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $b_status->datetime->headerCellClass() ?>"><div id="elh_b_status_datetime" class="b_status_datetime"><div class="ew-table-header-caption"><?php echo $b_status->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $b_status->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_status->SortUrl($b_status->datetime) ?>',2);"><div id="elh_b_status_datetime" class="b_status_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_status->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_status->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_status->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$b_status_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($b_status->ExportAll && $b_status->isExport()) {
	$b_status_list->StopRec = $b_status_list->TotalRecs;
} else {

	// Set the last record to display
	if ($b_status_list->TotalRecs > $b_status_list->StartRec + $b_status_list->DisplayRecs - 1)
		$b_status_list->StopRec = $b_status_list->StartRec + $b_status_list->DisplayRecs - 1;
	else
		$b_status_list->StopRec = $b_status_list->TotalRecs;
}
$b_status_list->RecCnt = $b_status_list->StartRec - 1;
if ($b_status_list->Recordset && !$b_status_list->Recordset->EOF) {
	$b_status_list->Recordset->moveFirst();
	$selectLimit = $b_status_list->UseSelectLimit;
	if (!$selectLimit && $b_status_list->StartRec > 1)
		$b_status_list->Recordset->move($b_status_list->StartRec - 1);
} elseif (!$b_status->AllowAddDeleteRow && $b_status_list->StopRec == 0) {
	$b_status_list->StopRec = $b_status->GridAddRowCount;
}

// Initialize aggregate
$b_status->RowType = ROWTYPE_AGGREGATEINIT;
$b_status->resetAttributes();
$b_status_list->renderRow();
while ($b_status_list->RecCnt < $b_status_list->StopRec) {
	$b_status_list->RecCnt++;
	if ($b_status_list->RecCnt >= $b_status_list->StartRec) {
		$b_status_list->RowCnt++;

		// Set up key count
		$b_status_list->KeyCount = $b_status_list->RowIndex;

		// Init row class and style
		$b_status->resetAttributes();
		$b_status->CssClass = "";
		if ($b_status->isGridAdd()) {
		} else {
			$b_status_list->loadRowValues($b_status_list->Recordset); // Load row values
		}
		$b_status->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$b_status->RowAttrs = array_merge($b_status->RowAttrs, array('data-rowindex'=>$b_status_list->RowCnt, 'id'=>'r' . $b_status_list->RowCnt . '_b_status', 'data-rowtype'=>$b_status->RowType));

		// Render row
		$b_status_list->renderRow();

		// Render list options
		$b_status_list->renderListOptions();
?>
	<tr<?php echo $b_status->rowAttributes() ?>>
<?php

// Render list options (body, left)
$b_status_list->ListOptions->render("body", "left", $b_status_list->RowCnt);
?>
	<?php if ($b_status->id->Visible) { // id ?>
		<td data-name="id"<?php echo $b_status->id->cellAttributes() ?>>
<span id="el<?php echo $b_status_list->RowCnt ?>_b_status_id" class="b_status_id">
<span<?php echo $b_status->id->viewAttributes() ?>>
<?php echo $b_status->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_status->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $b_status->grp->cellAttributes() ?>>
<span id="el<?php echo $b_status_list->RowCnt ?>_b_status_grp" class="b_status_grp">
<span<?php echo $b_status->grp->viewAttributes() ?>>
<?php echo $b_status->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_status->item->Visible) { // item ?>
		<td data-name="item"<?php echo $b_status->item->cellAttributes() ?>>
<span id="el<?php echo $b_status_list->RowCnt ?>_b_status_item" class="b_status_item">
<span<?php echo $b_status->item->viewAttributes() ?>>
<?php echo $b_status->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_status->status->Visible) { // status ?>
		<td data-name="status"<?php echo $b_status->status->cellAttributes() ?>>
<span id="el<?php echo $b_status_list->RowCnt ?>_b_status_status" class="b_status_status">
<span<?php echo $b_status->status->viewAttributes() ?>>
<?php echo $b_status->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_status->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $b_status->operator->cellAttributes() ?>>
<span id="el<?php echo $b_status_list->RowCnt ?>_b_status_operator" class="b_status_operator">
<span<?php echo $b_status->operator->viewAttributes() ?>>
<?php echo $b_status->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_status->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $b_status->datetime->cellAttributes() ?>>
<span id="el<?php echo $b_status_list->RowCnt ?>_b_status_datetime" class="b_status_datetime">
<span<?php echo $b_status->datetime->viewAttributes() ?>>
<?php echo $b_status->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$b_status_list->ListOptions->render("body", "right", $b_status_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$b_status->isGridAdd())
		$b_status_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$b_status->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($b_status_list->Recordset)
	$b_status_list->Recordset->Close();
?>
<?php if (!$b_status->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$b_status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_status_list->Pager)) $b_status_list->Pager = new PrevNextPager($b_status_list->StartRec, $b_status_list->DisplayRecs, $b_status_list->TotalRecs, $b_status_list->AutoHidePager) ?>
<?php if ($b_status_list->Pager->RecordCount > 0 && $b_status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_status_list->pageUrl() ?>start=<?php echo $b_status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_status_list->TotalRecs > 0 && (!$b_status_list->AutoHidePageSizeSelector || $b_status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($b_status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($b_status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($b_status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($b_status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_status_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($b_status_list->TotalRecs == 0 && !$b_status->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $b_status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$b_status_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$b_status->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$b_status->isExport()) { ?>
<script>
ew.scrollableTable("gmp_b_status", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$b_status_list->terminate();
?>