<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$balance_detailed_add = new balance_detailed_add();

// Run the page
$balance_detailed_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$balance_detailed_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fbalance_detailedadd = currentForm = new ew.Form("fbalance_detailedadd", "add");

// Validate form
fbalance_detailedadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($balance_detailed_add->account->Required) { ?>
			elm = this.getElements("x" + infix + "_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->account->caption(), $balance_detailed->account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->name->caption(), $balance_detailed->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->ref_account->Required) { ?>
			elm = this.getElements("x" + infix + "_ref_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->ref_account->caption(), $balance_detailed->ref_account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->debit->Required) { ?>
			elm = this.getElements("x" + infix + "_debit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->debit->caption(), $balance_detailed->debit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_debit");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($balance_detailed->debit->errorMessage()) ?>");
		<?php if ($balance_detailed_add->credit->Required) { ?>
			elm = this.getElements("x" + infix + "_credit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->credit->caption(), $balance_detailed->credit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_credit");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($balance_detailed->credit->errorMessage()) ?>");
		<?php if ($balance_detailed_add->balance->Required) { ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->balance->caption(), $balance_detailed->balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($balance_detailed->balance->errorMessage()) ?>");
		<?php if ($balance_detailed_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->dated->caption(), $balance_detailed->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($balance_detailed->dated->errorMessage()) ?>");
		<?php if ($balance_detailed_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->remarks->caption(), $balance_detailed->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->uploads->caption(), $balance_detailed->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->type->caption(), $balance_detailed->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->reference->caption(), $balance_detailed->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->operator->caption(), $balance_detailed->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($balance_detailed_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $balance_detailed->datetime->caption(), $balance_detailed->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($balance_detailed->datetime->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbalance_detailedadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbalance_detailedadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbalance_detailedadd.lists["x_account"] = <?php echo $balance_detailed_add->account->Lookup->toClientList() ?>;
fbalance_detailedadd.lists["x_account"].options = <?php echo JsonEncode($balance_detailed_add->account->lookupOptions()) ?>;
fbalance_detailedadd.lists["x_ref_account"] = <?php echo $balance_detailed_add->ref_account->Lookup->toClientList() ?>;
fbalance_detailedadd.lists["x_ref_account"].options = <?php echo JsonEncode($balance_detailed_add->ref_account->lookupOptions()) ?>;
fbalance_detailedadd.lists["x_operator"] = <?php echo $balance_detailed_add->operator->Lookup->toClientList() ?>;
fbalance_detailedadd.lists["x_operator"].options = <?php echo JsonEncode($balance_detailed_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $balance_detailed_add->showPageHeader(); ?>
<?php
$balance_detailed_add->showMessage();
?>
<form name="fbalance_detailedadd" id="fbalance_detailedadd" class="<?php echo $balance_detailed_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($balance_detailed_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $balance_detailed_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="balance_detailed">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$balance_detailed_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($balance_detailed->account->Visible) { // account ?>
	<div id="r_account" class="form-group row">
		<label id="elh_balance_detailed_account" for="x_account" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->account->caption() ?><?php echo ($balance_detailed->account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->account->cellAttributes() ?>>
<span id="el_balance_detailed_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance_detailed" data-field="x_account" data-value-separator="<?php echo $balance_detailed->account->displayValueSeparatorAttribute() ?>" id="x_account" name="x_account"<?php echo $balance_detailed->account->editAttributes() ?>>
		<?php echo $balance_detailed->account->selectOptionListHtml("x_account") ?>
	</select>
</div>
<?php echo $balance_detailed->account->Lookup->getParamTag("p_x_account") ?>
</span>
<?php echo $balance_detailed->account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_balance_detailed_name" for="x_name" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->name->caption() ?><?php echo ($balance_detailed->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->name->cellAttributes() ?>>
<span id="el_balance_detailed_name">
<input type="text" data-table="balance_detailed" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($balance_detailed->name->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->name->EditValue ?>"<?php echo $balance_detailed->name->editAttributes() ?>>
</span>
<?php echo $balance_detailed->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->ref_account->Visible) { // ref_account ?>
	<div id="r_ref_account" class="form-group row">
		<label id="elh_balance_detailed_ref_account" for="x_ref_account" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->ref_account->caption() ?><?php echo ($balance_detailed->ref_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->ref_account->cellAttributes() ?>>
<span id="el_balance_detailed_ref_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance_detailed" data-field="x_ref_account" data-value-separator="<?php echo $balance_detailed->ref_account->displayValueSeparatorAttribute() ?>" id="x_ref_account" name="x_ref_account"<?php echo $balance_detailed->ref_account->editAttributes() ?>>
		<?php echo $balance_detailed->ref_account->selectOptionListHtml("x_ref_account") ?>
	</select>
</div>
<?php echo $balance_detailed->ref_account->Lookup->getParamTag("p_x_ref_account") ?>
</span>
<?php echo $balance_detailed->ref_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->debit->Visible) { // debit ?>
	<div id="r_debit" class="form-group row">
		<label id="elh_balance_detailed_debit" for="x_debit" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->debit->caption() ?><?php echo ($balance_detailed->debit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->debit->cellAttributes() ?>>
<span id="el_balance_detailed_debit">
<input type="text" data-table="balance_detailed" data-field="x_debit" name="x_debit" id="x_debit" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->debit->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->debit->EditValue ?>"<?php echo $balance_detailed->debit->editAttributes() ?>>
</span>
<?php echo $balance_detailed->debit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->credit->Visible) { // credit ?>
	<div id="r_credit" class="form-group row">
		<label id="elh_balance_detailed_credit" for="x_credit" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->credit->caption() ?><?php echo ($balance_detailed->credit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->credit->cellAttributes() ?>>
<span id="el_balance_detailed_credit">
<input type="text" data-table="balance_detailed" data-field="x_credit" name="x_credit" id="x_credit" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->credit->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->credit->EditValue ?>"<?php echo $balance_detailed->credit->editAttributes() ?>>
</span>
<?php echo $balance_detailed->credit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label id="elh_balance_detailed_balance" for="x_balance" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->balance->caption() ?><?php echo ($balance_detailed->balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->balance->cellAttributes() ?>>
<span id="el_balance_detailed_balance">
<input type="text" data-table="balance_detailed" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->balance->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->balance->EditValue ?>"<?php echo $balance_detailed->balance->editAttributes() ?>>
</span>
<?php echo $balance_detailed->balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_balance_detailed_dated" for="x_dated" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->dated->caption() ?><?php echo ($balance_detailed->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->dated->cellAttributes() ?>>
<span id="el_balance_detailed_dated">
<input type="text" data-table="balance_detailed" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($balance_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->dated->EditValue ?>"<?php echo $balance_detailed->dated->editAttributes() ?>>
<?php if (!$balance_detailed->dated->ReadOnly && !$balance_detailed->dated->Disabled && !isset($balance_detailed->dated->EditAttrs["readonly"]) && !isset($balance_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbalance_detailedadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $balance_detailed->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_balance_detailed_remarks" for="x_remarks" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->remarks->caption() ?><?php echo ($balance_detailed->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->remarks->cellAttributes() ?>>
<span id="el_balance_detailed_remarks">
<input type="text" data-table="balance_detailed" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($balance_detailed->remarks->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->remarks->EditValue ?>"<?php echo $balance_detailed->remarks->editAttributes() ?>>
</span>
<?php echo $balance_detailed->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_balance_detailed_uploads" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->uploads->caption() ?><?php echo ($balance_detailed->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->uploads->cellAttributes() ?>>
<span id="el_balance_detailed_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $balance_detailed->uploads->title() ? $balance_detailed->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($balance_detailed->uploads->ReadOnly || $balance_detailed->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="balance_detailed" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $balance_detailed->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $balance_detailed->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $balance_detailed->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $balance_detailed->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $balance_detailed->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_balance_detailed_type" for="x_type" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->type->caption() ?><?php echo ($balance_detailed->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->type->cellAttributes() ?>>
<span id="el_balance_detailed_type">
<input type="text" data-table="balance_detailed" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="7" placeholder="<?php echo HtmlEncode($balance_detailed->type->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->type->EditValue ?>"<?php echo $balance_detailed->type->editAttributes() ?>>
</span>
<?php echo $balance_detailed->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_balance_detailed_reference" for="x_reference" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->reference->caption() ?><?php echo ($balance_detailed->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->reference->cellAttributes() ?>>
<span id="el_balance_detailed_reference">
<input type="text" data-table="balance_detailed" data-field="x_reference" name="x_reference" id="x_reference" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($balance_detailed->reference->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->reference->EditValue ?>"<?php echo $balance_detailed->reference->editAttributes() ?>>
</span>
<?php echo $balance_detailed->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_balance_detailed_operator" for="x_operator" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->operator->caption() ?><?php echo ($balance_detailed->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->operator->cellAttributes() ?>>
<span id="el_balance_detailed_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance_detailed" data-field="x_operator" data-value-separator="<?php echo $balance_detailed->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $balance_detailed->operator->editAttributes() ?>>
		<?php echo $balance_detailed->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $balance_detailed->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
<?php echo $balance_detailed->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_balance_detailed_datetime" for="x_datetime" class="<?php echo $balance_detailed_add->LeftColumnClass ?>"><?php echo $balance_detailed->datetime->caption() ?><?php echo ($balance_detailed->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $balance_detailed_add->RightColumnClass ?>"><div<?php echo $balance_detailed->datetime->cellAttributes() ?>>
<span id="el_balance_detailed_datetime">
<input type="text" data-table="balance_detailed" data-field="x_datetime" data-format="2" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($balance_detailed->datetime->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->datetime->EditValue ?>"<?php echo $balance_detailed->datetime->editAttributes() ?>>
<?php if (!$balance_detailed->datetime->ReadOnly && !$balance_detailed->datetime->Disabled && !isset($balance_detailed->datetime->EditAttrs["readonly"]) && !isset($balance_detailed->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbalance_detailedadd", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $balance_detailed->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$balance_detailed_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $balance_detailed_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $balance_detailed_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$balance_detailed_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$balance_detailed_add->terminate();
?>