<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$balance_detailed_list = new balance_detailed_list();

// Run the page
$balance_detailed_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$balance_detailed_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$balance_detailed->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbalance_detailedlist = currentForm = new ew.Form("fbalance_detailedlist", "list");
fbalance_detailedlist.formKeyCountName = '<?php echo $balance_detailed_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbalance_detailedlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbalance_detailedlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbalance_detailedlist.lists["x_account"] = <?php echo $balance_detailed_list->account->Lookup->toClientList() ?>;
fbalance_detailedlist.lists["x_account"].options = <?php echo JsonEncode($balance_detailed_list->account->lookupOptions()) ?>;
fbalance_detailedlist.lists["x_ref_account"] = <?php echo $balance_detailed_list->ref_account->Lookup->toClientList() ?>;
fbalance_detailedlist.lists["x_ref_account"].options = <?php echo JsonEncode($balance_detailed_list->ref_account->lookupOptions()) ?>;
fbalance_detailedlist.lists["x_operator"] = <?php echo $balance_detailed_list->operator->Lookup->toClientList() ?>;
fbalance_detailedlist.lists["x_operator"].options = <?php echo JsonEncode($balance_detailed_list->operator->lookupOptions()) ?>;

// Form object for search
var fbalance_detailedlistsrch = currentSearchForm = new ew.Form("fbalance_detailedlistsrch");

// Validate function for search
fbalance_detailedlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbalance_detailedlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbalance_detailedlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fbalance_detailedlistsrch.filterList = <?php echo $balance_detailed_list->getFilterList() ?>;

// Init search panel as collapsed
fbalance_detailedlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$balance_detailed->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($balance_detailed_list->TotalRecs > 0 && $balance_detailed_list->ExportOptions->visible()) { ?>
<?php $balance_detailed_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($balance_detailed_list->ImportOptions->visible()) { ?>
<?php $balance_detailed_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($balance_detailed_list->SearchOptions->visible()) { ?>
<?php $balance_detailed_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($balance_detailed_list->FilterOptions->visible()) { ?>
<?php $balance_detailed_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$balance_detailed_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$balance_detailed->isExport() && !$balance_detailed->CurrentAction) { ?>
<form name="fbalance_detailedlistsrch" id="fbalance_detailedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($balance_detailed_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbalance_detailedlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="balance_detailed">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$balance_detailed_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$balance_detailed->RowType = ROWTYPE_SEARCH;

// Render row
$balance_detailed->resetAttributes();
$balance_detailed_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($balance_detailed->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $balance_detailed->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="balance_detailed" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($balance_detailed->name->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->name->EditValue ?>"<?php echo $balance_detailed->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($balance_detailed->balance->Visible) { // balance ?>
	<div id="xsc_balance" class="ew-cell form-group">
		<label for="x_balance" class="ew-search-caption ew-label"><?php echo $balance_detailed->balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="balance_detailed" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->balance->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->balance->EditValue ?>"<?php echo $balance_detailed->balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_balance style="d-none"">
<input type="text" data-table="balance_detailed" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->balance->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->balance->EditValue2 ?>"<?php echo $balance_detailed->balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($balance_detailed->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $balance_detailed->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="balance_detailed" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($balance_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->dated->EditValue ?>"<?php echo $balance_detailed->dated->editAttributes() ?>>
<?php if (!$balance_detailed->dated->ReadOnly && !$balance_detailed->dated->Disabled && !isset($balance_detailed->dated->EditAttrs["readonly"]) && !isset($balance_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbalance_detailedlistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="balance_detailed" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($balance_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->dated->EditValue2 ?>"<?php echo $balance_detailed->dated->editAttributes() ?>>
<?php if (!$balance_detailed->dated->ReadOnly && !$balance_detailed->dated->Disabled && !isset($balance_detailed->dated->EditAttrs["readonly"]) && !isset($balance_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbalance_detailedlistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($balance_detailed_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($balance_detailed_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $balance_detailed_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($balance_detailed_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($balance_detailed_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($balance_detailed_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($balance_detailed_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $balance_detailed_list->showPageHeader(); ?>
<?php
$balance_detailed_list->showMessage();
?>
<?php if ($balance_detailed_list->TotalRecs > 0 || $balance_detailed->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($balance_detailed_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> balance_detailed">
<?php if (!$balance_detailed->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$balance_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($balance_detailed_list->Pager)) $balance_detailed_list->Pager = new PrevNextPager($balance_detailed_list->StartRec, $balance_detailed_list->DisplayRecs, $balance_detailed_list->TotalRecs, $balance_detailed_list->AutoHidePager) ?>
<?php if ($balance_detailed_list->Pager->RecordCount > 0 && $balance_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($balance_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($balance_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $balance_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($balance_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($balance_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $balance_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($balance_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $balance_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $balance_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $balance_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($balance_detailed_list->TotalRecs > 0 && (!$balance_detailed_list->AutoHidePageSizeSelector || $balance_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="balance_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($balance_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($balance_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($balance_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($balance_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($balance_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($balance_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $balance_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbalance_detailedlist" id="fbalance_detailedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($balance_detailed_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $balance_detailed_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="balance_detailed">
<div id="gmp_balance_detailed" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($balance_detailed_list->TotalRecs > 0 || $balance_detailed->isGridEdit()) { ?>
<table id="tbl_balance_detailedlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$balance_detailed_list->RowType = ROWTYPE_HEADER;

// Render list options
$balance_detailed_list->renderListOptions();

// Render list options (header, left)
$balance_detailed_list->ListOptions->render("header", "left");
?>
<?php if ($balance_detailed->id->Visible) { // id ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->id) == "") { ?>
		<th data-name="id" class="<?php echo $balance_detailed->id->headerCellClass() ?>"><div id="elh_balance_detailed_id" class="balance_detailed_id"><div class="ew-table-header-caption"><?php echo $balance_detailed->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $balance_detailed->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->id) ?>',2);"><div id="elh_balance_detailed_id" class="balance_detailed_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->account->Visible) { // account ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->account) == "") { ?>
		<th data-name="account" class="<?php echo $balance_detailed->account->headerCellClass() ?>"><div id="elh_balance_detailed_account" class="balance_detailed_account"><div class="ew-table-header-caption"><?php echo $balance_detailed->account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account" class="<?php echo $balance_detailed->account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->account) ?>',2);"><div id="elh_balance_detailed_account" class="balance_detailed_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->account->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->name->Visible) { // name ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->name) == "") { ?>
		<th data-name="name" class="<?php echo $balance_detailed->name->headerCellClass() ?>"><div id="elh_balance_detailed_name" class="balance_detailed_name"><div class="ew-table-header-caption"><?php echo $balance_detailed->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $balance_detailed->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->name) ?>',2);"><div id="elh_balance_detailed_name" class="balance_detailed_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->ref_account->Visible) { // ref_account ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->ref_account) == "") { ?>
		<th data-name="ref_account" class="<?php echo $balance_detailed->ref_account->headerCellClass() ?>"><div id="elh_balance_detailed_ref_account" class="balance_detailed_ref_account"><div class="ew-table-header-caption"><?php echo $balance_detailed->ref_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref_account" class="<?php echo $balance_detailed->ref_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->ref_account) ?>',2);"><div id="elh_balance_detailed_ref_account" class="balance_detailed_ref_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->ref_account->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->ref_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->ref_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->debit->Visible) { // debit ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->debit) == "") { ?>
		<th data-name="debit" class="<?php echo $balance_detailed->debit->headerCellClass() ?>"><div id="elh_balance_detailed_debit" class="balance_detailed_debit"><div class="ew-table-header-caption"><?php echo $balance_detailed->debit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="debit" class="<?php echo $balance_detailed->debit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->debit) ?>',2);"><div id="elh_balance_detailed_debit" class="balance_detailed_debit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->debit->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->debit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->debit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->credit->Visible) { // credit ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->credit) == "") { ?>
		<th data-name="credit" class="<?php echo $balance_detailed->credit->headerCellClass() ?>"><div id="elh_balance_detailed_credit" class="balance_detailed_credit"><div class="ew-table-header-caption"><?php echo $balance_detailed->credit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="credit" class="<?php echo $balance_detailed->credit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->credit) ?>',2);"><div id="elh_balance_detailed_credit" class="balance_detailed_credit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->credit->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->credit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->credit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->balance->Visible) { // balance ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $balance_detailed->balance->headerCellClass() ?>"><div id="elh_balance_detailed_balance" class="balance_detailed_balance"><div class="ew-table-header-caption"><?php echo $balance_detailed->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $balance_detailed->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->balance) ?>',2);"><div id="elh_balance_detailed_balance" class="balance_detailed_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->dated->Visible) { // dated ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $balance_detailed->dated->headerCellClass() ?>"><div id="elh_balance_detailed_dated" class="balance_detailed_dated"><div class="ew-table-header-caption"><?php echo $balance_detailed->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $balance_detailed->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->dated) ?>',2);"><div id="elh_balance_detailed_dated" class="balance_detailed_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->remarks->Visible) { // remarks ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $balance_detailed->remarks->headerCellClass() ?>"><div id="elh_balance_detailed_remarks" class="balance_detailed_remarks"><div class="ew-table-header-caption"><?php echo $balance_detailed->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $balance_detailed->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->remarks) ?>',2);"><div id="elh_balance_detailed_remarks" class="balance_detailed_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->uploads->Visible) { // uploads ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $balance_detailed->uploads->headerCellClass() ?>"><div id="elh_balance_detailed_uploads" class="balance_detailed_uploads"><div class="ew-table-header-caption"><?php echo $balance_detailed->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $balance_detailed->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->uploads) ?>',2);"><div id="elh_balance_detailed_uploads" class="balance_detailed_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->type->Visible) { // type ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->type) == "") { ?>
		<th data-name="type" class="<?php echo $balance_detailed->type->headerCellClass() ?>"><div id="elh_balance_detailed_type" class="balance_detailed_type"><div class="ew-table-header-caption"><?php echo $balance_detailed->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $balance_detailed->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->type) ?>',2);"><div id="elh_balance_detailed_type" class="balance_detailed_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->reference->Visible) { // reference ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $balance_detailed->reference->headerCellClass() ?>"><div id="elh_balance_detailed_reference" class="balance_detailed_reference"><div class="ew-table-header-caption"><?php echo $balance_detailed->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $balance_detailed->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->reference) ?>',2);"><div id="elh_balance_detailed_reference" class="balance_detailed_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->operator->Visible) { // operator ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $balance_detailed->operator->headerCellClass() ?>"><div id="elh_balance_detailed_operator" class="balance_detailed_operator"><div class="ew-table-header-caption"><?php echo $balance_detailed->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $balance_detailed->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->operator) ?>',2);"><div id="elh_balance_detailed_operator" class="balance_detailed_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance_detailed->datetime->Visible) { // datetime ?>
	<?php if ($balance_detailed->sortUrl($balance_detailed->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $balance_detailed->datetime->headerCellClass() ?>"><div id="elh_balance_detailed_datetime" class="balance_detailed_datetime"><div class="ew-table-header-caption"><?php echo $balance_detailed->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $balance_detailed->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance_detailed->SortUrl($balance_detailed->datetime) ?>',2);"><div id="elh_balance_detailed_datetime" class="balance_detailed_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance_detailed->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance_detailed->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance_detailed->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$balance_detailed_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($balance_detailed->ExportAll && $balance_detailed->isExport()) {
	$balance_detailed_list->StopRec = $balance_detailed_list->TotalRecs;
} else {

	// Set the last record to display
	if ($balance_detailed_list->TotalRecs > $balance_detailed_list->StartRec + $balance_detailed_list->DisplayRecs - 1)
		$balance_detailed_list->StopRec = $balance_detailed_list->StartRec + $balance_detailed_list->DisplayRecs - 1;
	else
		$balance_detailed_list->StopRec = $balance_detailed_list->TotalRecs;
}
$balance_detailed_list->RecCnt = $balance_detailed_list->StartRec - 1;
if ($balance_detailed_list->Recordset && !$balance_detailed_list->Recordset->EOF) {
	$balance_detailed_list->Recordset->moveFirst();
	$selectLimit = $balance_detailed_list->UseSelectLimit;
	if (!$selectLimit && $balance_detailed_list->StartRec > 1)
		$balance_detailed_list->Recordset->move($balance_detailed_list->StartRec - 1);
} elseif (!$balance_detailed->AllowAddDeleteRow && $balance_detailed_list->StopRec == 0) {
	$balance_detailed_list->StopRec = $balance_detailed->GridAddRowCount;
}

// Initialize aggregate
$balance_detailed->RowType = ROWTYPE_AGGREGATEINIT;
$balance_detailed->resetAttributes();
$balance_detailed_list->renderRow();
while ($balance_detailed_list->RecCnt < $balance_detailed_list->StopRec) {
	$balance_detailed_list->RecCnt++;
	if ($balance_detailed_list->RecCnt >= $balance_detailed_list->StartRec) {
		$balance_detailed_list->RowCnt++;

		// Set up key count
		$balance_detailed_list->KeyCount = $balance_detailed_list->RowIndex;

		// Init row class and style
		$balance_detailed->resetAttributes();
		$balance_detailed->CssClass = "";
		if ($balance_detailed->isGridAdd()) {
		} else {
			$balance_detailed_list->loadRowValues($balance_detailed_list->Recordset); // Load row values
		}
		$balance_detailed->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$balance_detailed->RowAttrs = array_merge($balance_detailed->RowAttrs, array('data-rowindex'=>$balance_detailed_list->RowCnt, 'id'=>'r' . $balance_detailed_list->RowCnt . '_balance_detailed', 'data-rowtype'=>$balance_detailed->RowType));

		// Render row
		$balance_detailed_list->renderRow();

		// Render list options
		$balance_detailed_list->renderListOptions();
?>
	<tr<?php echo $balance_detailed->rowAttributes() ?>>
<?php

// Render list options (body, left)
$balance_detailed_list->ListOptions->render("body", "left", $balance_detailed_list->RowCnt);
?>
	<?php if ($balance_detailed->id->Visible) { // id ?>
		<td data-name="id"<?php echo $balance_detailed->id->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_id" class="balance_detailed_id">
<span<?php echo $balance_detailed->id->viewAttributes() ?>>
<?php echo $balance_detailed->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->account->Visible) { // account ?>
		<td data-name="account"<?php echo $balance_detailed->account->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_account" class="balance_detailed_account">
<span<?php echo $balance_detailed->account->viewAttributes() ?>>
<?php echo $balance_detailed->account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->name->Visible) { // name ?>
		<td data-name="name"<?php echo $balance_detailed->name->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_name" class="balance_detailed_name">
<span<?php echo $balance_detailed->name->viewAttributes() ?>>
<?php if ((!EmptyString($balance_detailed->name->getViewValue())) && $balance_detailed->name->linkAttributes() <> "") { ?>
<a<?php echo $balance_detailed->name->linkAttributes() ?>><?php echo $balance_detailed->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $balance_detailed->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->ref_account->Visible) { // ref_account ?>
		<td data-name="ref_account"<?php echo $balance_detailed->ref_account->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_ref_account" class="balance_detailed_ref_account">
<span<?php echo $balance_detailed->ref_account->viewAttributes() ?>>
<?php echo $balance_detailed->ref_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->debit->Visible) { // debit ?>
		<td data-name="debit"<?php echo $balance_detailed->debit->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_debit" class="balance_detailed_debit">
<span<?php echo $balance_detailed->debit->viewAttributes() ?>>
<?php echo $balance_detailed->debit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->credit->Visible) { // credit ?>
		<td data-name="credit"<?php echo $balance_detailed->credit->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_credit" class="balance_detailed_credit">
<span<?php echo $balance_detailed->credit->viewAttributes() ?>>
<?php echo $balance_detailed->credit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $balance_detailed->balance->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_balance" class="balance_detailed_balance">
<span<?php echo $balance_detailed->balance->viewAttributes() ?>>
<?php echo $balance_detailed->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $balance_detailed->dated->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_dated" class="balance_detailed_dated">
<span<?php echo $balance_detailed->dated->viewAttributes() ?>>
<?php if ((!EmptyString($balance_detailed->dated->getViewValue())) && $balance_detailed->dated->linkAttributes() <> "") { ?>
<a<?php echo $balance_detailed->dated->linkAttributes() ?>><?php echo $balance_detailed->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $balance_detailed->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $balance_detailed->remarks->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_remarks" class="balance_detailed_remarks">
<span<?php echo $balance_detailed->remarks->viewAttributes() ?>>
<?php echo $balance_detailed->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $balance_detailed->uploads->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_uploads" class="balance_detailed_uploads">
<span<?php echo $balance_detailed->uploads->viewAttributes() ?>>
<?php echo GetFileViewTag($balance_detailed->uploads, $balance_detailed->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->type->Visible) { // type ?>
		<td data-name="type"<?php echo $balance_detailed->type->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_type" class="balance_detailed_type">
<span<?php echo $balance_detailed->type->viewAttributes() ?>>
<?php echo $balance_detailed->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $balance_detailed->reference->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_reference" class="balance_detailed_reference">
<span<?php echo $balance_detailed->reference->viewAttributes() ?>>
<?php echo $balance_detailed->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $balance_detailed->operator->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_operator" class="balance_detailed_operator">
<span<?php echo $balance_detailed->operator->viewAttributes() ?>>
<?php echo $balance_detailed->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance_detailed->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $balance_detailed->datetime->cellAttributes() ?>>
<span id="el<?php echo $balance_detailed_list->RowCnt ?>_balance_detailed_datetime" class="balance_detailed_datetime">
<span<?php echo $balance_detailed->datetime->viewAttributes() ?>>
<?php echo $balance_detailed->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$balance_detailed_list->ListOptions->render("body", "right", $balance_detailed_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$balance_detailed->isGridAdd())
		$balance_detailed_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$balance_detailed->RowType = ROWTYPE_AGGREGATE;
$balance_detailed->resetAttributes();
$balance_detailed_list->renderRow();
?>
<?php if ($balance_detailed_list->TotalRecs > 0 && !$balance_detailed->isGridAdd() && !$balance_detailed->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$balance_detailed_list->renderListOptions();

// Render list options (footer, left)
$balance_detailed_list->ListOptions->render("footer", "left");
?>
	<?php if ($balance_detailed->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $balance_detailed->id->footerCellClass() ?>"><span id="elf_balance_detailed_id" class="balance_detailed_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->account->Visible) { // account ?>
		<td data-name="account" class="<?php echo $balance_detailed->account->footerCellClass() ?>"><span id="elf_balance_detailed_account" class="balance_detailed_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->name->Visible) { // name ?>
		<td data-name="name" class="<?php echo $balance_detailed->name->footerCellClass() ?>"><span id="elf_balance_detailed_name" class="balance_detailed_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->ref_account->Visible) { // ref_account ?>
		<td data-name="ref_account" class="<?php echo $balance_detailed->ref_account->footerCellClass() ?>"><span id="elf_balance_detailed_ref_account" class="balance_detailed_ref_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->debit->Visible) { // debit ?>
		<td data-name="debit" class="<?php echo $balance_detailed->debit->footerCellClass() ?>"><span id="elf_balance_detailed_debit" class="balance_detailed_debit">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $balance_detailed->debit->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->credit->Visible) { // credit ?>
		<td data-name="credit" class="<?php echo $balance_detailed->credit->footerCellClass() ?>"><span id="elf_balance_detailed_credit" class="balance_detailed_credit">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $balance_detailed->credit->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $balance_detailed->balance->footerCellClass() ?>"><span id="elf_balance_detailed_balance" class="balance_detailed_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $balance_detailed->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $balance_detailed->dated->footerCellClass() ?>"><span id="elf_balance_detailed_dated" class="balance_detailed_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $balance_detailed->remarks->footerCellClass() ?>"><span id="elf_balance_detailed_remarks" class="balance_detailed_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->uploads->Visible) { // uploads ?>
		<td data-name="uploads" class="<?php echo $balance_detailed->uploads->footerCellClass() ?>"><span id="elf_balance_detailed_uploads" class="balance_detailed_uploads">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $balance_detailed->type->footerCellClass() ?>"><span id="elf_balance_detailed_type" class="balance_detailed_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->reference->Visible) { // reference ?>
		<td data-name="reference" class="<?php echo $balance_detailed->reference->footerCellClass() ?>"><span id="elf_balance_detailed_reference" class="balance_detailed_reference">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $balance_detailed->operator->footerCellClass() ?>"><span id="elf_balance_detailed_operator" class="balance_detailed_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance_detailed->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $balance_detailed->datetime->footerCellClass() ?>"><span id="elf_balance_detailed_datetime" class="balance_detailed_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$balance_detailed_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$balance_detailed->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($balance_detailed_list->Recordset)
	$balance_detailed_list->Recordset->Close();
?>
<?php if (!$balance_detailed->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$balance_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($balance_detailed_list->Pager)) $balance_detailed_list->Pager = new PrevNextPager($balance_detailed_list->StartRec, $balance_detailed_list->DisplayRecs, $balance_detailed_list->TotalRecs, $balance_detailed_list->AutoHidePager) ?>
<?php if ($balance_detailed_list->Pager->RecordCount > 0 && $balance_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($balance_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($balance_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $balance_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($balance_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($balance_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $balance_detailed_list->pageUrl() ?>start=<?php echo $balance_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $balance_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($balance_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $balance_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $balance_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $balance_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($balance_detailed_list->TotalRecs > 0 && (!$balance_detailed_list->AutoHidePageSizeSelector || $balance_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="balance_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($balance_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($balance_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($balance_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($balance_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($balance_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($balance_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $balance_detailed_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($balance_detailed_list->TotalRecs == 0 && !$balance_detailed->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $balance_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$balance_detailed_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$balance_detailed->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$balance_detailed->isExport()) { ?>
<script>
ew.scrollableTable("gmp_balance_detailed", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$balance_detailed_list->terminate();
?>