<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$balance_detailed_search = new balance_detailed_search();

// Run the page
$balance_detailed_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$balance_detailed_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($balance_detailed_search->IsModal) { ?>
var fbalance_detailedsearch = currentAdvancedSearchForm = new ew.Form("fbalance_detailedsearch", "search");
<?php } else { ?>
var fbalance_detailedsearch = currentForm = new ew.Form("fbalance_detailedsearch", "search");
<?php } ?>

// Form_CustomValidate event
fbalance_detailedsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbalance_detailedsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbalance_detailedsearch.lists["x_account"] = <?php echo $balance_detailed_search->account->Lookup->toClientList() ?>;
fbalance_detailedsearch.lists["x_account"].options = <?php echo JsonEncode($balance_detailed_search->account->lookupOptions()) ?>;
fbalance_detailedsearch.lists["x_ref_account"] = <?php echo $balance_detailed_search->ref_account->Lookup->toClientList() ?>;
fbalance_detailedsearch.lists["x_ref_account"].options = <?php echo JsonEncode($balance_detailed_search->ref_account->lookupOptions()) ?>;
fbalance_detailedsearch.lists["x_operator"] = <?php echo $balance_detailed_search->operator->Lookup->toClientList() ?>;
fbalance_detailedsearch.lists["x_operator"].options = <?php echo JsonEncode($balance_detailed_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbalance_detailedsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_debit");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->debit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_credit");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->credit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance_detailed->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $balance_detailed_search->showPageHeader(); ?>
<?php
$balance_detailed_search->showMessage();
?>
<form name="fbalance_detailedsearch" id="fbalance_detailedsearch" class="<?php echo $balance_detailed_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($balance_detailed_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $balance_detailed_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="balance_detailed">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$balance_detailed_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($balance_detailed->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_id"><?php echo $balance_detailed->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->id->cellAttributes() ?>>
			<span id="el_balance_detailed_id">
<input type="text" data-table="balance_detailed" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($balance_detailed->id->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->id->EditValue ?>"<?php echo $balance_detailed->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->account->Visible) { // account ?>
	<div id="r_account" class="form-group row">
		<label for="x_account" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_account"><?php echo $balance_detailed->account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_account" id="z_account" value="="></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->account->cellAttributes() ?>>
			<span id="el_balance_detailed_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance_detailed" data-field="x_account" data-value-separator="<?php echo $balance_detailed->account->displayValueSeparatorAttribute() ?>" id="x_account" name="x_account"<?php echo $balance_detailed->account->editAttributes() ?>>
		<?php echo $balance_detailed->account->selectOptionListHtml("x_account") ?>
	</select>
</div>
<?php echo $balance_detailed->account->Lookup->getParamTag("p_x_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_name"><?php echo $balance_detailed->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->name->cellAttributes() ?>>
			<span id="el_balance_detailed_name">
<input type="text" data-table="balance_detailed" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($balance_detailed->name->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->name->EditValue ?>"<?php echo $balance_detailed->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->ref_account->Visible) { // ref_account ?>
	<div id="r_ref_account" class="form-group row">
		<label for="x_ref_account" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_ref_account"><?php echo $balance_detailed->ref_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref_account" id="z_ref_account" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->ref_account->cellAttributes() ?>>
			<span id="el_balance_detailed_ref_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance_detailed" data-field="x_ref_account" data-value-separator="<?php echo $balance_detailed->ref_account->displayValueSeparatorAttribute() ?>" id="x_ref_account" name="x_ref_account"<?php echo $balance_detailed->ref_account->editAttributes() ?>>
		<?php echo $balance_detailed->ref_account->selectOptionListHtml("x_ref_account") ?>
	</select>
</div>
<?php echo $balance_detailed->ref_account->Lookup->getParamTag("p_x_ref_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->debit->Visible) { // debit ?>
	<div id="r_debit" class="form-group row">
		<label for="x_debit" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_debit"><?php echo $balance_detailed->debit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_debit" id="z_debit" value="="></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->debit->cellAttributes() ?>>
			<span id="el_balance_detailed_debit">
<input type="text" data-table="balance_detailed" data-field="x_debit" name="x_debit" id="x_debit" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->debit->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->debit->EditValue ?>"<?php echo $balance_detailed->debit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->credit->Visible) { // credit ?>
	<div id="r_credit" class="form-group row">
		<label for="x_credit" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_credit"><?php echo $balance_detailed->credit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_credit" id="z_credit" value="="></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->credit->cellAttributes() ?>>
			<span id="el_balance_detailed_credit">
<input type="text" data-table="balance_detailed" data-field="x_credit" name="x_credit" id="x_credit" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->credit->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->credit->EditValue ?>"<?php echo $balance_detailed->credit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_balance"><?php echo $balance_detailed->balance->caption() ?></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance_detailed->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_balance_detailed_balance">
<input type="text" data-table="balance_detailed" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->balance->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->balance->EditValue ?>"<?php echo $balance_detailed->balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_balance_detailed_balance" class="btw1_balance d-none">
<input type="text" data-table="balance_detailed" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($balance_detailed->balance->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->balance->EditValue2 ?>"<?php echo $balance_detailed->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_dated"><?php echo $balance_detailed->dated->caption() ?></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance_detailed->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_balance_detailed_dated">
<input type="text" data-table="balance_detailed" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($balance_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->dated->EditValue ?>"<?php echo $balance_detailed->dated->editAttributes() ?>>
<?php if (!$balance_detailed->dated->ReadOnly && !$balance_detailed->dated->Disabled && !isset($balance_detailed->dated->EditAttrs["readonly"]) && !isset($balance_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbalance_detailedsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_balance_detailed_dated" class="btw1_dated d-none">
<input type="text" data-table="balance_detailed" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($balance_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->dated->EditValue2 ?>"<?php echo $balance_detailed->dated->editAttributes() ?>>
<?php if (!$balance_detailed->dated->ReadOnly && !$balance_detailed->dated->Disabled && !isset($balance_detailed->dated->EditAttrs["readonly"]) && !isset($balance_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbalance_detailedsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_remarks"><?php echo $balance_detailed->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->remarks->cellAttributes() ?>>
			<span id="el_balance_detailed_remarks">
<input type="text" data-table="balance_detailed" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($balance_detailed->remarks->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->remarks->EditValue ?>"<?php echo $balance_detailed->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_uploads"><?php echo $balance_detailed->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->uploads->cellAttributes() ?>>
			<span id="el_balance_detailed_uploads">
<input type="text" data-table="balance_detailed" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($balance_detailed->uploads->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->uploads->EditValue ?>"<?php echo $balance_detailed->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_type"><?php echo $balance_detailed->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->type->cellAttributes() ?>>
			<span id="el_balance_detailed_type">
<input type="text" data-table="balance_detailed" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="7" placeholder="<?php echo HtmlEncode($balance_detailed->type->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->type->EditValue ?>"<?php echo $balance_detailed->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_reference"><?php echo $balance_detailed->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_reference" id="z_reference" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->reference->cellAttributes() ?>>
			<span id="el_balance_detailed_reference">
<input type="text" data-table="balance_detailed" data-field="x_reference" name="x_reference" id="x_reference" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($balance_detailed->reference->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->reference->EditValue ?>"<?php echo $balance_detailed->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_operator"><?php echo $balance_detailed->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->operator->cellAttributes() ?>>
			<span id="el_balance_detailed_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance_detailed" data-field="x_operator" data-value-separator="<?php echo $balance_detailed->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $balance_detailed->operator->editAttributes() ?>>
		<?php echo $balance_detailed->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $balance_detailed->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance_detailed->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $balance_detailed_search->LeftColumnClass ?>"><span id="elh_balance_detailed_datetime"><?php echo $balance_detailed->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $balance_detailed_search->RightColumnClass ?>"><div<?php echo $balance_detailed->datetime->cellAttributes() ?>>
			<span id="el_balance_detailed_datetime">
<input type="text" data-table="balance_detailed" data-field="x_datetime" data-format="2" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($balance_detailed->datetime->getPlaceHolder()) ?>" value="<?php echo $balance_detailed->datetime->EditValue ?>"<?php echo $balance_detailed->datetime->editAttributes() ?>>
<?php if (!$balance_detailed->datetime->ReadOnly && !$balance_detailed->datetime->Disabled && !isset($balance_detailed->datetime->EditAttrs["readonly"]) && !isset($balance_detailed->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbalance_detailedsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$balance_detailed_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $balance_detailed_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$balance_detailed_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$balance_detailed_search->terminate();
?>