<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$balance_list = new balance_list();

// Run the page
$balance_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$balance_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$balance->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbalancelist = currentForm = new ew.Form("fbalancelist", "list");
fbalancelist.formKeyCountName = '<?php echo $balance_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbalancelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbalancelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbalancelist.lists["x_sub_category"] = <?php echo $balance_list->sub_category->Lookup->toClientList() ?>;
fbalancelist.lists["x_sub_category"].options = <?php echo JsonEncode($balance_list->sub_category->lookupOptions()) ?>;
fbalancelist.lists["x_account"] = <?php echo $balance_list->account->Lookup->toClientList() ?>;
fbalancelist.lists["x_account"].options = <?php echo JsonEncode($balance_list->account->lookupOptions()) ?>;
fbalancelist.autoSuggests["x_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fbalancelistsrch = currentSearchForm = new ew.Form("fbalancelistsrch");

// Validate function for search
fbalancelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance->account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance->balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbalancelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbalancelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbalancelistsrch.lists["x_sub_category"] = <?php echo $balance_list->sub_category->Lookup->toClientList() ?>;
fbalancelistsrch.lists["x_sub_category"].options = <?php echo JsonEncode($balance_list->sub_category->lookupOptions()) ?>;
fbalancelistsrch.lists["x_account"] = <?php echo $balance_list->account->Lookup->toClientList() ?>;
fbalancelistsrch.lists["x_account"].options = <?php echo JsonEncode($balance_list->account->lookupOptions()) ?>;
fbalancelistsrch.autoSuggests["x_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fbalancelistsrch.filterList = <?php echo $balance_list->getFilterList() ?>;

// Init search panel as collapsed
fbalancelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$balance->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($balance_list->TotalRecs > 0 && $balance_list->ExportOptions->visible()) { ?>
<?php $balance_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($balance_list->ImportOptions->visible()) { ?>
<?php $balance_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($balance_list->SearchOptions->visible()) { ?>
<?php $balance_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($balance_list->FilterOptions->visible()) { ?>
<?php $balance_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$balance_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$balance->isExport() && !$balance->CurrentAction) { ?>
<form name="fbalancelistsrch" id="fbalancelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($balance_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbalancelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="balance">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$balance_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$balance->RowType = ROWTYPE_SEARCH;

// Render row
$balance->resetAttributes();
$balance_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($balance->sub_category->Visible) { // sub_category ?>
	<div id="xsc_sub_category" class="ew-cell form-group">
		<label for="x_sub_category" class="ew-search-caption ew-label"><?php echo $balance->sub_category->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sub_category" id="z_sub_category" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance" data-field="x_sub_category" data-value-separator="<?php echo $balance->sub_category->displayValueSeparatorAttribute() ?>" id="x_sub_category" name="x_sub_category"<?php echo $balance->sub_category->editAttributes() ?>>
		<?php echo $balance->sub_category->selectOptionListHtml("x_sub_category") ?>
	</select>
</div>
<?php echo $balance->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
</span>
	</div>
<?php } ?>
<?php if ($balance->account->Visible) { // account ?>
	<div id="xsc_account" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $balance->account->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_account" id="z_account" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$balance->account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$balance->account->EditAttrs["onchange"] = "";
?>
<span id="as_x_account" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_account" id="sv_x_account" value="<?php echo RemoveHtml($balance->account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($balance->account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($balance->account->getPlaceHolder()) ?>"<?php echo $balance->account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($balance->account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($balance->account->ReadOnly || $balance->account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="balance" data-field="x_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $balance->account->displayValueSeparatorAttribute() ?>" name="x_account" id="x_account" value="<?php echo HtmlEncode($balance->account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbalancelistsrch.createAutoSuggest({"id":"x_account","forceSelect":true});
</script>
<?php echo $balance->account->Lookup->getParamTag("p_x_account") ?>
</span>
	</div>
<?php } ?>
<?php if ($balance->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $balance->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="balance" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($balance->name->getPlaceHolder()) ?>" value="<?php echo $balance->name->EditValue ?>"<?php echo $balance->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($balance->balance->Visible) { // balance ?>
	<div id="xsc_balance" class="ew-cell form-group">
		<label for="x_balance" class="ew-search-caption ew-label"><?php echo $balance->balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="balance" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($balance->balance->getPlaceHolder()) ?>" value="<?php echo $balance->balance->EditValue ?>"<?php echo $balance->balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_balance style="d-none"">
<input type="text" data-table="balance" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($balance->balance->getPlaceHolder()) ?>" value="<?php echo $balance->balance->EditValue2 ?>"<?php echo $balance->balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($balance_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($balance_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $balance_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($balance_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($balance_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($balance_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($balance_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $balance_list->showPageHeader(); ?>
<?php
$balance_list->showMessage();
?>
<?php if ($balance_list->TotalRecs > 0 || $balance->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($balance_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> balance">
<?php if (!$balance->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($balance_list->Pager)) $balance_list->Pager = new PrevNextPager($balance_list->StartRec, $balance_list->DisplayRecs, $balance_list->TotalRecs, $balance_list->AutoHidePager) ?>
<?php if ($balance_list->Pager->RecordCount > 0 && $balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($balance_list->TotalRecs > 0 && (!$balance_list->AutoHidePageSizeSelector || $balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbalancelist" id="fbalancelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($balance_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $balance_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="balance">
<div id="gmp_balance" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($balance_list->TotalRecs > 0 || $balance->isGridEdit()) { ?>
<table id="tbl_balancelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$balance_list->RowType = ROWTYPE_HEADER;

// Render list options
$balance_list->renderListOptions();

// Render list options (header, left)
$balance_list->ListOptions->render("header", "left");
?>
<?php if ($balance->sub_category->Visible) { // sub_category ?>
	<?php if ($balance->sortUrl($balance->sub_category) == "") { ?>
		<th data-name="sub_category" class="<?php echo $balance->sub_category->headerCellClass() ?>"><div id="elh_balance_sub_category" class="balance_sub_category"><div class="ew-table-header-caption"><?php echo $balance->sub_category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sub_category" class="<?php echo $balance->sub_category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance->SortUrl($balance->sub_category) ?>',2);"><div id="elh_balance_sub_category" class="balance_sub_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance->sub_category->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance->sub_category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance->sub_category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance->account->Visible) { // account ?>
	<?php if ($balance->sortUrl($balance->account) == "") { ?>
		<th data-name="account" class="<?php echo $balance->account->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_balance_account" class="balance_account"><div class="ew-table-header-caption"><?php echo $balance->account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account" class="<?php echo $balance->account->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance->SortUrl($balance->account) ?>',2);"><div id="elh_balance_account" class="balance_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance->account->caption() ?></span><span class="ew-table-header-sort"><?php if ($balance->account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance->account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance->name->Visible) { // name ?>
	<?php if ($balance->sortUrl($balance->name) == "") { ?>
		<th data-name="name" class="<?php echo $balance->name->headerCellClass() ?>"><div id="elh_balance_name" class="balance_name"><div class="ew-table-header-caption"><?php echo $balance->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $balance->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance->SortUrl($balance->name) ?>',2);"><div id="elh_balance_name" class="balance_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance->debit->Visible) { // debit ?>
	<?php if ($balance->sortUrl($balance->debit) == "") { ?>
		<th data-name="debit" class="<?php echo $balance->debit->headerCellClass() ?>"><div id="elh_balance_debit" class="balance_debit"><div class="ew-table-header-caption"><?php echo $balance->debit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="debit" class="<?php echo $balance->debit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance->SortUrl($balance->debit) ?>',2);"><div id="elh_balance_debit" class="balance_debit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance->debit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance->debit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance->debit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance->credit->Visible) { // credit ?>
	<?php if ($balance->sortUrl($balance->credit) == "") { ?>
		<th data-name="credit" class="<?php echo $balance->credit->headerCellClass() ?>"><div id="elh_balance_credit" class="balance_credit"><div class="ew-table-header-caption"><?php echo $balance->credit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="credit" class="<?php echo $balance->credit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance->SortUrl($balance->credit) ?>',2);"><div id="elh_balance_credit" class="balance_credit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance->credit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance->credit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance->credit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($balance->balance->Visible) { // balance ?>
	<?php if ($balance->sortUrl($balance->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $balance->balance->headerCellClass() ?>"><div id="elh_balance_balance" class="balance_balance"><div class="ew-table-header-caption"><?php echo $balance->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $balance->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $balance->SortUrl($balance->balance) ?>',2);"><div id="elh_balance_balance" class="balance_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $balance->balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($balance->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($balance->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$balance_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($balance->ExportAll && $balance->isExport()) {
	$balance_list->StopRec = $balance_list->TotalRecs;
} else {

	// Set the last record to display
	if ($balance_list->TotalRecs > $balance_list->StartRec + $balance_list->DisplayRecs - 1)
		$balance_list->StopRec = $balance_list->StartRec + $balance_list->DisplayRecs - 1;
	else
		$balance_list->StopRec = $balance_list->TotalRecs;
}
$balance_list->RecCnt = $balance_list->StartRec - 1;
if ($balance_list->Recordset && !$balance_list->Recordset->EOF) {
	$balance_list->Recordset->moveFirst();
	$selectLimit = $balance_list->UseSelectLimit;
	if (!$selectLimit && $balance_list->StartRec > 1)
		$balance_list->Recordset->move($balance_list->StartRec - 1);
} elseif (!$balance->AllowAddDeleteRow && $balance_list->StopRec == 0) {
	$balance_list->StopRec = $balance->GridAddRowCount;
}

// Initialize aggregate
$balance->RowType = ROWTYPE_AGGREGATEINIT;
$balance->resetAttributes();
$balance_list->renderRow();
while ($balance_list->RecCnt < $balance_list->StopRec) {
	$balance_list->RecCnt++;
	if ($balance_list->RecCnt >= $balance_list->StartRec) {
		$balance_list->RowCnt++;

		// Set up key count
		$balance_list->KeyCount = $balance_list->RowIndex;

		// Init row class and style
		$balance->resetAttributes();
		$balance->CssClass = "";
		if ($balance->isGridAdd()) {
		} else {
			$balance_list->loadRowValues($balance_list->Recordset); // Load row values
		}
		$balance->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$balance->RowAttrs = array_merge($balance->RowAttrs, array('data-rowindex'=>$balance_list->RowCnt, 'id'=>'r' . $balance_list->RowCnt . '_balance', 'data-rowtype'=>$balance->RowType));

		// Render row
		$balance_list->renderRow();

		// Render list options
		$balance_list->renderListOptions();
?>
	<tr<?php echo $balance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$balance_list->ListOptions->render("body", "left", $balance_list->RowCnt);
?>
	<?php if ($balance->sub_category->Visible) { // sub_category ?>
		<td data-name="sub_category"<?php echo $balance->sub_category->cellAttributes() ?>>
<span id="el<?php echo $balance_list->RowCnt ?>_balance_sub_category" class="balance_sub_category">
<span<?php echo $balance->sub_category->viewAttributes() ?>>
<?php echo $balance->sub_category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance->account->Visible) { // account ?>
		<td data-name="account"<?php echo $balance->account->cellAttributes() ?>>
<span id="el<?php echo $balance_list->RowCnt ?>_balance_account" class="balance_account">
<span<?php echo $balance->account->viewAttributes() ?>>
<?php if ((!EmptyString($balance->account->getViewValue())) && $balance->account->linkAttributes() <> "") { ?>
<a<?php echo $balance->account->linkAttributes() ?>><?php echo $balance->account->getViewValue() ?></a>
<?php } else { ?>
<?php echo $balance->account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($balance->name->Visible) { // name ?>
		<td data-name="name"<?php echo $balance->name->cellAttributes() ?>>
<span id="el<?php echo $balance_list->RowCnt ?>_balance_name" class="balance_name">
<span<?php echo $balance->name->viewAttributes() ?>>
<?php if ((!EmptyString($balance->name->getViewValue())) && $balance->name->linkAttributes() <> "") { ?>
<a<?php echo $balance->name->linkAttributes() ?>><?php echo $balance->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $balance->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($balance->debit->Visible) { // debit ?>
		<td data-name="debit"<?php echo $balance->debit->cellAttributes() ?>>
<span id="el<?php echo $balance_list->RowCnt ?>_balance_debit" class="balance_debit">
<span<?php echo $balance->debit->viewAttributes() ?>>
<?php echo $balance->debit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance->credit->Visible) { // credit ?>
		<td data-name="credit"<?php echo $balance->credit->cellAttributes() ?>>
<span id="el<?php echo $balance_list->RowCnt ?>_balance_credit" class="balance_credit">
<span<?php echo $balance->credit->viewAttributes() ?>>
<?php echo $balance->credit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($balance->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $balance->balance->cellAttributes() ?>>
<span id="el<?php echo $balance_list->RowCnt ?>_balance_balance" class="balance_balance">
<span<?php echo $balance->balance->viewAttributes() ?>>
<?php if ((!EmptyString($balance->balance->getViewValue())) && $balance->balance->linkAttributes() <> "") { ?>
<a<?php echo $balance->balance->linkAttributes() ?>><?php echo $balance->balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $balance->balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$balance_list->ListOptions->render("body", "right", $balance_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$balance->isGridAdd())
		$balance_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$balance->RowType = ROWTYPE_AGGREGATE;
$balance->resetAttributes();
$balance_list->renderRow();
?>
<?php if ($balance_list->TotalRecs > 0 && !$balance->isGridAdd() && !$balance->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$balance_list->renderListOptions();

// Render list options (footer, left)
$balance_list->ListOptions->render("footer", "left");
?>
	<?php if ($balance->sub_category->Visible) { // sub_category ?>
		<td data-name="sub_category" class="<?php echo $balance->sub_category->footerCellClass() ?>"><span id="elf_balance_sub_category" class="balance_sub_category">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance->account->Visible) { // account ?>
		<td data-name="account" class="<?php echo $balance->account->footerCellClass() ?>"><span id="elf_balance_account" class="balance_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance->name->Visible) { // name ?>
		<td data-name="name" class="<?php echo $balance->name->footerCellClass() ?>"><span id="elf_balance_name" class="balance_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($balance->debit->Visible) { // debit ?>
		<td data-name="debit" class="<?php echo $balance->debit->footerCellClass() ?>"><span id="elf_balance_debit" class="balance_debit">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $balance->debit->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($balance->credit->Visible) { // credit ?>
		<td data-name="credit" class="<?php echo $balance->credit->footerCellClass() ?>"><span id="elf_balance_credit" class="balance_credit">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $balance->credit->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($balance->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $balance->balance->footerCellClass() ?>"><span id="elf_balance_balance" class="balance_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $balance->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$balance_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$balance->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($balance_list->Recordset)
	$balance_list->Recordset->Close();
?>
<?php if (!$balance->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($balance_list->Pager)) $balance_list->Pager = new PrevNextPager($balance_list->StartRec, $balance_list->DisplayRecs, $balance_list->TotalRecs, $balance_list->AutoHidePager) ?>
<?php if ($balance_list->Pager->RecordCount > 0 && $balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $balance_list->pageUrl() ?>start=<?php echo $balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($balance_list->TotalRecs > 0 && (!$balance_list->AutoHidePageSizeSelector || $balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $balance_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($balance_list->TotalRecs == 0 && !$balance->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$balance_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$balance->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$balance->isExport()) { ?>
<script>
ew.scrollableTable("gmp_balance", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$balance_list->terminate();
?>