<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$balance_search = new balance_search();

// Run the page
$balance_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$balance_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($balance_search->IsModal) { ?>
var fbalancesearch = currentAdvancedSearchForm = new ew.Form("fbalancesearch", "search");
<?php } else { ?>
var fbalancesearch = currentForm = new ew.Form("fbalancesearch", "search");
<?php } ?>

// Form_CustomValidate event
fbalancesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbalancesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbalancesearch.lists["x_grp"] = <?php echo $balance_search->grp->Lookup->toClientList() ?>;
fbalancesearch.lists["x_grp"].options = <?php echo JsonEncode($balance_search->grp->lookupOptions()) ?>;
fbalancesearch.lists["x_sub_category"] = <?php echo $balance_search->sub_category->Lookup->toClientList() ?>;
fbalancesearch.lists["x_sub_category"].options = <?php echo JsonEncode($balance_search->sub_category->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbalancesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance->account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_debit");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance->debit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_credit");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance->credit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($balance->balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $balance_search->showPageHeader(); ?>
<?php
$balance_search->showMessage();
?>
<form name="fbalancesearch" id="fbalancesearch" class="<?php echo $balance_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($balance_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $balance_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="balance">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$balance_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($balance->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $balance_search->LeftColumnClass ?>"><span id="elh_balance_grp"><?php echo $balance->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_grp" id="z_grp" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_search->RightColumnClass ?>"><div<?php echo $balance->grp->cellAttributes() ?>>
			<span id="el_balance_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance" data-field="x_grp" data-value-separator="<?php echo $balance->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $balance->grp->editAttributes() ?>>
		<?php echo $balance->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $balance->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance->sub_category->Visible) { // sub_category ?>
	<div id="r_sub_category" class="form-group row">
		<label for="x_sub_category" class="<?php echo $balance_search->LeftColumnClass ?>"><span id="elh_balance_sub_category"><?php echo $balance->sub_category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sub_category" id="z_sub_category" value="="></span>
		</label>
		<div class="<?php echo $balance_search->RightColumnClass ?>"><div<?php echo $balance->sub_category->cellAttributes() ?>>
			<span id="el_balance_sub_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="balance" data-field="x_sub_category" data-value-separator="<?php echo $balance->sub_category->displayValueSeparatorAttribute() ?>" id="x_sub_category" name="x_sub_category"<?php echo $balance->sub_category->editAttributes() ?>>
		<?php echo $balance->sub_category->selectOptionListHtml("x_sub_category") ?>
	</select>
</div>
<?php echo $balance->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $balance_search->LeftColumnClass ?>"><span id="elh_balance_name"><?php echo $balance->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $balance_search->RightColumnClass ?>"><div<?php echo $balance->name->cellAttributes() ?>>
			<span id="el_balance_name">
<input type="text" data-table="balance" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($balance->name->getPlaceHolder()) ?>" value="<?php echo $balance->name->EditValue ?>"<?php echo $balance->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance->debit->Visible) { // debit ?>
	<div id="r_debit" class="form-group row">
		<label for="x_debit" class="<?php echo $balance_search->LeftColumnClass ?>"><span id="elh_balance_debit"><?php echo $balance->debit->caption() ?></span>
		</label>
		<div class="<?php echo $balance_search->RightColumnClass ?>"><div<?php echo $balance->debit->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_debit" id="z_debit" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance->debit->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance->debit->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance->debit->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance->debit->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance->debit->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance->debit->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance->debit->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance->debit->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance->debit->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_balance_debit">
<input type="text" data-table="balance" data-field="x_debit" name="x_debit" id="x_debit" size="30" placeholder="<?php echo HtmlEncode($balance->debit->getPlaceHolder()) ?>" value="<?php echo $balance->debit->EditValue ?>"<?php echo $balance->debit->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_debit d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_balance_debit" class="btw1_debit d-none">
<input type="text" data-table="balance" data-field="x_debit" name="y_debit" id="y_debit" size="30" placeholder="<?php echo HtmlEncode($balance->debit->getPlaceHolder()) ?>" value="<?php echo $balance->debit->EditValue2 ?>"<?php echo $balance->debit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance->credit->Visible) { // credit ?>
	<div id="r_credit" class="form-group row">
		<label for="x_credit" class="<?php echo $balance_search->LeftColumnClass ?>"><span id="elh_balance_credit"><?php echo $balance->credit->caption() ?></span>
		</label>
		<div class="<?php echo $balance_search->RightColumnClass ?>"><div<?php echo $balance->credit->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_credit" id="z_credit" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance->credit->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance->credit->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance->credit->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance->credit->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance->credit->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance->credit->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance->credit->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance->credit->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance->credit->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_balance_credit">
<input type="text" data-table="balance" data-field="x_credit" name="x_credit" id="x_credit" size="30" placeholder="<?php echo HtmlEncode($balance->credit->getPlaceHolder()) ?>" value="<?php echo $balance->credit->EditValue ?>"<?php echo $balance->credit->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_credit d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_balance_credit" class="btw1_credit d-none">
<input type="text" data-table="balance" data-field="x_credit" name="y_credit" id="y_credit" size="30" placeholder="<?php echo HtmlEncode($balance->credit->getPlaceHolder()) ?>" value="<?php echo $balance->credit->EditValue2 ?>"<?php echo $balance->credit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($balance->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $balance_search->LeftColumnClass ?>"><span id="elh_balance_balance"><?php echo $balance->balance->caption() ?></span>
		</label>
		<div class="<?php echo $balance_search->RightColumnClass ?>"><div<?php echo $balance->balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($balance->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($balance->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_balance_balance">
<input type="text" data-table="balance" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($balance->balance->getPlaceHolder()) ?>" value="<?php echo $balance->balance->EditValue ?>"<?php echo $balance->balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_balance_balance" class="btw1_balance d-none">
<input type="text" data-table="balance" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($balance->balance->getPlaceHolder()) ?>" value="<?php echo $balance->balance->EditValue2 ?>"<?php echo $balance->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$balance_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $balance_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$balance_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$balance_search->terminate();
?>