<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bank_add = new bank_add();

// Run the page
$bank_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bank_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fbankadd = currentForm = new ew.Form("fbankadd", "add");

// Validate form
fbankadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bank_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->name->caption(), $bank->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->code->caption(), $bank->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($bank->code->errorMessage()) ?>");
		<?php if ($bank_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->status->caption(), $bank->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->operator->caption(), $bank->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->datetime->caption(), $bank->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbankadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbankadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbankadd.lists["x_status"] = <?php echo $bank_add->status->Lookup->toClientList() ?>;
fbankadd.lists["x_status"].options = <?php echo JsonEncode($bank_add->status->options(FALSE, TRUE)) ?>;
fbankadd.lists["x_operator"] = <?php echo $bank_add->operator->Lookup->toClientList() ?>;
fbankadd.lists["x_operator"].options = <?php echo JsonEncode($bank_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bank_add->showPageHeader(); ?>
<?php
$bank_add->showMessage();
?>
<form name="fbankadd" id="fbankadd" class="<?php echo $bank_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bank_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bank_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bank">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$bank_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($bank->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_bank_name" for="x_name" class="<?php echo $bank_add->LeftColumnClass ?>"><?php echo $bank->name->caption() ?><?php echo ($bank->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bank_add->RightColumnClass ?>"><div<?php echo $bank->name->cellAttributes() ?>>
<span id="el_bank_name">
<input type="text" data-table="bank" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($bank->name->getPlaceHolder()) ?>" value="<?php echo $bank->name->EditValue ?>"<?php echo $bank->name->editAttributes() ?>>
</span>
<?php echo $bank->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bank->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_bank_code" for="x_code" class="<?php echo $bank_add->LeftColumnClass ?>"><?php echo $bank->code->caption() ?><?php echo ($bank->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bank_add->RightColumnClass ?>"><div<?php echo $bank->code->cellAttributes() ?>>
<span id="el_bank_code">
<input type="text" data-table="bank" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($bank->code->getPlaceHolder()) ?>" value="<?php echo $bank->code->EditValue ?>"<?php echo $bank->code->editAttributes() ?>>
</span>
<?php echo $bank->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bank->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_bank_status" for="x_status" class="<?php echo $bank_add->LeftColumnClass ?>"><?php echo $bank->status->caption() ?><?php echo ($bank->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bank_add->RightColumnClass ?>"><div<?php echo $bank->status->cellAttributes() ?>>
<span id="el_bank_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bank" data-field="x_status" data-value-separator="<?php echo $bank->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bank->status->editAttributes() ?>>
		<?php echo $bank->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $bank->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bank_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bank_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $bank_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bank_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bank_add->terminate();
?>