<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bank_addopt = new bank_addopt();

// Run the page
$bank_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bank_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fbankaddopt = currentForm = new ew.Form("fbankaddopt", "addopt");

// Validate form
fbankaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bank_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->name->caption(), $bank->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->code->caption(), $bank->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($bank->code->errorMessage()) ?>");
		<?php if ($bank_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->status->caption(), $bank->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->operator->caption(), $bank->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->datetime->caption(), $bank->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbankaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbankaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbankaddopt.lists["x_status"] = <?php echo $bank_addopt->status->Lookup->toClientList() ?>;
fbankaddopt.lists["x_status"].options = <?php echo JsonEncode($bank_addopt->status->options(FALSE, TRUE)) ?>;
fbankaddopt.lists["x_operator"] = <?php echo $bank_addopt->operator->Lookup->toClientList() ?>;
fbankaddopt.lists["x_operator"].options = <?php echo JsonEncode($bank_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bank_addopt->showPageHeader(); ?>
<?php
$bank_addopt->showMessage();
?>
<form name="fbankaddopt" id="fbankaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($bank_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bank_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $bank_addopt->TableVar ?>">
<?php if ($bank->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $bank->name->caption() ?><?php echo ($bank->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="bank" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($bank->name->getPlaceHolder()) ?>" value="<?php echo $bank->name->EditValue ?>"<?php echo $bank->name->editAttributes() ?>>
<?php echo $bank->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($bank->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $bank->code->caption() ?><?php echo ($bank->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="bank" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($bank->code->getPlaceHolder()) ?>" value="<?php echo $bank->code->EditValue ?>"<?php echo $bank->code->editAttributes() ?>>
<?php echo $bank->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($bank->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $bank->status->caption() ?><?php echo ($bank->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bank" data-field="x_status" data-value-separator="<?php echo $bank->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bank->status->editAttributes() ?>>
		<?php echo $bank->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $bank->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($bank->operator->Visible) { // operator ?>
	<input type="hidden" data-table="bank" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($bank->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($bank->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="bank" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($bank->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$bank_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$bank_addopt->terminate();
?>