<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bank_edit = new bank_edit();

// Run the page
$bank_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bank_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbankedit = currentForm = new ew.Form("fbankedit", "edit");

// Validate form
fbankedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bank_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->id->caption(), $bank->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->name->caption(), $bank->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->code->caption(), $bank->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($bank->code->errorMessage()) ?>");
		<?php if ($bank_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->status->caption(), $bank->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->operator->caption(), $bank->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bank_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bank->datetime->caption(), $bank->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbankedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbankedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbankedit.lists["x_status"] = <?php echo $bank_edit->status->Lookup->toClientList() ?>;
fbankedit.lists["x_status"].options = <?php echo JsonEncode($bank_edit->status->options(FALSE, TRUE)) ?>;
fbankedit.lists["x_operator"] = <?php echo $bank_edit->operator->Lookup->toClientList() ?>;
fbankedit.lists["x_operator"].options = <?php echo JsonEncode($bank_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bank_edit->showPageHeader(); ?>
<?php
$bank_edit->showMessage();
?>
<form name="fbankedit" id="fbankedit" class="<?php echo $bank_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bank_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bank_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bank">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$bank_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($bank->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_bank_id" class="<?php echo $bank_edit->LeftColumnClass ?>"><?php echo $bank->id->caption() ?><?php echo ($bank->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bank_edit->RightColumnClass ?>"><div<?php echo $bank->id->cellAttributes() ?>>
<span id="el_bank_id">
<span<?php echo $bank->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bank->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bank" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($bank->id->CurrentValue) ?>">
<?php echo $bank->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bank->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_bank_name" for="x_name" class="<?php echo $bank_edit->LeftColumnClass ?>"><?php echo $bank->name->caption() ?><?php echo ($bank->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bank_edit->RightColumnClass ?>"><div<?php echo $bank->name->cellAttributes() ?>>
<span id="el_bank_name">
<input type="text" data-table="bank" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($bank->name->getPlaceHolder()) ?>" value="<?php echo $bank->name->EditValue ?>"<?php echo $bank->name->editAttributes() ?>>
</span>
<?php echo $bank->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bank->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_bank_code" for="x_code" class="<?php echo $bank_edit->LeftColumnClass ?>"><?php echo $bank->code->caption() ?><?php echo ($bank->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bank_edit->RightColumnClass ?>"><div<?php echo $bank->code->cellAttributes() ?>>
<span id="el_bank_code">
<input type="text" data-table="bank" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($bank->code->getPlaceHolder()) ?>" value="<?php echo $bank->code->EditValue ?>"<?php echo $bank->code->editAttributes() ?>>
</span>
<?php echo $bank->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bank->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_bank_status" for="x_status" class="<?php echo $bank_edit->LeftColumnClass ?>"><?php echo $bank->status->caption() ?><?php echo ($bank->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bank_edit->RightColumnClass ?>"><div<?php echo $bank->status->cellAttributes() ?>>
<span id="el_bank_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bank" data-field="x_status" data-value-separator="<?php echo $bank->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bank->status->editAttributes() ?>>
		<?php echo $bank->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $bank->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bank_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bank_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $bank_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bank_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bank_edit->terminate();
?>