<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bank_list = new bank_list();

// Run the page
$bank_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bank_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bank->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbanklist = currentForm = new ew.Form("fbanklist", "list");
fbanklist.formKeyCountName = '<?php echo $bank_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbanklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbanklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbanklist.lists["x_status"] = <?php echo $bank_list->status->Lookup->toClientList() ?>;
fbanklist.lists["x_status"].options = <?php echo JsonEncode($bank_list->status->options(FALSE, TRUE)) ?>;
fbanklist.lists["x_operator"] = <?php echo $bank_list->operator->Lookup->toClientList() ?>;
fbanklist.lists["x_operator"].options = <?php echo JsonEncode($bank_list->operator->lookupOptions()) ?>;

// Form object for search
var fbanklistsrch = currentSearchForm = new ew.Form("fbanklistsrch");

// Filters
fbanklistsrch.filterList = <?php echo $bank_list->getFilterList() ?>;

// Init search panel as collapsed
fbanklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bank->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($bank_list->TotalRecs > 0 && $bank_list->ExportOptions->visible()) { ?>
<?php $bank_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($bank_list->ImportOptions->visible()) { ?>
<?php $bank_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($bank_list->SearchOptions->visible()) { ?>
<?php $bank_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($bank_list->FilterOptions->visible()) { ?>
<?php $bank_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$bank_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$bank->isExport() && !$bank->CurrentAction) { ?>
<form name="fbanklistsrch" id="fbanklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($bank_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbanklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bank">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($bank_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($bank_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $bank_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($bank_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($bank_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($bank_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($bank_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bank_list->showPageHeader(); ?>
<?php
$bank_list->showMessage();
?>
<?php if ($bank_list->TotalRecs > 0 || $bank->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($bank_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> bank">
<?php if (!$bank->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$bank->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bank_list->Pager)) $bank_list->Pager = new PrevNextPager($bank_list->StartRec, $bank_list->DisplayRecs, $bank_list->TotalRecs, $bank_list->AutoHidePager) ?>
<?php if ($bank_list->Pager->RecordCount > 0 && $bank_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bank_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bank_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bank_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bank_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bank_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bank_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bank_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bank_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bank_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bank_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bank_list->TotalRecs > 0 && (!$bank_list->AutoHidePageSizeSelector || $bank_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bank">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bank_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bank_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bank_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bank_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bank_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bank->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bank_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbanklist" id="fbanklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bank_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bank_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bank">
<div id="gmp_bank" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($bank_list->TotalRecs > 0 || $bank->isGridEdit()) { ?>
<table id="tbl_banklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$bank_list->RowType = ROWTYPE_HEADER;

// Render list options
$bank_list->renderListOptions();

// Render list options (header, left)
$bank_list->ListOptions->render("header", "left");
?>
<?php if ($bank->id->Visible) { // id ?>
	<?php if ($bank->sortUrl($bank->id) == "") { ?>
		<th data-name="id" class="<?php echo $bank->id->headerCellClass() ?>"><div id="elh_bank_id" class="bank_id"><div class="ew-table-header-caption"><?php echo $bank->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $bank->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bank->SortUrl($bank->id) ?>',2);"><div id="elh_bank_id" class="bank_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bank->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bank->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bank->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bank->name->Visible) { // name ?>
	<?php if ($bank->sortUrl($bank->name) == "") { ?>
		<th data-name="name" class="<?php echo $bank->name->headerCellClass() ?>"><div id="elh_bank_name" class="bank_name"><div class="ew-table-header-caption"><?php echo $bank->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $bank->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bank->SortUrl($bank->name) ?>',2);"><div id="elh_bank_name" class="bank_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bank->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bank->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bank->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bank->code->Visible) { // code ?>
	<?php if ($bank->sortUrl($bank->code) == "") { ?>
		<th data-name="code" class="<?php echo $bank->code->headerCellClass() ?>"><div id="elh_bank_code" class="bank_code"><div class="ew-table-header-caption"><?php echo $bank->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $bank->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bank->SortUrl($bank->code) ?>',2);"><div id="elh_bank_code" class="bank_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bank->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bank->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bank->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bank->status->Visible) { // status ?>
	<?php if ($bank->sortUrl($bank->status) == "") { ?>
		<th data-name="status" class="<?php echo $bank->status->headerCellClass() ?>"><div id="elh_bank_status" class="bank_status"><div class="ew-table-header-caption"><?php echo $bank->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $bank->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bank->SortUrl($bank->status) ?>',2);"><div id="elh_bank_status" class="bank_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bank->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($bank->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bank->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bank->operator->Visible) { // operator ?>
	<?php if ($bank->sortUrl($bank->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $bank->operator->headerCellClass() ?>"><div id="elh_bank_operator" class="bank_operator"><div class="ew-table-header-caption"><?php echo $bank->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $bank->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bank->SortUrl($bank->operator) ?>',2);"><div id="elh_bank_operator" class="bank_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bank->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($bank->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bank->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bank->datetime->Visible) { // datetime ?>
	<?php if ($bank->sortUrl($bank->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $bank->datetime->headerCellClass() ?>"><div id="elh_bank_datetime" class="bank_datetime"><div class="ew-table-header-caption"><?php echo $bank->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $bank->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bank->SortUrl($bank->datetime) ?>',2);"><div id="elh_bank_datetime" class="bank_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bank->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($bank->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bank->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bank_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bank->ExportAll && $bank->isExport()) {
	$bank_list->StopRec = $bank_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bank_list->TotalRecs > $bank_list->StartRec + $bank_list->DisplayRecs - 1)
		$bank_list->StopRec = $bank_list->StartRec + $bank_list->DisplayRecs - 1;
	else
		$bank_list->StopRec = $bank_list->TotalRecs;
}
$bank_list->RecCnt = $bank_list->StartRec - 1;
if ($bank_list->Recordset && !$bank_list->Recordset->EOF) {
	$bank_list->Recordset->moveFirst();
	$selectLimit = $bank_list->UseSelectLimit;
	if (!$selectLimit && $bank_list->StartRec > 1)
		$bank_list->Recordset->move($bank_list->StartRec - 1);
} elseif (!$bank->AllowAddDeleteRow && $bank_list->StopRec == 0) {
	$bank_list->StopRec = $bank->GridAddRowCount;
}

// Initialize aggregate
$bank->RowType = ROWTYPE_AGGREGATEINIT;
$bank->resetAttributes();
$bank_list->renderRow();
while ($bank_list->RecCnt < $bank_list->StopRec) {
	$bank_list->RecCnt++;
	if ($bank_list->RecCnt >= $bank_list->StartRec) {
		$bank_list->RowCnt++;

		// Set up key count
		$bank_list->KeyCount = $bank_list->RowIndex;

		// Init row class and style
		$bank->resetAttributes();
		$bank->CssClass = "";
		if ($bank->isGridAdd()) {
		} else {
			$bank_list->loadRowValues($bank_list->Recordset); // Load row values
		}
		$bank->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$bank->RowAttrs = array_merge($bank->RowAttrs, array('data-rowindex'=>$bank_list->RowCnt, 'id'=>'r' . $bank_list->RowCnt . '_bank', 'data-rowtype'=>$bank->RowType));

		// Render row
		$bank_list->renderRow();

		// Render list options
		$bank_list->renderListOptions();
?>
	<tr<?php echo $bank->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bank_list->ListOptions->render("body", "left", $bank_list->RowCnt);
?>
	<?php if ($bank->id->Visible) { // id ?>
		<td data-name="id"<?php echo $bank->id->cellAttributes() ?>>
<span id="el<?php echo $bank_list->RowCnt ?>_bank_id" class="bank_id">
<span<?php echo $bank->id->viewAttributes() ?>>
<?php echo $bank->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bank->name->Visible) { // name ?>
		<td data-name="name"<?php echo $bank->name->cellAttributes() ?>>
<span id="el<?php echo $bank_list->RowCnt ?>_bank_name" class="bank_name">
<span<?php echo $bank->name->viewAttributes() ?>>
<?php echo $bank->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bank->code->Visible) { // code ?>
		<td data-name="code"<?php echo $bank->code->cellAttributes() ?>>
<span id="el<?php echo $bank_list->RowCnt ?>_bank_code" class="bank_code">
<span<?php echo $bank->code->viewAttributes() ?>>
<?php echo $bank->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bank->status->Visible) { // status ?>
		<td data-name="status"<?php echo $bank->status->cellAttributes() ?>>
<span id="el<?php echo $bank_list->RowCnt ?>_bank_status" class="bank_status">
<span<?php echo $bank->status->viewAttributes() ?>>
<?php echo $bank->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bank->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $bank->operator->cellAttributes() ?>>
<span id="el<?php echo $bank_list->RowCnt ?>_bank_operator" class="bank_operator">
<span<?php echo $bank->operator->viewAttributes() ?>>
<?php echo $bank->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bank->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $bank->datetime->cellAttributes() ?>>
<span id="el<?php echo $bank_list->RowCnt ?>_bank_datetime" class="bank_datetime">
<span<?php echo $bank->datetime->viewAttributes() ?>>
<?php echo $bank->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bank_list->ListOptions->render("body", "right", $bank_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$bank->isGridAdd())
		$bank_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$bank->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($bank_list->Recordset)
	$bank_list->Recordset->Close();
?>
<?php if (!$bank->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$bank->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bank_list->Pager)) $bank_list->Pager = new PrevNextPager($bank_list->StartRec, $bank_list->DisplayRecs, $bank_list->TotalRecs, $bank_list->AutoHidePager) ?>
<?php if ($bank_list->Pager->RecordCount > 0 && $bank_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bank_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bank_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bank_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bank_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bank_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bank_list->pageUrl() ?>start=<?php echo $bank_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bank_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bank_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bank_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bank_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bank_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bank_list->TotalRecs > 0 && (!$bank_list->AutoHidePageSizeSelector || $bank_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bank">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bank_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bank_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bank_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bank_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bank_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bank->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bank_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($bank_list->TotalRecs == 0 && !$bank->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $bank_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$bank_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bank->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$bank->isExport()) { ?>
<script>
ew.scrollableTable("gmp_bank", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bank_list->terminate();
?>