<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bank_search = new bank_search();

// Run the page
$bank_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bank_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($bank_search->IsModal) { ?>
var fbanksearch = currentAdvancedSearchForm = new ew.Form("fbanksearch", "search");
<?php } else { ?>
var fbanksearch = currentForm = new ew.Form("fbanksearch", "search");
<?php } ?>

// Form_CustomValidate event
fbanksearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbanksearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbanksearch.lists["x_status"] = <?php echo $bank_search->status->Lookup->toClientList() ?>;
fbanksearch.lists["x_status"].options = <?php echo JsonEncode($bank_search->status->options(FALSE, TRUE)) ?>;
fbanksearch.lists["x_operator"] = <?php echo $bank_search->operator->Lookup->toClientList() ?>;
fbanksearch.lists["x_operator"].options = <?php echo JsonEncode($bank_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbanksearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bank->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
		return this.onError(elm, "<?php echo JsEncode($bank->code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bank->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bank_search->showPageHeader(); ?>
<?php
$bank_search->showMessage();
?>
<form name="fbanksearch" id="fbanksearch" class="<?php echo $bank_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bank_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bank_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bank">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$bank_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($bank->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $bank_search->LeftColumnClass ?>"><span id="elh_bank_id"><?php echo $bank->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $bank_search->RightColumnClass ?>"><div<?php echo $bank->id->cellAttributes() ?>>
			<span id="el_bank_id">
<input type="text" data-table="bank" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bank->id->getPlaceHolder()) ?>" value="<?php echo $bank->id->EditValue ?>"<?php echo $bank->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bank->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $bank_search->LeftColumnClass ?>"><span id="elh_bank_name"><?php echo $bank->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $bank_search->RightColumnClass ?>"><div<?php echo $bank->name->cellAttributes() ?>>
			<span id="el_bank_name">
<input type="text" data-table="bank" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($bank->name->getPlaceHolder()) ?>" value="<?php echo $bank->name->EditValue ?>"<?php echo $bank->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bank->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $bank_search->LeftColumnClass ?>"><span id="elh_bank_code"><?php echo $bank->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $bank_search->RightColumnClass ?>"><div<?php echo $bank->code->cellAttributes() ?>>
			<span id="el_bank_code">
<input type="text" data-table="bank" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($bank->code->getPlaceHolder()) ?>" value="<?php echo $bank->code->EditValue ?>"<?php echo $bank->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bank->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $bank_search->LeftColumnClass ?>"><span id="elh_bank_status"><?php echo $bank->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $bank_search->RightColumnClass ?>"><div<?php echo $bank->status->cellAttributes() ?>>
			<span id="el_bank_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bank" data-field="x_status" data-value-separator="<?php echo $bank->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bank->status->editAttributes() ?>>
		<?php echo $bank->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bank->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $bank_search->LeftColumnClass ?>"><span id="elh_bank_operator"><?php echo $bank->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $bank_search->RightColumnClass ?>"><div<?php echo $bank->operator->cellAttributes() ?>>
			<span id="el_bank_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bank" data-field="x_operator" data-value-separator="<?php echo $bank->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $bank->operator->editAttributes() ?>>
		<?php echo $bank->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $bank->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bank->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $bank_search->LeftColumnClass ?>"><span id="elh_bank_datetime"><?php echo $bank->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $bank_search->RightColumnClass ?>"><div<?php echo $bank->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bank->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bank->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bank->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bank->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bank->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bank->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($bank->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bank_datetime">
<input type="text" data-table="bank" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($bank->datetime->getPlaceHolder()) ?>" value="<?php echo $bank->datetime->EditValue ?>"<?php echo $bank->datetime->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bank_datetime" class="btw1_datetime d-none">
<input type="text" data-table="bank" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($bank->datetime->getPlaceHolder()) ?>" value="<?php echo $bank->datetime->EditValue2 ?>"<?php echo $bank->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bank_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bank_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bank_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bank_search->terminate();
?>