<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bank_view = new bank_view();

// Run the page
$bank_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bank_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bank->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbankview = currentForm = new ew.Form("fbankview", "view");

// Form_CustomValidate event
fbankview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbankview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbankview.lists["x_status"] = <?php echo $bank_view->status->Lookup->toClientList() ?>;
fbankview.lists["x_status"].options = <?php echo JsonEncode($bank_view->status->options(FALSE, TRUE)) ?>;
fbankview.lists["x_operator"] = <?php echo $bank_view->operator->Lookup->toClientList() ?>;
fbankview.lists["x_operator"].options = <?php echo JsonEncode($bank_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bank->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $bank_view->ExportOptions->render("body") ?>
<?php $bank_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $bank_view->showPageHeader(); ?>
<?php
$bank_view->showMessage();
?>
<form name="fbankview" id="fbankview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bank_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bank_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bank">
<input type="hidden" name="modal" value="<?php echo (int)$bank_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($bank->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $bank_view->TableLeftColumnClass ?>"><span id="elh_bank_id"><?php echo $bank->id->caption() ?></span></td>
		<td data-name="id"<?php echo $bank->id->cellAttributes() ?>>
<span id="el_bank_id">
<span<?php echo $bank->id->viewAttributes() ?>>
<?php echo $bank->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bank->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $bank_view->TableLeftColumnClass ?>"><span id="elh_bank_name"><?php echo $bank->name->caption() ?></span></td>
		<td data-name="name"<?php echo $bank->name->cellAttributes() ?>>
<span id="el_bank_name">
<span<?php echo $bank->name->viewAttributes() ?>>
<?php echo $bank->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bank->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $bank_view->TableLeftColumnClass ?>"><span id="elh_bank_code"><?php echo $bank->code->caption() ?></span></td>
		<td data-name="code"<?php echo $bank->code->cellAttributes() ?>>
<span id="el_bank_code">
<span<?php echo $bank->code->viewAttributes() ?>>
<?php echo $bank->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bank->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $bank_view->TableLeftColumnClass ?>"><span id="elh_bank_status"><?php echo $bank->status->caption() ?></span></td>
		<td data-name="status"<?php echo $bank->status->cellAttributes() ?>>
<span id="el_bank_status">
<span<?php echo $bank->status->viewAttributes() ?>>
<?php echo $bank->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bank->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $bank_view->TableLeftColumnClass ?>"><span id="elh_bank_operator"><?php echo $bank->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $bank->operator->cellAttributes() ?>>
<span id="el_bank_operator">
<span<?php echo $bank->operator->viewAttributes() ?>>
<?php echo $bank->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bank->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $bank_view->TableLeftColumnClass ?>"><span id="elh_bank_datetime"><?php echo $bank->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $bank->datetime->cellAttributes() ?>>
<span id="el_bank_datetime">
<span<?php echo $bank->datetime->viewAttributes() ?>>
<?php echo $bank->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$bank_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bank->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bank_view->terminate();
?>