<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$banner_edit = new banner_edit();

// Run the page
$banner_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$banner_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbanneredit = currentForm = new ew.Form("fbanneredit", "edit");

// Validate form
fbanneredit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($banner_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->id->caption(), $banner->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->title->Required) { ?>
			elm = this.getElements("x" + infix + "_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->title->caption(), $banner->title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->images->Required) { ?>
			felm = this.getElements("x" + infix + "_images");
			elm = this.getElements("fn_x" + infix + "_images");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $banner->images->caption(), $banner->images->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->url->caption(), $banner->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->show_at->Required) { ?>
			elm = this.getElements("x" + infix + "_show_at");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->show_at->caption(), $banner->show_at->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->text->Required) { ?>
			elm = this.getElements("x" + infix + "_text");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->text->caption(), $banner->text->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->day->Required) { ?>
			elm = this.getElements("x" + infix + "_day");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->day->caption(), $banner->day->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_day");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($banner->day->errorMessage()) ?>");
		<?php if ($banner_edit->start_time->Required) { ?>
			elm = this.getElements("x" + infix + "_start_time");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->start_time->caption(), $banner->start_time->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_start_time");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($banner->start_time->errorMessage()) ?>");
		<?php if ($banner_edit->end_time->Required) { ?>
			elm = this.getElements("x" + infix + "_end_time");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->end_time->caption(), $banner->end_time->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_end_time");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($banner->end_time->errorMessage()) ?>");
		<?php if ($banner_edit->order_by->Required) { ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->order_by->caption(), $banner->order_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->status->caption(), $banner->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->operator->caption(), $banner->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($banner_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $banner->datetime->caption(), $banner->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbanneredit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbanneredit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbanneredit.lists["x_show_at"] = <?php echo $banner_edit->show_at->Lookup->toClientList() ?>;
fbanneredit.lists["x_show_at"].options = <?php echo JsonEncode($banner_edit->show_at->options(FALSE, TRUE)) ?>;
fbanneredit.lists["x_order_by"] = <?php echo $banner_edit->order_by->Lookup->toClientList() ?>;
fbanneredit.lists["x_order_by"].options = <?php echo JsonEncode($banner_edit->order_by->options(FALSE, TRUE)) ?>;
fbanneredit.lists["x_status"] = <?php echo $banner_edit->status->Lookup->toClientList() ?>;
fbanneredit.lists["x_status"].options = <?php echo JsonEncode($banner_edit->status->options(FALSE, TRUE)) ?>;
fbanneredit.lists["x_operator"] = <?php echo $banner_edit->operator->Lookup->toClientList() ?>;
fbanneredit.lists["x_operator"].options = <?php echo JsonEncode($banner_edit->operator->lookupOptions()) ?>;
fbanneredit.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $banner_edit->showPageHeader(); ?>
<?php
$banner_edit->showMessage();
?>
<form name="fbanneredit" id="fbanneredit" class="<?php echo $banner_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($banner_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $banner_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="banner">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$banner_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($banner->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_banner_id" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->id->caption() ?><?php echo ($banner->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->id->cellAttributes() ?>>
<span id="el_banner_id">
<span<?php echo $banner->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($banner->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="banner" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($banner->id->CurrentValue) ?>">
<?php echo $banner->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->title->Visible) { // title ?>
	<div id="r_title" class="form-group row">
		<label id="elh_banner_title" for="x_title" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->title->caption() ?><?php echo ($banner->title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->title->cellAttributes() ?>>
<span id="el_banner_title">
<input type="text" data-table="banner" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($banner->title->getPlaceHolder()) ?>" value="<?php echo $banner->title->EditValue ?>"<?php echo $banner->title->editAttributes() ?>>
</span>
<?php echo $banner->title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->images->Visible) { // images ?>
	<div id="r_images" class="form-group row">
		<label id="elh_banner_images" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->images->caption() ?><?php echo ($banner->images->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->images->cellAttributes() ?>>
<span id="el_banner_images">
<div id="fd_x_images">
<span title="<?php echo $banner->images->title() ? $banner->images->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($banner->images->ReadOnly || $banner->images->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="banner" data-field="x_images" name="x_images" id="x_images"<?php echo $banner->images->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_images" id= "fn_x_images" value="<?php echo $banner->images->Upload->FileName ?>">
<?php if (Post("fa_x_images") == "0") { ?>
<input type="hidden" name="fa_x_images" id= "fa_x_images" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_images" id= "fa_x_images" value="1">
<?php } ?>
<input type="hidden" name="fs_x_images" id= "fs_x_images" value="100">
<input type="hidden" name="fx_x_images" id= "fx_x_images" value="<?php echo $banner->images->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_images" id= "fm_x_images" value="<?php echo $banner->images->UploadMaxFileSize ?>">
</div>
<table id="ft_x_images" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $banner->images->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_banner_url" for="x_url" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->url->caption() ?><?php echo ($banner->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->url->cellAttributes() ?>>
<span id="el_banner_url">
<input type="text" data-table="banner" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($banner->url->getPlaceHolder()) ?>" value="<?php echo $banner->url->EditValue ?>"<?php echo $banner->url->editAttributes() ?>>
</span>
<?php echo $banner->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->show_at->Visible) { // show_at ?>
	<div id="r_show_at" class="form-group row">
		<label id="elh_banner_show_at" for="x_show_at" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->show_at->caption() ?><?php echo ($banner->show_at->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->show_at->cellAttributes() ?>>
<span id="el_banner_show_at">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="banner" data-field="x_show_at" data-value-separator="<?php echo $banner->show_at->displayValueSeparatorAttribute() ?>" id="x_show_at" name="x_show_at"<?php echo $banner->show_at->editAttributes() ?>>
		<?php echo $banner->show_at->selectOptionListHtml("x_show_at") ?>
	</select>
</div>
</span>
<?php echo $banner->show_at->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->text->Visible) { // text ?>
	<div id="r_text" class="form-group row">
		<label id="elh_banner_text" for="x_text" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->text->caption() ?><?php echo ($banner->text->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->text->cellAttributes() ?>>
<span id="el_banner_text">
<input type="text" data-table="banner" data-field="x_text" name="x_text" id="x_text" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($banner->text->getPlaceHolder()) ?>" value="<?php echo $banner->text->EditValue ?>"<?php echo $banner->text->editAttributes() ?>>
</span>
<?php echo $banner->text->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->day->Visible) { // day ?>
	<div id="r_day" class="form-group row">
		<label id="elh_banner_day" for="x_day" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->day->caption() ?><?php echo ($banner->day->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->day->cellAttributes() ?>>
<span id="el_banner_day">
<input type="text" data-table="banner" data-field="x_day" name="x_day" id="x_day" size="30" placeholder="<?php echo HtmlEncode($banner->day->getPlaceHolder()) ?>" value="<?php echo $banner->day->EditValue ?>"<?php echo $banner->day->editAttributes() ?>>
</span>
<?php echo $banner->day->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->start_time->Visible) { // start_time ?>
	<div id="r_start_time" class="form-group row">
		<label id="elh_banner_start_time" for="x_start_time" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->start_time->caption() ?><?php echo ($banner->start_time->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->start_time->cellAttributes() ?>>
<span id="el_banner_start_time">
<input type="text" data-table="banner" data-field="x_start_time" name="x_start_time" id="x_start_time" placeholder="<?php echo HtmlEncode($banner->start_time->getPlaceHolder()) ?>" value="<?php echo $banner->start_time->EditValue ?>"<?php echo $banner->start_time->editAttributes() ?>>
<?php if (!$banner->start_time->ReadOnly && !$banner->start_time->Disabled && !isset($banner->start_time->EditAttrs["readonly"]) && !isset($banner->start_time->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbanneredit", "x_start_time", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $banner->start_time->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->end_time->Visible) { // end_time ?>
	<div id="r_end_time" class="form-group row">
		<label id="elh_banner_end_time" for="x_end_time" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->end_time->caption() ?><?php echo ($banner->end_time->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->end_time->cellAttributes() ?>>
<span id="el_banner_end_time">
<input type="text" data-table="banner" data-field="x_end_time" name="x_end_time" id="x_end_time" placeholder="<?php echo HtmlEncode($banner->end_time->getPlaceHolder()) ?>" value="<?php echo $banner->end_time->EditValue ?>"<?php echo $banner->end_time->editAttributes() ?>>
<?php if (!$banner->end_time->ReadOnly && !$banner->end_time->Disabled && !isset($banner->end_time->EditAttrs["readonly"]) && !isset($banner->end_time->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbanneredit", "x_end_time", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $banner->end_time->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label id="elh_banner_order_by" for="x_order_by" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->order_by->caption() ?><?php echo ($banner->order_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->order_by->cellAttributes() ?>>
<span id="el_banner_order_by">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="banner" data-field="x_order_by" data-value-separator="<?php echo $banner->order_by->displayValueSeparatorAttribute() ?>" id="x_order_by" name="x_order_by"<?php echo $banner->order_by->editAttributes() ?>>
		<?php echo $banner->order_by->selectOptionListHtml("x_order_by") ?>
	</select>
</div>
</span>
<?php echo $banner->order_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($banner->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_banner_status" for="x_status" class="<?php echo $banner_edit->LeftColumnClass ?>"><?php echo $banner->status->caption() ?><?php echo ($banner->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $banner_edit->RightColumnClass ?>"><div<?php echo $banner->status->cellAttributes() ?>>
<span id="el_banner_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="banner" data-field="x_status" data-value-separator="<?php echo $banner->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $banner->status->editAttributes() ?>>
		<?php echo $banner->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $banner->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$banner_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $banner_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $banner_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$banner_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$banner_edit->terminate();
?>