<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$banner_list = new banner_list();

// Run the page
$banner_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$banner_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$banner->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbannerlist = currentForm = new ew.Form("fbannerlist", "list");
fbannerlist.formKeyCountName = '<?php echo $banner_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbannerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbannerlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbannerlist.lists["x_show_at"] = <?php echo $banner_list->show_at->Lookup->toClientList() ?>;
fbannerlist.lists["x_show_at"].options = <?php echo JsonEncode($banner_list->show_at->options(FALSE, TRUE)) ?>;
fbannerlist.lists["x_order_by"] = <?php echo $banner_list->order_by->Lookup->toClientList() ?>;
fbannerlist.lists["x_order_by"].options = <?php echo JsonEncode($banner_list->order_by->options(FALSE, TRUE)) ?>;
fbannerlist.lists["x_status"] = <?php echo $banner_list->status->Lookup->toClientList() ?>;
fbannerlist.lists["x_status"].options = <?php echo JsonEncode($banner_list->status->options(FALSE, TRUE)) ?>;
fbannerlist.lists["x_operator"] = <?php echo $banner_list->operator->Lookup->toClientList() ?>;
fbannerlist.lists["x_operator"].options = <?php echo JsonEncode($banner_list->operator->lookupOptions()) ?>;
fbannerlist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fbannerlistsrch = currentSearchForm = new ew.Form("fbannerlistsrch");

// Filters
fbannerlistsrch.filterList = <?php echo $banner_list->getFilterList() ?>;

// Init search panel as collapsed
fbannerlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$banner->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($banner_list->TotalRecs > 0 && $banner_list->ExportOptions->visible()) { ?>
<?php $banner_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($banner_list->ImportOptions->visible()) { ?>
<?php $banner_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($banner_list->SearchOptions->visible()) { ?>
<?php $banner_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($banner_list->FilterOptions->visible()) { ?>
<?php $banner_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$banner_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$banner->isExport() && !$banner->CurrentAction) { ?>
<form name="fbannerlistsrch" id="fbannerlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($banner_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbannerlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="banner">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($banner_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($banner_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $banner_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($banner_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($banner_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($banner_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($banner_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $banner_list->showPageHeader(); ?>
<?php
$banner_list->showMessage();
?>
<?php if ($banner_list->TotalRecs > 0 || $banner->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($banner_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> banner">
<?php if (!$banner->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$banner->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($banner_list->Pager)) $banner_list->Pager = new PrevNextPager($banner_list->StartRec, $banner_list->DisplayRecs, $banner_list->TotalRecs, $banner_list->AutoHidePager) ?>
<?php if ($banner_list->Pager->RecordCount > 0 && $banner_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($banner_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($banner_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $banner_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($banner_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($banner_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $banner_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($banner_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $banner_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $banner_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $banner_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($banner_list->TotalRecs > 0 && (!$banner_list->AutoHidePageSizeSelector || $banner_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="banner">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($banner_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($banner_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($banner_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($banner_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($banner_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($banner->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $banner_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbannerlist" id="fbannerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($banner_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $banner_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="banner">
<div id="gmp_banner" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($banner_list->TotalRecs > 0 || $banner->isGridEdit()) { ?>
<table id="tbl_bannerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$banner_list->RowType = ROWTYPE_HEADER;

// Render list options
$banner_list->renderListOptions();

// Render list options (header, left)
$banner_list->ListOptions->render("header", "left");
?>
<?php if ($banner->id->Visible) { // id ?>
	<?php if ($banner->sortUrl($banner->id) == "") { ?>
		<th data-name="id" class="<?php echo $banner->id->headerCellClass() ?>"><div id="elh_banner_id" class="banner_id"><div class="ew-table-header-caption"><?php echo $banner->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $banner->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->id) ?>',2);"><div id="elh_banner_id" class="banner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->title->Visible) { // title ?>
	<?php if ($banner->sortUrl($banner->title) == "") { ?>
		<th data-name="title" class="<?php echo $banner->title->headerCellClass() ?>"><div id="elh_banner_title" class="banner_title"><div class="ew-table-header-caption"><?php echo $banner->title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="title" class="<?php echo $banner->title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->title) ?>',2);"><div id="elh_banner_title" class="banner_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($banner->title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->images->Visible) { // images ?>
	<?php if ($banner->sortUrl($banner->images) == "") { ?>
		<th data-name="images" class="<?php echo $banner->images->headerCellClass() ?>"><div id="elh_banner_images" class="banner_images"><div class="ew-table-header-caption"><?php echo $banner->images->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="images" class="<?php echo $banner->images->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->images) ?>',2);"><div id="elh_banner_images" class="banner_images">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->images->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($banner->images->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->images->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->url->Visible) { // url ?>
	<?php if ($banner->sortUrl($banner->url) == "") { ?>
		<th data-name="url" class="<?php echo $banner->url->headerCellClass() ?>"><div id="elh_banner_url" class="banner_url"><div class="ew-table-header-caption"><?php echo $banner->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $banner->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->url) ?>',2);"><div id="elh_banner_url" class="banner_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($banner->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->show_at->Visible) { // show_at ?>
	<?php if ($banner->sortUrl($banner->show_at) == "") { ?>
		<th data-name="show_at" class="<?php echo $banner->show_at->headerCellClass() ?>"><div id="elh_banner_show_at" class="banner_show_at"><div class="ew-table-header-caption"><?php echo $banner->show_at->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="show_at" class="<?php echo $banner->show_at->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->show_at) ?>',2);"><div id="elh_banner_show_at" class="banner_show_at">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->show_at->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->show_at->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->show_at->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->text->Visible) { // text ?>
	<?php if ($banner->sortUrl($banner->text) == "") { ?>
		<th data-name="text" class="<?php echo $banner->text->headerCellClass() ?>"><div id="elh_banner_text" class="banner_text"><div class="ew-table-header-caption"><?php echo $banner->text->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="text" class="<?php echo $banner->text->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->text) ?>',2);"><div id="elh_banner_text" class="banner_text">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->text->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($banner->text->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->text->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->day->Visible) { // day ?>
	<?php if ($banner->sortUrl($banner->day) == "") { ?>
		<th data-name="day" class="<?php echo $banner->day->headerCellClass() ?>"><div id="elh_banner_day" class="banner_day"><div class="ew-table-header-caption"><?php echo $banner->day->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="day" class="<?php echo $banner->day->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->day) ?>',2);"><div id="elh_banner_day" class="banner_day">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->day->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->day->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->day->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->start_time->Visible) { // start_time ?>
	<?php if ($banner->sortUrl($banner->start_time) == "") { ?>
		<th data-name="start_time" class="<?php echo $banner->start_time->headerCellClass() ?>"><div id="elh_banner_start_time" class="banner_start_time"><div class="ew-table-header-caption"><?php echo $banner->start_time->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="start_time" class="<?php echo $banner->start_time->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->start_time) ?>',2);"><div id="elh_banner_start_time" class="banner_start_time">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->start_time->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->start_time->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->start_time->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->end_time->Visible) { // end_time ?>
	<?php if ($banner->sortUrl($banner->end_time) == "") { ?>
		<th data-name="end_time" class="<?php echo $banner->end_time->headerCellClass() ?>"><div id="elh_banner_end_time" class="banner_end_time"><div class="ew-table-header-caption"><?php echo $banner->end_time->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="end_time" class="<?php echo $banner->end_time->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->end_time) ?>',2);"><div id="elh_banner_end_time" class="banner_end_time">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->end_time->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->end_time->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->end_time->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->order_by->Visible) { // order_by ?>
	<?php if ($banner->sortUrl($banner->order_by) == "") { ?>
		<th data-name="order_by" class="<?php echo $banner->order_by->headerCellClass() ?>"><div id="elh_banner_order_by" class="banner_order_by"><div class="ew-table-header-caption"><?php echo $banner->order_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_by" class="<?php echo $banner->order_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->order_by) ?>',2);"><div id="elh_banner_order_by" class="banner_order_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->order_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->order_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->order_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->status->Visible) { // status ?>
	<?php if ($banner->sortUrl($banner->status) == "") { ?>
		<th data-name="status" class="<?php echo $banner->status->headerCellClass() ?>"><div id="elh_banner_status" class="banner_status"><div class="ew-table-header-caption"><?php echo $banner->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $banner->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->status) ?>',2);"><div id="elh_banner_status" class="banner_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->operator->Visible) { // operator ?>
	<?php if ($banner->sortUrl($banner->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $banner->operator->headerCellClass() ?>"><div id="elh_banner_operator" class="banner_operator"><div class="ew-table-header-caption"><?php echo $banner->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $banner->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->operator) ?>',2);"><div id="elh_banner_operator" class="banner_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($banner->datetime->Visible) { // datetime ?>
	<?php if ($banner->sortUrl($banner->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $banner->datetime->headerCellClass() ?>"><div id="elh_banner_datetime" class="banner_datetime"><div class="ew-table-header-caption"><?php echo $banner->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $banner->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $banner->SortUrl($banner->datetime) ?>',2);"><div id="elh_banner_datetime" class="banner_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $banner->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($banner->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($banner->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$banner_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($banner->ExportAll && $banner->isExport()) {
	$banner_list->StopRec = $banner_list->TotalRecs;
} else {

	// Set the last record to display
	if ($banner_list->TotalRecs > $banner_list->StartRec + $banner_list->DisplayRecs - 1)
		$banner_list->StopRec = $banner_list->StartRec + $banner_list->DisplayRecs - 1;
	else
		$banner_list->StopRec = $banner_list->TotalRecs;
}
$banner_list->RecCnt = $banner_list->StartRec - 1;
if ($banner_list->Recordset && !$banner_list->Recordset->EOF) {
	$banner_list->Recordset->moveFirst();
	$selectLimit = $banner_list->UseSelectLimit;
	if (!$selectLimit && $banner_list->StartRec > 1)
		$banner_list->Recordset->move($banner_list->StartRec - 1);
} elseif (!$banner->AllowAddDeleteRow && $banner_list->StopRec == 0) {
	$banner_list->StopRec = $banner->GridAddRowCount;
}

// Initialize aggregate
$banner->RowType = ROWTYPE_AGGREGATEINIT;
$banner->resetAttributes();
$banner_list->renderRow();
while ($banner_list->RecCnt < $banner_list->StopRec) {
	$banner_list->RecCnt++;
	if ($banner_list->RecCnt >= $banner_list->StartRec) {
		$banner_list->RowCnt++;

		// Set up key count
		$banner_list->KeyCount = $banner_list->RowIndex;

		// Init row class and style
		$banner->resetAttributes();
		$banner->CssClass = "";
		if ($banner->isGridAdd()) {
		} else {
			$banner_list->loadRowValues($banner_list->Recordset); // Load row values
		}
		$banner->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$banner->RowAttrs = array_merge($banner->RowAttrs, array('data-rowindex'=>$banner_list->RowCnt, 'id'=>'r' . $banner_list->RowCnt . '_banner', 'data-rowtype'=>$banner->RowType));

		// Render row
		$banner_list->renderRow();

		// Render list options
		$banner_list->renderListOptions();
?>
	<tr<?php echo $banner->rowAttributes() ?>>
<?php

// Render list options (body, left)
$banner_list->ListOptions->render("body", "left", $banner_list->RowCnt);
?>
	<?php if ($banner->id->Visible) { // id ?>
		<td data-name="id"<?php echo $banner->id->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_id" class="banner_id">
<span<?php echo $banner->id->viewAttributes() ?>>
<?php echo $banner->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->title->Visible) { // title ?>
		<td data-name="title"<?php echo $banner->title->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_title" class="banner_title">
<span<?php echo $banner->title->viewAttributes() ?>>
<?php echo $banner->title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->images->Visible) { // images ?>
		<td data-name="images"<?php echo $banner->images->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_images" class="banner_images">
<span>
<?php echo GetFileViewTag($banner->images, $banner->images->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->url->Visible) { // url ?>
		<td data-name="url"<?php echo $banner->url->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_url" class="banner_url">
<span<?php echo $banner->url->viewAttributes() ?>>
<?php echo $banner->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->show_at->Visible) { // show_at ?>
		<td data-name="show_at"<?php echo $banner->show_at->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_show_at" class="banner_show_at">
<span<?php echo $banner->show_at->viewAttributes() ?>>
<?php echo $banner->show_at->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->text->Visible) { // text ?>
		<td data-name="text"<?php echo $banner->text->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_text" class="banner_text">
<span<?php echo $banner->text->viewAttributes() ?>>
<?php echo $banner->text->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->day->Visible) { // day ?>
		<td data-name="day"<?php echo $banner->day->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_day" class="banner_day">
<span<?php echo $banner->day->viewAttributes() ?>>
<?php echo $banner->day->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->start_time->Visible) { // start_time ?>
		<td data-name="start_time"<?php echo $banner->start_time->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_start_time" class="banner_start_time">
<span<?php echo $banner->start_time->viewAttributes() ?>>
<?php echo $banner->start_time->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->end_time->Visible) { // end_time ?>
		<td data-name="end_time"<?php echo $banner->end_time->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_end_time" class="banner_end_time">
<span<?php echo $banner->end_time->viewAttributes() ?>>
<?php echo $banner->end_time->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->order_by->Visible) { // order_by ?>
		<td data-name="order_by"<?php echo $banner->order_by->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_order_by" class="banner_order_by">
<span<?php echo $banner->order_by->viewAttributes() ?>>
<?php echo $banner->order_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->status->Visible) { // status ?>
		<td data-name="status"<?php echo $banner->status->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_status" class="banner_status">
<span<?php echo $banner->status->viewAttributes() ?>>
<?php echo $banner->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $banner->operator->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_operator" class="banner_operator">
<span<?php echo $banner->operator->viewAttributes() ?>>
<?php echo $banner->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($banner->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $banner->datetime->cellAttributes() ?>>
<span id="el<?php echo $banner_list->RowCnt ?>_banner_datetime" class="banner_datetime">
<span<?php echo $banner->datetime->viewAttributes() ?>>
<?php echo $banner->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$banner_list->ListOptions->render("body", "right", $banner_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$banner->isGridAdd())
		$banner_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$banner->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($banner_list->Recordset)
	$banner_list->Recordset->Close();
?>
<?php if (!$banner->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$banner->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($banner_list->Pager)) $banner_list->Pager = new PrevNextPager($banner_list->StartRec, $banner_list->DisplayRecs, $banner_list->TotalRecs, $banner_list->AutoHidePager) ?>
<?php if ($banner_list->Pager->RecordCount > 0 && $banner_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($banner_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($banner_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $banner_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($banner_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($banner_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $banner_list->pageUrl() ?>start=<?php echo $banner_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $banner_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($banner_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $banner_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $banner_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $banner_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($banner_list->TotalRecs > 0 && (!$banner_list->AutoHidePageSizeSelector || $banner_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="banner">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($banner_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($banner_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($banner_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($banner_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($banner_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($banner->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $banner_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($banner_list->TotalRecs == 0 && !$banner->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $banner_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$banner_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$banner->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$banner->isExport()) { ?>
<script>
ew.scrollableTable("gmp_banner", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$banner_list->terminate();
?>