<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$banner_view = new banner_view();

// Run the page
$banner_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$banner_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$banner->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbannerview = currentForm = new ew.Form("fbannerview", "view");

// Form_CustomValidate event
fbannerview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbannerview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbannerview.lists["x_show_at"] = <?php echo $banner_view->show_at->Lookup->toClientList() ?>;
fbannerview.lists["x_show_at"].options = <?php echo JsonEncode($banner_view->show_at->options(FALSE, TRUE)) ?>;
fbannerview.lists["x_order_by"] = <?php echo $banner_view->order_by->Lookup->toClientList() ?>;
fbannerview.lists["x_order_by"].options = <?php echo JsonEncode($banner_view->order_by->options(FALSE, TRUE)) ?>;
fbannerview.lists["x_status"] = <?php echo $banner_view->status->Lookup->toClientList() ?>;
fbannerview.lists["x_status"].options = <?php echo JsonEncode($banner_view->status->options(FALSE, TRUE)) ?>;
fbannerview.lists["x_operator"] = <?php echo $banner_view->operator->Lookup->toClientList() ?>;
fbannerview.lists["x_operator"].options = <?php echo JsonEncode($banner_view->operator->lookupOptions()) ?>;
fbannerview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$banner->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $banner_view->ExportOptions->render("body") ?>
<?php $banner_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $banner_view->showPageHeader(); ?>
<?php
$banner_view->showMessage();
?>
<form name="fbannerview" id="fbannerview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($banner_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $banner_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="banner">
<input type="hidden" name="modal" value="<?php echo (int)$banner_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($banner->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_id"><?php echo $banner->id->caption() ?></span></td>
		<td data-name="id"<?php echo $banner->id->cellAttributes() ?>>
<span id="el_banner_id">
<span<?php echo $banner->id->viewAttributes() ?>>
<?php echo $banner->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->title->Visible) { // title ?>
	<tr id="r_title">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_title"><?php echo $banner->title->caption() ?></span></td>
		<td data-name="title"<?php echo $banner->title->cellAttributes() ?>>
<span id="el_banner_title">
<span<?php echo $banner->title->viewAttributes() ?>>
<?php echo $banner->title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->images->Visible) { // images ?>
	<tr id="r_images">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_images"><?php echo $banner->images->caption() ?></span></td>
		<td data-name="images"<?php echo $banner->images->cellAttributes() ?>>
<span id="el_banner_images">
<span>
<?php echo GetFileViewTag($banner->images, $banner->images->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_url"><?php echo $banner->url->caption() ?></span></td>
		<td data-name="url"<?php echo $banner->url->cellAttributes() ?>>
<span id="el_banner_url">
<span<?php echo $banner->url->viewAttributes() ?>>
<?php echo $banner->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->show_at->Visible) { // show_at ?>
	<tr id="r_show_at">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_show_at"><?php echo $banner->show_at->caption() ?></span></td>
		<td data-name="show_at"<?php echo $banner->show_at->cellAttributes() ?>>
<span id="el_banner_show_at">
<span<?php echo $banner->show_at->viewAttributes() ?>>
<?php echo $banner->show_at->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->text->Visible) { // text ?>
	<tr id="r_text">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_text"><?php echo $banner->text->caption() ?></span></td>
		<td data-name="text"<?php echo $banner->text->cellAttributes() ?>>
<span id="el_banner_text">
<span<?php echo $banner->text->viewAttributes() ?>>
<?php echo $banner->text->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->day->Visible) { // day ?>
	<tr id="r_day">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_day"><?php echo $banner->day->caption() ?></span></td>
		<td data-name="day"<?php echo $banner->day->cellAttributes() ?>>
<span id="el_banner_day">
<span<?php echo $banner->day->viewAttributes() ?>>
<?php echo $banner->day->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->start_time->Visible) { // start_time ?>
	<tr id="r_start_time">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_start_time"><?php echo $banner->start_time->caption() ?></span></td>
		<td data-name="start_time"<?php echo $banner->start_time->cellAttributes() ?>>
<span id="el_banner_start_time">
<span<?php echo $banner->start_time->viewAttributes() ?>>
<?php echo $banner->start_time->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->end_time->Visible) { // end_time ?>
	<tr id="r_end_time">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_end_time"><?php echo $banner->end_time->caption() ?></span></td>
		<td data-name="end_time"<?php echo $banner->end_time->cellAttributes() ?>>
<span id="el_banner_end_time">
<span<?php echo $banner->end_time->viewAttributes() ?>>
<?php echo $banner->end_time->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->order_by->Visible) { // order_by ?>
	<tr id="r_order_by">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_order_by"><?php echo $banner->order_by->caption() ?></span></td>
		<td data-name="order_by"<?php echo $banner->order_by->cellAttributes() ?>>
<span id="el_banner_order_by">
<span<?php echo $banner->order_by->viewAttributes() ?>>
<?php echo $banner->order_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_status"><?php echo $banner->status->caption() ?></span></td>
		<td data-name="status"<?php echo $banner->status->cellAttributes() ?>>
<span id="el_banner_status">
<span<?php echo $banner->status->viewAttributes() ?>>
<?php echo $banner->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_operator"><?php echo $banner->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $banner->operator->cellAttributes() ?>>
<span id="el_banner_operator">
<span<?php echo $banner->operator->viewAttributes() ?>>
<?php echo $banner->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($banner->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $banner_view->TableLeftColumnClass ?>"><span id="elh_banner_datetime"><?php echo $banner->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $banner->datetime->cellAttributes() ?>>
<span id="el_banner_datetime">
<span<?php echo $banner->datetime->viewAttributes() ?>>
<?php echo $banner->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$banner_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$banner->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$banner_view->terminate();
?>