<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$barcode_print_list = new barcode_print_list();

// Run the page
$barcode_print_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barcode_print_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$barcode_print->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbarcode_printlist = currentForm = new ew.Form("fbarcode_printlist", "list");
fbarcode_printlist.formKeyCountName = '<?php echo $barcode_print_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbarcode_printlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_printlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_printlist.lists["x_category"] = <?php echo $barcode_print_list->category->Lookup->toClientList() ?>;
fbarcode_printlist.lists["x_category"].options = <?php echo JsonEncode($barcode_print_list->category->lookupOptions()) ?>;
fbarcode_printlist.lists["x_weaving_works"] = <?php echo $barcode_print_list->weaving_works->Lookup->toClientList() ?>;
fbarcode_printlist.lists["x_weaving_works"].options = <?php echo JsonEncode($barcode_print_list->weaving_works->lookupOptions()) ?>;
fbarcode_printlist.lists["x_buyer_ref"] = <?php echo $barcode_print_list->buyer_ref->Lookup->toClientList() ?>;
fbarcode_printlist.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_print_list->buyer_ref->lookupOptions()) ?>;
fbarcode_printlist.lists["x_buyers_id"] = <?php echo $barcode_print_list->buyers_id->Lookup->toClientList() ?>;
fbarcode_printlist.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_print_list->buyers_id->lookupOptions()) ?>;

// Form object for search
var fbarcode_printlistsrch = currentSearchForm = new ew.Form("fbarcode_printlistsrch");

// Validate function for search
fbarcode_printlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_print->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_print->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_design_size");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_print->design_size->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbarcode_printlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_printlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fbarcode_printlistsrch.filterList = <?php echo $barcode_print_list->getFilterList() ?>;

// Init search panel as collapsed
fbarcode_printlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$barcode_print->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($barcode_print_list->TotalRecs > 0 && $barcode_print_list->ExportOptions->visible()) { ?>
<?php $barcode_print_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($barcode_print_list->ImportOptions->visible()) { ?>
<?php $barcode_print_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($barcode_print_list->SearchOptions->visible()) { ?>
<?php $barcode_print_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($barcode_print_list->FilterOptions->visible()) { ?>
<?php $barcode_print_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$barcode_print_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$barcode_print->isExport() && !$barcode_print->CurrentAction) { ?>
<form name="fbarcode_printlistsrch" id="fbarcode_printlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($barcode_print_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbarcode_printlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="barcode_print">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$barcode_print_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$barcode_print->RowType = ROWTYPE_SEARCH;

// Render row
$barcode_print->resetAttributes();
$barcode_print_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($barcode_print->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $barcode_print->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="barcode_print" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($barcode_print->po->getPlaceHolder()) ?>" value="<?php echo $barcode_print->po->EditValue ?>"<?php echo $barcode_print->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="barcode_print" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($barcode_print->po->getPlaceHolder()) ?>" value="<?php echo $barcode_print->po->EditValue2 ?>"<?php echo $barcode_print->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($barcode_print->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $barcode_print->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="barcode_print" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_print->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_print->_barcode->EditValue ?>"<?php echo $barcode_print->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="barcode_print" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_print->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_print->_barcode->EditValue2 ?>"<?php echo $barcode_print->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($barcode_print->design_size->Visible) { // design_size ?>
	<div id="xsc_design_size" class="ew-cell form-group">
		<label for="x_design_size" class="ew-search-caption ew-label"><?php echo $barcode_print->design_size->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_size" id="z_design_size" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="barcode_print" data-field="x_design_size" name="x_design_size" id="x_design_size" size="30" placeholder="<?php echo HtmlEncode($barcode_print->design_size->getPlaceHolder()) ?>" value="<?php echo $barcode_print->design_size->EditValue ?>"<?php echo $barcode_print->design_size->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($barcode_print_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($barcode_print_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $barcode_print_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($barcode_print_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($barcode_print_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($barcode_print_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($barcode_print_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $barcode_print_list->showPageHeader(); ?>
<?php
$barcode_print_list->showMessage();
?>
<?php if ($barcode_print_list->TotalRecs > 0 || $barcode_print->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($barcode_print_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> barcode_print">
<?php if (!$barcode_print->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$barcode_print->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($barcode_print_list->Pager)) $barcode_print_list->Pager = new PrevNextPager($barcode_print_list->StartRec, $barcode_print_list->DisplayRecs, $barcode_print_list->TotalRecs, $barcode_print_list->AutoHidePager) ?>
<?php if ($barcode_print_list->Pager->RecordCount > 0 && $barcode_print_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($barcode_print_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($barcode_print_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $barcode_print_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($barcode_print_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($barcode_print_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $barcode_print_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($barcode_print_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $barcode_print_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $barcode_print_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $barcode_print_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($barcode_print_list->TotalRecs > 0 && (!$barcode_print_list->AutoHidePageSizeSelector || $barcode_print_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="barcode_print">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($barcode_print_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($barcode_print_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($barcode_print_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($barcode_print_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($barcode_print_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($barcode_print->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $barcode_print_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbarcode_printlist" id="fbarcode_printlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($barcode_print_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $barcode_print_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="barcode_print">
<div id="gmp_barcode_print" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($barcode_print_list->TotalRecs > 0 || $barcode_print->isGridEdit()) { ?>
<table id="tbl_barcode_printlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$barcode_print_list->RowType = ROWTYPE_HEADER;

// Render list options
$barcode_print_list->renderListOptions();

// Render list options (header, left)
$barcode_print_list->ListOptions->render("header", "left");
?>
<?php if ($barcode_print->po->Visible) { // po ?>
	<?php if ($barcode_print->sortUrl($barcode_print->po) == "") { ?>
		<th data-name="po" class="<?php echo $barcode_print->po->headerCellClass() ?>"><div id="elh_barcode_print_po" class="barcode_print_po"><div class="ew-table-header-caption"><?php echo $barcode_print->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $barcode_print->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->po) ?>',2);"><div id="elh_barcode_print_po" class="barcode_print_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->_barcode->Visible) { // barcode ?>
	<?php if ($barcode_print->sortUrl($barcode_print->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $barcode_print->_barcode->headerCellClass() ?>"><div id="elh_barcode_print__barcode" class="barcode_print__barcode"><div class="ew-table-header-caption"><?php echo $barcode_print->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $barcode_print->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->_barcode) ?>',2);"><div id="elh_barcode_print__barcode" class="barcode_print__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->design_size->Visible) { // design_size ?>
	<?php if ($barcode_print->sortUrl($barcode_print->design_size) == "") { ?>
		<th data-name="design_size" class="<?php echo $barcode_print->design_size->headerCellClass() ?>"><div id="elh_barcode_print_design_size" class="barcode_print_design_size"><div class="ew-table-header-caption"><?php echo $barcode_print->design_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_size" class="<?php echo $barcode_print->design_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->design_size) ?>',2);"><div id="elh_barcode_print_design_size" class="barcode_print_design_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->design_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->design_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->design_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->quantity->Visible) { // quantity ?>
	<?php if ($barcode_print->sortUrl($barcode_print->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $barcode_print->quantity->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode_print_quantity" class="barcode_print_quantity"><div class="ew-table-header-caption"><?php echo $barcode_print->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $barcode_print->quantity->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->quantity) ?>',2);"><div id="elh_barcode_print_quantity" class="barcode_print_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->category->Visible) { // category ?>
	<?php if ($barcode_print->sortUrl($barcode_print->category) == "") { ?>
		<th data-name="category" class="<?php echo $barcode_print->category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode_print_category" class="barcode_print_category"><div class="ew-table-header-caption"><?php echo $barcode_print->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $barcode_print->category->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->category) ?>',2);"><div id="elh_barcode_print_category" class="barcode_print_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->weaving_works->Visible) { // weaving_works ?>
	<?php if ($barcode_print->sortUrl($barcode_print->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $barcode_print->weaving_works->headerCellClass() ?>"><div id="elh_barcode_print_weaving_works" class="barcode_print_weaving_works"><div class="ew-table-header-caption"><?php echo $barcode_print->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $barcode_print->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->weaving_works) ?>',2);"><div id="elh_barcode_print_weaving_works" class="barcode_print_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($barcode_print->sortUrl($barcode_print->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $barcode_print->buyer_ref->headerCellClass() ?>"><div id="elh_barcode_print_buyer_ref" class="barcode_print_buyer_ref"><div class="ew-table-header-caption"><?php echo $barcode_print->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $barcode_print->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->buyer_ref) ?>',2);"><div id="elh_barcode_print_buyer_ref" class="barcode_print_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->buyer_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->design->Visible) { // design ?>
	<?php if ($barcode_print->sortUrl($barcode_print->design) == "") { ?>
		<th data-name="design" class="<?php echo $barcode_print->design->headerCellClass() ?>"><div id="elh_barcode_print_design" class="barcode_print_design"><div class="ew-table-header-caption"><?php echo $barcode_print->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $barcode_print->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->design) ?>',2);"><div id="elh_barcode_print_design" class="barcode_print_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->size_cm->Visible) { // size_cm ?>
	<?php if ($barcode_print->sortUrl($barcode_print->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $barcode_print->size_cm->headerCellClass() ?>"><div id="elh_barcode_print_size_cm" class="barcode_print_size_cm"><div class="ew-table-header-caption"><?php echo $barcode_print->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $barcode_print->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->size_cm) ?>',2);"><div id="elh_barcode_print_size_cm" class="barcode_print_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_print->buyers_id->Visible) { // buyers_id ?>
	<?php if ($barcode_print->sortUrl($barcode_print->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $barcode_print->buyers_id->headerCellClass() ?>"><div id="elh_barcode_print_buyers_id" class="barcode_print_buyers_id"><div class="ew-table-header-caption"><?php echo $barcode_print->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $barcode_print->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_print->SortUrl($barcode_print->buyers_id) ?>',2);"><div id="elh_barcode_print_buyers_id" class="barcode_print_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_print->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_print->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_print->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$barcode_print_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($barcode_print->ExportAll && $barcode_print->isExport()) {
	$barcode_print_list->StopRec = $barcode_print_list->TotalRecs;
} else {

	// Set the last record to display
	if ($barcode_print_list->TotalRecs > $barcode_print_list->StartRec + $barcode_print_list->DisplayRecs - 1)
		$barcode_print_list->StopRec = $barcode_print_list->StartRec + $barcode_print_list->DisplayRecs - 1;
	else
		$barcode_print_list->StopRec = $barcode_print_list->TotalRecs;
}
$barcode_print_list->RecCnt = $barcode_print_list->StartRec - 1;
if ($barcode_print_list->Recordset && !$barcode_print_list->Recordset->EOF) {
	$barcode_print_list->Recordset->moveFirst();
	$selectLimit = $barcode_print_list->UseSelectLimit;
	if (!$selectLimit && $barcode_print_list->StartRec > 1)
		$barcode_print_list->Recordset->move($barcode_print_list->StartRec - 1);
} elseif (!$barcode_print->AllowAddDeleteRow && $barcode_print_list->StopRec == 0) {
	$barcode_print_list->StopRec = $barcode_print->GridAddRowCount;
}

// Initialize aggregate
$barcode_print->RowType = ROWTYPE_AGGREGATEINIT;
$barcode_print->resetAttributes();
$barcode_print_list->renderRow();
while ($barcode_print_list->RecCnt < $barcode_print_list->StopRec) {
	$barcode_print_list->RecCnt++;
	if ($barcode_print_list->RecCnt >= $barcode_print_list->StartRec) {
		$barcode_print_list->RowCnt++;

		// Set up key count
		$barcode_print_list->KeyCount = $barcode_print_list->RowIndex;

		// Init row class and style
		$barcode_print->resetAttributes();
		$barcode_print->CssClass = "";
		if ($barcode_print->isGridAdd()) {
		} else {
			$barcode_print_list->loadRowValues($barcode_print_list->Recordset); // Load row values
		}
		$barcode_print->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$barcode_print->RowAttrs = array_merge($barcode_print->RowAttrs, array('data-rowindex'=>$barcode_print_list->RowCnt, 'id'=>'r' . $barcode_print_list->RowCnt . '_barcode_print', 'data-rowtype'=>$barcode_print->RowType));

		// Render row
		$barcode_print_list->renderRow();

		// Render list options
		$barcode_print_list->renderListOptions();
?>
	<tr<?php echo $barcode_print->rowAttributes() ?>>
<?php

// Render list options (body, left)
$barcode_print_list->ListOptions->render("body", "left", $barcode_print_list->RowCnt);
?>
	<?php if ($barcode_print->po->Visible) { // po ?>
		<td data-name="po"<?php echo $barcode_print->po->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_po" class="barcode_print_po">
<span<?php echo $barcode_print->po->viewAttributes() ?>>
<?php echo $barcode_print->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $barcode_print->_barcode->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print__barcode" class="barcode_print__barcode">
<span<?php echo $barcode_print->_barcode->viewAttributes() ?>>
<?php echo $barcode_print->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->design_size->Visible) { // design_size ?>
		<td data-name="design_size"<?php echo $barcode_print->design_size->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_design_size" class="barcode_print_design_size">
<span<?php echo $barcode_print->design_size->viewAttributes() ?>>
<?php echo $barcode_print->design_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $barcode_print->quantity->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_quantity" class="barcode_print_quantity">
<span<?php echo $barcode_print->quantity->viewAttributes() ?>>
<?php echo $barcode_print->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->category->Visible) { // category ?>
		<td data-name="category"<?php echo $barcode_print->category->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_category" class="barcode_print_category">
<span<?php echo $barcode_print->category->viewAttributes() ?>>
<?php echo $barcode_print->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $barcode_print->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_weaving_works" class="barcode_print_weaving_works">
<span<?php echo $barcode_print->weaving_works->viewAttributes() ?>>
<?php echo $barcode_print->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $barcode_print->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_buyer_ref" class="barcode_print_buyer_ref">
<span<?php echo $barcode_print->buyer_ref->viewAttributes() ?>>
<?php echo $barcode_print->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->design->Visible) { // design ?>
		<td data-name="design"<?php echo $barcode_print->design->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_design" class="barcode_print_design">
<span<?php echo $barcode_print->design->viewAttributes() ?>>
<?php echo $barcode_print->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $barcode_print->size_cm->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_size_cm" class="barcode_print_size_cm">
<span<?php echo $barcode_print->size_cm->viewAttributes() ?>>
<?php echo $barcode_print->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_print->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $barcode_print->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $barcode_print_list->RowCnt ?>_barcode_print_buyers_id" class="barcode_print_buyers_id">
<span<?php echo $barcode_print->buyers_id->viewAttributes() ?>>
<?php echo $barcode_print->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$barcode_print_list->ListOptions->render("body", "right", $barcode_print_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$barcode_print->isGridAdd())
		$barcode_print_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$barcode_print->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($barcode_print_list->Recordset)
	$barcode_print_list->Recordset->Close();
?>
<?php if (!$barcode_print->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$barcode_print->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($barcode_print_list->Pager)) $barcode_print_list->Pager = new PrevNextPager($barcode_print_list->StartRec, $barcode_print_list->DisplayRecs, $barcode_print_list->TotalRecs, $barcode_print_list->AutoHidePager) ?>
<?php if ($barcode_print_list->Pager->RecordCount > 0 && $barcode_print_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($barcode_print_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($barcode_print_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $barcode_print_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($barcode_print_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($barcode_print_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $barcode_print_list->pageUrl() ?>start=<?php echo $barcode_print_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $barcode_print_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($barcode_print_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $barcode_print_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $barcode_print_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $barcode_print_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($barcode_print_list->TotalRecs > 0 && (!$barcode_print_list->AutoHidePageSizeSelector || $barcode_print_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="barcode_print">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($barcode_print_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($barcode_print_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($barcode_print_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($barcode_print_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($barcode_print_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($barcode_print->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $barcode_print_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($barcode_print_list->TotalRecs == 0 && !$barcode_print->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $barcode_print_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$barcode_print_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$barcode_print->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$barcode_print->isExport()) { ?>
<script>
ew.scrollableTable("gmp_barcode_print", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$barcode_print_list->terminate();
?>