<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$barcode_print_search = new barcode_print_search();

// Run the page
$barcode_print_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barcode_print_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($barcode_print_search->IsModal) { ?>
var fbarcode_printsearch = currentAdvancedSearchForm = new ew.Form("fbarcode_printsearch", "search");
<?php } else { ?>
var fbarcode_printsearch = currentForm = new ew.Form("fbarcode_printsearch", "search");
<?php } ?>

// Form_CustomValidate event
fbarcode_printsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_printsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_printsearch.lists["x_category"] = <?php echo $barcode_print_search->category->Lookup->toClientList() ?>;
fbarcode_printsearch.lists["x_category"].options = <?php echo JsonEncode($barcode_print_search->category->lookupOptions()) ?>;
fbarcode_printsearch.lists["x_weaving_works"] = <?php echo $barcode_print_search->weaving_works->Lookup->toClientList() ?>;
fbarcode_printsearch.lists["x_weaving_works"].options = <?php echo JsonEncode($barcode_print_search->weaving_works->lookupOptions()) ?>;
fbarcode_printsearch.lists["x_buyer_ref"] = <?php echo $barcode_print_search->buyer_ref->Lookup->toClientList() ?>;
fbarcode_printsearch.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_print_search->buyer_ref->lookupOptions()) ?>;
fbarcode_printsearch.lists["x_buyers_id"] = <?php echo $barcode_print_search->buyers_id->Lookup->toClientList() ?>;
fbarcode_printsearch.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_print_search->buyers_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbarcode_printsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_print->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_print->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_design_size");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_print->design_size->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $barcode_print_search->showPageHeader(); ?>
<?php
$barcode_print_search->showMessage();
?>
<form name="fbarcode_printsearch" id="fbarcode_printsearch" class="<?php echo $barcode_print_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($barcode_print_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $barcode_print_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="barcode_print">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$barcode_print_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($barcode_print->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_po"><?php echo $barcode_print->po->caption() ?></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($barcode_print->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_barcode_print_po">
<input type="text" data-table="barcode_print" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($barcode_print->po->getPlaceHolder()) ?>" value="<?php echo $barcode_print->po->EditValue ?>"<?php echo $barcode_print->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_barcode_print_po" class="btw1_po d-none">
<input type="text" data-table="barcode_print" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($barcode_print->po->getPlaceHolder()) ?>" value="<?php echo $barcode_print->po->EditValue2 ?>"<?php echo $barcode_print->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print__barcode"><?php echo $barcode_print->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($barcode_print->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_barcode_print__barcode">
<input type="text" data-table="barcode_print" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_print->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_print->_barcode->EditValue ?>"<?php echo $barcode_print->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_barcode_print__barcode" class="btw1__barcode d-none">
<input type="text" data-table="barcode_print" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_print->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_print->_barcode->EditValue2 ?>"<?php echo $barcode_print->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->design_size->Visible) { // design_size ?>
	<div id="r_design_size" class="form-group row">
		<label for="x_design_size" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_design_size"><?php echo $barcode_print->design_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_size" id="z_design_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->design_size->cellAttributes() ?>>
			<span id="el_barcode_print_design_size">
<input type="text" data-table="barcode_print" data-field="x_design_size" name="x_design_size" id="x_design_size" size="30" placeholder="<?php echo HtmlEncode($barcode_print->design_size->getPlaceHolder()) ?>" value="<?php echo $barcode_print->design_size->EditValue ?>"<?php echo $barcode_print->design_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_category"><?php echo $barcode_print->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->category->cellAttributes() ?>>
			<span id="el_barcode_print_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_print" data-field="x_category" data-value-separator="<?php echo $barcode_print->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $barcode_print->category->editAttributes() ?>>
		<?php echo $barcode_print->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $barcode_print->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_weaving_works"><?php echo $barcode_print->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->weaving_works->cellAttributes() ?>>
			<span id="el_barcode_print_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_print" data-field="x_weaving_works" data-value-separator="<?php echo $barcode_print->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $barcode_print->weaving_works->editAttributes() ?>>
		<?php echo $barcode_print->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $barcode_print->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_buyer_ref"><?php echo $barcode_print->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->buyer_ref->cellAttributes() ?>>
			<span id="el_barcode_print_buyer_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_print" data-field="x_buyer_ref" data-value-separator="<?php echo $barcode_print->buyer_ref->displayValueSeparatorAttribute() ?>" id="x_buyer_ref" name="x_buyer_ref"<?php echo $barcode_print->buyer_ref->editAttributes() ?>>
		<?php echo $barcode_print->buyer_ref->selectOptionListHtml("x_buyer_ref") ?>
	</select>
</div>
<?php echo $barcode_print->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_design"><?php echo $barcode_print->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->design->cellAttributes() ?>>
			<span id="el_barcode_print_design">
<input type="text" data-table="barcode_print" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($barcode_print->design->getPlaceHolder()) ?>" value="<?php echo $barcode_print->design->EditValue ?>"<?php echo $barcode_print->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_size_cm"><?php echo $barcode_print->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->size_cm->cellAttributes() ?>>
			<span id="el_barcode_print_size_cm">
<input type="text" data-table="barcode_print" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($barcode_print->size_cm->getPlaceHolder()) ?>" value="<?php echo $barcode_print->size_cm->EditValue ?>"<?php echo $barcode_print->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_print->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $barcode_print_search->LeftColumnClass ?>"><span id="elh_barcode_print_buyers_id"><?php echo $barcode_print->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $barcode_print_search->RightColumnClass ?>"><div<?php echo $barcode_print->buyers_id->cellAttributes() ?>>
			<span id="el_barcode_print_buyers_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_print" data-field="x_buyers_id" data-value-separator="<?php echo $barcode_print->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $barcode_print->buyers_id->editAttributes() ?>>
		<?php echo $barcode_print->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $barcode_print->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$barcode_print_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $barcode_print_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$barcode_print_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$barcode_print_search->terminate();
?>