<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$barcode_query_edit = new barcode_query_edit();

// Run the page
$barcode_query_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barcode_query_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbarcode_queryedit = currentForm = new ew.Form("fbarcode_queryedit", "edit");

// Validate form
fbarcode_queryedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($barcode_query_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->id->caption(), $barcode_query->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->pl_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->pl_no->caption(), $barcode_query->pl_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->po->caption(), $barcode_query->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->_barcode->caption(), $barcode_query->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->buyers_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyers_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyers_id->caption(), $barcode_query->buyers_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->buyer_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyer_ref->caption(), $barcode_query->buyer_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->buyer_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyer_barcode->caption(), $barcode_query->buyer_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->design_id->caption(), $barcode_query->design_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->batch_no->caption(), $barcode_query->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->category->caption(), $barcode_query->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->size_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_size_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->size_cm->caption(), $barcode_query->size_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->size_buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_size_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->size_buyer->caption(), $barcode_query->size_buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->order_date->caption(), $barcode_query->order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($barcode_query->order_date->errorMessage()) ?>");
		<?php if ($barcode_query_edit->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->despatch_week->caption(), $barcode_query->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->sqm->caption(), $barcode_query->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->remarks->caption(), $barcode_query->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->buyer_po->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyer_po->caption(), $barcode_query->buyer_po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->po_price->Required) { ?>
			elm = this.getElements("x" + infix + "_po_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->po_price->caption(), $barcode_query->po_price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->po_discount->Required) { ?>
			elm = this.getElements("x" + infix + "_po_discount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->po_discount->caption(), $barcode_query->po_discount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_discount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($barcode_query->po_discount->errorMessage()) ?>");
		<?php if ($barcode_query_edit->po_currency->Required) { ?>
			elm = this.getElements("x" + infix + "_po_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->po_currency->caption(), $barcode_query->po_currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->weaving_works->caption(), $barcode_query->weaving_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->current_works->Required) { ?>
			elm = this.getElements("x" + infix + "_current_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->current_works->caption(), $barcode_query->current_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->consignee->Required) { ?>
			elm = this.getElements("x" + infix + "_consignee");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->consignee->caption(), $barcode_query->consignee->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->jc_no->caption(), $barcode_query->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->operator->caption(), $barcode_query->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($barcode_query_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->datetime->caption(), $barcode_query->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbarcode_queryedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_queryedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_queryedit.lists["x_buyers_id"] = <?php echo $barcode_query_edit->buyers_id->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_query_edit->buyers_id->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_buyer_ref"] = <?php echo $barcode_query_edit->buyer_ref->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_query_edit->buyer_ref->lookupOptions()) ?>;
fbarcode_queryedit.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbarcode_queryedit.lists["x_design_id"] = <?php echo $barcode_query_edit->design_id->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_design_id"].options = <?php echo JsonEncode($barcode_query_edit->design_id->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_batch_no"] = <?php echo $barcode_query_edit->batch_no->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_batch_no"].options = <?php echo JsonEncode($barcode_query_edit->batch_no->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_category"] = <?php echo $barcode_query_edit->category->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_category"].options = <?php echo JsonEncode($barcode_query_edit->category->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_despatch_week"] = <?php echo $barcode_query_edit->despatch_week->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_despatch_week"].options = <?php echo JsonEncode($barcode_query_edit->despatch_week->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_po_currency"] = <?php echo $barcode_query_edit->po_currency->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_po_currency"].options = <?php echo JsonEncode($barcode_query_edit->po_currency->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_weaving_works"] = <?php echo $barcode_query_edit->weaving_works->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_weaving_works"].options = <?php echo JsonEncode($barcode_query_edit->weaving_works->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_current_works"] = <?php echo $barcode_query_edit->current_works->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_current_works"].options = <?php echo JsonEncode($barcode_query_edit->current_works->lookupOptions()) ?>;
fbarcode_queryedit.lists["x_consignee"] = <?php echo $barcode_query_edit->consignee->Lookup->toClientList() ?>;
fbarcode_queryedit.lists["x_consignee"].options = <?php echo JsonEncode($barcode_query_edit->consignee->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $barcode_query_edit->showPageHeader(); ?>
<?php
$barcode_query_edit->showMessage();
?>
<form name="fbarcode_queryedit" id="fbarcode_queryedit" class="<?php echo $barcode_query_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($barcode_query_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $barcode_query_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$barcode_query_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($barcode_query->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_barcode_query_id" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->id->caption() ?><?php echo ($barcode_query->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->id->cellAttributes() ?>>
<span id="el_barcode_query_id">
<span<?php echo $barcode_query->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($barcode_query->id->CurrentValue) ?>">
<?php echo $barcode_query->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label id="elh_barcode_query_pl_no" for="x_pl_no" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->pl_no->caption() ?><?php echo ($barcode_query->pl_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->pl_no->cellAttributes() ?>>
<span id="el_barcode_query_pl_no">
<span<?php echo $barcode_query->pl_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->pl_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" value="<?php echo HtmlEncode($barcode_query->pl_no->CurrentValue) ?>">
<?php echo $barcode_query->pl_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_barcode_query_po" for="x_po" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->po->caption() ?><?php echo ($barcode_query->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->po->cellAttributes() ?>>
<span id="el_barcode_query_po">
<span<?php echo $barcode_query->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($barcode_query->po->CurrentValue) ?>">
<?php echo $barcode_query->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_barcode_query__barcode" for="x__barcode" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->_barcode->caption() ?><?php echo ($barcode_query->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->_barcode->cellAttributes() ?>>
<span id="el_barcode_query__barcode">
<span<?php echo $barcode_query->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x__barcode" name="x__barcode" id="x__barcode" value="<?php echo HtmlEncode($barcode_query->_barcode->CurrentValue) ?>">
<?php echo $barcode_query->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label id="elh_barcode_query_buyers_id" for="x_buyers_id" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->buyers_id->caption() ?><?php echo ($barcode_query->buyers_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->buyers_id->cellAttributes() ?>>
<span id="el_barcode_query_buyers_id">
<?php $barcode_query->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$barcode_query->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_buyers_id" data-value-separator="<?php echo $barcode_query->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $barcode_query->buyers_id->editAttributes() ?>>
		<?php echo $barcode_query->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $barcode_query->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
<?php echo $barcode_query->buyers_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label id="elh_barcode_query_buyer_ref" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->buyer_ref->caption() ?><?php echo ($barcode_query->buyer_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_ref->cellAttributes() ?>>
<span id="el_barcode_query_buyer_ref">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$barcode_query->buyer_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$barcode_query->buyer_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_ref" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?php echo RemoveHtml($barcode_query->buyer_ref->EditValue) ?>" placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>"<?php echo $barcode_query->buyer_ref->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->buyer_ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_ref',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->buyer_ref->ReadOnly || $barcode_query->buyer_ref->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyer_ref" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($barcode_query->buyer_ref->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbarcode_queryedit.createAutoSuggest({"id":"x_buyer_ref","forceSelect":true});
</script>
<?php echo $barcode_query->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
<?php echo $barcode_query->buyer_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_barcode->Visible) { // buyer_barcode ?>
	<div id="r_buyer_barcode" class="form-group row">
		<label id="elh_barcode_query_buyer_barcode" for="x_buyer_barcode" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->buyer_barcode->caption() ?><?php echo ($barcode_query->buyer_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_barcode->cellAttributes() ?>>
<span id="el_barcode_query_buyer_barcode">
<input type="text" data-table="barcode_query" data-field="x_buyer_barcode" name="x_buyer_barcode" id="x_buyer_barcode" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($barcode_query->buyer_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_query->buyer_barcode->EditValue ?>"<?php echo $barcode_query->buyer_barcode->editAttributes() ?>>
</span>
<?php echo $barcode_query->buyer_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label id="elh_barcode_query_design_id" for="x_design_id" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->design_id->caption() ?><?php echo ($barcode_query->design_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->design_id->cellAttributes() ?>>
<span id="el_barcode_query_design_id">
<?php $barcode_query->design_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$barcode_query->design_id->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_design_id"><?php echo strval($barcode_query->design_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($barcode_query->design_id->ViewValue) : $barcode_query->design_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->design_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->design_id->ReadOnly || $barcode_query->design_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_design_id',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $barcode_query->design_id->Lookup->getParamTag("p_x_design_id") ?>
<input type="hidden" data-table="barcode_query" data-field="x_design_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->design_id->displayValueSeparatorAttribute() ?>" name="x_design_id" id="x_design_id" value="<?php echo $barcode_query->design_id->CurrentValue ?>"<?php echo $barcode_query->design_id->editAttributes() ?>>
</span>
<?php echo $barcode_query->design_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_barcode_query_batch_no" for="x_batch_no" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->batch_no->caption() ?><?php echo ($barcode_query->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->batch_no->cellAttributes() ?>>
<span id="el_barcode_query_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_batch_no" data-value-separator="<?php echo $barcode_query->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $barcode_query->batch_no->editAttributes() ?>>
		<?php echo $barcode_query->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $barcode_query->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php echo $barcode_query->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_barcode_query_category" for="x_category" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->category->caption() ?><?php echo ($barcode_query->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->category->cellAttributes() ?>>
<span id="el_barcode_query_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_category" data-value-separator="<?php echo $barcode_query->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $barcode_query->category->editAttributes() ?>>
		<?php echo $barcode_query->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $barcode_query->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $barcode_query->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label id="elh_barcode_query_size_cm" for="x_size_cm" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->size_cm->caption() ?><?php echo ($barcode_query->size_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->size_cm->cellAttributes() ?>>
<span id="el_barcode_query_size_cm">
<span<?php echo $barcode_query->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->size_cm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" value="<?php echo HtmlEncode($barcode_query->size_cm->CurrentValue) ?>">
<?php echo $barcode_query->size_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label id="elh_barcode_query_size_buyer" for="x_size_buyer" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->size_buyer->caption() ?><?php echo ($barcode_query->size_buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->size_buyer->cellAttributes() ?>>
<span id="el_barcode_query_size_buyer">
<span<?php echo $barcode_query->size_buyer->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->size_buyer->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" value="<?php echo HtmlEncode($barcode_query->size_buyer->CurrentValue) ?>">
<?php echo $barcode_query->size_buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label id="elh_barcode_query_order_date" for="x_order_date" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->order_date->caption() ?><?php echo ($barcode_query->order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->order_date->cellAttributes() ?>>
<span id="el_barcode_query_order_date">
<input type="text" data-table="barcode_query" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($barcode_query->order_date->getPlaceHolder()) ?>" value="<?php echo $barcode_query->order_date->EditValue ?>"<?php echo $barcode_query->order_date->editAttributes() ?>>
<?php if (!$barcode_query->order_date->ReadOnly && !$barcode_query->order_date->Disabled && !isset($barcode_query->order_date->EditAttrs["readonly"]) && !isset($barcode_query->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbarcode_queryedit", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $barcode_query->order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_barcode_query_despatch_week" for="x_despatch_week" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->despatch_week->caption() ?><?php echo ($barcode_query->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->despatch_week->cellAttributes() ?>>
<span id="el_barcode_query_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_despatch_week" data-value-separator="<?php echo $barcode_query->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $barcode_query->despatch_week->editAttributes() ?>>
		<?php echo $barcode_query->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $barcode_query->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php echo $barcode_query->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_barcode_query_sqm" for="x_sqm" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->sqm->caption() ?><?php echo ($barcode_query->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->sqm->cellAttributes() ?>>
<span id="el_barcode_query_sqm">
<span<?php echo $barcode_query->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_sqm" name="x_sqm" id="x_sqm" value="<?php echo HtmlEncode($barcode_query->sqm->CurrentValue) ?>">
<?php echo $barcode_query->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_barcode_query_remarks" for="x_remarks" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->remarks->caption() ?><?php echo ($barcode_query->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->remarks->cellAttributes() ?>>
<span id="el_barcode_query_remarks">
<input type="text" data-table="barcode_query" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($barcode_query->remarks->getPlaceHolder()) ?>" value="<?php echo $barcode_query->remarks->EditValue ?>"<?php echo $barcode_query->remarks->editAttributes() ?>>
</span>
<?php echo $barcode_query->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label id="elh_barcode_query_buyer_po" for="x_buyer_po" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->buyer_po->caption() ?><?php echo ($barcode_query->buyer_po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_po->cellAttributes() ?>>
<span id="el_barcode_query_buyer_po">
<input type="text" data-table="barcode_query" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($barcode_query->buyer_po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->buyer_po->EditValue ?>"<?php echo $barcode_query->buyer_po->editAttributes() ?>>
</span>
<?php echo $barcode_query->buyer_po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label id="elh_barcode_query_po_price" for="x_po_price" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->po_price->caption() ?><?php echo ($barcode_query->po_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->po_price->cellAttributes() ?>>
<span id="el_barcode_query_po_price">
<input type="text" data-table="barcode_query" data-field="x_po_price" name="x_po_price" id="x_po_price" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($barcode_query->po_price->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po_price->EditValue ?>"<?php echo $barcode_query->po_price->editAttributes() ?>>
</span>
<?php echo $barcode_query->po_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_discount->Visible) { // po_discount ?>
	<div id="r_po_discount" class="form-group row">
		<label id="elh_barcode_query_po_discount" for="x_po_discount" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->po_discount->caption() ?><?php echo ($barcode_query->po_discount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->po_discount->cellAttributes() ?>>
<span id="el_barcode_query_po_discount">
<input type="text" data-table="barcode_query" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" size="30" placeholder="<?php echo HtmlEncode($barcode_query->po_discount->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po_discount->EditValue ?>"<?php echo $barcode_query->po_discount->editAttributes() ?>>
</span>
<?php echo $barcode_query->po_discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_currency->Visible) { // po_currency ?>
	<div id="r_po_currency" class="form-group row">
		<label id="elh_barcode_query_po_currency" for="x_po_currency" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->po_currency->caption() ?><?php echo ($barcode_query->po_currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->po_currency->cellAttributes() ?>>
<span id="el_barcode_query_po_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_po_currency" data-value-separator="<?php echo $barcode_query->po_currency->displayValueSeparatorAttribute() ?>" id="x_po_currency" name="x_po_currency"<?php echo $barcode_query->po_currency->editAttributes() ?>>
		<?php echo $barcode_query->po_currency->selectOptionListHtml("x_po_currency") ?>
	</select>
</div>
<?php echo $barcode_query->po_currency->Lookup->getParamTag("p_x_po_currency") ?>
</span>
<?php echo $barcode_query->po_currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label id="elh_barcode_query_weaving_works" for="x_weaving_works" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->weaving_works->caption() ?><?php echo ($barcode_query->weaving_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->weaving_works->cellAttributes() ?>>
<span id="el_barcode_query_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_weaving_works" data-value-separator="<?php echo $barcode_query->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $barcode_query->weaving_works->editAttributes() ?>>
		<?php echo $barcode_query->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $barcode_query->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
<?php echo $barcode_query->weaving_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label id="elh_barcode_query_current_works" for="x_current_works" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->current_works->caption() ?><?php echo ($barcode_query->current_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->current_works->cellAttributes() ?>>
<span id="el_barcode_query_current_works">
<span<?php echo $barcode_query->current_works->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->current_works->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_current_works" name="x_current_works" id="x_current_works" value="<?php echo HtmlEncode($barcode_query->current_works->CurrentValue) ?>">
<?php echo $barcode_query->current_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->consignee->Visible) { // consignee ?>
	<div id="r_consignee" class="form-group row">
		<label id="elh_barcode_query_consignee" for="x_consignee" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->consignee->caption() ?><?php echo ($barcode_query->consignee->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->consignee->cellAttributes() ?>>
<span id="el_barcode_query_consignee">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_consignee" data-value-separator="<?php echo $barcode_query->consignee->displayValueSeparatorAttribute() ?>" id="x_consignee" name="x_consignee"<?php echo $barcode_query->consignee->editAttributes() ?>>
		<?php echo $barcode_query->consignee->selectOptionListHtml("x_consignee") ?>
	</select>
</div>
<?php echo $barcode_query->consignee->Lookup->getParamTag("p_x_consignee") ?>
</span>
<?php echo $barcode_query->consignee->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_barcode_query_jc_no" for="x_jc_no" class="<?php echo $barcode_query_edit->LeftColumnClass ?>"><?php echo $barcode_query->jc_no->caption() ?><?php echo ($barcode_query->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $barcode_query_edit->RightColumnClass ?>"><div<?php echo $barcode_query->jc_no->cellAttributes() ?>>
<span id="el_barcode_query_jc_no">
<span<?php echo $barcode_query->jc_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->jc_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" value="<?php echo HtmlEncode($barcode_query->jc_no->CurrentValue) ?>">
<?php echo $barcode_query->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$barcode_query_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $barcode_query_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $barcode_query_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$barcode_query_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$barcode_query_edit->terminate();
?>