<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$barcode_query_list = new barcode_query_list();

// Run the page
$barcode_query_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barcode_query_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$barcode_query->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbarcode_querylist = currentForm = new ew.Form("fbarcode_querylist", "list");
fbarcode_querylist.formKeyCountName = '<?php echo $barcode_query_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbarcode_querylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_querylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_querylist.lists["x_buyers_id"] = <?php echo $barcode_query_list->buyers_id->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_query_list->buyers_id->lookupOptions()) ?>;
fbarcode_querylist.lists["x_buyer_ref"] = <?php echo $barcode_query_list->buyer_ref->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_query_list->buyer_ref->lookupOptions()) ?>;
fbarcode_querylist.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbarcode_querylist.lists["x_design_id"] = <?php echo $barcode_query_list->design_id->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_design_id"].options = <?php echo JsonEncode($barcode_query_list->design_id->lookupOptions()) ?>;
fbarcode_querylist.lists["x_batch_no"] = <?php echo $barcode_query_list->batch_no->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_batch_no"].options = <?php echo JsonEncode($barcode_query_list->batch_no->lookupOptions()) ?>;
fbarcode_querylist.lists["x_category"] = <?php echo $barcode_query_list->category->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_category"].options = <?php echo JsonEncode($barcode_query_list->category->lookupOptions()) ?>;
fbarcode_querylist.lists["x_despatch_week"] = <?php echo $barcode_query_list->despatch_week->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_despatch_week"].options = <?php echo JsonEncode($barcode_query_list->despatch_week->lookupOptions()) ?>;
fbarcode_querylist.lists["x_po_currency"] = <?php echo $barcode_query_list->po_currency->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_po_currency"].options = <?php echo JsonEncode($barcode_query_list->po_currency->lookupOptions()) ?>;
fbarcode_querylist.lists["x_weaving_works"] = <?php echo $barcode_query_list->weaving_works->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_weaving_works"].options = <?php echo JsonEncode($barcode_query_list->weaving_works->lookupOptions()) ?>;
fbarcode_querylist.lists["x_current_works"] = <?php echo $barcode_query_list->current_works->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_current_works"].options = <?php echo JsonEncode($barcode_query_list->current_works->lookupOptions()) ?>;
fbarcode_querylist.lists["x_consignee"] = <?php echo $barcode_query_list->consignee->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_consignee"].options = <?php echo JsonEncode($barcode_query_list->consignee->lookupOptions()) ?>;
fbarcode_querylist.lists["x_completed"] = <?php echo $barcode_query_list->completed->Lookup->toClientList() ?>;
fbarcode_querylist.lists["x_completed"].options = <?php echo JsonEncode($barcode_query_list->completed->options(FALSE, TRUE)) ?>;

// Form object for search
var fbarcode_querylistsrch = currentSearchForm = new ew.Form("fbarcode_querylistsrch");

// Validate function for search
fbarcode_querylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbarcode_querylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_querylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_querylistsrch.lists["x_buyers_id"] = <?php echo $barcode_query_list->buyers_id->Lookup->toClientList() ?>;
fbarcode_querylistsrch.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_query_list->buyers_id->lookupOptions()) ?>;
fbarcode_querylistsrch.lists["x_buyer_ref"] = <?php echo $barcode_query_list->buyer_ref->Lookup->toClientList() ?>;
fbarcode_querylistsrch.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_query_list->buyer_ref->lookupOptions()) ?>;
fbarcode_querylistsrch.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbarcode_querylistsrch.lists["x_design_id"] = <?php echo $barcode_query_list->design_id->Lookup->toClientList() ?>;
fbarcode_querylistsrch.lists["x_design_id"].options = <?php echo JsonEncode($barcode_query_list->design_id->lookupOptions()) ?>;
fbarcode_querylistsrch.lists["x_despatch_week"] = <?php echo $barcode_query_list->despatch_week->Lookup->toClientList() ?>;
fbarcode_querylistsrch.lists["x_despatch_week"].options = <?php echo JsonEncode($barcode_query_list->despatch_week->lookupOptions()) ?>;
fbarcode_querylistsrch.lists["x_completed"] = <?php echo $barcode_query_list->completed->Lookup->toClientList() ?>;
fbarcode_querylistsrch.lists["x_completed"].options = <?php echo JsonEncode($barcode_query_list->completed->options(FALSE, TRUE)) ?>;

// Filters
fbarcode_querylistsrch.filterList = <?php echo $barcode_query_list->getFilterList() ?>;

// Init search panel as collapsed
fbarcode_querylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$barcode_query->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($barcode_query_list->TotalRecs > 0 && $barcode_query_list->ExportOptions->visible()) { ?>
<?php $barcode_query_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($barcode_query_list->ImportOptions->visible()) { ?>
<?php $barcode_query_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($barcode_query_list->SearchOptions->visible()) { ?>
<?php $barcode_query_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($barcode_query_list->FilterOptions->visible()) { ?>
<?php $barcode_query_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$barcode_query_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$barcode_query->isExport() && !$barcode_query->CurrentAction) { ?>
<form name="fbarcode_querylistsrch" id="fbarcode_querylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($barcode_query_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbarcode_querylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="barcode_query">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$barcode_query_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$barcode_query->RowType = ROWTYPE_SEARCH;

// Render row
$barcode_query->resetAttributes();
$barcode_query_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($barcode_query->pl_no->Visible) { // pl_no ?>
	<div id="xsc_pl_no" class="ew-cell form-group">
		<label for="x_pl_no" class="ew-search-caption ew-label"><?php echo $barcode_query->pl_no->caption() ?></label>
		<span class="ew-search-operator"><select name="z_pl_no" id="z_pl_no" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="barcode_query" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($barcode_query->pl_no->getPlaceHolder()) ?>" value="<?php echo $barcode_query->pl_no->EditValue ?>"<?php echo $barcode_query->pl_no->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_pl_no style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_pl_no style="d-none"">
<input type="text" data-table="barcode_query" data-field="x_pl_no" name="y_pl_no" id="y_pl_no" size="30" placeholder="<?php echo HtmlEncode($barcode_query->pl_no->getPlaceHolder()) ?>" value="<?php echo $barcode_query->pl_no->EditValue2 ?>"<?php echo $barcode_query->pl_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($barcode_query->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $barcode_query->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="barcode_query" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($barcode_query->po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po->EditValue ?>"<?php echo $barcode_query->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="barcode_query" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($barcode_query->po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po->EditValue2 ?>"<?php echo $barcode_query->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($barcode_query->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $barcode_query->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="barcode_query" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_query->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_query->_barcode->EditValue ?>"<?php echo $barcode_query->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="barcode_query" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_query->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_query->_barcode->EditValue2 ?>"<?php echo $barcode_query->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($barcode_query->buyers_id->Visible) { // buyers_id ?>
	<div id="xsc_buyers_id" class="ew-cell form-group">
		<label for="x_buyers_id" class="ew-search-caption ew-label"><?php echo $barcode_query->buyers_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		<span class="ew-search-field">
<?php $barcode_query->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$barcode_query->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_buyers_id" data-value-separator="<?php echo $barcode_query->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $barcode_query->buyers_id->editAttributes() ?>>
		<?php echo $barcode_query->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $barcode_query->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($barcode_query->buyer_ref->Visible) { // buyer_ref ?>
	<div id="xsc_buyer_ref" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $barcode_query->buyer_ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$barcode_query->buyer_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$barcode_query->buyer_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_ref" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?php echo RemoveHtml($barcode_query->buyer_ref->EditValue) ?>" placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>"<?php echo $barcode_query->buyer_ref->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->buyer_ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_ref',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->buyer_ref->ReadOnly || $barcode_query->buyer_ref->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyer_ref" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($barcode_query->buyer_ref->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbarcode_querylistsrch.createAutoSuggest({"id":"x_buyer_ref","forceSelect":false});
</script>
<?php echo $barcode_query->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
	</div>
<?php } ?>
<?php if ($barcode_query->design_id->Visible) { // design_id ?>
	<div id="xsc_design_id" class="ew-cell form-group">
		<label for="x_design_id" class="ew-search-caption ew-label"><?php echo $barcode_query->design_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_design_id"><?php echo strval($barcode_query->design_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($barcode_query->design_id->AdvancedSearch->ViewValue) : $barcode_query->design_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->design_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->design_id->ReadOnly || $barcode_query->design_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_design_id',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $barcode_query->design_id->Lookup->getParamTag("p_x_design_id") ?>
<input type="hidden" data-table="barcode_query" data-field="x_design_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->design_id->displayValueSeparatorAttribute() ?>" name="x_design_id" id="x_design_id" value="<?php echo $barcode_query->design_id->AdvancedSearch->SearchValue ?>"<?php echo $barcode_query->design_id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
<?php if ($barcode_query->despatch_week->Visible) { // despatch_week ?>
	<div id="xsc_despatch_week" class="ew-cell form-group">
		<label for="x_despatch_week" class="ew-search-caption ew-label"><?php echo $barcode_query->despatch_week->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_despatch_week" data-value-separator="<?php echo $barcode_query->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $barcode_query->despatch_week->editAttributes() ?>>
		<?php echo $barcode_query->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $barcode_query->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_po->Visible) { // buyer_po ?>
	<div id="xsc_buyer_po" class="ew-cell form-group">
		<label for="x_buyer_po" class="ew-search-caption ew-label"><?php echo $barcode_query->buyer_po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="barcode_query" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($barcode_query->buyer_po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->buyer_po->EditValue ?>"<?php echo $barcode_query->buyer_po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ew-row d-sm-flex">
<?php if ($barcode_query->completed->Visible) { // completed ?>
	<div id="xsc_completed" class="ew-cell form-group">
		<label for="x_completed" class="ew-search-caption ew-label"><?php echo $barcode_query->completed->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_completed" id="z_completed" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_completed" data-value-separator="<?php echo $barcode_query->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $barcode_query->completed->editAttributes() ?>>
		<?php echo $barcode_query->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($barcode_query_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($barcode_query_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $barcode_query_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($barcode_query_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($barcode_query_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($barcode_query_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($barcode_query_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $barcode_query_list->showPageHeader(); ?>
<?php
$barcode_query_list->showMessage();
?>
<?php if ($barcode_query_list->TotalRecs > 0 || $barcode_query->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($barcode_query_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> barcode_query">
<?php if (!$barcode_query->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$barcode_query->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($barcode_query_list->Pager)) $barcode_query_list->Pager = new PrevNextPager($barcode_query_list->StartRec, $barcode_query_list->DisplayRecs, $barcode_query_list->TotalRecs, $barcode_query_list->AutoHidePager) ?>
<?php if ($barcode_query_list->Pager->RecordCount > 0 && $barcode_query_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($barcode_query_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($barcode_query_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $barcode_query_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($barcode_query_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($barcode_query_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $barcode_query_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($barcode_query_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $barcode_query_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $barcode_query_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $barcode_query_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($barcode_query_list->TotalRecs > 0 && (!$barcode_query_list->AutoHidePageSizeSelector || $barcode_query_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="barcode_query">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($barcode_query_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($barcode_query_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($barcode_query_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $barcode_query_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbarcode_querylist" id="fbarcode_querylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($barcode_query_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $barcode_query_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<div id="gmp_barcode_query" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($barcode_query_list->TotalRecs > 0 || $barcode_query->isGridEdit()) { ?>
<table id="tbl_barcode_querylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$barcode_query_list->RowType = ROWTYPE_HEADER;

// Render list options
$barcode_query_list->renderListOptions();

// Render list options (header, left)
$barcode_query_list->ListOptions->render("header", "left");
?>
<?php if ($barcode_query->id->Visible) { // id ?>
	<?php if ($barcode_query->sortUrl($barcode_query->id) == "") { ?>
		<th data-name="id" class="<?php echo $barcode_query->id->headerCellClass() ?>"><div id="elh_barcode_query_id" class="barcode_query_id"><div class="ew-table-header-caption"><?php echo $barcode_query->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $barcode_query->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->id) ?>',2);"><div id="elh_barcode_query_id" class="barcode_query_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->pl_no->Visible) { // pl_no ?>
	<?php if ($barcode_query->sortUrl($barcode_query->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $barcode_query->pl_no->headerCellClass() ?>"><div id="elh_barcode_query_pl_no" class="barcode_query_pl_no"><div class="ew-table-header-caption"><?php echo $barcode_query->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $barcode_query->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->pl_no) ?>',2);"><div id="elh_barcode_query_pl_no" class="barcode_query_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->pl_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->po->Visible) { // po ?>
	<?php if ($barcode_query->sortUrl($barcode_query->po) == "") { ?>
		<th data-name="po" class="<?php echo $barcode_query->po->headerCellClass() ?>"><div id="elh_barcode_query_po" class="barcode_query_po"><div class="ew-table-header-caption"><?php echo $barcode_query->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $barcode_query->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->po) ?>',2);"><div id="elh_barcode_query_po" class="barcode_query_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->_barcode->Visible) { // barcode ?>
	<?php if ($barcode_query->sortUrl($barcode_query->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $barcode_query->_barcode->headerCellClass() ?>"><div id="elh_barcode_query__barcode" class="barcode_query__barcode"><div class="ew-table-header-caption"><?php echo $barcode_query->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $barcode_query->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->_barcode) ?>',2);"><div id="elh_barcode_query__barcode" class="barcode_query__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->buyers_id->Visible) { // buyers_id ?>
	<?php if ($barcode_query->sortUrl($barcode_query->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $barcode_query->buyers_id->headerCellClass() ?>"><div id="elh_barcode_query_buyers_id" class="barcode_query_buyers_id"><div class="ew-table-header-caption"><?php echo $barcode_query->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $barcode_query->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->buyers_id) ?>',2);"><div id="elh_barcode_query_buyers_id" class="barcode_query_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($barcode_query->sortUrl($barcode_query->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $barcode_query->buyer_ref->headerCellClass() ?>"><div id="elh_barcode_query_buyer_ref" class="barcode_query_buyer_ref"><div class="ew-table-header-caption"><?php echo $barcode_query->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $barcode_query->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->buyer_ref) ?>',2);"><div id="elh_barcode_query_buyer_ref" class="barcode_query_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->buyer_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->buyer_barcode->Visible) { // buyer_barcode ?>
	<?php if ($barcode_query->sortUrl($barcode_query->buyer_barcode) == "") { ?>
		<th data-name="buyer_barcode" class="<?php echo $barcode_query->buyer_barcode->headerCellClass() ?>"><div id="elh_barcode_query_buyer_barcode" class="barcode_query_buyer_barcode"><div class="ew-table-header-caption"><?php echo $barcode_query->buyer_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_barcode" class="<?php echo $barcode_query->buyer_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->buyer_barcode) ?>',2);"><div id="elh_barcode_query_buyer_barcode" class="barcode_query_buyer_barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->buyer_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->buyer_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->buyer_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->design_id->Visible) { // design_id ?>
	<?php if ($barcode_query->sortUrl($barcode_query->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $barcode_query->design_id->headerCellClass() ?>"><div id="elh_barcode_query_design_id" class="barcode_query_design_id"><div class="ew-table-header-caption"><?php echo $barcode_query->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $barcode_query->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->design_id) ?>',2);"><div id="elh_barcode_query_design_id" class="barcode_query_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->batch_no->Visible) { // batch_no ?>
	<?php if ($barcode_query->sortUrl($barcode_query->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $barcode_query->batch_no->headerCellClass() ?>"><div id="elh_barcode_query_batch_no" class="barcode_query_batch_no"><div class="ew-table-header-caption"><?php echo $barcode_query->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $barcode_query->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->batch_no) ?>',2);"><div id="elh_barcode_query_batch_no" class="barcode_query_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->category->Visible) { // category ?>
	<?php if ($barcode_query->sortUrl($barcode_query->category) == "") { ?>
		<th data-name="category" class="<?php echo $barcode_query->category->headerCellClass() ?>"><div id="elh_barcode_query_category" class="barcode_query_category"><div class="ew-table-header-caption"><?php echo $barcode_query->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $barcode_query->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->category) ?>',2);"><div id="elh_barcode_query_category" class="barcode_query_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->size_cm->Visible) { // size_cm ?>
	<?php if ($barcode_query->sortUrl($barcode_query->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $barcode_query->size_cm->headerCellClass() ?>"><div id="elh_barcode_query_size_cm" class="barcode_query_size_cm"><div class="ew-table-header-caption"><?php echo $barcode_query->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $barcode_query->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->size_cm) ?>',2);"><div id="elh_barcode_query_size_cm" class="barcode_query_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->size_buyer->Visible) { // size_buyer ?>
	<?php if ($barcode_query->sortUrl($barcode_query->size_buyer) == "") { ?>
		<th data-name="size_buyer" class="<?php echo $barcode_query->size_buyer->headerCellClass() ?>"><div id="elh_barcode_query_size_buyer" class="barcode_query_size_buyer"><div class="ew-table-header-caption"><?php echo $barcode_query->size_buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_buyer" class="<?php echo $barcode_query->size_buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->size_buyer) ?>',2);"><div id="elh_barcode_query_size_buyer" class="barcode_query_size_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->size_buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->size_buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->size_buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->order_date->Visible) { // order_date ?>
	<?php if ($barcode_query->sortUrl($barcode_query->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $barcode_query->order_date->headerCellClass() ?>"><div id="elh_barcode_query_order_date" class="barcode_query_order_date"><div class="ew-table-header-caption"><?php echo $barcode_query->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $barcode_query->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->order_date) ?>',2);"><div id="elh_barcode_query_order_date" class="barcode_query_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->despatch_week->Visible) { // despatch_week ?>
	<?php if ($barcode_query->sortUrl($barcode_query->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $barcode_query->despatch_week->headerCellClass() ?>"><div id="elh_barcode_query_despatch_week" class="barcode_query_despatch_week"><div class="ew-table-header-caption"><?php echo $barcode_query->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $barcode_query->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->despatch_week) ?>',2);"><div id="elh_barcode_query_despatch_week" class="barcode_query_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->sqm->Visible) { // sqm ?>
	<?php if ($barcode_query->sortUrl($barcode_query->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $barcode_query->sqm->headerCellClass() ?>"><div id="elh_barcode_query_sqm" class="barcode_query_sqm"><div class="ew-table-header-caption"><?php echo $barcode_query->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $barcode_query->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->sqm) ?>',2);"><div id="elh_barcode_query_sqm" class="barcode_query_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->remarks->Visible) { // remarks ?>
	<?php if ($barcode_query->sortUrl($barcode_query->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $barcode_query->remarks->headerCellClass() ?>"><div id="elh_barcode_query_remarks" class="barcode_query_remarks"><div class="ew-table-header-caption"><?php echo $barcode_query->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $barcode_query->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->remarks) ?>',2);"><div id="elh_barcode_query_remarks" class="barcode_query_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->buyer_po->Visible) { // buyer_po ?>
	<?php if ($barcode_query->sortUrl($barcode_query->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $barcode_query->buyer_po->headerCellClass() ?>"><div id="elh_barcode_query_buyer_po" class="barcode_query_buyer_po"><div class="ew-table-header-caption"><?php echo $barcode_query->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $barcode_query->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->buyer_po) ?>',2);"><div id="elh_barcode_query_buyer_po" class="barcode_query_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->po_price->Visible) { // po_price ?>
	<?php if ($barcode_query->sortUrl($barcode_query->po_price) == "") { ?>
		<th data-name="po_price" class="<?php echo $barcode_query->po_price->headerCellClass() ?>"><div id="elh_barcode_query_po_price" class="barcode_query_po_price"><div class="ew-table-header-caption"><?php echo $barcode_query->po_price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_price" class="<?php echo $barcode_query->po_price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->po_price) ?>',2);"><div id="elh_barcode_query_po_price" class="barcode_query_po_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->po_price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->po_price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->po_price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->po_discount->Visible) { // po_discount ?>
	<?php if ($barcode_query->sortUrl($barcode_query->po_discount) == "") { ?>
		<th data-name="po_discount" class="<?php echo $barcode_query->po_discount->headerCellClass() ?>"><div id="elh_barcode_query_po_discount" class="barcode_query_po_discount"><div class="ew-table-header-caption"><?php echo $barcode_query->po_discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_discount" class="<?php echo $barcode_query->po_discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->po_discount) ?>',2);"><div id="elh_barcode_query_po_discount" class="barcode_query_po_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->po_discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->po_discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->po_discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->po_currency->Visible) { // po_currency ?>
	<?php if ($barcode_query->sortUrl($barcode_query->po_currency) == "") { ?>
		<th data-name="po_currency" class="<?php echo $barcode_query->po_currency->headerCellClass() ?>"><div id="elh_barcode_query_po_currency" class="barcode_query_po_currency"><div class="ew-table-header-caption"><?php echo $barcode_query->po_currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_currency" class="<?php echo $barcode_query->po_currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->po_currency) ?>',2);"><div id="elh_barcode_query_po_currency" class="barcode_query_po_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->po_currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->po_currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->po_currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->weaving_works->Visible) { // weaving_works ?>
	<?php if ($barcode_query->sortUrl($barcode_query->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $barcode_query->weaving_works->headerCellClass() ?>"><div id="elh_barcode_query_weaving_works" class="barcode_query_weaving_works"><div class="ew-table-header-caption"><?php echo $barcode_query->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $barcode_query->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->weaving_works) ?>',2);"><div id="elh_barcode_query_weaving_works" class="barcode_query_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->current_works->Visible) { // current_works ?>
	<?php if ($barcode_query->sortUrl($barcode_query->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $barcode_query->current_works->headerCellClass() ?>"><div id="elh_barcode_query_current_works" class="barcode_query_current_works"><div class="ew-table-header-caption"><?php echo $barcode_query->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $barcode_query->current_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->current_works) ?>',2);"><div id="elh_barcode_query_current_works" class="barcode_query_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->consignee->Visible) { // consignee ?>
	<?php if ($barcode_query->sortUrl($barcode_query->consignee) == "") { ?>
		<th data-name="consignee" class="<?php echo $barcode_query->consignee->headerCellClass() ?>"><div id="elh_barcode_query_consignee" class="barcode_query_consignee"><div class="ew-table-header-caption"><?php echo $barcode_query->consignee->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consignee" class="<?php echo $barcode_query->consignee->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->consignee) ?>',2);"><div id="elh_barcode_query_consignee" class="barcode_query_consignee">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->consignee->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->consignee->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->consignee->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->jc_no->Visible) { // jc_no ?>
	<?php if ($barcode_query->sortUrl($barcode_query->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $barcode_query->jc_no->headerCellClass() ?>"><div id="elh_barcode_query_jc_no" class="barcode_query_jc_no"><div class="ew-table-header-caption"><?php echo $barcode_query->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $barcode_query->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->jc_no) ?>',2);"><div id="elh_barcode_query_jc_no" class="barcode_query_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->operator->Visible) { // operator ?>
	<?php if ($barcode_query->sortUrl($barcode_query->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $barcode_query->operator->headerCellClass() ?>"><div id="elh_barcode_query_operator" class="barcode_query_operator"><div class="ew-table-header-caption"><?php echo $barcode_query->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $barcode_query->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->operator) ?>',2);"><div id="elh_barcode_query_operator" class="barcode_query_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->datetime->Visible) { // datetime ?>
	<?php if ($barcode_query->sortUrl($barcode_query->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $barcode_query->datetime->headerCellClass() ?>"><div id="elh_barcode_query_datetime" class="barcode_query_datetime"><div class="ew-table-header-caption"><?php echo $barcode_query->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $barcode_query->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->datetime) ?>',2);"><div id="elh_barcode_query_datetime" class="barcode_query_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($barcode_query->completed->Visible) { // completed ?>
	<?php if ($barcode_query->sortUrl($barcode_query->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $barcode_query->completed->headerCellClass() ?>"><div id="elh_barcode_query_completed" class="barcode_query_completed"><div class="ew-table-header-caption"><?php echo $barcode_query->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $barcode_query->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $barcode_query->SortUrl($barcode_query->completed) ?>',2);"><div id="elh_barcode_query_completed" class="barcode_query_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $barcode_query->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($barcode_query->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($barcode_query->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$barcode_query_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($barcode_query->ExportAll && $barcode_query->isExport()) {
	$barcode_query_list->StopRec = $barcode_query_list->TotalRecs;
} else {

	// Set the last record to display
	if ($barcode_query_list->TotalRecs > $barcode_query_list->StartRec + $barcode_query_list->DisplayRecs - 1)
		$barcode_query_list->StopRec = $barcode_query_list->StartRec + $barcode_query_list->DisplayRecs - 1;
	else
		$barcode_query_list->StopRec = $barcode_query_list->TotalRecs;
}
$barcode_query_list->RecCnt = $barcode_query_list->StartRec - 1;
if ($barcode_query_list->Recordset && !$barcode_query_list->Recordset->EOF) {
	$barcode_query_list->Recordset->moveFirst();
	$selectLimit = $barcode_query_list->UseSelectLimit;
	if (!$selectLimit && $barcode_query_list->StartRec > 1)
		$barcode_query_list->Recordset->move($barcode_query_list->StartRec - 1);
} elseif (!$barcode_query->AllowAddDeleteRow && $barcode_query_list->StopRec == 0) {
	$barcode_query_list->StopRec = $barcode_query->GridAddRowCount;
}

// Initialize aggregate
$barcode_query->RowType = ROWTYPE_AGGREGATEINIT;
$barcode_query->resetAttributes();
$barcode_query_list->renderRow();
while ($barcode_query_list->RecCnt < $barcode_query_list->StopRec) {
	$barcode_query_list->RecCnt++;
	if ($barcode_query_list->RecCnt >= $barcode_query_list->StartRec) {
		$barcode_query_list->RowCnt++;

		// Set up key count
		$barcode_query_list->KeyCount = $barcode_query_list->RowIndex;

		// Init row class and style
		$barcode_query->resetAttributes();
		$barcode_query->CssClass = "";
		if ($barcode_query->isGridAdd()) {
		} else {
			$barcode_query_list->loadRowValues($barcode_query_list->Recordset); // Load row values
		}
		$barcode_query->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$barcode_query->RowAttrs = array_merge($barcode_query->RowAttrs, array('data-rowindex'=>$barcode_query_list->RowCnt, 'id'=>'r' . $barcode_query_list->RowCnt . '_barcode_query', 'data-rowtype'=>$barcode_query->RowType));

		// Render row
		$barcode_query_list->renderRow();

		// Render list options
		$barcode_query_list->renderListOptions();
?>
	<tr<?php echo $barcode_query->rowAttributes() ?>>
<?php

// Render list options (body, left)
$barcode_query_list->ListOptions->render("body", "left", $barcode_query_list->RowCnt);
?>
	<?php if ($barcode_query->id->Visible) { // id ?>
		<td data-name="id"<?php echo $barcode_query->id->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_id" class="barcode_query_id">
<span<?php echo $barcode_query->id->viewAttributes() ?>>
<?php echo $barcode_query->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $barcode_query->pl_no->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_pl_no" class="barcode_query_pl_no">
<span<?php echo $barcode_query->pl_no->viewAttributes() ?>>
<?php echo $barcode_query->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->po->Visible) { // po ?>
		<td data-name="po"<?php echo $barcode_query->po->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_po" class="barcode_query_po">
<span<?php echo $barcode_query->po->viewAttributes() ?>>
<?php echo $barcode_query->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $barcode_query->_barcode->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query__barcode" class="barcode_query__barcode">
<span<?php echo $barcode_query->_barcode->viewAttributes() ?>>
<?php echo $barcode_query->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $barcode_query->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_buyers_id" class="barcode_query_buyers_id">
<span<?php echo $barcode_query->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($barcode_query->buyers_id->getViewValue())) && $barcode_query->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $barcode_query->buyers_id->linkAttributes() ?>><?php echo $barcode_query->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $barcode_query->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $barcode_query->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_buyer_ref" class="barcode_query_buyer_ref">
<span<?php echo $barcode_query->buyer_ref->viewAttributes() ?>>
<?php echo $barcode_query->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode"<?php echo $barcode_query->buyer_barcode->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_buyer_barcode" class="barcode_query_buyer_barcode">
<span<?php echo $barcode_query->buyer_barcode->viewAttributes() ?>>
<?php echo $barcode_query->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $barcode_query->design_id->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_design_id" class="barcode_query_design_id">
<span<?php echo $barcode_query->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($barcode_query->design_id->getViewValue())) && $barcode_query->design_id->linkAttributes() <> "") { ?>
<a<?php echo $barcode_query->design_id->linkAttributes() ?>><?php echo $barcode_query->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $barcode_query->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $barcode_query->batch_no->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_batch_no" class="barcode_query_batch_no">
<span<?php echo $barcode_query->batch_no->viewAttributes() ?>>
<?php echo $barcode_query->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->category->Visible) { // category ?>
		<td data-name="category"<?php echo $barcode_query->category->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_category" class="barcode_query_category">
<span<?php echo $barcode_query->category->viewAttributes() ?>>
<?php echo $barcode_query->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $barcode_query->size_cm->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_size_cm" class="barcode_query_size_cm">
<span<?php echo $barcode_query->size_cm->viewAttributes() ?>>
<?php echo $barcode_query->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer"<?php echo $barcode_query->size_buyer->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_size_buyer" class="barcode_query_size_buyer">
<span<?php echo $barcode_query->size_buyer->viewAttributes() ?>>
<?php echo $barcode_query->size_buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $barcode_query->order_date->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_order_date" class="barcode_query_order_date">
<span<?php echo $barcode_query->order_date->viewAttributes() ?>>
<?php echo $barcode_query->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $barcode_query->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_despatch_week" class="barcode_query_despatch_week">
<span<?php echo $barcode_query->despatch_week->viewAttributes() ?>>
<?php echo $barcode_query->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $barcode_query->sqm->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_sqm" class="barcode_query_sqm">
<span<?php echo $barcode_query->sqm->viewAttributes() ?>>
<?php echo $barcode_query->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $barcode_query->remarks->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_remarks" class="barcode_query_remarks">
<span<?php echo $barcode_query->remarks->viewAttributes() ?>>
<?php echo $barcode_query->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $barcode_query->buyer_po->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_buyer_po" class="barcode_query_buyer_po">
<span<?php echo $barcode_query->buyer_po->viewAttributes() ?>>
<?php echo $barcode_query->buyer_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->po_price->Visible) { // po_price ?>
		<td data-name="po_price"<?php echo $barcode_query->po_price->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_po_price" class="barcode_query_po_price">
<span<?php echo $barcode_query->po_price->viewAttributes() ?>>
<?php echo $barcode_query->po_price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->po_discount->Visible) { // po_discount ?>
		<td data-name="po_discount"<?php echo $barcode_query->po_discount->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_po_discount" class="barcode_query_po_discount">
<span<?php echo $barcode_query->po_discount->viewAttributes() ?>>
<?php echo $barcode_query->po_discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->po_currency->Visible) { // po_currency ?>
		<td data-name="po_currency"<?php echo $barcode_query->po_currency->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_po_currency" class="barcode_query_po_currency">
<span<?php echo $barcode_query->po_currency->viewAttributes() ?>>
<?php echo $barcode_query->po_currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $barcode_query->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_weaving_works" class="barcode_query_weaving_works">
<span<?php echo $barcode_query->weaving_works->viewAttributes() ?>>
<?php echo $barcode_query->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $barcode_query->current_works->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_current_works" class="barcode_query_current_works">
<span<?php echo $barcode_query->current_works->viewAttributes() ?>>
<?php echo $barcode_query->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->consignee->Visible) { // consignee ?>
		<td data-name="consignee"<?php echo $barcode_query->consignee->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_consignee" class="barcode_query_consignee">
<span<?php echo $barcode_query->consignee->viewAttributes() ?>>
<?php echo $barcode_query->consignee->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $barcode_query->jc_no->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_jc_no" class="barcode_query_jc_no">
<span<?php echo $barcode_query->jc_no->viewAttributes() ?>>
<?php echo $barcode_query->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $barcode_query->operator->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_operator" class="barcode_query_operator">
<span<?php echo $barcode_query->operator->viewAttributes() ?>>
<?php echo $barcode_query->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $barcode_query->datetime->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_datetime" class="barcode_query_datetime">
<span<?php echo $barcode_query->datetime->viewAttributes() ?>>
<?php echo $barcode_query->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($barcode_query->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $barcode_query->completed->cellAttributes() ?>>
<span id="el<?php echo $barcode_query_list->RowCnt ?>_barcode_query_completed" class="barcode_query_completed">
<span<?php echo $barcode_query->completed->viewAttributes() ?>>
<?php echo $barcode_query->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$barcode_query_list->ListOptions->render("body", "right", $barcode_query_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$barcode_query->isGridAdd())
		$barcode_query_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$barcode_query->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($barcode_query_list->Recordset)
	$barcode_query_list->Recordset->Close();
?>
<?php if (!$barcode_query->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$barcode_query->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($barcode_query_list->Pager)) $barcode_query_list->Pager = new PrevNextPager($barcode_query_list->StartRec, $barcode_query_list->DisplayRecs, $barcode_query_list->TotalRecs, $barcode_query_list->AutoHidePager) ?>
<?php if ($barcode_query_list->Pager->RecordCount > 0 && $barcode_query_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($barcode_query_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($barcode_query_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $barcode_query_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($barcode_query_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($barcode_query_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $barcode_query_list->pageUrl() ?>start=<?php echo $barcode_query_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $barcode_query_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($barcode_query_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $barcode_query_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $barcode_query_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $barcode_query_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($barcode_query_list->TotalRecs > 0 && (!$barcode_query_list->AutoHidePageSizeSelector || $barcode_query_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="barcode_query">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($barcode_query_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($barcode_query_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($barcode_query_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $barcode_query_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($barcode_query_list->TotalRecs == 0 && !$barcode_query->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $barcode_query_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$barcode_query_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$barcode_query->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$barcode_query->isExport()) { ?>
<script>
ew.scrollableTable("gmp_barcode_query", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$barcode_query_list->terminate();
?>