<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$barcode_query_search = new barcode_query_search();

// Run the page
$barcode_query_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barcode_query_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($barcode_query_search->IsModal) { ?>
var fbarcode_querysearch = currentAdvancedSearchForm = new ew.Form("fbarcode_querysearch", "search");
<?php } else { ?>
var fbarcode_querysearch = currentForm = new ew.Form("fbarcode_querysearch", "search");
<?php } ?>

// Form_CustomValidate event
fbarcode_querysearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_querysearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_querysearch.lists["x_buyers_id"] = <?php echo $barcode_query_search->buyers_id->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_query_search->buyers_id->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_buyer_ref"] = <?php echo $barcode_query_search->buyer_ref->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_query_search->buyer_ref->lookupOptions()) ?>;
fbarcode_querysearch.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbarcode_querysearch.lists["x_design_id"] = <?php echo $barcode_query_search->design_id->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_design_id"].options = <?php echo JsonEncode($barcode_query_search->design_id->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_batch_no"] = <?php echo $barcode_query_search->batch_no->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_batch_no"].options = <?php echo JsonEncode($barcode_query_search->batch_no->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_category"] = <?php echo $barcode_query_search->category->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_category"].options = <?php echo JsonEncode($barcode_query_search->category->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_despatch_week"] = <?php echo $barcode_query_search->despatch_week->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_despatch_week"].options = <?php echo JsonEncode($barcode_query_search->despatch_week->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_po_currency"] = <?php echo $barcode_query_search->po_currency->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_po_currency"].options = <?php echo JsonEncode($barcode_query_search->po_currency->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_weaving_works"] = <?php echo $barcode_query_search->weaving_works->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_weaving_works"].options = <?php echo JsonEncode($barcode_query_search->weaving_works->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_current_works"] = <?php echo $barcode_query_search->current_works->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_current_works"].options = <?php echo JsonEncode($barcode_query_search->current_works->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_consignee"] = <?php echo $barcode_query_search->consignee->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_consignee"].options = <?php echo JsonEncode($barcode_query_search->consignee->lookupOptions()) ?>;
fbarcode_querysearch.lists["x_completed"] = <?php echo $barcode_query_search->completed->Lookup->toClientList() ?>;
fbarcode_querysearch.lists["x_completed"].options = <?php echo JsonEncode($barcode_query_search->completed->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fbarcode_querysearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->po_discount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($barcode_query->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $barcode_query_search->showPageHeader(); ?>
<?php
$barcode_query_search->showMessage();
?>
<form name="fbarcode_querysearch" id="fbarcode_querysearch" class="<?php echo $barcode_query_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($barcode_query_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $barcode_query_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$barcode_query_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($barcode_query->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_id"><?php echo $barcode_query->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->id->cellAttributes() ?>>
			<span id="el_barcode_query_id">
<input type="text" data-table="barcode_query" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($barcode_query->id->getPlaceHolder()) ?>" value="<?php echo $barcode_query->id->EditValue ?>"<?php echo $barcode_query->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_pl_no"><?php echo $barcode_query->pl_no->caption() ?></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->pl_no->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pl_no" id="z_pl_no" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($barcode_query->pl_no->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_barcode_query_pl_no">
<input type="text" data-table="barcode_query" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($barcode_query->pl_no->getPlaceHolder()) ?>" value="<?php echo $barcode_query->pl_no->EditValue ?>"<?php echo $barcode_query->pl_no->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pl_no d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_barcode_query_pl_no" class="btw1_pl_no d-none">
<input type="text" data-table="barcode_query" data-field="x_pl_no" name="y_pl_no" id="y_pl_no" size="30" placeholder="<?php echo HtmlEncode($barcode_query->pl_no->getPlaceHolder()) ?>" value="<?php echo $barcode_query->pl_no->EditValue2 ?>"<?php echo $barcode_query->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_po"><?php echo $barcode_query->po->caption() ?></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($barcode_query->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_barcode_query_po">
<input type="text" data-table="barcode_query" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($barcode_query->po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po->EditValue ?>"<?php echo $barcode_query->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_barcode_query_po" class="btw1_po d-none">
<input type="text" data-table="barcode_query" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($barcode_query->po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po->EditValue2 ?>"<?php echo $barcode_query->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query__barcode"><?php echo $barcode_query->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($barcode_query->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_barcode_query__barcode">
<input type="text" data-table="barcode_query" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_query->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_query->_barcode->EditValue ?>"<?php echo $barcode_query->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_barcode_query__barcode" class="btw1__barcode d-none">
<input type="text" data-table="barcode_query" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($barcode_query->_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_query->_barcode->EditValue2 ?>"<?php echo $barcode_query->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_buyers_id"><?php echo $barcode_query->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->buyers_id->cellAttributes() ?>>
			<span id="el_barcode_query_buyers_id">
<?php $barcode_query->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$barcode_query->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_buyers_id" data-value-separator="<?php echo $barcode_query->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $barcode_query->buyers_id->editAttributes() ?>>
		<?php echo $barcode_query->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $barcode_query->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_buyer_ref"><?php echo $barcode_query->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_ref->cellAttributes() ?>>
			<span id="el_barcode_query_buyer_ref">
<?php
$wrkonchange = "" . trim(@$barcode_query->buyer_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$barcode_query->buyer_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_ref" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?php echo RemoveHtml($barcode_query->buyer_ref->EditValue) ?>" placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>"<?php echo $barcode_query->buyer_ref->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->buyer_ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_ref',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->buyer_ref->ReadOnly || $barcode_query->buyer_ref->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyer_ref" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($barcode_query->buyer_ref->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbarcode_querysearch.createAutoSuggest({"id":"x_buyer_ref","forceSelect":false});
</script>
<?php echo $barcode_query->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_barcode->Visible) { // buyer_barcode ?>
	<div id="r_buyer_barcode" class="form-group row">
		<label for="x_buyer_barcode" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_buyer_barcode"><?php echo $barcode_query->buyer_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_barcode" id="z_buyer_barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_barcode->cellAttributes() ?>>
			<span id="el_barcode_query_buyer_barcode">
<input type="text" data-table="barcode_query" data-field="x_buyer_barcode" name="x_buyer_barcode" id="x_buyer_barcode" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($barcode_query->buyer_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_query->buyer_barcode->EditValue ?>"<?php echo $barcode_query->buyer_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_design_id"><?php echo $barcode_query->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->design_id->cellAttributes() ?>>
			<span id="el_barcode_query_design_id">
<?php $barcode_query->design_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$barcode_query->design_id->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_design_id"><?php echo strval($barcode_query->design_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($barcode_query->design_id->AdvancedSearch->ViewValue) : $barcode_query->design_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->design_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->design_id->ReadOnly || $barcode_query->design_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_design_id',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $barcode_query->design_id->Lookup->getParamTag("p_x_design_id") ?>
<input type="hidden" data-table="barcode_query" data-field="x_design_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->design_id->displayValueSeparatorAttribute() ?>" name="x_design_id" id="x_design_id" value="<?php echo $barcode_query->design_id->AdvancedSearch->SearchValue ?>"<?php echo $barcode_query->design_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_batch_no"><?php echo $barcode_query->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->batch_no->cellAttributes() ?>>
			<span id="el_barcode_query_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_batch_no" data-value-separator="<?php echo $barcode_query->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $barcode_query->batch_no->editAttributes() ?>>
		<?php echo $barcode_query->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $barcode_query->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_category"><?php echo $barcode_query->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->category->cellAttributes() ?>>
			<span id="el_barcode_query_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_category" data-value-separator="<?php echo $barcode_query->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $barcode_query->category->editAttributes() ?>>
		<?php echo $barcode_query->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $barcode_query->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_size_cm"><?php echo $barcode_query->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->size_cm->cellAttributes() ?>>
			<span id="el_barcode_query_size_cm">
<input type="text" data-table="barcode_query" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($barcode_query->size_cm->getPlaceHolder()) ?>" value="<?php echo $barcode_query->size_cm->EditValue ?>"<?php echo $barcode_query->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_size_buyer"><?php echo $barcode_query->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->size_buyer->cellAttributes() ?>>
			<span id="el_barcode_query_size_buyer">
<input type="text" data-table="barcode_query" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($barcode_query->size_buyer->getPlaceHolder()) ?>" value="<?php echo $barcode_query->size_buyer->EditValue ?>"<?php echo $barcode_query->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_order_date"><?php echo $barcode_query->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->order_date->cellAttributes() ?>>
			<span id="el_barcode_query_order_date">
<input type="text" data-table="barcode_query" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($barcode_query->order_date->getPlaceHolder()) ?>" value="<?php echo $barcode_query->order_date->EditValue ?>"<?php echo $barcode_query->order_date->editAttributes() ?>>
<?php if (!$barcode_query->order_date->ReadOnly && !$barcode_query->order_date->Disabled && !isset($barcode_query->order_date->EditAttrs["readonly"]) && !isset($barcode_query->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbarcode_querysearch", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_despatch_week"><?php echo $barcode_query->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->despatch_week->cellAttributes() ?>>
			<span id="el_barcode_query_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_despatch_week" data-value-separator="<?php echo $barcode_query->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $barcode_query->despatch_week->editAttributes() ?>>
		<?php echo $barcode_query->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $barcode_query->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_sqm"><?php echo $barcode_query->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->sqm->cellAttributes() ?>>
			<span id="el_barcode_query_sqm">
<input type="text" data-table="barcode_query" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($barcode_query->sqm->getPlaceHolder()) ?>" value="<?php echo $barcode_query->sqm->EditValue ?>"<?php echo $barcode_query->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_remarks"><?php echo $barcode_query->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->remarks->cellAttributes() ?>>
			<span id="el_barcode_query_remarks">
<input type="text" data-table="barcode_query" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($barcode_query->remarks->getPlaceHolder()) ?>" value="<?php echo $barcode_query->remarks->EditValue ?>"<?php echo $barcode_query->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_buyer_po"><?php echo $barcode_query->buyer_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_po->cellAttributes() ?>>
			<span id="el_barcode_query_buyer_po">
<input type="text" data-table="barcode_query" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($barcode_query->buyer_po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->buyer_po->EditValue ?>"<?php echo $barcode_query->buyer_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label for="x_po_price" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_po_price"><?php echo $barcode_query->po_price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_price" id="z_po_price" value="LIKE"></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->po_price->cellAttributes() ?>>
			<span id="el_barcode_query_po_price">
<input type="text" data-table="barcode_query" data-field="x_po_price" name="x_po_price" id="x_po_price" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($barcode_query->po_price->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po_price->EditValue ?>"<?php echo $barcode_query->po_price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_discount->Visible) { // po_discount ?>
	<div id="r_po_discount" class="form-group row">
		<label for="x_po_discount" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_po_discount"><?php echo $barcode_query->po_discount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_discount" id="z_po_discount" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->po_discount->cellAttributes() ?>>
			<span id="el_barcode_query_po_discount">
<input type="text" data-table="barcode_query" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" size="30" placeholder="<?php echo HtmlEncode($barcode_query->po_discount->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po_discount->EditValue ?>"<?php echo $barcode_query->po_discount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_currency->Visible) { // po_currency ?>
	<div id="r_po_currency" class="form-group row">
		<label for="x_po_currency" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_po_currency"><?php echo $barcode_query->po_currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_currency" id="z_po_currency" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->po_currency->cellAttributes() ?>>
			<span id="el_barcode_query_po_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_po_currency" data-value-separator="<?php echo $barcode_query->po_currency->displayValueSeparatorAttribute() ?>" id="x_po_currency" name="x_po_currency"<?php echo $barcode_query->po_currency->editAttributes() ?>>
		<?php echo $barcode_query->po_currency->selectOptionListHtml("x_po_currency") ?>
	</select>
</div>
<?php echo $barcode_query->po_currency->Lookup->getParamTag("p_x_po_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_weaving_works"><?php echo $barcode_query->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->weaving_works->cellAttributes() ?>>
			<span id="el_barcode_query_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_weaving_works" data-value-separator="<?php echo $barcode_query->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $barcode_query->weaving_works->editAttributes() ?>>
		<?php echo $barcode_query->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $barcode_query->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_current_works"><?php echo $barcode_query->current_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->current_works->cellAttributes() ?>>
			<span id="el_barcode_query_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_current_works" data-value-separator="<?php echo $barcode_query->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $barcode_query->current_works->editAttributes() ?>>
		<?php echo $barcode_query->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $barcode_query->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->consignee->Visible) { // consignee ?>
	<div id="r_consignee" class="form-group row">
		<label for="x_consignee" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_consignee"><?php echo $barcode_query->consignee->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_consignee" id="z_consignee" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->consignee->cellAttributes() ?>>
			<span id="el_barcode_query_consignee">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_consignee" data-value-separator="<?php echo $barcode_query->consignee->displayValueSeparatorAttribute() ?>" id="x_consignee" name="x_consignee"<?php echo $barcode_query->consignee->editAttributes() ?>>
		<?php echo $barcode_query->consignee->selectOptionListHtml("x_consignee") ?>
	</select>
</div>
<?php echo $barcode_query->consignee->Lookup->getParamTag("p_x_consignee") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_jc_no"><?php echo $barcode_query->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->jc_no->cellAttributes() ?>>
			<span id="el_barcode_query_jc_no">
<input type="text" data-table="barcode_query" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($barcode_query->jc_no->getPlaceHolder()) ?>" value="<?php echo $barcode_query->jc_no->EditValue ?>"<?php echo $barcode_query->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_operator"><?php echo $barcode_query->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->operator->cellAttributes() ?>>
			<span id="el_barcode_query_operator">
<input type="text" data-table="barcode_query" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($barcode_query->operator->getPlaceHolder()) ?>" value="<?php echo $barcode_query->operator->EditValue ?>"<?php echo $barcode_query->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_datetime"><?php echo $barcode_query->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->datetime->cellAttributes() ?>>
			<span id="el_barcode_query_datetime">
<input type="text" data-table="barcode_query" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($barcode_query->datetime->getPlaceHolder()) ?>" value="<?php echo $barcode_query->datetime->EditValue ?>"<?php echo $barcode_query->datetime->editAttributes() ?>>
<?php if (!$barcode_query->datetime->ReadOnly && !$barcode_query->datetime->Disabled && !isset($barcode_query->datetime->EditAttrs["readonly"]) && !isset($barcode_query->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbarcode_querysearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label for="x_completed" class="<?php echo $barcode_query_search->LeftColumnClass ?>"><span id="elh_barcode_query_completed"><?php echo $barcode_query->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_completed" id="z_completed" value="="></span>
		</label>
		<div class="<?php echo $barcode_query_search->RightColumnClass ?>"><div<?php echo $barcode_query->completed->cellAttributes() ?>>
			<span id="el_barcode_query_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_completed" data-value-separator="<?php echo $barcode_query->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $barcode_query->completed->editAttributes() ?>>
		<?php echo $barcode_query->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$barcode_query_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $barcode_query_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$barcode_query_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$barcode_query_search->terminate();
?>