<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$barcode_query_update = new barcode_query_update();

// Run the page
$barcode_query_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barcode_query_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fbarcode_queryupdate = currentForm = new ew.Form("fbarcode_queryupdate", "update");

// Validate form
fbarcode_queryupdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($barcode_query_update->buyers_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyers_id");
			uelm = this.getElements("u" + infix + "_buyers_id");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyers_id->caption(), $barcode_query->buyers_id->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->buyer_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_ref");
			uelm = this.getElements("u" + infix + "_buyer_ref");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyer_ref->caption(), $barcode_query->buyer_ref->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->buyer_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_barcode");
			uelm = this.getElements("u" + infix + "_buyer_barcode");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyer_barcode->caption(), $barcode_query->buyer_barcode->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			uelm = this.getElements("u" + infix + "_design_id");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->design_id->caption(), $barcode_query->design_id->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			uelm = this.getElements("u" + infix + "_batch_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->batch_no->caption(), $barcode_query->batch_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			uelm = this.getElements("u" + infix + "_category");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->category->caption(), $barcode_query->category->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_order_date");
			uelm = this.getElements("u" + infix + "_order_date");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->order_date->caption(), $barcode_query->order_date->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_date");
			uelm = this.getElements("u" + infix + "_order_date");
			if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($barcode_query->order_date->errorMessage()) ?>");
		<?php if ($barcode_query_update->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			uelm = this.getElements("u" + infix + "_despatch_week");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->despatch_week->caption(), $barcode_query->despatch_week->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->buyer_po->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_po");
			uelm = this.getElements("u" + infix + "_buyer_po");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->buyer_po->caption(), $barcode_query->buyer_po->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->po_price->Required) { ?>
			elm = this.getElements("x" + infix + "_po_price");
			uelm = this.getElements("u" + infix + "_po_price");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->po_price->caption(), $barcode_query->po_price->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->po_discount->Required) { ?>
			elm = this.getElements("x" + infix + "_po_discount");
			uelm = this.getElements("u" + infix + "_po_discount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->po_discount->caption(), $barcode_query->po_discount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_discount");
			uelm = this.getElements("u" + infix + "_po_discount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($barcode_query->po_discount->errorMessage()) ?>");
		<?php if ($barcode_query_update->po_currency->Required) { ?>
			elm = this.getElements("x" + infix + "_po_currency");
			uelm = this.getElements("u" + infix + "_po_currency");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->po_currency->caption(), $barcode_query->po_currency->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			uelm = this.getElements("u" + infix + "_weaving_works");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->weaving_works->caption(), $barcode_query->weaving_works->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->consignee->Required) { ?>
			elm = this.getElements("x" + infix + "_consignee");
			uelm = this.getElements("u" + infix + "_consignee");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->consignee->caption(), $barcode_query->consignee->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			uelm = this.getElements("u" + infix + "_jc_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->jc_no->caption(), $barcode_query->jc_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($barcode_query_update->completed->Required) { ?>
			elm = this.getElements("x" + infix + "_completed");
			uelm = this.getElements("u" + infix + "_completed");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $barcode_query->completed->caption(), $barcode_query->completed->RequiredErrorMessage)) ?>");
			}
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbarcode_queryupdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_queryupdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_queryupdate.lists["x_buyers_id"] = <?php echo $barcode_query_update->buyers_id->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_query_update->buyers_id->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_buyer_ref"] = <?php echo $barcode_query_update->buyer_ref->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_query_update->buyer_ref->lookupOptions()) ?>;
fbarcode_queryupdate.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbarcode_queryupdate.lists["x_design_id"] = <?php echo $barcode_query_update->design_id->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_design_id"].options = <?php echo JsonEncode($barcode_query_update->design_id->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_batch_no"] = <?php echo $barcode_query_update->batch_no->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_batch_no"].options = <?php echo JsonEncode($barcode_query_update->batch_no->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_category"] = <?php echo $barcode_query_update->category->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_category"].options = <?php echo JsonEncode($barcode_query_update->category->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_despatch_week"] = <?php echo $barcode_query_update->despatch_week->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_despatch_week"].options = <?php echo JsonEncode($barcode_query_update->despatch_week->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_po_currency"] = <?php echo $barcode_query_update->po_currency->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_po_currency"].options = <?php echo JsonEncode($barcode_query_update->po_currency->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_weaving_works"] = <?php echo $barcode_query_update->weaving_works->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_weaving_works"].options = <?php echo JsonEncode($barcode_query_update->weaving_works->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_consignee"] = <?php echo $barcode_query_update->consignee->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_consignee"].options = <?php echo JsonEncode($barcode_query_update->consignee->lookupOptions()) ?>;
fbarcode_queryupdate.lists["x_completed"] = <?php echo $barcode_query_update->completed->Lookup->toClientList() ?>;
fbarcode_queryupdate.lists["x_completed"].options = <?php echo JsonEncode($barcode_query_update->completed->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $barcode_query_update->showPageHeader(); ?>
<?php
$barcode_query_update->showMessage();
?>
<form name="fbarcode_queryupdate" id="fbarcode_queryupdate" class="<?php echo $barcode_query_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($barcode_query_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $barcode_query_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<?php if ($barcode_query->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$barcode_query_update->IsModal ?>">
<?php foreach ($barcode_query_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_barcode_queryupdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $barcode_query_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($barcode_query->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_buyers_id" id="u_buyers_id" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->buyers_id->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_buyers_id" id="u_buyers_id" value="<?php echo $barcode_query->buyers_id->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->buyers_id->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_buyers_id"><?php echo $barcode_query->buyers_id->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->buyers_id->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_buyers_id">
<?php $barcode_query->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$barcode_query->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_buyers_id" data-value-separator="<?php echo $barcode_query->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $barcode_query->buyers_id->editAttributes() ?>>
		<?php echo $barcode_query->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $barcode_query->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_buyers_id">
<span<?php echo $barcode_query->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($barcode_query->buyers_id->ViewValue)) && $barcode_query->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $barcode_query->buyers_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->buyers_id->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->buyers_id->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyers_id" name="x_buyers_id" id="x_buyers_id" value="<?php echo HtmlEncode($barcode_query->buyers_id->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->buyers_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_buyer_ref" id="u_buyer_ref" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->buyer_ref->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_buyer_ref" id="u_buyer_ref" value="<?php echo $barcode_query->buyer_ref->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->buyer_ref->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_buyer_ref"><?php echo $barcode_query->buyer_ref->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_ref->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_buyer_ref">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$barcode_query->buyer_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$barcode_query->buyer_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_ref" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?php echo RemoveHtml($barcode_query->buyer_ref->EditValue) ?>" placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($barcode_query->buyer_ref->getPlaceHolder()) ?>"<?php echo $barcode_query->buyer_ref->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->buyer_ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_ref',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->buyer_ref->ReadOnly || $barcode_query->buyer_ref->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyer_ref" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($barcode_query->buyer_ref->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbarcode_queryupdate.createAutoSuggest({"id":"x_buyer_ref","forceSelect":true});
</script>
<?php echo $barcode_query->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_buyer_ref">
<span<?php echo $barcode_query->buyer_ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->buyer_ref->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($barcode_query->buyer_ref->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->buyer_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_barcode->Visible) { // buyer_barcode ?>
	<div id="r_buyer_barcode" class="form-group row">
		<label for="x_buyer_barcode" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_buyer_barcode" id="u_buyer_barcode" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->buyer_barcode->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_buyer_barcode" id="u_buyer_barcode" value="<?php echo $barcode_query->buyer_barcode->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->buyer_barcode->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_buyer_barcode"><?php echo $barcode_query->buyer_barcode->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_barcode->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_buyer_barcode">
<input type="text" data-table="barcode_query" data-field="x_buyer_barcode" name="x_buyer_barcode" id="x_buyer_barcode" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($barcode_query->buyer_barcode->getPlaceHolder()) ?>" value="<?php echo $barcode_query->buyer_barcode->EditValue ?>"<?php echo $barcode_query->buyer_barcode->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_barcode_query_buyer_barcode">
<span<?php echo $barcode_query->buyer_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->buyer_barcode->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyer_barcode" name="x_buyer_barcode" id="x_buyer_barcode" value="<?php echo HtmlEncode($barcode_query->buyer_barcode->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->buyer_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_design_id" id="u_design_id" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->design_id->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_design_id" id="u_design_id" value="<?php echo $barcode_query->design_id->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->design_id->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_design_id"><?php echo $barcode_query->design_id->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->design_id->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_design_id">
<?php $barcode_query->design_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$barcode_query->design_id->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_design_id"><?php echo strval($barcode_query->design_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($barcode_query->design_id->ViewValue) : $barcode_query->design_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($barcode_query->design_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($barcode_query->design_id->ReadOnly || $barcode_query->design_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_design_id',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $barcode_query->design_id->Lookup->getParamTag("p_x_design_id") ?>
<input type="hidden" data-table="barcode_query" data-field="x_design_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $barcode_query->design_id->displayValueSeparatorAttribute() ?>" name="x_design_id" id="x_design_id" value="<?php echo $barcode_query->design_id->CurrentValue ?>"<?php echo $barcode_query->design_id->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_barcode_query_design_id">
<span<?php echo $barcode_query->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($barcode_query->design_id->ViewValue)) && $barcode_query->design_id->linkAttributes() <> "") { ?>
<a<?php echo $barcode_query->design_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->design_id->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->design_id->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_design_id" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($barcode_query->design_id->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->design_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_batch_no" id="u_batch_no" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->batch_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_batch_no" id="u_batch_no" value="<?php echo $barcode_query->batch_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->batch_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_batch_no"><?php echo $barcode_query->batch_no->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->batch_no->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_batch_no" data-value-separator="<?php echo $barcode_query->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $barcode_query->batch_no->editAttributes() ?>>
		<?php echo $barcode_query->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $barcode_query->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_batch_no">
<span<?php echo $barcode_query->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->batch_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" value="<?php echo HtmlEncode($barcode_query->batch_no->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_category" id="u_category" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->category->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_category" id="u_category" value="<?php echo $barcode_query->category->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->category->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_category"><?php echo $barcode_query->category->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->category->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_category" data-value-separator="<?php echo $barcode_query->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $barcode_query->category->editAttributes() ?>>
		<?php echo $barcode_query->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $barcode_query->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_category">
<span<?php echo $barcode_query->category->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->category->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_category" name="x_category" id="x_category" value="<?php echo HtmlEncode($barcode_query->category->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_order_date" id="u_order_date" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->order_date->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_order_date" id="u_order_date" value="<?php echo $barcode_query->order_date->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->order_date->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_order_date"><?php echo $barcode_query->order_date->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->order_date->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_order_date">
<input type="text" data-table="barcode_query" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($barcode_query->order_date->getPlaceHolder()) ?>" value="<?php echo $barcode_query->order_date->EditValue ?>"<?php echo $barcode_query->order_date->editAttributes() ?>>
<?php if (!$barcode_query->order_date->ReadOnly && !$barcode_query->order_date->Disabled && !isset($barcode_query->order_date->EditAttrs["readonly"]) && !isset($barcode_query->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbarcode_queryupdate", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_order_date">
<span<?php echo $barcode_query->order_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->order_date->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_order_date" name="x_order_date" id="x_order_date" value="<?php echo HtmlEncode($barcode_query->order_date->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_despatch_week" id="u_despatch_week" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->despatch_week->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_despatch_week" id="u_despatch_week" value="<?php echo $barcode_query->despatch_week->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->despatch_week->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_despatch_week"><?php echo $barcode_query->despatch_week->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->despatch_week->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_despatch_week" data-value-separator="<?php echo $barcode_query->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $barcode_query->despatch_week->editAttributes() ?>>
		<?php echo $barcode_query->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $barcode_query->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_despatch_week">
<span<?php echo $barcode_query->despatch_week->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->despatch_week->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_despatch_week" name="x_despatch_week" id="x_despatch_week" value="<?php echo HtmlEncode($barcode_query->despatch_week->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_buyer_po" id="u_buyer_po" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->buyer_po->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_buyer_po" id="u_buyer_po" value="<?php echo $barcode_query->buyer_po->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->buyer_po->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_buyer_po"><?php echo $barcode_query->buyer_po->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->buyer_po->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_buyer_po">
<input type="text" data-table="barcode_query" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($barcode_query->buyer_po->getPlaceHolder()) ?>" value="<?php echo $barcode_query->buyer_po->EditValue ?>"<?php echo $barcode_query->buyer_po->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_barcode_query_buyer_po">
<span<?php echo $barcode_query->buyer_po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->buyer_po->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" value="<?php echo HtmlEncode($barcode_query->buyer_po->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->buyer_po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label for="x_po_price" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_po_price" id="u_po_price" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->po_price->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_po_price" id="u_po_price" value="<?php echo $barcode_query->po_price->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->po_price->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_po_price"><?php echo $barcode_query->po_price->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->po_price->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_po_price">
<input type="text" data-table="barcode_query" data-field="x_po_price" name="x_po_price" id="x_po_price" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($barcode_query->po_price->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po_price->EditValue ?>"<?php echo $barcode_query->po_price->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_barcode_query_po_price">
<span<?php echo $barcode_query->po_price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->po_price->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_po_price" name="x_po_price" id="x_po_price" value="<?php echo HtmlEncode($barcode_query->po_price->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->po_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_discount->Visible) { // po_discount ?>
	<div id="r_po_discount" class="form-group row">
		<label for="x_po_discount" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_po_discount" id="u_po_discount" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->po_discount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_po_discount" id="u_po_discount" value="<?php echo $barcode_query->po_discount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->po_discount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_po_discount"><?php echo $barcode_query->po_discount->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->po_discount->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_po_discount">
<input type="text" data-table="barcode_query" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" size="30" placeholder="<?php echo HtmlEncode($barcode_query->po_discount->getPlaceHolder()) ?>" value="<?php echo $barcode_query->po_discount->EditValue ?>"<?php echo $barcode_query->po_discount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_barcode_query_po_discount">
<span<?php echo $barcode_query->po_discount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->po_discount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" value="<?php echo HtmlEncode($barcode_query->po_discount->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->po_discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->po_currency->Visible) { // po_currency ?>
	<div id="r_po_currency" class="form-group row">
		<label for="x_po_currency" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_po_currency" id="u_po_currency" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->po_currency->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_po_currency" id="u_po_currency" value="<?php echo $barcode_query->po_currency->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->po_currency->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_po_currency"><?php echo $barcode_query->po_currency->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->po_currency->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_po_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_po_currency" data-value-separator="<?php echo $barcode_query->po_currency->displayValueSeparatorAttribute() ?>" id="x_po_currency" name="x_po_currency"<?php echo $barcode_query->po_currency->editAttributes() ?>>
		<?php echo $barcode_query->po_currency->selectOptionListHtml("x_po_currency") ?>
	</select>
</div>
<?php echo $barcode_query->po_currency->Lookup->getParamTag("p_x_po_currency") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_po_currency">
<span<?php echo $barcode_query->po_currency->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->po_currency->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_po_currency" name="x_po_currency" id="x_po_currency" value="<?php echo HtmlEncode($barcode_query->po_currency->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->po_currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_weaving_works" id="u_weaving_works" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->weaving_works->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_weaving_works" id="u_weaving_works" value="<?php echo $barcode_query->weaving_works->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->weaving_works->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_weaving_works"><?php echo $barcode_query->weaving_works->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->weaving_works->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_weaving_works" data-value-separator="<?php echo $barcode_query->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $barcode_query->weaving_works->editAttributes() ?>>
		<?php echo $barcode_query->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $barcode_query->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_weaving_works">
<span<?php echo $barcode_query->weaving_works->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->weaving_works->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_weaving_works" name="x_weaving_works" id="x_weaving_works" value="<?php echo HtmlEncode($barcode_query->weaving_works->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->weaving_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->consignee->Visible) { // consignee ?>
	<div id="r_consignee" class="form-group row">
		<label for="x_consignee" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_consignee" id="u_consignee" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->consignee->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_consignee" id="u_consignee" value="<?php echo $barcode_query->consignee->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->consignee->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_consignee"><?php echo $barcode_query->consignee->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->consignee->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_consignee">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_consignee" data-value-separator="<?php echo $barcode_query->consignee->displayValueSeparatorAttribute() ?>" id="x_consignee" name="x_consignee"<?php echo $barcode_query->consignee->editAttributes() ?>>
		<?php echo $barcode_query->consignee->selectOptionListHtml("x_consignee") ?>
	</select>
</div>
<?php echo $barcode_query->consignee->Lookup->getParamTag("p_x_consignee") ?>
</span>
<?php } else { ?>
<span id="el_barcode_query_consignee">
<span<?php echo $barcode_query->consignee->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->consignee->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_consignee" name="x_consignee" id="x_consignee" value="<?php echo HtmlEncode($barcode_query->consignee->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->consignee->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($barcode_query->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label for="x_completed" class="<?php echo $barcode_query_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$barcode_query->isConfirm()) { ?>
<input type="checkbox" name="u_completed" id="u_completed" class="form-check-input ew-multi-select" value="1"<?php echo ($barcode_query->completed->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_completed" id="u_completed" value="<?php echo $barcode_query->completed->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($barcode_query->completed->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_completed"><?php echo $barcode_query->completed->caption() ?></label></div></label>
		<div class="<?php echo $barcode_query_update->RightColumnClass ?>"><div<?php echo $barcode_query->completed->cellAttributes() ?>>
<?php if (!$barcode_query->isConfirm()) { ?>
<span id="el_barcode_query_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="barcode_query" data-field="x_completed" data-value-separator="<?php echo $barcode_query->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $barcode_query->completed->editAttributes() ?>>
		<?php echo $barcode_query->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_barcode_query_completed">
<span<?php echo $barcode_query->completed->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($barcode_query->completed->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="barcode_query" data-field="x_completed" name="x_completed" id="x_completed" value="<?php echo HtmlEncode($barcode_query->completed->FormValue) ?>">
<?php } ?>
<?php echo $barcode_query->completed->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$barcode_query_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $barcode_query_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$barcode_query->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $barcode_query_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$barcode_query_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$barcode_query_update->terminate();
?>