<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$barcode_query_view = new barcode_query_view();

// Run the page
$barcode_query_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barcode_query_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$barcode_query->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbarcode_queryview = currentForm = new ew.Form("fbarcode_queryview", "view");

// Form_CustomValidate event
fbarcode_queryview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbarcode_queryview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbarcode_queryview.lists["x_buyers_id"] = <?php echo $barcode_query_view->buyers_id->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_buyers_id"].options = <?php echo JsonEncode($barcode_query_view->buyers_id->lookupOptions()) ?>;
fbarcode_queryview.lists["x_buyer_ref"] = <?php echo $barcode_query_view->buyer_ref->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_buyer_ref"].options = <?php echo JsonEncode($barcode_query_view->buyer_ref->lookupOptions()) ?>;
fbarcode_queryview.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbarcode_queryview.lists["x_design_id"] = <?php echo $barcode_query_view->design_id->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_design_id"].options = <?php echo JsonEncode($barcode_query_view->design_id->lookupOptions()) ?>;
fbarcode_queryview.lists["x_batch_no"] = <?php echo $barcode_query_view->batch_no->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_batch_no"].options = <?php echo JsonEncode($barcode_query_view->batch_no->lookupOptions()) ?>;
fbarcode_queryview.lists["x_category"] = <?php echo $barcode_query_view->category->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_category"].options = <?php echo JsonEncode($barcode_query_view->category->lookupOptions()) ?>;
fbarcode_queryview.lists["x_despatch_week"] = <?php echo $barcode_query_view->despatch_week->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_despatch_week"].options = <?php echo JsonEncode($barcode_query_view->despatch_week->lookupOptions()) ?>;
fbarcode_queryview.lists["x_po_currency"] = <?php echo $barcode_query_view->po_currency->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_po_currency"].options = <?php echo JsonEncode($barcode_query_view->po_currency->lookupOptions()) ?>;
fbarcode_queryview.lists["x_weaving_works"] = <?php echo $barcode_query_view->weaving_works->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_weaving_works"].options = <?php echo JsonEncode($barcode_query_view->weaving_works->lookupOptions()) ?>;
fbarcode_queryview.lists["x_current_works"] = <?php echo $barcode_query_view->current_works->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_current_works"].options = <?php echo JsonEncode($barcode_query_view->current_works->lookupOptions()) ?>;
fbarcode_queryview.lists["x_consignee"] = <?php echo $barcode_query_view->consignee->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_consignee"].options = <?php echo JsonEncode($barcode_query_view->consignee->lookupOptions()) ?>;
fbarcode_queryview.lists["x_completed"] = <?php echo $barcode_query_view->completed->Lookup->toClientList() ?>;
fbarcode_queryview.lists["x_completed"].options = <?php echo JsonEncode($barcode_query_view->completed->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$barcode_query->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $barcode_query_view->ExportOptions->render("body") ?>
<?php $barcode_query_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $barcode_query_view->showPageHeader(); ?>
<?php
$barcode_query_view->showMessage();
?>
<form name="fbarcode_queryview" id="fbarcode_queryview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($barcode_query_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $barcode_query_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<input type="hidden" name="modal" value="<?php echo (int)$barcode_query_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($barcode_query->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_id"><?php echo $barcode_query->id->caption() ?></span></td>
		<td data-name="id"<?php echo $barcode_query->id->cellAttributes() ?>>
<span id="el_barcode_query_id">
<span<?php echo $barcode_query->id->viewAttributes() ?>>
<?php echo $barcode_query->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->pl_no->Visible) { // pl_no ?>
	<tr id="r_pl_no">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_pl_no"><?php echo $barcode_query->pl_no->caption() ?></span></td>
		<td data-name="pl_no"<?php echo $barcode_query->pl_no->cellAttributes() ?>>
<span id="el_barcode_query_pl_no">
<span<?php echo $barcode_query->pl_no->viewAttributes() ?>>
<?php echo $barcode_query->pl_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_po"><?php echo $barcode_query->po->caption() ?></span></td>
		<td data-name="po"<?php echo $barcode_query->po->cellAttributes() ?>>
<span id="el_barcode_query_po">
<span<?php echo $barcode_query->po->viewAttributes() ?>>
<?php echo $barcode_query->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query__barcode"><?php echo $barcode_query->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $barcode_query->_barcode->cellAttributes() ?>>
<span id="el_barcode_query__barcode">
<span<?php echo $barcode_query->_barcode->viewAttributes() ?>>
<?php echo $barcode_query->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->buyers_id->Visible) { // buyers_id ?>
	<tr id="r_buyers_id">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_buyers_id"><?php echo $barcode_query->buyers_id->caption() ?></span></td>
		<td data-name="buyers_id"<?php echo $barcode_query->buyers_id->cellAttributes() ?>>
<span id="el_barcode_query_buyers_id">
<span<?php echo $barcode_query->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($barcode_query->buyers_id->getViewValue())) && $barcode_query->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $barcode_query->buyers_id->linkAttributes() ?>><?php echo $barcode_query->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $barcode_query->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_buyer_ref"><?php echo $barcode_query->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $barcode_query->buyer_ref->cellAttributes() ?>>
<span id="el_barcode_query_buyer_ref">
<span<?php echo $barcode_query->buyer_ref->viewAttributes() ?>>
<?php echo $barcode_query->buyer_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->buyer_barcode->Visible) { // buyer_barcode ?>
	<tr id="r_buyer_barcode">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_buyer_barcode"><?php echo $barcode_query->buyer_barcode->caption() ?></span></td>
		<td data-name="buyer_barcode"<?php echo $barcode_query->buyer_barcode->cellAttributes() ?>>
<span id="el_barcode_query_buyer_barcode">
<span<?php echo $barcode_query->buyer_barcode->viewAttributes() ?>>
<?php echo $barcode_query->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_design_id"><?php echo $barcode_query->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $barcode_query->design_id->cellAttributes() ?>>
<span id="el_barcode_query_design_id">
<span<?php echo $barcode_query->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($barcode_query->design_id->getViewValue())) && $barcode_query->design_id->linkAttributes() <> "") { ?>
<a<?php echo $barcode_query->design_id->linkAttributes() ?>><?php echo $barcode_query->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $barcode_query->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_batch_no"><?php echo $barcode_query->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $barcode_query->batch_no->cellAttributes() ?>>
<span id="el_barcode_query_batch_no">
<span<?php echo $barcode_query->batch_no->viewAttributes() ?>>
<?php echo $barcode_query->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_category"><?php echo $barcode_query->category->caption() ?></span></td>
		<td data-name="category"<?php echo $barcode_query->category->cellAttributes() ?>>
<span id="el_barcode_query_category">
<span<?php echo $barcode_query->category->viewAttributes() ?>>
<?php echo $barcode_query->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->size_cm->Visible) { // size_cm ?>
	<tr id="r_size_cm">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_size_cm"><?php echo $barcode_query->size_cm->caption() ?></span></td>
		<td data-name="size_cm"<?php echo $barcode_query->size_cm->cellAttributes() ?>>
<span id="el_barcode_query_size_cm">
<span<?php echo $barcode_query->size_cm->viewAttributes() ?>>
<?php echo $barcode_query->size_cm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->size_buyer->Visible) { // size_buyer ?>
	<tr id="r_size_buyer">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_size_buyer"><?php echo $barcode_query->size_buyer->caption() ?></span></td>
		<td data-name="size_buyer"<?php echo $barcode_query->size_buyer->cellAttributes() ?>>
<span id="el_barcode_query_size_buyer">
<span<?php echo $barcode_query->size_buyer->viewAttributes() ?>>
<?php echo $barcode_query->size_buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->order_date->Visible) { // order_date ?>
	<tr id="r_order_date">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_order_date"><?php echo $barcode_query->order_date->caption() ?></span></td>
		<td data-name="order_date"<?php echo $barcode_query->order_date->cellAttributes() ?>>
<span id="el_barcode_query_order_date">
<span<?php echo $barcode_query->order_date->viewAttributes() ?>>
<?php echo $barcode_query->order_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->despatch_week->Visible) { // despatch_week ?>
	<tr id="r_despatch_week">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_despatch_week"><?php echo $barcode_query->despatch_week->caption() ?></span></td>
		<td data-name="despatch_week"<?php echo $barcode_query->despatch_week->cellAttributes() ?>>
<span id="el_barcode_query_despatch_week">
<span<?php echo $barcode_query->despatch_week->viewAttributes() ?>>
<?php echo $barcode_query->despatch_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_sqm"><?php echo $barcode_query->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $barcode_query->sqm->cellAttributes() ?>>
<span id="el_barcode_query_sqm">
<span<?php echo $barcode_query->sqm->viewAttributes() ?>>
<?php echo $barcode_query->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_remarks"><?php echo $barcode_query->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $barcode_query->remarks->cellAttributes() ?>>
<span id="el_barcode_query_remarks">
<span<?php echo $barcode_query->remarks->viewAttributes() ?>>
<?php echo $barcode_query->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->buyer_po->Visible) { // buyer_po ?>
	<tr id="r_buyer_po">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_buyer_po"><?php echo $barcode_query->buyer_po->caption() ?></span></td>
		<td data-name="buyer_po"<?php echo $barcode_query->buyer_po->cellAttributes() ?>>
<span id="el_barcode_query_buyer_po">
<span<?php echo $barcode_query->buyer_po->viewAttributes() ?>>
<?php echo $barcode_query->buyer_po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->po_price->Visible) { // po_price ?>
	<tr id="r_po_price">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_po_price"><?php echo $barcode_query->po_price->caption() ?></span></td>
		<td data-name="po_price"<?php echo $barcode_query->po_price->cellAttributes() ?>>
<span id="el_barcode_query_po_price">
<span<?php echo $barcode_query->po_price->viewAttributes() ?>>
<?php echo $barcode_query->po_price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->po_discount->Visible) { // po_discount ?>
	<tr id="r_po_discount">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_po_discount"><?php echo $barcode_query->po_discount->caption() ?></span></td>
		<td data-name="po_discount"<?php echo $barcode_query->po_discount->cellAttributes() ?>>
<span id="el_barcode_query_po_discount">
<span<?php echo $barcode_query->po_discount->viewAttributes() ?>>
<?php echo $barcode_query->po_discount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->po_currency->Visible) { // po_currency ?>
	<tr id="r_po_currency">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_po_currency"><?php echo $barcode_query->po_currency->caption() ?></span></td>
		<td data-name="po_currency"<?php echo $barcode_query->po_currency->cellAttributes() ?>>
<span id="el_barcode_query_po_currency">
<span<?php echo $barcode_query->po_currency->viewAttributes() ?>>
<?php echo $barcode_query->po_currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->weaving_works->Visible) { // weaving_works ?>
	<tr id="r_weaving_works">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_weaving_works"><?php echo $barcode_query->weaving_works->caption() ?></span></td>
		<td data-name="weaving_works"<?php echo $barcode_query->weaving_works->cellAttributes() ?>>
<span id="el_barcode_query_weaving_works">
<span<?php echo $barcode_query->weaving_works->viewAttributes() ?>>
<?php echo $barcode_query->weaving_works->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->current_works->Visible) { // current_works ?>
	<tr id="r_current_works">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_current_works"><?php echo $barcode_query->current_works->caption() ?></span></td>
		<td data-name="current_works"<?php echo $barcode_query->current_works->cellAttributes() ?>>
<span id="el_barcode_query_current_works">
<span<?php echo $barcode_query->current_works->viewAttributes() ?>>
<?php echo $barcode_query->current_works->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->consignee->Visible) { // consignee ?>
	<tr id="r_consignee">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_consignee"><?php echo $barcode_query->consignee->caption() ?></span></td>
		<td data-name="consignee"<?php echo $barcode_query->consignee->cellAttributes() ?>>
<span id="el_barcode_query_consignee">
<span<?php echo $barcode_query->consignee->viewAttributes() ?>>
<?php echo $barcode_query->consignee->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->jc_no->Visible) { // jc_no ?>
	<tr id="r_jc_no">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_jc_no"><?php echo $barcode_query->jc_no->caption() ?></span></td>
		<td data-name="jc_no"<?php echo $barcode_query->jc_no->cellAttributes() ?>>
<span id="el_barcode_query_jc_no">
<span<?php echo $barcode_query->jc_no->viewAttributes() ?>>
<?php echo $barcode_query->jc_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_operator"><?php echo $barcode_query->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $barcode_query->operator->cellAttributes() ?>>
<span id="el_barcode_query_operator">
<span<?php echo $barcode_query->operator->viewAttributes() ?>>
<?php echo $barcode_query->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_datetime"><?php echo $barcode_query->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $barcode_query->datetime->cellAttributes() ?>>
<span id="el_barcode_query_datetime">
<span<?php echo $barcode_query->datetime->viewAttributes() ?>>
<?php echo $barcode_query->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($barcode_query->completed->Visible) { // completed ?>
	<tr id="r_completed">
		<td class="<?php echo $barcode_query_view->TableLeftColumnClass ?>"><span id="elh_barcode_query_completed"><?php echo $barcode_query->completed->caption() ?></span></td>
		<td data-name="completed"<?php echo $barcode_query->completed->cellAttributes() ?>>
<span id="el_barcode_query_completed">
<span<?php echo $barcode_query->completed->viewAttributes() ?>>
<?php echo $barcode_query->completed->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$barcode_query_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$barcode_query->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$barcode_query_view->terminate();
?>