<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$batch_no_addopt = new batch_no_addopt();

// Run the page
$batch_no_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$batch_no_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fbatch_noaddopt = currentForm = new ew.Form("fbatch_noaddopt", "addopt");

// Validate form
fbatch_noaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($batch_no_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->grp->caption(), $batch_no->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->s_grp->caption(), $batch_no->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->product->caption(), $batch_no->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->rid->caption(), $batch_no->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->packing_type->caption(), $batch_no->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->batch_no->caption(), $batch_no->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->description->caption(), $batch_no->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->remarks->caption(), $batch_no->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->status->caption(), $batch_no->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $batch_no->image->caption(), $batch_no->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->operator->caption(), $batch_no->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->datetime->caption(), $batch_no->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->process_id_tmp->Required) { ?>
			elm = this.getElements("x" + infix + "_process_id_tmp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->process_id_tmp->caption(), $batch_no->process_id_tmp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->process->caption(), $batch_no->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->bom_app_id->Required) { ?>
			elm = this.getElements("x" + infix + "_bom_app_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->bom_app_id->caption(), $batch_no->bom_app_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_bom_app_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($batch_no->bom_app_id->errorMessage()) ?>");
		<?php if ($batch_no_addopt->bom_url->Required) { ?>
			elm = this.getElements("x" + infix + "_bom_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->bom_url->caption(), $batch_no->bom_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->ted_url->Required) { ?>
			elm = this.getElements("x" + infix + "_ted_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->ted_url->caption(), $batch_no->ted_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->payment_url->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->payment_url->caption(), $batch_no->payment_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_addopt->uid->Required) { ?>
			elm = this.getElements("x" + infix + "_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->uid->caption(), $batch_no->uid->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbatch_noaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbatch_noaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbatch_noaddopt.lists["x_grp"] = <?php echo $batch_no_addopt->grp->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_grp"].options = <?php echo JsonEncode($batch_no_addopt->grp->lookupOptions()) ?>;
fbatch_noaddopt.lists["x_s_grp"] = <?php echo $batch_no_addopt->s_grp->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_s_grp"].options = <?php echo JsonEncode($batch_no_addopt->s_grp->lookupOptions()) ?>;
fbatch_noaddopt.lists["x_product"] = <?php echo $batch_no_addopt->product->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_product"].options = <?php echo JsonEncode($batch_no_addopt->product->lookupOptions()) ?>;
fbatch_noaddopt.lists["x_rid"] = <?php echo $batch_no_addopt->rid->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_rid"].options = <?php echo JsonEncode($batch_no_addopt->rid->lookupOptions()) ?>;
fbatch_noaddopt.lists["x_packing_type"] = <?php echo $batch_no_addopt->packing_type->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_packing_type"].options = <?php echo JsonEncode($batch_no_addopt->packing_type->lookupOptions()) ?>;
fbatch_noaddopt.lists["x_status"] = <?php echo $batch_no_addopt->status->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_status"].options = <?php echo JsonEncode($batch_no_addopt->status->options(FALSE, TRUE)) ?>;
fbatch_noaddopt.lists["x_operator"] = <?php echo $batch_no_addopt->operator->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_operator"].options = <?php echo JsonEncode($batch_no_addopt->operator->lookupOptions()) ?>;
fbatch_noaddopt.lists["x_process_id_tmp[]"] = <?php echo $batch_no_addopt->process_id_tmp->Lookup->toClientList() ?>;
fbatch_noaddopt.lists["x_process_id_tmp[]"].options = <?php echo JsonEncode($batch_no_addopt->process_id_tmp->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $batch_no_addopt->showPageHeader(); ?>
<?php
$batch_no_addopt->showMessage();
?>
<form name="fbatch_noaddopt" id="fbatch_noaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($batch_no_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $batch_no_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $batch_no_addopt->TableVar ?>">
<?php if ($batch_no->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $batch_no->grp->caption() ?><?php echo ($batch_no->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $batch_no->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$batch_no->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_grp" data-value-separator="<?php echo $batch_no->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $batch_no->grp->editAttributes() ?>>
		<?php echo $batch_no->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $batch_no->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $batch_no->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?php echo $batch_no->s_grp->caption() ?><?php echo ($batch_no->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $batch_no->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$batch_no->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_s_grp" data-value-separator="<?php echo $batch_no->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $batch_no->s_grp->editAttributes() ?>>
		<?php echo $batch_no->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $batch_no->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $batch_no->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $batch_no->product->caption() ?><?php echo ($batch_no->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $batch_no->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$batch_no->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_product" data-value-separator="<?php echo $batch_no->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $batch_no->product->editAttributes() ?>>
		<?php echo $batch_no->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $batch_no->product->Lookup->getParamTag("p_x_product") ?>
<?php echo $batch_no->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->rid->Visible) { // rid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $batch_no->rid->caption() ?><?php echo ($batch_no->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="batch_no" data-field="x_rid" data-value-separator="<?php echo $batch_no->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="{value}"<?php echo $batch_no->rid->editAttributes() ?>></div>
<div id="dsl_x_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $batch_no->rid->radioButtonListHtml(FALSE, "x_rid") ?>
</div></div>
<?php echo $batch_no->rid->Lookup->getParamTag("p_x_rid") ?>
<?php echo $batch_no->rid->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->packing_type->Visible) { // packing_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_packing_type"><?php echo $batch_no->packing_type->caption() ?><?php echo ($batch_no->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_packing_type" data-value-separator="<?php echo $batch_no->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $batch_no->packing_type->editAttributes() ?>>
		<?php echo $batch_no->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $batch_no->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
<?php echo $batch_no->packing_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->batch_no->Visible) { // batch_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_batch_no"><?php echo $batch_no->batch_no->caption() ?><?php echo ($batch_no->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="batch_no" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" maxlength="36" placeholder="<?php echo HtmlEncode($batch_no->batch_no->getPlaceHolder()) ?>" value="<?php echo $batch_no->batch_no->EditValue ?>"<?php echo $batch_no->batch_no->editAttributes() ?>>
<?php echo $batch_no->batch_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->description->Visible) { // description ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_description"><?php echo $batch_no->description->caption() ?><?php echo ($batch_no->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="batch_no" data-field="x_description" name="x_description" id="x_description" size="30" placeholder="<?php echo HtmlEncode($batch_no->description->getPlaceHolder()) ?>" value="<?php echo $batch_no->description->EditValue ?>"<?php echo $batch_no->description->editAttributes() ?>>
<?php echo $batch_no->description->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->remarks->Visible) { // remarks ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remarks"><?php echo $batch_no->remarks->caption() ?><?php echo ($batch_no->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="batch_no" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($batch_no->remarks->getPlaceHolder()) ?>"<?php echo $batch_no->remarks->editAttributes() ?>><?php echo $batch_no->remarks->EditValue ?></textarea>
<?php echo $batch_no->remarks->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $batch_no->status->caption() ?><?php echo ($batch_no->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_status" data-value-separator="<?php echo $batch_no->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $batch_no->status->editAttributes() ?>>
		<?php echo $batch_no->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $batch_no->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->image->Visible) { // image ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $batch_no->image->caption() ?><?php echo ($batch_no->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_image">
<span title="<?php echo $batch_no->image->title() ? $batch_no->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($batch_no->image->ReadOnly || $batch_no->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="batch_no" data-field="x_image" name="x_image" id="x_image"<?php echo $batch_no->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $batch_no->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="255">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $batch_no->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $batch_no->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $batch_no->image->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->operator->Visible) { // operator ?>
	<input type="hidden" data-table="batch_no" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($batch_no->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($batch_no->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="batch_no" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($batch_no->datetime->CurrentValue) ?>">
<?php } ?>
<?php if ($batch_no->process_id_tmp->Visible) { // process_id_tmp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $batch_no->process_id_tmp->caption() ?><?php echo ($batch_no->process_id_tmp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_process_id_tmp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="batch_no" data-field="x_process_id_tmp" data-value-separator="<?php echo $batch_no->process_id_tmp->displayValueSeparatorAttribute() ?>" name="x_process_id_tmp[]" id="x_process_id_tmp[]" value="{value}"<?php echo $batch_no->process_id_tmp->editAttributes() ?>></div>
<div id="dsl_x_process_id_tmp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $batch_no->process_id_tmp->checkBoxListHtml(FALSE, "x_process_id_tmp[]") ?>
</div></div>
<?php echo $batch_no->process_id_tmp->Lookup->getParamTag("p_x_process_id_tmp") ?>
<?php echo $batch_no->process_id_tmp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->process->Visible) { // process ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_process"><?php echo $batch_no->process->caption() ?><?php echo ($batch_no->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="batch_no" data-field="x_process" name="x_process" id="x_process" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($batch_no->process->getPlaceHolder()) ?>" value="<?php echo $batch_no->process->EditValue ?>"<?php echo $batch_no->process->editAttributes() ?>>
<?php echo $batch_no->process->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->bom_app_id->Visible) { // bom_app_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bom_app_id"><?php echo $batch_no->bom_app_id->caption() ?><?php echo ($batch_no->bom_app_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="batch_no" data-field="x_bom_app_id" name="x_bom_app_id" id="x_bom_app_id" size="30" placeholder="<?php echo HtmlEncode($batch_no->bom_app_id->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom_app_id->EditValue ?>"<?php echo $batch_no->bom_app_id->editAttributes() ?>>
<?php echo $batch_no->bom_app_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->bom_url->Visible) { // bom_url ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bom_url"><?php echo $batch_no->bom_url->caption() ?><?php echo ($batch_no->bom_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="batch_no" data-field="x_bom_url" name="x_bom_url" id="x_bom_url" size="30" maxlength="131" placeholder="<?php echo HtmlEncode($batch_no->bom_url->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom_url->EditValue ?>"<?php echo $batch_no->bom_url->editAttributes() ?>>
<?php echo $batch_no->bom_url->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->ted_url->Visible) { // ted_url ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_ted_url"><?php echo $batch_no->ted_url->caption() ?><?php echo ($batch_no->ted_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="batch_no" data-field="x_ted_url" name="x_ted_url" id="x_ted_url" cols="35" rows="4" placeholder="<?php echo HtmlEncode($batch_no->ted_url->getPlaceHolder()) ?>"<?php echo $batch_no->ted_url->editAttributes() ?>><?php echo $batch_no->ted_url->EditValue ?></textarea>
<?php echo $batch_no->ted_url->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->payment_url->Visible) { // payment_url ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_payment_url"><?php echo $batch_no->payment_url->caption() ?><?php echo ($batch_no->payment_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="batch_no" data-field="x_payment_url" name="x_payment_url" id="x_payment_url" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($batch_no->payment_url->getPlaceHolder()) ?>" value="<?php echo $batch_no->payment_url->EditValue ?>"<?php echo $batch_no->payment_url->editAttributes() ?>>
<?php echo $batch_no->payment_url->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($batch_no->uid->Visible) { // uid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_uid"><?php echo $batch_no->uid->caption() ?><?php echo ($batch_no->uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="batch_no" data-field="x_uid" name="x_uid" id="x_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($batch_no->uid->getPlaceHolder()) ?>" value="<?php echo $batch_no->uid->EditValue ?>"<?php echo $batch_no->uid->editAttributes() ?>>
<?php echo $batch_no->uid->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$batch_no_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$batch_no_addopt->terminate();
?>