<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$batch_no_list = new batch_no_list();

// Run the page
$batch_no_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$batch_no_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$batch_no->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbatch_nolist = currentForm = new ew.Form("fbatch_nolist", "list");
fbatch_nolist.formKeyCountName = '<?php echo $batch_no_list->FormKeyCountName ?>';

// Validate form
fbatch_nolist.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($batch_no_list->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->id->caption(), $batch_no->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->rid->caption(), $batch_no->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->packing_type->caption(), $batch_no->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->batch_no->caption(), $batch_no->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->description->caption(), $batch_no->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->bom->Required) { ?>
			elm = this.getElements("x" + infix + "_bom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->bom->caption(), $batch_no->bom->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->ted->Required) { ?>
			elm = this.getElements("x" + infix + "_ted");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->ted->caption(), $batch_no->ted->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->payment->Required) { ?>
			elm = this.getElements("x" + infix + "_payment");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->payment->caption(), $batch_no->payment->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->remarks->caption(), $batch_no->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->status->caption(), $batch_no->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $batch_no->image->caption(), $batch_no->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->operator->caption(), $batch_no->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->datetime->caption(), $batch_no->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->a_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_a_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->a_operator->caption(), $batch_no->a_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->a_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_a_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->a_datetime->caption(), $batch_no->a_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_a_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($batch_no->a_datetime->errorMessage()) ?>");
		<?php if ($batch_no_list->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->process->caption(), $batch_no->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($batch_no_list->bom_url->Required) { ?>
			elm = this.getElements("x" + infix + "_bom_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $batch_no->bom_url->caption(), $batch_no->bom_url->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbatch_nolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbatch_nolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbatch_nolist.lists["x_rid"] = <?php echo $batch_no_list->rid->Lookup->toClientList() ?>;
fbatch_nolist.lists["x_rid"].options = <?php echo JsonEncode($batch_no_list->rid->lookupOptions()) ?>;
fbatch_nolist.lists["x_packing_type"] = <?php echo $batch_no_list->packing_type->Lookup->toClientList() ?>;
fbatch_nolist.lists["x_packing_type"].options = <?php echo JsonEncode($batch_no_list->packing_type->lookupOptions()) ?>;
fbatch_nolist.lists["x_status"] = <?php echo $batch_no_list->status->Lookup->toClientList() ?>;
fbatch_nolist.lists["x_status"].options = <?php echo JsonEncode($batch_no_list->status->options(FALSE, TRUE)) ?>;
fbatch_nolist.lists["x_operator"] = <?php echo $batch_no_list->operator->Lookup->toClientList() ?>;
fbatch_nolist.lists["x_operator"].options = <?php echo JsonEncode($batch_no_list->operator->lookupOptions()) ?>;
fbatch_nolist.lists["x_a_operator"] = <?php echo $batch_no_list->a_operator->Lookup->toClientList() ?>;
fbatch_nolist.lists["x_a_operator"].options = <?php echo JsonEncode($batch_no_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fbatch_nolistsrch = currentSearchForm = new ew.Form("fbatch_nolistsrch");

// Filters
fbatch_nolistsrch.filterList = <?php echo $batch_no_list->getFilterList() ?>;

// Init search panel as collapsed
fbatch_nolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$batch_no->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($batch_no_list->TotalRecs > 0 && $batch_no_list->ExportOptions->visible()) { ?>
<?php $batch_no_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($batch_no_list->ImportOptions->visible()) { ?>
<?php $batch_no_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($batch_no_list->SearchOptions->visible()) { ?>
<?php $batch_no_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($batch_no_list->FilterOptions->visible()) { ?>
<?php $batch_no_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$batch_no_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$batch_no->isExport() && !$batch_no->CurrentAction) { ?>
<form name="fbatch_nolistsrch" id="fbatch_nolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($batch_no_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbatch_nolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="batch_no">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($batch_no_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($batch_no_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $batch_no_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($batch_no_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($batch_no_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($batch_no_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($batch_no_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $batch_no_list->showPageHeader(); ?>
<?php
$batch_no_list->showMessage();
?>
<?php if ($batch_no_list->TotalRecs > 0 || $batch_no->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($batch_no_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> batch_no">
<?php if (!$batch_no->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$batch_no->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($batch_no_list->Pager)) $batch_no_list->Pager = new PrevNextPager($batch_no_list->StartRec, $batch_no_list->DisplayRecs, $batch_no_list->TotalRecs, $batch_no_list->AutoHidePager) ?>
<?php if ($batch_no_list->Pager->RecordCount > 0 && $batch_no_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($batch_no_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($batch_no_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $batch_no_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($batch_no_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($batch_no_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $batch_no_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($batch_no_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $batch_no_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $batch_no_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $batch_no_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($batch_no_list->TotalRecs > 0 && (!$batch_no_list->AutoHidePageSizeSelector || $batch_no_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="batch_no">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($batch_no_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($batch_no_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($batch_no_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($batch_no_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($batch_no_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($batch_no->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $batch_no_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbatch_nolist" id="fbatch_nolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($batch_no_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $batch_no_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="batch_no">
<div id="gmp_batch_no" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($batch_no_list->TotalRecs > 0 || $batch_no->isGridEdit()) { ?>
<table id="tbl_batch_nolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$batch_no_list->RowType = ROWTYPE_HEADER;

// Render list options
$batch_no_list->renderListOptions();

// Render list options (header, left)
$batch_no_list->ListOptions->render("header", "left");
?>
<?php if ($batch_no->id->Visible) { // id ?>
	<?php if ($batch_no->sortUrl($batch_no->id) == "") { ?>
		<th data-name="id" class="<?php echo $batch_no->id->headerCellClass() ?>"><div id="elh_batch_no_id" class="batch_no_id"><div class="ew-table-header-caption"><?php echo $batch_no->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $batch_no->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->id) ?>',2);"><div id="elh_batch_no_id" class="batch_no_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->rid->Visible) { // rid ?>
	<?php if ($batch_no->sortUrl($batch_no->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $batch_no->rid->headerCellClass() ?>"><div id="elh_batch_no_rid" class="batch_no_rid"><div class="ew-table-header-caption"><?php echo $batch_no->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $batch_no->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->rid) ?>',2);"><div id="elh_batch_no_rid" class="batch_no_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->packing_type->Visible) { // packing_type ?>
	<?php if ($batch_no->sortUrl($batch_no->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $batch_no->packing_type->headerCellClass() ?>"><div id="elh_batch_no_packing_type" class="batch_no_packing_type"><div class="ew-table-header-caption"><?php echo $batch_no->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $batch_no->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->packing_type) ?>',2);"><div id="elh_batch_no_packing_type" class="batch_no_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->batch_no->Visible) { // batch_no ?>
	<?php if ($batch_no->sortUrl($batch_no->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $batch_no->batch_no->headerCellClass() ?>"><div id="elh_batch_no_batch_no" class="batch_no_batch_no"><div class="ew-table-header-caption"><?php echo $batch_no->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $batch_no->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->batch_no) ?>',2);"><div id="elh_batch_no_batch_no" class="batch_no_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->description->Visible) { // description ?>
	<?php if ($batch_no->sortUrl($batch_no->description) == "") { ?>
		<th data-name="description" class="<?php echo $batch_no->description->headerCellClass() ?>"><div id="elh_batch_no_description" class="batch_no_description"><div class="ew-table-header-caption"><?php echo $batch_no->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $batch_no->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->description) ?>',2);"><div id="elh_batch_no_description" class="batch_no_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->bom->Visible) { // bom ?>
	<?php if ($batch_no->sortUrl($batch_no->bom) == "") { ?>
		<th data-name="bom" class="<?php echo $batch_no->bom->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_bom" class="batch_no_bom"><div class="ew-table-header-caption"><?php echo $batch_no->bom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bom" class="<?php echo $batch_no->bom->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->bom) ?>',2);"><div id="elh_batch_no_bom" class="batch_no_bom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->bom->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->bom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->bom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->ted->Visible) { // ted ?>
	<?php if ($batch_no->sortUrl($batch_no->ted) == "") { ?>
		<th data-name="ted" class="<?php echo $batch_no->ted->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_ted" class="batch_no_ted"><div class="ew-table-header-caption"><?php echo $batch_no->ted->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ted" class="<?php echo $batch_no->ted->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->ted) ?>',2);"><div id="elh_batch_no_ted" class="batch_no_ted">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->ted->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->ted->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->ted->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->payment->Visible) { // payment ?>
	<?php if ($batch_no->sortUrl($batch_no->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $batch_no->payment->headerCellClass() ?>"><div id="elh_batch_no_payment" class="batch_no_payment"><div class="ew-table-header-caption"><?php echo $batch_no->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $batch_no->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->payment) ?>',2);"><div id="elh_batch_no_payment" class="batch_no_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->payment->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->remarks->Visible) { // remarks ?>
	<?php if ($batch_no->sortUrl($batch_no->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $batch_no->remarks->headerCellClass() ?>"><div id="elh_batch_no_remarks" class="batch_no_remarks"><div class="ew-table-header-caption"><?php echo $batch_no->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $batch_no->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->remarks) ?>',2);"><div id="elh_batch_no_remarks" class="batch_no_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->status->Visible) { // status ?>
	<?php if ($batch_no->sortUrl($batch_no->status) == "") { ?>
		<th data-name="status" class="<?php echo $batch_no->status->headerCellClass() ?>"><div id="elh_batch_no_status" class="batch_no_status"><div class="ew-table-header-caption"><?php echo $batch_no->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $batch_no->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->status) ?>',2);"><div id="elh_batch_no_status" class="batch_no_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->image->Visible) { // image ?>
	<?php if ($batch_no->sortUrl($batch_no->image) == "") { ?>
		<th data-name="image" class="<?php echo $batch_no->image->headerCellClass() ?>"><div id="elh_batch_no_image" class="batch_no_image"><div class="ew-table-header-caption"><?php echo $batch_no->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $batch_no->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->image) ?>',2);"><div id="elh_batch_no_image" class="batch_no_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->operator->Visible) { // operator ?>
	<?php if ($batch_no->sortUrl($batch_no->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $batch_no->operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_operator" class="batch_no_operator"><div class="ew-table-header-caption"><?php echo $batch_no->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $batch_no->operator->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->operator) ?>',2);"><div id="elh_batch_no_operator" class="batch_no_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->datetime->Visible) { // datetime ?>
	<?php if ($batch_no->sortUrl($batch_no->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $batch_no->datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_datetime" class="batch_no_datetime"><div class="ew-table-header-caption"><?php echo $batch_no->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $batch_no->datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->datetime) ?>',2);"><div id="elh_batch_no_datetime" class="batch_no_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->a_operator->Visible) { // a_operator ?>
	<?php if ($batch_no->sortUrl($batch_no->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $batch_no->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_a_operator" class="batch_no_a_operator"><div class="ew-table-header-caption"><?php echo $batch_no->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $batch_no->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->a_operator) ?>',2);"><div id="elh_batch_no_a_operator" class="batch_no_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->a_datetime->Visible) { // a_datetime ?>
	<?php if ($batch_no->sortUrl($batch_no->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $batch_no->a_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_a_datetime" class="batch_no_a_datetime"><div class="ew-table-header-caption"><?php echo $batch_no->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $batch_no->a_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->a_datetime) ?>',2);"><div id="elh_batch_no_a_datetime" class="batch_no_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->process->Visible) { // process ?>
	<?php if ($batch_no->sortUrl($batch_no->process) == "") { ?>
		<th data-name="process" class="<?php echo $batch_no->process->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_process" class="batch_no_process"><div class="ew-table-header-caption"><?php echo $batch_no->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $batch_no->process->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->process) ?>',2);"><div id="elh_batch_no_process" class="batch_no_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($batch_no->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($batch_no->bom_url->Visible) { // bom_url ?>
	<?php if ($batch_no->sortUrl($batch_no->bom_url) == "") { ?>
		<th data-name="bom_url" class="<?php echo $batch_no->bom_url->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_batch_no_bom_url" class="batch_no_bom_url"><div class="ew-table-header-caption"><?php echo $batch_no->bom_url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bom_url" class="<?php echo $batch_no->bom_url->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $batch_no->SortUrl($batch_no->bom_url) ?>',2);"><div id="elh_batch_no_bom_url" class="batch_no_bom_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $batch_no->bom_url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($batch_no->bom_url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($batch_no->bom_url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$batch_no_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($batch_no->ExportAll && $batch_no->isExport()) {
	$batch_no_list->StopRec = $batch_no_list->TotalRecs;
} else {

	// Set the last record to display
	if ($batch_no_list->TotalRecs > $batch_no_list->StartRec + $batch_no_list->DisplayRecs - 1)
		$batch_no_list->StopRec = $batch_no_list->StartRec + $batch_no_list->DisplayRecs - 1;
	else
		$batch_no_list->StopRec = $batch_no_list->TotalRecs;
}

// Restore number of post back records
if ($CurrentForm && $batch_no_list->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($batch_no_list->FormKeyCountName) && ($batch_no->isGridAdd() || $batch_no->isGridEdit() || $batch_no->isConfirm())) {
		$batch_no_list->KeyCount = $CurrentForm->getValue($batch_no_list->FormKeyCountName);
		$batch_no_list->StopRec = $batch_no_list->StartRec + $batch_no_list->KeyCount - 1;
	}
}
$batch_no_list->RecCnt = $batch_no_list->StartRec - 1;
if ($batch_no_list->Recordset && !$batch_no_list->Recordset->EOF) {
	$batch_no_list->Recordset->moveFirst();
	$selectLimit = $batch_no_list->UseSelectLimit;
	if (!$selectLimit && $batch_no_list->StartRec > 1)
		$batch_no_list->Recordset->move($batch_no_list->StartRec - 1);
} elseif (!$batch_no->AllowAddDeleteRow && $batch_no_list->StopRec == 0) {
	$batch_no_list->StopRec = $batch_no->GridAddRowCount;
}

// Initialize aggregate
$batch_no->RowType = ROWTYPE_AGGREGATEINIT;
$batch_no->resetAttributes();
$batch_no_list->renderRow();
if ($batch_no->isGridEdit())
	$batch_no_list->RowIndex = 0;
while ($batch_no_list->RecCnt < $batch_no_list->StopRec) {
	$batch_no_list->RecCnt++;
	if ($batch_no_list->RecCnt >= $batch_no_list->StartRec) {
		$batch_no_list->RowCnt++;
		if ($batch_no->isGridAdd() || $batch_no->isGridEdit() || $batch_no->isConfirm()) {
			$batch_no_list->RowIndex++;
			$CurrentForm->Index = $batch_no_list->RowIndex;
			if ($CurrentForm->hasValue($batch_no_list->FormActionName) && $batch_no_list->EventCancelled)
				$batch_no_list->RowAction = strval($CurrentForm->getValue($batch_no_list->FormActionName));
			elseif ($batch_no->isGridAdd())
				$batch_no_list->RowAction = "insert";
			else
				$batch_no_list->RowAction = "";
		}

		// Set up key count
		$batch_no_list->KeyCount = $batch_no_list->RowIndex;

		// Init row class and style
		$batch_no->resetAttributes();
		$batch_no->CssClass = "";
		if ($batch_no->isGridAdd()) {
			$batch_no_list->loadRowValues(); // Load default values
		} else {
			$batch_no_list->loadRowValues($batch_no_list->Recordset); // Load row values
		}
		$batch_no->RowType = ROWTYPE_VIEW; // Render view
		if ($batch_no->isGridEdit()) { // Grid edit
			if ($batch_no->EventCancelled)
				$batch_no_list->restoreCurrentRowFormValues($batch_no_list->RowIndex); // Restore form values
			if ($batch_no_list->RowAction == "insert")
				$batch_no->RowType = ROWTYPE_ADD; // Render add
			else
				$batch_no->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($batch_no->isGridEdit() && ($batch_no->RowType == ROWTYPE_EDIT || $batch_no->RowType == ROWTYPE_ADD) && $batch_no->EventCancelled) // Update failed
			$batch_no_list->restoreCurrentRowFormValues($batch_no_list->RowIndex); // Restore form values
		if ($batch_no->RowType == ROWTYPE_EDIT) // Edit row
			$batch_no_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$batch_no->RowAttrs = array_merge($batch_no->RowAttrs, array('data-rowindex'=>$batch_no_list->RowCnt, 'id'=>'r' . $batch_no_list->RowCnt . '_batch_no', 'data-rowtype'=>$batch_no->RowType));

		// Render row
		$batch_no_list->renderRow();

		// Render list options
		$batch_no_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($batch_no_list->RowAction <> "delete" && $batch_no_list->RowAction <> "insertdelete" && !($batch_no_list->RowAction == "insert" && $batch_no->isConfirm() && $batch_no_list->emptyRow())) {
?>
	<tr<?php echo $batch_no->rowAttributes() ?>>
<?php

// Render list options (body, left)
$batch_no_list->ListOptions->render("body", "left", $batch_no_list->RowCnt);
?>
	<?php if ($batch_no->id->Visible) { // id ?>
		<td data-name="id"<?php echo $batch_no->id->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="batch_no" data-field="x_id" name="o<?php echo $batch_no_list->RowIndex ?>_id" id="o<?php echo $batch_no_list->RowIndex ?>_id" value="<?php echo HtmlEncode($batch_no->id->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_id" class="form-group batch_no_id">
<span<?php echo $batch_no->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($batch_no->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="batch_no" data-field="x_id" name="x<?php echo $batch_no_list->RowIndex ?>_id" id="x<?php echo $batch_no_list->RowIndex ?>_id" value="<?php echo HtmlEncode($batch_no->id->CurrentValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_id" class="batch_no_id">
<span<?php echo $batch_no->id->viewAttributes() ?>>
<?php echo $batch_no->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $batch_no->rid->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_rid" class="form-group batch_no_rid">
<div id="tp_x<?php echo $batch_no_list->RowIndex ?>_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="batch_no" data-field="x_rid" data-value-separator="<?php echo $batch_no->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $batch_no_list->RowIndex ?>_rid" id="x<?php echo $batch_no_list->RowIndex ?>_rid" value="{value}"<?php echo $batch_no->rid->editAttributes() ?>></div>
<div id="dsl_x<?php echo $batch_no_list->RowIndex ?>_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $batch_no->rid->radioButtonListHtml(FALSE, "x{$batch_no_list->RowIndex}_rid") ?>
</div></div>
<?php echo $batch_no->rid->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="batch_no" data-field="x_rid" name="o<?php echo $batch_no_list->RowIndex ?>_rid" id="o<?php echo $batch_no_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($batch_no->rid->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_rid" class="form-group batch_no_rid">
<div id="tp_x<?php echo $batch_no_list->RowIndex ?>_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="batch_no" data-field="x_rid" data-value-separator="<?php echo $batch_no->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $batch_no_list->RowIndex ?>_rid" id="x<?php echo $batch_no_list->RowIndex ?>_rid" value="{value}"<?php echo $batch_no->rid->editAttributes() ?>></div>
<div id="dsl_x<?php echo $batch_no_list->RowIndex ?>_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $batch_no->rid->radioButtonListHtml(FALSE, "x{$batch_no_list->RowIndex}_rid") ?>
</div></div>
<?php echo $batch_no->rid->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_rid") ?>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_rid" class="batch_no_rid">
<span<?php echo $batch_no->rid->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->rid->getViewValue())) && $batch_no->rid->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->rid->linkAttributes() ?>><?php echo $batch_no->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $batch_no->packing_type->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_packing_type" class="form-group batch_no_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_packing_type" data-value-separator="<?php echo $batch_no->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_packing_type" name="x<?php echo $batch_no_list->RowIndex ?>_packing_type"<?php echo $batch_no->packing_type->editAttributes() ?>>
		<?php echo $batch_no->packing_type->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_packing_type") ?>
	</select>
</div>
<?php echo $batch_no->packing_type->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_packing_type") ?>
</span>
<input type="hidden" data-table="batch_no" data-field="x_packing_type" name="o<?php echo $batch_no_list->RowIndex ?>_packing_type" id="o<?php echo $batch_no_list->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($batch_no->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_packing_type" class="form-group batch_no_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_packing_type" data-value-separator="<?php echo $batch_no->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_packing_type" name="x<?php echo $batch_no_list->RowIndex ?>_packing_type"<?php echo $batch_no->packing_type->editAttributes() ?>>
		<?php echo $batch_no->packing_type->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_packing_type") ?>
	</select>
</div>
<?php echo $batch_no->packing_type->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_packing_type") ?>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_packing_type" class="batch_no_packing_type">
<span<?php echo $batch_no->packing_type->viewAttributes() ?>>
<?php echo $batch_no->packing_type->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $batch_no->batch_no->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_batch_no" class="form-group batch_no_batch_no">
<input type="text" data-table="batch_no" data-field="x_batch_no" name="x<?php echo $batch_no_list->RowIndex ?>_batch_no" id="x<?php echo $batch_no_list->RowIndex ?>_batch_no" size="30" maxlength="36" placeholder="<?php echo HtmlEncode($batch_no->batch_no->getPlaceHolder()) ?>" value="<?php echo $batch_no->batch_no->EditValue ?>"<?php echo $batch_no->batch_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_batch_no" name="o<?php echo $batch_no_list->RowIndex ?>_batch_no" id="o<?php echo $batch_no_list->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($batch_no->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_batch_no" class="form-group batch_no_batch_no">
<input type="text" data-table="batch_no" data-field="x_batch_no" name="x<?php echo $batch_no_list->RowIndex ?>_batch_no" id="x<?php echo $batch_no_list->RowIndex ?>_batch_no" size="30" maxlength="36" placeholder="<?php echo HtmlEncode($batch_no->batch_no->getPlaceHolder()) ?>" value="<?php echo $batch_no->batch_no->EditValue ?>"<?php echo $batch_no->batch_no->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_batch_no" class="batch_no_batch_no">
<span<?php echo $batch_no->batch_no->viewAttributes() ?>>
<?php echo $batch_no->batch_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->description->Visible) { // description ?>
		<td data-name="description"<?php echo $batch_no->description->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_description" class="form-group batch_no_description">
<input type="text" data-table="batch_no" data-field="x_description" name="x<?php echo $batch_no_list->RowIndex ?>_description" id="x<?php echo $batch_no_list->RowIndex ?>_description" size="30" placeholder="<?php echo HtmlEncode($batch_no->description->getPlaceHolder()) ?>" value="<?php echo $batch_no->description->EditValue ?>"<?php echo $batch_no->description->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_description" name="o<?php echo $batch_no_list->RowIndex ?>_description" id="o<?php echo $batch_no_list->RowIndex ?>_description" value="<?php echo HtmlEncode($batch_no->description->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_description" class="form-group batch_no_description">
<input type="text" data-table="batch_no" data-field="x_description" name="x<?php echo $batch_no_list->RowIndex ?>_description" id="x<?php echo $batch_no_list->RowIndex ?>_description" size="30" placeholder="<?php echo HtmlEncode($batch_no->description->getPlaceHolder()) ?>" value="<?php echo $batch_no->description->EditValue ?>"<?php echo $batch_no->description->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_description" class="batch_no_description">
<span<?php echo $batch_no->description->viewAttributes() ?>>
<?php echo $batch_no->description->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->bom->Visible) { // bom ?>
		<td data-name="bom"<?php echo $batch_no->bom->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_bom" class="form-group batch_no_bom">
<input type="text" data-table="batch_no" data-field="x_bom" name="x<?php echo $batch_no_list->RowIndex ?>_bom" id="x<?php echo $batch_no_list->RowIndex ?>_bom" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($batch_no->bom->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom->EditValue ?>"<?php echo $batch_no->bom->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_bom" name="o<?php echo $batch_no_list->RowIndex ?>_bom" id="o<?php echo $batch_no_list->RowIndex ?>_bom" value="<?php echo HtmlEncode($batch_no->bom->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_bom" class="form-group batch_no_bom">
<input type="text" data-table="batch_no" data-field="x_bom" name="x<?php echo $batch_no_list->RowIndex ?>_bom" id="x<?php echo $batch_no_list->RowIndex ?>_bom" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($batch_no->bom->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom->EditValue ?>"<?php echo $batch_no->bom->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_bom" class="batch_no_bom">
<span<?php echo $batch_no->bom->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->bom->getViewValue())) && $batch_no->bom->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->bom->linkAttributes() ?>><?php echo $batch_no->bom->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->bom->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->ted->Visible) { // ted ?>
		<td data-name="ted"<?php echo $batch_no->ted->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_ted" class="form-group batch_no_ted">
<input type="text" data-table="batch_no" data-field="x_ted" name="x<?php echo $batch_no_list->RowIndex ?>_ted" id="x<?php echo $batch_no_list->RowIndex ?>_ted" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($batch_no->ted->getPlaceHolder()) ?>" value="<?php echo $batch_no->ted->EditValue ?>"<?php echo $batch_no->ted->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_ted" name="o<?php echo $batch_no_list->RowIndex ?>_ted" id="o<?php echo $batch_no_list->RowIndex ?>_ted" value="<?php echo HtmlEncode($batch_no->ted->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_ted" class="form-group batch_no_ted">
<input type="text" data-table="batch_no" data-field="x_ted" name="x<?php echo $batch_no_list->RowIndex ?>_ted" id="x<?php echo $batch_no_list->RowIndex ?>_ted" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($batch_no->ted->getPlaceHolder()) ?>" value="<?php echo $batch_no->ted->EditValue ?>"<?php echo $batch_no->ted->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_ted" class="batch_no_ted">
<span<?php echo $batch_no->ted->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->ted->getViewValue())) && $batch_no->ted->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->ted->linkAttributes() ?>><?php echo $batch_no->ted->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->ted->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $batch_no->payment->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_payment" class="form-group batch_no_payment">
<input type="text" data-table="batch_no" data-field="x_payment" name="x<?php echo $batch_no_list->RowIndex ?>_payment" id="x<?php echo $batch_no_list->RowIndex ?>_payment" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($batch_no->payment->getPlaceHolder()) ?>" value="<?php echo $batch_no->payment->EditValue ?>"<?php echo $batch_no->payment->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_payment" name="o<?php echo $batch_no_list->RowIndex ?>_payment" id="o<?php echo $batch_no_list->RowIndex ?>_payment" value="<?php echo HtmlEncode($batch_no->payment->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_payment" class="form-group batch_no_payment">
<input type="text" data-table="batch_no" data-field="x_payment" name="x<?php echo $batch_no_list->RowIndex ?>_payment" id="x<?php echo $batch_no_list->RowIndex ?>_payment" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($batch_no->payment->getPlaceHolder()) ?>" value="<?php echo $batch_no->payment->EditValue ?>"<?php echo $batch_no->payment->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_payment" class="batch_no_payment">
<span<?php echo $batch_no->payment->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->payment->getViewValue())) && $batch_no->payment->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->payment->linkAttributes() ?>><?php echo $batch_no->payment->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->payment->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $batch_no->remarks->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_remarks" class="form-group batch_no_remarks">
<textarea data-table="batch_no" data-field="x_remarks" name="x<?php echo $batch_no_list->RowIndex ?>_remarks" id="x<?php echo $batch_no_list->RowIndex ?>_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($batch_no->remarks->getPlaceHolder()) ?>"<?php echo $batch_no->remarks->editAttributes() ?>><?php echo $batch_no->remarks->EditValue ?></textarea>
</span>
<input type="hidden" data-table="batch_no" data-field="x_remarks" name="o<?php echo $batch_no_list->RowIndex ?>_remarks" id="o<?php echo $batch_no_list->RowIndex ?>_remarks" value="<?php echo HtmlEncode($batch_no->remarks->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_remarks" class="form-group batch_no_remarks">
<textarea data-table="batch_no" data-field="x_remarks" name="x<?php echo $batch_no_list->RowIndex ?>_remarks" id="x<?php echo $batch_no_list->RowIndex ?>_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($batch_no->remarks->getPlaceHolder()) ?>"<?php echo $batch_no->remarks->editAttributes() ?>><?php echo $batch_no->remarks->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_remarks" class="batch_no_remarks">
<span<?php echo $batch_no->remarks->viewAttributes() ?>>
<?php echo $batch_no->remarks->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->status->Visible) { // status ?>
		<td data-name="status"<?php echo $batch_no->status->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_status" class="form-group batch_no_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_status" data-value-separator="<?php echo $batch_no->status->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_status" name="x<?php echo $batch_no_list->RowIndex ?>_status"<?php echo $batch_no->status->editAttributes() ?>>
		<?php echo $batch_no->status->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_status") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="batch_no" data-field="x_status" name="o<?php echo $batch_no_list->RowIndex ?>_status" id="o<?php echo $batch_no_list->RowIndex ?>_status" value="<?php echo HtmlEncode($batch_no->status->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_status" class="form-group batch_no_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_status" data-value-separator="<?php echo $batch_no->status->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_status" name="x<?php echo $batch_no_list->RowIndex ?>_status"<?php echo $batch_no->status->editAttributes() ?>>
		<?php echo $batch_no->status->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_status") ?>
	</select>
</div>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_status" class="batch_no_status">
<span<?php echo $batch_no->status->viewAttributes() ?>>
<?php echo $batch_no->status->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->image->Visible) { // image ?>
		<td data-name="image"<?php echo $batch_no->image->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_image" class="form-group batch_no_image">
<div id="fd_x<?php echo $batch_no_list->RowIndex ?>_image">
<span title="<?php echo $batch_no->image->title() ? $batch_no->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($batch_no->image->ReadOnly || $batch_no->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="batch_no" data-field="x_image" name="x<?php echo $batch_no_list->RowIndex ?>_image" id="x<?php echo $batch_no_list->RowIndex ?>_image"<?php echo $batch_no->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fn_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fa_x<?php echo $batch_no_list->RowIndex ?>_image" value="0">
<input type="hidden" name="fs_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fs_x<?php echo $batch_no_list->RowIndex ?>_image" value="255">
<input type="hidden" name="fx_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fx_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fm_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $batch_no_list->RowIndex ?>_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="batch_no" data-field="x_image" name="o<?php echo $batch_no_list->RowIndex ?>_image" id="o<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo HtmlEncode($batch_no->image->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_image" class="form-group batch_no_image">
<div id="fd_x<?php echo $batch_no_list->RowIndex ?>_image">
<span title="<?php echo $batch_no->image->title() ? $batch_no->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($batch_no->image->ReadOnly || $batch_no->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="batch_no" data-field="x_image" name="x<?php echo $batch_no_list->RowIndex ?>_image" id="x<?php echo $batch_no_list->RowIndex ?>_image"<?php echo $batch_no->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fn_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->Upload->FileName ?>">
<?php if (Post("fa_x<?php echo $batch_no_list->RowIndex ?>_image") == "0") { ?>
<input type="hidden" name="fa_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fa_x<?php echo $batch_no_list->RowIndex ?>_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fa_x<?php echo $batch_no_list->RowIndex ?>_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fs_x<?php echo $batch_no_list->RowIndex ?>_image" value="255">
<input type="hidden" name="fx_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fx_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fm_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $batch_no_list->RowIndex ?>_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_image" class="batch_no_image">
<span>
<?php echo GetFileViewTag($batch_no->image, $batch_no->image->getViewValue()) ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $batch_no->operator->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="batch_no" data-field="x_operator" name="o<?php echo $batch_no_list->RowIndex ?>_operator" id="o<?php echo $batch_no_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($batch_no->operator->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_operator" class="batch_no_operator">
<span<?php echo $batch_no->operator->viewAttributes() ?>>
<?php echo $batch_no->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $batch_no->datetime->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="batch_no" data-field="x_datetime" name="o<?php echo $batch_no_list->RowIndex ?>_datetime" id="o<?php echo $batch_no_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($batch_no->datetime->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_datetime" class="batch_no_datetime">
<span<?php echo $batch_no->datetime->viewAttributes() ?>>
<?php echo $batch_no->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $batch_no->a_operator->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_a_operator" class="form-group batch_no_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_a_operator" data-value-separator="<?php echo $batch_no->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_a_operator" name="x<?php echo $batch_no_list->RowIndex ?>_a_operator"<?php echo $batch_no->a_operator->editAttributes() ?>>
		<?php echo $batch_no->a_operator->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $batch_no->a_operator->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_a_operator") ?>
</span>
<input type="hidden" data-table="batch_no" data-field="x_a_operator" name="o<?php echo $batch_no_list->RowIndex ?>_a_operator" id="o<?php echo $batch_no_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($batch_no->a_operator->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_a_operator" class="form-group batch_no_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_a_operator" data-value-separator="<?php echo $batch_no->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_a_operator" name="x<?php echo $batch_no_list->RowIndex ?>_a_operator"<?php echo $batch_no->a_operator->editAttributes() ?>>
		<?php echo $batch_no->a_operator->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $batch_no->a_operator->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_a_operator") ?>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_a_operator" class="batch_no_a_operator">
<span<?php echo $batch_no->a_operator->viewAttributes() ?>>
<?php echo $batch_no->a_operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $batch_no->a_datetime->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_a_datetime" class="form-group batch_no_a_datetime">
<input type="text" data-table="batch_no" data-field="x_a_datetime" name="x<?php echo $batch_no_list->RowIndex ?>_a_datetime" id="x<?php echo $batch_no_list->RowIndex ?>_a_datetime" placeholder="<?php echo HtmlEncode($batch_no->a_datetime->getPlaceHolder()) ?>" value="<?php echo $batch_no->a_datetime->EditValue ?>"<?php echo $batch_no->a_datetime->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_a_datetime" name="o<?php echo $batch_no_list->RowIndex ?>_a_datetime" id="o<?php echo $batch_no_list->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($batch_no->a_datetime->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_a_datetime" class="form-group batch_no_a_datetime">
<input type="text" data-table="batch_no" data-field="x_a_datetime" name="x<?php echo $batch_no_list->RowIndex ?>_a_datetime" id="x<?php echo $batch_no_list->RowIndex ?>_a_datetime" placeholder="<?php echo HtmlEncode($batch_no->a_datetime->getPlaceHolder()) ?>" value="<?php echo $batch_no->a_datetime->EditValue ?>"<?php echo $batch_no->a_datetime->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_a_datetime" class="batch_no_a_datetime">
<span<?php echo $batch_no->a_datetime->viewAttributes() ?>>
<?php echo $batch_no->a_datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->process->Visible) { // process ?>
		<td data-name="process"<?php echo $batch_no->process->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_process" class="form-group batch_no_process">
<input type="text" data-table="batch_no" data-field="x_process" name="x<?php echo $batch_no_list->RowIndex ?>_process" id="x<?php echo $batch_no_list->RowIndex ?>_process" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($batch_no->process->getPlaceHolder()) ?>" value="<?php echo $batch_no->process->EditValue ?>"<?php echo $batch_no->process->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_process" name="o<?php echo $batch_no_list->RowIndex ?>_process" id="o<?php echo $batch_no_list->RowIndex ?>_process" value="<?php echo HtmlEncode($batch_no->process->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_process" class="form-group batch_no_process">
<input type="text" data-table="batch_no" data-field="x_process" name="x<?php echo $batch_no_list->RowIndex ?>_process" id="x<?php echo $batch_no_list->RowIndex ?>_process" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($batch_no->process->getPlaceHolder()) ?>" value="<?php echo $batch_no->process->EditValue ?>"<?php echo $batch_no->process->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_process" class="batch_no_process">
<span<?php echo $batch_no->process->viewAttributes() ?>>
<?php echo $batch_no->process->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($batch_no->bom_url->Visible) { // bom_url ?>
		<td data-name="bom_url"<?php echo $batch_no->bom_url->cellAttributes() ?>>
<?php if ($batch_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_bom_url" class="form-group batch_no_bom_url">
<input type="text" data-table="batch_no" data-field="x_bom_url" name="x<?php echo $batch_no_list->RowIndex ?>_bom_url" id="x<?php echo $batch_no_list->RowIndex ?>_bom_url" size="30" maxlength="131" placeholder="<?php echo HtmlEncode($batch_no->bom_url->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom_url->EditValue ?>"<?php echo $batch_no->bom_url->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_bom_url" name="o<?php echo $batch_no_list->RowIndex ?>_bom_url" id="o<?php echo $batch_no_list->RowIndex ?>_bom_url" value="<?php echo HtmlEncode($batch_no->bom_url->OldValue) ?>">
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_bom_url" class="form-group batch_no_bom_url">
<input type="text" data-table="batch_no" data-field="x_bom_url" name="x<?php echo $batch_no_list->RowIndex ?>_bom_url" id="x<?php echo $batch_no_list->RowIndex ?>_bom_url" size="30" maxlength="131" placeholder="<?php echo HtmlEncode($batch_no->bom_url->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom_url->EditValue ?>"<?php echo $batch_no->bom_url->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($batch_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $batch_no_list->RowCnt ?>_batch_no_bom_url" class="batch_no_bom_url">
<span<?php echo $batch_no->bom_url->viewAttributes() ?>>
<?php echo $batch_no->bom_url->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$batch_no_list->ListOptions->render("body", "right", $batch_no_list->RowCnt);
?>
	</tr>
<?php if ($batch_no->RowType == ROWTYPE_ADD || $batch_no->RowType == ROWTYPE_EDIT) { ?>
<script>
fbatch_nolist.updateLists(<?php echo $batch_no_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$batch_no->isGridAdd())
		if (!$batch_no_list->Recordset->EOF)
			$batch_no_list->Recordset->moveNext();
}
?>
<?php
	if ($batch_no->isGridAdd() || $batch_no->isGridEdit()) {
		$batch_no_list->RowIndex = '$rowindex$';
		$batch_no_list->loadRowValues();

		// Set row properties
		$batch_no->resetAttributes();
		$batch_no->RowAttrs = array_merge($batch_no->RowAttrs, array('data-rowindex'=>$batch_no_list->RowIndex, 'id'=>'r0_batch_no', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($batch_no->RowAttrs["class"], "ew-template");
		$batch_no->RowType = ROWTYPE_ADD;

		// Render row
		$batch_no_list->renderRow();

		// Render list options
		$batch_no_list->renderListOptions();
		$batch_no_list->StartRowCnt = 0;
?>
	<tr<?php echo $batch_no->rowAttributes() ?>>
<?php

// Render list options (body, left)
$batch_no_list->ListOptions->render("body", "left", $batch_no_list->RowIndex);
?>
	<?php if ($batch_no->id->Visible) { // id ?>
		<td data-name="id">
<input type="hidden" data-table="batch_no" data-field="x_id" name="o<?php echo $batch_no_list->RowIndex ?>_id" id="o<?php echo $batch_no_list->RowIndex ?>_id" value="<?php echo HtmlEncode($batch_no->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->rid->Visible) { // rid ?>
		<td data-name="rid">
<span id="el$rowindex$_batch_no_rid" class="form-group batch_no_rid">
<div id="tp_x<?php echo $batch_no_list->RowIndex ?>_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="batch_no" data-field="x_rid" data-value-separator="<?php echo $batch_no->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $batch_no_list->RowIndex ?>_rid" id="x<?php echo $batch_no_list->RowIndex ?>_rid" value="{value}"<?php echo $batch_no->rid->editAttributes() ?>></div>
<div id="dsl_x<?php echo $batch_no_list->RowIndex ?>_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $batch_no->rid->radioButtonListHtml(FALSE, "x{$batch_no_list->RowIndex}_rid") ?>
</div></div>
<?php echo $batch_no->rid->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="batch_no" data-field="x_rid" name="o<?php echo $batch_no_list->RowIndex ?>_rid" id="o<?php echo $batch_no_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($batch_no->rid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type">
<span id="el$rowindex$_batch_no_packing_type" class="form-group batch_no_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_packing_type" data-value-separator="<?php echo $batch_no->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_packing_type" name="x<?php echo $batch_no_list->RowIndex ?>_packing_type"<?php echo $batch_no->packing_type->editAttributes() ?>>
		<?php echo $batch_no->packing_type->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_packing_type") ?>
	</select>
</div>
<?php echo $batch_no->packing_type->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_packing_type") ?>
</span>
<input type="hidden" data-table="batch_no" data-field="x_packing_type" name="o<?php echo $batch_no_list->RowIndex ?>_packing_type" id="o<?php echo $batch_no_list->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($batch_no->packing_type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no">
<span id="el$rowindex$_batch_no_batch_no" class="form-group batch_no_batch_no">
<input type="text" data-table="batch_no" data-field="x_batch_no" name="x<?php echo $batch_no_list->RowIndex ?>_batch_no" id="x<?php echo $batch_no_list->RowIndex ?>_batch_no" size="30" maxlength="36" placeholder="<?php echo HtmlEncode($batch_no->batch_no->getPlaceHolder()) ?>" value="<?php echo $batch_no->batch_no->EditValue ?>"<?php echo $batch_no->batch_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_batch_no" name="o<?php echo $batch_no_list->RowIndex ?>_batch_no" id="o<?php echo $batch_no_list->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($batch_no->batch_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->description->Visible) { // description ?>
		<td data-name="description">
<span id="el$rowindex$_batch_no_description" class="form-group batch_no_description">
<input type="text" data-table="batch_no" data-field="x_description" name="x<?php echo $batch_no_list->RowIndex ?>_description" id="x<?php echo $batch_no_list->RowIndex ?>_description" size="30" placeholder="<?php echo HtmlEncode($batch_no->description->getPlaceHolder()) ?>" value="<?php echo $batch_no->description->EditValue ?>"<?php echo $batch_no->description->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_description" name="o<?php echo $batch_no_list->RowIndex ?>_description" id="o<?php echo $batch_no_list->RowIndex ?>_description" value="<?php echo HtmlEncode($batch_no->description->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->bom->Visible) { // bom ?>
		<td data-name="bom">
<span id="el$rowindex$_batch_no_bom" class="form-group batch_no_bom">
<input type="text" data-table="batch_no" data-field="x_bom" name="x<?php echo $batch_no_list->RowIndex ?>_bom" id="x<?php echo $batch_no_list->RowIndex ?>_bom" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($batch_no->bom->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom->EditValue ?>"<?php echo $batch_no->bom->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_bom" name="o<?php echo $batch_no_list->RowIndex ?>_bom" id="o<?php echo $batch_no_list->RowIndex ?>_bom" value="<?php echo HtmlEncode($batch_no->bom->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->ted->Visible) { // ted ?>
		<td data-name="ted">
<span id="el$rowindex$_batch_no_ted" class="form-group batch_no_ted">
<input type="text" data-table="batch_no" data-field="x_ted" name="x<?php echo $batch_no_list->RowIndex ?>_ted" id="x<?php echo $batch_no_list->RowIndex ?>_ted" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($batch_no->ted->getPlaceHolder()) ?>" value="<?php echo $batch_no->ted->EditValue ?>"<?php echo $batch_no->ted->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_ted" name="o<?php echo $batch_no_list->RowIndex ?>_ted" id="o<?php echo $batch_no_list->RowIndex ?>_ted" value="<?php echo HtmlEncode($batch_no->ted->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->payment->Visible) { // payment ?>
		<td data-name="payment">
<span id="el$rowindex$_batch_no_payment" class="form-group batch_no_payment">
<input type="text" data-table="batch_no" data-field="x_payment" name="x<?php echo $batch_no_list->RowIndex ?>_payment" id="x<?php echo $batch_no_list->RowIndex ?>_payment" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($batch_no->payment->getPlaceHolder()) ?>" value="<?php echo $batch_no->payment->EditValue ?>"<?php echo $batch_no->payment->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_payment" name="o<?php echo $batch_no_list->RowIndex ?>_payment" id="o<?php echo $batch_no_list->RowIndex ?>_payment" value="<?php echo HtmlEncode($batch_no->payment->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->remarks->Visible) { // remarks ?>
		<td data-name="remarks">
<span id="el$rowindex$_batch_no_remarks" class="form-group batch_no_remarks">
<textarea data-table="batch_no" data-field="x_remarks" name="x<?php echo $batch_no_list->RowIndex ?>_remarks" id="x<?php echo $batch_no_list->RowIndex ?>_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($batch_no->remarks->getPlaceHolder()) ?>"<?php echo $batch_no->remarks->editAttributes() ?>><?php echo $batch_no->remarks->EditValue ?></textarea>
</span>
<input type="hidden" data-table="batch_no" data-field="x_remarks" name="o<?php echo $batch_no_list->RowIndex ?>_remarks" id="o<?php echo $batch_no_list->RowIndex ?>_remarks" value="<?php echo HtmlEncode($batch_no->remarks->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->status->Visible) { // status ?>
		<td data-name="status">
<span id="el$rowindex$_batch_no_status" class="form-group batch_no_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_status" data-value-separator="<?php echo $batch_no->status->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_status" name="x<?php echo $batch_no_list->RowIndex ?>_status"<?php echo $batch_no->status->editAttributes() ?>>
		<?php echo $batch_no->status->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_status") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="batch_no" data-field="x_status" name="o<?php echo $batch_no_list->RowIndex ?>_status" id="o<?php echo $batch_no_list->RowIndex ?>_status" value="<?php echo HtmlEncode($batch_no->status->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->image->Visible) { // image ?>
		<td data-name="image">
<span id="el$rowindex$_batch_no_image" class="form-group batch_no_image">
<div id="fd_x<?php echo $batch_no_list->RowIndex ?>_image">
<span title="<?php echo $batch_no->image->title() ? $batch_no->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($batch_no->image->ReadOnly || $batch_no->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="batch_no" data-field="x_image" name="x<?php echo $batch_no_list->RowIndex ?>_image" id="x<?php echo $batch_no_list->RowIndex ?>_image"<?php echo $batch_no->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fn_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fa_x<?php echo $batch_no_list->RowIndex ?>_image" value="0">
<input type="hidden" name="fs_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fs_x<?php echo $batch_no_list->RowIndex ?>_image" value="255">
<input type="hidden" name="fx_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fx_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $batch_no_list->RowIndex ?>_image" id= "fm_x<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo $batch_no->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $batch_no_list->RowIndex ?>_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="batch_no" data-field="x_image" name="o<?php echo $batch_no_list->RowIndex ?>_image" id="o<?php echo $batch_no_list->RowIndex ?>_image" value="<?php echo HtmlEncode($batch_no->image->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->operator->Visible) { // operator ?>
		<td data-name="operator">
<input type="hidden" data-table="batch_no" data-field="x_operator" name="o<?php echo $batch_no_list->RowIndex ?>_operator" id="o<?php echo $batch_no_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($batch_no->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<input type="hidden" data-table="batch_no" data-field="x_datetime" name="o<?php echo $batch_no_list->RowIndex ?>_datetime" id="o<?php echo $batch_no_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($batch_no->datetime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator">
<span id="el$rowindex$_batch_no_a_operator" class="form-group batch_no_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_a_operator" data-value-separator="<?php echo $batch_no->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $batch_no_list->RowIndex ?>_a_operator" name="x<?php echo $batch_no_list->RowIndex ?>_a_operator"<?php echo $batch_no->a_operator->editAttributes() ?>>
		<?php echo $batch_no->a_operator->selectOptionListHtml("x<?php echo $batch_no_list->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $batch_no->a_operator->Lookup->getParamTag("p_x" . $batch_no_list->RowIndex . "_a_operator") ?>
</span>
<input type="hidden" data-table="batch_no" data-field="x_a_operator" name="o<?php echo $batch_no_list->RowIndex ?>_a_operator" id="o<?php echo $batch_no_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($batch_no->a_operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime">
<span id="el$rowindex$_batch_no_a_datetime" class="form-group batch_no_a_datetime">
<input type="text" data-table="batch_no" data-field="x_a_datetime" name="x<?php echo $batch_no_list->RowIndex ?>_a_datetime" id="x<?php echo $batch_no_list->RowIndex ?>_a_datetime" placeholder="<?php echo HtmlEncode($batch_no->a_datetime->getPlaceHolder()) ?>" value="<?php echo $batch_no->a_datetime->EditValue ?>"<?php echo $batch_no->a_datetime->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_a_datetime" name="o<?php echo $batch_no_list->RowIndex ?>_a_datetime" id="o<?php echo $batch_no_list->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($batch_no->a_datetime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->process->Visible) { // process ?>
		<td data-name="process">
<span id="el$rowindex$_batch_no_process" class="form-group batch_no_process">
<input type="text" data-table="batch_no" data-field="x_process" name="x<?php echo $batch_no_list->RowIndex ?>_process" id="x<?php echo $batch_no_list->RowIndex ?>_process" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($batch_no->process->getPlaceHolder()) ?>" value="<?php echo $batch_no->process->EditValue ?>"<?php echo $batch_no->process->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_process" name="o<?php echo $batch_no_list->RowIndex ?>_process" id="o<?php echo $batch_no_list->RowIndex ?>_process" value="<?php echo HtmlEncode($batch_no->process->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($batch_no->bom_url->Visible) { // bom_url ?>
		<td data-name="bom_url">
<span id="el$rowindex$_batch_no_bom_url" class="form-group batch_no_bom_url">
<input type="text" data-table="batch_no" data-field="x_bom_url" name="x<?php echo $batch_no_list->RowIndex ?>_bom_url" id="x<?php echo $batch_no_list->RowIndex ?>_bom_url" size="30" maxlength="131" placeholder="<?php echo HtmlEncode($batch_no->bom_url->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom_url->EditValue ?>"<?php echo $batch_no->bom_url->editAttributes() ?>>
</span>
<input type="hidden" data-table="batch_no" data-field="x_bom_url" name="o<?php echo $batch_no_list->RowIndex ?>_bom_url" id="o<?php echo $batch_no_list->RowIndex ?>_bom_url" value="<?php echo HtmlEncode($batch_no->bom_url->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$batch_no_list->ListOptions->render("body", "right", $batch_no_list->RowIndex);
?>
<script>
fbatch_nolist.updateLists(<?php echo $batch_no_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($batch_no->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $batch_no_list->FormKeyCountName ?>" id="<?php echo $batch_no_list->FormKeyCountName ?>" value="<?php echo $batch_no_list->KeyCount ?>">
<?php echo $batch_no_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$batch_no->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($batch_no_list->Recordset)
	$batch_no_list->Recordset->Close();
?>
<?php if (!$batch_no->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$batch_no->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($batch_no_list->Pager)) $batch_no_list->Pager = new PrevNextPager($batch_no_list->StartRec, $batch_no_list->DisplayRecs, $batch_no_list->TotalRecs, $batch_no_list->AutoHidePager) ?>
<?php if ($batch_no_list->Pager->RecordCount > 0 && $batch_no_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($batch_no_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($batch_no_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $batch_no_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($batch_no_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($batch_no_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $batch_no_list->pageUrl() ?>start=<?php echo $batch_no_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $batch_no_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($batch_no_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $batch_no_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $batch_no_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $batch_no_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($batch_no_list->TotalRecs > 0 && (!$batch_no_list->AutoHidePageSizeSelector || $batch_no_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="batch_no">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($batch_no_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($batch_no_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($batch_no_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($batch_no_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($batch_no_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($batch_no->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $batch_no_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($batch_no_list->TotalRecs == 0 && !$batch_no->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $batch_no_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$batch_no_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$batch_no->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$batch_no->isExport()) { ?>
<script>
ew.scrollableTable("gmp_batch_no", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$batch_no_list->terminate();
?>