<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$batch_no_search = new batch_no_search();

// Run the page
$batch_no_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$batch_no_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($batch_no_search->IsModal) { ?>
var fbatch_nosearch = currentAdvancedSearchForm = new ew.Form("fbatch_nosearch", "search");
<?php } else { ?>
var fbatch_nosearch = currentForm = new ew.Form("fbatch_nosearch", "search");
<?php } ?>

// Form_CustomValidate event
fbatch_nosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbatch_nosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbatch_nosearch.lists["x_grp"] = <?php echo $batch_no_search->grp->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_grp"].options = <?php echo JsonEncode($batch_no_search->grp->lookupOptions()) ?>;
fbatch_nosearch.lists["x_s_grp"] = <?php echo $batch_no_search->s_grp->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_s_grp"].options = <?php echo JsonEncode($batch_no_search->s_grp->lookupOptions()) ?>;
fbatch_nosearch.lists["x_product"] = <?php echo $batch_no_search->product->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_product"].options = <?php echo JsonEncode($batch_no_search->product->lookupOptions()) ?>;
fbatch_nosearch.lists["x_rid"] = <?php echo $batch_no_search->rid->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_rid"].options = <?php echo JsonEncode($batch_no_search->rid->lookupOptions()) ?>;
fbatch_nosearch.lists["x_packing_type"] = <?php echo $batch_no_search->packing_type->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_packing_type"].options = <?php echo JsonEncode($batch_no_search->packing_type->lookupOptions()) ?>;
fbatch_nosearch.lists["x_status"] = <?php echo $batch_no_search->status->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_status"].options = <?php echo JsonEncode($batch_no_search->status->options(FALSE, TRUE)) ?>;
fbatch_nosearch.lists["x_a_operator"] = <?php echo $batch_no_search->a_operator->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_a_operator"].options = <?php echo JsonEncode($batch_no_search->a_operator->lookupOptions()) ?>;
fbatch_nosearch.lists["x_process_id_tmp[]"] = <?php echo $batch_no_search->process_id_tmp->Lookup->toClientList() ?>;
fbatch_nosearch.lists["x_process_id_tmp[]"].options = <?php echo JsonEncode($batch_no_search->process_id_tmp->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbatch_nosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($batch_no->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $batch_no_search->showPageHeader(); ?>
<?php
$batch_no_search->showMessage();
?>
<form name="fbatch_nosearch" id="fbatch_nosearch" class="<?php echo $batch_no_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($batch_no_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $batch_no_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="batch_no">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$batch_no_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($batch_no->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_id"><?php echo $batch_no->id->caption() ?></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_id" id="z_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($batch_no->id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_batch_no_id">
<input type="text" data-table="batch_no" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($batch_no->id->getPlaceHolder()) ?>" value="<?php echo $batch_no->id->EditValue ?>"<?php echo $batch_no->id->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_batch_no_id" class="btw1_id d-none">
<input type="text" data-table="batch_no" data-field="x_id" name="y_id" id="y_id" placeholder="<?php echo HtmlEncode($batch_no->id->getPlaceHolder()) ?>" value="<?php echo $batch_no->id->EditValue2 ?>"<?php echo $batch_no->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_grp"><?php echo $batch_no->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->grp->cellAttributes() ?>>
			<span id="el_batch_no_grp">
<?php $batch_no->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$batch_no->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_grp" data-value-separator="<?php echo $batch_no->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $batch_no->grp->editAttributes() ?>>
		<?php echo $batch_no->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $batch_no->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_s_grp"><?php echo $batch_no->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->s_grp->cellAttributes() ?>>
			<span id="el_batch_no_s_grp">
<?php $batch_no->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$batch_no->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_s_grp" data-value-separator="<?php echo $batch_no->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $batch_no->s_grp->editAttributes() ?>>
		<?php echo $batch_no->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $batch_no->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_product"><?php echo $batch_no->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->product->cellAttributes() ?>>
			<span id="el_batch_no_product">
<?php $batch_no->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$batch_no->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_product" data-value-separator="<?php echo $batch_no->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $batch_no->product->editAttributes() ?>>
		<?php echo $batch_no->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $batch_no->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_rid"><?php echo $batch_no->rid->caption() ?></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->rid->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_rid" id="z_rid" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($batch_no->rid->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_batch_no_rid">
<div id="tp_x_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="batch_no" data-field="x_rid" data-value-separator="<?php echo $batch_no->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="{value}"<?php echo $batch_no->rid->editAttributes() ?>></div>
<div id="dsl_x_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $batch_no->rid->radioButtonListHtml(FALSE, "x_rid") ?>
</div></div>
<?php echo $batch_no->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
			<span class="ew-search-cond btw1_rid d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_batch_no_rid" class="btw1_rid d-none">
<div id="tp_y_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="batch_no" data-field="x_rid" data-value-separator="<?php echo $batch_no->rid->displayValueSeparatorAttribute() ?>" name="y_rid" id="y_rid" value="{value}"<?php echo $batch_no->rid->editAttributes() ?>></div>
<div id="dsl_y_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $batch_no->rid->radioButtonListHtml(FALSE, "y_rid") ?>
</div></div>
<?php echo $batch_no->rid->Lookup->getParamTag("p_y_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_packing_type"><?php echo $batch_no->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->packing_type->cellAttributes() ?>>
			<span id="el_batch_no_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_packing_type" data-value-separator="<?php echo $batch_no->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $batch_no->packing_type->editAttributes() ?>>
		<?php echo $batch_no->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $batch_no->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_batch_no"><?php echo $batch_no->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->batch_no->cellAttributes() ?>>
			<span id="el_batch_no_batch_no">
<input type="text" data-table="batch_no" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" maxlength="36" placeholder="<?php echo HtmlEncode($batch_no->batch_no->getPlaceHolder()) ?>" value="<?php echo $batch_no->batch_no->EditValue ?>"<?php echo $batch_no->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_description"><?php echo $batch_no->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->description->cellAttributes() ?>>
			<span id="el_batch_no_description">
<input type="text" data-table="batch_no" data-field="x_description" name="x_description" id="x_description" size="30" placeholder="<?php echo HtmlEncode($batch_no->description->getPlaceHolder()) ?>" value="<?php echo $batch_no->description->EditValue ?>"<?php echo $batch_no->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label for="x_payment" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_payment"><?php echo $batch_no->payment->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment" id="z_payment" value="LIKE"></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->payment->cellAttributes() ?>>
			<span id="el_batch_no_payment">
<input type="text" data-table="batch_no" data-field="x_payment" name="x_payment" id="x_payment" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($batch_no->payment->getPlaceHolder()) ?>" value="<?php echo $batch_no->payment->EditValue ?>"<?php echo $batch_no->payment->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_remarks"><?php echo $batch_no->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->remarks->cellAttributes() ?>>
			<span id="el_batch_no_remarks">
<input type="text" data-table="batch_no" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($batch_no->remarks->getPlaceHolder()) ?>" value="<?php echo $batch_no->remarks->EditValue ?>"<?php echo $batch_no->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_status"><?php echo $batch_no->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->status->cellAttributes() ?>>
			<span id="el_batch_no_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_status" data-value-separator="<?php echo $batch_no->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $batch_no->status->editAttributes() ?>>
		<?php echo $batch_no->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_image"><?php echo $batch_no->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->image->cellAttributes() ?>>
			<span id="el_batch_no_image">
<input type="text" data-table="batch_no" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($batch_no->image->getPlaceHolder()) ?>" value="<?php echo $batch_no->image->EditValue ?>"<?php echo $batch_no->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_a_operator"><?php echo $batch_no->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->a_operator->cellAttributes() ?>>
			<span id="el_batch_no_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="batch_no" data-field="x_a_operator" data-value-separator="<?php echo $batch_no->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $batch_no->a_operator->editAttributes() ?>>
		<?php echo $batch_no->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $batch_no->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->process_id_tmp->Visible) { // process_id_tmp ?>
	<div id="r_process_id_tmp" class="form-group row">
		<label class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_process_id_tmp"><?php echo $batch_no->process_id_tmp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_id_tmp" id="z_process_id_tmp" value="LIKE"></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->process_id_tmp->cellAttributes() ?>>
			<span id="el_batch_no_process_id_tmp">
<div id="tp_x_process_id_tmp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="batch_no" data-field="x_process_id_tmp" data-value-separator="<?php echo $batch_no->process_id_tmp->displayValueSeparatorAttribute() ?>" name="x_process_id_tmp[]" id="x_process_id_tmp[]" value="{value}"<?php echo $batch_no->process_id_tmp->editAttributes() ?>></div>
<div id="dsl_x_process_id_tmp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $batch_no->process_id_tmp->checkBoxListHtml(FALSE, "x_process_id_tmp[]") ?>
</div></div>
<?php echo $batch_no->process_id_tmp->Lookup->getParamTag("p_x_process_id_tmp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($batch_no->bom_url->Visible) { // bom_url ?>
	<div id="r_bom_url" class="form-group row">
		<label for="x_bom_url" class="<?php echo $batch_no_search->LeftColumnClass ?>"><span id="elh_batch_no_bom_url"><?php echo $batch_no->bom_url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bom_url" id="z_bom_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $batch_no_search->RightColumnClass ?>"><div<?php echo $batch_no->bom_url->cellAttributes() ?>>
			<span id="el_batch_no_bom_url">
<input type="text" data-table="batch_no" data-field="x_bom_url" name="x_bom_url" id="x_bom_url" size="30" maxlength="131" placeholder="<?php echo HtmlEncode($batch_no->bom_url->getPlaceHolder()) ?>" value="<?php echo $batch_no->bom_url->EditValue ?>"<?php echo $batch_no->bom_url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$batch_no_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $batch_no_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$batch_no_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$batch_no_search->terminate();
?>