<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$batch_no_view = new batch_no_view();

// Run the page
$batch_no_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$batch_no_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$batch_no->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbatch_noview = currentForm = new ew.Form("fbatch_noview", "view");

// Form_CustomValidate event
fbatch_noview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbatch_noview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbatch_noview.lists["x_grp"] = <?php echo $batch_no_view->grp->Lookup->toClientList() ?>;
fbatch_noview.lists["x_grp"].options = <?php echo JsonEncode($batch_no_view->grp->lookupOptions()) ?>;
fbatch_noview.lists["x_s_grp"] = <?php echo $batch_no_view->s_grp->Lookup->toClientList() ?>;
fbatch_noview.lists["x_s_grp"].options = <?php echo JsonEncode($batch_no_view->s_grp->lookupOptions()) ?>;
fbatch_noview.lists["x_product"] = <?php echo $batch_no_view->product->Lookup->toClientList() ?>;
fbatch_noview.lists["x_product"].options = <?php echo JsonEncode($batch_no_view->product->lookupOptions()) ?>;
fbatch_noview.lists["x_rid"] = <?php echo $batch_no_view->rid->Lookup->toClientList() ?>;
fbatch_noview.lists["x_rid"].options = <?php echo JsonEncode($batch_no_view->rid->lookupOptions()) ?>;
fbatch_noview.lists["x_packing_type"] = <?php echo $batch_no_view->packing_type->Lookup->toClientList() ?>;
fbatch_noview.lists["x_packing_type"].options = <?php echo JsonEncode($batch_no_view->packing_type->lookupOptions()) ?>;
fbatch_noview.lists["x_status"] = <?php echo $batch_no_view->status->Lookup->toClientList() ?>;
fbatch_noview.lists["x_status"].options = <?php echo JsonEncode($batch_no_view->status->options(FALSE, TRUE)) ?>;
fbatch_noview.lists["x_operator"] = <?php echo $batch_no_view->operator->Lookup->toClientList() ?>;
fbatch_noview.lists["x_operator"].options = <?php echo JsonEncode($batch_no_view->operator->lookupOptions()) ?>;
fbatch_noview.lists["x_a_operator"] = <?php echo $batch_no_view->a_operator->Lookup->toClientList() ?>;
fbatch_noview.lists["x_a_operator"].options = <?php echo JsonEncode($batch_no_view->a_operator->lookupOptions()) ?>;
fbatch_noview.lists["x_process_id_tmp[]"] = <?php echo $batch_no_view->process_id_tmp->Lookup->toClientList() ?>;
fbatch_noview.lists["x_process_id_tmp[]"].options = <?php echo JsonEncode($batch_no_view->process_id_tmp->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$batch_no->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $batch_no_view->ExportOptions->render("body") ?>
<?php $batch_no_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $batch_no_view->showPageHeader(); ?>
<?php
$batch_no_view->showMessage();
?>
<form name="fbatch_noview" id="fbatch_noview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($batch_no_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $batch_no_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="batch_no">
<input type="hidden" name="modal" value="<?php echo (int)$batch_no_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($batch_no->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_id"><?php echo $batch_no->id->caption() ?></span></td>
		<td data-name="id"<?php echo $batch_no->id->cellAttributes() ?>>
<span id="el_batch_no_id">
<span<?php echo $batch_no->id->viewAttributes() ?>>
<?php echo $batch_no->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_grp"><?php echo $batch_no->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $batch_no->grp->cellAttributes() ?>>
<span id="el_batch_no_grp">
<span<?php echo $batch_no->grp->viewAttributes() ?>>
<?php echo $batch_no->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_s_grp"><?php echo $batch_no->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $batch_no->s_grp->cellAttributes() ?>>
<span id="el_batch_no_s_grp">
<span<?php echo $batch_no->s_grp->viewAttributes() ?>>
<?php echo $batch_no->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_product"><?php echo $batch_no->product->caption() ?></span></td>
		<td data-name="product"<?php echo $batch_no->product->cellAttributes() ?>>
<span id="el_batch_no_product">
<span<?php echo $batch_no->product->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->product->getViewValue())) && $batch_no->product->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->product->linkAttributes() ?>><?php echo $batch_no->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_rid"><?php echo $batch_no->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $batch_no->rid->cellAttributes() ?>>
<span id="el_batch_no_rid">
<span<?php echo $batch_no->rid->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->rid->getViewValue())) && $batch_no->rid->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->rid->linkAttributes() ?>><?php echo $batch_no->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_packing_type"><?php echo $batch_no->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $batch_no->packing_type->cellAttributes() ?>>
<span id="el_batch_no_packing_type">
<span<?php echo $batch_no->packing_type->viewAttributes() ?>>
<?php echo $batch_no->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_batch_no"><?php echo $batch_no->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $batch_no->batch_no->cellAttributes() ?>>
<span id="el_batch_no_batch_no">
<span<?php echo $batch_no->batch_no->viewAttributes() ?>>
<?php echo $batch_no->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_description"><?php echo $batch_no->description->caption() ?></span></td>
		<td data-name="description"<?php echo $batch_no->description->cellAttributes() ?>>
<span id="el_batch_no_description">
<span<?php echo $batch_no->description->viewAttributes() ?>>
<?php echo $batch_no->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->bom->Visible) { // bom ?>
	<tr id="r_bom">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_bom"><?php echo $batch_no->bom->caption() ?></span></td>
		<td data-name="bom"<?php echo $batch_no->bom->cellAttributes() ?>>
<span id="el_batch_no_bom">
<span<?php echo $batch_no->bom->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->bom->getViewValue())) && $batch_no->bom->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->bom->linkAttributes() ?>><?php echo $batch_no->bom->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->bom->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->ted->Visible) { // ted ?>
	<tr id="r_ted">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_ted"><?php echo $batch_no->ted->caption() ?></span></td>
		<td data-name="ted"<?php echo $batch_no->ted->cellAttributes() ?>>
<span id="el_batch_no_ted">
<span<?php echo $batch_no->ted->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->ted->getViewValue())) && $batch_no->ted->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->ted->linkAttributes() ?>><?php echo $batch_no->ted->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->ted->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->payment->Visible) { // payment ?>
	<tr id="r_payment">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_payment"><?php echo $batch_no->payment->caption() ?></span></td>
		<td data-name="payment"<?php echo $batch_no->payment->cellAttributes() ?>>
<span id="el_batch_no_payment">
<span<?php echo $batch_no->payment->viewAttributes() ?>>
<?php if ((!EmptyString($batch_no->payment->getViewValue())) && $batch_no->payment->linkAttributes() <> "") { ?>
<a<?php echo $batch_no->payment->linkAttributes() ?>><?php echo $batch_no->payment->getViewValue() ?></a>
<?php } else { ?>
<?php echo $batch_no->payment->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_remarks"><?php echo $batch_no->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $batch_no->remarks->cellAttributes() ?>>
<span id="el_batch_no_remarks">
<span<?php echo $batch_no->remarks->viewAttributes() ?>>
<?php echo $batch_no->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_status"><?php echo $batch_no->status->caption() ?></span></td>
		<td data-name="status"<?php echo $batch_no->status->cellAttributes() ?>>
<span id="el_batch_no_status">
<span<?php echo $batch_no->status->viewAttributes() ?>>
<?php echo $batch_no->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_image"><?php echo $batch_no->image->caption() ?></span></td>
		<td data-name="image"<?php echo $batch_no->image->cellAttributes() ?>>
<span id="el_batch_no_image">
<span>
<?php echo GetFileViewTag($batch_no->image, $batch_no->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_operator"><?php echo $batch_no->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $batch_no->operator->cellAttributes() ?>>
<span id="el_batch_no_operator">
<span<?php echo $batch_no->operator->viewAttributes() ?>>
<?php echo $batch_no->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_datetime"><?php echo $batch_no->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $batch_no->datetime->cellAttributes() ?>>
<span id="el_batch_no_datetime">
<span<?php echo $batch_no->datetime->viewAttributes() ?>>
<?php echo $batch_no->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->a_operator->Visible) { // a_operator ?>
	<tr id="r_a_operator">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_a_operator"><?php echo $batch_no->a_operator->caption() ?></span></td>
		<td data-name="a_operator"<?php echo $batch_no->a_operator->cellAttributes() ?>>
<span id="el_batch_no_a_operator">
<span<?php echo $batch_no->a_operator->viewAttributes() ?>>
<?php echo $batch_no->a_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->a_datetime->Visible) { // a_datetime ?>
	<tr id="r_a_datetime">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_a_datetime"><?php echo $batch_no->a_datetime->caption() ?></span></td>
		<td data-name="a_datetime"<?php echo $batch_no->a_datetime->cellAttributes() ?>>
<span id="el_batch_no_a_datetime">
<span<?php echo $batch_no->a_datetime->viewAttributes() ?>>
<?php echo $batch_no->a_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->process_id_tmp->Visible) { // process_id_tmp ?>
	<tr id="r_process_id_tmp">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_process_id_tmp"><?php echo $batch_no->process_id_tmp->caption() ?></span></td>
		<td data-name="process_id_tmp"<?php echo $batch_no->process_id_tmp->cellAttributes() ?>>
<span id="el_batch_no_process_id_tmp">
<span<?php echo $batch_no->process_id_tmp->viewAttributes() ?>>
<?php echo $batch_no->process_id_tmp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($batch_no->bom_url->Visible) { // bom_url ?>
	<tr id="r_bom_url">
		<td class="<?php echo $batch_no_view->TableLeftColumnClass ?>"><span id="elh_batch_no_bom_url"><?php echo $batch_no->bom_url->caption() ?></span></td>
		<td data-name="bom_url"<?php echo $batch_no->bom_url->cellAttributes() ?>>
<span id="el_batch_no_bom_url">
<span<?php echo $batch_no->bom_url->viewAttributes() ?>>
<?php echo $batch_no->bom_url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php
	if (in_array("bom", explode(",", $batch_no->getCurrentDetailTable())) && $bom->DetailView) {
?>
<?php if ($batch_no->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("bom", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "bomgrid.php" ?>
<?php } ?>
<?php
	if (in_array("production_process", explode(",", $batch_no->getCurrentDetailTable())) && $production_process->DetailView) {
?>
<?php if ($batch_no->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("production_process", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "production_processgrid.php" ?>
<?php } ?>
</form>
<?php
$batch_no_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$batch_no->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$batch_no_view->terminate();
?>