<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_old_list = new bcode_old_list();

// Run the page
$bcode_old_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_old_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bcode_old->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbcode_oldlist = currentForm = new ew.Form("fbcode_oldlist", "list");
fbcode_oldlist.formKeyCountName = '<?php echo $bcode_old_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbcode_oldlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_oldlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_oldlist.lists["x_weaving_works"] = <?php echo $bcode_old_list->weaving_works->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_old_list->weaving_works->lookupOptions()) ?>;
fbcode_oldlist.lists["x_current_works"] = <?php echo $bcode_old_list->current_works->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_current_works"].options = <?php echo JsonEncode($bcode_old_list->current_works->lookupOptions()) ?>;
fbcode_oldlist.lists["x_buyers_id"] = <?php echo $bcode_old_list->buyers_id->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_old_list->buyers_id->lookupOptions()) ?>;
fbcode_oldlist.lists["x_buyer_ref"] = <?php echo $bcode_old_list->buyer_ref->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_old_list->buyer_ref->lookupOptions()) ?>;
fbcode_oldlist.lists["x_design_id"] = <?php echo $bcode_old_list->design_id->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_design_id"].options = <?php echo JsonEncode($bcode_old_list->design_id->lookupOptions()) ?>;
fbcode_oldlist.lists["x_batch_no"] = <?php echo $bcode_old_list->batch_no->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_batch_no"].options = <?php echo JsonEncode($bcode_old_list->batch_no->lookupOptions()) ?>;
fbcode_oldlist.lists["x_shape"] = <?php echo $bcode_old_list->shape->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_shape"].options = <?php echo JsonEncode($bcode_old_list->shape->lookupOptions()) ?>;
fbcode_oldlist.lists["x_cs"] = <?php echo $bcode_old_list->cs->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_cs"].options = <?php echo JsonEncode($bcode_old_list->cs->options(FALSE, TRUE)) ?>;
fbcode_oldlist.lists["x_product_type"] = <?php echo $bcode_old_list->product_type->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_product_type"].options = <?php echo JsonEncode($bcode_old_list->product_type->options(FALSE, TRUE)) ?>;
fbcode_oldlist.lists["x_despatch_week"] = <?php echo $bcode_old_list->despatch_week->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_old_list->despatch_week->lookupOptions()) ?>;
fbcode_oldlist.lists["x_status"] = <?php echo $bcode_old_list->status->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_status"].options = <?php echo JsonEncode($bcode_old_list->status->lookupOptions()) ?>;
fbcode_oldlist.lists["x_completed"] = <?php echo $bcode_old_list->completed->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_completed"].options = <?php echo JsonEncode($bcode_old_list->completed->options(FALSE, TRUE)) ?>;
fbcode_oldlist.lists["x_process_d[]"] = <?php echo $bcode_old_list->process_d->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_process_d[]"].options = <?php echo JsonEncode($bcode_old_list->process_d->lookupOptions()) ?>;
fbcode_oldlist.lists["x_category"] = <?php echo $bcode_old_list->category->Lookup->toClientList() ?>;
fbcode_oldlist.lists["x_category"].options = <?php echo JsonEncode($bcode_old_list->category->lookupOptions()) ?>;

// Form object for search
var fbcode_oldlistsrch = currentSearchForm = new ew.Form("fbcode_oldlistsrch");

// Validate function for search
fbcode_oldlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbcode_oldlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_oldlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_oldlistsrch.lists["x_current_works"] = <?php echo $bcode_old_list->current_works->Lookup->toClientList() ?>;
fbcode_oldlistsrch.lists["x_current_works"].options = <?php echo JsonEncode($bcode_old_list->current_works->lookupOptions()) ?>;
fbcode_oldlistsrch.lists["x_status"] = <?php echo $bcode_old_list->status->Lookup->toClientList() ?>;
fbcode_oldlistsrch.lists["x_status"].options = <?php echo JsonEncode($bcode_old_list->status->lookupOptions()) ?>;

// Filters
fbcode_oldlistsrch.filterList = <?php echo $bcode_old_list->getFilterList() ?>;

// Init search panel as collapsed
fbcode_oldlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bcode_old->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($bcode_old_list->TotalRecs > 0 && $bcode_old_list->ExportOptions->visible()) { ?>
<?php $bcode_old_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_old_list->ImportOptions->visible()) { ?>
<?php $bcode_old_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_old_list->SearchOptions->visible()) { ?>
<?php $bcode_old_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_old_list->FilterOptions->visible()) { ?>
<?php $bcode_old_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$bcode_old_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$bcode_old->isExport() && !$bcode_old->CurrentAction) { ?>
<form name="fbcode_oldlistsrch" id="fbcode_oldlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($bcode_old_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbcode_oldlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bcode_old">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$bcode_old_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$bcode_old->RowType = ROWTYPE_SEARCH;

// Render row
$bcode_old->resetAttributes();
$bcode_old_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($bcode_old->current_works->Visible) { // current_works ?>
	<div id="xsc_current_works" class="ew-cell form-group">
		<label for="x_current_works" class="ew-search-caption ew-label"><?php echo $bcode_old->current_works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_current_works" data-value-separator="<?php echo $bcode_old->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $bcode_old->current_works->editAttributes() ?>>
		<?php echo $bcode_old->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $bcode_old->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
	</div>
<?php } ?>
<?php if ($bcode_old->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $bcode_old->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode_old" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($bcode_old->po->getPlaceHolder()) ?>" value="<?php echo $bcode_old->po->EditValue ?>"<?php echo $bcode_old->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="bcode_old" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($bcode_old->po->getPlaceHolder()) ?>" value="<?php echo $bcode_old->po->EditValue2 ?>"<?php echo $bcode_old->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($bcode_old->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $bcode_old->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode_old" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_old->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_barcode->EditValue ?>"<?php echo $bcode_old->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="bcode_old" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_old->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_barcode->EditValue2 ?>"<?php echo $bcode_old->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($bcode_old->buyer_uid->Visible) { // buyer_uid ?>
	<div id="xsc_buyer_uid" class="ew-cell form-group">
		<label for="x_buyer_uid" class="ew-search-caption ew-label"><?php echo $bcode_old->buyer_uid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode_old" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_old->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_old->buyer_uid->EditValue ?>"<?php echo $bcode_old->buyer_uid->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($bcode_old->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $bcode_old->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_status" data-value-separator="<?php echo $bcode_old->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode_old->status->editAttributes() ?>>
		<?php echo $bcode_old->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $bcode_old->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($bcode_old_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($bcode_old_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $bcode_old_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($bcode_old_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($bcode_old_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($bcode_old_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($bcode_old_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bcode_old_list->showPageHeader(); ?>
<?php
$bcode_old_list->showMessage();
?>
<?php if ($bcode_old_list->TotalRecs > 0 || $bcode_old->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($bcode_old_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> bcode_old">
<?php if (!$bcode_old->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$bcode_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_old_list->Pager)) $bcode_old_list->Pager = new PrevNextPager($bcode_old_list->StartRec, $bcode_old_list->DisplayRecs, $bcode_old_list->TotalRecs, $bcode_old_list->AutoHidePager) ?>
<?php if ($bcode_old_list->Pager->RecordCount > 0 && $bcode_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_old_list->TotalRecs > 0 && (!$bcode_old_list->AutoHidePageSizeSelector || $bcode_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbcode_oldlist" id="fbcode_oldlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_old_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_old_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_old">
<div id="gmp_bcode_old" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($bcode_old_list->TotalRecs > 0 || $bcode_old->isGridEdit()) { ?>
<table id="tbl_bcode_oldlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$bcode_old_list->RowType = ROWTYPE_HEADER;

// Render list options
$bcode_old_list->renderListOptions();

// Render list options (header, left)
$bcode_old_list->ListOptions->render("header", "left");
?>
<?php if ($bcode_old->weaving_works->Visible) { // weaving_works ?>
	<?php if ($bcode_old->sortUrl($bcode_old->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $bcode_old->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old_weaving_works" class="bcode_old_weaving_works"><div class="ew-table-header-caption"><?php echo $bcode_old->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $bcode_old->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->weaving_works) ?>',2);"><div id="elh_bcode_old_weaving_works" class="bcode_old_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->current_works->Visible) { // current_works ?>
	<?php if ($bcode_old->sortUrl($bcode_old->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $bcode_old->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old_current_works" class="bcode_old_current_works"><div class="ew-table-header-caption"><?php echo $bcode_old->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $bcode_old->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->current_works) ?>',2);"><div id="elh_bcode_old_current_works" class="bcode_old_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->po->Visible) { // po ?>
	<?php if ($bcode_old->sortUrl($bcode_old->po) == "") { ?>
		<th data-name="po" class="<?php echo $bcode_old->po->headerCellClass() ?>"><div id="elh_bcode_old_po" class="bcode_old_po"><div class="ew-table-header-caption"><?php echo $bcode_old->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $bcode_old->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->po) ?>',2);"><div id="elh_bcode_old_po" class="bcode_old_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_barcode->Visible) { // barcode ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $bcode_old->_barcode->headerCellClass() ?>" style="width: 300px;"><div id="elh_bcode_old__barcode" class="bcode_old__barcode"><div class="ew-table-header-caption"><?php echo $bcode_old->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $bcode_old->_barcode->headerCellClass() ?>" style="width: 300px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_barcode) ?>',2);"><div id="elh_bcode_old__barcode" class="bcode_old__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->buyers_id->Visible) { // buyers_id ?>
	<?php if ($bcode_old->sortUrl($bcode_old->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $bcode_old->buyers_id->headerCellClass() ?>"><div id="elh_bcode_old_buyers_id" class="bcode_old_buyers_id"><div class="ew-table-header-caption"><?php echo $bcode_old->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $bcode_old->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->buyers_id) ?>',2);"><div id="elh_bcode_old_buyers_id" class="bcode_old_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($bcode_old->sortUrl($bcode_old->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $bcode_old->buyer_ref->headerCellClass() ?>"><div id="elh_bcode_old_buyer_ref" class="bcode_old_buyer_ref"><div class="ew-table-header-caption"><?php echo $bcode_old->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $bcode_old->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->buyer_ref) ?>',2);"><div id="elh_bcode_old_buyer_ref" class="bcode_old_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->buyer_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->design_id->Visible) { // design_id ?>
	<?php if ($bcode_old->sortUrl($bcode_old->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $bcode_old->design_id->headerCellClass() ?>"><div id="elh_bcode_old_design_id" class="bcode_old_design_id"><div class="ew-table-header-caption"><?php echo $bcode_old->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $bcode_old->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->design_id) ?>',2);"><div id="elh_bcode_old_design_id" class="bcode_old_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->batch_no->Visible) { // batch_no ?>
	<?php if ($bcode_old->sortUrl($bcode_old->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $bcode_old->batch_no->headerCellClass() ?>"><div id="elh_bcode_old_batch_no" class="bcode_old_batch_no"><div class="ew-table-header-caption"><?php echo $bcode_old->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $bcode_old->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->batch_no) ?>',2);"><div id="elh_bcode_old_batch_no" class="bcode_old_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->sqm->Visible) { // sqm ?>
	<?php if ($bcode_old->sortUrl($bcode_old->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $bcode_old->sqm->headerCellClass() ?>"><div id="elh_bcode_old_sqm" class="bcode_old_sqm"><div class="ew-table-header-caption"><?php echo $bcode_old->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $bcode_old->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->sqm) ?>',2);"><div id="elh_bcode_old_sqm" class="bcode_old_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->shape->Visible) { // shape ?>
	<?php if ($bcode_old->sortUrl($bcode_old->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $bcode_old->shape->headerCellClass() ?>"><div id="elh_bcode_old_shape" class="bcode_old_shape"><div class="ew-table-header-caption"><?php echo $bcode_old->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $bcode_old->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->shape) ?>',2);"><div id="elh_bcode_old_shape" class="bcode_old_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->cs->Visible) { // cs ?>
	<?php if ($bcode_old->sortUrl($bcode_old->cs) == "") { ?>
		<th data-name="cs" class="<?php echo $bcode_old->cs->headerCellClass() ?>"><div id="elh_bcode_old_cs" class="bcode_old_cs"><div class="ew-table-header-caption"><?php echo $bcode_old->cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs" class="<?php echo $bcode_old->cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->cs) ?>',2);"><div id="elh_bcode_old_cs" class="bcode_old_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->product_type->Visible) { // product_type ?>
	<?php if ($bcode_old->sortUrl($bcode_old->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $bcode_old->product_type->headerCellClass() ?>"><div id="elh_bcode_old_product_type" class="bcode_old_product_type"><div class="ew-table-header-caption"><?php echo $bcode_old->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $bcode_old->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->product_type) ?>',2);"><div id="elh_bcode_old_product_type" class="bcode_old_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->size_cm->Visible) { // size_cm ?>
	<?php if ($bcode_old->sortUrl($bcode_old->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $bcode_old->size_cm->headerCellClass() ?>"><div id="elh_bcode_old_size_cm" class="bcode_old_size_cm"><div class="ew-table-header-caption"><?php echo $bcode_old->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $bcode_old->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->size_cm) ?>',2);"><div id="elh_bcode_old_size_cm" class="bcode_old_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->buyer_uid->Visible) { // buyer_uid ?>
	<?php if ($bcode_old->sortUrl($bcode_old->buyer_uid) == "") { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode_old->buyer_uid->headerCellClass() ?>" style="width: 200px;"><div id="elh_bcode_old_buyer_uid" class="bcode_old_buyer_uid"><div class="ew-table-header-caption"><?php echo $bcode_old->buyer_uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode_old->buyer_uid->headerCellClass() ?>" style="width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->buyer_uid) ?>',2);"><div id="elh_bcode_old_buyer_uid" class="bcode_old_buyer_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->buyer_uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->buyer_uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->buyer_uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->buyer_loc->Visible) { // buyer_loc ?>
	<?php if ($bcode_old->sortUrl($bcode_old->buyer_loc) == "") { ?>
		<th data-name="buyer_loc" class="<?php echo $bcode_old->buyer_loc->headerCellClass() ?>"><div id="elh_bcode_old_buyer_loc" class="bcode_old_buyer_loc"><div class="ew-table-header-caption"><?php echo $bcode_old->buyer_loc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_loc" class="<?php echo $bcode_old->buyer_loc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->buyer_loc) ?>',2);"><div id="elh_bcode_old_buyer_loc" class="bcode_old_buyer_loc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->buyer_loc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->buyer_loc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->buyer_loc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->quantity->Visible) { // quantity ?>
	<?php if ($bcode_old->sortUrl($bcode_old->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $bcode_old->quantity->headerCellClass() ?>"><div id="elh_bcode_old_quantity" class="bcode_old_quantity"><div class="ew-table-header-caption"><?php echo $bcode_old->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $bcode_old->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->quantity) ?>',2);"><div id="elh_bcode_old_quantity" class="bcode_old_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->po_price->Visible) { // po_price ?>
	<?php if ($bcode_old->sortUrl($bcode_old->po_price) == "") { ?>
		<th data-name="po_price" class="<?php echo $bcode_old->po_price->headerCellClass() ?>"><div id="elh_bcode_old_po_price" class="bcode_old_po_price"><div class="ew-table-header-caption"><?php echo $bcode_old->po_price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_price" class="<?php echo $bcode_old->po_price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->po_price) ?>',2);"><div id="elh_bcode_old_po_price" class="bcode_old_po_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->po_price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->po_price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->po_price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->despatch_week->Visible) { // despatch_week ?>
	<?php if ($bcode_old->sortUrl($bcode_old->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $bcode_old->despatch_week->headerCellClass() ?>"><div id="elh_bcode_old_despatch_week" class="bcode_old_despatch_week"><div class="ew-table-header-caption"><?php echo $bcode_old->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $bcode_old->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->despatch_week) ?>',2);"><div id="elh_bcode_old_despatch_week" class="bcode_old_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->despatch_date->Visible) { // despatch_date ?>
	<?php if ($bcode_old->sortUrl($bcode_old->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $bcode_old->despatch_date->headerCellClass() ?>"><div id="elh_bcode_old_despatch_date" class="bcode_old_despatch_date"><div class="ew-table-header-caption"><?php echo $bcode_old->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $bcode_old->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->despatch_date) ?>',2);"><div id="elh_bcode_old_despatch_date" class="bcode_old_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->status->Visible) { // status ?>
	<?php if ($bcode_old->sortUrl($bcode_old->status) == "") { ?>
		<th data-name="status" class="<?php echo $bcode_old->status->headerCellClass() ?>"><div id="elh_bcode_old_status" class="bcode_old_status"><div class="ew-table-header-caption"><?php echo $bcode_old->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $bcode_old->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->status) ?>',2);"><div id="elh_bcode_old_status" class="bcode_old_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->completed->Visible) { // completed ?>
	<?php if ($bcode_old->sortUrl($bcode_old->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $bcode_old->completed->headerCellClass() ?>"><div id="elh_bcode_old_completed" class="bcode_old_completed"><div class="ew-table-header-caption"><?php echo $bcode_old->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $bcode_old->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->completed) ?>',2);"><div id="elh_bcode_old_completed" class="bcode_old_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->buyer_po->Visible) { // buyer_po ?>
	<?php if ($bcode_old->sortUrl($bcode_old->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $bcode_old->buyer_po->headerCellClass() ?>"><div id="elh_bcode_old_buyer_po" class="bcode_old_buyer_po"><div class="ew-table-header-caption"><?php echo $bcode_old->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $bcode_old->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->buyer_po) ?>',2);"><div id="elh_bcode_old_buyer_po" class="bcode_old_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->process_d->Visible) { // process_d ?>
	<?php if ($bcode_old->sortUrl($bcode_old->process_d) == "") { ?>
		<th data-name="process_d" class="<?php echo $bcode_old->process_d->headerCellClass() ?>"><div id="elh_bcode_old_process_d" class="bcode_old_process_d"><div class="ew-table-header-caption"><?php echo $bcode_old->process_d->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_d" class="<?php echo $bcode_old->process_d->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->process_d) ?>',2);"><div id="elh_bcode_old_process_d" class="bcode_old_process_d">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->process_d->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->process_d->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->process_d->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->weight->Visible) { // weight ?>
	<?php if ($bcode_old->sortUrl($bcode_old->weight) == "") { ?>
		<th data-name="weight" class="<?php echo $bcode_old->weight->headerCellClass() ?>"><div id="elh_bcode_old_weight" class="bcode_old_weight"><div class="ew-table-header-caption"><?php echo $bcode_old->weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight" class="<?php echo $bcode_old->weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->weight) ?>',2);"><div id="elh_bcode_old_weight" class="bcode_old_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->po_currency->Visible) { // po_currency ?>
	<?php if ($bcode_old->sortUrl($bcode_old->po_currency) == "") { ?>
		<th data-name="po_currency" class="<?php echo $bcode_old->po_currency->headerCellClass() ?>"><div id="elh_bcode_old_po_currency" class="bcode_old_po_currency"><div class="ew-table-header-caption"><?php echo $bcode_old->po_currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_currency" class="<?php echo $bcode_old->po_currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->po_currency) ?>',2);"><div id="elh_bcode_old_po_currency" class="bcode_old_po_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->po_currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->po_currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->po_currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<?php if ($bcode_old->sortUrl($bcode_old->dispatch_week_p) == "") { ?>
		<th data-name="dispatch_week_p" class="<?php echo $bcode_old->dispatch_week_p->headerCellClass() ?>"><div id="elh_bcode_old_dispatch_week_p" class="bcode_old_dispatch_week_p"><div class="ew-table-header-caption"><?php echo $bcode_old->dispatch_week_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch_week_p" class="<?php echo $bcode_old->dispatch_week_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->dispatch_week_p) ?>',2);"><div id="elh_bcode_old_dispatch_week_p" class="bcode_old_dispatch_week_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->dispatch_week_p->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->dispatch_week_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->dispatch_week_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->remarks->Visible) { // remarks ?>
	<?php if ($bcode_old->sortUrl($bcode_old->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $bcode_old->remarks->headerCellClass() ?>"><div id="elh_bcode_old_remarks" class="bcode_old_remarks"><div class="ew-table-header-caption"><?php echo $bcode_old->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $bcode_old->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->remarks) ?>',2);"><div id="elh_bcode_old_remarks" class="bcode_old_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->pl_no->Visible) { // pl_no ?>
	<?php if ($bcode_old->sortUrl($bcode_old->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $bcode_old->pl_no->headerCellClass() ?>"><div id="elh_bcode_old_pl_no" class="bcode_old_pl_no"><div class="ew-table-header-caption"><?php echo $bcode_old->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $bcode_old->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->pl_no) ?>',2);"><div id="elh_bcode_old_pl_no" class="bcode_old_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->pl_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->category->Visible) { // category ?>
	<?php if ($bcode_old->sortUrl($bcode_old->category) == "") { ?>
		<th data-name="category" class="<?php echo $bcode_old->category->headerCellClass() ?>"><div id="elh_bcode_old_category" class="bcode_old_category"><div class="ew-table-header-caption"><?php echo $bcode_old->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $bcode_old->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->category) ?>',2);"><div id="elh_bcode_old_category" class="bcode_old_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->roll_no->Visible) { // roll_no ?>
	<?php if ($bcode_old->sortUrl($bcode_old->roll_no) == "") { ?>
		<th data-name="roll_no" class="<?php echo $bcode_old->roll_no->headerCellClass() ?>"><div id="elh_bcode_old_roll_no" class="bcode_old_roll_no"><div class="ew-table-header-caption"><?php echo $bcode_old->roll_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no" class="<?php echo $bcode_old->roll_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->roll_no) ?>',2);"><div id="elh_bcode_old_roll_no" class="bcode_old_roll_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->roll_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->roll_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->roll_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->qty->Visible) { // qty ?>
	<?php if ($bcode_old->sortUrl($bcode_old->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $bcode_old->qty->headerCellClass() ?>"><div id="elh_bcode_old_qty" class="bcode_old_qty"><div class="ew-table-header-caption"><?php echo $bcode_old->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $bcode_old->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->qty) ?>',2);"><div id="elh_bcode_old_qty" class="bcode_old_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->buyer_barcode->Visible) { // buyer_barcode ?>
	<?php if ($bcode_old->sortUrl($bcode_old->buyer_barcode) == "") { ?>
		<th data-name="buyer_barcode" class="<?php echo $bcode_old->buyer_barcode->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old_buyer_barcode" class="bcode_old_buyer_barcode"><div class="ew-table-header-caption"><?php echo $bcode_old->buyer_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_barcode" class="<?php echo $bcode_old->buyer_barcode->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->buyer_barcode) ?>',2);"><div id="elh_bcode_old_buyer_barcode" class="bcode_old_buyer_barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->buyer_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->buyer_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->buyer_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->q_sku->Visible) { // q_sku ?>
	<?php if ($bcode_old->sortUrl($bcode_old->q_sku) == "") { ?>
		<th data-name="q_sku" class="<?php echo $bcode_old->q_sku->headerCellClass() ?>"><div id="elh_bcode_old_q_sku" class="bcode_old_q_sku"><div class="ew-table-header-caption"><?php echo $bcode_old->q_sku->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="q_sku" class="<?php echo $bcode_old->q_sku->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->q_sku) ?>',2);"><div id="elh_bcode_old_q_sku" class="bcode_old_q_sku">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->q_sku->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->q_sku->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->q_sku->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->sqm_u->Visible) { // sqm_u ?>
	<?php if ($bcode_old->sortUrl($bcode_old->sqm_u) == "") { ?>
		<th data-name="sqm_u" class="<?php echo $bcode_old->sqm_u->headerCellClass() ?>"><div id="elh_bcode_old_sqm_u" class="bcode_old_sqm_u"><div class="ew-table-header-caption"><?php echo $bcode_old->sqm_u->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_u" class="<?php echo $bcode_old->sqm_u->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->sqm_u) ?>',2);"><div id="elh_bcode_old_sqm_u" class="bcode_old_sqm_u">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->sqm_u->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->sqm_u->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->sqm_u->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->po_discount->Visible) { // po_discount ?>
	<?php if ($bcode_old->sortUrl($bcode_old->po_discount) == "") { ?>
		<th data-name="po_discount" class="<?php echo $bcode_old->po_discount->headerCellClass() ?>"><div id="elh_bcode_old_po_discount" class="bcode_old_po_discount"><div class="ew-table-header-caption"><?php echo $bcode_old->po_discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_discount" class="<?php echo $bcode_old->po_discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->po_discount) ?>',2);"><div id="elh_bcode_old_po_discount" class="bcode_old_po_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->po_discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->po_discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->po_discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_11->Visible) { // 11 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_11) == "") { ?>
		<th data-name="_11" class="<?php echo $bcode_old->_11->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__11" class="bcode_old__11"><div class="ew-table-header-caption"><?php echo $bcode_old->_11->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_11" class="<?php echo $bcode_old->_11->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_11) ?>',2);"><div id="elh_bcode_old__11" class="bcode_old__11">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_11->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_11->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_11->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_12->Visible) { // 12 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_12) == "") { ?>
		<th data-name="_12" class="<?php echo $bcode_old->_12->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__12" class="bcode_old__12"><div class="ew-table-header-caption"><?php echo $bcode_old->_12->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_12" class="<?php echo $bcode_old->_12->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_12) ?>',2);"><div id="elh_bcode_old__12" class="bcode_old__12">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_12->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_12->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_12->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_13->Visible) { // 13 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_13) == "") { ?>
		<th data-name="_13" class="<?php echo $bcode_old->_13->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__13" class="bcode_old__13"><div class="ew-table-header-caption"><?php echo $bcode_old->_13->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_13" class="<?php echo $bcode_old->_13->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_13) ?>',2);"><div id="elh_bcode_old__13" class="bcode_old__13">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_13->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_13->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_13->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_14->Visible) { // 14 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_14) == "") { ?>
		<th data-name="_14" class="<?php echo $bcode_old->_14->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__14" class="bcode_old__14"><div class="ew-table-header-caption"><?php echo $bcode_old->_14->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_14" class="<?php echo $bcode_old->_14->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_14) ?>',2);"><div id="elh_bcode_old__14" class="bcode_old__14">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_14->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_14->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_14->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_15->Visible) { // 15 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_15) == "") { ?>
		<th data-name="_15" class="<?php echo $bcode_old->_15->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__15" class="bcode_old__15"><div class="ew-table-header-caption"><?php echo $bcode_old->_15->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_15" class="<?php echo $bcode_old->_15->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_15) ?>',2);"><div id="elh_bcode_old__15" class="bcode_old__15">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_15->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_15->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_15->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_16->Visible) { // 16 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_16) == "") { ?>
		<th data-name="_16" class="<?php echo $bcode_old->_16->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__16" class="bcode_old__16"><div class="ew-table-header-caption"><?php echo $bcode_old->_16->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_16" class="<?php echo $bcode_old->_16->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_16) ?>',2);"><div id="elh_bcode_old__16" class="bcode_old__16">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_16->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_16->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_16->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_17->Visible) { // 17 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_17) == "") { ?>
		<th data-name="_17" class="<?php echo $bcode_old->_17->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__17" class="bcode_old__17"><div class="ew-table-header-caption"><?php echo $bcode_old->_17->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_17" class="<?php echo $bcode_old->_17->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_17) ?>',2);"><div id="elh_bcode_old__17" class="bcode_old__17">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_17->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_17->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_17->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_18->Visible) { // 18 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_18) == "") { ?>
		<th data-name="_18" class="<?php echo $bcode_old->_18->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__18" class="bcode_old__18"><div class="ew-table-header-caption"><?php echo $bcode_old->_18->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_18" class="<?php echo $bcode_old->_18->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_18) ?>',2);"><div id="elh_bcode_old__18" class="bcode_old__18">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_18->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_18->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_18->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_19->Visible) { // 19 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_19) == "") { ?>
		<th data-name="_19" class="<?php echo $bcode_old->_19->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__19" class="bcode_old__19"><div class="ew-table-header-caption"><?php echo $bcode_old->_19->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_19" class="<?php echo $bcode_old->_19->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_19) ?>',2);"><div id="elh_bcode_old__19" class="bcode_old__19">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_19->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_19->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_19->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_20->Visible) { // 20 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_20) == "") { ?>
		<th data-name="_20" class="<?php echo $bcode_old->_20->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__20" class="bcode_old__20"><div class="ew-table-header-caption"><?php echo $bcode_old->_20->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_20" class="<?php echo $bcode_old->_20->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_20) ?>',2);"><div id="elh_bcode_old__20" class="bcode_old__20">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_20->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_20->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_20->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_21->Visible) { // 21 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_21) == "") { ?>
		<th data-name="_21" class="<?php echo $bcode_old->_21->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__21" class="bcode_old__21"><div class="ew-table-header-caption"><?php echo $bcode_old->_21->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_21" class="<?php echo $bcode_old->_21->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_21) ?>',2);"><div id="elh_bcode_old__21" class="bcode_old__21">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_21->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_21->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_21->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_22->Visible) { // 22 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_22) == "") { ?>
		<th data-name="_22" class="<?php echo $bcode_old->_22->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__22" class="bcode_old__22"><div class="ew-table-header-caption"><?php echo $bcode_old->_22->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_22" class="<?php echo $bcode_old->_22->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_22) ?>',2);"><div id="elh_bcode_old__22" class="bcode_old__22">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_22->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_22->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_22->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_23->Visible) { // 23 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_23) == "") { ?>
		<th data-name="_23" class="<?php echo $bcode_old->_23->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__23" class="bcode_old__23"><div class="ew-table-header-caption"><?php echo $bcode_old->_23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_23" class="<?php echo $bcode_old->_23->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_23) ?>',2);"><div id="elh_bcode_old__23" class="bcode_old__23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_23->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_24->Visible) { // 24 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_24) == "") { ?>
		<th data-name="_24" class="<?php echo $bcode_old->_24->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__24" class="bcode_old__24"><div class="ew-table-header-caption"><?php echo $bcode_old->_24->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_24" class="<?php echo $bcode_old->_24->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_24) ?>',2);"><div id="elh_bcode_old__24" class="bcode_old__24">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_24->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_24->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_24->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_25->Visible) { // 25 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_25) == "") { ?>
		<th data-name="_25" class="<?php echo $bcode_old->_25->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__25" class="bcode_old__25"><div class="ew-table-header-caption"><?php echo $bcode_old->_25->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_25" class="<?php echo $bcode_old->_25->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_25) ?>',2);"><div id="elh_bcode_old__25" class="bcode_old__25">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_25->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_25->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_25->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_26->Visible) { // 26 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_26) == "") { ?>
		<th data-name="_26" class="<?php echo $bcode_old->_26->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__26" class="bcode_old__26"><div class="ew-table-header-caption"><?php echo $bcode_old->_26->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_26" class="<?php echo $bcode_old->_26->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_26) ?>',2);"><div id="elh_bcode_old__26" class="bcode_old__26">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_26->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_26->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_26->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_27->Visible) { // 27 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_27) == "") { ?>
		<th data-name="_27" class="<?php echo $bcode_old->_27->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__27" class="bcode_old__27"><div class="ew-table-header-caption"><?php echo $bcode_old->_27->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_27" class="<?php echo $bcode_old->_27->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_27) ?>',2);"><div id="elh_bcode_old__27" class="bcode_old__27">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_27->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_27->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_27->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_28->Visible) { // 28 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_28) == "") { ?>
		<th data-name="_28" class="<?php echo $bcode_old->_28->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__28" class="bcode_old__28"><div class="ew-table-header-caption"><?php echo $bcode_old->_28->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_28" class="<?php echo $bcode_old->_28->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_28) ?>',2);"><div id="elh_bcode_old__28" class="bcode_old__28">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_28->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_28->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_28->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_29->Visible) { // 29 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_29) == "") { ?>
		<th data-name="_29" class="<?php echo $bcode_old->_29->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__29" class="bcode_old__29"><div class="ew-table-header-caption"><?php echo $bcode_old->_29->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_29" class="<?php echo $bcode_old->_29->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_29) ?>',2);"><div id="elh_bcode_old__29" class="bcode_old__29">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_29->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_29->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_29->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_30->Visible) { // 30 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_30) == "") { ?>
		<th data-name="_30" class="<?php echo $bcode_old->_30->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__30" class="bcode_old__30"><div class="ew-table-header-caption"><?php echo $bcode_old->_30->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_30" class="<?php echo $bcode_old->_30->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_30) ?>',2);"><div id="elh_bcode_old__30" class="bcode_old__30">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_30->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_30->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_30->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_31->Visible) { // 31 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_31) == "") { ?>
		<th data-name="_31" class="<?php echo $bcode_old->_31->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__31" class="bcode_old__31"><div class="ew-table-header-caption"><?php echo $bcode_old->_31->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_31" class="<?php echo $bcode_old->_31->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_31) ?>',2);"><div id="elh_bcode_old__31" class="bcode_old__31">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_31->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_31->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_31->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_32->Visible) { // 32 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_32) == "") { ?>
		<th data-name="_32" class="<?php echo $bcode_old->_32->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__32" class="bcode_old__32"><div class="ew-table-header-caption"><?php echo $bcode_old->_32->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_32" class="<?php echo $bcode_old->_32->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_32) ?>',2);"><div id="elh_bcode_old__32" class="bcode_old__32">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_32->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_32->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_32->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_33->Visible) { // 33 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_33) == "") { ?>
		<th data-name="_33" class="<?php echo $bcode_old->_33->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__33" class="bcode_old__33"><div class="ew-table-header-caption"><?php echo $bcode_old->_33->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_33" class="<?php echo $bcode_old->_33->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_33) ?>',2);"><div id="elh_bcode_old__33" class="bcode_old__33">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_33->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_33->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_33->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_34->Visible) { // 34 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_34) == "") { ?>
		<th data-name="_34" class="<?php echo $bcode_old->_34->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__34" class="bcode_old__34"><div class="ew-table-header-caption"><?php echo $bcode_old->_34->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_34" class="<?php echo $bcode_old->_34->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_34) ?>',2);"><div id="elh_bcode_old__34" class="bcode_old__34">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_34->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_34->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_34->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_35->Visible) { // 35 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_35) == "") { ?>
		<th data-name="_35" class="<?php echo $bcode_old->_35->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__35" class="bcode_old__35"><div class="ew-table-header-caption"><?php echo $bcode_old->_35->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_35" class="<?php echo $bcode_old->_35->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_35) ?>',2);"><div id="elh_bcode_old__35" class="bcode_old__35">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_35->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_35->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_35->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_36->Visible) { // 36 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_36) == "") { ?>
		<th data-name="_36" class="<?php echo $bcode_old->_36->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__36" class="bcode_old__36"><div class="ew-table-header-caption"><?php echo $bcode_old->_36->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_36" class="<?php echo $bcode_old->_36->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_36) ?>',2);"><div id="elh_bcode_old__36" class="bcode_old__36">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_36->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_36->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_36->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_37->Visible) { // 37 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_37) == "") { ?>
		<th data-name="_37" class="<?php echo $bcode_old->_37->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__37" class="bcode_old__37"><div class="ew-table-header-caption"><?php echo $bcode_old->_37->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_37" class="<?php echo $bcode_old->_37->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_37) ?>',2);"><div id="elh_bcode_old__37" class="bcode_old__37">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_37->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_37->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_37->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_38->Visible) { // 38 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_38) == "") { ?>
		<th data-name="_38" class="<?php echo $bcode_old->_38->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__38" class="bcode_old__38"><div class="ew-table-header-caption"><?php echo $bcode_old->_38->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_38" class="<?php echo $bcode_old->_38->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_38) ?>',2);"><div id="elh_bcode_old__38" class="bcode_old__38">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_38->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_38->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_38->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_39->Visible) { // 39 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_39) == "") { ?>
		<th data-name="_39" class="<?php echo $bcode_old->_39->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__39" class="bcode_old__39"><div class="ew-table-header-caption"><?php echo $bcode_old->_39->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_39" class="<?php echo $bcode_old->_39->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_39) ?>',2);"><div id="elh_bcode_old__39" class="bcode_old__39">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_39->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_39->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_39->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_40->Visible) { // 40 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $bcode_old->_40->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__40" class="bcode_old__40"><div class="ew-table-header-caption"><?php echo $bcode_old->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $bcode_old->_40->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_40) ?>',2);"><div id="elh_bcode_old__40" class="bcode_old__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_41->Visible) { // 41 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_41) == "") { ?>
		<th data-name="_41" class="<?php echo $bcode_old->_41->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__41" class="bcode_old__41"><div class="ew-table-header-caption"><?php echo $bcode_old->_41->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_41" class="<?php echo $bcode_old->_41->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_41) ?>',2);"><div id="elh_bcode_old__41" class="bcode_old__41">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_41->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_41->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_41->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_42->Visible) { // 42 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_42) == "") { ?>
		<th data-name="_42" class="<?php echo $bcode_old->_42->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__42" class="bcode_old__42"><div class="ew-table-header-caption"><?php echo $bcode_old->_42->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_42" class="<?php echo $bcode_old->_42->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_42) ?>',2);"><div id="elh_bcode_old__42" class="bcode_old__42">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_42->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_42->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_42->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_43->Visible) { // 43 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_43) == "") { ?>
		<th data-name="_43" class="<?php echo $bcode_old->_43->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__43" class="bcode_old__43"><div class="ew-table-header-caption"><?php echo $bcode_old->_43->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_43" class="<?php echo $bcode_old->_43->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_43) ?>',2);"><div id="elh_bcode_old__43" class="bcode_old__43">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_43->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_43->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_43->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_44->Visible) { // 44 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_44) == "") { ?>
		<th data-name="_44" class="<?php echo $bcode_old->_44->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__44" class="bcode_old__44"><div class="ew-table-header-caption"><?php echo $bcode_old->_44->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_44" class="<?php echo $bcode_old->_44->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_44) ?>',2);"><div id="elh_bcode_old__44" class="bcode_old__44">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_44->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_44->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_44->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_45->Visible) { // 45 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_45) == "") { ?>
		<th data-name="_45" class="<?php echo $bcode_old->_45->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__45" class="bcode_old__45"><div class="ew-table-header-caption"><?php echo $bcode_old->_45->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_45" class="<?php echo $bcode_old->_45->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_45) ?>',2);"><div id="elh_bcode_old__45" class="bcode_old__45">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_45->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_45->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_45->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_46->Visible) { // 46 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_46) == "") { ?>
		<th data-name="_46" class="<?php echo $bcode_old->_46->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__46" class="bcode_old__46"><div class="ew-table-header-caption"><?php echo $bcode_old->_46->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_46" class="<?php echo $bcode_old->_46->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_46) ?>',2);"><div id="elh_bcode_old__46" class="bcode_old__46">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_46->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_46->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_46->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_47->Visible) { // 47 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_47) == "") { ?>
		<th data-name="_47" class="<?php echo $bcode_old->_47->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__47" class="bcode_old__47"><div class="ew-table-header-caption"><?php echo $bcode_old->_47->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_47" class="<?php echo $bcode_old->_47->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_47) ?>',2);"><div id="elh_bcode_old__47" class="bcode_old__47">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_47->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_47->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_47->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_48->Visible) { // 48 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_48) == "") { ?>
		<th data-name="_48" class="<?php echo $bcode_old->_48->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__48" class="bcode_old__48"><div class="ew-table-header-caption"><?php echo $bcode_old->_48->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_48" class="<?php echo $bcode_old->_48->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_48) ?>',2);"><div id="elh_bcode_old__48" class="bcode_old__48">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_48->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_48->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_48->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_49->Visible) { // 49 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_49) == "") { ?>
		<th data-name="_49" class="<?php echo $bcode_old->_49->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__49" class="bcode_old__49"><div class="ew-table-header-caption"><?php echo $bcode_old->_49->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_49" class="<?php echo $bcode_old->_49->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_49) ?>',2);"><div id="elh_bcode_old__49" class="bcode_old__49">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_49->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_49->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_49->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->_50->Visible) { // 50 ?>
	<?php if ($bcode_old->sortUrl($bcode_old->_50) == "") { ?>
		<th data-name="_50" class="<?php echo $bcode_old->_50->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__50" class="bcode_old__50"><div class="ew-table-header-caption"><?php echo $bcode_old->_50->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_50" class="<?php echo $bcode_old->_50->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->_50) ?>',2);"><div id="elh_bcode_old__50" class="bcode_old__50">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->_50->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->_50->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->_50->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->c_sqm->Visible) { // c_sqm ?>
	<?php if ($bcode_old->sortUrl($bcode_old->c_sqm) == "") { ?>
		<th data-name="c_sqm" class="<?php echo $bcode_old->c_sqm->headerCellClass() ?>"><div id="elh_bcode_old_c_sqm" class="bcode_old_c_sqm"><div class="ew-table-header-caption"><?php echo $bcode_old->c_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_sqm" class="<?php echo $bcode_old->c_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->c_sqm) ?>',2);"><div id="elh_bcode_old_c_sqm" class="bcode_old_c_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->c_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->c_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->c_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->packing_type->Visible) { // packing_type ?>
	<?php if ($bcode_old->sortUrl($bcode_old->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $bcode_old->packing_type->headerCellClass() ?>"><div id="elh_bcode_old_packing_type" class="bcode_old_packing_type"><div class="ew-table-header-caption"><?php echo $bcode_old->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $bcode_old->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->packing_type) ?>',2);"><div id="elh_bcode_old_packing_type" class="bcode_old_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->order_date->Visible) { // order_date ?>
	<?php if ($bcode_old->sortUrl($bcode_old->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $bcode_old->order_date->headerCellClass() ?>"><div id="elh_bcode_old_order_date" class="bcode_old_order_date"><div class="ew-table-header-caption"><?php echo $bcode_old->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $bcode_old->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->order_date) ?>',2);"><div id="elh_bcode_old_order_date" class="bcode_old_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->qc_weaving->Visible) { // qc_weaving ?>
	<?php if ($bcode_old->sortUrl($bcode_old->qc_weaving) == "") { ?>
		<th data-name="qc_weaving" class="<?php echo $bcode_old->qc_weaving->headerCellClass() ?>"><div id="elh_bcode_old_qc_weaving" class="bcode_old_qc_weaving"><div class="ew-table-header-caption"><?php echo $bcode_old->qc_weaving->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_weaving" class="<?php echo $bcode_old->qc_weaving->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->qc_weaving) ?>',2);"><div id="elh_bcode_old_qc_weaving" class="bcode_old_qc_weaving">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->qc_weaving->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->qc_weaving->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->qc_weaving->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_old->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
	<?php if ($bcode_old->sortUrl($bcode_old->roll_no_qty_tmp) == "") { ?>
		<th data-name="roll_no_qty_tmp" class="<?php echo $bcode_old->roll_no_qty_tmp->headerCellClass() ?>"><div id="elh_bcode_old_roll_no_qty_tmp" class="bcode_old_roll_no_qty_tmp"><div class="ew-table-header-caption"><?php echo $bcode_old->roll_no_qty_tmp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no_qty_tmp" class="<?php echo $bcode_old->roll_no_qty_tmp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_old->SortUrl($bcode_old->roll_no_qty_tmp) ?>',2);"><div id="elh_bcode_old_roll_no_qty_tmp" class="bcode_old_roll_no_qty_tmp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_old->roll_no_qty_tmp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_old->roll_no_qty_tmp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_old->roll_no_qty_tmp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bcode_old_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bcode_old->ExportAll && $bcode_old->isExport()) {
	$bcode_old_list->StopRec = $bcode_old_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bcode_old_list->TotalRecs > $bcode_old_list->StartRec + $bcode_old_list->DisplayRecs - 1)
		$bcode_old_list->StopRec = $bcode_old_list->StartRec + $bcode_old_list->DisplayRecs - 1;
	else
		$bcode_old_list->StopRec = $bcode_old_list->TotalRecs;
}
$bcode_old_list->RecCnt = $bcode_old_list->StartRec - 1;
if ($bcode_old_list->Recordset && !$bcode_old_list->Recordset->EOF) {
	$bcode_old_list->Recordset->moveFirst();
	$selectLimit = $bcode_old_list->UseSelectLimit;
	if (!$selectLimit && $bcode_old_list->StartRec > 1)
		$bcode_old_list->Recordset->move($bcode_old_list->StartRec - 1);
} elseif (!$bcode_old->AllowAddDeleteRow && $bcode_old_list->StopRec == 0) {
	$bcode_old_list->StopRec = $bcode_old->GridAddRowCount;
}

// Initialize aggregate
$bcode_old->RowType = ROWTYPE_AGGREGATEINIT;
$bcode_old->resetAttributes();
$bcode_old_list->renderRow();
while ($bcode_old_list->RecCnt < $bcode_old_list->StopRec) {
	$bcode_old_list->RecCnt++;
	if ($bcode_old_list->RecCnt >= $bcode_old_list->StartRec) {
		$bcode_old_list->RowCnt++;

		// Set up key count
		$bcode_old_list->KeyCount = $bcode_old_list->RowIndex;

		// Init row class and style
		$bcode_old->resetAttributes();
		$bcode_old->CssClass = "";
		if ($bcode_old->isGridAdd()) {
		} else {
			$bcode_old_list->loadRowValues($bcode_old_list->Recordset); // Load row values
		}
		$bcode_old->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$bcode_old->RowAttrs = array_merge($bcode_old->RowAttrs, array('data-rowindex'=>$bcode_old_list->RowCnt, 'id'=>'r' . $bcode_old_list->RowCnt . '_bcode_old', 'data-rowtype'=>$bcode_old->RowType));

		// Render row
		$bcode_old_list->renderRow();

		// Render list options
		$bcode_old_list->renderListOptions();
?>
	<tr<?php echo $bcode_old->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bcode_old_list->ListOptions->render("body", "left", $bcode_old_list->RowCnt);
?>
	<?php if ($bcode_old->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $bcode_old->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_weaving_works" class="bcode_old_weaving_works">
<span<?php echo $bcode_old->weaving_works->viewAttributes() ?>>
<?php echo $bcode_old->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $bcode_old->current_works->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_current_works" class="bcode_old_current_works">
<span<?php echo $bcode_old->current_works->viewAttributes() ?>>
<?php echo $bcode_old->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->po->Visible) { // po ?>
		<td data-name="po"<?php echo $bcode_old->po->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_po" class="bcode_old_po">
<span<?php echo $bcode_old->po->viewAttributes() ?>>
<?php echo $bcode_old->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $bcode_old->_barcode->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__barcode" class="bcode_old__barcode">
<span<?php echo $bcode_old->_barcode->viewAttributes() ?>>
<?php echo $bcode_old->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $bcode_old->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_buyers_id" class="bcode_old_buyers_id">
<span<?php echo $bcode_old->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_old->buyers_id->getViewValue())) && $bcode_old->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_old->buyers_id->linkAttributes() ?>><?php echo $bcode_old->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_old->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $bcode_old->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_buyer_ref" class="bcode_old_buyer_ref">
<span<?php echo $bcode_old->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_old->buyer_ref->getViewValue())) && $bcode_old->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $bcode_old->buyer_ref->linkAttributes() ?>><?php echo $bcode_old->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_old->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $bcode_old->design_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_design_id" class="bcode_old_design_id">
<span<?php echo $bcode_old->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_old->design_id->getViewValue())) && $bcode_old->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_old->design_id->linkAttributes() ?>><?php echo $bcode_old->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_old->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $bcode_old->batch_no->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_batch_no" class="bcode_old_batch_no">
<span<?php echo $bcode_old->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_old->batch_no->getViewValue())) && $bcode_old->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $bcode_old->batch_no->linkAttributes() ?>><?php echo $bcode_old->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_old->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $bcode_old->sqm->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_sqm" class="bcode_old_sqm">
<span<?php echo $bcode_old->sqm->viewAttributes() ?>>
<?php echo $bcode_old->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $bcode_old->shape->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_shape" class="bcode_old_shape">
<span<?php echo $bcode_old->shape->viewAttributes() ?>>
<?php echo $bcode_old->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->cs->Visible) { // cs ?>
		<td data-name="cs"<?php echo $bcode_old->cs->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_cs" class="bcode_old_cs">
<span<?php echo $bcode_old->cs->viewAttributes() ?>>
<?php echo $bcode_old->cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $bcode_old->product_type->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_product_type" class="bcode_old_product_type">
<span<?php echo $bcode_old->product_type->viewAttributes() ?>>
<?php echo $bcode_old->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $bcode_old->size_cm->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_size_cm" class="bcode_old_size_cm">
<span<?php echo $bcode_old->size_cm->viewAttributes() ?>>
<?php echo $bcode_old->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->buyer_uid->Visible) { // buyer_uid ?>
		<td data-name="buyer_uid"<?php echo $bcode_old->buyer_uid->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_buyer_uid" class="bcode_old_buyer_uid">
<span<?php echo $bcode_old->buyer_uid->viewAttributes() ?>>
<?php echo $bcode_old->buyer_uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->buyer_loc->Visible) { // buyer_loc ?>
		<td data-name="buyer_loc"<?php echo $bcode_old->buyer_loc->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_buyer_loc" class="bcode_old_buyer_loc">
<span<?php echo $bcode_old->buyer_loc->viewAttributes() ?>>
<?php echo $bcode_old->buyer_loc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $bcode_old->quantity->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_quantity" class="bcode_old_quantity">
<span<?php echo $bcode_old->quantity->viewAttributes() ?>>
<?php echo $bcode_old->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->po_price->Visible) { // po_price ?>
		<td data-name="po_price"<?php echo $bcode_old->po_price->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_po_price" class="bcode_old_po_price">
<span<?php echo $bcode_old->po_price->viewAttributes() ?>>
<?php echo $bcode_old->po_price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $bcode_old->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_despatch_week" class="bcode_old_despatch_week">
<span<?php echo $bcode_old->despatch_week->viewAttributes() ?>>
<?php echo $bcode_old->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $bcode_old->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_despatch_date" class="bcode_old_despatch_date">
<span<?php echo $bcode_old->despatch_date->viewAttributes() ?>>
<?php echo $bcode_old->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->status->Visible) { // status ?>
		<td data-name="status"<?php echo $bcode_old->status->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_status" class="bcode_old_status">
<span<?php echo $bcode_old->status->viewAttributes() ?>>
<?php echo $bcode_old->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $bcode_old->completed->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_completed" class="bcode_old_completed">
<span<?php echo $bcode_old->completed->viewAttributes() ?>>
<?php echo $bcode_old->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $bcode_old->buyer_po->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_buyer_po" class="bcode_old_buyer_po">
<span<?php echo $bcode_old->buyer_po->viewAttributes() ?>>
<?php echo $bcode_old->buyer_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->process_d->Visible) { // process_d ?>
		<td data-name="process_d"<?php echo $bcode_old->process_d->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_process_d" class="bcode_old_process_d">
<span<?php echo $bcode_old->process_d->viewAttributes() ?>>
<?php echo $bcode_old->process_d->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->weight->Visible) { // weight ?>
		<td data-name="weight"<?php echo $bcode_old->weight->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_weight" class="bcode_old_weight">
<span<?php echo $bcode_old->weight->viewAttributes() ?>>
<?php echo $bcode_old->weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->po_currency->Visible) { // po_currency ?>
		<td data-name="po_currency"<?php echo $bcode_old->po_currency->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_po_currency" class="bcode_old_po_currency">
<span<?php echo $bcode_old->po_currency->viewAttributes() ?>>
<?php echo $bcode_old->po_currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->dispatch_week_p->Visible) { // dispatch_week_p ?>
		<td data-name="dispatch_week_p"<?php echo $bcode_old->dispatch_week_p->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_dispatch_week_p" class="bcode_old_dispatch_week_p">
<span<?php echo $bcode_old->dispatch_week_p->viewAttributes() ?>>
<?php echo $bcode_old->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $bcode_old->remarks->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_remarks" class="bcode_old_remarks">
<span<?php echo $bcode_old->remarks->viewAttributes() ?>>
<?php echo $bcode_old->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $bcode_old->pl_no->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_pl_no" class="bcode_old_pl_no">
<span<?php echo $bcode_old->pl_no->viewAttributes() ?>>
<?php echo $bcode_old->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->category->Visible) { // category ?>
		<td data-name="category"<?php echo $bcode_old->category->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_category" class="bcode_old_category">
<span<?php echo $bcode_old->category->viewAttributes() ?>>
<?php echo $bcode_old->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no"<?php echo $bcode_old->roll_no->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_roll_no" class="bcode_old_roll_no">
<span<?php echo $bcode_old->roll_no->viewAttributes() ?>>
<?php echo $bcode_old->roll_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $bcode_old->qty->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_qty" class="bcode_old_qty">
<span<?php echo $bcode_old->qty->viewAttributes() ?>>
<?php echo $bcode_old->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode"<?php echo $bcode_old->buyer_barcode->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_buyer_barcode" class="bcode_old_buyer_barcode">
<span<?php echo $bcode_old->buyer_barcode->viewAttributes() ?>>
<?php echo $bcode_old->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->q_sku->Visible) { // q_sku ?>
		<td data-name="q_sku"<?php echo $bcode_old->q_sku->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_q_sku" class="bcode_old_q_sku">
<span<?php echo $bcode_old->q_sku->viewAttributes() ?>>
<?php echo $bcode_old->q_sku->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->sqm_u->Visible) { // sqm_u ?>
		<td data-name="sqm_u"<?php echo $bcode_old->sqm_u->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_sqm_u" class="bcode_old_sqm_u">
<span<?php echo $bcode_old->sqm_u->viewAttributes() ?>>
<?php echo $bcode_old->sqm_u->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->po_discount->Visible) { // po_discount ?>
		<td data-name="po_discount"<?php echo $bcode_old->po_discount->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_po_discount" class="bcode_old_po_discount">
<span<?php echo $bcode_old->po_discount->viewAttributes() ?>>
<?php echo $bcode_old->po_discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_11->Visible) { // 11 ?>
		<td data-name="_11"<?php echo $bcode_old->_11->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__11" class="bcode_old__11">
<span<?php echo $bcode_old->_11->viewAttributes() ?>>
<?php echo $bcode_old->_11->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_12->Visible) { // 12 ?>
		<td data-name="_12"<?php echo $bcode_old->_12->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__12" class="bcode_old__12">
<span<?php echo $bcode_old->_12->viewAttributes() ?>>
<?php echo $bcode_old->_12->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_13->Visible) { // 13 ?>
		<td data-name="_13"<?php echo $bcode_old->_13->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__13" class="bcode_old__13">
<span<?php echo $bcode_old->_13->viewAttributes() ?>>
<?php echo $bcode_old->_13->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_14->Visible) { // 14 ?>
		<td data-name="_14"<?php echo $bcode_old->_14->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__14" class="bcode_old__14">
<span<?php echo $bcode_old->_14->viewAttributes() ?>>
<?php echo $bcode_old->_14->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_15->Visible) { // 15 ?>
		<td data-name="_15"<?php echo $bcode_old->_15->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__15" class="bcode_old__15">
<span<?php echo $bcode_old->_15->viewAttributes() ?>>
<?php echo $bcode_old->_15->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_16->Visible) { // 16 ?>
		<td data-name="_16"<?php echo $bcode_old->_16->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__16" class="bcode_old__16">
<span<?php echo $bcode_old->_16->viewAttributes() ?>>
<?php echo $bcode_old->_16->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_17->Visible) { // 17 ?>
		<td data-name="_17"<?php echo $bcode_old->_17->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__17" class="bcode_old__17">
<span<?php echo $bcode_old->_17->viewAttributes() ?>>
<?php echo $bcode_old->_17->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_18->Visible) { // 18 ?>
		<td data-name="_18"<?php echo $bcode_old->_18->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__18" class="bcode_old__18">
<span<?php echo $bcode_old->_18->viewAttributes() ?>>
<?php echo $bcode_old->_18->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_19->Visible) { // 19 ?>
		<td data-name="_19"<?php echo $bcode_old->_19->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__19" class="bcode_old__19">
<span<?php echo $bcode_old->_19->viewAttributes() ?>>
<?php echo $bcode_old->_19->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_20->Visible) { // 20 ?>
		<td data-name="_20"<?php echo $bcode_old->_20->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__20" class="bcode_old__20">
<span<?php echo $bcode_old->_20->viewAttributes() ?>>
<?php echo $bcode_old->_20->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_21->Visible) { // 21 ?>
		<td data-name="_21"<?php echo $bcode_old->_21->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__21" class="bcode_old__21">
<span<?php echo $bcode_old->_21->viewAttributes() ?>>
<?php echo $bcode_old->_21->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_22->Visible) { // 22 ?>
		<td data-name="_22"<?php echo $bcode_old->_22->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__22" class="bcode_old__22">
<span<?php echo $bcode_old->_22->viewAttributes() ?>>
<?php echo $bcode_old->_22->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_23->Visible) { // 23 ?>
		<td data-name="_23"<?php echo $bcode_old->_23->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__23" class="bcode_old__23">
<span<?php echo $bcode_old->_23->viewAttributes() ?>>
<?php echo $bcode_old->_23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_24->Visible) { // 24 ?>
		<td data-name="_24"<?php echo $bcode_old->_24->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__24" class="bcode_old__24">
<span<?php echo $bcode_old->_24->viewAttributes() ?>>
<?php echo $bcode_old->_24->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_25->Visible) { // 25 ?>
		<td data-name="_25"<?php echo $bcode_old->_25->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__25" class="bcode_old__25">
<span<?php echo $bcode_old->_25->viewAttributes() ?>>
<?php echo $bcode_old->_25->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_26->Visible) { // 26 ?>
		<td data-name="_26"<?php echo $bcode_old->_26->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__26" class="bcode_old__26">
<span<?php echo $bcode_old->_26->viewAttributes() ?>>
<?php echo $bcode_old->_26->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_27->Visible) { // 27 ?>
		<td data-name="_27"<?php echo $bcode_old->_27->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__27" class="bcode_old__27">
<span<?php echo $bcode_old->_27->viewAttributes() ?>>
<?php echo $bcode_old->_27->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_28->Visible) { // 28 ?>
		<td data-name="_28"<?php echo $bcode_old->_28->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__28" class="bcode_old__28">
<span<?php echo $bcode_old->_28->viewAttributes() ?>>
<?php echo $bcode_old->_28->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_29->Visible) { // 29 ?>
		<td data-name="_29"<?php echo $bcode_old->_29->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__29" class="bcode_old__29">
<span<?php echo $bcode_old->_29->viewAttributes() ?>>
<?php echo $bcode_old->_29->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_30->Visible) { // 30 ?>
		<td data-name="_30"<?php echo $bcode_old->_30->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__30" class="bcode_old__30">
<span<?php echo $bcode_old->_30->viewAttributes() ?>>
<?php echo $bcode_old->_30->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_31->Visible) { // 31 ?>
		<td data-name="_31"<?php echo $bcode_old->_31->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__31" class="bcode_old__31">
<span<?php echo $bcode_old->_31->viewAttributes() ?>>
<?php echo $bcode_old->_31->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_32->Visible) { // 32 ?>
		<td data-name="_32"<?php echo $bcode_old->_32->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__32" class="bcode_old__32">
<span<?php echo $bcode_old->_32->viewAttributes() ?>>
<?php echo $bcode_old->_32->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_33->Visible) { // 33 ?>
		<td data-name="_33"<?php echo $bcode_old->_33->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__33" class="bcode_old__33">
<span<?php echo $bcode_old->_33->viewAttributes() ?>>
<?php echo $bcode_old->_33->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_34->Visible) { // 34 ?>
		<td data-name="_34"<?php echo $bcode_old->_34->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__34" class="bcode_old__34">
<span<?php echo $bcode_old->_34->viewAttributes() ?>>
<?php echo $bcode_old->_34->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_35->Visible) { // 35 ?>
		<td data-name="_35"<?php echo $bcode_old->_35->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__35" class="bcode_old__35">
<span<?php echo $bcode_old->_35->viewAttributes() ?>>
<?php echo $bcode_old->_35->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_36->Visible) { // 36 ?>
		<td data-name="_36"<?php echo $bcode_old->_36->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__36" class="bcode_old__36">
<span<?php echo $bcode_old->_36->viewAttributes() ?>>
<?php echo $bcode_old->_36->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_37->Visible) { // 37 ?>
		<td data-name="_37"<?php echo $bcode_old->_37->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__37" class="bcode_old__37">
<span<?php echo $bcode_old->_37->viewAttributes() ?>>
<?php echo $bcode_old->_37->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_38->Visible) { // 38 ?>
		<td data-name="_38"<?php echo $bcode_old->_38->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__38" class="bcode_old__38">
<span<?php echo $bcode_old->_38->viewAttributes() ?>>
<?php echo $bcode_old->_38->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_39->Visible) { // 39 ?>
		<td data-name="_39"<?php echo $bcode_old->_39->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__39" class="bcode_old__39">
<span<?php echo $bcode_old->_39->viewAttributes() ?>>
<?php echo $bcode_old->_39->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_40->Visible) { // 40 ?>
		<td data-name="_40"<?php echo $bcode_old->_40->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__40" class="bcode_old__40">
<span<?php echo $bcode_old->_40->viewAttributes() ?>>
<?php echo $bcode_old->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_41->Visible) { // 41 ?>
		<td data-name="_41"<?php echo $bcode_old->_41->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__41" class="bcode_old__41">
<span<?php echo $bcode_old->_41->viewAttributes() ?>>
<?php echo $bcode_old->_41->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_42->Visible) { // 42 ?>
		<td data-name="_42"<?php echo $bcode_old->_42->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__42" class="bcode_old__42">
<span<?php echo $bcode_old->_42->viewAttributes() ?>>
<?php echo $bcode_old->_42->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_43->Visible) { // 43 ?>
		<td data-name="_43"<?php echo $bcode_old->_43->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__43" class="bcode_old__43">
<span<?php echo $bcode_old->_43->viewAttributes() ?>>
<?php echo $bcode_old->_43->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_44->Visible) { // 44 ?>
		<td data-name="_44"<?php echo $bcode_old->_44->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__44" class="bcode_old__44">
<span<?php echo $bcode_old->_44->viewAttributes() ?>>
<?php echo $bcode_old->_44->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_45->Visible) { // 45 ?>
		<td data-name="_45"<?php echo $bcode_old->_45->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__45" class="bcode_old__45">
<span<?php echo $bcode_old->_45->viewAttributes() ?>>
<?php echo $bcode_old->_45->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_46->Visible) { // 46 ?>
		<td data-name="_46"<?php echo $bcode_old->_46->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__46" class="bcode_old__46">
<span<?php echo $bcode_old->_46->viewAttributes() ?>>
<?php echo $bcode_old->_46->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_47->Visible) { // 47 ?>
		<td data-name="_47"<?php echo $bcode_old->_47->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__47" class="bcode_old__47">
<span<?php echo $bcode_old->_47->viewAttributes() ?>>
<?php echo $bcode_old->_47->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_48->Visible) { // 48 ?>
		<td data-name="_48"<?php echo $bcode_old->_48->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__48" class="bcode_old__48">
<span<?php echo $bcode_old->_48->viewAttributes() ?>>
<?php echo $bcode_old->_48->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_49->Visible) { // 49 ?>
		<td data-name="_49"<?php echo $bcode_old->_49->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__49" class="bcode_old__49">
<span<?php echo $bcode_old->_49->viewAttributes() ?>>
<?php echo $bcode_old->_49->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->_50->Visible) { // 50 ?>
		<td data-name="_50"<?php echo $bcode_old->_50->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old__50" class="bcode_old__50">
<span<?php echo $bcode_old->_50->viewAttributes() ?>>
<?php echo $bcode_old->_50->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->c_sqm->Visible) { // c_sqm ?>
		<td data-name="c_sqm"<?php echo $bcode_old->c_sqm->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_c_sqm" class="bcode_old_c_sqm">
<span<?php echo $bcode_old->c_sqm->viewAttributes() ?>>
<?php echo $bcode_old->c_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $bcode_old->packing_type->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_packing_type" class="bcode_old_packing_type">
<span<?php echo $bcode_old->packing_type->viewAttributes() ?>>
<?php echo $bcode_old->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $bcode_old->order_date->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_order_date" class="bcode_old_order_date">
<span<?php echo $bcode_old->order_date->viewAttributes() ?>>
<?php echo $bcode_old->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->qc_weaving->Visible) { // qc_weaving ?>
		<td data-name="qc_weaving"<?php echo $bcode_old->qc_weaving->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_qc_weaving" class="bcode_old_qc_weaving">
<span<?php echo $bcode_old->qc_weaving->viewAttributes() ?>>
<?php echo $bcode_old->qc_weaving->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_old->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
		<td data-name="roll_no_qty_tmp"<?php echo $bcode_old->roll_no_qty_tmp->cellAttributes() ?>>
<span id="el<?php echo $bcode_old_list->RowCnt ?>_bcode_old_roll_no_qty_tmp" class="bcode_old_roll_no_qty_tmp">
<span<?php echo $bcode_old->roll_no_qty_tmp->viewAttributes() ?>>
<?php echo $bcode_old->roll_no_qty_tmp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bcode_old_list->ListOptions->render("body", "right", $bcode_old_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$bcode_old->isGridAdd())
		$bcode_old_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$bcode_old->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($bcode_old_list->Recordset)
	$bcode_old_list->Recordset->Close();
?>
<?php if (!$bcode_old->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$bcode_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_old_list->Pager)) $bcode_old_list->Pager = new PrevNextPager($bcode_old_list->StartRec, $bcode_old_list->DisplayRecs, $bcode_old_list->TotalRecs, $bcode_old_list->AutoHidePager) ?>
<?php if ($bcode_old_list->Pager->RecordCount > 0 && $bcode_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_old_list->pageUrl() ?>start=<?php echo $bcode_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_old_list->TotalRecs > 0 && (!$bcode_old_list->AutoHidePageSizeSelector || $bcode_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_old_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($bcode_old_list->TotalRecs == 0 && !$bcode_old->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $bcode_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$bcode_old_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bcode_old->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$bcode_old->isExport()) { ?>
<script>
ew.scrollableTable("gmp_bcode_old", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bcode_old_list->terminate();
?>