<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_old_search = new bcode_old_search();

// Run the page
$bcode_old_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_old_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($bcode_old_search->IsModal) { ?>
var fbcode_oldsearch = currentAdvancedSearchForm = new ew.Form("fbcode_oldsearch", "search");
<?php } else { ?>
var fbcode_oldsearch = currentForm = new ew.Form("fbcode_oldsearch", "search");
<?php } ?>

// Form_CustomValidate event
fbcode_oldsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_oldsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_oldsearch.lists["x_weaving_works"] = <?php echo $bcode_old_search->weaving_works->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_old_search->weaving_works->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_current_works"] = <?php echo $bcode_old_search->current_works->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_current_works"].options = <?php echo JsonEncode($bcode_old_search->current_works->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_buyers_id"] = <?php echo $bcode_old_search->buyers_id->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_old_search->buyers_id->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_buyer_ref"] = <?php echo $bcode_old_search->buyer_ref->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_old_search->buyer_ref->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_design_id"] = <?php echo $bcode_old_search->design_id->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_design_id"].options = <?php echo JsonEncode($bcode_old_search->design_id->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_batch_no"] = <?php echo $bcode_old_search->batch_no->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_batch_no"].options = <?php echo JsonEncode($bcode_old_search->batch_no->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_shape"] = <?php echo $bcode_old_search->shape->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_shape"].options = <?php echo JsonEncode($bcode_old_search->shape->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_cs"] = <?php echo $bcode_old_search->cs->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_cs"].options = <?php echo JsonEncode($bcode_old_search->cs->options(FALSE, TRUE)) ?>;
fbcode_oldsearch.lists["x_product_type"] = <?php echo $bcode_old_search->product_type->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_product_type"].options = <?php echo JsonEncode($bcode_old_search->product_type->options(FALSE, TRUE)) ?>;
fbcode_oldsearch.lists["x_despatch_week"] = <?php echo $bcode_old_search->despatch_week->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_old_search->despatch_week->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_payment_plan"] = <?php echo $bcode_old_search->payment_plan->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_payment_plan"].options = <?php echo JsonEncode($bcode_old_search->payment_plan->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_production_plan"] = <?php echo $bcode_old_search->production_plan->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_production_plan"].options = <?php echo JsonEncode($bcode_old_search->production_plan->options(FALSE, TRUE)) ?>;
fbcode_oldsearch.lists["x_status"] = <?php echo $bcode_old_search->status->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_status"].options = <?php echo JsonEncode($bcode_old_search->status->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_completed"] = <?php echo $bcode_old_search->completed->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_completed"].options = <?php echo JsonEncode($bcode_old_search->completed->options(FALSE, TRUE)) ?>;
fbcode_oldsearch.lists["x_process_d[]"] = <?php echo $bcode_old_search->process_d->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_process_d[]"].options = <?php echo JsonEncode($bcode_old_search->process_d->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_operator"] = <?php echo $bcode_old_search->operator->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_operator"].options = <?php echo JsonEncode($bcode_old_search->operator->lookupOptions()) ?>;
fbcode_oldsearch.lists["x_category"] = <?php echo $bcode_old_search->category->Lookup->toClientList() ?>;
fbcode_oldsearch.lists["x_category"].options = <?php echo JsonEncode($bcode_old_search->category->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbcode_oldsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->pid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pp_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->pp_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_currency");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->po_currency->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dispatch_week_p");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->dispatch_week_p->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_roll_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->roll_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_q_sku");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->q_sku->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm_u");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->sqm_u->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->po_discount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_c_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->c_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->packing_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qc_weaving");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->qc_weaving->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_roll_no_qty_tmp");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_old->roll_no_qty_tmp->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_old_search->showPageHeader(); ?>
<?php
$bcode_old_search->showMessage();
?>
<form name="fbcode_oldsearch" id="fbcode_oldsearch" class="<?php echo $bcode_old_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_old_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_old_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_old">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_old_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($bcode_old->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_id"><?php echo $bcode_old->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->id->cellAttributes() ?>>
			<span id="el_bcode_old_id">
<input type="text" data-table="bcode_old" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bcode_old->id->getPlaceHolder()) ?>" value="<?php echo $bcode_old->id->EditValue ?>"<?php echo $bcode_old->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->pid->Visible) { // pid ?>
	<div id="r_pid" class="form-group row">
		<label for="x_pid" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_pid"><?php echo $bcode_old->pid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pid" id="z_pid" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->pid->cellAttributes() ?>>
			<span id="el_bcode_old_pid">
<input type="text" data-table="bcode_old" data-field="x_pid" name="x_pid" id="x_pid" size="30" placeholder="<?php echo HtmlEncode($bcode_old->pid->getPlaceHolder()) ?>" value="<?php echo $bcode_old->pid->EditValue ?>"<?php echo $bcode_old->pid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_weaving_works"><?php echo $bcode_old->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->weaving_works->cellAttributes() ?>>
			<span id="el_bcode_old_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_weaving_works" data-value-separator="<?php echo $bcode_old->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $bcode_old->weaving_works->editAttributes() ?>>
		<?php echo $bcode_old->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $bcode_old->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_current_works"><?php echo $bcode_old->current_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->current_works->cellAttributes() ?>>
			<span id="el_bcode_old_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_current_works" data-value-separator="<?php echo $bcode_old->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $bcode_old->current_works->editAttributes() ?>>
		<?php echo $bcode_old->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $bcode_old->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_po"><?php echo $bcode_old->po->caption() ?></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bcode_old->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bcode_old_po">
<input type="text" data-table="bcode_old" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($bcode_old->po->getPlaceHolder()) ?>" value="<?php echo $bcode_old->po->EditValue ?>"<?php echo $bcode_old->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bcode_old_po" class="btw1_po d-none">
<input type="text" data-table="bcode_old" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($bcode_old->po->getPlaceHolder()) ?>" value="<?php echo $bcode_old->po->EditValue2 ?>"<?php echo $bcode_old->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__barcode"><?php echo $bcode_old->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($bcode_old->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bcode_old__barcode">
<input type="text" data-table="bcode_old" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_old->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_barcode->EditValue ?>"<?php echo $bcode_old->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bcode_old__barcode" class="btw1__barcode d-none">
<input type="text" data-table="bcode_old" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_old->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_barcode->EditValue2 ?>"<?php echo $bcode_old->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_buyers_id"><?php echo $bcode_old->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->buyers_id->cellAttributes() ?>>
			<span id="el_bcode_old_buyers_id">
<?php $bcode_old->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bcode_old->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_buyers_id" data-value-separator="<?php echo $bcode_old->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $bcode_old->buyers_id->editAttributes() ?>>
		<?php echo $bcode_old->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $bcode_old->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label for="x_pp_id" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_pp_id"><?php echo $bcode_old->pp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pp_id" id="z_pp_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->pp_id->cellAttributes() ?>>
			<span id="el_bcode_old_pp_id">
<input type="text" data-table="bcode_old" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($bcode_old->pp_id->getPlaceHolder()) ?>" value="<?php echo $bcode_old->pp_id->EditValue ?>"<?php echo $bcode_old->pp_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_buyer_ref"><?php echo $bcode_old->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->buyer_ref->cellAttributes() ?>>
			<span id="el_bcode_old_buyer_ref">
<input type="text" data-table="bcode_old" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" placeholder="<?php echo HtmlEncode($bcode_old->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $bcode_old->buyer_ref->EditValue ?>"<?php echo $bcode_old->buyer_ref->editAttributes() ?>>
<?php echo $bcode_old->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_design_id"><?php echo $bcode_old->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->design_id->cellAttributes() ?>>
			<span id="el_bcode_old_design_id">
<input type="text" data-table="bcode_old" data-field="x_design_id" name="x_design_id" id="x_design_id" size="30" placeholder="<?php echo HtmlEncode($bcode_old->design_id->getPlaceHolder()) ?>" value="<?php echo $bcode_old->design_id->EditValue ?>"<?php echo $bcode_old->design_id->editAttributes() ?>>
<?php echo $bcode_old->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_batch_no"><?php echo $bcode_old->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->batch_no->cellAttributes() ?>>
			<span id="el_bcode_old_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_batch_no" data-value-separator="<?php echo $bcode_old->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $bcode_old->batch_no->editAttributes() ?>>
		<?php echo $bcode_old->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $bcode_old->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_sqm"><?php echo $bcode_old->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->sqm->cellAttributes() ?>>
			<span id="el_bcode_old_sqm">
<input type="text" data-table="bcode_old" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($bcode_old->sqm->getPlaceHolder()) ?>" value="<?php echo $bcode_old->sqm->EditValue ?>"<?php echo $bcode_old->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_shape"><?php echo $bcode_old->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->shape->cellAttributes() ?>>
			<span id="el_bcode_old_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_shape" data-value-separator="<?php echo $bcode_old->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $bcode_old->shape->editAttributes() ?>>
		<?php echo $bcode_old->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $bcode_old->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->cs->Visible) { // cs ?>
	<div id="r_cs" class="form-group row">
		<label for="x_cs" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_cs"><?php echo $bcode_old->cs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cs" id="z_cs" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->cs->cellAttributes() ?>>
			<span id="el_bcode_old_cs">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_cs" data-value-separator="<?php echo $bcode_old->cs->displayValueSeparatorAttribute() ?>" id="x_cs" name="x_cs"<?php echo $bcode_old->cs->editAttributes() ?>>
		<?php echo $bcode_old->cs->selectOptionListHtml("x_cs") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_product_type"><?php echo $bcode_old->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->product_type->cellAttributes() ?>>
			<span id="el_bcode_old_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_product_type" data-value-separator="<?php echo $bcode_old->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $bcode_old->product_type->editAttributes() ?>>
		<?php echo $bcode_old->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_size_cm"><?php echo $bcode_old->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->size_cm->cellAttributes() ?>>
			<span id="el_bcode_old_size_cm">
<input type="text" data-table="bcode_old" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode_old->size_cm->getPlaceHolder()) ?>" value="<?php echo $bcode_old->size_cm->EditValue ?>"<?php echo $bcode_old->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_size_buyer"><?php echo $bcode_old->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->size_buyer->cellAttributes() ?>>
			<span id="el_bcode_old_size_buyer">
<input type="text" data-table="bcode_old" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_old->size_buyer->getPlaceHolder()) ?>" value="<?php echo $bcode_old->size_buyer->EditValue ?>"<?php echo $bcode_old->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_buyer_uid"><?php echo $bcode_old->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->buyer_uid->cellAttributes() ?>>
			<span id="el_bcode_old_buyer_uid">
<input type="text" data-table="bcode_old" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_old->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_old->buyer_uid->EditValue ?>"<?php echo $bcode_old->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->buyer_loc->Visible) { // buyer_loc ?>
	<div id="r_buyer_loc" class="form-group row">
		<label for="x_buyer_loc" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_buyer_loc"><?php echo $bcode_old->buyer_loc->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->buyer_loc->cellAttributes() ?>>
			<span id="el_bcode_old_buyer_loc">
<input type="text" data-table="bcode_old" data-field="x_buyer_loc" name="x_buyer_loc" id="x_buyer_loc" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode_old->buyer_loc->getPlaceHolder()) ?>" value="<?php echo $bcode_old->buyer_loc->EditValue ?>"<?php echo $bcode_old->buyer_loc->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_quantity"><?php echo $bcode_old->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->quantity->cellAttributes() ?>>
			<span id="el_bcode_old_quantity">
<input type="text" data-table="bcode_old" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($bcode_old->quantity->getPlaceHolder()) ?>" value="<?php echo $bcode_old->quantity->EditValue ?>"<?php echo $bcode_old->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label for="x_po_price" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_po_price"><?php echo $bcode_old->po_price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_price" id="z_po_price" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->po_price->cellAttributes() ?>>
			<span id="el_bcode_old_po_price">
<input type="text" data-table="bcode_old" data-field="x_po_price" name="x_po_price" id="x_po_price" size="30" maxlength="1" placeholder="<?php echo HtmlEncode($bcode_old->po_price->getPlaceHolder()) ?>" value="<?php echo $bcode_old->po_price->EditValue ?>"<?php echo $bcode_old->po_price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_despatch_week"><?php echo $bcode_old->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->despatch_week->cellAttributes() ?>>
			<span id="el_bcode_old_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_despatch_week" data-value-separator="<?php echo $bcode_old->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $bcode_old->despatch_week->editAttributes() ?>>
		<?php echo $bcode_old->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $bcode_old->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_despatch_date"><?php echo $bcode_old->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->despatch_date->cellAttributes() ?>>
			<span id="el_bcode_old_despatch_date">
<input type="text" data-table="bcode_old" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($bcode_old->despatch_date->getPlaceHolder()) ?>" value="<?php echo $bcode_old->despatch_date->EditValue ?>"<?php echo $bcode_old->despatch_date->editAttributes() ?>>
<?php if (!$bcode_old->despatch_date->ReadOnly && !$bcode_old->despatch_date->Disabled && !isset($bcode_old->despatch_date->EditAttrs["readonly"]) && !isset($bcode_old->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcode_oldsearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->payment_plan->Visible) { // payment_plan ?>
	<div id="r_payment_plan" class="form-group row">
		<label for="x_payment_plan" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_payment_plan"><?php echo $bcode_old->payment_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment_plan" id="z_payment_plan" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->payment_plan->cellAttributes() ?>>
			<span id="el_bcode_old_payment_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_payment_plan" data-value-separator="<?php echo $bcode_old->payment_plan->displayValueSeparatorAttribute() ?>" id="x_payment_plan" name="x_payment_plan"<?php echo $bcode_old->payment_plan->editAttributes() ?>>
		<?php echo $bcode_old->payment_plan->selectOptionListHtml("x_payment_plan") ?>
	</select>
</div>
<?php echo $bcode_old->payment_plan->Lookup->getParamTag("p_x_payment_plan") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_production_plan"><?php echo $bcode_old->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->production_plan->cellAttributes() ?>>
			<span id="el_bcode_old_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_production_plan" data-value-separator="<?php echo $bcode_old->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $bcode_old->production_plan->editAttributes() ?>>
		<?php echo $bcode_old->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_status"><?php echo $bcode_old->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->status->cellAttributes() ?>>
			<span id="el_bcode_old_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_status" data-value-separator="<?php echo $bcode_old->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode_old->status->editAttributes() ?>>
		<?php echo $bcode_old->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $bcode_old->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label for="x_completed" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_completed"><?php echo $bcode_old->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_completed" id="z_completed" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->completed->cellAttributes() ?>>
			<span id="el_bcode_old_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_completed" data-value-separator="<?php echo $bcode_old->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $bcode_old->completed->editAttributes() ?>>
		<?php echo $bcode_old->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_buyer_po"><?php echo $bcode_old->buyer_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->buyer_po->cellAttributes() ?>>
			<span id="el_bcode_old_buyer_po">
<input type="text" data-table="bcode_old" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_old->buyer_po->getPlaceHolder()) ?>" value="<?php echo $bcode_old->buyer_po->EditValue ?>"<?php echo $bcode_old->buyer_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_jc_no"><?php echo $bcode_old->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->jc_no->cellAttributes() ?>>
			<span id="el_bcode_old_jc_no">
<input type="text" data-table="bcode_old" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($bcode_old->jc_no->getPlaceHolder()) ?>" value="<?php echo $bcode_old->jc_no->EditValue ?>"<?php echo $bcode_old->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->process_d->Visible) { // process_d ?>
	<div id="r_process_d" class="form-group row">
		<label class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_process_d"><?php echo $bcode_old->process_d->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_d" id="z_process_d" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->process_d->cellAttributes() ?>>
			<span id="el_bcode_old_process_d">
<div id="tp_x_process_d" class="ew-template"><input type="checkbox" class="form-check-input" data-table="bcode_old" data-field="x_process_d" data-value-separator="<?php echo $bcode_old->process_d->displayValueSeparatorAttribute() ?>" name="x_process_d[]" id="x_process_d[]" value="{value}"<?php echo $bcode_old->process_d->editAttributes() ?>></div>
<div id="dsl_x_process_d" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $bcode_old->process_d->checkBoxListHtml(FALSE, "x_process_d[]") ?>
</div></div>
<?php echo $bcode_old->process_d->Lookup->getParamTag("p_x_process_d") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_operator"><?php echo $bcode_old->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->operator->cellAttributes() ?>>
			<span id="el_bcode_old_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_operator" data-value-separator="<?php echo $bcode_old->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $bcode_old->operator->editAttributes() ?>>
		<?php echo $bcode_old->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $bcode_old->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_datetime"><?php echo $bcode_old->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->datetime->cellAttributes() ?>>
			<span id="el_bcode_old_datetime">
<input type="text" data-table="bcode_old" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($bcode_old->datetime->getPlaceHolder()) ?>" value="<?php echo $bcode_old->datetime->EditValue ?>"<?php echo $bcode_old->datetime->editAttributes() ?>>
<?php if (!$bcode_old->datetime->ReadOnly && !$bcode_old->datetime->Disabled && !isset($bcode_old->datetime->EditAttrs["readonly"]) && !isset($bcode_old->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcode_oldsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->po_currency->Visible) { // po_currency ?>
	<div id="r_po_currency" class="form-group row">
		<label for="x_po_currency" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_po_currency"><?php echo $bcode_old->po_currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_currency" id="z_po_currency" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->po_currency->cellAttributes() ?>>
			<span id="el_bcode_old_po_currency">
<input type="text" data-table="bcode_old" data-field="x_po_currency" name="x_po_currency" id="x_po_currency" size="30" placeholder="<?php echo HtmlEncode($bcode_old->po_currency->getPlaceHolder()) ?>" value="<?php echo $bcode_old->po_currency->EditValue ?>"<?php echo $bcode_old->po_currency->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<div id="r_dispatch_week_p" class="form-group row">
		<label for="x_dispatch_week_p" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_dispatch_week_p"><?php echo $bcode_old->dispatch_week_p->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dispatch_week_p" id="z_dispatch_week_p" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->dispatch_week_p->cellAttributes() ?>>
			<span id="el_bcode_old_dispatch_week_p">
<input type="text" data-table="bcode_old" data-field="x_dispatch_week_p" name="x_dispatch_week_p" id="x_dispatch_week_p" size="30" placeholder="<?php echo HtmlEncode($bcode_old->dispatch_week_p->getPlaceHolder()) ?>" value="<?php echo $bcode_old->dispatch_week_p->EditValue ?>"<?php echo $bcode_old->dispatch_week_p->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_remarks"><?php echo $bcode_old->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->remarks->cellAttributes() ?>>
			<span id="el_bcode_old_remarks">
<input type="text" data-table="bcode_old" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($bcode_old->remarks->getPlaceHolder()) ?>" value="<?php echo $bcode_old->remarks->EditValue ?>"<?php echo $bcode_old->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_pl_no"><?php echo $bcode_old->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->pl_no->cellAttributes() ?>>
			<span id="el_bcode_old_pl_no">
<input type="text" data-table="bcode_old" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($bcode_old->pl_no->getPlaceHolder()) ?>" value="<?php echo $bcode_old->pl_no->EditValue ?>"<?php echo $bcode_old->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_category"><?php echo $bcode_old->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->category->cellAttributes() ?>>
			<span id="el_bcode_old_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_old" data-field="x_category" data-value-separator="<?php echo $bcode_old->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $bcode_old->category->editAttributes() ?>>
		<?php echo $bcode_old->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $bcode_old->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->roll_no->Visible) { // roll_no ?>
	<div id="r_roll_no" class="form-group row">
		<label for="x_roll_no" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_roll_no"><?php echo $bcode_old->roll_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no" id="z_roll_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->roll_no->cellAttributes() ?>>
			<span id="el_bcode_old_roll_no">
<input type="text" data-table="bcode_old" data-field="x_roll_no" name="x_roll_no" id="x_roll_no" size="30" placeholder="<?php echo HtmlEncode($bcode_old->roll_no->getPlaceHolder()) ?>" value="<?php echo $bcode_old->roll_no->EditValue ?>"<?php echo $bcode_old->roll_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_qty"><?php echo $bcode_old->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->qty->cellAttributes() ?>>
			<span id="el_bcode_old_qty">
<input type="text" data-table="bcode_old" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($bcode_old->qty->getPlaceHolder()) ?>" value="<?php echo $bcode_old->qty->EditValue ?>"<?php echo $bcode_old->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->q_sku->Visible) { // q_sku ?>
	<div id="r_q_sku" class="form-group row">
		<label for="x_q_sku" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_q_sku"><?php echo $bcode_old->q_sku->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_q_sku" id="z_q_sku" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->q_sku->cellAttributes() ?>>
			<span id="el_bcode_old_q_sku">
<input type="text" data-table="bcode_old" data-field="x_q_sku" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($bcode_old->q_sku->getPlaceHolder()) ?>" value="<?php echo $bcode_old->q_sku->EditValue ?>"<?php echo $bcode_old->q_sku->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->sqm_u->Visible) { // sqm_u ?>
	<div id="r_sqm_u" class="form-group row">
		<label for="x_sqm_u" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_sqm_u"><?php echo $bcode_old->sqm_u->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm_u" id="z_sqm_u" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->sqm_u->cellAttributes() ?>>
			<span id="el_bcode_old_sqm_u">
<input type="text" data-table="bcode_old" data-field="x_sqm_u" name="x_sqm_u" id="x_sqm_u" size="30" placeholder="<?php echo HtmlEncode($bcode_old->sqm_u->getPlaceHolder()) ?>" value="<?php echo $bcode_old->sqm_u->EditValue ?>"<?php echo $bcode_old->sqm_u->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->po_discount->Visible) { // po_discount ?>
	<div id="r_po_discount" class="form-group row">
		<label for="x_po_discount" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_po_discount"><?php echo $bcode_old->po_discount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_discount" id="z_po_discount" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->po_discount->cellAttributes() ?>>
			<span id="el_bcode_old_po_discount">
<input type="text" data-table="bcode_old" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" size="30" placeholder="<?php echo HtmlEncode($bcode_old->po_discount->getPlaceHolder()) ?>" value="<?php echo $bcode_old->po_discount->EditValue ?>"<?php echo $bcode_old->po_discount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_11->Visible) { // 11 ?>
	<div id="r__11" class="form-group row">
		<label for="x__11" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__11"><?php echo $bcode_old->_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__11" id="z__11" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_11->cellAttributes() ?>>
			<span id="el_bcode_old__11">
<input type="text" data-table="bcode_old" data-field="x__11" name="x__11" id="x__11" placeholder="<?php echo HtmlEncode($bcode_old->_11->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_11->EditValue ?>"<?php echo $bcode_old->_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_12->Visible) { // 12 ?>
	<div id="r__12" class="form-group row">
		<label for="x__12" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__12"><?php echo $bcode_old->_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__12" id="z__12" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_12->cellAttributes() ?>>
			<span id="el_bcode_old__12">
<input type="text" data-table="bcode_old" data-field="x__12" name="x__12" id="x__12" placeholder="<?php echo HtmlEncode($bcode_old->_12->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_12->EditValue ?>"<?php echo $bcode_old->_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_13->Visible) { // 13 ?>
	<div id="r__13" class="form-group row">
		<label for="x__13" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__13"><?php echo $bcode_old->_13->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__13" id="z__13" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_13->cellAttributes() ?>>
			<span id="el_bcode_old__13">
<input type="text" data-table="bcode_old" data-field="x__13" name="x__13" id="x__13" placeholder="<?php echo HtmlEncode($bcode_old->_13->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_13->EditValue ?>"<?php echo $bcode_old->_13->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_14->Visible) { // 14 ?>
	<div id="r__14" class="form-group row">
		<label for="x__14" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__14"><?php echo $bcode_old->_14->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__14" id="z__14" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_14->cellAttributes() ?>>
			<span id="el_bcode_old__14">
<input type="text" data-table="bcode_old" data-field="x__14" name="x__14" id="x__14" placeholder="<?php echo HtmlEncode($bcode_old->_14->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_14->EditValue ?>"<?php echo $bcode_old->_14->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_15->Visible) { // 15 ?>
	<div id="r__15" class="form-group row">
		<label for="x__15" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__15"><?php echo $bcode_old->_15->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__15" id="z__15" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_15->cellAttributes() ?>>
			<span id="el_bcode_old__15">
<input type="text" data-table="bcode_old" data-field="x__15" name="x__15" id="x__15" placeholder="<?php echo HtmlEncode($bcode_old->_15->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_15->EditValue ?>"<?php echo $bcode_old->_15->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_16->Visible) { // 16 ?>
	<div id="r__16" class="form-group row">
		<label for="x__16" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__16"><?php echo $bcode_old->_16->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__16" id="z__16" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_16->cellAttributes() ?>>
			<span id="el_bcode_old__16">
<input type="text" data-table="bcode_old" data-field="x__16" name="x__16" id="x__16" placeholder="<?php echo HtmlEncode($bcode_old->_16->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_16->EditValue ?>"<?php echo $bcode_old->_16->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_17->Visible) { // 17 ?>
	<div id="r__17" class="form-group row">
		<label for="x__17" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__17"><?php echo $bcode_old->_17->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__17" id="z__17" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_17->cellAttributes() ?>>
			<span id="el_bcode_old__17">
<input type="text" data-table="bcode_old" data-field="x__17" name="x__17" id="x__17" placeholder="<?php echo HtmlEncode($bcode_old->_17->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_17->EditValue ?>"<?php echo $bcode_old->_17->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_18->Visible) { // 18 ?>
	<div id="r__18" class="form-group row">
		<label for="x__18" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__18"><?php echo $bcode_old->_18->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__18" id="z__18" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_18->cellAttributes() ?>>
			<span id="el_bcode_old__18">
<input type="text" data-table="bcode_old" data-field="x__18" name="x__18" id="x__18" placeholder="<?php echo HtmlEncode($bcode_old->_18->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_18->EditValue ?>"<?php echo $bcode_old->_18->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_19->Visible) { // 19 ?>
	<div id="r__19" class="form-group row">
		<label for="x__19" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__19"><?php echo $bcode_old->_19->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__19" id="z__19" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_19->cellAttributes() ?>>
			<span id="el_bcode_old__19">
<input type="text" data-table="bcode_old" data-field="x__19" name="x__19" id="x__19" placeholder="<?php echo HtmlEncode($bcode_old->_19->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_19->EditValue ?>"<?php echo $bcode_old->_19->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_20->Visible) { // 20 ?>
	<div id="r__20" class="form-group row">
		<label for="x__20" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__20"><?php echo $bcode_old->_20->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__20" id="z__20" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_20->cellAttributes() ?>>
			<span id="el_bcode_old__20">
<input type="text" data-table="bcode_old" data-field="x__20" name="x__20" id="x__20" placeholder="<?php echo HtmlEncode($bcode_old->_20->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_20->EditValue ?>"<?php echo $bcode_old->_20->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_21->Visible) { // 21 ?>
	<div id="r__21" class="form-group row">
		<label for="x__21" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__21"><?php echo $bcode_old->_21->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__21" id="z__21" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_21->cellAttributes() ?>>
			<span id="el_bcode_old__21">
<input type="text" data-table="bcode_old" data-field="x__21" name="x__21" id="x__21" placeholder="<?php echo HtmlEncode($bcode_old->_21->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_21->EditValue ?>"<?php echo $bcode_old->_21->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_22->Visible) { // 22 ?>
	<div id="r__22" class="form-group row">
		<label for="x__22" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__22"><?php echo $bcode_old->_22->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__22" id="z__22" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_22->cellAttributes() ?>>
			<span id="el_bcode_old__22">
<input type="text" data-table="bcode_old" data-field="x__22" name="x__22" id="x__22" placeholder="<?php echo HtmlEncode($bcode_old->_22->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_22->EditValue ?>"<?php echo $bcode_old->_22->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_23->Visible) { // 23 ?>
	<div id="r__23" class="form-group row">
		<label for="x__23" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__23"><?php echo $bcode_old->_23->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__23" id="z__23" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_23->cellAttributes() ?>>
			<span id="el_bcode_old__23">
<input type="text" data-table="bcode_old" data-field="x__23" name="x__23" id="x__23" placeholder="<?php echo HtmlEncode($bcode_old->_23->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_23->EditValue ?>"<?php echo $bcode_old->_23->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_24->Visible) { // 24 ?>
	<div id="r__24" class="form-group row">
		<label for="x__24" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__24"><?php echo $bcode_old->_24->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__24" id="z__24" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_24->cellAttributes() ?>>
			<span id="el_bcode_old__24">
<input type="text" data-table="bcode_old" data-field="x__24" name="x__24" id="x__24" placeholder="<?php echo HtmlEncode($bcode_old->_24->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_24->EditValue ?>"<?php echo $bcode_old->_24->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_25->Visible) { // 25 ?>
	<div id="r__25" class="form-group row">
		<label for="x__25" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__25"><?php echo $bcode_old->_25->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__25" id="z__25" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_25->cellAttributes() ?>>
			<span id="el_bcode_old__25">
<input type="text" data-table="bcode_old" data-field="x__25" name="x__25" id="x__25" placeholder="<?php echo HtmlEncode($bcode_old->_25->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_25->EditValue ?>"<?php echo $bcode_old->_25->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_26->Visible) { // 26 ?>
	<div id="r__26" class="form-group row">
		<label for="x__26" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__26"><?php echo $bcode_old->_26->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__26" id="z__26" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_26->cellAttributes() ?>>
			<span id="el_bcode_old__26">
<input type="text" data-table="bcode_old" data-field="x__26" name="x__26" id="x__26" placeholder="<?php echo HtmlEncode($bcode_old->_26->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_26->EditValue ?>"<?php echo $bcode_old->_26->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_27->Visible) { // 27 ?>
	<div id="r__27" class="form-group row">
		<label for="x__27" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__27"><?php echo $bcode_old->_27->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__27" id="z__27" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_27->cellAttributes() ?>>
			<span id="el_bcode_old__27">
<input type="text" data-table="bcode_old" data-field="x__27" name="x__27" id="x__27" placeholder="<?php echo HtmlEncode($bcode_old->_27->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_27->EditValue ?>"<?php echo $bcode_old->_27->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_28->Visible) { // 28 ?>
	<div id="r__28" class="form-group row">
		<label for="x__28" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__28"><?php echo $bcode_old->_28->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__28" id="z__28" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_28->cellAttributes() ?>>
			<span id="el_bcode_old__28">
<input type="text" data-table="bcode_old" data-field="x__28" name="x__28" id="x__28" placeholder="<?php echo HtmlEncode($bcode_old->_28->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_28->EditValue ?>"<?php echo $bcode_old->_28->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_29->Visible) { // 29 ?>
	<div id="r__29" class="form-group row">
		<label for="x__29" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__29"><?php echo $bcode_old->_29->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__29" id="z__29" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_29->cellAttributes() ?>>
			<span id="el_bcode_old__29">
<input type="text" data-table="bcode_old" data-field="x__29" name="x__29" id="x__29" placeholder="<?php echo HtmlEncode($bcode_old->_29->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_29->EditValue ?>"<?php echo $bcode_old->_29->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_30->Visible) { // 30 ?>
	<div id="r__30" class="form-group row">
		<label for="x__30" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__30"><?php echo $bcode_old->_30->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__30" id="z__30" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_30->cellAttributes() ?>>
			<span id="el_bcode_old__30">
<input type="text" data-table="bcode_old" data-field="x__30" name="x__30" id="x__30" placeholder="<?php echo HtmlEncode($bcode_old->_30->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_30->EditValue ?>"<?php echo $bcode_old->_30->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_31->Visible) { // 31 ?>
	<div id="r__31" class="form-group row">
		<label for="x__31" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__31"><?php echo $bcode_old->_31->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__31" id="z__31" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_31->cellAttributes() ?>>
			<span id="el_bcode_old__31">
<input type="text" data-table="bcode_old" data-field="x__31" name="x__31" id="x__31" placeholder="<?php echo HtmlEncode($bcode_old->_31->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_31->EditValue ?>"<?php echo $bcode_old->_31->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_32->Visible) { // 32 ?>
	<div id="r__32" class="form-group row">
		<label for="x__32" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__32"><?php echo $bcode_old->_32->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__32" id="z__32" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_32->cellAttributes() ?>>
			<span id="el_bcode_old__32">
<input type="text" data-table="bcode_old" data-field="x__32" name="x__32" id="x__32" placeholder="<?php echo HtmlEncode($bcode_old->_32->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_32->EditValue ?>"<?php echo $bcode_old->_32->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_33->Visible) { // 33 ?>
	<div id="r__33" class="form-group row">
		<label for="x__33" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__33"><?php echo $bcode_old->_33->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__33" id="z__33" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_33->cellAttributes() ?>>
			<span id="el_bcode_old__33">
<input type="text" data-table="bcode_old" data-field="x__33" name="x__33" id="x__33" placeholder="<?php echo HtmlEncode($bcode_old->_33->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_33->EditValue ?>"<?php echo $bcode_old->_33->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_34->Visible) { // 34 ?>
	<div id="r__34" class="form-group row">
		<label for="x__34" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__34"><?php echo $bcode_old->_34->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__34" id="z__34" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_34->cellAttributes() ?>>
			<span id="el_bcode_old__34">
<input type="text" data-table="bcode_old" data-field="x__34" name="x__34" id="x__34" placeholder="<?php echo HtmlEncode($bcode_old->_34->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_34->EditValue ?>"<?php echo $bcode_old->_34->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_35->Visible) { // 35 ?>
	<div id="r__35" class="form-group row">
		<label for="x__35" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__35"><?php echo $bcode_old->_35->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__35" id="z__35" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_35->cellAttributes() ?>>
			<span id="el_bcode_old__35">
<input type="text" data-table="bcode_old" data-field="x__35" name="x__35" id="x__35" placeholder="<?php echo HtmlEncode($bcode_old->_35->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_35->EditValue ?>"<?php echo $bcode_old->_35->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_36->Visible) { // 36 ?>
	<div id="r__36" class="form-group row">
		<label for="x__36" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__36"><?php echo $bcode_old->_36->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__36" id="z__36" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_36->cellAttributes() ?>>
			<span id="el_bcode_old__36">
<input type="text" data-table="bcode_old" data-field="x__36" name="x__36" id="x__36" placeholder="<?php echo HtmlEncode($bcode_old->_36->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_36->EditValue ?>"<?php echo $bcode_old->_36->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_37->Visible) { // 37 ?>
	<div id="r__37" class="form-group row">
		<label for="x__37" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__37"><?php echo $bcode_old->_37->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__37" id="z__37" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_37->cellAttributes() ?>>
			<span id="el_bcode_old__37">
<input type="text" data-table="bcode_old" data-field="x__37" name="x__37" id="x__37" placeholder="<?php echo HtmlEncode($bcode_old->_37->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_37->EditValue ?>"<?php echo $bcode_old->_37->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_38->Visible) { // 38 ?>
	<div id="r__38" class="form-group row">
		<label for="x__38" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__38"><?php echo $bcode_old->_38->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__38" id="z__38" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_38->cellAttributes() ?>>
			<span id="el_bcode_old__38">
<input type="text" data-table="bcode_old" data-field="x__38" name="x__38" id="x__38" placeholder="<?php echo HtmlEncode($bcode_old->_38->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_38->EditValue ?>"<?php echo $bcode_old->_38->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_39->Visible) { // 39 ?>
	<div id="r__39" class="form-group row">
		<label for="x__39" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__39"><?php echo $bcode_old->_39->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__39" id="z__39" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_39->cellAttributes() ?>>
			<span id="el_bcode_old__39">
<input type="text" data-table="bcode_old" data-field="x__39" name="x__39" id="x__39" placeholder="<?php echo HtmlEncode($bcode_old->_39->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_39->EditValue ?>"<?php echo $bcode_old->_39->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_40->Visible) { // 40 ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__40"><?php echo $bcode_old->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__40" id="z__40" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_40->cellAttributes() ?>>
			<span id="el_bcode_old__40">
<input type="text" data-table="bcode_old" data-field="x__40" name="x__40" id="x__40" placeholder="<?php echo HtmlEncode($bcode_old->_40->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_40->EditValue ?>"<?php echo $bcode_old->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_41->Visible) { // 41 ?>
	<div id="r__41" class="form-group row">
		<label for="x__41" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__41"><?php echo $bcode_old->_41->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__41" id="z__41" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_41->cellAttributes() ?>>
			<span id="el_bcode_old__41">
<input type="text" data-table="bcode_old" data-field="x__41" name="x__41" id="x__41" placeholder="<?php echo HtmlEncode($bcode_old->_41->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_41->EditValue ?>"<?php echo $bcode_old->_41->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_42->Visible) { // 42 ?>
	<div id="r__42" class="form-group row">
		<label for="x__42" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__42"><?php echo $bcode_old->_42->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__42" id="z__42" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_42->cellAttributes() ?>>
			<span id="el_bcode_old__42">
<input type="text" data-table="bcode_old" data-field="x__42" name="x__42" id="x__42" placeholder="<?php echo HtmlEncode($bcode_old->_42->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_42->EditValue ?>"<?php echo $bcode_old->_42->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_43->Visible) { // 43 ?>
	<div id="r__43" class="form-group row">
		<label for="x__43" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__43"><?php echo $bcode_old->_43->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__43" id="z__43" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_43->cellAttributes() ?>>
			<span id="el_bcode_old__43">
<input type="text" data-table="bcode_old" data-field="x__43" name="x__43" id="x__43" placeholder="<?php echo HtmlEncode($bcode_old->_43->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_43->EditValue ?>"<?php echo $bcode_old->_43->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_44->Visible) { // 44 ?>
	<div id="r__44" class="form-group row">
		<label for="x__44" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__44"><?php echo $bcode_old->_44->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__44" id="z__44" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_44->cellAttributes() ?>>
			<span id="el_bcode_old__44">
<input type="text" data-table="bcode_old" data-field="x__44" name="x__44" id="x__44" placeholder="<?php echo HtmlEncode($bcode_old->_44->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_44->EditValue ?>"<?php echo $bcode_old->_44->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_45->Visible) { // 45 ?>
	<div id="r__45" class="form-group row">
		<label for="x__45" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__45"><?php echo $bcode_old->_45->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__45" id="z__45" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_45->cellAttributes() ?>>
			<span id="el_bcode_old__45">
<input type="text" data-table="bcode_old" data-field="x__45" name="x__45" id="x__45" placeholder="<?php echo HtmlEncode($bcode_old->_45->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_45->EditValue ?>"<?php echo $bcode_old->_45->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_46->Visible) { // 46 ?>
	<div id="r__46" class="form-group row">
		<label for="x__46" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__46"><?php echo $bcode_old->_46->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__46" id="z__46" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_46->cellAttributes() ?>>
			<span id="el_bcode_old__46">
<input type="text" data-table="bcode_old" data-field="x__46" name="x__46" id="x__46" placeholder="<?php echo HtmlEncode($bcode_old->_46->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_46->EditValue ?>"<?php echo $bcode_old->_46->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_47->Visible) { // 47 ?>
	<div id="r__47" class="form-group row">
		<label for="x__47" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__47"><?php echo $bcode_old->_47->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__47" id="z__47" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_47->cellAttributes() ?>>
			<span id="el_bcode_old__47">
<input type="text" data-table="bcode_old" data-field="x__47" name="x__47" id="x__47" placeholder="<?php echo HtmlEncode($bcode_old->_47->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_47->EditValue ?>"<?php echo $bcode_old->_47->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_48->Visible) { // 48 ?>
	<div id="r__48" class="form-group row">
		<label for="x__48" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__48"><?php echo $bcode_old->_48->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__48" id="z__48" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_48->cellAttributes() ?>>
			<span id="el_bcode_old__48">
<input type="text" data-table="bcode_old" data-field="x__48" name="x__48" id="x__48" placeholder="<?php echo HtmlEncode($bcode_old->_48->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_48->EditValue ?>"<?php echo $bcode_old->_48->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_49->Visible) { // 49 ?>
	<div id="r__49" class="form-group row">
		<label for="x__49" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__49"><?php echo $bcode_old->_49->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__49" id="z__49" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_49->cellAttributes() ?>>
			<span id="el_bcode_old__49">
<input type="text" data-table="bcode_old" data-field="x__49" name="x__49" id="x__49" placeholder="<?php echo HtmlEncode($bcode_old->_49->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_49->EditValue ?>"<?php echo $bcode_old->_49->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->_50->Visible) { // 50 ?>
	<div id="r__50" class="form-group row">
		<label for="x__50" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old__50"><?php echo $bcode_old->_50->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__50" id="z__50" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->_50->cellAttributes() ?>>
			<span id="el_bcode_old__50">
<input type="text" data-table="bcode_old" data-field="x__50" name="x__50" id="x__50" placeholder="<?php echo HtmlEncode($bcode_old->_50->getPlaceHolder()) ?>" value="<?php echo $bcode_old->_50->EditValue ?>"<?php echo $bcode_old->_50->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->c_sqm->Visible) { // c_sqm ?>
	<div id="r_c_sqm" class="form-group row">
		<label for="x_c_sqm" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_c_sqm"><?php echo $bcode_old->c_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_c_sqm" id="z_c_sqm" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->c_sqm->cellAttributes() ?>>
			<span id="el_bcode_old_c_sqm">
<input type="text" data-table="bcode_old" data-field="x_c_sqm" name="x_c_sqm" id="x_c_sqm" size="30" placeholder="<?php echo HtmlEncode($bcode_old->c_sqm->getPlaceHolder()) ?>" value="<?php echo $bcode_old->c_sqm->EditValue ?>"<?php echo $bcode_old->c_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_packing_type"><?php echo $bcode_old->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->packing_type->cellAttributes() ?>>
			<span id="el_bcode_old_packing_type">
<input type="text" data-table="bcode_old" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($bcode_old->packing_type->getPlaceHolder()) ?>" value="<?php echo $bcode_old->packing_type->EditValue ?>"<?php echo $bcode_old->packing_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_order_date"><?php echo $bcode_old->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->order_date->cellAttributes() ?>>
			<span id="el_bcode_old_order_date">
<input type="text" data-table="bcode_old" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($bcode_old->order_date->getPlaceHolder()) ?>" value="<?php echo $bcode_old->order_date->EditValue ?>"<?php echo $bcode_old->order_date->editAttributes() ?>>
<?php if (!$bcode_old->order_date->ReadOnly && !$bcode_old->order_date->Disabled && !isset($bcode_old->order_date->EditAttrs["readonly"]) && !isset($bcode_old->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcode_oldsearch", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->qc_weaving->Visible) { // qc_weaving ?>
	<div id="r_qc_weaving" class="form-group row">
		<label for="x_qc_weaving" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_qc_weaving"><?php echo $bcode_old->qc_weaving->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_weaving" id="z_qc_weaving" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->qc_weaving->cellAttributes() ?>>
			<span id="el_bcode_old_qc_weaving">
<input type="text" data-table="bcode_old" data-field="x_qc_weaving" name="x_qc_weaving" id="x_qc_weaving" placeholder="<?php echo HtmlEncode($bcode_old->qc_weaving->getPlaceHolder()) ?>" value="<?php echo $bcode_old->qc_weaving->EditValue ?>"<?php echo $bcode_old->qc_weaving->editAttributes() ?>>
<?php if (!$bcode_old->qc_weaving->ReadOnly && !$bcode_old->qc_weaving->Disabled && !isset($bcode_old->qc_weaving->EditAttrs["readonly"]) && !isset($bcode_old->qc_weaving->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcode_oldsearch", "x_qc_weaving", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label for="x_p_remarks" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_p_remarks"><?php echo $bcode_old->p_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_p_remarks" id="z_p_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->p_remarks->cellAttributes() ?>>
			<span id="el_bcode_old_p_remarks">
<input type="text" data-table="bcode_old" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" size="35" placeholder="<?php echo HtmlEncode($bcode_old->p_remarks->getPlaceHolder()) ?>" value="<?php echo $bcode_old->p_remarks->EditValue ?>"<?php echo $bcode_old->p_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_old->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
	<div id="r_roll_no_qty_tmp" class="form-group row">
		<label for="x_roll_no_qty_tmp" class="<?php echo $bcode_old_search->LeftColumnClass ?>"><span id="elh_bcode_old_roll_no_qty_tmp"><?php echo $bcode_old->roll_no_qty_tmp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no_qty_tmp" id="z_roll_no_qty_tmp" value="="></span>
		</label>
		<div class="<?php echo $bcode_old_search->RightColumnClass ?>"><div<?php echo $bcode_old->roll_no_qty_tmp->cellAttributes() ?>>
			<span id="el_bcode_old_roll_no_qty_tmp">
<input type="text" data-table="bcode_old" data-field="x_roll_no_qty_tmp" name="x_roll_no_qty_tmp" id="x_roll_no_qty_tmp" size="30" placeholder="<?php echo HtmlEncode($bcode_old->roll_no_qty_tmp->getPlaceHolder()) ?>" value="<?php echo $bcode_old->roll_no_qty_tmp->EditValue ?>"<?php echo $bcode_old->roll_no_qty_tmp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bcode_old_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bcode_old_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_old_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_old_search->terminate();
?>