<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_s_edit = new bcode_s_edit();

// Run the page
$bcode_s_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_s_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbcode_sedit = currentForm = new ew.Form("fbcode_sedit", "edit");

// Validate form
fbcode_sedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bcode_s_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->id->caption(), $bcode_s->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->po->caption(), $bcode_s->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->_barcode->caption(), $bcode_s->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->operator->caption(), $bcode_s->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->datetime->caption(), $bcode_s->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->weaving_works->caption(), $bcode_s->weaving_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->current_works->Required) { ?>
			elm = this.getElements("x" + infix + "_current_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->current_works->caption(), $bcode_s->current_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->buyers_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyers_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->buyers_id->caption(), $bcode_s->buyers_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->buyer_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->buyer_ref->caption(), $bcode_s->buyer_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->design_id->caption(), $bcode_s->design_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->batch_no->caption(), $bcode_s->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode_s->batch_no->errorMessage()) ?>");
		<?php if ($bcode_s_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->sqm->caption(), $bcode_s->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->shape->caption(), $bcode_s->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->product_type->caption(), $bcode_s->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->size_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_size_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->size_cm->caption(), $bcode_s->size_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->size_buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_size_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->size_buyer->caption(), $bcode_s->size_buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->buyer_uid->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->buyer_uid->caption(), $bcode_s->buyer_uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->quantity->caption(), $bcode_s->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->po_price->Required) { ?>
			elm = this.getElements("x" + infix + "_po_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->po_price->caption(), $bcode_s->po_price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->despatch_week->caption(), $bcode_s->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->despatch_date->caption(), $bcode_s->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode_s->despatch_date->errorMessage()) ?>");
		<?php if ($bcode_s_edit->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->production_plan->caption(), $bcode_s->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->status->caption(), $bcode_s->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->completed->Required) { ?>
			elm = this.getElements("x" + infix + "_completed");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->completed->caption(), $bcode_s->completed->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->buyer_po->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->buyer_po->caption(), $bcode_s->buyer_po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_s_edit->pp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->pp_id->caption(), $bcode_s->pp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode_s->pp_id->errorMessage()) ?>");
		<?php if ($bcode_s_edit->in_id->Required) { ?>
			elm = this.getElements("x" + infix + "_in_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->in_id->caption(), $bcode_s->in_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_in_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode_s->in_id->errorMessage()) ?>");
		<?php if ($bcode_s_edit->out_id->Required) { ?>
			elm = this.getElements("x" + infix + "_out_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->out_id->caption(), $bcode_s->out_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_out_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode_s->out_id->errorMessage()) ?>");
		<?php if ($bcode_s_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_s->remarks->caption(), $bcode_s->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbcode_sedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_sedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_sedit.lists["x_operator"] = <?php echo $bcode_s_edit->operator->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_operator"].options = <?php echo JsonEncode($bcode_s_edit->operator->lookupOptions()) ?>;
fbcode_sedit.lists["x_weaving_works"] = <?php echo $bcode_s_edit->weaving_works->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_s_edit->weaving_works->lookupOptions()) ?>;
fbcode_sedit.lists["x_current_works"] = <?php echo $bcode_s_edit->current_works->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_current_works"].options = <?php echo JsonEncode($bcode_s_edit->current_works->lookupOptions()) ?>;
fbcode_sedit.lists["x_buyers_id"] = <?php echo $bcode_s_edit->buyers_id->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_s_edit->buyers_id->lookupOptions()) ?>;
fbcode_sedit.lists["x_buyer_ref"] = <?php echo $bcode_s_edit->buyer_ref->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_s_edit->buyer_ref->lookupOptions()) ?>;
fbcode_sedit.lists["x_design_id"] = <?php echo $bcode_s_edit->design_id->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_design_id"].options = <?php echo JsonEncode($bcode_s_edit->design_id->lookupOptions()) ?>;
fbcode_sedit.lists["x_shape"] = <?php echo $bcode_s_edit->shape->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_shape"].options = <?php echo JsonEncode($bcode_s_edit->shape->lookupOptions()) ?>;
fbcode_sedit.lists["x_despatch_week"] = <?php echo $bcode_s_edit->despatch_week->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_s_edit->despatch_week->lookupOptions()) ?>;
fbcode_sedit.lists["x_production_plan"] = <?php echo $bcode_s_edit->production_plan->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_production_plan"].options = <?php echo JsonEncode($bcode_s_edit->production_plan->options(FALSE, TRUE)) ?>;
fbcode_sedit.lists["x_status"] = <?php echo $bcode_s_edit->status->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_status"].options = <?php echo JsonEncode($bcode_s_edit->status->options(FALSE, TRUE)) ?>;
fbcode_sedit.lists["x_completed"] = <?php echo $bcode_s_edit->completed->Lookup->toClientList() ?>;
fbcode_sedit.lists["x_completed"].options = <?php echo JsonEncode($bcode_s_edit->completed->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_s_edit->showPageHeader(); ?>
<?php
$bcode_s_edit->showMessage();
?>
<form name="fbcode_sedit" id="fbcode_sedit" class="<?php echo $bcode_s_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_s_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_s_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_s">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_s_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($bcode_s->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_bcode_s_id" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->id->caption() ?><?php echo ($bcode_s->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->id->cellAttributes() ?>>
<span id="el_bcode_s_id">
<span<?php echo $bcode_s->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($bcode_s->id->CurrentValue) ?>">
<?php echo $bcode_s->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_bcode_s_po" for="x_po" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->po->caption() ?><?php echo ($bcode_s->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->po->cellAttributes() ?>>
<span id="el_bcode_s_po">
<span<?php echo $bcode_s->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($bcode_s->po->CurrentValue) ?>">
<?php echo $bcode_s->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_bcode_s__barcode" for="x__barcode" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->_barcode->caption() ?><?php echo ($bcode_s->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->_barcode->cellAttributes() ?>>
<span id="el_bcode_s__barcode">
<span<?php echo $bcode_s->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x__barcode" name="x__barcode" id="x__barcode" value="<?php echo HtmlEncode($bcode_s->_barcode->CurrentValue) ?>">
<?php echo $bcode_s->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label id="elh_bcode_s_weaving_works" for="x_weaving_works" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->weaving_works->caption() ?><?php echo ($bcode_s->weaving_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->weaving_works->cellAttributes() ?>>
<span id="el_bcode_s_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_weaving_works" data-value-separator="<?php echo $bcode_s->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $bcode_s->weaving_works->editAttributes() ?>>
		<?php echo $bcode_s->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $bcode_s->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
<?php echo $bcode_s->weaving_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label id="elh_bcode_s_current_works" for="x_current_works" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->current_works->caption() ?><?php echo ($bcode_s->current_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->current_works->cellAttributes() ?>>
<span id="el_bcode_s_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_current_works" data-value-separator="<?php echo $bcode_s->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $bcode_s->current_works->editAttributes() ?>>
		<?php echo $bcode_s->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $bcode_s->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
<?php echo $bcode_s->current_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label id="elh_bcode_s_buyers_id" for="x_buyers_id" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->buyers_id->caption() ?><?php echo ($bcode_s->buyers_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->buyers_id->cellAttributes() ?>>
<span id="el_bcode_s_buyers_id">
<span<?php echo $bcode_s->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->buyers_id->EditValue)) && $bcode_s->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->buyers_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->buyers_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->buyers_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_buyers_id" name="x_buyers_id" id="x_buyers_id" value="<?php echo HtmlEncode($bcode_s->buyers_id->CurrentValue) ?>">
<?php echo $bcode_s->buyers_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label id="elh_bcode_s_buyer_ref" for="x_buyer_ref" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->buyer_ref->caption() ?><?php echo ($bcode_s->buyer_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->buyer_ref->cellAttributes() ?>>
<span id="el_bcode_s_buyer_ref">
<span<?php echo $bcode_s->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->buyer_ref->EditValue)) && $bcode_s->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->buyer_ref->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->buyer_ref->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->buyer_ref->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($bcode_s->buyer_ref->CurrentValue) ?>">
<?php echo $bcode_s->buyer_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label id="elh_bcode_s_design_id" for="x_design_id" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->design_id->caption() ?><?php echo ($bcode_s->design_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->design_id->cellAttributes() ?>>
<span id="el_bcode_s_design_id">
<span<?php echo $bcode_s->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->design_id->EditValue)) && $bcode_s->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->design_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->design_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->design_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_design_id" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($bcode_s->design_id->CurrentValue) ?>">
<?php echo $bcode_s->design_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_bcode_s_batch_no" for="x_batch_no" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->batch_no->caption() ?><?php echo ($bcode_s->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->batch_no->cellAttributes() ?>>
<span id="el_bcode_s_batch_no">
<input type="text" data-table="bcode_s" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($bcode_s->batch_no->getPlaceHolder()) ?>" value="<?php echo $bcode_s->batch_no->EditValue ?>"<?php echo $bcode_s->batch_no->editAttributes() ?>>
</span>
<?php echo $bcode_s->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_bcode_s_sqm" for="x_sqm" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->sqm->caption() ?><?php echo ($bcode_s->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->sqm->cellAttributes() ?>>
<span id="el_bcode_s_sqm">
<span<?php echo $bcode_s->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_sqm" name="x_sqm" id="x_sqm" value="<?php echo HtmlEncode($bcode_s->sqm->CurrentValue) ?>">
<?php echo $bcode_s->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_bcode_s_shape" for="x_shape" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->shape->caption() ?><?php echo ($bcode_s->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->shape->cellAttributes() ?>>
<span id="el_bcode_s_shape">
<span<?php echo $bcode_s->shape->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->shape->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_shape" name="x_shape" id="x_shape" value="<?php echo HtmlEncode($bcode_s->shape->CurrentValue) ?>">
<?php echo $bcode_s->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_bcode_s_product_type" for="x_product_type" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->product_type->caption() ?><?php echo ($bcode_s->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->product_type->cellAttributes() ?>>
<span id="el_bcode_s_product_type">
<span<?php echo $bcode_s->product_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->product_type->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_product_type" name="x_product_type" id="x_product_type" value="<?php echo HtmlEncode($bcode_s->product_type->CurrentValue) ?>">
<?php echo $bcode_s->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label id="elh_bcode_s_size_cm" for="x_size_cm" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->size_cm->caption() ?><?php echo ($bcode_s->size_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->size_cm->cellAttributes() ?>>
<span id="el_bcode_s_size_cm">
<span<?php echo $bcode_s->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->size_cm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" value="<?php echo HtmlEncode($bcode_s->size_cm->CurrentValue) ?>">
<?php echo $bcode_s->size_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label id="elh_bcode_s_size_buyer" for="x_size_buyer" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->size_buyer->caption() ?><?php echo ($bcode_s->size_buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->size_buyer->cellAttributes() ?>>
<span id="el_bcode_s_size_buyer">
<span<?php echo $bcode_s->size_buyer->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->size_buyer->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" value="<?php echo HtmlEncode($bcode_s->size_buyer->CurrentValue) ?>">
<?php echo $bcode_s->size_buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label id="elh_bcode_s_buyer_uid" for="x_buyer_uid" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->buyer_uid->caption() ?><?php echo ($bcode_s->buyer_uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->buyer_uid->cellAttributes() ?>>
<span id="el_bcode_s_buyer_uid">
<input type="text" data-table="bcode_s" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_s->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_s->buyer_uid->EditValue ?>"<?php echo $bcode_s->buyer_uid->editAttributes() ?>>
</span>
<?php echo $bcode_s->buyer_uid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_bcode_s_quantity" for="x_quantity" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->quantity->caption() ?><?php echo ($bcode_s->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->quantity->cellAttributes() ?>>
<span id="el_bcode_s_quantity">
<span<?php echo $bcode_s->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->quantity->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_quantity" name="x_quantity" id="x_quantity" value="<?php echo HtmlEncode($bcode_s->quantity->CurrentValue) ?>">
<?php echo $bcode_s->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label id="elh_bcode_s_po_price" for="x_po_price" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->po_price->caption() ?><?php echo ($bcode_s->po_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->po_price->cellAttributes() ?>>
<span id="el_bcode_s_po_price">
<span<?php echo $bcode_s->po_price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_s->po_price->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_po_price" name="x_po_price" id="x_po_price" value="<?php echo HtmlEncode($bcode_s->po_price->CurrentValue) ?>">
<?php echo $bcode_s->po_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_bcode_s_despatch_week" for="x_despatch_week" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->despatch_week->caption() ?><?php echo ($bcode_s->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->despatch_week->cellAttributes() ?>>
<span id="el_bcode_s_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_despatch_week" data-value-separator="<?php echo $bcode_s->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $bcode_s->despatch_week->editAttributes() ?>>
		<?php echo $bcode_s->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $bcode_s->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php echo $bcode_s->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_bcode_s_despatch_date" for="x_despatch_date" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->despatch_date->caption() ?><?php echo ($bcode_s->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->despatch_date->cellAttributes() ?>>
<span id="el_bcode_s_despatch_date">
<input type="text" data-table="bcode_s" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($bcode_s->despatch_date->getPlaceHolder()) ?>" value="<?php echo $bcode_s->despatch_date->EditValue ?>"<?php echo $bcode_s->despatch_date->editAttributes() ?>>
<?php if (!$bcode_s->despatch_date->ReadOnly && !$bcode_s->despatch_date->Disabled && !isset($bcode_s->despatch_date->EditAttrs["readonly"]) && !isset($bcode_s->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcode_sedit", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $bcode_s->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_bcode_s_production_plan" for="x_production_plan" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->production_plan->caption() ?><?php echo ($bcode_s->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->production_plan->cellAttributes() ?>>
<span id="el_bcode_s_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_production_plan" data-value-separator="<?php echo $bcode_s->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $bcode_s->production_plan->editAttributes() ?>>
		<?php echo $bcode_s->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
<?php echo $bcode_s->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_bcode_s_status" for="x_status" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->status->caption() ?><?php echo ($bcode_s->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->status->cellAttributes() ?>>
<span id="el_bcode_s_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_status" data-value-separator="<?php echo $bcode_s->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode_s->status->editAttributes() ?>>
		<?php echo $bcode_s->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $bcode_s->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label id="elh_bcode_s_completed" for="x_completed" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->completed->caption() ?><?php echo ($bcode_s->completed->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->completed->cellAttributes() ?>>
<span id="el_bcode_s_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_completed" data-value-separator="<?php echo $bcode_s->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $bcode_s->completed->editAttributes() ?>>
		<?php echo $bcode_s->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
<?php echo $bcode_s->completed->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label id="elh_bcode_s_buyer_po" for="x_buyer_po" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->buyer_po->caption() ?><?php echo ($bcode_s->buyer_po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->buyer_po->cellAttributes() ?>>
<span id="el_bcode_s_buyer_po">
<input type="text" data-table="bcode_s" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_s->buyer_po->getPlaceHolder()) ?>" value="<?php echo $bcode_s->buyer_po->EditValue ?>"<?php echo $bcode_s->buyer_po->editAttributes() ?>>
</span>
<?php echo $bcode_s->buyer_po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label id="elh_bcode_s_pp_id" for="x_pp_id" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->pp_id->caption() ?><?php echo ($bcode_s->pp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->pp_id->cellAttributes() ?>>
<span id="el_bcode_s_pp_id">
<input type="text" data-table="bcode_s" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($bcode_s->pp_id->getPlaceHolder()) ?>" value="<?php echo $bcode_s->pp_id->EditValue ?>"<?php echo $bcode_s->pp_id->editAttributes() ?>>
</span>
<?php echo $bcode_s->pp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->in_id->Visible) { // in_id ?>
	<div id="r_in_id" class="form-group row">
		<label id="elh_bcode_s_in_id" for="x_in_id" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->in_id->caption() ?><?php echo ($bcode_s->in_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->in_id->cellAttributes() ?>>
<span id="el_bcode_s_in_id">
<input type="text" data-table="bcode_s" data-field="x_in_id" name="x_in_id" id="x_in_id" size="30" placeholder="<?php echo HtmlEncode($bcode_s->in_id->getPlaceHolder()) ?>" value="<?php echo $bcode_s->in_id->EditValue ?>"<?php echo $bcode_s->in_id->editAttributes() ?>>
</span>
<?php echo $bcode_s->in_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->out_id->Visible) { // out_id ?>
	<div id="r_out_id" class="form-group row">
		<label id="elh_bcode_s_out_id" for="x_out_id" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->out_id->caption() ?><?php echo ($bcode_s->out_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->out_id->cellAttributes() ?>>
<span id="el_bcode_s_out_id">
<input type="text" data-table="bcode_s" data-field="x_out_id" name="x_out_id" id="x_out_id" size="30" placeholder="<?php echo HtmlEncode($bcode_s->out_id->getPlaceHolder()) ?>" value="<?php echo $bcode_s->out_id->EditValue ?>"<?php echo $bcode_s->out_id->editAttributes() ?>>
</span>
<?php echo $bcode_s->out_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_bcode_s_remarks" for="x_remarks" class="<?php echo $bcode_s_edit->LeftColumnClass ?>"><?php echo $bcode_s->remarks->caption() ?><?php echo ($bcode_s->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_s_edit->RightColumnClass ?>"><div<?php echo $bcode_s->remarks->cellAttributes() ?>>
<span id="el_bcode_s_remarks">
<textarea data-table="bcode_s" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($bcode_s->remarks->getPlaceHolder()) ?>"<?php echo $bcode_s->remarks->editAttributes() ?>><?php echo $bcode_s->remarks->EditValue ?></textarea>
</span>
<?php echo $bcode_s->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bcode_s_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bcode_s_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $bcode_s_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_s_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_s_edit->terminate();
?>