<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_s_list = new bcode_s_list();

// Run the page
$bcode_s_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_s_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bcode_s->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbcode_slist = currentForm = new ew.Form("fbcode_slist", "list");
fbcode_slist.formKeyCountName = '<?php echo $bcode_s_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbcode_slist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_slist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_slist.lists["x_weaving_works"] = <?php echo $bcode_s_list->weaving_works->Lookup->toClientList() ?>;
fbcode_slist.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_s_list->weaving_works->lookupOptions()) ?>;
fbcode_slist.lists["x_current_works"] = <?php echo $bcode_s_list->current_works->Lookup->toClientList() ?>;
fbcode_slist.lists["x_current_works"].options = <?php echo JsonEncode($bcode_s_list->current_works->lookupOptions()) ?>;
fbcode_slist.lists["x_buyers_id"] = <?php echo $bcode_s_list->buyers_id->Lookup->toClientList() ?>;
fbcode_slist.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_s_list->buyers_id->lookupOptions()) ?>;
fbcode_slist.lists["x_buyer_ref"] = <?php echo $bcode_s_list->buyer_ref->Lookup->toClientList() ?>;
fbcode_slist.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_s_list->buyer_ref->lookupOptions()) ?>;
fbcode_slist.lists["x_design_id"] = <?php echo $bcode_s_list->design_id->Lookup->toClientList() ?>;
fbcode_slist.lists["x_design_id"].options = <?php echo JsonEncode($bcode_s_list->design_id->lookupOptions()) ?>;
fbcode_slist.lists["x_shape"] = <?php echo $bcode_s_list->shape->Lookup->toClientList() ?>;
fbcode_slist.lists["x_shape"].options = <?php echo JsonEncode($bcode_s_list->shape->lookupOptions()) ?>;
fbcode_slist.lists["x_status"] = <?php echo $bcode_s_list->status->Lookup->toClientList() ?>;
fbcode_slist.lists["x_status"].options = <?php echo JsonEncode($bcode_s_list->status->options(FALSE, TRUE)) ?>;
fbcode_slist.lists["x_completed"] = <?php echo $bcode_s_list->completed->Lookup->toClientList() ?>;
fbcode_slist.lists["x_completed"].options = <?php echo JsonEncode($bcode_s_list->completed->options(FALSE, TRUE)) ?>;

// Form object for search
var fbcode_slistsrch = currentSearchForm = new ew.Form("fbcode_slistsrch");

// Filters
fbcode_slistsrch.filterList = <?php echo $bcode_s_list->getFilterList() ?>;

// Init search panel as collapsed
fbcode_slistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bcode_s->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($bcode_s_list->TotalRecs > 0 && $bcode_s_list->ExportOptions->visible()) { ?>
<?php $bcode_s_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_s_list->ImportOptions->visible()) { ?>
<?php $bcode_s_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_s_list->SearchOptions->visible()) { ?>
<?php $bcode_s_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_s_list->FilterOptions->visible()) { ?>
<?php $bcode_s_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$bcode_s_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$bcode_s->isExport() && !$bcode_s->CurrentAction) { ?>
<form name="fbcode_slistsrch" id="fbcode_slistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($bcode_s_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbcode_slistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bcode_s">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($bcode_s_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($bcode_s_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $bcode_s_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($bcode_s_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($bcode_s_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($bcode_s_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($bcode_s_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bcode_s_list->showPageHeader(); ?>
<?php
$bcode_s_list->showMessage();
?>
<?php if ($bcode_s_list->TotalRecs > 0 || $bcode_s->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($bcode_s_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> bcode_s">
<?php if (!$bcode_s->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$bcode_s->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_s_list->Pager)) $bcode_s_list->Pager = new PrevNextPager($bcode_s_list->StartRec, $bcode_s_list->DisplayRecs, $bcode_s_list->TotalRecs, $bcode_s_list->AutoHidePager) ?>
<?php if ($bcode_s_list->Pager->RecordCount > 0 && $bcode_s_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_s_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_s_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_s_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_s_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_s_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_s_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_s_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_s_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_s_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_s_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_s_list->TotalRecs > 0 && (!$bcode_s_list->AutoHidePageSizeSelector || $bcode_s_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode_s">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_s_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_s_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_s_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_s_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_s_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode_s->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_s_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbcode_slist" id="fbcode_slist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_s_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_s_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_s">
<div id="gmp_bcode_s" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($bcode_s_list->TotalRecs > 0 || $bcode_s->isGridEdit()) { ?>
<table id="tbl_bcode_slist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$bcode_s_list->RowType = ROWTYPE_HEADER;

// Render list options
$bcode_s_list->renderListOptions();

// Render list options (header, left)
$bcode_s_list->ListOptions->render("header", "left");
?>
<?php if ($bcode_s->id->Visible) { // id ?>
	<?php if ($bcode_s->sortUrl($bcode_s->id) == "") { ?>
		<th data-name="id" class="<?php echo $bcode_s->id->headerCellClass() ?>"><div id="elh_bcode_s_id" class="bcode_s_id"><div class="ew-table-header-caption"><?php echo $bcode_s->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $bcode_s->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->id) ?>',2);"><div id="elh_bcode_s_id" class="bcode_s_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->po->Visible) { // po ?>
	<?php if ($bcode_s->sortUrl($bcode_s->po) == "") { ?>
		<th data-name="po" class="<?php echo $bcode_s->po->headerCellClass() ?>"><div id="elh_bcode_s_po" class="bcode_s_po"><div class="ew-table-header-caption"><?php echo $bcode_s->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $bcode_s->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->po) ?>',2);"><div id="elh_bcode_s_po" class="bcode_s_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->_barcode->Visible) { // barcode ?>
	<?php if ($bcode_s->sortUrl($bcode_s->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $bcode_s->_barcode->headerCellClass() ?>"><div id="elh_bcode_s__barcode" class="bcode_s__barcode"><div class="ew-table-header-caption"><?php echo $bcode_s->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $bcode_s->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->_barcode) ?>',2);"><div id="elh_bcode_s__barcode" class="bcode_s__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->pid->Visible) { // pid ?>
	<?php if ($bcode_s->sortUrl($bcode_s->pid) == "") { ?>
		<th data-name="pid" class="<?php echo $bcode_s->pid->headerCellClass() ?>"><div id="elh_bcode_s_pid" class="bcode_s_pid"><div class="ew-table-header-caption"><?php echo $bcode_s->pid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pid" class="<?php echo $bcode_s->pid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->pid) ?>',2);"><div id="elh_bcode_s_pid" class="bcode_s_pid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->pid->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->pid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->pid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->weaving_works->Visible) { // weaving_works ?>
	<?php if ($bcode_s->sortUrl($bcode_s->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $bcode_s->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_s_weaving_works" class="bcode_s_weaving_works"><div class="ew-table-header-caption"><?php echo $bcode_s->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $bcode_s->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->weaving_works) ?>',2);"><div id="elh_bcode_s_weaving_works" class="bcode_s_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->current_works->Visible) { // current_works ?>
	<?php if ($bcode_s->sortUrl($bcode_s->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $bcode_s->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_s_current_works" class="bcode_s_current_works"><div class="ew-table-header-caption"><?php echo $bcode_s->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $bcode_s->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->current_works) ?>',2);"><div id="elh_bcode_s_current_works" class="bcode_s_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->buyers_id->Visible) { // buyers_id ?>
	<?php if ($bcode_s->sortUrl($bcode_s->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $bcode_s->buyers_id->headerCellClass() ?>"><div id="elh_bcode_s_buyers_id" class="bcode_s_buyers_id"><div class="ew-table-header-caption"><?php echo $bcode_s->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $bcode_s->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->buyers_id) ?>',2);"><div id="elh_bcode_s_buyers_id" class="bcode_s_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($bcode_s->sortUrl($bcode_s->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $bcode_s->buyer_ref->headerCellClass() ?>"><div id="elh_bcode_s_buyer_ref" class="bcode_s_buyer_ref"><div class="ew-table-header-caption"><?php echo $bcode_s->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $bcode_s->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->buyer_ref) ?>',2);"><div id="elh_bcode_s_buyer_ref" class="bcode_s_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->buyer_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->buyer_tid->Visible) { // buyer_tid ?>
	<?php if ($bcode_s->sortUrl($bcode_s->buyer_tid) == "") { ?>
		<th data-name="buyer_tid" class="<?php echo $bcode_s->buyer_tid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_s_buyer_tid" class="bcode_s_buyer_tid"><div class="ew-table-header-caption"><?php echo $bcode_s->buyer_tid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_tid" class="<?php echo $bcode_s->buyer_tid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->buyer_tid) ?>',2);"><div id="elh_bcode_s_buyer_tid" class="bcode_s_buyer_tid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->buyer_tid->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->buyer_tid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->buyer_tid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->design_id->Visible) { // design_id ?>
	<?php if ($bcode_s->sortUrl($bcode_s->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $bcode_s->design_id->headerCellClass() ?>"><div id="elh_bcode_s_design_id" class="bcode_s_design_id"><div class="ew-table-header-caption"><?php echo $bcode_s->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $bcode_s->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->design_id) ?>',2);"><div id="elh_bcode_s_design_id" class="bcode_s_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->batch_no->Visible) { // batch_no ?>
	<?php if ($bcode_s->sortUrl($bcode_s->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $bcode_s->batch_no->headerCellClass() ?>"><div id="elh_bcode_s_batch_no" class="bcode_s_batch_no"><div class="ew-table-header-caption"><?php echo $bcode_s->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $bcode_s->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->batch_no) ?>',2);"><div id="elh_bcode_s_batch_no" class="bcode_s_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->sqm->Visible) { // sqm ?>
	<?php if ($bcode_s->sortUrl($bcode_s->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $bcode_s->sqm->headerCellClass() ?>"><div id="elh_bcode_s_sqm" class="bcode_s_sqm"><div class="ew-table-header-caption"><?php echo $bcode_s->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $bcode_s->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->sqm) ?>',2);"><div id="elh_bcode_s_sqm" class="bcode_s_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->shape->Visible) { // shape ?>
	<?php if ($bcode_s->sortUrl($bcode_s->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $bcode_s->shape->headerCellClass() ?>"><div id="elh_bcode_s_shape" class="bcode_s_shape"><div class="ew-table-header-caption"><?php echo $bcode_s->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $bcode_s->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->shape) ?>',2);"><div id="elh_bcode_s_shape" class="bcode_s_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->product_type->Visible) { // product_type ?>
	<?php if ($bcode_s->sortUrl($bcode_s->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $bcode_s->product_type->headerCellClass() ?>"><div id="elh_bcode_s_product_type" class="bcode_s_product_type"><div class="ew-table-header-caption"><?php echo $bcode_s->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $bcode_s->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->product_type) ?>',2);"><div id="elh_bcode_s_product_type" class="bcode_s_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->size_cm->Visible) { // size_cm ?>
	<?php if ($bcode_s->sortUrl($bcode_s->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $bcode_s->size_cm->headerCellClass() ?>"><div id="elh_bcode_s_size_cm" class="bcode_s_size_cm"><div class="ew-table-header-caption"><?php echo $bcode_s->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $bcode_s->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->size_cm) ?>',2);"><div id="elh_bcode_s_size_cm" class="bcode_s_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->buyer_uid->Visible) { // buyer_uid ?>
	<?php if ($bcode_s->sortUrl($bcode_s->buyer_uid) == "") { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode_s->buyer_uid->headerCellClass() ?>"><div id="elh_bcode_s_buyer_uid" class="bcode_s_buyer_uid"><div class="ew-table-header-caption"><?php echo $bcode_s->buyer_uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode_s->buyer_uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->buyer_uid) ?>',2);"><div id="elh_bcode_s_buyer_uid" class="bcode_s_buyer_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->buyer_uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->buyer_uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->buyer_uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->quantity->Visible) { // quantity ?>
	<?php if ($bcode_s->sortUrl($bcode_s->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $bcode_s->quantity->headerCellClass() ?>"><div id="elh_bcode_s_quantity" class="bcode_s_quantity"><div class="ew-table-header-caption"><?php echo $bcode_s->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $bcode_s->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->quantity) ?>',2);"><div id="elh_bcode_s_quantity" class="bcode_s_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->po_price->Visible) { // po_price ?>
	<?php if ($bcode_s->sortUrl($bcode_s->po_price) == "") { ?>
		<th data-name="po_price" class="<?php echo $bcode_s->po_price->headerCellClass() ?>"><div id="elh_bcode_s_po_price" class="bcode_s_po_price"><div class="ew-table-header-caption"><?php echo $bcode_s->po_price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_price" class="<?php echo $bcode_s->po_price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->po_price) ?>',2);"><div id="elh_bcode_s_po_price" class="bcode_s_po_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->po_price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->po_price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->po_price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->despatch_date->Visible) { // despatch_date ?>
	<?php if ($bcode_s->sortUrl($bcode_s->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $bcode_s->despatch_date->headerCellClass() ?>"><div id="elh_bcode_s_despatch_date" class="bcode_s_despatch_date"><div class="ew-table-header-caption"><?php echo $bcode_s->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $bcode_s->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->despatch_date) ?>',2);"><div id="elh_bcode_s_despatch_date" class="bcode_s_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->status->Visible) { // status ?>
	<?php if ($bcode_s->sortUrl($bcode_s->status) == "") { ?>
		<th data-name="status" class="<?php echo $bcode_s->status->headerCellClass() ?>"><div id="elh_bcode_s_status" class="bcode_s_status"><div class="ew-table-header-caption"><?php echo $bcode_s->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $bcode_s->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->status) ?>',2);"><div id="elh_bcode_s_status" class="bcode_s_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->completed->Visible) { // completed ?>
	<?php if ($bcode_s->sortUrl($bcode_s->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $bcode_s->completed->headerCellClass() ?>"><div id="elh_bcode_s_completed" class="bcode_s_completed"><div class="ew-table-header-caption"><?php echo $bcode_s->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $bcode_s->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->completed) ?>',2);"><div id="elh_bcode_s_completed" class="bcode_s_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->buyer_po->Visible) { // buyer_po ?>
	<?php if ($bcode_s->sortUrl($bcode_s->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $bcode_s->buyer_po->headerCellClass() ?>"><div id="elh_bcode_s_buyer_po" class="bcode_s_buyer_po"><div class="ew-table-header-caption"><?php echo $bcode_s->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $bcode_s->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->buyer_po) ?>',2);"><div id="elh_bcode_s_buyer_po" class="bcode_s_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->pp_id->Visible) { // pp_id ?>
	<?php if ($bcode_s->sortUrl($bcode_s->pp_id) == "") { ?>
		<th data-name="pp_id" class="<?php echo $bcode_s->pp_id->headerCellClass() ?>"><div id="elh_bcode_s_pp_id" class="bcode_s_pp_id"><div class="ew-table-header-caption"><?php echo $bcode_s->pp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_id" class="<?php echo $bcode_s->pp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->pp_id) ?>',2);"><div id="elh_bcode_s_pp_id" class="bcode_s_pp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->pp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->pp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->pp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->in_id->Visible) { // in_id ?>
	<?php if ($bcode_s->sortUrl($bcode_s->in_id) == "") { ?>
		<th data-name="in_id" class="<?php echo $bcode_s->in_id->headerCellClass() ?>"><div id="elh_bcode_s_in_id" class="bcode_s_in_id"><div class="ew-table-header-caption"><?php echo $bcode_s->in_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="in_id" class="<?php echo $bcode_s->in_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->in_id) ?>',2);"><div id="elh_bcode_s_in_id" class="bcode_s_in_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->in_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->in_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->in_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_s->out_id->Visible) { // out_id ?>
	<?php if ($bcode_s->sortUrl($bcode_s->out_id) == "") { ?>
		<th data-name="out_id" class="<?php echo $bcode_s->out_id->headerCellClass() ?>"><div id="elh_bcode_s_out_id" class="bcode_s_out_id"><div class="ew-table-header-caption"><?php echo $bcode_s->out_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="out_id" class="<?php echo $bcode_s->out_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_s->SortUrl($bcode_s->out_id) ?>',2);"><div id="elh_bcode_s_out_id" class="bcode_s_out_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_s->out_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_s->out_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_s->out_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bcode_s_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bcode_s->ExportAll && $bcode_s->isExport()) {
	$bcode_s_list->StopRec = $bcode_s_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bcode_s_list->TotalRecs > $bcode_s_list->StartRec + $bcode_s_list->DisplayRecs - 1)
		$bcode_s_list->StopRec = $bcode_s_list->StartRec + $bcode_s_list->DisplayRecs - 1;
	else
		$bcode_s_list->StopRec = $bcode_s_list->TotalRecs;
}
$bcode_s_list->RecCnt = $bcode_s_list->StartRec - 1;
if ($bcode_s_list->Recordset && !$bcode_s_list->Recordset->EOF) {
	$bcode_s_list->Recordset->moveFirst();
	$selectLimit = $bcode_s_list->UseSelectLimit;
	if (!$selectLimit && $bcode_s_list->StartRec > 1)
		$bcode_s_list->Recordset->move($bcode_s_list->StartRec - 1);
} elseif (!$bcode_s->AllowAddDeleteRow && $bcode_s_list->StopRec == 0) {
	$bcode_s_list->StopRec = $bcode_s->GridAddRowCount;
}

// Initialize aggregate
$bcode_s->RowType = ROWTYPE_AGGREGATEINIT;
$bcode_s->resetAttributes();
$bcode_s_list->renderRow();
while ($bcode_s_list->RecCnt < $bcode_s_list->StopRec) {
	$bcode_s_list->RecCnt++;
	if ($bcode_s_list->RecCnt >= $bcode_s_list->StartRec) {
		$bcode_s_list->RowCnt++;

		// Set up key count
		$bcode_s_list->KeyCount = $bcode_s_list->RowIndex;

		// Init row class and style
		$bcode_s->resetAttributes();
		$bcode_s->CssClass = "";
		if ($bcode_s->isGridAdd()) {
		} else {
			$bcode_s_list->loadRowValues($bcode_s_list->Recordset); // Load row values
		}
		$bcode_s->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$bcode_s->RowAttrs = array_merge($bcode_s->RowAttrs, array('data-rowindex'=>$bcode_s_list->RowCnt, 'id'=>'r' . $bcode_s_list->RowCnt . '_bcode_s', 'data-rowtype'=>$bcode_s->RowType));

		// Render row
		$bcode_s_list->renderRow();

		// Render list options
		$bcode_s_list->renderListOptions();
?>
	<tr<?php echo $bcode_s->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bcode_s_list->ListOptions->render("body", "left", $bcode_s_list->RowCnt);
?>
	<?php if ($bcode_s->id->Visible) { // id ?>
		<td data-name="id"<?php echo $bcode_s->id->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_id" class="bcode_s_id">
<span<?php echo $bcode_s->id->viewAttributes() ?>>
<?php echo $bcode_s->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->po->Visible) { // po ?>
		<td data-name="po"<?php echo $bcode_s->po->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_po" class="bcode_s_po">
<span<?php echo $bcode_s->po->viewAttributes() ?>>
<?php echo $bcode_s->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $bcode_s->_barcode->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s__barcode" class="bcode_s__barcode">
<span<?php echo $bcode_s->_barcode->viewAttributes() ?>>
<?php echo $bcode_s->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->pid->Visible) { // pid ?>
		<td data-name="pid"<?php echo $bcode_s->pid->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_pid" class="bcode_s_pid">
<span<?php echo $bcode_s->pid->viewAttributes() ?>>
<?php echo $bcode_s->pid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $bcode_s->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_weaving_works" class="bcode_s_weaving_works">
<span<?php echo $bcode_s->weaving_works->viewAttributes() ?>>
<?php echo $bcode_s->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $bcode_s->current_works->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_current_works" class="bcode_s_current_works">
<span<?php echo $bcode_s->current_works->viewAttributes() ?>>
<?php echo $bcode_s->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $bcode_s->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_buyers_id" class="bcode_s_buyers_id">
<span<?php echo $bcode_s->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->buyers_id->getViewValue())) && $bcode_s->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->buyers_id->linkAttributes() ?>><?php echo $bcode_s->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_s->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $bcode_s->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_buyer_ref" class="bcode_s_buyer_ref">
<span<?php echo $bcode_s->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->buyer_ref->getViewValue())) && $bcode_s->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->buyer_ref->linkAttributes() ?>><?php echo $bcode_s->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_s->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->buyer_tid->Visible) { // buyer_tid ?>
		<td data-name="buyer_tid"<?php echo $bcode_s->buyer_tid->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_buyer_tid" class="bcode_s_buyer_tid">
<span<?php echo $bcode_s->buyer_tid->viewAttributes() ?>>
<?php echo $bcode_s->buyer_tid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $bcode_s->design_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_design_id" class="bcode_s_design_id">
<span<?php echo $bcode_s->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->design_id->getViewValue())) && $bcode_s->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->design_id->linkAttributes() ?>><?php echo $bcode_s->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_s->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $bcode_s->batch_no->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_batch_no" class="bcode_s_batch_no">
<span<?php echo $bcode_s->batch_no->viewAttributes() ?>>
<?php echo $bcode_s->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $bcode_s->sqm->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_sqm" class="bcode_s_sqm">
<span<?php echo $bcode_s->sqm->viewAttributes() ?>>
<?php echo $bcode_s->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $bcode_s->shape->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_shape" class="bcode_s_shape">
<span<?php echo $bcode_s->shape->viewAttributes() ?>>
<?php echo $bcode_s->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $bcode_s->product_type->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_product_type" class="bcode_s_product_type">
<span<?php echo $bcode_s->product_type->viewAttributes() ?>>
<?php echo $bcode_s->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $bcode_s->size_cm->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_size_cm" class="bcode_s_size_cm">
<span<?php echo $bcode_s->size_cm->viewAttributes() ?>>
<?php echo $bcode_s->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->buyer_uid->Visible) { // buyer_uid ?>
		<td data-name="buyer_uid"<?php echo $bcode_s->buyer_uid->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_buyer_uid" class="bcode_s_buyer_uid">
<span<?php echo $bcode_s->buyer_uid->viewAttributes() ?>>
<?php echo $bcode_s->buyer_uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $bcode_s->quantity->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_quantity" class="bcode_s_quantity">
<span<?php echo $bcode_s->quantity->viewAttributes() ?>>
<?php echo $bcode_s->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->po_price->Visible) { // po_price ?>
		<td data-name="po_price"<?php echo $bcode_s->po_price->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_po_price" class="bcode_s_po_price">
<span<?php echo $bcode_s->po_price->viewAttributes() ?>>
<?php echo $bcode_s->po_price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $bcode_s->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_despatch_date" class="bcode_s_despatch_date">
<span<?php echo $bcode_s->despatch_date->viewAttributes() ?>>
<?php echo $bcode_s->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->status->Visible) { // status ?>
		<td data-name="status"<?php echo $bcode_s->status->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_status" class="bcode_s_status">
<span<?php echo $bcode_s->status->viewAttributes() ?>>
<?php echo $bcode_s->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $bcode_s->completed->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_completed" class="bcode_s_completed">
<span<?php echo $bcode_s->completed->viewAttributes() ?>>
<?php echo $bcode_s->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $bcode_s->buyer_po->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_buyer_po" class="bcode_s_buyer_po">
<span<?php echo $bcode_s->buyer_po->viewAttributes() ?>>
<?php echo $bcode_s->buyer_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id"<?php echo $bcode_s->pp_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_pp_id" class="bcode_s_pp_id">
<span<?php echo $bcode_s->pp_id->viewAttributes() ?>>
<?php echo $bcode_s->pp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->in_id->Visible) { // in_id ?>
		<td data-name="in_id"<?php echo $bcode_s->in_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_in_id" class="bcode_s_in_id">
<span<?php echo $bcode_s->in_id->viewAttributes() ?>>
<?php echo $bcode_s->in_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode_s->out_id->Visible) { // out_id ?>
		<td data-name="out_id"<?php echo $bcode_s->out_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_s_list->RowCnt ?>_bcode_s_out_id" class="bcode_s_out_id">
<span<?php echo $bcode_s->out_id->viewAttributes() ?>>
<?php echo $bcode_s->out_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bcode_s_list->ListOptions->render("body", "right", $bcode_s_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$bcode_s->isGridAdd())
		$bcode_s_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$bcode_s->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($bcode_s_list->Recordset)
	$bcode_s_list->Recordset->Close();
?>
<?php if (!$bcode_s->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$bcode_s->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_s_list->Pager)) $bcode_s_list->Pager = new PrevNextPager($bcode_s_list->StartRec, $bcode_s_list->DisplayRecs, $bcode_s_list->TotalRecs, $bcode_s_list->AutoHidePager) ?>
<?php if ($bcode_s_list->Pager->RecordCount > 0 && $bcode_s_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_s_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_s_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_s_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_s_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_s_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_s_list->pageUrl() ?>start=<?php echo $bcode_s_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_s_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_s_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_s_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_s_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_s_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_s_list->TotalRecs > 0 && (!$bcode_s_list->AutoHidePageSizeSelector || $bcode_s_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode_s">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_s_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_s_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_s_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_s_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_s_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode_s->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_s_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($bcode_s_list->TotalRecs == 0 && !$bcode_s->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $bcode_s_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$bcode_s_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bcode_s->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$bcode_s->isExport()) { ?>
<script>
ew.scrollableTable("gmp_bcode_s", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bcode_s_list->terminate();
?>