<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_s_search = new bcode_s_search();

// Run the page
$bcode_s_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_s_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($bcode_s_search->IsModal) { ?>
var fbcode_ssearch = currentAdvancedSearchForm = new ew.Form("fbcode_ssearch", "search");
<?php } else { ?>
var fbcode_ssearch = currentForm = new ew.Form("fbcode_ssearch", "search");
<?php } ?>

// Form_CustomValidate event
fbcode_ssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_ssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_ssearch.lists["x_operator"] = <?php echo $bcode_s_search->operator->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_operator"].options = <?php echo JsonEncode($bcode_s_search->operator->lookupOptions()) ?>;
fbcode_ssearch.lists["x_buyers_id"] = <?php echo $bcode_s_search->buyers_id->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_s_search->buyers_id->lookupOptions()) ?>;
fbcode_ssearch.lists["x_buyer_ref"] = <?php echo $bcode_s_search->buyer_ref->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_s_search->buyer_ref->lookupOptions()) ?>;
fbcode_ssearch.lists["x_design_id"] = <?php echo $bcode_s_search->design_id->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_design_id"].options = <?php echo JsonEncode($bcode_s_search->design_id->lookupOptions()) ?>;
fbcode_ssearch.lists["x_shape"] = <?php echo $bcode_s_search->shape->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_shape"].options = <?php echo JsonEncode($bcode_s_search->shape->lookupOptions()) ?>;
fbcode_ssearch.lists["x_despatch_week"] = <?php echo $bcode_s_search->despatch_week->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_s_search->despatch_week->lookupOptions()) ?>;
fbcode_ssearch.lists["x_payment_plan"] = <?php echo $bcode_s_search->payment_plan->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_payment_plan"].options = <?php echo JsonEncode($bcode_s_search->payment_plan->lookupOptions()) ?>;
fbcode_ssearch.lists["x_production_plan"] = <?php echo $bcode_s_search->production_plan->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_production_plan"].options = <?php echo JsonEncode($bcode_s_search->production_plan->options(FALSE, TRUE)) ?>;
fbcode_ssearch.lists["x_status"] = <?php echo $bcode_s_search->status->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_status"].options = <?php echo JsonEncode($bcode_s_search->status->options(FALSE, TRUE)) ?>;
fbcode_ssearch.lists["x_completed"] = <?php echo $bcode_s_search->completed->Lookup->toClientList() ?>;
fbcode_ssearch.lists["x_completed"].options = <?php echo JsonEncode($bcode_s_search->completed->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fbcode_ssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->pid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->batch_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->product_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pp_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->pp_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_in_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->in_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_out_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_s->out_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_s_search->showPageHeader(); ?>
<?php
$bcode_s_search->showMessage();
?>
<form name="fbcode_ssearch" id="fbcode_ssearch" class="<?php echo $bcode_s_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_s_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_s_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_s">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_s_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($bcode_s->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_id"><?php echo $bcode_s->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->id->cellAttributes() ?>>
			<span id="el_bcode_s_id">
<input type="text" data-table="bcode_s" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bcode_s->id->getPlaceHolder()) ?>" value="<?php echo $bcode_s->id->EditValue ?>"<?php echo $bcode_s->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_po"><?php echo $bcode_s->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->po->cellAttributes() ?>>
			<span id="el_bcode_s_po">
<input type="text" data-table="bcode_s" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($bcode_s->po->getPlaceHolder()) ?>" value="<?php echo $bcode_s->po->EditValue ?>"<?php echo $bcode_s->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s__barcode"><?php echo $bcode_s->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->_barcode->cellAttributes() ?>>
			<span id="el_bcode_s__barcode">
<input type="text" data-table="bcode_s" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_s->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_s->_barcode->EditValue ?>"<?php echo $bcode_s->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_operator"><?php echo $bcode_s->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->operator->cellAttributes() ?>>
			<span id="el_bcode_s_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_operator" data-value-separator="<?php echo $bcode_s->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $bcode_s->operator->editAttributes() ?>>
		<?php echo $bcode_s->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $bcode_s->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_datetime"><?php echo $bcode_s->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->datetime->cellAttributes() ?>>
			<span id="el_bcode_s_datetime">
<input type="text" data-table="bcode_s" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($bcode_s->datetime->getPlaceHolder()) ?>" value="<?php echo $bcode_s->datetime->EditValue ?>"<?php echo $bcode_s->datetime->editAttributes() ?>>
<?php if (!$bcode_s->datetime->ReadOnly && !$bcode_s->datetime->Disabled && !isset($bcode_s->datetime->EditAttrs["readonly"]) && !isset($bcode_s->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcode_ssearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->pid->Visible) { // pid ?>
	<div id="r_pid" class="form-group row">
		<label for="x_pid" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_pid"><?php echo $bcode_s->pid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pid" id="z_pid" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->pid->cellAttributes() ?>>
			<span id="el_bcode_s_pid">
<input type="text" data-table="bcode_s" data-field="x_pid" name="x_pid" id="x_pid" size="30" placeholder="<?php echo HtmlEncode($bcode_s->pid->getPlaceHolder()) ?>" value="<?php echo $bcode_s->pid->EditValue ?>"<?php echo $bcode_s->pid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_buyers_id"><?php echo $bcode_s->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->buyers_id->cellAttributes() ?>>
			<span id="el_bcode_s_buyers_id">
<?php $bcode_s->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bcode_s->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_buyers_id" data-value-separator="<?php echo $bcode_s->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $bcode_s->buyers_id->editAttributes() ?>>
		<?php echo $bcode_s->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $bcode_s->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_buyer_ref"><?php echo $bcode_s->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->buyer_ref->cellAttributes() ?>>
			<span id="el_bcode_s_buyer_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_buyer_ref" data-value-separator="<?php echo $bcode_s->buyer_ref->displayValueSeparatorAttribute() ?>" id="x_buyer_ref" name="x_buyer_ref"<?php echo $bcode_s->buyer_ref->editAttributes() ?>>
		<?php echo $bcode_s->buyer_ref->selectOptionListHtml("x_buyer_ref") ?>
	</select>
</div>
<?php echo $bcode_s->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_design_id"><?php echo $bcode_s->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->design_id->cellAttributes() ?>>
			<span id="el_bcode_s_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_design_id" data-value-separator="<?php echo $bcode_s->design_id->displayValueSeparatorAttribute() ?>" id="x_design_id" name="x_design_id"<?php echo $bcode_s->design_id->editAttributes() ?>>
		<?php echo $bcode_s->design_id->selectOptionListHtml("x_design_id") ?>
	</select>
</div>
<?php echo $bcode_s->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_batch_no"><?php echo $bcode_s->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->batch_no->cellAttributes() ?>>
			<span id="el_bcode_s_batch_no">
<input type="text" data-table="bcode_s" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($bcode_s->batch_no->getPlaceHolder()) ?>" value="<?php echo $bcode_s->batch_no->EditValue ?>"<?php echo $bcode_s->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_sqm"><?php echo $bcode_s->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->sqm->cellAttributes() ?>>
			<span id="el_bcode_s_sqm">
<input type="text" data-table="bcode_s" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($bcode_s->sqm->getPlaceHolder()) ?>" value="<?php echo $bcode_s->sqm->EditValue ?>"<?php echo $bcode_s->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_shape"><?php echo $bcode_s->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->shape->cellAttributes() ?>>
			<span id="el_bcode_s_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_shape" data-value-separator="<?php echo $bcode_s->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $bcode_s->shape->editAttributes() ?>>
		<?php echo $bcode_s->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $bcode_s->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_product_type"><?php echo $bcode_s->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->product_type->cellAttributes() ?>>
			<span id="el_bcode_s_product_type">
<input type="text" data-table="bcode_s" data-field="x_product_type" name="x_product_type" id="x_product_type" size="30" placeholder="<?php echo HtmlEncode($bcode_s->product_type->getPlaceHolder()) ?>" value="<?php echo $bcode_s->product_type->EditValue ?>"<?php echo $bcode_s->product_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_size_cm"><?php echo $bcode_s->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->size_cm->cellAttributes() ?>>
			<span id="el_bcode_s_size_cm">
<input type="text" data-table="bcode_s" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode_s->size_cm->getPlaceHolder()) ?>" value="<?php echo $bcode_s->size_cm->EditValue ?>"<?php echo $bcode_s->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_size_buyer"><?php echo $bcode_s->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->size_buyer->cellAttributes() ?>>
			<span id="el_bcode_s_size_buyer">
<input type="text" data-table="bcode_s" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_s->size_buyer->getPlaceHolder()) ?>" value="<?php echo $bcode_s->size_buyer->EditValue ?>"<?php echo $bcode_s->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_buyer_uid"><?php echo $bcode_s->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->buyer_uid->cellAttributes() ?>>
			<span id="el_bcode_s_buyer_uid">
<input type="text" data-table="bcode_s" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_s->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_s->buyer_uid->EditValue ?>"<?php echo $bcode_s->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_quantity"><?php echo $bcode_s->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->quantity->cellAttributes() ?>>
			<span id="el_bcode_s_quantity">
<input type="text" data-table="bcode_s" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($bcode_s->quantity->getPlaceHolder()) ?>" value="<?php echo $bcode_s->quantity->EditValue ?>"<?php echo $bcode_s->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label for="x_po_price" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_po_price"><?php echo $bcode_s->po_price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_price" id="z_po_price" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->po_price->cellAttributes() ?>>
			<span id="el_bcode_s_po_price">
<input type="text" data-table="bcode_s" data-field="x_po_price" name="x_po_price" id="x_po_price" size="30" maxlength="1" placeholder="<?php echo HtmlEncode($bcode_s->po_price->getPlaceHolder()) ?>" value="<?php echo $bcode_s->po_price->EditValue ?>"<?php echo $bcode_s->po_price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_despatch_week"><?php echo $bcode_s->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->despatch_week->cellAttributes() ?>>
			<span id="el_bcode_s_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_despatch_week" data-value-separator="<?php echo $bcode_s->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $bcode_s->despatch_week->editAttributes() ?>>
		<?php echo $bcode_s->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $bcode_s->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_despatch_date"><?php echo $bcode_s->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->despatch_date->cellAttributes() ?>>
			<span id="el_bcode_s_despatch_date">
<input type="text" data-table="bcode_s" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($bcode_s->despatch_date->getPlaceHolder()) ?>" value="<?php echo $bcode_s->despatch_date->EditValue ?>"<?php echo $bcode_s->despatch_date->editAttributes() ?>>
<?php if (!$bcode_s->despatch_date->ReadOnly && !$bcode_s->despatch_date->Disabled && !isset($bcode_s->despatch_date->EditAttrs["readonly"]) && !isset($bcode_s->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcode_ssearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->payment_plan->Visible) { // payment_plan ?>
	<div id="r_payment_plan" class="form-group row">
		<label for="x_payment_plan" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_payment_plan"><?php echo $bcode_s->payment_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment_plan" id="z_payment_plan" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->payment_plan->cellAttributes() ?>>
			<span id="el_bcode_s_payment_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_payment_plan" data-value-separator="<?php echo $bcode_s->payment_plan->displayValueSeparatorAttribute() ?>" id="x_payment_plan" name="x_payment_plan"<?php echo $bcode_s->payment_plan->editAttributes() ?>>
		<?php echo $bcode_s->payment_plan->selectOptionListHtml("x_payment_plan") ?>
	</select>
</div>
<?php echo $bcode_s->payment_plan->Lookup->getParamTag("p_x_payment_plan") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_production_plan"><?php echo $bcode_s->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->production_plan->cellAttributes() ?>>
			<span id="el_bcode_s_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_production_plan" data-value-separator="<?php echo $bcode_s->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $bcode_s->production_plan->editAttributes() ?>>
		<?php echo $bcode_s->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_status"><?php echo $bcode_s->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->status->cellAttributes() ?>>
			<span id="el_bcode_s_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_status" data-value-separator="<?php echo $bcode_s->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode_s->status->editAttributes() ?>>
		<?php echo $bcode_s->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label for="x_completed" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_completed"><?php echo $bcode_s->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_completed" id="z_completed" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->completed->cellAttributes() ?>>
			<span id="el_bcode_s_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_s" data-field="x_completed" data-value-separator="<?php echo $bcode_s->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $bcode_s->completed->editAttributes() ?>>
		<?php echo $bcode_s->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_buyer_po"><?php echo $bcode_s->buyer_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->buyer_po->cellAttributes() ?>>
			<span id="el_bcode_s_buyer_po">
<input type="text" data-table="bcode_s" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_s->buyer_po->getPlaceHolder()) ?>" value="<?php echo $bcode_s->buyer_po->EditValue ?>"<?php echo $bcode_s->buyer_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_jc_no"><?php echo $bcode_s->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->jc_no->cellAttributes() ?>>
			<span id="el_bcode_s_jc_no">
<input type="text" data-table="bcode_s" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($bcode_s->jc_no->getPlaceHolder()) ?>" value="<?php echo $bcode_s->jc_no->EditValue ?>"<?php echo $bcode_s->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label for="x_pp_id" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_pp_id"><?php echo $bcode_s->pp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pp_id" id="z_pp_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->pp_id->cellAttributes() ?>>
			<span id="el_bcode_s_pp_id">
<input type="text" data-table="bcode_s" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($bcode_s->pp_id->getPlaceHolder()) ?>" value="<?php echo $bcode_s->pp_id->EditValue ?>"<?php echo $bcode_s->pp_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->in_id->Visible) { // in_id ?>
	<div id="r_in_id" class="form-group row">
		<label for="x_in_id" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_in_id"><?php echo $bcode_s->in_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_in_id" id="z_in_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->in_id->cellAttributes() ?>>
			<span id="el_bcode_s_in_id">
<input type="text" data-table="bcode_s" data-field="x_in_id" name="x_in_id" id="x_in_id" size="30" placeholder="<?php echo HtmlEncode($bcode_s->in_id->getPlaceHolder()) ?>" value="<?php echo $bcode_s->in_id->EditValue ?>"<?php echo $bcode_s->in_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->out_id->Visible) { // out_id ?>
	<div id="r_out_id" class="form-group row">
		<label for="x_out_id" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_out_id"><?php echo $bcode_s->out_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_out_id" id="z_out_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->out_id->cellAttributes() ?>>
			<span id="el_bcode_s_out_id">
<input type="text" data-table="bcode_s" data-field="x_out_id" name="x_out_id" id="x_out_id" size="30" placeholder="<?php echo HtmlEncode($bcode_s->out_id->getPlaceHolder()) ?>" value="<?php echo $bcode_s->out_id->EditValue ?>"<?php echo $bcode_s->out_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_s->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $bcode_s_search->LeftColumnClass ?>"><span id="elh_bcode_s_remarks"><?php echo $bcode_s->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_s_search->RightColumnClass ?>"><div<?php echo $bcode_s->remarks->cellAttributes() ?>>
			<span id="el_bcode_s_remarks">
<input type="text" data-table="bcode_s" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($bcode_s->remarks->getPlaceHolder()) ?>" value="<?php echo $bcode_s->remarks->EditValue ?>"<?php echo $bcode_s->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bcode_s_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bcode_s_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_s_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_s_search->terminate();
?>