<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_s_view = new bcode_s_view();

// Run the page
$bcode_s_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_s_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bcode_s->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbcode_sview = currentForm = new ew.Form("fbcode_sview", "view");

// Form_CustomValidate event
fbcode_sview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_sview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_sview.lists["x_operator"] = <?php echo $bcode_s_view->operator->Lookup->toClientList() ?>;
fbcode_sview.lists["x_operator"].options = <?php echo JsonEncode($bcode_s_view->operator->lookupOptions()) ?>;
fbcode_sview.lists["x_buyers_id"] = <?php echo $bcode_s_view->buyers_id->Lookup->toClientList() ?>;
fbcode_sview.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_s_view->buyers_id->lookupOptions()) ?>;
fbcode_sview.lists["x_buyer_ref"] = <?php echo $bcode_s_view->buyer_ref->Lookup->toClientList() ?>;
fbcode_sview.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_s_view->buyer_ref->lookupOptions()) ?>;
fbcode_sview.lists["x_design_id"] = <?php echo $bcode_s_view->design_id->Lookup->toClientList() ?>;
fbcode_sview.lists["x_design_id"].options = <?php echo JsonEncode($bcode_s_view->design_id->lookupOptions()) ?>;
fbcode_sview.lists["x_shape"] = <?php echo $bcode_s_view->shape->Lookup->toClientList() ?>;
fbcode_sview.lists["x_shape"].options = <?php echo JsonEncode($bcode_s_view->shape->lookupOptions()) ?>;
fbcode_sview.lists["x_despatch_week"] = <?php echo $bcode_s_view->despatch_week->Lookup->toClientList() ?>;
fbcode_sview.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_s_view->despatch_week->lookupOptions()) ?>;
fbcode_sview.lists["x_production_plan"] = <?php echo $bcode_s_view->production_plan->Lookup->toClientList() ?>;
fbcode_sview.lists["x_production_plan"].options = <?php echo JsonEncode($bcode_s_view->production_plan->options(FALSE, TRUE)) ?>;
fbcode_sview.lists["x_status"] = <?php echo $bcode_s_view->status->Lookup->toClientList() ?>;
fbcode_sview.lists["x_status"].options = <?php echo JsonEncode($bcode_s_view->status->options(FALSE, TRUE)) ?>;
fbcode_sview.lists["x_completed"] = <?php echo $bcode_s_view->completed->Lookup->toClientList() ?>;
fbcode_sview.lists["x_completed"].options = <?php echo JsonEncode($bcode_s_view->completed->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bcode_s->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $bcode_s_view->ExportOptions->render("body") ?>
<?php $bcode_s_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $bcode_s_view->showPageHeader(); ?>
<?php
$bcode_s_view->showMessage();
?>
<form name="fbcode_sview" id="fbcode_sview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_s_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_s_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_s">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_s_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($bcode_s->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_id"><?php echo $bcode_s->id->caption() ?></span></td>
		<td data-name="id"<?php echo $bcode_s->id->cellAttributes() ?>>
<span id="el_bcode_s_id">
<span<?php echo $bcode_s->id->viewAttributes() ?>>
<?php echo $bcode_s->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_po"><?php echo $bcode_s->po->caption() ?></span></td>
		<td data-name="po"<?php echo $bcode_s->po->cellAttributes() ?>>
<span id="el_bcode_s_po">
<span<?php echo $bcode_s->po->viewAttributes() ?>>
<?php echo $bcode_s->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s__barcode"><?php echo $bcode_s->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $bcode_s->_barcode->cellAttributes() ?>>
<span id="el_bcode_s__barcode">
<span<?php echo $bcode_s->_barcode->viewAttributes() ?>>
<?php echo $bcode_s->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_operator"><?php echo $bcode_s->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $bcode_s->operator->cellAttributes() ?>>
<span id="el_bcode_s_operator">
<span<?php echo $bcode_s->operator->viewAttributes() ?>>
<?php echo $bcode_s->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_datetime"><?php echo $bcode_s->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $bcode_s->datetime->cellAttributes() ?>>
<span id="el_bcode_s_datetime">
<span<?php echo $bcode_s->datetime->viewAttributes() ?>>
<?php echo $bcode_s->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->pid->Visible) { // pid ?>
	<tr id="r_pid">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_pid"><?php echo $bcode_s->pid->caption() ?></span></td>
		<td data-name="pid"<?php echo $bcode_s->pid->cellAttributes() ?>>
<span id="el_bcode_s_pid">
<span<?php echo $bcode_s->pid->viewAttributes() ?>>
<?php echo $bcode_s->pid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->buyers_id->Visible) { // buyers_id ?>
	<tr id="r_buyers_id">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_buyers_id"><?php echo $bcode_s->buyers_id->caption() ?></span></td>
		<td data-name="buyers_id"<?php echo $bcode_s->buyers_id->cellAttributes() ?>>
<span id="el_bcode_s_buyers_id">
<span<?php echo $bcode_s->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->buyers_id->getViewValue())) && $bcode_s->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->buyers_id->linkAttributes() ?>><?php echo $bcode_s->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_s->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_buyer_ref"><?php echo $bcode_s->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $bcode_s->buyer_ref->cellAttributes() ?>>
<span id="el_bcode_s_buyer_ref">
<span<?php echo $bcode_s->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->buyer_ref->getViewValue())) && $bcode_s->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->buyer_ref->linkAttributes() ?>><?php echo $bcode_s->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_s->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_design_id"><?php echo $bcode_s->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $bcode_s->design_id->cellAttributes() ?>>
<span id="el_bcode_s_design_id">
<span<?php echo $bcode_s->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_s->design_id->getViewValue())) && $bcode_s->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_s->design_id->linkAttributes() ?>><?php echo $bcode_s->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_s->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_batch_no"><?php echo $bcode_s->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $bcode_s->batch_no->cellAttributes() ?>>
<span id="el_bcode_s_batch_no">
<span<?php echo $bcode_s->batch_no->viewAttributes() ?>>
<?php echo $bcode_s->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_sqm"><?php echo $bcode_s->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $bcode_s->sqm->cellAttributes() ?>>
<span id="el_bcode_s_sqm">
<span<?php echo $bcode_s->sqm->viewAttributes() ?>>
<?php echo $bcode_s->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->shape->Visible) { // shape ?>
	<tr id="r_shape">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_shape"><?php echo $bcode_s->shape->caption() ?></span></td>
		<td data-name="shape"<?php echo $bcode_s->shape->cellAttributes() ?>>
<span id="el_bcode_s_shape">
<span<?php echo $bcode_s->shape->viewAttributes() ?>>
<?php echo $bcode_s->shape->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_product_type"><?php echo $bcode_s->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $bcode_s->product_type->cellAttributes() ?>>
<span id="el_bcode_s_product_type">
<span<?php echo $bcode_s->product_type->viewAttributes() ?>>
<?php echo $bcode_s->product_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->size_cm->Visible) { // size_cm ?>
	<tr id="r_size_cm">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_size_cm"><?php echo $bcode_s->size_cm->caption() ?></span></td>
		<td data-name="size_cm"<?php echo $bcode_s->size_cm->cellAttributes() ?>>
<span id="el_bcode_s_size_cm">
<span<?php echo $bcode_s->size_cm->viewAttributes() ?>>
<?php echo $bcode_s->size_cm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->size_buyer->Visible) { // size_buyer ?>
	<tr id="r_size_buyer">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_size_buyer"><?php echo $bcode_s->size_buyer->caption() ?></span></td>
		<td data-name="size_buyer"<?php echo $bcode_s->size_buyer->cellAttributes() ?>>
<span id="el_bcode_s_size_buyer">
<span<?php echo $bcode_s->size_buyer->viewAttributes() ?>>
<?php echo $bcode_s->size_buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->buyer_uid->Visible) { // buyer_uid ?>
	<tr id="r_buyer_uid">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_buyer_uid"><?php echo $bcode_s->buyer_uid->caption() ?></span></td>
		<td data-name="buyer_uid"<?php echo $bcode_s->buyer_uid->cellAttributes() ?>>
<span id="el_bcode_s_buyer_uid">
<span<?php echo $bcode_s->buyer_uid->viewAttributes() ?>>
<?php echo $bcode_s->buyer_uid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_quantity"><?php echo $bcode_s->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $bcode_s->quantity->cellAttributes() ?>>
<span id="el_bcode_s_quantity">
<span<?php echo $bcode_s->quantity->viewAttributes() ?>>
<?php echo $bcode_s->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->po_price->Visible) { // po_price ?>
	<tr id="r_po_price">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_po_price"><?php echo $bcode_s->po_price->caption() ?></span></td>
		<td data-name="po_price"<?php echo $bcode_s->po_price->cellAttributes() ?>>
<span id="el_bcode_s_po_price">
<span<?php echo $bcode_s->po_price->viewAttributes() ?>>
<?php echo $bcode_s->po_price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->despatch_week->Visible) { // despatch_week ?>
	<tr id="r_despatch_week">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_despatch_week"><?php echo $bcode_s->despatch_week->caption() ?></span></td>
		<td data-name="despatch_week"<?php echo $bcode_s->despatch_week->cellAttributes() ?>>
<span id="el_bcode_s_despatch_week">
<span<?php echo $bcode_s->despatch_week->viewAttributes() ?>>
<?php echo $bcode_s->despatch_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->despatch_date->Visible) { // despatch_date ?>
	<tr id="r_despatch_date">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_despatch_date"><?php echo $bcode_s->despatch_date->caption() ?></span></td>
		<td data-name="despatch_date"<?php echo $bcode_s->despatch_date->cellAttributes() ?>>
<span id="el_bcode_s_despatch_date">
<span<?php echo $bcode_s->despatch_date->viewAttributes() ?>>
<?php echo $bcode_s->despatch_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->production_plan->Visible) { // production_plan ?>
	<tr id="r_production_plan">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_production_plan"><?php echo $bcode_s->production_plan->caption() ?></span></td>
		<td data-name="production_plan"<?php echo $bcode_s->production_plan->cellAttributes() ?>>
<span id="el_bcode_s_production_plan">
<span<?php echo $bcode_s->production_plan->viewAttributes() ?>>
<?php echo $bcode_s->production_plan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_status"><?php echo $bcode_s->status->caption() ?></span></td>
		<td data-name="status"<?php echo $bcode_s->status->cellAttributes() ?>>
<span id="el_bcode_s_status">
<span<?php echo $bcode_s->status->viewAttributes() ?>>
<?php echo $bcode_s->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->completed->Visible) { // completed ?>
	<tr id="r_completed">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_completed"><?php echo $bcode_s->completed->caption() ?></span></td>
		<td data-name="completed"<?php echo $bcode_s->completed->cellAttributes() ?>>
<span id="el_bcode_s_completed">
<span<?php echo $bcode_s->completed->viewAttributes() ?>>
<?php echo $bcode_s->completed->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->buyer_po->Visible) { // buyer_po ?>
	<tr id="r_buyer_po">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_buyer_po"><?php echo $bcode_s->buyer_po->caption() ?></span></td>
		<td data-name="buyer_po"<?php echo $bcode_s->buyer_po->cellAttributes() ?>>
<span id="el_bcode_s_buyer_po">
<span<?php echo $bcode_s->buyer_po->viewAttributes() ?>>
<?php echo $bcode_s->buyer_po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->jc_no->Visible) { // jc_no ?>
	<tr id="r_jc_no">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_jc_no"><?php echo $bcode_s->jc_no->caption() ?></span></td>
		<td data-name="jc_no"<?php echo $bcode_s->jc_no->cellAttributes() ?>>
<span id="el_bcode_s_jc_no">
<span<?php echo $bcode_s->jc_no->viewAttributes() ?>>
<?php echo $bcode_s->jc_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->pp_id->Visible) { // pp_id ?>
	<tr id="r_pp_id">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_pp_id"><?php echo $bcode_s->pp_id->caption() ?></span></td>
		<td data-name="pp_id"<?php echo $bcode_s->pp_id->cellAttributes() ?>>
<span id="el_bcode_s_pp_id">
<span<?php echo $bcode_s->pp_id->viewAttributes() ?>>
<?php echo $bcode_s->pp_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->in_id->Visible) { // in_id ?>
	<tr id="r_in_id">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_in_id"><?php echo $bcode_s->in_id->caption() ?></span></td>
		<td data-name="in_id"<?php echo $bcode_s->in_id->cellAttributes() ?>>
<span id="el_bcode_s_in_id">
<span<?php echo $bcode_s->in_id->viewAttributes() ?>>
<?php echo $bcode_s->in_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->out_id->Visible) { // out_id ?>
	<tr id="r_out_id">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_out_id"><?php echo $bcode_s->out_id->caption() ?></span></td>
		<td data-name="out_id"<?php echo $bcode_s->out_id->cellAttributes() ?>>
<span id="el_bcode_s_out_id">
<span<?php echo $bcode_s->out_id->viewAttributes() ?>>
<?php echo $bcode_s->out_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode_s->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $bcode_s_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_remarks"><?php echo $bcode_s->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $bcode_s->remarks->cellAttributes() ?>>
<span id="el_bcode_s_remarks">
<span<?php echo $bcode_s->remarks->viewAttributes() ?>>
<?php echo $bcode_s->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$bcode_s_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bcode_s->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bcode_s_view->terminate();
?>