<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_token_edit = new bcode_token_edit();

// Run the page
$bcode_token_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_token_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbcode_tokenedit = currentForm = new ew.Form("fbcode_tokenedit", "edit");

// Validate form
fbcode_tokenedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bcode_token_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->po->caption(), $bcode_token->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->_barcode->caption(), $bcode_token->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_edit->buyer_uid->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->buyer_uid->caption(), $bcode_token->buyer_uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_edit->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->design_id->caption(), $bcode_token->design_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_edit->size_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_size_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->size_cm->caption(), $bcode_token->size_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->id->caption(), $bcode_token->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_edit->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->weaving_works->caption(), $bcode_token->weaving_works->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode_token->weaving_works->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbcode_tokenedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_tokenedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_tokenedit.lists["x_design_id"] = <?php echo $bcode_token_edit->design_id->Lookup->toClientList() ?>;
fbcode_tokenedit.lists["x_design_id"].options = <?php echo JsonEncode($bcode_token_edit->design_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_token_edit->showPageHeader(); ?>
<?php
$bcode_token_edit->showMessage();
?>
<form name="fbcode_tokenedit" id="fbcode_tokenedit" class="<?php echo $bcode_token_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_token_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_token_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_token">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_token_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($bcode_token->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_bcode_token_po" for="x_po" class="<?php echo $bcode_token_edit->LeftColumnClass ?>"><?php echo $bcode_token->po->caption() ?><?php echo ($bcode_token->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_token_edit->RightColumnClass ?>"><div<?php echo $bcode_token->po->cellAttributes() ?>>
<span id="el_bcode_token_po">
<span<?php echo $bcode_token->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($bcode_token->po->CurrentValue) ?>">
<?php echo $bcode_token->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_bcode_token__barcode" for="x__barcode" class="<?php echo $bcode_token_edit->LeftColumnClass ?>"><?php echo $bcode_token->_barcode->caption() ?><?php echo ($bcode_token->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_token_edit->RightColumnClass ?>"><div<?php echo $bcode_token->_barcode->cellAttributes() ?>>
<span id="el_bcode_token__barcode">
<span<?php echo $bcode_token->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x__barcode" name="x__barcode" id="x__barcode" value="<?php echo HtmlEncode($bcode_token->_barcode->CurrentValue) ?>">
<?php echo $bcode_token->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label id="elh_bcode_token_buyer_uid" for="x_buyer_uid" class="<?php echo $bcode_token_edit->LeftColumnClass ?>"><?php echo $bcode_token->buyer_uid->caption() ?><?php echo ($bcode_token->buyer_uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_token_edit->RightColumnClass ?>"><div<?php echo $bcode_token->buyer_uid->cellAttributes() ?>>
<span id="el_bcode_token_buyer_uid">
<input type="text" data-table="bcode_token" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_token->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_token->buyer_uid->EditValue ?>"<?php echo $bcode_token->buyer_uid->editAttributes() ?>>
</span>
<?php echo $bcode_token->buyer_uid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label id="elh_bcode_token_design_id" for="x_design_id" class="<?php echo $bcode_token_edit->LeftColumnClass ?>"><?php echo $bcode_token->design_id->caption() ?><?php echo ($bcode_token->design_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_token_edit->RightColumnClass ?>"><div<?php echo $bcode_token->design_id->cellAttributes() ?>>
<span id="el_bcode_token_design_id">
<span<?php echo $bcode_token->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_token->design_id->EditValue)) && $bcode_token->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_token->design_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->design_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->design_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_design_id" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($bcode_token->design_id->CurrentValue) ?>">
<?php echo $bcode_token->design_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label id="elh_bcode_token_size_cm" for="x_size_cm" class="<?php echo $bcode_token_edit->LeftColumnClass ?>"><?php echo $bcode_token->size_cm->caption() ?><?php echo ($bcode_token->size_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_token_edit->RightColumnClass ?>"><div<?php echo $bcode_token->size_cm->cellAttributes() ?>>
<span id="el_bcode_token_size_cm">
<span<?php echo $bcode_token->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->size_cm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" value="<?php echo HtmlEncode($bcode_token->size_cm->CurrentValue) ?>">
<?php echo $bcode_token->size_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_bcode_token_id" class="<?php echo $bcode_token_edit->LeftColumnClass ?>"><?php echo $bcode_token->id->caption() ?><?php echo ($bcode_token->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_token_edit->RightColumnClass ?>"><div<?php echo $bcode_token->id->cellAttributes() ?>>
<span id="el_bcode_token_id">
<input type="text" data-table="bcode_token" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bcode_token->id->getPlaceHolder()) ?>" value="<?php echo $bcode_token->id->EditValue ?>"<?php echo $bcode_token->id->editAttributes() ?>>
</span>
<?php echo $bcode_token->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label id="elh_bcode_token_weaving_works" for="x_weaving_works" class="<?php echo $bcode_token_edit->LeftColumnClass ?>"><?php echo $bcode_token->weaving_works->caption() ?><?php echo ($bcode_token->weaving_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_token_edit->RightColumnClass ?>"><div<?php echo $bcode_token->weaving_works->cellAttributes() ?>>
<span id="el_bcode_token_weaving_works">
<input type="text" data-table="bcode_token" data-field="x_weaving_works" name="x_weaving_works" id="x_weaving_works" size="30" placeholder="<?php echo HtmlEncode($bcode_token->weaving_works->getPlaceHolder()) ?>" value="<?php echo $bcode_token->weaving_works->EditValue ?>"<?php echo $bcode_token->weaving_works->editAttributes() ?>>
</span>
<?php echo $bcode_token->weaving_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bcode_token_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bcode_token_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $bcode_token_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_token_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_token_edit->terminate();
?>