<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_token_list = new bcode_token_list();

// Run the page
$bcode_token_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_token_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bcode_token->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbcode_tokenlist = currentForm = new ew.Form("fbcode_tokenlist", "list");
fbcode_tokenlist.formKeyCountName = '<?php echo $bcode_token_list->FormKeyCountName ?>';

// Validate form
fbcode_tokenlist.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bcode_token_list->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->po->caption(), $bcode_token->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_list->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->_barcode->caption(), $bcode_token->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_list->buyer_uid->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->buyer_uid->caption(), $bcode_token->buyer_uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_list->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->design_id->caption(), $bcode_token->design_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_list->size_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_size_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->size_cm->caption(), $bcode_token->size_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_list->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->id->caption(), $bcode_token->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_token_list->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode_token->weaving_works->caption(), $bcode_token->weaving_works->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode_token->weaving_works->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbcode_tokenlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_tokenlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_tokenlist.lists["x_design_id"] = <?php echo $bcode_token_list->design_id->Lookup->toClientList() ?>;
fbcode_tokenlist.lists["x_design_id"].options = <?php echo JsonEncode($bcode_token_list->design_id->lookupOptions()) ?>;

// Form object for search
var fbcode_tokenlistsrch = currentSearchForm = new ew.Form("fbcode_tokenlistsrch");

// Validate function for search
fbcode_tokenlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_token->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_token->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbcode_tokenlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_tokenlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fbcode_tokenlistsrch.filterList = <?php echo $bcode_token_list->getFilterList() ?>;

// Init search panel as collapsed
fbcode_tokenlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bcode_token->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($bcode_token_list->TotalRecs > 0 && $bcode_token_list->ExportOptions->visible()) { ?>
<?php $bcode_token_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_token_list->ImportOptions->visible()) { ?>
<?php $bcode_token_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_token_list->SearchOptions->visible()) { ?>
<?php $bcode_token_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_token_list->FilterOptions->visible()) { ?>
<?php $bcode_token_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$bcode_token_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$bcode_token->isExport() && !$bcode_token->CurrentAction) { ?>
<form name="fbcode_tokenlistsrch" id="fbcode_tokenlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($bcode_token_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbcode_tokenlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bcode_token">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$bcode_token_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$bcode_token->RowType = ROWTYPE_SEARCH;

// Render row
$bcode_token->resetAttributes();
$bcode_token_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($bcode_token->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $bcode_token->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode_token" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($bcode_token->po->getPlaceHolder()) ?>" value="<?php echo $bcode_token->po->EditValue ?>"<?php echo $bcode_token->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($bcode_token->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $bcode_token->_barcode->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode_token" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_token->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_token->_barcode->EditValue ?>"<?php echo $bcode_token->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($bcode_token->buyer_uid->Visible) { // buyer_uid ?>
	<div id="xsc_buyer_uid" class="ew-cell form-group">
		<label for="x_buyer_uid" class="ew-search-caption ew-label"><?php echo $bcode_token->buyer_uid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode_token" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_token->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_token->buyer_uid->EditValue ?>"<?php echo $bcode_token->buyer_uid->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($bcode_token_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($bcode_token_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $bcode_token_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($bcode_token_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($bcode_token_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($bcode_token_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($bcode_token_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bcode_token_list->showPageHeader(); ?>
<?php
$bcode_token_list->showMessage();
?>
<?php if ($bcode_token_list->TotalRecs > 0 || $bcode_token->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($bcode_token_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> bcode_token">
<?php if (!$bcode_token->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$bcode_token->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_token_list->Pager)) $bcode_token_list->Pager = new PrevNextPager($bcode_token_list->StartRec, $bcode_token_list->DisplayRecs, $bcode_token_list->TotalRecs, $bcode_token_list->AutoHidePager) ?>
<?php if ($bcode_token_list->Pager->RecordCount > 0 && $bcode_token_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_token_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_token_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_token_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_token_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_token_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_token_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_token_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_token_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_token_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_token_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_token_list->TotalRecs > 0 && (!$bcode_token_list->AutoHidePageSizeSelector || $bcode_token_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode_token">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_token_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_token_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_token_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_token_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_token_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode_token->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_token_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbcode_tokenlist" id="fbcode_tokenlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_token_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_token_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_token">
<div id="gmp_bcode_token" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($bcode_token_list->TotalRecs > 0 || $bcode_token->isGridEdit()) { ?>
<table id="tbl_bcode_tokenlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$bcode_token_list->RowType = ROWTYPE_HEADER;

// Render list options
$bcode_token_list->renderListOptions();

// Render list options (header, left)
$bcode_token_list->ListOptions->render("header", "left");
?>
<?php if ($bcode_token->po->Visible) { // po ?>
	<?php if ($bcode_token->sortUrl($bcode_token->po) == "") { ?>
		<th data-name="po" class="<?php echo $bcode_token->po->headerCellClass() ?>"><div id="elh_bcode_token_po" class="bcode_token_po"><div class="ew-table-header-caption"><?php echo $bcode_token->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $bcode_token->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_token->SortUrl($bcode_token->po) ?>',2);"><div id="elh_bcode_token_po" class="bcode_token_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_token->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_token->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_token->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_token->_barcode->Visible) { // barcode ?>
	<?php if ($bcode_token->sortUrl($bcode_token->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $bcode_token->_barcode->headerCellClass() ?>"><div id="elh_bcode_token__barcode" class="bcode_token__barcode"><div class="ew-table-header-caption"><?php echo $bcode_token->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $bcode_token->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_token->SortUrl($bcode_token->_barcode) ?>',2);"><div id="elh_bcode_token__barcode" class="bcode_token__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_token->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_token->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_token->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_token->buyer_uid->Visible) { // buyer_uid ?>
	<?php if ($bcode_token->sortUrl($bcode_token->buyer_uid) == "") { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode_token->buyer_uid->headerCellClass() ?>"><div id="elh_bcode_token_buyer_uid" class="bcode_token_buyer_uid"><div class="ew-table-header-caption"><?php echo $bcode_token->buyer_uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode_token->buyer_uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_token->SortUrl($bcode_token->buyer_uid) ?>',2);"><div id="elh_bcode_token_buyer_uid" class="bcode_token_buyer_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_token->buyer_uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_token->buyer_uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_token->buyer_uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_token->design_id->Visible) { // design_id ?>
	<?php if ($bcode_token->sortUrl($bcode_token->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $bcode_token->design_id->headerCellClass() ?>"><div id="elh_bcode_token_design_id" class="bcode_token_design_id"><div class="ew-table-header-caption"><?php echo $bcode_token->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $bcode_token->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_token->SortUrl($bcode_token->design_id) ?>',2);"><div id="elh_bcode_token_design_id" class="bcode_token_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_token->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_token->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_token->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_token->size_cm->Visible) { // size_cm ?>
	<?php if ($bcode_token->sortUrl($bcode_token->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $bcode_token->size_cm->headerCellClass() ?>"><div id="elh_bcode_token_size_cm" class="bcode_token_size_cm"><div class="ew-table-header-caption"><?php echo $bcode_token->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $bcode_token->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_token->SortUrl($bcode_token->size_cm) ?>',2);"><div id="elh_bcode_token_size_cm" class="bcode_token_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_token->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode_token->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_token->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_token->id->Visible) { // id ?>
	<?php if ($bcode_token->sortUrl($bcode_token->id) == "") { ?>
		<th data-name="id" class="<?php echo $bcode_token->id->headerCellClass() ?>"><div id="elh_bcode_token_id" class="bcode_token_id"><div class="ew-table-header-caption"><?php echo $bcode_token->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $bcode_token->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_token->SortUrl($bcode_token->id) ?>',2);"><div id="elh_bcode_token_id" class="bcode_token_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_token->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_token->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_token->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode_token->weaving_works->Visible) { // weaving_works ?>
	<?php if ($bcode_token->sortUrl($bcode_token->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $bcode_token->weaving_works->headerCellClass() ?>"><div id="elh_bcode_token_weaving_works" class="bcode_token_weaving_works"><div class="ew-table-header-caption"><?php echo $bcode_token->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $bcode_token->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode_token->SortUrl($bcode_token->weaving_works) ?>',2);"><div id="elh_bcode_token_weaving_works" class="bcode_token_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode_token->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode_token->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode_token->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bcode_token_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bcode_token->ExportAll && $bcode_token->isExport()) {
	$bcode_token_list->StopRec = $bcode_token_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bcode_token_list->TotalRecs > $bcode_token_list->StartRec + $bcode_token_list->DisplayRecs - 1)
		$bcode_token_list->StopRec = $bcode_token_list->StartRec + $bcode_token_list->DisplayRecs - 1;
	else
		$bcode_token_list->StopRec = $bcode_token_list->TotalRecs;
}

// Restore number of post back records
if ($CurrentForm && $bcode_token_list->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($bcode_token_list->FormKeyCountName) && ($bcode_token->isGridAdd() || $bcode_token->isGridEdit() || $bcode_token->isConfirm())) {
		$bcode_token_list->KeyCount = $CurrentForm->getValue($bcode_token_list->FormKeyCountName);
		$bcode_token_list->StopRec = $bcode_token_list->StartRec + $bcode_token_list->KeyCount - 1;
	}
}
$bcode_token_list->RecCnt = $bcode_token_list->StartRec - 1;
if ($bcode_token_list->Recordset && !$bcode_token_list->Recordset->EOF) {
	$bcode_token_list->Recordset->moveFirst();
	$selectLimit = $bcode_token_list->UseSelectLimit;
	if (!$selectLimit && $bcode_token_list->StartRec > 1)
		$bcode_token_list->Recordset->move($bcode_token_list->StartRec - 1);
} elseif (!$bcode_token->AllowAddDeleteRow && $bcode_token_list->StopRec == 0) {
	$bcode_token_list->StopRec = $bcode_token->GridAddRowCount;
}

// Initialize aggregate
$bcode_token->RowType = ROWTYPE_AGGREGATEINIT;
$bcode_token->resetAttributes();
$bcode_token_list->renderRow();
if ($bcode_token->isGridEdit())
	$bcode_token_list->RowIndex = 0;
while ($bcode_token_list->RecCnt < $bcode_token_list->StopRec) {
	$bcode_token_list->RecCnt++;
	if ($bcode_token_list->RecCnt >= $bcode_token_list->StartRec) {
		$bcode_token_list->RowCnt++;
		if ($bcode_token->isGridAdd() || $bcode_token->isGridEdit() || $bcode_token->isConfirm()) {
			$bcode_token_list->RowIndex++;
			$CurrentForm->Index = $bcode_token_list->RowIndex;
			if ($CurrentForm->hasValue($bcode_token_list->FormActionName) && $bcode_token_list->EventCancelled)
				$bcode_token_list->RowAction = strval($CurrentForm->getValue($bcode_token_list->FormActionName));
			elseif ($bcode_token->isGridAdd())
				$bcode_token_list->RowAction = "insert";
			else
				$bcode_token_list->RowAction = "";
		}

		// Set up key count
		$bcode_token_list->KeyCount = $bcode_token_list->RowIndex;

		// Init row class and style
		$bcode_token->resetAttributes();
		$bcode_token->CssClass = "";
		if ($bcode_token->isGridAdd()) {
			$bcode_token_list->loadRowValues(); // Load default values
		} else {
			$bcode_token_list->loadRowValues($bcode_token_list->Recordset); // Load row values
		}
		$bcode_token->RowType = ROWTYPE_VIEW; // Render view
		if ($bcode_token->isGridEdit()) { // Grid edit
			if ($bcode_token->EventCancelled)
				$bcode_token_list->restoreCurrentRowFormValues($bcode_token_list->RowIndex); // Restore form values
			if ($bcode_token_list->RowAction == "insert")
				$bcode_token->RowType = ROWTYPE_ADD; // Render add
			else
				$bcode_token->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($bcode_token->isGridEdit() && ($bcode_token->RowType == ROWTYPE_EDIT || $bcode_token->RowType == ROWTYPE_ADD) && $bcode_token->EventCancelled) // Update failed
			$bcode_token_list->restoreCurrentRowFormValues($bcode_token_list->RowIndex); // Restore form values
		if ($bcode_token->RowType == ROWTYPE_EDIT) // Edit row
			$bcode_token_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$bcode_token->RowAttrs = array_merge($bcode_token->RowAttrs, array('data-rowindex'=>$bcode_token_list->RowCnt, 'id'=>'r' . $bcode_token_list->RowCnt . '_bcode_token', 'data-rowtype'=>$bcode_token->RowType));

		// Render row
		$bcode_token_list->renderRow();

		// Render list options
		$bcode_token_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($bcode_token_list->RowAction <> "delete" && $bcode_token_list->RowAction <> "insertdelete" && !($bcode_token_list->RowAction == "insert" && $bcode_token->isConfirm() && $bcode_token_list->emptyRow())) {
?>
	<tr<?php echo $bcode_token->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bcode_token_list->ListOptions->render("body", "left", $bcode_token_list->RowCnt);
?>
	<?php if ($bcode_token->po->Visible) { // po ?>
		<td data-name="po"<?php echo $bcode_token->po->cellAttributes() ?>>
<?php if ($bcode_token->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_po" class="form-group bcode_token_po">
<input type="text" data-table="bcode_token" data-field="x_po" name="x<?php echo $bcode_token_list->RowIndex ?>_po" id="x<?php echo $bcode_token_list->RowIndex ?>_po" size="30" placeholder="<?php echo HtmlEncode($bcode_token->po->getPlaceHolder()) ?>" value="<?php echo $bcode_token->po->EditValue ?>"<?php echo $bcode_token->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_po" name="o<?php echo $bcode_token_list->RowIndex ?>_po" id="o<?php echo $bcode_token_list->RowIndex ?>_po" value="<?php echo HtmlEncode($bcode_token->po->OldValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_po" class="form-group bcode_token_po">
<span<?php echo $bcode_token->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_po" name="x<?php echo $bcode_token_list->RowIndex ?>_po" id="x<?php echo $bcode_token_list->RowIndex ?>_po" value="<?php echo HtmlEncode($bcode_token->po->CurrentValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_po" class="bcode_token_po">
<span<?php echo $bcode_token->po->viewAttributes() ?>>
<?php echo $bcode_token->po->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bcode_token->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $bcode_token->_barcode->cellAttributes() ?>>
<?php if ($bcode_token->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token__barcode" class="form-group bcode_token__barcode">
<input type="text" data-table="bcode_token" data-field="x__barcode" name="x<?php echo $bcode_token_list->RowIndex ?>__barcode" id="x<?php echo $bcode_token_list->RowIndex ?>__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_token->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_token->_barcode->EditValue ?>"<?php echo $bcode_token->_barcode->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x__barcode" name="o<?php echo $bcode_token_list->RowIndex ?>__barcode" id="o<?php echo $bcode_token_list->RowIndex ?>__barcode" value="<?php echo HtmlEncode($bcode_token->_barcode->OldValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token__barcode" class="form-group bcode_token__barcode">
<span<?php echo $bcode_token->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x__barcode" name="x<?php echo $bcode_token_list->RowIndex ?>__barcode" id="x<?php echo $bcode_token_list->RowIndex ?>__barcode" value="<?php echo HtmlEncode($bcode_token->_barcode->CurrentValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token__barcode" class="bcode_token__barcode">
<span<?php echo $bcode_token->_barcode->viewAttributes() ?>>
<?php echo $bcode_token->_barcode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bcode_token->buyer_uid->Visible) { // buyer_uid ?>
		<td data-name="buyer_uid"<?php echo $bcode_token->buyer_uid->cellAttributes() ?>>
<?php if ($bcode_token->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_buyer_uid" class="form-group bcode_token_buyer_uid">
<input type="text" data-table="bcode_token" data-field="x_buyer_uid" name="x<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" id="x<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_token->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_token->buyer_uid->EditValue ?>"<?php echo $bcode_token->buyer_uid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_buyer_uid" name="o<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" id="o<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" value="<?php echo HtmlEncode($bcode_token->buyer_uid->OldValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_buyer_uid" class="form-group bcode_token_buyer_uid">
<input type="text" data-table="bcode_token" data-field="x_buyer_uid" name="x<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" id="x<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_token->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_token->buyer_uid->EditValue ?>"<?php echo $bcode_token->buyer_uid->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_buyer_uid" class="bcode_token_buyer_uid">
<span<?php echo $bcode_token->buyer_uid->viewAttributes() ?>>
<?php echo $bcode_token->buyer_uid->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bcode_token->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $bcode_token->design_id->cellAttributes() ?>>
<?php if ($bcode_token->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_design_id" class="form-group bcode_token_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_token" data-field="x_design_id" data-value-separator="<?php echo $bcode_token->design_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $bcode_token_list->RowIndex ?>_design_id" name="x<?php echo $bcode_token_list->RowIndex ?>_design_id"<?php echo $bcode_token->design_id->editAttributes() ?>>
		<?php echo $bcode_token->design_id->selectOptionListHtml("x<?php echo $bcode_token_list->RowIndex ?>_design_id") ?>
	</select>
</div>
<?php echo $bcode_token->design_id->Lookup->getParamTag("p_x" . $bcode_token_list->RowIndex . "_design_id") ?>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_design_id" name="o<?php echo $bcode_token_list->RowIndex ?>_design_id" id="o<?php echo $bcode_token_list->RowIndex ?>_design_id" value="<?php echo HtmlEncode($bcode_token->design_id->OldValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_design_id" class="form-group bcode_token_design_id">
<span<?php echo $bcode_token->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_token->design_id->EditValue)) && $bcode_token->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_token->design_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->design_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->design_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_design_id" name="x<?php echo $bcode_token_list->RowIndex ?>_design_id" id="x<?php echo $bcode_token_list->RowIndex ?>_design_id" value="<?php echo HtmlEncode($bcode_token->design_id->CurrentValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_design_id" class="bcode_token_design_id">
<span<?php echo $bcode_token->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode_token->design_id->getViewValue())) && $bcode_token->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode_token->design_id->linkAttributes() ?>><?php echo $bcode_token->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode_token->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bcode_token->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $bcode_token->size_cm->cellAttributes() ?>>
<?php if ($bcode_token->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_size_cm" class="form-group bcode_token_size_cm">
<input type="text" data-table="bcode_token" data-field="x_size_cm" name="x<?php echo $bcode_token_list->RowIndex ?>_size_cm" id="x<?php echo $bcode_token_list->RowIndex ?>_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode_token->size_cm->getPlaceHolder()) ?>" value="<?php echo $bcode_token->size_cm->EditValue ?>"<?php echo $bcode_token->size_cm->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_size_cm" name="o<?php echo $bcode_token_list->RowIndex ?>_size_cm" id="o<?php echo $bcode_token_list->RowIndex ?>_size_cm" value="<?php echo HtmlEncode($bcode_token->size_cm->OldValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_size_cm" class="form-group bcode_token_size_cm">
<span<?php echo $bcode_token->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode_token->size_cm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_size_cm" name="x<?php echo $bcode_token_list->RowIndex ?>_size_cm" id="x<?php echo $bcode_token_list->RowIndex ?>_size_cm" value="<?php echo HtmlEncode($bcode_token->size_cm->CurrentValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_size_cm" class="bcode_token_size_cm">
<span<?php echo $bcode_token->size_cm->viewAttributes() ?>>
<?php echo $bcode_token->size_cm->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bcode_token->id->Visible) { // id ?>
		<td data-name="id"<?php echo $bcode_token->id->cellAttributes() ?>>
<?php if ($bcode_token->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="bcode_token" data-field="x_id" name="o<?php echo $bcode_token_list->RowIndex ?>_id" id="o<?php echo $bcode_token_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bcode_token->id->OldValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_id" class="form-group bcode_token_id">
<input type="text" data-table="bcode_token" data-field="x_id" name="x<?php echo $bcode_token_list->RowIndex ?>_id" id="x<?php echo $bcode_token_list->RowIndex ?>_id" placeholder="<?php echo HtmlEncode($bcode_token->id->getPlaceHolder()) ?>" value="<?php echo $bcode_token->id->EditValue ?>"<?php echo $bcode_token->id->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_id" class="bcode_token_id">
<span<?php echo $bcode_token->id->viewAttributes() ?>>
<?php echo $bcode_token->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bcode_token->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $bcode_token->weaving_works->cellAttributes() ?>>
<?php if ($bcode_token->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_weaving_works" class="form-group bcode_token_weaving_works">
<input type="text" data-table="bcode_token" data-field="x_weaving_works" name="x<?php echo $bcode_token_list->RowIndex ?>_weaving_works" id="x<?php echo $bcode_token_list->RowIndex ?>_weaving_works" size="30" placeholder="<?php echo HtmlEncode($bcode_token->weaving_works->getPlaceHolder()) ?>" value="<?php echo $bcode_token->weaving_works->EditValue ?>"<?php echo $bcode_token->weaving_works->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_weaving_works" name="o<?php echo $bcode_token_list->RowIndex ?>_weaving_works" id="o<?php echo $bcode_token_list->RowIndex ?>_weaving_works" value="<?php echo HtmlEncode($bcode_token->weaving_works->OldValue) ?>">
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_weaving_works" class="form-group bcode_token_weaving_works">
<input type="text" data-table="bcode_token" data-field="x_weaving_works" name="x<?php echo $bcode_token_list->RowIndex ?>_weaving_works" id="x<?php echo $bcode_token_list->RowIndex ?>_weaving_works" size="30" placeholder="<?php echo HtmlEncode($bcode_token->weaving_works->getPlaceHolder()) ?>" value="<?php echo $bcode_token->weaving_works->EditValue ?>"<?php echo $bcode_token->weaving_works->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($bcode_token->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bcode_token_list->RowCnt ?>_bcode_token_weaving_works" class="bcode_token_weaving_works">
<span<?php echo $bcode_token->weaving_works->viewAttributes() ?>>
<?php echo $bcode_token->weaving_works->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bcode_token_list->ListOptions->render("body", "right", $bcode_token_list->RowCnt);
?>
	</tr>
<?php if ($bcode_token->RowType == ROWTYPE_ADD || $bcode_token->RowType == ROWTYPE_EDIT) { ?>
<script>
fbcode_tokenlist.updateLists(<?php echo $bcode_token_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$bcode_token->isGridAdd())
		if (!$bcode_token_list->Recordset->EOF)
			$bcode_token_list->Recordset->moveNext();
}
?>
<?php
	if ($bcode_token->isGridAdd() || $bcode_token->isGridEdit()) {
		$bcode_token_list->RowIndex = '$rowindex$';
		$bcode_token_list->loadRowValues();

		// Set row properties
		$bcode_token->resetAttributes();
		$bcode_token->RowAttrs = array_merge($bcode_token->RowAttrs, array('data-rowindex'=>$bcode_token_list->RowIndex, 'id'=>'r0_bcode_token', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($bcode_token->RowAttrs["class"], "ew-template");
		$bcode_token->RowType = ROWTYPE_ADD;

		// Render row
		$bcode_token_list->renderRow();

		// Render list options
		$bcode_token_list->renderListOptions();
		$bcode_token_list->StartRowCnt = 0;
?>
	<tr<?php echo $bcode_token->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bcode_token_list->ListOptions->render("body", "left", $bcode_token_list->RowIndex);
?>
	<?php if ($bcode_token->po->Visible) { // po ?>
		<td data-name="po">
<span id="el$rowindex$_bcode_token_po" class="form-group bcode_token_po">
<input type="text" data-table="bcode_token" data-field="x_po" name="x<?php echo $bcode_token_list->RowIndex ?>_po" id="x<?php echo $bcode_token_list->RowIndex ?>_po" size="30" placeholder="<?php echo HtmlEncode($bcode_token->po->getPlaceHolder()) ?>" value="<?php echo $bcode_token->po->EditValue ?>"<?php echo $bcode_token->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_po" name="o<?php echo $bcode_token_list->RowIndex ?>_po" id="o<?php echo $bcode_token_list->RowIndex ?>_po" value="<?php echo HtmlEncode($bcode_token->po->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bcode_token->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode">
<span id="el$rowindex$_bcode_token__barcode" class="form-group bcode_token__barcode">
<input type="text" data-table="bcode_token" data-field="x__barcode" name="x<?php echo $bcode_token_list->RowIndex ?>__barcode" id="x<?php echo $bcode_token_list->RowIndex ?>__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_token->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_token->_barcode->EditValue ?>"<?php echo $bcode_token->_barcode->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x__barcode" name="o<?php echo $bcode_token_list->RowIndex ?>__barcode" id="o<?php echo $bcode_token_list->RowIndex ?>__barcode" value="<?php echo HtmlEncode($bcode_token->_barcode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bcode_token->buyer_uid->Visible) { // buyer_uid ?>
		<td data-name="buyer_uid">
<span id="el$rowindex$_bcode_token_buyer_uid" class="form-group bcode_token_buyer_uid">
<input type="text" data-table="bcode_token" data-field="x_buyer_uid" name="x<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" id="x<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_token->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_token->buyer_uid->EditValue ?>"<?php echo $bcode_token->buyer_uid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_buyer_uid" name="o<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" id="o<?php echo $bcode_token_list->RowIndex ?>_buyer_uid" value="<?php echo HtmlEncode($bcode_token->buyer_uid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bcode_token->design_id->Visible) { // design_id ?>
		<td data-name="design_id">
<span id="el$rowindex$_bcode_token_design_id" class="form-group bcode_token_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_token" data-field="x_design_id" data-value-separator="<?php echo $bcode_token->design_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $bcode_token_list->RowIndex ?>_design_id" name="x<?php echo $bcode_token_list->RowIndex ?>_design_id"<?php echo $bcode_token->design_id->editAttributes() ?>>
		<?php echo $bcode_token->design_id->selectOptionListHtml("x<?php echo $bcode_token_list->RowIndex ?>_design_id") ?>
	</select>
</div>
<?php echo $bcode_token->design_id->Lookup->getParamTag("p_x" . $bcode_token_list->RowIndex . "_design_id") ?>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_design_id" name="o<?php echo $bcode_token_list->RowIndex ?>_design_id" id="o<?php echo $bcode_token_list->RowIndex ?>_design_id" value="<?php echo HtmlEncode($bcode_token->design_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bcode_token->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm">
<span id="el$rowindex$_bcode_token_size_cm" class="form-group bcode_token_size_cm">
<input type="text" data-table="bcode_token" data-field="x_size_cm" name="x<?php echo $bcode_token_list->RowIndex ?>_size_cm" id="x<?php echo $bcode_token_list->RowIndex ?>_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode_token->size_cm->getPlaceHolder()) ?>" value="<?php echo $bcode_token->size_cm->EditValue ?>"<?php echo $bcode_token->size_cm->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_size_cm" name="o<?php echo $bcode_token_list->RowIndex ?>_size_cm" id="o<?php echo $bcode_token_list->RowIndex ?>_size_cm" value="<?php echo HtmlEncode($bcode_token->size_cm->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bcode_token->id->Visible) { // id ?>
		<td data-name="id">
<input type="hidden" data-table="bcode_token" data-field="x_id" name="o<?php echo $bcode_token_list->RowIndex ?>_id" id="o<?php echo $bcode_token_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bcode_token->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bcode_token->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works">
<span id="el$rowindex$_bcode_token_weaving_works" class="form-group bcode_token_weaving_works">
<input type="text" data-table="bcode_token" data-field="x_weaving_works" name="x<?php echo $bcode_token_list->RowIndex ?>_weaving_works" id="x<?php echo $bcode_token_list->RowIndex ?>_weaving_works" size="30" placeholder="<?php echo HtmlEncode($bcode_token->weaving_works->getPlaceHolder()) ?>" value="<?php echo $bcode_token->weaving_works->EditValue ?>"<?php echo $bcode_token->weaving_works->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_weaving_works" name="o<?php echo $bcode_token_list->RowIndex ?>_weaving_works" id="o<?php echo $bcode_token_list->RowIndex ?>_weaving_works" value="<?php echo HtmlEncode($bcode_token->weaving_works->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bcode_token_list->ListOptions->render("body", "right", $bcode_token_list->RowIndex);
?>
<script>
fbcode_tokenlist.updateLists(<?php echo $bcode_token_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($bcode_token->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $bcode_token_list->FormKeyCountName ?>" id="<?php echo $bcode_token_list->FormKeyCountName ?>" value="<?php echo $bcode_token_list->KeyCount ?>">
<?php echo $bcode_token_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$bcode_token->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($bcode_token_list->Recordset)
	$bcode_token_list->Recordset->Close();
?>
<?php if (!$bcode_token->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$bcode_token->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_token_list->Pager)) $bcode_token_list->Pager = new PrevNextPager($bcode_token_list->StartRec, $bcode_token_list->DisplayRecs, $bcode_token_list->TotalRecs, $bcode_token_list->AutoHidePager) ?>
<?php if ($bcode_token_list->Pager->RecordCount > 0 && $bcode_token_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_token_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_token_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_token_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_token_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_token_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_token_list->pageUrl() ?>start=<?php echo $bcode_token_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_token_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_token_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_token_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_token_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_token_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_token_list->TotalRecs > 0 && (!$bcode_token_list->AutoHidePageSizeSelector || $bcode_token_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode_token">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_token_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_token_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_token_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_token_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_token_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode_token->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_token_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($bcode_token_list->TotalRecs == 0 && !$bcode_token->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $bcode_token_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$bcode_token_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bcode_token->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$bcode_token->isExport()) { ?>
<script>
ew.scrollableTable("gmp_bcode_token", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bcode_token_list->terminate();
?>