<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_token_search = new bcode_token_search();

// Run the page
$bcode_token_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_token_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($bcode_token_search->IsModal) { ?>
var fbcode_tokensearch = currentAdvancedSearchForm = new ew.Form("fbcode_tokensearch", "search");
<?php } else { ?>
var fbcode_tokensearch = currentForm = new ew.Form("fbcode_tokensearch", "search");
<?php } ?>

// Form_CustomValidate event
fbcode_tokensearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcode_tokensearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcode_tokensearch.lists["x_design_id"] = <?php echo $bcode_token_search->design_id->Lookup->toClientList() ?>;
fbcode_tokensearch.lists["x_design_id"].options = <?php echo JsonEncode($bcode_token_search->design_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbcode_tokensearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_token->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_token->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_token->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weaving_works");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode_token->weaving_works->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_token_search->showPageHeader(); ?>
<?php
$bcode_token_search->showMessage();
?>
<form name="fbcode_tokensearch" id="fbcode_tokensearch" class="<?php echo $bcode_token_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_token_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_token_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode_token">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_token_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($bcode_token->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $bcode_token_search->LeftColumnClass ?>"><span id="elh_bcode_token_po"><?php echo $bcode_token->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $bcode_token_search->RightColumnClass ?>"><div<?php echo $bcode_token->po->cellAttributes() ?>>
			<span id="el_bcode_token_po">
<input type="text" data-table="bcode_token" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($bcode_token->po->getPlaceHolder()) ?>" value="<?php echo $bcode_token->po->EditValue ?>"<?php echo $bcode_token->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $bcode_token_search->LeftColumnClass ?>"><span id="elh_bcode_token__barcode"><?php echo $bcode_token->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		</label>
		<div class="<?php echo $bcode_token_search->RightColumnClass ?>"><div<?php echo $bcode_token->_barcode->cellAttributes() ?>>
			<span id="el_bcode_token__barcode">
<input type="text" data-table="bcode_token" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode_token->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode_token->_barcode->EditValue ?>"<?php echo $bcode_token->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $bcode_token_search->LeftColumnClass ?>"><span id="elh_bcode_token_buyer_uid"><?php echo $bcode_token->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_token_search->RightColumnClass ?>"><div<?php echo $bcode_token->buyer_uid->cellAttributes() ?>>
			<span id="el_bcode_token_buyer_uid">
<input type="text" data-table="bcode_token" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode_token->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode_token->buyer_uid->EditValue ?>"<?php echo $bcode_token->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $bcode_token_search->LeftColumnClass ?>"><span id="elh_bcode_token_design_id"><?php echo $bcode_token->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_token_search->RightColumnClass ?>"><div<?php echo $bcode_token->design_id->cellAttributes() ?>>
			<span id="el_bcode_token_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode_token" data-field="x_design_id" data-value-separator="<?php echo $bcode_token->design_id->displayValueSeparatorAttribute() ?>" id="x_design_id" name="x_design_id"<?php echo $bcode_token->design_id->editAttributes() ?>>
		<?php echo $bcode_token->design_id->selectOptionListHtml("x_design_id") ?>
	</select>
</div>
<?php echo $bcode_token->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $bcode_token_search->LeftColumnClass ?>"><span id="elh_bcode_token_size_cm"><?php echo $bcode_token->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_token_search->RightColumnClass ?>"><div<?php echo $bcode_token->size_cm->cellAttributes() ?>>
			<span id="el_bcode_token_size_cm">
<input type="text" data-table="bcode_token" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode_token->size_cm->getPlaceHolder()) ?>" value="<?php echo $bcode_token->size_cm->EditValue ?>"<?php echo $bcode_token->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $bcode_token_search->LeftColumnClass ?>"><span id="elh_bcode_token_id"><?php echo $bcode_token->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_token_search->RightColumnClass ?>"><div<?php echo $bcode_token->id->cellAttributes() ?>>
			<span id="el_bcode_token_id">
<input type="text" data-table="bcode_token" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bcode_token->id->getPlaceHolder()) ?>" value="<?php echo $bcode_token->id->EditValue ?>"<?php echo $bcode_token->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode_token->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $bcode_token_search->LeftColumnClass ?>"><span id="elh_bcode_token_weaving_works"><?php echo $bcode_token->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $bcode_token_search->RightColumnClass ?>"><div<?php echo $bcode_token->weaving_works->cellAttributes() ?>>
			<span id="el_bcode_token_weaving_works">
<input type="text" data-table="bcode_token" data-field="x_weaving_works" name="x_weaving_works" id="x_weaving_works" size="30" placeholder="<?php echo HtmlEncode($bcode_token->weaving_works->getPlaceHolder()) ?>" value="<?php echo $bcode_token->weaving_works->EditValue ?>"<?php echo $bcode_token->weaving_works->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bcode_token_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bcode_token_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_token_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_token_search->terminate();
?>