<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_edit = new bcode_edit();

// Run the page
$bcode_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbcodeedit = currentForm = new ew.Form("fbcodeedit", "edit");

// Validate form
fbcodeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bcode_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->id->caption(), $bcode->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->po->caption(), $bcode->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->design_id->caption(), $bcode->design_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->size_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_size_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->size_cm->caption(), $bcode->size_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->_barcode->caption(), $bcode->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->buyer_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->buyer_ref->caption(), $bcode->buyer_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->order_date->caption(), $bcode->order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->order_date->errorMessage()) ?>");
		<?php if ($bcode_edit->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->despatch_date->caption(), $bcode->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->despatch_week->caption(), $bcode->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->dispatch_week_p->Required) { ?>
			elm = this.getElements("x" + infix + "_dispatch_week_p");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->dispatch_week_p->caption(), $bcode->dispatch_week_p->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->status->caption(), $bcode->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->buyers_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyers_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->buyers_id->caption(), $bcode->buyers_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->buyer_uid->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->buyer_uid->caption(), $bcode->buyer_uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->buyer_loc->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_loc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->buyer_loc->caption(), $bcode->buyer_loc->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->quantity->caption(), $bcode->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->sqm->caption(), $bcode->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->sqm_u->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm_u");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->sqm_u->caption(), $bcode->sqm_u->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm_u");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->sqm_u->errorMessage()) ?>");
		<?php if ($bcode_edit->c_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_c_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->c_sqm->caption(), $bcode->c_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_c_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->c_sqm->errorMessage()) ?>");
		<?php if ($bcode_edit->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->weaving_works->caption(), $bcode->weaving_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->current_works->Required) { ?>
			elm = this.getElements("x" + infix + "_current_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->current_works->caption(), $bcode->current_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->size_buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_size_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->size_buyer->caption(), $bcode->size_buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->w_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->w_cm->caption(), $bcode->w_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->w_cm->errorMessage()) ?>");
		<?php if ($bcode_edit->l_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->l_cm->caption(), $bcode->l_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->l_cm->errorMessage()) ?>");
		<?php if ($bcode_edit->q_sku->Required) { ?>
			elm = this.getElements("x" + infix + "_q_sku");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->q_sku->caption(), $bcode->q_sku->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_q_sku");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->q_sku->errorMessage()) ?>");
		<?php if ($bcode_edit->po_price->Required) { ?>
			elm = this.getElements("x" + infix + "_po_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->po_price->caption(), $bcode->po_price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->po_discount->Required) { ?>
			elm = this.getElements("x" + infix + "_po_discount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->po_discount->caption(), $bcode->po_discount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_discount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->po_discount->errorMessage()) ?>");
		<?php if ($bcode_edit->po_currency->Required) { ?>
			elm = this.getElements("x" + infix + "_po_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->po_currency->caption(), $bcode->po_currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->product_type->caption(), $bcode->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->shape->caption(), $bcode->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->production_plan->caption(), $bcode->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->datetime->caption(), $bcode->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->completed->Required) { ?>
			elm = this.getElements("x" + infix + "_completed");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->completed->caption(), $bcode->completed->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->buyer_po->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->buyer_po->caption(), $bcode->buyer_po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->operator->caption(), $bcode->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->jc_no->caption(), $bcode->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->jc_no->errorMessage()) ?>");
		<?php if ($bcode_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->batch_no->caption(), $bcode->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->cs->Required) { ?>
			elm = this.getElements("x" + infix + "_cs");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->cs->caption(), $bcode->cs->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->weight->Required) { ?>
			elm = this.getElements("x" + infix + "_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->weight->caption(), $bcode->weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->weight->errorMessage()) ?>");
		<?php if ($bcode_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->remarks->caption(), $bcode->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->roll_no->Required) { ?>
			elm = this.getElements("x" + infix + "_roll_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->roll_no->caption(), $bcode->roll_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->qty->Required) { ?>
			elm = this.getElements("x" + infix + "_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->qty->caption(), $bcode->qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->pl_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->pl_no->caption(), $bcode->pl_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->category->caption(), $bcode->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->pp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->pp_id->caption(), $bcode->pp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->pp_id->errorMessage()) ?>");
		<?php if ($bcode_edit->buyer_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->buyer_barcode->caption(), $bcode->buyer_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->p_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_p_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->p_remarks->caption(), $bcode->p_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bcode_edit->roll_no_qty_tmp->Required) { ?>
			elm = this.getElements("x" + infix + "_roll_no_qty_tmp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->roll_no_qty_tmp->caption(), $bcode->roll_no_qty_tmp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_roll_no_qty_tmp");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->roll_no_qty_tmp->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbcodeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcodeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcodeedit.lists["x_design_id"] = <?php echo $bcode_edit->design_id->Lookup->toClientList() ?>;
fbcodeedit.lists["x_design_id"].options = <?php echo JsonEncode($bcode_edit->design_id->lookupOptions()) ?>;
fbcodeedit.lists["x_buyer_ref"] = <?php echo $bcode_edit->buyer_ref->Lookup->toClientList() ?>;
fbcodeedit.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_edit->buyer_ref->lookupOptions()) ?>;
fbcodeedit.lists["x_despatch_week"] = <?php echo $bcode_edit->despatch_week->Lookup->toClientList() ?>;
fbcodeedit.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_edit->despatch_week->lookupOptions()) ?>;
fbcodeedit.lists["x_dispatch_week_p"] = <?php echo $bcode_edit->dispatch_week_p->Lookup->toClientList() ?>;
fbcodeedit.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($bcode_edit->dispatch_week_p->lookupOptions()) ?>;
fbcodeedit.lists["x_status"] = <?php echo $bcode_edit->status->Lookup->toClientList() ?>;
fbcodeedit.lists["x_status"].options = <?php echo JsonEncode($bcode_edit->status->lookupOptions()) ?>;
fbcodeedit.lists["x_buyers_id"] = <?php echo $bcode_edit->buyers_id->Lookup->toClientList() ?>;
fbcodeedit.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_edit->buyers_id->lookupOptions()) ?>;
fbcodeedit.lists["x_weaving_works"] = <?php echo $bcode_edit->weaving_works->Lookup->toClientList() ?>;
fbcodeedit.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_edit->weaving_works->lookupOptions()) ?>;
fbcodeedit.lists["x_current_works"] = <?php echo $bcode_edit->current_works->Lookup->toClientList() ?>;
fbcodeedit.lists["x_current_works"].options = <?php echo JsonEncode($bcode_edit->current_works->lookupOptions()) ?>;
fbcodeedit.lists["x_po_currency"] = <?php echo $bcode_edit->po_currency->Lookup->toClientList() ?>;
fbcodeedit.lists["x_po_currency"].options = <?php echo JsonEncode($bcode_edit->po_currency->lookupOptions()) ?>;
fbcodeedit.lists["x_product_type"] = <?php echo $bcode_edit->product_type->Lookup->toClientList() ?>;
fbcodeedit.lists["x_product_type"].options = <?php echo JsonEncode($bcode_edit->product_type->options(FALSE, TRUE)) ?>;
fbcodeedit.lists["x_shape"] = <?php echo $bcode_edit->shape->Lookup->toClientList() ?>;
fbcodeedit.lists["x_shape"].options = <?php echo JsonEncode($bcode_edit->shape->lookupOptions()) ?>;
fbcodeedit.lists["x_production_plan"] = <?php echo $bcode_edit->production_plan->Lookup->toClientList() ?>;
fbcodeedit.lists["x_production_plan"].options = <?php echo JsonEncode($bcode_edit->production_plan->options(FALSE, TRUE)) ?>;
fbcodeedit.lists["x_completed"] = <?php echo $bcode_edit->completed->Lookup->toClientList() ?>;
fbcodeedit.lists["x_completed"].options = <?php echo JsonEncode($bcode_edit->completed->options(FALSE, TRUE)) ?>;
fbcodeedit.lists["x_operator"] = <?php echo $bcode_edit->operator->Lookup->toClientList() ?>;
fbcodeedit.lists["x_operator"].options = <?php echo JsonEncode($bcode_edit->operator->lookupOptions()) ?>;
fbcodeedit.lists["x_batch_no"] = <?php echo $bcode_edit->batch_no->Lookup->toClientList() ?>;
fbcodeedit.lists["x_batch_no"].options = <?php echo JsonEncode($bcode_edit->batch_no->lookupOptions()) ?>;
fbcodeedit.lists["x_cs"] = <?php echo $bcode_edit->cs->Lookup->toClientList() ?>;
fbcodeedit.lists["x_cs"].options = <?php echo JsonEncode($bcode_edit->cs->options(FALSE, TRUE)) ?>;
fbcodeedit.lists["x_category"] = <?php echo $bcode_edit->category->Lookup->toClientList() ?>;
fbcodeedit.lists["x_category"].options = <?php echo JsonEncode($bcode_edit->category->lookupOptions()) ?>;
fbcodeedit.lists["x_pp_id"] = <?php echo $bcode_edit->pp_id->Lookup->toClientList() ?>;
fbcodeedit.lists["x_pp_id"].options = <?php echo JsonEncode($bcode_edit->pp_id->lookupOptions()) ?>;
fbcodeedit.autoSuggests["x_pp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_edit->showPageHeader(); ?>
<?php
$bcode_edit->showMessage();
?>
<form name="fbcodeedit" id="fbcodeedit" class="<?php echo $bcode_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($bcode->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_bcode_id" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->id->caption() ?><?php echo ($bcode->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->id->cellAttributes() ?>>
<span id="el_bcode_id">
<span<?php echo $bcode->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($bcode->id->CurrentValue) ?>">
<?php echo $bcode->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_bcode_po" for="x_po" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->po->caption() ?><?php echo ($bcode->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->po->cellAttributes() ?>>
<span id="el_bcode_po">
<span<?php echo $bcode->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($bcode->po->CurrentValue) ?>">
<?php echo $bcode->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label id="elh_bcode_design_id" for="x_design_id" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->design_id->caption() ?><?php echo ($bcode->design_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->design_id->cellAttributes() ?>>
<span id="el_bcode_design_id">
<span<?php echo $bcode->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->design_id->EditValue)) && $bcode->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode->design_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->design_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->design_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode" data-field="x_design_id" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($bcode->design_id->CurrentValue) ?>">
<?php echo $bcode->design_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label id="elh_bcode_size_cm" for="x_size_cm" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->size_cm->caption() ?><?php echo ($bcode->size_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->size_cm->cellAttributes() ?>>
<span id="el_bcode_size_cm">
<span<?php echo $bcode->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->size_cm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" value="<?php echo HtmlEncode($bcode->size_cm->CurrentValue) ?>">
<?php echo $bcode->size_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_bcode__barcode" for="x__barcode" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->_barcode->caption() ?><?php echo ($bcode->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->_barcode->cellAttributes() ?>>
<span id="el_bcode__barcode">
<span<?php echo $bcode->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x__barcode" name="x__barcode" id="x__barcode" value="<?php echo HtmlEncode($bcode->_barcode->CurrentValue) ?>">
<?php echo $bcode->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label id="elh_bcode_buyer_ref" for="x_buyer_ref" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->buyer_ref->caption() ?><?php echo ($bcode->buyer_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->buyer_ref->cellAttributes() ?>>
<span id="el_bcode_buyer_ref">
<span<?php echo $bcode->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->buyer_ref->EditValue)) && $bcode->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $bcode->buyer_ref->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->buyer_ref->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->buyer_ref->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($bcode->buyer_ref->CurrentValue) ?>">
<?php echo $bcode->buyer_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label id="elh_bcode_order_date" for="x_order_date" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->order_date->caption() ?><?php echo ($bcode->order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->order_date->cellAttributes() ?>>
<span id="el_bcode_order_date">
<input type="text" data-table="bcode" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($bcode->order_date->getPlaceHolder()) ?>" value="<?php echo $bcode->order_date->EditValue ?>"<?php echo $bcode->order_date->editAttributes() ?>>
<?php if (!$bcode->order_date->ReadOnly && !$bcode->order_date->Disabled && !isset($bcode->order_date->EditAttrs["readonly"]) && !isset($bcode->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcodeedit", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $bcode->order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_bcode_despatch_date" for="x_despatch_date" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->despatch_date->caption() ?><?php echo ($bcode->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->despatch_date->cellAttributes() ?>>
<span id="el_bcode_despatch_date">
<span<?php echo $bcode->despatch_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->despatch_date->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" value="<?php echo HtmlEncode($bcode->despatch_date->CurrentValue) ?>">
<?php echo $bcode->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_bcode_despatch_week" for="x_despatch_week" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->despatch_week->caption() ?><?php echo ($bcode->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->despatch_week->cellAttributes() ?>>
<span id="el_bcode_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_despatch_week" data-value-separator="<?php echo $bcode->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $bcode->despatch_week->editAttributes() ?>>
		<?php echo $bcode->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $bcode->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php echo $bcode->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<div id="r_dispatch_week_p" class="form-group row">
		<label id="elh_bcode_dispatch_week_p" for="x_dispatch_week_p" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->dispatch_week_p->caption() ?><?php echo ($bcode->dispatch_week_p->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->dispatch_week_p->cellAttributes() ?>>
<span id="el_bcode_dispatch_week_p">
<span<?php echo $bcode->dispatch_week_p->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->dispatch_week_p->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_dispatch_week_p" name="x_dispatch_week_p" id="x_dispatch_week_p" value="<?php echo HtmlEncode($bcode->dispatch_week_p->CurrentValue) ?>">
<?php echo $bcode->dispatch_week_p->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_bcode_status" for="x_status" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->status->caption() ?><?php echo ($bcode->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->status->cellAttributes() ?>>
<span id="el_bcode_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_status" data-value-separator="<?php echo $bcode->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode->status->editAttributes() ?>>
		<?php echo $bcode->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $bcode->status->Lookup->getParamTag("p_x_status") ?>
</span>
<?php echo $bcode->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label id="elh_bcode_buyers_id" for="x_buyers_id" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->buyers_id->caption() ?><?php echo ($bcode->buyers_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->buyers_id->cellAttributes() ?>>
<span id="el_bcode_buyers_id">
<span<?php echo $bcode->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->buyers_id->EditValue)) && $bcode->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode->buyers_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->buyers_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->buyers_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="bcode" data-field="x_buyers_id" name="x_buyers_id" id="x_buyers_id" value="<?php echo HtmlEncode($bcode->buyers_id->CurrentValue) ?>">
<?php echo $bcode->buyers_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label id="elh_bcode_buyer_uid" for="x_buyer_uid" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->buyer_uid->caption() ?><?php echo ($bcode->buyer_uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->buyer_uid->cellAttributes() ?>>
<span id="el_bcode_buyer_uid">
<input type="text" data-table="bcode" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_uid->EditValue ?>"<?php echo $bcode->buyer_uid->editAttributes() ?>>
</span>
<?php echo $bcode->buyer_uid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_loc->Visible) { // buyer_loc ?>
	<div id="r_buyer_loc" class="form-group row">
		<label id="elh_bcode_buyer_loc" for="x_buyer_loc" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->buyer_loc->caption() ?><?php echo ($bcode->buyer_loc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->buyer_loc->cellAttributes() ?>>
<span id="el_bcode_buyer_loc">
<input type="text" data-table="bcode" data-field="x_buyer_loc" name="x_buyer_loc" id="x_buyer_loc" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode->buyer_loc->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_loc->EditValue ?>"<?php echo $bcode->buyer_loc->editAttributes() ?>>
</span>
<?php echo $bcode->buyer_loc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_bcode_quantity" for="x_quantity" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->quantity->caption() ?><?php echo ($bcode->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->quantity->cellAttributes() ?>>
<span id="el_bcode_quantity">
<span<?php echo $bcode->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->quantity->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_quantity" name="x_quantity" id="x_quantity" value="<?php echo HtmlEncode($bcode->quantity->CurrentValue) ?>">
<?php echo $bcode->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_bcode_sqm" for="x_sqm" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->sqm->caption() ?><?php echo ($bcode->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->sqm->cellAttributes() ?>>
<span id="el_bcode_sqm">
<span<?php echo $bcode->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_sqm" name="x_sqm" id="x_sqm" value="<?php echo HtmlEncode($bcode->sqm->CurrentValue) ?>">
<?php echo $bcode->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->sqm_u->Visible) { // sqm_u ?>
	<div id="r_sqm_u" class="form-group row">
		<label id="elh_bcode_sqm_u" for="x_sqm_u" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->sqm_u->caption() ?><?php echo ($bcode->sqm_u->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->sqm_u->cellAttributes() ?>>
<span id="el_bcode_sqm_u">
<input type="text" data-table="bcode" data-field="x_sqm_u" name="x_sqm_u" id="x_sqm_u" size="30" placeholder="<?php echo HtmlEncode($bcode->sqm_u->getPlaceHolder()) ?>" value="<?php echo $bcode->sqm_u->EditValue ?>"<?php echo $bcode->sqm_u->editAttributes() ?>>
</span>
<?php echo $bcode->sqm_u->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->c_sqm->Visible) { // c_sqm ?>
	<div id="r_c_sqm" class="form-group row">
		<label id="elh_bcode_c_sqm" for="x_c_sqm" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->c_sqm->caption() ?><?php echo ($bcode->c_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->c_sqm->cellAttributes() ?>>
<span id="el_bcode_c_sqm">
<input type="text" data-table="bcode" data-field="x_c_sqm" name="x_c_sqm" id="x_c_sqm" size="30" placeholder="<?php echo HtmlEncode($bcode->c_sqm->getPlaceHolder()) ?>" value="<?php echo $bcode->c_sqm->EditValue ?>"<?php echo $bcode->c_sqm->editAttributes() ?>>
</span>
<?php echo $bcode->c_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label id="elh_bcode_weaving_works" for="x_weaving_works" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->weaving_works->caption() ?><?php echo ($bcode->weaving_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->weaving_works->cellAttributes() ?>>
<span id="el_bcode_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_weaving_works" data-value-separator="<?php echo $bcode->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $bcode->weaving_works->editAttributes() ?>>
		<?php echo $bcode->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $bcode->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
<?php echo $bcode->weaving_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label id="elh_bcode_current_works" for="x_current_works" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->current_works->caption() ?><?php echo ($bcode->current_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->current_works->cellAttributes() ?>>
<span id="el_bcode_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_current_works" data-value-separator="<?php echo $bcode->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $bcode->current_works->editAttributes() ?>>
		<?php echo $bcode->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $bcode->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
<?php echo $bcode->current_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label id="elh_bcode_size_buyer" for="x_size_buyer" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->size_buyer->caption() ?><?php echo ($bcode->size_buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->size_buyer->cellAttributes() ?>>
<span id="el_bcode_size_buyer">
<input type="text" data-table="bcode" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode->size_buyer->getPlaceHolder()) ?>" value="<?php echo $bcode->size_buyer->EditValue ?>"<?php echo $bcode->size_buyer->editAttributes() ?>>
</span>
<?php echo $bcode->size_buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label id="elh_bcode_w_cm" for="x_w_cm" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->w_cm->caption() ?><?php echo ($bcode->w_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->w_cm->cellAttributes() ?>>
<span id="el_bcode_w_cm">
<input type="text" data-table="bcode" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($bcode->w_cm->getPlaceHolder()) ?>" value="<?php echo $bcode->w_cm->EditValue ?>"<?php echo $bcode->w_cm->editAttributes() ?>>
</span>
<?php echo $bcode->w_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label id="elh_bcode_l_cm" for="x_l_cm" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->l_cm->caption() ?><?php echo ($bcode->l_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->l_cm->cellAttributes() ?>>
<span id="el_bcode_l_cm">
<input type="text" data-table="bcode" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($bcode->l_cm->getPlaceHolder()) ?>" value="<?php echo $bcode->l_cm->EditValue ?>"<?php echo $bcode->l_cm->editAttributes() ?>>
</span>
<?php echo $bcode->l_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->q_sku->Visible) { // q_sku ?>
	<div id="r_q_sku" class="form-group row">
		<label id="elh_bcode_q_sku" for="x_q_sku" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->q_sku->caption() ?><?php echo ($bcode->q_sku->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->q_sku->cellAttributes() ?>>
<span id="el_bcode_q_sku">
<input type="text" data-table="bcode" data-field="x_q_sku" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($bcode->q_sku->getPlaceHolder()) ?>" value="<?php echo $bcode->q_sku->EditValue ?>"<?php echo $bcode->q_sku->editAttributes() ?>>
</span>
<?php echo $bcode->q_sku->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label id="elh_bcode_po_price" for="x_po_price" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->po_price->caption() ?><?php echo ($bcode->po_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->po_price->cellAttributes() ?>>
<span id="el_bcode_po_price">
<span<?php echo $bcode->po_price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->po_price->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_po_price" name="x_po_price" id="x_po_price" value="<?php echo HtmlEncode($bcode->po_price->CurrentValue) ?>">
<?php echo $bcode->po_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->po_discount->Visible) { // po_discount ?>
	<div id="r_po_discount" class="form-group row">
		<label id="elh_bcode_po_discount" for="x_po_discount" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->po_discount->caption() ?><?php echo ($bcode->po_discount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->po_discount->cellAttributes() ?>>
<span id="el_bcode_po_discount">
<input type="text" data-table="bcode" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" size="30" placeholder="<?php echo HtmlEncode($bcode->po_discount->getPlaceHolder()) ?>" value="<?php echo $bcode->po_discount->EditValue ?>"<?php echo $bcode->po_discount->editAttributes() ?>>
</span>
<?php echo $bcode->po_discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->po_currency->Visible) { // po_currency ?>
	<div id="r_po_currency" class="form-group row">
		<label id="elh_bcode_po_currency" for="x_po_currency" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->po_currency->caption() ?><?php echo ($bcode->po_currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->po_currency->cellAttributes() ?>>
<span id="el_bcode_po_currency">
<span<?php echo $bcode->po_currency->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->po_currency->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_po_currency" name="x_po_currency" id="x_po_currency" value="<?php echo HtmlEncode($bcode->po_currency->CurrentValue) ?>">
<?php echo $bcode->po_currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_bcode_product_type" for="x_product_type" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->product_type->caption() ?><?php echo ($bcode->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->product_type->cellAttributes() ?>>
<span id="el_bcode_product_type">
<span<?php echo $bcode->product_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->product_type->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_product_type" name="x_product_type" id="x_product_type" value="<?php echo HtmlEncode($bcode->product_type->CurrentValue) ?>">
<?php echo $bcode->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_bcode_shape" for="x_shape" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->shape->caption() ?><?php echo ($bcode->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->shape->cellAttributes() ?>>
<span id="el_bcode_shape">
<span<?php echo $bcode->shape->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->shape->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_shape" name="x_shape" id="x_shape" value="<?php echo HtmlEncode($bcode->shape->CurrentValue) ?>">
<?php echo $bcode->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_bcode_production_plan" for="x_production_plan" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->production_plan->caption() ?><?php echo ($bcode->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->production_plan->cellAttributes() ?>>
<span id="el_bcode_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_production_plan" data-value-separator="<?php echo $bcode->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $bcode->production_plan->editAttributes() ?>>
		<?php echo $bcode->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
<?php echo $bcode->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label id="elh_bcode_completed" for="x_completed" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->completed->caption() ?><?php echo ($bcode->completed->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->completed->cellAttributes() ?>>
<span id="el_bcode_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_completed" data-value-separator="<?php echo $bcode->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $bcode->completed->editAttributes() ?>>
		<?php echo $bcode->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
<?php echo $bcode->completed->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label id="elh_bcode_buyer_po" for="x_buyer_po" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->buyer_po->caption() ?><?php echo ($bcode->buyer_po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->buyer_po->cellAttributes() ?>>
<span id="el_bcode_buyer_po">
<input type="text" data-table="bcode" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode->buyer_po->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_po->EditValue ?>"<?php echo $bcode->buyer_po->editAttributes() ?>>
</span>
<?php echo $bcode->buyer_po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_bcode_jc_no" for="x_jc_no" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->jc_no->caption() ?><?php echo ($bcode->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->jc_no->cellAttributes() ?>>
<span id="el_bcode_jc_no">
<input type="text" data-table="bcode" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($bcode->jc_no->getPlaceHolder()) ?>" value="<?php echo $bcode->jc_no->EditValue ?>"<?php echo $bcode->jc_no->editAttributes() ?>>
</span>
<?php echo $bcode->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_bcode_batch_no" for="x_batch_no" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->batch_no->caption() ?><?php echo ($bcode->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->batch_no->cellAttributes() ?>>
<span id="el_bcode_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_batch_no" data-value-separator="<?php echo $bcode->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $bcode->batch_no->editAttributes() ?>>
		<?php echo $bcode->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $bcode->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php echo $bcode->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->cs->Visible) { // cs ?>
	<div id="r_cs" class="form-group row">
		<label id="elh_bcode_cs" for="x_cs" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->cs->caption() ?><?php echo ($bcode->cs->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->cs->cellAttributes() ?>>
<span id="el_bcode_cs">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_cs" data-value-separator="<?php echo $bcode->cs->displayValueSeparatorAttribute() ?>" id="x_cs" name="x_cs"<?php echo $bcode->cs->editAttributes() ?>>
		<?php echo $bcode->cs->selectOptionListHtml("x_cs") ?>
	</select>
</div>
</span>
<?php echo $bcode->cs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->weight->Visible) { // weight ?>
	<div id="r_weight" class="form-group row">
		<label id="elh_bcode_weight" for="x_weight" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->weight->caption() ?><?php echo ($bcode->weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->weight->cellAttributes() ?>>
<span id="el_bcode_weight">
<input type="text" data-table="bcode" data-field="x_weight" name="x_weight" id="x_weight" size="30" placeholder="<?php echo HtmlEncode($bcode->weight->getPlaceHolder()) ?>" value="<?php echo $bcode->weight->EditValue ?>"<?php echo $bcode->weight->editAttributes() ?>>
</span>
<?php echo $bcode->weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_bcode_remarks" for="x_remarks" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->remarks->caption() ?><?php echo ($bcode->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->remarks->cellAttributes() ?>>
<span id="el_bcode_remarks">
<input type="text" data-table="bcode" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($bcode->remarks->getPlaceHolder()) ?>" value="<?php echo $bcode->remarks->EditValue ?>"<?php echo $bcode->remarks->editAttributes() ?>>
</span>
<?php echo $bcode->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->roll_no->Visible) { // roll_no ?>
	<div id="r_roll_no" class="form-group row">
		<label id="elh_bcode_roll_no" for="x_roll_no" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->roll_no->caption() ?><?php echo ($bcode->roll_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->roll_no->cellAttributes() ?>>
<span id="el_bcode_roll_no">
<span<?php echo $bcode->roll_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->roll_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_roll_no" name="x_roll_no" id="x_roll_no" value="<?php echo HtmlEncode($bcode->roll_no->CurrentValue) ?>">
<?php echo $bcode->roll_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label id="elh_bcode_qty" for="x_qty" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->qty->caption() ?><?php echo ($bcode->qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->qty->cellAttributes() ?>>
<span id="el_bcode_qty">
<span<?php echo $bcode->qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_qty" name="x_qty" id="x_qty" value="<?php echo HtmlEncode($bcode->qty->CurrentValue) ?>">
<?php echo $bcode->qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label id="elh_bcode_pl_no" for="x_pl_no" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->pl_no->caption() ?><?php echo ($bcode->pl_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->pl_no->cellAttributes() ?>>
<span id="el_bcode_pl_no">
<span<?php echo $bcode->pl_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->pl_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" value="<?php echo HtmlEncode($bcode->pl_no->CurrentValue) ?>">
<?php echo $bcode->pl_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_bcode_category" for="x_category" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->category->caption() ?><?php echo ($bcode->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->category->cellAttributes() ?>>
<span id="el_bcode_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_category" data-value-separator="<?php echo $bcode->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $bcode->category->editAttributes() ?>>
		<?php echo $bcode->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $bcode->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $bcode->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label id="elh_bcode_pp_id" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->pp_id->caption() ?><?php echo ($bcode->pp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->pp_id->cellAttributes() ?>>
<span id="el_bcode_pp_id">
<?php
$wrkonchange = "" . trim(@$bcode->pp_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bcode->pp_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_pp_id" class="text-nowrap" style="z-index: 8410">
	<input type="text" class="form-control" name="sv_x_pp_id" id="sv_x_pp_id" value="<?php echo RemoveHtml($bcode->pp_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bcode->pp_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bcode->pp_id->getPlaceHolder()) ?>"<?php echo $bcode->pp_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode" data-field="x_pp_id" data-value-separator="<?php echo $bcode->pp_id->displayValueSeparatorAttribute() ?>" name="x_pp_id" id="x_pp_id" value="<?php echo HtmlEncode($bcode->pp_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbcodeedit.createAutoSuggest({"id":"x_pp_id","forceSelect":false});
</script>
<?php echo $bcode->pp_id->Lookup->getParamTag("p_x_pp_id") ?>
</span>
<?php echo $bcode->pp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_barcode->Visible) { // buyer_barcode ?>
	<div id="r_buyer_barcode" class="form-group row">
		<label id="elh_bcode_buyer_barcode" for="x_buyer_barcode" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->buyer_barcode->caption() ?><?php echo ($bcode->buyer_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->buyer_barcode->cellAttributes() ?>>
<span id="el_bcode_buyer_barcode">
<span<?php echo $bcode->buyer_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->buyer_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_buyer_barcode" name="x_buyer_barcode" id="x_buyer_barcode" value="<?php echo HtmlEncode($bcode->buyer_barcode->CurrentValue) ?>">
<?php echo $bcode->buyer_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label id="elh_bcode_p_remarks" for="x_p_remarks" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->p_remarks->caption() ?><?php echo ($bcode->p_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->p_remarks->cellAttributes() ?>>
<span id="el_bcode_p_remarks">
<textarea data-table="bcode" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($bcode->p_remarks->getPlaceHolder()) ?>"<?php echo $bcode->p_remarks->editAttributes() ?>><?php echo $bcode->p_remarks->EditValue ?></textarea>
</span>
<?php echo $bcode->p_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
	<div id="r_roll_no_qty_tmp" class="form-group row">
		<label id="elh_bcode_roll_no_qty_tmp" for="x_roll_no_qty_tmp" class="<?php echo $bcode_edit->LeftColumnClass ?>"><?php echo $bcode->roll_no_qty_tmp->caption() ?><?php echo ($bcode->roll_no_qty_tmp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $bcode_edit->RightColumnClass ?>"><div<?php echo $bcode->roll_no_qty_tmp->cellAttributes() ?>>
<span id="el_bcode_roll_no_qty_tmp">
<input type="text" data-table="bcode" data-field="x_roll_no_qty_tmp" name="x_roll_no_qty_tmp" id="x_roll_no_qty_tmp" size="30" placeholder="<?php echo HtmlEncode($bcode->roll_no_qty_tmp->getPlaceHolder()) ?>" value="<?php echo $bcode->roll_no_qty_tmp->EditValue ?>"<?php echo $bcode->roll_no_qty_tmp->editAttributes() ?>>
</span>
<?php echo $bcode->roll_no_qty_tmp->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bcode_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bcode_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $bcode_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_edit->terminate();
?>