<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_list = new bcode_list();

// Run the page
$bcode_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bcode->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbcodelist = currentForm = new ew.Form("fbcodelist", "list");
fbcodelist.formKeyCountName = '<?php echo $bcode_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbcodelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcodelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcodelist.lists["x_design_id"] = <?php echo $bcode_list->design_id->Lookup->toClientList() ?>;
fbcodelist.lists["x_design_id"].options = <?php echo JsonEncode($bcode_list->design_id->lookupOptions()) ?>;
fbcodelist.lists["x_process_d[]"] = <?php echo $bcode_list->process_d->Lookup->toClientList() ?>;
fbcodelist.lists["x_process_d[]"].options = <?php echo JsonEncode($bcode_list->process_d->lookupOptions()) ?>;
fbcodelist.lists["x_buyer_ref"] = <?php echo $bcode_list->buyer_ref->Lookup->toClientList() ?>;
fbcodelist.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_list->buyer_ref->lookupOptions()) ?>;
fbcodelist.lists["x_despatch_week"] = <?php echo $bcode_list->despatch_week->Lookup->toClientList() ?>;
fbcodelist.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_list->despatch_week->lookupOptions()) ?>;
fbcodelist.lists["x_dispatch_week_p"] = <?php echo $bcode_list->dispatch_week_p->Lookup->toClientList() ?>;
fbcodelist.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($bcode_list->dispatch_week_p->lookupOptions()) ?>;
fbcodelist.lists["x_status"] = <?php echo $bcode_list->status->Lookup->toClientList() ?>;
fbcodelist.lists["x_status"].options = <?php echo JsonEncode($bcode_list->status->lookupOptions()) ?>;
fbcodelist.lists["x_buyers_id"] = <?php echo $bcode_list->buyers_id->Lookup->toClientList() ?>;
fbcodelist.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_list->buyers_id->lookupOptions()) ?>;
fbcodelist.lists["x_weaving_works"] = <?php echo $bcode_list->weaving_works->Lookup->toClientList() ?>;
fbcodelist.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_list->weaving_works->lookupOptions()) ?>;
fbcodelist.lists["x_current_works"] = <?php echo $bcode_list->current_works->Lookup->toClientList() ?>;
fbcodelist.lists["x_current_works"].options = <?php echo JsonEncode($bcode_list->current_works->lookupOptions()) ?>;
fbcodelist.lists["x_po_currency"] = <?php echo $bcode_list->po_currency->Lookup->toClientList() ?>;
fbcodelist.lists["x_po_currency"].options = <?php echo JsonEncode($bcode_list->po_currency->lookupOptions()) ?>;
fbcodelist.lists["x_product_type"] = <?php echo $bcode_list->product_type->Lookup->toClientList() ?>;
fbcodelist.lists["x_product_type"].options = <?php echo JsonEncode($bcode_list->product_type->options(FALSE, TRUE)) ?>;
fbcodelist.lists["x_shape"] = <?php echo $bcode_list->shape->Lookup->toClientList() ?>;
fbcodelist.lists["x_shape"].options = <?php echo JsonEncode($bcode_list->shape->lookupOptions()) ?>;
fbcodelist.lists["x_completed"] = <?php echo $bcode_list->completed->Lookup->toClientList() ?>;
fbcodelist.lists["x_completed"].options = <?php echo JsonEncode($bcode_list->completed->options(FALSE, TRUE)) ?>;
fbcodelist.lists["x_batch_no"] = <?php echo $bcode_list->batch_no->Lookup->toClientList() ?>;
fbcodelist.lists["x_batch_no"].options = <?php echo JsonEncode($bcode_list->batch_no->lookupOptions()) ?>;
fbcodelist.lists["x_cs"] = <?php echo $bcode_list->cs->Lookup->toClientList() ?>;
fbcodelist.lists["x_cs"].options = <?php echo JsonEncode($bcode_list->cs->options(FALSE, TRUE)) ?>;
fbcodelist.lists["x_category"] = <?php echo $bcode_list->category->Lookup->toClientList() ?>;
fbcodelist.lists["x_category"].options = <?php echo JsonEncode($bcode_list->category->lookupOptions()) ?>;

// Form object for search
var fbcodelistsrch = currentSearchForm = new ew.Form("fbcodelistsrch");

// Validate function for search
fbcodelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbcodelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcodelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcodelistsrch.lists["x_status"] = <?php echo $bcode_list->status->Lookup->toClientList() ?>;
fbcodelistsrch.lists["x_status"].options = <?php echo JsonEncode($bcode_list->status->lookupOptions()) ?>;
fbcodelistsrch.lists["x_current_works"] = <?php echo $bcode_list->current_works->Lookup->toClientList() ?>;
fbcodelistsrch.lists["x_current_works"].options = <?php echo JsonEncode($bcode_list->current_works->lookupOptions()) ?>;

// Filters
fbcodelistsrch.filterList = <?php echo $bcode_list->getFilterList() ?>;

// Init search panel as collapsed
fbcodelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bcode->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($bcode_list->TotalRecs > 0 && $bcode_list->ExportOptions->visible()) { ?>
<?php $bcode_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_list->ImportOptions->visible()) { ?>
<?php $bcode_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_list->SearchOptions->visible()) { ?>
<?php $bcode_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($bcode_list->FilterOptions->visible()) { ?>
<?php $bcode_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$bcode_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$bcode->isExport() && !$bcode->CurrentAction) { ?>
<form name="fbcodelistsrch" id="fbcodelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($bcode_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbcodelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bcode">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$bcode_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$bcode->RowType = ROWTYPE_SEARCH;

// Render row
$bcode->resetAttributes();
$bcode_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($bcode->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $bcode->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($bcode->po->getPlaceHolder()) ?>" value="<?php echo $bcode->po->EditValue ?>"<?php echo $bcode->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="bcode" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($bcode->po->getPlaceHolder()) ?>" value="<?php echo $bcode->po->EditValue2 ?>"<?php echo $bcode->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($bcode->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $bcode->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode->_barcode->EditValue ?>"<?php echo $bcode->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="bcode" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode->_barcode->EditValue2 ?>"<?php echo $bcode->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($bcode->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $bcode->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_status" data-value-separator="<?php echo $bcode->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode->status->editAttributes() ?>>
		<?php echo $bcode->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $bcode->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
<?php if ($bcode->buyer_uid->Visible) { // buyer_uid ?>
	<div id="xsc_buyer_uid" class="ew-cell form-group">
		<label for="x_buyer_uid" class="ew-search-caption ew-label"><?php echo $bcode->buyer_uid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="bcode" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_uid->EditValue ?>"<?php echo $bcode->buyer_uid->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($bcode->current_works->Visible) { // current_works ?>
	<div id="xsc_current_works" class="ew-cell form-group">
		<label for="x_current_works" class="ew-search-caption ew-label"><?php echo $bcode->current_works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_current_works" data-value-separator="<?php echo $bcode->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $bcode->current_works->editAttributes() ?>>
		<?php echo $bcode->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $bcode->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($bcode_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($bcode_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $bcode_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($bcode_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($bcode_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($bcode_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($bcode_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bcode_list->showPageHeader(); ?>
<?php
$bcode_list->showMessage();
?>
<?php if ($bcode_list->TotalRecs > 0 || $bcode->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($bcode_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> bcode">
<?php if (!$bcode->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$bcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_list->Pager)) $bcode_list->Pager = new PrevNextPager($bcode_list->StartRec, $bcode_list->DisplayRecs, $bcode_list->TotalRecs, $bcode_list->AutoHidePager) ?>
<?php if ($bcode_list->Pager->RecordCount > 0 && $bcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_list->TotalRecs > 0 && (!$bcode_list->AutoHidePageSizeSelector || $bcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbcodelist" id="fbcodelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode">
<div id="gmp_bcode" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($bcode_list->TotalRecs > 0 || $bcode->isGridEdit()) { ?>
<table id="tbl_bcodelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$bcode_list->RowType = ROWTYPE_HEADER;

// Render list options
$bcode_list->renderListOptions();

// Render list options (header, left)
$bcode_list->ListOptions->render("header", "left");
?>
<?php if ($bcode->po->Visible) { // po ?>
	<?php if ($bcode->sortUrl($bcode->po) == "") { ?>
		<th data-name="po" class="<?php echo $bcode->po->headerCellClass() ?>"><div id="elh_bcode_po" class="bcode_po"><div class="ew-table-header-caption"><?php echo $bcode->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $bcode->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->po) ?>',2);"><div id="elh_bcode_po" class="bcode_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->design_id->Visible) { // design_id ?>
	<?php if ($bcode->sortUrl($bcode->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $bcode->design_id->headerCellClass() ?>"><div id="elh_bcode_design_id" class="bcode_design_id"><div class="ew-table-header-caption"><?php echo $bcode->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $bcode->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->design_id) ?>',2);"><div id="elh_bcode_design_id" class="bcode_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->size_cm->Visible) { // size_cm ?>
	<?php if ($bcode->sortUrl($bcode->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $bcode->size_cm->headerCellClass() ?>"><div id="elh_bcode_size_cm" class="bcode_size_cm"><div class="ew-table-header-caption"><?php echo $bcode->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $bcode->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->size_cm) ?>',2);"><div id="elh_bcode_size_cm" class="bcode_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_barcode->Visible) { // barcode ?>
	<?php if ($bcode->sortUrl($bcode->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $bcode->_barcode->headerCellClass() ?>" style="width: 300px;"><div id="elh_bcode__barcode" class="bcode__barcode"><div class="ew-table-header-caption"><?php echo $bcode->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $bcode->_barcode->headerCellClass() ?>" style="width: 300px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_barcode) ?>',2);"><div id="elh_bcode__barcode" class="bcode__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->process_d->Visible) { // process_d ?>
	<?php if ($bcode->sortUrl($bcode->process_d) == "") { ?>
		<th data-name="process_d" class="<?php echo $bcode->process_d->headerCellClass() ?>"><div id="elh_bcode_process_d" class="bcode_process_d"><div class="ew-table-header-caption"><?php echo $bcode->process_d->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_d" class="<?php echo $bcode->process_d->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->process_d) ?>',2);"><div id="elh_bcode_process_d" class="bcode_process_d">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->process_d->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->process_d->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->process_d->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($bcode->sortUrl($bcode->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $bcode->buyer_ref->headerCellClass() ?>"><div id="elh_bcode_buyer_ref" class="bcode_buyer_ref"><div class="ew-table-header-caption"><?php echo $bcode->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $bcode->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->buyer_ref) ?>',2);"><div id="elh_bcode_buyer_ref" class="bcode_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->buyer_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->order_date->Visible) { // order_date ?>
	<?php if ($bcode->sortUrl($bcode->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $bcode->order_date->headerCellClass() ?>"><div id="elh_bcode_order_date" class="bcode_order_date"><div class="ew-table-header-caption"><?php echo $bcode->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $bcode->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->order_date) ?>',2);"><div id="elh_bcode_order_date" class="bcode_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->despatch_date->Visible) { // despatch_date ?>
	<?php if ($bcode->sortUrl($bcode->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $bcode->despatch_date->headerCellClass() ?>"><div id="elh_bcode_despatch_date" class="bcode_despatch_date"><div class="ew-table-header-caption"><?php echo $bcode->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $bcode->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->despatch_date) ?>',2);"><div id="elh_bcode_despatch_date" class="bcode_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->despatch_week->Visible) { // despatch_week ?>
	<?php if ($bcode->sortUrl($bcode->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $bcode->despatch_week->headerCellClass() ?>"><div id="elh_bcode_despatch_week" class="bcode_despatch_week"><div class="ew-table-header-caption"><?php echo $bcode->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $bcode->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->despatch_week) ?>',2);"><div id="elh_bcode_despatch_week" class="bcode_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<?php if ($bcode->sortUrl($bcode->dispatch_week_p) == "") { ?>
		<th data-name="dispatch_week_p" class="<?php echo $bcode->dispatch_week_p->headerCellClass() ?>"><div id="elh_bcode_dispatch_week_p" class="bcode_dispatch_week_p"><div class="ew-table-header-caption"><?php echo $bcode->dispatch_week_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch_week_p" class="<?php echo $bcode->dispatch_week_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->dispatch_week_p) ?>',2);"><div id="elh_bcode_dispatch_week_p" class="bcode_dispatch_week_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->dispatch_week_p->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->dispatch_week_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->dispatch_week_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->status->Visible) { // status ?>
	<?php if ($bcode->sortUrl($bcode->status) == "") { ?>
		<th data-name="status" class="<?php echo $bcode->status->headerCellClass() ?>"><div id="elh_bcode_status" class="bcode_status"><div class="ew-table-header-caption"><?php echo $bcode->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $bcode->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->status) ?>',2);"><div id="elh_bcode_status" class="bcode_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->buyers_id->Visible) { // buyers_id ?>
	<?php if ($bcode->sortUrl($bcode->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $bcode->buyers_id->headerCellClass() ?>"><div id="elh_bcode_buyers_id" class="bcode_buyers_id"><div class="ew-table-header-caption"><?php echo $bcode->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $bcode->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->buyers_id) ?>',2);"><div id="elh_bcode_buyers_id" class="bcode_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->buyer_uid->Visible) { // buyer_uid ?>
	<?php if ($bcode->sortUrl($bcode->buyer_uid) == "") { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode->buyer_uid->headerCellClass() ?>" style="width: 200px;"><div id="elh_bcode_buyer_uid" class="bcode_buyer_uid"><div class="ew-table-header-caption"><?php echo $bcode->buyer_uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_uid" class="<?php echo $bcode->buyer_uid->headerCellClass() ?>" style="width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->buyer_uid) ?>',2);"><div id="elh_bcode_buyer_uid" class="bcode_buyer_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->buyer_uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->buyer_uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->buyer_uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->buyer_loc->Visible) { // buyer_loc ?>
	<?php if ($bcode->sortUrl($bcode->buyer_loc) == "") { ?>
		<th data-name="buyer_loc" class="<?php echo $bcode->buyer_loc->headerCellClass() ?>"><div id="elh_bcode_buyer_loc" class="bcode_buyer_loc"><div class="ew-table-header-caption"><?php echo $bcode->buyer_loc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_loc" class="<?php echo $bcode->buyer_loc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->buyer_loc) ?>',2);"><div id="elh_bcode_buyer_loc" class="bcode_buyer_loc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->buyer_loc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->buyer_loc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->buyer_loc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->quantity->Visible) { // quantity ?>
	<?php if ($bcode->sortUrl($bcode->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $bcode->quantity->headerCellClass() ?>"><div id="elh_bcode_quantity" class="bcode_quantity"><div class="ew-table-header-caption"><?php echo $bcode->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $bcode->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->quantity) ?>',2);"><div id="elh_bcode_quantity" class="bcode_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->sqm->Visible) { // sqm ?>
	<?php if ($bcode->sortUrl($bcode->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $bcode->sqm->headerCellClass() ?>"><div id="elh_bcode_sqm" class="bcode_sqm"><div class="ew-table-header-caption"><?php echo $bcode->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $bcode->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->sqm) ?>',2);"><div id="elh_bcode_sqm" class="bcode_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->sqm_u->Visible) { // sqm_u ?>
	<?php if ($bcode->sortUrl($bcode->sqm_u) == "") { ?>
		<th data-name="sqm_u" class="<?php echo $bcode->sqm_u->headerCellClass() ?>"><div id="elh_bcode_sqm_u" class="bcode_sqm_u"><div class="ew-table-header-caption"><?php echo $bcode->sqm_u->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_u" class="<?php echo $bcode->sqm_u->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->sqm_u) ?>',2);"><div id="elh_bcode_sqm_u" class="bcode_sqm_u">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->sqm_u->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->sqm_u->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->sqm_u->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->c_sqm->Visible) { // c_sqm ?>
	<?php if ($bcode->sortUrl($bcode->c_sqm) == "") { ?>
		<th data-name="c_sqm" class="<?php echo $bcode->c_sqm->headerCellClass() ?>"><div id="elh_bcode_c_sqm" class="bcode_c_sqm"><div class="ew-table-header-caption"><?php echo $bcode->c_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_sqm" class="<?php echo $bcode->c_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->c_sqm) ?>',2);"><div id="elh_bcode_c_sqm" class="bcode_c_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->c_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->c_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->c_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->weaving_works->Visible) { // weaving_works ?>
	<?php if ($bcode->sortUrl($bcode->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $bcode->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_weaving_works" class="bcode_weaving_works"><div class="ew-table-header-caption"><?php echo $bcode->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $bcode->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->weaving_works) ?>',2);"><div id="elh_bcode_weaving_works" class="bcode_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->current_works->Visible) { // current_works ?>
	<?php if ($bcode->sortUrl($bcode->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $bcode->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_current_works" class="bcode_current_works"><div class="ew-table-header-caption"><?php echo $bcode->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $bcode->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->current_works) ?>',2);"><div id="elh_bcode_current_works" class="bcode_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->q_sku->Visible) { // q_sku ?>
	<?php if ($bcode->sortUrl($bcode->q_sku) == "") { ?>
		<th data-name="q_sku" class="<?php echo $bcode->q_sku->headerCellClass() ?>"><div id="elh_bcode_q_sku" class="bcode_q_sku"><div class="ew-table-header-caption"><?php echo $bcode->q_sku->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="q_sku" class="<?php echo $bcode->q_sku->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->q_sku) ?>',2);"><div id="elh_bcode_q_sku" class="bcode_q_sku">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->q_sku->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->q_sku->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->q_sku->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->po_price->Visible) { // po_price ?>
	<?php if ($bcode->sortUrl($bcode->po_price) == "") { ?>
		<th data-name="po_price" class="<?php echo $bcode->po_price->headerCellClass() ?>"><div id="elh_bcode_po_price" class="bcode_po_price"><div class="ew-table-header-caption"><?php echo $bcode->po_price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_price" class="<?php echo $bcode->po_price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->po_price) ?>',2);"><div id="elh_bcode_po_price" class="bcode_po_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->po_price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->po_price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->po_price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->po_discount->Visible) { // po_discount ?>
	<?php if ($bcode->sortUrl($bcode->po_discount) == "") { ?>
		<th data-name="po_discount" class="<?php echo $bcode->po_discount->headerCellClass() ?>"><div id="elh_bcode_po_discount" class="bcode_po_discount"><div class="ew-table-header-caption"><?php echo $bcode->po_discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_discount" class="<?php echo $bcode->po_discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->po_discount) ?>',2);"><div id="elh_bcode_po_discount" class="bcode_po_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->po_discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->po_discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->po_discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->po_currency->Visible) { // po_currency ?>
	<?php if ($bcode->sortUrl($bcode->po_currency) == "") { ?>
		<th data-name="po_currency" class="<?php echo $bcode->po_currency->headerCellClass() ?>"><div id="elh_bcode_po_currency" class="bcode_po_currency"><div class="ew-table-header-caption"><?php echo $bcode->po_currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_currency" class="<?php echo $bcode->po_currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->po_currency) ?>',2);"><div id="elh_bcode_po_currency" class="bcode_po_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->po_currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->po_currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->po_currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->product_type->Visible) { // product_type ?>
	<?php if ($bcode->sortUrl($bcode->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $bcode->product_type->headerCellClass() ?>"><div id="elh_bcode_product_type" class="bcode_product_type"><div class="ew-table-header-caption"><?php echo $bcode->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $bcode->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->product_type) ?>',2);"><div id="elh_bcode_product_type" class="bcode_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->shape->Visible) { // shape ?>
	<?php if ($bcode->sortUrl($bcode->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $bcode->shape->headerCellClass() ?>"><div id="elh_bcode_shape" class="bcode_shape"><div class="ew-table-header-caption"><?php echo $bcode->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $bcode->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->shape) ?>',2);"><div id="elh_bcode_shape" class="bcode_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->completed->Visible) { // completed ?>
	<?php if ($bcode->sortUrl($bcode->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $bcode->completed->headerCellClass() ?>"><div id="elh_bcode_completed" class="bcode_completed"><div class="ew-table-header-caption"><?php echo $bcode->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $bcode->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->completed) ?>',2);"><div id="elh_bcode_completed" class="bcode_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->buyer_po->Visible) { // buyer_po ?>
	<?php if ($bcode->sortUrl($bcode->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $bcode->buyer_po->headerCellClass() ?>"><div id="elh_bcode_buyer_po" class="bcode_buyer_po"><div class="ew-table-header-caption"><?php echo $bcode->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $bcode->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->buyer_po) ?>',2);"><div id="elh_bcode_buyer_po" class="bcode_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->batch_no->Visible) { // batch_no ?>
	<?php if ($bcode->sortUrl($bcode->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $bcode->batch_no->headerCellClass() ?>"><div id="elh_bcode_batch_no" class="bcode_batch_no"><div class="ew-table-header-caption"><?php echo $bcode->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $bcode->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->batch_no) ?>',2);"><div id="elh_bcode_batch_no" class="bcode_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->cs->Visible) { // cs ?>
	<?php if ($bcode->sortUrl($bcode->cs) == "") { ?>
		<th data-name="cs" class="<?php echo $bcode->cs->headerCellClass() ?>"><div id="elh_bcode_cs" class="bcode_cs"><div class="ew-table-header-caption"><?php echo $bcode->cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs" class="<?php echo $bcode->cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->cs) ?>',2);"><div id="elh_bcode_cs" class="bcode_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->weight->Visible) { // weight ?>
	<?php if ($bcode->sortUrl($bcode->weight) == "") { ?>
		<th data-name="weight" class="<?php echo $bcode->weight->headerCellClass() ?>"><div id="elh_bcode_weight" class="bcode_weight"><div class="ew-table-header-caption"><?php echo $bcode->weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight" class="<?php echo $bcode->weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->weight) ?>',2);"><div id="elh_bcode_weight" class="bcode_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->remarks->Visible) { // remarks ?>
	<?php if ($bcode->sortUrl($bcode->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $bcode->remarks->headerCellClass() ?>"><div id="elh_bcode_remarks" class="bcode_remarks"><div class="ew-table-header-caption"><?php echo $bcode->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $bcode->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->remarks) ?>',2);"><div id="elh_bcode_remarks" class="bcode_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->roll_no->Visible) { // roll_no ?>
	<?php if ($bcode->sortUrl($bcode->roll_no) == "") { ?>
		<th data-name="roll_no" class="<?php echo $bcode->roll_no->headerCellClass() ?>"><div id="elh_bcode_roll_no" class="bcode_roll_no"><div class="ew-table-header-caption"><?php echo $bcode->roll_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no" class="<?php echo $bcode->roll_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->roll_no) ?>',2);"><div id="elh_bcode_roll_no" class="bcode_roll_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->roll_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->roll_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->roll_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->qty->Visible) { // qty ?>
	<?php if ($bcode->sortUrl($bcode->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $bcode->qty->headerCellClass() ?>"><div id="elh_bcode_qty" class="bcode_qty"><div class="ew-table-header-caption"><?php echo $bcode->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $bcode->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->qty) ?>',2);"><div id="elh_bcode_qty" class="bcode_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->pl_no->Visible) { // pl_no ?>
	<?php if ($bcode->sortUrl($bcode->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $bcode->pl_no->headerCellClass() ?>"><div id="elh_bcode_pl_no" class="bcode_pl_no"><div class="ew-table-header-caption"><?php echo $bcode->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $bcode->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->pl_no) ?>',2);"><div id="elh_bcode_pl_no" class="bcode_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->pl_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->category->Visible) { // category ?>
	<?php if ($bcode->sortUrl($bcode->category) == "") { ?>
		<th data-name="category" class="<?php echo $bcode->category->headerCellClass() ?>"><div id="elh_bcode_category" class="bcode_category"><div class="ew-table-header-caption"><?php echo $bcode->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $bcode->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->category) ?>',2);"><div id="elh_bcode_category" class="bcode_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->buyer_barcode->Visible) { // buyer_barcode ?>
	<?php if ($bcode->sortUrl($bcode->buyer_barcode) == "") { ?>
		<th data-name="buyer_barcode" class="<?php echo $bcode->buyer_barcode->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_buyer_barcode" class="bcode_buyer_barcode"><div class="ew-table-header-caption"><?php echo $bcode->buyer_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_barcode" class="<?php echo $bcode->buyer_barcode->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->buyer_barcode) ?>',2);"><div id="elh_bcode_buyer_barcode" class="bcode_buyer_barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->buyer_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bcode->buyer_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->buyer_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_11->Visible) { // 11 ?>
	<?php if ($bcode->sortUrl($bcode->_11) == "") { ?>
		<th data-name="_11" class="<?php echo $bcode->_11->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__11" class="bcode__11"><div class="ew-table-header-caption"><?php echo $bcode->_11->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_11" class="<?php echo $bcode->_11->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_11) ?>',2);"><div id="elh_bcode__11" class="bcode__11">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_11->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_11->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_11->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_12->Visible) { // 12 ?>
	<?php if ($bcode->sortUrl($bcode->_12) == "") { ?>
		<th data-name="_12" class="<?php echo $bcode->_12->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__12" class="bcode__12"><div class="ew-table-header-caption"><?php echo $bcode->_12->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_12" class="<?php echo $bcode->_12->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_12) ?>',2);"><div id="elh_bcode__12" class="bcode__12">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_12->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_12->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_12->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_13->Visible) { // 13 ?>
	<?php if ($bcode->sortUrl($bcode->_13) == "") { ?>
		<th data-name="_13" class="<?php echo $bcode->_13->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__13" class="bcode__13"><div class="ew-table-header-caption"><?php echo $bcode->_13->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_13" class="<?php echo $bcode->_13->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_13) ?>',2);"><div id="elh_bcode__13" class="bcode__13">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_13->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_13->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_13->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_14->Visible) { // 14 ?>
	<?php if ($bcode->sortUrl($bcode->_14) == "") { ?>
		<th data-name="_14" class="<?php echo $bcode->_14->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__14" class="bcode__14"><div class="ew-table-header-caption"><?php echo $bcode->_14->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_14" class="<?php echo $bcode->_14->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_14) ?>',2);"><div id="elh_bcode__14" class="bcode__14">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_14->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_14->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_14->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_15->Visible) { // 15 ?>
	<?php if ($bcode->sortUrl($bcode->_15) == "") { ?>
		<th data-name="_15" class="<?php echo $bcode->_15->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__15" class="bcode__15"><div class="ew-table-header-caption"><?php echo $bcode->_15->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_15" class="<?php echo $bcode->_15->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_15) ?>',2);"><div id="elh_bcode__15" class="bcode__15">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_15->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_15->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_15->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_16->Visible) { // 16 ?>
	<?php if ($bcode->sortUrl($bcode->_16) == "") { ?>
		<th data-name="_16" class="<?php echo $bcode->_16->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__16" class="bcode__16"><div class="ew-table-header-caption"><?php echo $bcode->_16->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_16" class="<?php echo $bcode->_16->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_16) ?>',2);"><div id="elh_bcode__16" class="bcode__16">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_16->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_16->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_16->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_17->Visible) { // 17 ?>
	<?php if ($bcode->sortUrl($bcode->_17) == "") { ?>
		<th data-name="_17" class="<?php echo $bcode->_17->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__17" class="bcode__17"><div class="ew-table-header-caption"><?php echo $bcode->_17->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_17" class="<?php echo $bcode->_17->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_17) ?>',2);"><div id="elh_bcode__17" class="bcode__17">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_17->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_17->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_17->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_18->Visible) { // 18 ?>
	<?php if ($bcode->sortUrl($bcode->_18) == "") { ?>
		<th data-name="_18" class="<?php echo $bcode->_18->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__18" class="bcode__18"><div class="ew-table-header-caption"><?php echo $bcode->_18->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_18" class="<?php echo $bcode->_18->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_18) ?>',2);"><div id="elh_bcode__18" class="bcode__18">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_18->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_18->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_18->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_19->Visible) { // 19 ?>
	<?php if ($bcode->sortUrl($bcode->_19) == "") { ?>
		<th data-name="_19" class="<?php echo $bcode->_19->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__19" class="bcode__19"><div class="ew-table-header-caption"><?php echo $bcode->_19->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_19" class="<?php echo $bcode->_19->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_19) ?>',2);"><div id="elh_bcode__19" class="bcode__19">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_19->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_19->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_19->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_20->Visible) { // 20 ?>
	<?php if ($bcode->sortUrl($bcode->_20) == "") { ?>
		<th data-name="_20" class="<?php echo $bcode->_20->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__20" class="bcode__20"><div class="ew-table-header-caption"><?php echo $bcode->_20->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_20" class="<?php echo $bcode->_20->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_20) ?>',2);"><div id="elh_bcode__20" class="bcode__20">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_20->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_20->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_20->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_21->Visible) { // 21 ?>
	<?php if ($bcode->sortUrl($bcode->_21) == "") { ?>
		<th data-name="_21" class="<?php echo $bcode->_21->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__21" class="bcode__21"><div class="ew-table-header-caption"><?php echo $bcode->_21->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_21" class="<?php echo $bcode->_21->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_21) ?>',2);"><div id="elh_bcode__21" class="bcode__21">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_21->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_21->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_21->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_22->Visible) { // 22 ?>
	<?php if ($bcode->sortUrl($bcode->_22) == "") { ?>
		<th data-name="_22" class="<?php echo $bcode->_22->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__22" class="bcode__22"><div class="ew-table-header-caption"><?php echo $bcode->_22->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_22" class="<?php echo $bcode->_22->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_22) ?>',2);"><div id="elh_bcode__22" class="bcode__22">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_22->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_22->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_22->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_23->Visible) { // 23 ?>
	<?php if ($bcode->sortUrl($bcode->_23) == "") { ?>
		<th data-name="_23" class="<?php echo $bcode->_23->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__23" class="bcode__23"><div class="ew-table-header-caption"><?php echo $bcode->_23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_23" class="<?php echo $bcode->_23->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_23) ?>',2);"><div id="elh_bcode__23" class="bcode__23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_23->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_24->Visible) { // 24 ?>
	<?php if ($bcode->sortUrl($bcode->_24) == "") { ?>
		<th data-name="_24" class="<?php echo $bcode->_24->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__24" class="bcode__24"><div class="ew-table-header-caption"><?php echo $bcode->_24->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_24" class="<?php echo $bcode->_24->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_24) ?>',2);"><div id="elh_bcode__24" class="bcode__24">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_24->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_24->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_24->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_25->Visible) { // 25 ?>
	<?php if ($bcode->sortUrl($bcode->_25) == "") { ?>
		<th data-name="_25" class="<?php echo $bcode->_25->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__25" class="bcode__25"><div class="ew-table-header-caption"><?php echo $bcode->_25->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_25" class="<?php echo $bcode->_25->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_25) ?>',2);"><div id="elh_bcode__25" class="bcode__25">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_25->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_25->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_25->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_26->Visible) { // 26 ?>
	<?php if ($bcode->sortUrl($bcode->_26) == "") { ?>
		<th data-name="_26" class="<?php echo $bcode->_26->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__26" class="bcode__26"><div class="ew-table-header-caption"><?php echo $bcode->_26->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_26" class="<?php echo $bcode->_26->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_26) ?>',2);"><div id="elh_bcode__26" class="bcode__26">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_26->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_26->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_26->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_27->Visible) { // 27 ?>
	<?php if ($bcode->sortUrl($bcode->_27) == "") { ?>
		<th data-name="_27" class="<?php echo $bcode->_27->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__27" class="bcode__27"><div class="ew-table-header-caption"><?php echo $bcode->_27->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_27" class="<?php echo $bcode->_27->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_27) ?>',2);"><div id="elh_bcode__27" class="bcode__27">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_27->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_27->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_27->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_28->Visible) { // 28 ?>
	<?php if ($bcode->sortUrl($bcode->_28) == "") { ?>
		<th data-name="_28" class="<?php echo $bcode->_28->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__28" class="bcode__28"><div class="ew-table-header-caption"><?php echo $bcode->_28->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_28" class="<?php echo $bcode->_28->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_28) ?>',2);"><div id="elh_bcode__28" class="bcode__28">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_28->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_28->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_28->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_29->Visible) { // 29 ?>
	<?php if ($bcode->sortUrl($bcode->_29) == "") { ?>
		<th data-name="_29" class="<?php echo $bcode->_29->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__29" class="bcode__29"><div class="ew-table-header-caption"><?php echo $bcode->_29->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_29" class="<?php echo $bcode->_29->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_29) ?>',2);"><div id="elh_bcode__29" class="bcode__29">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_29->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_29->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_29->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_30->Visible) { // 30 ?>
	<?php if ($bcode->sortUrl($bcode->_30) == "") { ?>
		<th data-name="_30" class="<?php echo $bcode->_30->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__30" class="bcode__30"><div class="ew-table-header-caption"><?php echo $bcode->_30->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_30" class="<?php echo $bcode->_30->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_30) ?>',2);"><div id="elh_bcode__30" class="bcode__30">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_30->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_30->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_30->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_31->Visible) { // 31 ?>
	<?php if ($bcode->sortUrl($bcode->_31) == "") { ?>
		<th data-name="_31" class="<?php echo $bcode->_31->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__31" class="bcode__31"><div class="ew-table-header-caption"><?php echo $bcode->_31->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_31" class="<?php echo $bcode->_31->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_31) ?>',2);"><div id="elh_bcode__31" class="bcode__31">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_31->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_31->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_31->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_32->Visible) { // 32 ?>
	<?php if ($bcode->sortUrl($bcode->_32) == "") { ?>
		<th data-name="_32" class="<?php echo $bcode->_32->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__32" class="bcode__32"><div class="ew-table-header-caption"><?php echo $bcode->_32->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_32" class="<?php echo $bcode->_32->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_32) ?>',2);"><div id="elh_bcode__32" class="bcode__32">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_32->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_32->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_32->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_33->Visible) { // 33 ?>
	<?php if ($bcode->sortUrl($bcode->_33) == "") { ?>
		<th data-name="_33" class="<?php echo $bcode->_33->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__33" class="bcode__33"><div class="ew-table-header-caption"><?php echo $bcode->_33->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_33" class="<?php echo $bcode->_33->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_33) ?>',2);"><div id="elh_bcode__33" class="bcode__33">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_33->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_33->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_33->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_34->Visible) { // 34 ?>
	<?php if ($bcode->sortUrl($bcode->_34) == "") { ?>
		<th data-name="_34" class="<?php echo $bcode->_34->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__34" class="bcode__34"><div class="ew-table-header-caption"><?php echo $bcode->_34->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_34" class="<?php echo $bcode->_34->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_34) ?>',2);"><div id="elh_bcode__34" class="bcode__34">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_34->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_34->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_34->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_35->Visible) { // 35 ?>
	<?php if ($bcode->sortUrl($bcode->_35) == "") { ?>
		<th data-name="_35" class="<?php echo $bcode->_35->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__35" class="bcode__35"><div class="ew-table-header-caption"><?php echo $bcode->_35->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_35" class="<?php echo $bcode->_35->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_35) ?>',2);"><div id="elh_bcode__35" class="bcode__35">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_35->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_35->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_35->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_36->Visible) { // 36 ?>
	<?php if ($bcode->sortUrl($bcode->_36) == "") { ?>
		<th data-name="_36" class="<?php echo $bcode->_36->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__36" class="bcode__36"><div class="ew-table-header-caption"><?php echo $bcode->_36->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_36" class="<?php echo $bcode->_36->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_36) ?>',2);"><div id="elh_bcode__36" class="bcode__36">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_36->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_36->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_36->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_37->Visible) { // 37 ?>
	<?php if ($bcode->sortUrl($bcode->_37) == "") { ?>
		<th data-name="_37" class="<?php echo $bcode->_37->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__37" class="bcode__37"><div class="ew-table-header-caption"><?php echo $bcode->_37->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_37" class="<?php echo $bcode->_37->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_37) ?>',2);"><div id="elh_bcode__37" class="bcode__37">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_37->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_37->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_37->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_38->Visible) { // 38 ?>
	<?php if ($bcode->sortUrl($bcode->_38) == "") { ?>
		<th data-name="_38" class="<?php echo $bcode->_38->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__38" class="bcode__38"><div class="ew-table-header-caption"><?php echo $bcode->_38->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_38" class="<?php echo $bcode->_38->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_38) ?>',2);"><div id="elh_bcode__38" class="bcode__38">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_38->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_38->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_38->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_39->Visible) { // 39 ?>
	<?php if ($bcode->sortUrl($bcode->_39) == "") { ?>
		<th data-name="_39" class="<?php echo $bcode->_39->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__39" class="bcode__39"><div class="ew-table-header-caption"><?php echo $bcode->_39->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_39" class="<?php echo $bcode->_39->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_39) ?>',2);"><div id="elh_bcode__39" class="bcode__39">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_39->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_39->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_39->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_40->Visible) { // 40 ?>
	<?php if ($bcode->sortUrl($bcode->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $bcode->_40->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__40" class="bcode__40"><div class="ew-table-header-caption"><?php echo $bcode->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $bcode->_40->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_40) ?>',2);"><div id="elh_bcode__40" class="bcode__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_41->Visible) { // 41 ?>
	<?php if ($bcode->sortUrl($bcode->_41) == "") { ?>
		<th data-name="_41" class="<?php echo $bcode->_41->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__41" class="bcode__41"><div class="ew-table-header-caption"><?php echo $bcode->_41->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_41" class="<?php echo $bcode->_41->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_41) ?>',2);"><div id="elh_bcode__41" class="bcode__41">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_41->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_41->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_41->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_42->Visible) { // 42 ?>
	<?php if ($bcode->sortUrl($bcode->_42) == "") { ?>
		<th data-name="_42" class="<?php echo $bcode->_42->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__42" class="bcode__42"><div class="ew-table-header-caption"><?php echo $bcode->_42->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_42" class="<?php echo $bcode->_42->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_42) ?>',2);"><div id="elh_bcode__42" class="bcode__42">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_42->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_42->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_42->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_43->Visible) { // 43 ?>
	<?php if ($bcode->sortUrl($bcode->_43) == "") { ?>
		<th data-name="_43" class="<?php echo $bcode->_43->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__43" class="bcode__43"><div class="ew-table-header-caption"><?php echo $bcode->_43->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_43" class="<?php echo $bcode->_43->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_43) ?>',2);"><div id="elh_bcode__43" class="bcode__43">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_43->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_43->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_43->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_44->Visible) { // 44 ?>
	<?php if ($bcode->sortUrl($bcode->_44) == "") { ?>
		<th data-name="_44" class="<?php echo $bcode->_44->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__44" class="bcode__44"><div class="ew-table-header-caption"><?php echo $bcode->_44->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_44" class="<?php echo $bcode->_44->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_44) ?>',2);"><div id="elh_bcode__44" class="bcode__44">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_44->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_44->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_44->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_45->Visible) { // 45 ?>
	<?php if ($bcode->sortUrl($bcode->_45) == "") { ?>
		<th data-name="_45" class="<?php echo $bcode->_45->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__45" class="bcode__45"><div class="ew-table-header-caption"><?php echo $bcode->_45->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_45" class="<?php echo $bcode->_45->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_45) ?>',2);"><div id="elh_bcode__45" class="bcode__45">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_45->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_45->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_45->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_46->Visible) { // 46 ?>
	<?php if ($bcode->sortUrl($bcode->_46) == "") { ?>
		<th data-name="_46" class="<?php echo $bcode->_46->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__46" class="bcode__46"><div class="ew-table-header-caption"><?php echo $bcode->_46->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_46" class="<?php echo $bcode->_46->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_46) ?>',2);"><div id="elh_bcode__46" class="bcode__46">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_46->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_46->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_46->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_47->Visible) { // 47 ?>
	<?php if ($bcode->sortUrl($bcode->_47) == "") { ?>
		<th data-name="_47" class="<?php echo $bcode->_47->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__47" class="bcode__47"><div class="ew-table-header-caption"><?php echo $bcode->_47->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_47" class="<?php echo $bcode->_47->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_47) ?>',2);"><div id="elh_bcode__47" class="bcode__47">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_47->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_47->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_47->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_48->Visible) { // 48 ?>
	<?php if ($bcode->sortUrl($bcode->_48) == "") { ?>
		<th data-name="_48" class="<?php echo $bcode->_48->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__48" class="bcode__48"><div class="ew-table-header-caption"><?php echo $bcode->_48->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_48" class="<?php echo $bcode->_48->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_48) ?>',2);"><div id="elh_bcode__48" class="bcode__48">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_48->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_48->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_48->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_49->Visible) { // 49 ?>
	<?php if ($bcode->sortUrl($bcode->_49) == "") { ?>
		<th data-name="_49" class="<?php echo $bcode->_49->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__49" class="bcode__49"><div class="ew-table-header-caption"><?php echo $bcode->_49->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_49" class="<?php echo $bcode->_49->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_49) ?>',2);"><div id="elh_bcode__49" class="bcode__49">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_49->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_49->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_49->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->_50->Visible) { // 50 ?>
	<?php if ($bcode->sortUrl($bcode->_50) == "") { ?>
		<th data-name="_50" class="<?php echo $bcode->_50->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode__50" class="bcode__50"><div class="ew-table-header-caption"><?php echo $bcode->_50->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_50" class="<?php echo $bcode->_50->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->_50) ?>',2);"><div id="elh_bcode__50" class="bcode__50">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->_50->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->_50->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->_50->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bcode->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
	<?php if ($bcode->sortUrl($bcode->roll_no_qty_tmp) == "") { ?>
		<th data-name="roll_no_qty_tmp" class="<?php echo $bcode->roll_no_qty_tmp->headerCellClass() ?>"><div id="elh_bcode_roll_no_qty_tmp" class="bcode_roll_no_qty_tmp"><div class="ew-table-header-caption"><?php echo $bcode->roll_no_qty_tmp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no_qty_tmp" class="<?php echo $bcode->roll_no_qty_tmp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bcode->SortUrl($bcode->roll_no_qty_tmp) ?>',2);"><div id="elh_bcode_roll_no_qty_tmp" class="bcode_roll_no_qty_tmp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bcode->roll_no_qty_tmp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bcode->roll_no_qty_tmp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bcode->roll_no_qty_tmp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bcode_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bcode->ExportAll && $bcode->isExport()) {
	$bcode_list->StopRec = $bcode_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bcode_list->TotalRecs > $bcode_list->StartRec + $bcode_list->DisplayRecs - 1)
		$bcode_list->StopRec = $bcode_list->StartRec + $bcode_list->DisplayRecs - 1;
	else
		$bcode_list->StopRec = $bcode_list->TotalRecs;
}
$bcode_list->RecCnt = $bcode_list->StartRec - 1;
if ($bcode_list->Recordset && !$bcode_list->Recordset->EOF) {
	$bcode_list->Recordset->moveFirst();
	$selectLimit = $bcode_list->UseSelectLimit;
	if (!$selectLimit && $bcode_list->StartRec > 1)
		$bcode_list->Recordset->move($bcode_list->StartRec - 1);
} elseif (!$bcode->AllowAddDeleteRow && $bcode_list->StopRec == 0) {
	$bcode_list->StopRec = $bcode->GridAddRowCount;
}

// Initialize aggregate
$bcode->RowType = ROWTYPE_AGGREGATEINIT;
$bcode->resetAttributes();
$bcode_list->renderRow();
while ($bcode_list->RecCnt < $bcode_list->StopRec) {
	$bcode_list->RecCnt++;
	if ($bcode_list->RecCnt >= $bcode_list->StartRec) {
		$bcode_list->RowCnt++;

		// Set up key count
		$bcode_list->KeyCount = $bcode_list->RowIndex;

		// Init row class and style
		$bcode->resetAttributes();
		$bcode->CssClass = "";
		if ($bcode->isGridAdd()) {
		} else {
			$bcode_list->loadRowValues($bcode_list->Recordset); // Load row values
		}
		$bcode->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$bcode->RowAttrs = array_merge($bcode->RowAttrs, array('data-rowindex'=>$bcode_list->RowCnt, 'id'=>'r' . $bcode_list->RowCnt . '_bcode', 'data-rowtype'=>$bcode->RowType));

		// Render row
		$bcode_list->renderRow();

		// Render list options
		$bcode_list->renderListOptions();
?>
	<tr<?php echo $bcode->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bcode_list->ListOptions->render("body", "left", $bcode_list->RowCnt);
?>
	<?php if ($bcode->po->Visible) { // po ?>
		<td data-name="po"<?php echo $bcode->po->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_po" class="bcode_po">
<span<?php echo $bcode->po->viewAttributes() ?>>
<?php echo $bcode->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $bcode->design_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_design_id" class="bcode_design_id">
<span<?php echo $bcode->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->design_id->getViewValue())) && $bcode->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode->design_id->linkAttributes() ?>><?php echo $bcode->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $bcode->size_cm->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_size_cm" class="bcode_size_cm">
<span<?php echo $bcode->size_cm->viewAttributes() ?>>
<?php echo $bcode->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $bcode->_barcode->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__barcode" class="bcode__barcode">
<span<?php echo $bcode->_barcode->viewAttributes() ?>>
<?php echo $bcode->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->process_d->Visible) { // process_d ?>
		<td data-name="process_d"<?php echo $bcode->process_d->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_process_d" class="bcode_process_d">
<span<?php echo $bcode->process_d->viewAttributes() ?>>
<?php echo $bcode->process_d->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $bcode->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_buyer_ref" class="bcode_buyer_ref">
<span<?php echo $bcode->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->buyer_ref->getViewValue())) && $bcode->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $bcode->buyer_ref->linkAttributes() ?>><?php echo $bcode->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $bcode->order_date->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_order_date" class="bcode_order_date">
<span<?php echo $bcode->order_date->viewAttributes() ?>>
<?php echo $bcode->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $bcode->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_despatch_date" class="bcode_despatch_date">
<span<?php echo $bcode->despatch_date->viewAttributes() ?>>
<?php echo $bcode->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $bcode->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_despatch_week" class="bcode_despatch_week">
<span<?php echo $bcode->despatch_week->viewAttributes() ?>>
<?php echo $bcode->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->dispatch_week_p->Visible) { // dispatch_week_p ?>
		<td data-name="dispatch_week_p"<?php echo $bcode->dispatch_week_p->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_dispatch_week_p" class="bcode_dispatch_week_p">
<span<?php echo $bcode->dispatch_week_p->viewAttributes() ?>>
<?php echo $bcode->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->status->Visible) { // status ?>
		<td data-name="status"<?php echo $bcode->status->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_status" class="bcode_status">
<span<?php echo $bcode->status->viewAttributes() ?>>
<?php echo $bcode->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $bcode->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_buyers_id" class="bcode_buyers_id">
<span<?php echo $bcode->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->buyers_id->getViewValue())) && $bcode->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode->buyers_id->linkAttributes() ?>><?php echo $bcode->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->buyer_uid->Visible) { // buyer_uid ?>
		<td data-name="buyer_uid"<?php echo $bcode->buyer_uid->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_buyer_uid" class="bcode_buyer_uid">
<span<?php echo $bcode->buyer_uid->viewAttributes() ?>>
<?php echo $bcode->buyer_uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->buyer_loc->Visible) { // buyer_loc ?>
		<td data-name="buyer_loc"<?php echo $bcode->buyer_loc->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_buyer_loc" class="bcode_buyer_loc">
<span<?php echo $bcode->buyer_loc->viewAttributes() ?>>
<?php echo $bcode->buyer_loc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $bcode->quantity->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_quantity" class="bcode_quantity">
<span<?php echo $bcode->quantity->viewAttributes() ?>>
<?php echo $bcode->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $bcode->sqm->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_sqm" class="bcode_sqm">
<span<?php echo $bcode->sqm->viewAttributes() ?>>
<?php echo $bcode->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->sqm_u->Visible) { // sqm_u ?>
		<td data-name="sqm_u"<?php echo $bcode->sqm_u->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_sqm_u" class="bcode_sqm_u">
<span<?php echo $bcode->sqm_u->viewAttributes() ?>>
<?php echo $bcode->sqm_u->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->c_sqm->Visible) { // c_sqm ?>
		<td data-name="c_sqm"<?php echo $bcode->c_sqm->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_c_sqm" class="bcode_c_sqm">
<span<?php echo $bcode->c_sqm->viewAttributes() ?>>
<?php echo $bcode->c_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $bcode->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_weaving_works" class="bcode_weaving_works">
<span<?php echo $bcode->weaving_works->viewAttributes() ?>>
<?php echo $bcode->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $bcode->current_works->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_current_works" class="bcode_current_works">
<span<?php echo $bcode->current_works->viewAttributes() ?>>
<?php echo $bcode->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->q_sku->Visible) { // q_sku ?>
		<td data-name="q_sku"<?php echo $bcode->q_sku->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_q_sku" class="bcode_q_sku">
<span<?php echo $bcode->q_sku->viewAttributes() ?>>
<?php echo $bcode->q_sku->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->po_price->Visible) { // po_price ?>
		<td data-name="po_price"<?php echo $bcode->po_price->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_po_price" class="bcode_po_price">
<span<?php echo $bcode->po_price->viewAttributes() ?>>
<?php echo $bcode->po_price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->po_discount->Visible) { // po_discount ?>
		<td data-name="po_discount"<?php echo $bcode->po_discount->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_po_discount" class="bcode_po_discount">
<span<?php echo $bcode->po_discount->viewAttributes() ?>>
<?php echo $bcode->po_discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->po_currency->Visible) { // po_currency ?>
		<td data-name="po_currency"<?php echo $bcode->po_currency->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_po_currency" class="bcode_po_currency">
<span<?php echo $bcode->po_currency->viewAttributes() ?>>
<?php echo $bcode->po_currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $bcode->product_type->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_product_type" class="bcode_product_type">
<span<?php echo $bcode->product_type->viewAttributes() ?>>
<?php echo $bcode->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $bcode->shape->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_shape" class="bcode_shape">
<span<?php echo $bcode->shape->viewAttributes() ?>>
<?php echo $bcode->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $bcode->completed->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_completed" class="bcode_completed">
<span<?php echo $bcode->completed->viewAttributes() ?>>
<?php echo $bcode->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $bcode->buyer_po->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_buyer_po" class="bcode_buyer_po">
<span<?php echo $bcode->buyer_po->viewAttributes() ?>>
<?php echo $bcode->buyer_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $bcode->batch_no->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_batch_no" class="bcode_batch_no">
<span<?php echo $bcode->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->batch_no->getViewValue())) && $bcode->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $bcode->batch_no->linkAttributes() ?>><?php echo $bcode->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->cs->Visible) { // cs ?>
		<td data-name="cs"<?php echo $bcode->cs->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_cs" class="bcode_cs">
<span<?php echo $bcode->cs->viewAttributes() ?>>
<?php echo $bcode->cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->weight->Visible) { // weight ?>
		<td data-name="weight"<?php echo $bcode->weight->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_weight" class="bcode_weight">
<span<?php echo $bcode->weight->viewAttributes() ?>>
<?php echo $bcode->weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $bcode->remarks->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_remarks" class="bcode_remarks">
<span<?php echo $bcode->remarks->viewAttributes() ?>>
<?php echo $bcode->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no"<?php echo $bcode->roll_no->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_roll_no" class="bcode_roll_no">
<span<?php echo $bcode->roll_no->viewAttributes() ?>>
<?php echo $bcode->roll_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $bcode->qty->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_qty" class="bcode_qty">
<span<?php echo $bcode->qty->viewAttributes() ?>>
<?php echo $bcode->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $bcode->pl_no->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_pl_no" class="bcode_pl_no">
<span<?php echo $bcode->pl_no->viewAttributes() ?>>
<?php echo $bcode->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->category->Visible) { // category ?>
		<td data-name="category"<?php echo $bcode->category->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_category" class="bcode_category">
<span<?php echo $bcode->category->viewAttributes() ?>>
<?php echo $bcode->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode"<?php echo $bcode->buyer_barcode->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_buyer_barcode" class="bcode_buyer_barcode">
<span<?php echo $bcode->buyer_barcode->viewAttributes() ?>>
<?php echo $bcode->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_11->Visible) { // 11 ?>
		<td data-name="_11"<?php echo $bcode->_11->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__11" class="bcode__11">
<span<?php echo $bcode->_11->viewAttributes() ?>>
<?php echo $bcode->_11->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_12->Visible) { // 12 ?>
		<td data-name="_12"<?php echo $bcode->_12->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__12" class="bcode__12">
<span<?php echo $bcode->_12->viewAttributes() ?>>
<?php echo $bcode->_12->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_13->Visible) { // 13 ?>
		<td data-name="_13"<?php echo $bcode->_13->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__13" class="bcode__13">
<span<?php echo $bcode->_13->viewAttributes() ?>>
<?php echo $bcode->_13->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_14->Visible) { // 14 ?>
		<td data-name="_14"<?php echo $bcode->_14->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__14" class="bcode__14">
<span<?php echo $bcode->_14->viewAttributes() ?>>
<?php echo $bcode->_14->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_15->Visible) { // 15 ?>
		<td data-name="_15"<?php echo $bcode->_15->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__15" class="bcode__15">
<span<?php echo $bcode->_15->viewAttributes() ?>>
<?php echo $bcode->_15->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_16->Visible) { // 16 ?>
		<td data-name="_16"<?php echo $bcode->_16->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__16" class="bcode__16">
<span<?php echo $bcode->_16->viewAttributes() ?>>
<?php echo $bcode->_16->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_17->Visible) { // 17 ?>
		<td data-name="_17"<?php echo $bcode->_17->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__17" class="bcode__17">
<span<?php echo $bcode->_17->viewAttributes() ?>>
<?php echo $bcode->_17->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_18->Visible) { // 18 ?>
		<td data-name="_18"<?php echo $bcode->_18->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__18" class="bcode__18">
<span<?php echo $bcode->_18->viewAttributes() ?>>
<?php echo $bcode->_18->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_19->Visible) { // 19 ?>
		<td data-name="_19"<?php echo $bcode->_19->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__19" class="bcode__19">
<span<?php echo $bcode->_19->viewAttributes() ?>>
<?php echo $bcode->_19->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_20->Visible) { // 20 ?>
		<td data-name="_20"<?php echo $bcode->_20->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__20" class="bcode__20">
<span<?php echo $bcode->_20->viewAttributes() ?>>
<?php echo $bcode->_20->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_21->Visible) { // 21 ?>
		<td data-name="_21"<?php echo $bcode->_21->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__21" class="bcode__21">
<span<?php echo $bcode->_21->viewAttributes() ?>>
<?php echo $bcode->_21->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_22->Visible) { // 22 ?>
		<td data-name="_22"<?php echo $bcode->_22->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__22" class="bcode__22">
<span<?php echo $bcode->_22->viewAttributes() ?>>
<?php echo $bcode->_22->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_23->Visible) { // 23 ?>
		<td data-name="_23"<?php echo $bcode->_23->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__23" class="bcode__23">
<span<?php echo $bcode->_23->viewAttributes() ?>>
<?php echo $bcode->_23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_24->Visible) { // 24 ?>
		<td data-name="_24"<?php echo $bcode->_24->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__24" class="bcode__24">
<span<?php echo $bcode->_24->viewAttributes() ?>>
<?php echo $bcode->_24->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_25->Visible) { // 25 ?>
		<td data-name="_25"<?php echo $bcode->_25->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__25" class="bcode__25">
<span<?php echo $bcode->_25->viewAttributes() ?>>
<?php echo $bcode->_25->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_26->Visible) { // 26 ?>
		<td data-name="_26"<?php echo $bcode->_26->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__26" class="bcode__26">
<span<?php echo $bcode->_26->viewAttributes() ?>>
<?php echo $bcode->_26->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_27->Visible) { // 27 ?>
		<td data-name="_27"<?php echo $bcode->_27->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__27" class="bcode__27">
<span<?php echo $bcode->_27->viewAttributes() ?>>
<?php echo $bcode->_27->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_28->Visible) { // 28 ?>
		<td data-name="_28"<?php echo $bcode->_28->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__28" class="bcode__28">
<span<?php echo $bcode->_28->viewAttributes() ?>>
<?php echo $bcode->_28->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_29->Visible) { // 29 ?>
		<td data-name="_29"<?php echo $bcode->_29->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__29" class="bcode__29">
<span<?php echo $bcode->_29->viewAttributes() ?>>
<?php echo $bcode->_29->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_30->Visible) { // 30 ?>
		<td data-name="_30"<?php echo $bcode->_30->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__30" class="bcode__30">
<span<?php echo $bcode->_30->viewAttributes() ?>>
<?php echo $bcode->_30->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_31->Visible) { // 31 ?>
		<td data-name="_31"<?php echo $bcode->_31->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__31" class="bcode__31">
<span<?php echo $bcode->_31->viewAttributes() ?>>
<?php echo $bcode->_31->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_32->Visible) { // 32 ?>
		<td data-name="_32"<?php echo $bcode->_32->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__32" class="bcode__32">
<span<?php echo $bcode->_32->viewAttributes() ?>>
<?php echo $bcode->_32->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_33->Visible) { // 33 ?>
		<td data-name="_33"<?php echo $bcode->_33->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__33" class="bcode__33">
<span<?php echo $bcode->_33->viewAttributes() ?>>
<?php echo $bcode->_33->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_34->Visible) { // 34 ?>
		<td data-name="_34"<?php echo $bcode->_34->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__34" class="bcode__34">
<span<?php echo $bcode->_34->viewAttributes() ?>>
<?php echo $bcode->_34->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_35->Visible) { // 35 ?>
		<td data-name="_35"<?php echo $bcode->_35->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__35" class="bcode__35">
<span<?php echo $bcode->_35->viewAttributes() ?>>
<?php echo $bcode->_35->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_36->Visible) { // 36 ?>
		<td data-name="_36"<?php echo $bcode->_36->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__36" class="bcode__36">
<span<?php echo $bcode->_36->viewAttributes() ?>>
<?php echo $bcode->_36->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_37->Visible) { // 37 ?>
		<td data-name="_37"<?php echo $bcode->_37->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__37" class="bcode__37">
<span<?php echo $bcode->_37->viewAttributes() ?>>
<?php echo $bcode->_37->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_38->Visible) { // 38 ?>
		<td data-name="_38"<?php echo $bcode->_38->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__38" class="bcode__38">
<span<?php echo $bcode->_38->viewAttributes() ?>>
<?php echo $bcode->_38->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_39->Visible) { // 39 ?>
		<td data-name="_39"<?php echo $bcode->_39->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__39" class="bcode__39">
<span<?php echo $bcode->_39->viewAttributes() ?>>
<?php echo $bcode->_39->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_40->Visible) { // 40 ?>
		<td data-name="_40"<?php echo $bcode->_40->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__40" class="bcode__40">
<span<?php echo $bcode->_40->viewAttributes() ?>>
<?php echo $bcode->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_41->Visible) { // 41 ?>
		<td data-name="_41"<?php echo $bcode->_41->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__41" class="bcode__41">
<span<?php echo $bcode->_41->viewAttributes() ?>>
<?php echo $bcode->_41->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_42->Visible) { // 42 ?>
		<td data-name="_42"<?php echo $bcode->_42->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__42" class="bcode__42">
<span<?php echo $bcode->_42->viewAttributes() ?>>
<?php echo $bcode->_42->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_43->Visible) { // 43 ?>
		<td data-name="_43"<?php echo $bcode->_43->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__43" class="bcode__43">
<span<?php echo $bcode->_43->viewAttributes() ?>>
<?php echo $bcode->_43->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_44->Visible) { // 44 ?>
		<td data-name="_44"<?php echo $bcode->_44->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__44" class="bcode__44">
<span<?php echo $bcode->_44->viewAttributes() ?>>
<?php echo $bcode->_44->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_45->Visible) { // 45 ?>
		<td data-name="_45"<?php echo $bcode->_45->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__45" class="bcode__45">
<span<?php echo $bcode->_45->viewAttributes() ?>>
<?php echo $bcode->_45->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_46->Visible) { // 46 ?>
		<td data-name="_46"<?php echo $bcode->_46->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__46" class="bcode__46">
<span<?php echo $bcode->_46->viewAttributes() ?>>
<?php echo $bcode->_46->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_47->Visible) { // 47 ?>
		<td data-name="_47"<?php echo $bcode->_47->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__47" class="bcode__47">
<span<?php echo $bcode->_47->viewAttributes() ?>>
<?php echo $bcode->_47->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_48->Visible) { // 48 ?>
		<td data-name="_48"<?php echo $bcode->_48->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__48" class="bcode__48">
<span<?php echo $bcode->_48->viewAttributes() ?>>
<?php echo $bcode->_48->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_49->Visible) { // 49 ?>
		<td data-name="_49"<?php echo $bcode->_49->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__49" class="bcode__49">
<span<?php echo $bcode->_49->viewAttributes() ?>>
<?php echo $bcode->_49->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->_50->Visible) { // 50 ?>
		<td data-name="_50"<?php echo $bcode->_50->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode__50" class="bcode__50">
<span<?php echo $bcode->_50->viewAttributes() ?>>
<?php echo $bcode->_50->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bcode->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
		<td data-name="roll_no_qty_tmp"<?php echo $bcode->roll_no_qty_tmp->cellAttributes() ?>>
<span id="el<?php echo $bcode_list->RowCnt ?>_bcode_roll_no_qty_tmp" class="bcode_roll_no_qty_tmp">
<span<?php echo $bcode->roll_no_qty_tmp->viewAttributes() ?>>
<?php echo $bcode->roll_no_qty_tmp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bcode_list->ListOptions->render("body", "right", $bcode_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$bcode->isGridAdd())
		$bcode_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$bcode->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($bcode_list->Recordset)
	$bcode_list->Recordset->Close();
?>
<?php if (!$bcode->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$bcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bcode_list->Pager)) $bcode_list->Pager = new PrevNextPager($bcode_list->StartRec, $bcode_list->DisplayRecs, $bcode_list->TotalRecs, $bcode_list->AutoHidePager) ?>
<?php if ($bcode_list->Pager->RecordCount > 0 && $bcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bcode_list->pageUrl() ?>start=<?php echo $bcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bcode_list->TotalRecs > 0 && (!$bcode_list->AutoHidePageSizeSelector || $bcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bcode_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($bcode_list->TotalRecs == 0 && !$bcode->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $bcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$bcode_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bcode->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$bcode->isExport()) { ?>
<script>
ew.scrollableTable("gmp_bcode", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bcode_list->terminate();
?>