<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_search = new bcode_search();

// Run the page
$bcode_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($bcode_search->IsModal) { ?>
var fbcodesearch = currentAdvancedSearchForm = new ew.Form("fbcodesearch", "search");
<?php } else { ?>
var fbcodesearch = currentForm = new ew.Form("fbcodesearch", "search");
<?php } ?>

// Form_CustomValidate event
fbcodesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcodesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcodesearch.lists["x_design_id"] = <?php echo $bcode_search->design_id->Lookup->toClientList() ?>;
fbcodesearch.lists["x_design_id"].options = <?php echo JsonEncode($bcode_search->design_id->lookupOptions()) ?>;
fbcodesearch.lists["x_process_d[]"] = <?php echo $bcode_search->process_d->Lookup->toClientList() ?>;
fbcodesearch.lists["x_process_d[]"].options = <?php echo JsonEncode($bcode_search->process_d->lookupOptions()) ?>;
fbcodesearch.lists["x_buyer_ref"] = <?php echo $bcode_search->buyer_ref->Lookup->toClientList() ?>;
fbcodesearch.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_search->buyer_ref->lookupOptions()) ?>;
fbcodesearch.lists["x_despatch_week"] = <?php echo $bcode_search->despatch_week->Lookup->toClientList() ?>;
fbcodesearch.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_search->despatch_week->lookupOptions()) ?>;
fbcodesearch.lists["x_dispatch_week_p"] = <?php echo $bcode_search->dispatch_week_p->Lookup->toClientList() ?>;
fbcodesearch.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($bcode_search->dispatch_week_p->lookupOptions()) ?>;
fbcodesearch.lists["x_status"] = <?php echo $bcode_search->status->Lookup->toClientList() ?>;
fbcodesearch.lists["x_status"].options = <?php echo JsonEncode($bcode_search->status->lookupOptions()) ?>;
fbcodesearch.lists["x_buyers_id"] = <?php echo $bcode_search->buyers_id->Lookup->toClientList() ?>;
fbcodesearch.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_search->buyers_id->lookupOptions()) ?>;
fbcodesearch.lists["x_weaving_works"] = <?php echo $bcode_search->weaving_works->Lookup->toClientList() ?>;
fbcodesearch.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_search->weaving_works->lookupOptions()) ?>;
fbcodesearch.lists["x_current_works"] = <?php echo $bcode_search->current_works->Lookup->toClientList() ?>;
fbcodesearch.lists["x_current_works"].options = <?php echo JsonEncode($bcode_search->current_works->lookupOptions()) ?>;
fbcodesearch.lists["x_po_currency"] = <?php echo $bcode_search->po_currency->Lookup->toClientList() ?>;
fbcodesearch.lists["x_po_currency"].options = <?php echo JsonEncode($bcode_search->po_currency->lookupOptions()) ?>;
fbcodesearch.lists["x_product_type"] = <?php echo $bcode_search->product_type->Lookup->toClientList() ?>;
fbcodesearch.lists["x_product_type"].options = <?php echo JsonEncode($bcode_search->product_type->options(FALSE, TRUE)) ?>;
fbcodesearch.lists["x_shape"] = <?php echo $bcode_search->shape->Lookup->toClientList() ?>;
fbcodesearch.lists["x_shape"].options = <?php echo JsonEncode($bcode_search->shape->lookupOptions()) ?>;
fbcodesearch.lists["x_payment_plan"] = <?php echo $bcode_search->payment_plan->Lookup->toClientList() ?>;
fbcodesearch.lists["x_payment_plan"].options = <?php echo JsonEncode($bcode_search->payment_plan->lookupOptions()) ?>;
fbcodesearch.lists["x_production_plan"] = <?php echo $bcode_search->production_plan->Lookup->toClientList() ?>;
fbcodesearch.lists["x_production_plan"].options = <?php echo JsonEncode($bcode_search->production_plan->options(FALSE, TRUE)) ?>;
fbcodesearch.lists["x_completed"] = <?php echo $bcode_search->completed->Lookup->toClientList() ?>;
fbcodesearch.lists["x_completed"].options = <?php echo JsonEncode($bcode_search->completed->options(FALSE, TRUE)) ?>;
fbcodesearch.lists["x_operator"] = <?php echo $bcode_search->operator->Lookup->toClientList() ?>;
fbcodesearch.lists["x_operator"].options = <?php echo JsonEncode($bcode_search->operator->lookupOptions()) ?>;
fbcodesearch.lists["x_batch_no"] = <?php echo $bcode_search->batch_no->Lookup->toClientList() ?>;
fbcodesearch.lists["x_batch_no"].options = <?php echo JsonEncode($bcode_search->batch_no->lookupOptions()) ?>;
fbcodesearch.lists["x_cs"] = <?php echo $bcode_search->cs->Lookup->toClientList() ?>;
fbcodesearch.lists["x_cs"].options = <?php echo JsonEncode($bcode_search->cs->options(FALSE, TRUE)) ?>;
fbcodesearch.lists["x_category"] = <?php echo $bcode_search->category->Lookup->toClientList() ?>;
fbcodesearch.lists["x_category"].options = <?php echo JsonEncode($bcode_search->category->lookupOptions()) ?>;
fbcodesearch.lists["x_pp_id"] = <?php echo $bcode_search->pp_id->Lookup->toClientList() ?>;
fbcodesearch.lists["x_pp_id"].options = <?php echo JsonEncode($bcode_search->pp_id->lookupOptions()) ?>;
fbcodesearch.autoSuggests["x_pp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fbcodesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->pid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm_u");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->sqm_u->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_c_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->c_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_q_sku");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->q_sku->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->po_discount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_roll_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->roll_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pp_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->pp_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_roll_no_qty_tmp");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bcode->roll_no_qty_tmp->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_search->showPageHeader(); ?>
<?php
$bcode_search->showMessage();
?>
<form name="fbcodesearch" id="fbcodesearch" class="<?php echo $bcode_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($bcode->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_id"><?php echo $bcode->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->id->cellAttributes() ?>>
			<span id="el_bcode_id">
<input type="text" data-table="bcode" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bcode->id->getPlaceHolder()) ?>" value="<?php echo $bcode->id->EditValue ?>"<?php echo $bcode->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->pid->Visible) { // pid ?>
	<div id="r_pid" class="form-group row">
		<label for="x_pid" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_pid"><?php echo $bcode->pid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pid" id="z_pid" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->pid->cellAttributes() ?>>
			<span id="el_bcode_pid">
<input type="text" data-table="bcode" data-field="x_pid" name="x_pid" id="x_pid" size="30" placeholder="<?php echo HtmlEncode($bcode->pid->getPlaceHolder()) ?>" value="<?php echo $bcode->pid->EditValue ?>"<?php echo $bcode->pid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_po"><?php echo $bcode->po->caption() ?></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bcode->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bcode_po">
<input type="text" data-table="bcode" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($bcode->po->getPlaceHolder()) ?>" value="<?php echo $bcode->po->EditValue ?>"<?php echo $bcode->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bcode_po" class="btw1_po d-none">
<input type="text" data-table="bcode" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($bcode->po->getPlaceHolder()) ?>" value="<?php echo $bcode->po->EditValue2 ?>"<?php echo $bcode->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_design_id"><?php echo $bcode->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->design_id->cellAttributes() ?>>
			<span id="el_bcode_design_id">
<input type="text" data-table="bcode" data-field="x_design_id" name="x_design_id" id="x_design_id" size="30" placeholder="<?php echo HtmlEncode($bcode->design_id->getPlaceHolder()) ?>" value="<?php echo $bcode->design_id->EditValue ?>"<?php echo $bcode->design_id->editAttributes() ?>>
<?php echo $bcode->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_size_cm"><?php echo $bcode->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->size_cm->cellAttributes() ?>>
			<span id="el_bcode_size_cm">
<input type="text" data-table="bcode" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode->size_cm->getPlaceHolder()) ?>" value="<?php echo $bcode->size_cm->EditValue ?>"<?php echo $bcode->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__barcode"><?php echo $bcode->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($bcode->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bcode__barcode">
<input type="text" data-table="bcode" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode->_barcode->EditValue ?>"<?php echo $bcode->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bcode__barcode" class="btw1__barcode d-none">
<input type="text" data-table="bcode" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($bcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $bcode->_barcode->EditValue2 ?>"<?php echo $bcode->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->process_d->Visible) { // process_d ?>
	<div id="r_process_d" class="form-group row">
		<label class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_process_d"><?php echo $bcode->process_d->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_d" id="z_process_d" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->process_d->cellAttributes() ?>>
			<span id="el_bcode_process_d">
<div id="tp_x_process_d" class="ew-template"><input type="checkbox" class="form-check-input" data-table="bcode" data-field="x_process_d" data-value-separator="<?php echo $bcode->process_d->displayValueSeparatorAttribute() ?>" name="x_process_d[]" id="x_process_d[]" value="{value}"<?php echo $bcode->process_d->editAttributes() ?>></div>
<div id="dsl_x_process_d" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $bcode->process_d->checkBoxListHtml(FALSE, "x_process_d[]") ?>
</div></div>
<?php echo $bcode->process_d->Lookup->getParamTag("p_x_process_d") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_buyer_ref"><?php echo $bcode->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->buyer_ref->cellAttributes() ?>>
			<span id="el_bcode_buyer_ref">
<input type="text" data-table="bcode" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" placeholder="<?php echo HtmlEncode($bcode->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_ref->EditValue ?>"<?php echo $bcode->buyer_ref->editAttributes() ?>>
<?php echo $bcode->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_order_date"><?php echo $bcode->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->order_date->cellAttributes() ?>>
			<span id="el_bcode_order_date">
<input type="text" data-table="bcode" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($bcode->order_date->getPlaceHolder()) ?>" value="<?php echo $bcode->order_date->EditValue ?>"<?php echo $bcode->order_date->editAttributes() ?>>
<?php if (!$bcode->order_date->ReadOnly && !$bcode->order_date->Disabled && !isset($bcode->order_date->EditAttrs["readonly"]) && !isset($bcode->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcodesearch", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_despatch_date"><?php echo $bcode->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->despatch_date->cellAttributes() ?>>
			<span id="el_bcode_despatch_date">
<input type="text" data-table="bcode" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($bcode->despatch_date->getPlaceHolder()) ?>" value="<?php echo $bcode->despatch_date->EditValue ?>"<?php echo $bcode->despatch_date->editAttributes() ?>>
<?php if (!$bcode->despatch_date->ReadOnly && !$bcode->despatch_date->Disabled && !isset($bcode->despatch_date->EditAttrs["readonly"]) && !isset($bcode->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcodesearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_despatch_week"><?php echo $bcode->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->despatch_week->cellAttributes() ?>>
			<span id="el_bcode_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_despatch_week" data-value-separator="<?php echo $bcode->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $bcode->despatch_week->editAttributes() ?>>
		<?php echo $bcode->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $bcode->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<div id="r_dispatch_week_p" class="form-group row">
		<label for="x_dispatch_week_p" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_dispatch_week_p"><?php echo $bcode->dispatch_week_p->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dispatch_week_p" id="z_dispatch_week_p" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->dispatch_week_p->cellAttributes() ?>>
			<span id="el_bcode_dispatch_week_p">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_dispatch_week_p" data-value-separator="<?php echo $bcode->dispatch_week_p->displayValueSeparatorAttribute() ?>" id="x_dispatch_week_p" name="x_dispatch_week_p"<?php echo $bcode->dispatch_week_p->editAttributes() ?>>
		<?php echo $bcode->dispatch_week_p->selectOptionListHtml("x_dispatch_week_p") ?>
	</select>
</div>
<?php echo $bcode->dispatch_week_p->Lookup->getParamTag("p_x_dispatch_week_p") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_status"><?php echo $bcode->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->status->cellAttributes() ?>>
			<span id="el_bcode_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_status" data-value-separator="<?php echo $bcode->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode->status->editAttributes() ?>>
		<?php echo $bcode->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $bcode->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_buyers_id"><?php echo $bcode->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->buyers_id->cellAttributes() ?>>
			<span id="el_bcode_buyers_id">
<?php $bcode->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bcode->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_buyers_id" data-value-separator="<?php echo $bcode->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $bcode->buyers_id->editAttributes() ?>>
		<?php echo $bcode->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $bcode->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_buyer_uid"><?php echo $bcode->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->buyer_uid->cellAttributes() ?>>
			<span id="el_bcode_buyer_uid">
<input type="text" data-table="bcode" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_uid->EditValue ?>"<?php echo $bcode->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_loc->Visible) { // buyer_loc ?>
	<div id="r_buyer_loc" class="form-group row">
		<label for="x_buyer_loc" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_buyer_loc"><?php echo $bcode->buyer_loc->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->buyer_loc->cellAttributes() ?>>
			<span id="el_bcode_buyer_loc">
<input type="text" data-table="bcode" data-field="x_buyer_loc" name="x_buyer_loc" id="x_buyer_loc" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode->buyer_loc->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_loc->EditValue ?>"<?php echo $bcode->buyer_loc->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_quantity"><?php echo $bcode->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->quantity->cellAttributes() ?>>
			<span id="el_bcode_quantity">
<input type="text" data-table="bcode" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($bcode->quantity->getPlaceHolder()) ?>" value="<?php echo $bcode->quantity->EditValue ?>"<?php echo $bcode->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_sqm"><?php echo $bcode->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->sqm->cellAttributes() ?>>
			<span id="el_bcode_sqm">
<input type="text" data-table="bcode" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($bcode->sqm->getPlaceHolder()) ?>" value="<?php echo $bcode->sqm->EditValue ?>"<?php echo $bcode->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->sqm_u->Visible) { // sqm_u ?>
	<div id="r_sqm_u" class="form-group row">
		<label for="x_sqm_u" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_sqm_u"><?php echo $bcode->sqm_u->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm_u" id="z_sqm_u" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->sqm_u->cellAttributes() ?>>
			<span id="el_bcode_sqm_u">
<input type="text" data-table="bcode" data-field="x_sqm_u" name="x_sqm_u" id="x_sqm_u" size="30" placeholder="<?php echo HtmlEncode($bcode->sqm_u->getPlaceHolder()) ?>" value="<?php echo $bcode->sqm_u->EditValue ?>"<?php echo $bcode->sqm_u->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->c_sqm->Visible) { // c_sqm ?>
	<div id="r_c_sqm" class="form-group row">
		<label for="x_c_sqm" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_c_sqm"><?php echo $bcode->c_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_c_sqm" id="z_c_sqm" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->c_sqm->cellAttributes() ?>>
			<span id="el_bcode_c_sqm">
<input type="text" data-table="bcode" data-field="x_c_sqm" name="x_c_sqm" id="x_c_sqm" size="30" placeholder="<?php echo HtmlEncode($bcode->c_sqm->getPlaceHolder()) ?>" value="<?php echo $bcode->c_sqm->EditValue ?>"<?php echo $bcode->c_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_weaving_works"><?php echo $bcode->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->weaving_works->cellAttributes() ?>>
			<span id="el_bcode_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_weaving_works" data-value-separator="<?php echo $bcode->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $bcode->weaving_works->editAttributes() ?>>
		<?php echo $bcode->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $bcode->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_current_works"><?php echo $bcode->current_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->current_works->cellAttributes() ?>>
			<span id="el_bcode_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_current_works" data-value-separator="<?php echo $bcode->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $bcode->current_works->editAttributes() ?>>
		<?php echo $bcode->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $bcode->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_size_buyer"><?php echo $bcode->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->size_buyer->cellAttributes() ?>>
			<span id="el_bcode_size_buyer">
<input type="text" data-table="bcode" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode->size_buyer->getPlaceHolder()) ?>" value="<?php echo $bcode->size_buyer->EditValue ?>"<?php echo $bcode->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->q_sku->Visible) { // q_sku ?>
	<div id="r_q_sku" class="form-group row">
		<label for="x_q_sku" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_q_sku"><?php echo $bcode->q_sku->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_q_sku" id="z_q_sku" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->q_sku->cellAttributes() ?>>
			<span id="el_bcode_q_sku">
<input type="text" data-table="bcode" data-field="x_q_sku" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($bcode->q_sku->getPlaceHolder()) ?>" value="<?php echo $bcode->q_sku->EditValue ?>"<?php echo $bcode->q_sku->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->po_price->Visible) { // po_price ?>
	<div id="r_po_price" class="form-group row">
		<label for="x_po_price" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_po_price"><?php echo $bcode->po_price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_price" id="z_po_price" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->po_price->cellAttributes() ?>>
			<span id="el_bcode_po_price">
<input type="text" data-table="bcode" data-field="x_po_price" name="x_po_price" id="x_po_price" size="30" maxlength="1" placeholder="<?php echo HtmlEncode($bcode->po_price->getPlaceHolder()) ?>" value="<?php echo $bcode->po_price->EditValue ?>"<?php echo $bcode->po_price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->po_discount->Visible) { // po_discount ?>
	<div id="r_po_discount" class="form-group row">
		<label for="x_po_discount" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_po_discount"><?php echo $bcode->po_discount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_discount" id="z_po_discount" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->po_discount->cellAttributes() ?>>
			<span id="el_bcode_po_discount">
<input type="text" data-table="bcode" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" size="30" placeholder="<?php echo HtmlEncode($bcode->po_discount->getPlaceHolder()) ?>" value="<?php echo $bcode->po_discount->EditValue ?>"<?php echo $bcode->po_discount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->po_currency->Visible) { // po_currency ?>
	<div id="r_po_currency" class="form-group row">
		<label for="x_po_currency" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_po_currency"><?php echo $bcode->po_currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_currency" id="z_po_currency" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->po_currency->cellAttributes() ?>>
			<span id="el_bcode_po_currency">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_po_currency"><?php echo strval($bcode->po_currency->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($bcode->po_currency->AdvancedSearch->ViewValue) : $bcode->po_currency->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($bcode->po_currency->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($bcode->po_currency->ReadOnly || $bcode->po_currency->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_po_currency',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $bcode->po_currency->Lookup->getParamTag("p_x_po_currency") ?>
<input type="hidden" data-table="bcode" data-field="x_po_currency" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $bcode->po_currency->displayValueSeparatorAttribute() ?>" name="x_po_currency" id="x_po_currency" value="<?php echo $bcode->po_currency->AdvancedSearch->SearchValue ?>"<?php echo $bcode->po_currency->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_product_type"><?php echo $bcode->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->product_type->cellAttributes() ?>>
			<span id="el_bcode_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_product_type" data-value-separator="<?php echo $bcode->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $bcode->product_type->editAttributes() ?>>
		<?php echo $bcode->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_shape"><?php echo $bcode->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->shape->cellAttributes() ?>>
			<span id="el_bcode_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_shape" data-value-separator="<?php echo $bcode->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $bcode->shape->editAttributes() ?>>
		<?php echo $bcode->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $bcode->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->payment_plan->Visible) { // payment_plan ?>
	<div id="r_payment_plan" class="form-group row">
		<label for="x_payment_plan" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_payment_plan"><?php echo $bcode->payment_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment_plan" id="z_payment_plan" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->payment_plan->cellAttributes() ?>>
			<span id="el_bcode_payment_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_payment_plan" data-value-separator="<?php echo $bcode->payment_plan->displayValueSeparatorAttribute() ?>" id="x_payment_plan" name="x_payment_plan"<?php echo $bcode->payment_plan->editAttributes() ?>>
		<?php echo $bcode->payment_plan->selectOptionListHtml("x_payment_plan") ?>
	</select>
</div>
<?php echo $bcode->payment_plan->Lookup->getParamTag("p_x_payment_plan") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_production_plan"><?php echo $bcode->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->production_plan->cellAttributes() ?>>
			<span id="el_bcode_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_production_plan" data-value-separator="<?php echo $bcode->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $bcode->production_plan->editAttributes() ?>>
		<?php echo $bcode->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_datetime"><?php echo $bcode->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->datetime->cellAttributes() ?>>
			<span id="el_bcode_datetime">
<input type="text" data-table="bcode" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($bcode->datetime->getPlaceHolder()) ?>" value="<?php echo $bcode->datetime->EditValue ?>"<?php echo $bcode->datetime->editAttributes() ?>>
<?php if (!$bcode->datetime->ReadOnly && !$bcode->datetime->Disabled && !isset($bcode->datetime->EditAttrs["readonly"]) && !isset($bcode->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcodesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label for="x_completed" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_completed"><?php echo $bcode->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_completed" id="z_completed" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->completed->cellAttributes() ?>>
			<span id="el_bcode_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_completed" data-value-separator="<?php echo $bcode->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $bcode->completed->editAttributes() ?>>
		<?php echo $bcode->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_buyer_po"><?php echo $bcode->buyer_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->buyer_po->cellAttributes() ?>>
			<span id="el_bcode_buyer_po">
<input type="text" data-table="bcode" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($bcode->buyer_po->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_po->EditValue ?>"<?php echo $bcode->buyer_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_operator"><?php echo $bcode->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->operator->cellAttributes() ?>>
			<span id="el_bcode_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_operator" data-value-separator="<?php echo $bcode->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $bcode->operator->editAttributes() ?>>
		<?php echo $bcode->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $bcode->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_jc_no"><?php echo $bcode->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->jc_no->cellAttributes() ?>>
			<span id="el_bcode_jc_no">
<input type="text" data-table="bcode" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($bcode->jc_no->getPlaceHolder()) ?>" value="<?php echo $bcode->jc_no->EditValue ?>"<?php echo $bcode->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_batch_no"><?php echo $bcode->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->batch_no->cellAttributes() ?>>
			<span id="el_bcode_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_batch_no" data-value-separator="<?php echo $bcode->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $bcode->batch_no->editAttributes() ?>>
		<?php echo $bcode->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $bcode->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->cs->Visible) { // cs ?>
	<div id="r_cs" class="form-group row">
		<label for="x_cs" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_cs"><?php echo $bcode->cs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cs" id="z_cs" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->cs->cellAttributes() ?>>
			<span id="el_bcode_cs">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_cs" data-value-separator="<?php echo $bcode->cs->displayValueSeparatorAttribute() ?>" id="x_cs" name="x_cs"<?php echo $bcode->cs->editAttributes() ?>>
		<?php echo $bcode->cs->selectOptionListHtml("x_cs") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_remarks"><?php echo $bcode->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->remarks->cellAttributes() ?>>
			<span id="el_bcode_remarks">
<input type="text" data-table="bcode" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($bcode->remarks->getPlaceHolder()) ?>" value="<?php echo $bcode->remarks->EditValue ?>"<?php echo $bcode->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->roll_no->Visible) { // roll_no ?>
	<div id="r_roll_no" class="form-group row">
		<label for="x_roll_no" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_roll_no"><?php echo $bcode->roll_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no" id="z_roll_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->roll_no->cellAttributes() ?>>
			<span id="el_bcode_roll_no">
<input type="text" data-table="bcode" data-field="x_roll_no" name="x_roll_no" id="x_roll_no" size="30" placeholder="<?php echo HtmlEncode($bcode->roll_no->getPlaceHolder()) ?>" value="<?php echo $bcode->roll_no->EditValue ?>"<?php echo $bcode->roll_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_qty"><?php echo $bcode->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->qty->cellAttributes() ?>>
			<span id="el_bcode_qty">
<input type="text" data-table="bcode" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($bcode->qty->getPlaceHolder()) ?>" value="<?php echo $bcode->qty->EditValue ?>"<?php echo $bcode->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_pl_no"><?php echo $bcode->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->pl_no->cellAttributes() ?>>
			<span id="el_bcode_pl_no">
<input type="text" data-table="bcode" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($bcode->pl_no->getPlaceHolder()) ?>" value="<?php echo $bcode->pl_no->EditValue ?>"<?php echo $bcode->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_category"><?php echo $bcode->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->category->cellAttributes() ?>>
			<span id="el_bcode_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_category" data-value-separator="<?php echo $bcode->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $bcode->category->editAttributes() ?>>
		<?php echo $bcode->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $bcode->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_pp_id"><?php echo $bcode->pp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pp_id" id="z_pp_id" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->pp_id->cellAttributes() ?>>
			<span id="el_bcode_pp_id">
<?php
$wrkonchange = "" . trim(@$bcode->pp_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bcode->pp_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_pp_id" class="text-nowrap" style="z-index: 8410">
	<input type="text" class="form-control" name="sv_x_pp_id" id="sv_x_pp_id" value="<?php echo RemoveHtml($bcode->pp_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bcode->pp_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bcode->pp_id->getPlaceHolder()) ?>"<?php echo $bcode->pp_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="bcode" data-field="x_pp_id" data-value-separator="<?php echo $bcode->pp_id->displayValueSeparatorAttribute() ?>" name="x_pp_id" id="x_pp_id" value="<?php echo HtmlEncode($bcode->pp_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbcodesearch.createAutoSuggest({"id":"x_pp_id","forceSelect":false});
</script>
<?php echo $bcode->pp_id->Lookup->getParamTag("p_x_pp_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_11->Visible) { // 11 ?>
	<div id="r__11" class="form-group row">
		<label for="x__11" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__11"><?php echo $bcode->_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__11" id="z__11" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_11->cellAttributes() ?>>
			<span id="el_bcode__11">
<input type="text" data-table="bcode" data-field="x__11" name="x__11" id="x__11" placeholder="<?php echo HtmlEncode($bcode->_11->getPlaceHolder()) ?>" value="<?php echo $bcode->_11->EditValue ?>"<?php echo $bcode->_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_12->Visible) { // 12 ?>
	<div id="r__12" class="form-group row">
		<label for="x__12" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__12"><?php echo $bcode->_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__12" id="z__12" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_12->cellAttributes() ?>>
			<span id="el_bcode__12">
<input type="text" data-table="bcode" data-field="x__12" name="x__12" id="x__12" placeholder="<?php echo HtmlEncode($bcode->_12->getPlaceHolder()) ?>" value="<?php echo $bcode->_12->EditValue ?>"<?php echo $bcode->_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_13->Visible) { // 13 ?>
	<div id="r__13" class="form-group row">
		<label for="x__13" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__13"><?php echo $bcode->_13->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__13" id="z__13" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_13->cellAttributes() ?>>
			<span id="el_bcode__13">
<input type="text" data-table="bcode" data-field="x__13" name="x__13" id="x__13" placeholder="<?php echo HtmlEncode($bcode->_13->getPlaceHolder()) ?>" value="<?php echo $bcode->_13->EditValue ?>"<?php echo $bcode->_13->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_14->Visible) { // 14 ?>
	<div id="r__14" class="form-group row">
		<label for="x__14" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__14"><?php echo $bcode->_14->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__14" id="z__14" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_14->cellAttributes() ?>>
			<span id="el_bcode__14">
<input type="text" data-table="bcode" data-field="x__14" name="x__14" id="x__14" placeholder="<?php echo HtmlEncode($bcode->_14->getPlaceHolder()) ?>" value="<?php echo $bcode->_14->EditValue ?>"<?php echo $bcode->_14->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_15->Visible) { // 15 ?>
	<div id="r__15" class="form-group row">
		<label for="x__15" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__15"><?php echo $bcode->_15->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__15" id="z__15" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_15->cellAttributes() ?>>
			<span id="el_bcode__15">
<input type="text" data-table="bcode" data-field="x__15" name="x__15" id="x__15" placeholder="<?php echo HtmlEncode($bcode->_15->getPlaceHolder()) ?>" value="<?php echo $bcode->_15->EditValue ?>"<?php echo $bcode->_15->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_16->Visible) { // 16 ?>
	<div id="r__16" class="form-group row">
		<label for="x__16" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__16"><?php echo $bcode->_16->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__16" id="z__16" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_16->cellAttributes() ?>>
			<span id="el_bcode__16">
<input type="text" data-table="bcode" data-field="x__16" name="x__16" id="x__16" placeholder="<?php echo HtmlEncode($bcode->_16->getPlaceHolder()) ?>" value="<?php echo $bcode->_16->EditValue ?>"<?php echo $bcode->_16->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_17->Visible) { // 17 ?>
	<div id="r__17" class="form-group row">
		<label for="x__17" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__17"><?php echo $bcode->_17->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__17" id="z__17" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_17->cellAttributes() ?>>
			<span id="el_bcode__17">
<input type="text" data-table="bcode" data-field="x__17" name="x__17" id="x__17" placeholder="<?php echo HtmlEncode($bcode->_17->getPlaceHolder()) ?>" value="<?php echo $bcode->_17->EditValue ?>"<?php echo $bcode->_17->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_18->Visible) { // 18 ?>
	<div id="r__18" class="form-group row">
		<label for="x__18" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__18"><?php echo $bcode->_18->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__18" id="z__18" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_18->cellAttributes() ?>>
			<span id="el_bcode__18">
<input type="text" data-table="bcode" data-field="x__18" name="x__18" id="x__18" placeholder="<?php echo HtmlEncode($bcode->_18->getPlaceHolder()) ?>" value="<?php echo $bcode->_18->EditValue ?>"<?php echo $bcode->_18->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_19->Visible) { // 19 ?>
	<div id="r__19" class="form-group row">
		<label for="x__19" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__19"><?php echo $bcode->_19->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__19" id="z__19" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_19->cellAttributes() ?>>
			<span id="el_bcode__19">
<input type="text" data-table="bcode" data-field="x__19" name="x__19" id="x__19" placeholder="<?php echo HtmlEncode($bcode->_19->getPlaceHolder()) ?>" value="<?php echo $bcode->_19->EditValue ?>"<?php echo $bcode->_19->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_20->Visible) { // 20 ?>
	<div id="r__20" class="form-group row">
		<label for="x__20" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__20"><?php echo $bcode->_20->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__20" id="z__20" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_20->cellAttributes() ?>>
			<span id="el_bcode__20">
<input type="text" data-table="bcode" data-field="x__20" name="x__20" id="x__20" placeholder="<?php echo HtmlEncode($bcode->_20->getPlaceHolder()) ?>" value="<?php echo $bcode->_20->EditValue ?>"<?php echo $bcode->_20->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_21->Visible) { // 21 ?>
	<div id="r__21" class="form-group row">
		<label for="x__21" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__21"><?php echo $bcode->_21->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__21" id="z__21" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_21->cellAttributes() ?>>
			<span id="el_bcode__21">
<input type="text" data-table="bcode" data-field="x__21" name="x__21" id="x__21" placeholder="<?php echo HtmlEncode($bcode->_21->getPlaceHolder()) ?>" value="<?php echo $bcode->_21->EditValue ?>"<?php echo $bcode->_21->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_22->Visible) { // 22 ?>
	<div id="r__22" class="form-group row">
		<label for="x__22" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__22"><?php echo $bcode->_22->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__22" id="z__22" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_22->cellAttributes() ?>>
			<span id="el_bcode__22">
<input type="text" data-table="bcode" data-field="x__22" name="x__22" id="x__22" placeholder="<?php echo HtmlEncode($bcode->_22->getPlaceHolder()) ?>" value="<?php echo $bcode->_22->EditValue ?>"<?php echo $bcode->_22->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_23->Visible) { // 23 ?>
	<div id="r__23" class="form-group row">
		<label for="x__23" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__23"><?php echo $bcode->_23->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__23" id="z__23" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_23->cellAttributes() ?>>
			<span id="el_bcode__23">
<input type="text" data-table="bcode" data-field="x__23" name="x__23" id="x__23" placeholder="<?php echo HtmlEncode($bcode->_23->getPlaceHolder()) ?>" value="<?php echo $bcode->_23->EditValue ?>"<?php echo $bcode->_23->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_24->Visible) { // 24 ?>
	<div id="r__24" class="form-group row">
		<label for="x__24" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__24"><?php echo $bcode->_24->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__24" id="z__24" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_24->cellAttributes() ?>>
			<span id="el_bcode__24">
<input type="text" data-table="bcode" data-field="x__24" name="x__24" id="x__24" placeholder="<?php echo HtmlEncode($bcode->_24->getPlaceHolder()) ?>" value="<?php echo $bcode->_24->EditValue ?>"<?php echo $bcode->_24->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_25->Visible) { // 25 ?>
	<div id="r__25" class="form-group row">
		<label for="x__25" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__25"><?php echo $bcode->_25->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__25" id="z__25" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_25->cellAttributes() ?>>
			<span id="el_bcode__25">
<input type="text" data-table="bcode" data-field="x__25" name="x__25" id="x__25" placeholder="<?php echo HtmlEncode($bcode->_25->getPlaceHolder()) ?>" value="<?php echo $bcode->_25->EditValue ?>"<?php echo $bcode->_25->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_26->Visible) { // 26 ?>
	<div id="r__26" class="form-group row">
		<label for="x__26" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__26"><?php echo $bcode->_26->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__26" id="z__26" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_26->cellAttributes() ?>>
			<span id="el_bcode__26">
<input type="text" data-table="bcode" data-field="x__26" name="x__26" id="x__26" placeholder="<?php echo HtmlEncode($bcode->_26->getPlaceHolder()) ?>" value="<?php echo $bcode->_26->EditValue ?>"<?php echo $bcode->_26->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_27->Visible) { // 27 ?>
	<div id="r__27" class="form-group row">
		<label for="x__27" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__27"><?php echo $bcode->_27->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__27" id="z__27" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_27->cellAttributes() ?>>
			<span id="el_bcode__27">
<input type="text" data-table="bcode" data-field="x__27" name="x__27" id="x__27" placeholder="<?php echo HtmlEncode($bcode->_27->getPlaceHolder()) ?>" value="<?php echo $bcode->_27->EditValue ?>"<?php echo $bcode->_27->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_28->Visible) { // 28 ?>
	<div id="r__28" class="form-group row">
		<label for="x__28" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__28"><?php echo $bcode->_28->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__28" id="z__28" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_28->cellAttributes() ?>>
			<span id="el_bcode__28">
<input type="text" data-table="bcode" data-field="x__28" name="x__28" id="x__28" placeholder="<?php echo HtmlEncode($bcode->_28->getPlaceHolder()) ?>" value="<?php echo $bcode->_28->EditValue ?>"<?php echo $bcode->_28->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_29->Visible) { // 29 ?>
	<div id="r__29" class="form-group row">
		<label for="x__29" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__29"><?php echo $bcode->_29->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__29" id="z__29" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_29->cellAttributes() ?>>
			<span id="el_bcode__29">
<input type="text" data-table="bcode" data-field="x__29" name="x__29" id="x__29" placeholder="<?php echo HtmlEncode($bcode->_29->getPlaceHolder()) ?>" value="<?php echo $bcode->_29->EditValue ?>"<?php echo $bcode->_29->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_30->Visible) { // 30 ?>
	<div id="r__30" class="form-group row">
		<label for="x__30" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__30"><?php echo $bcode->_30->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__30" id="z__30" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_30->cellAttributes() ?>>
			<span id="el_bcode__30">
<input type="text" data-table="bcode" data-field="x__30" name="x__30" id="x__30" placeholder="<?php echo HtmlEncode($bcode->_30->getPlaceHolder()) ?>" value="<?php echo $bcode->_30->EditValue ?>"<?php echo $bcode->_30->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_31->Visible) { // 31 ?>
	<div id="r__31" class="form-group row">
		<label for="x__31" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__31"><?php echo $bcode->_31->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__31" id="z__31" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_31->cellAttributes() ?>>
			<span id="el_bcode__31">
<input type="text" data-table="bcode" data-field="x__31" name="x__31" id="x__31" placeholder="<?php echo HtmlEncode($bcode->_31->getPlaceHolder()) ?>" value="<?php echo $bcode->_31->EditValue ?>"<?php echo $bcode->_31->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_32->Visible) { // 32 ?>
	<div id="r__32" class="form-group row">
		<label for="x__32" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__32"><?php echo $bcode->_32->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__32" id="z__32" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_32->cellAttributes() ?>>
			<span id="el_bcode__32">
<input type="text" data-table="bcode" data-field="x__32" name="x__32" id="x__32" placeholder="<?php echo HtmlEncode($bcode->_32->getPlaceHolder()) ?>" value="<?php echo $bcode->_32->EditValue ?>"<?php echo $bcode->_32->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_33->Visible) { // 33 ?>
	<div id="r__33" class="form-group row">
		<label for="x__33" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__33"><?php echo $bcode->_33->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__33" id="z__33" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_33->cellAttributes() ?>>
			<span id="el_bcode__33">
<input type="text" data-table="bcode" data-field="x__33" name="x__33" id="x__33" placeholder="<?php echo HtmlEncode($bcode->_33->getPlaceHolder()) ?>" value="<?php echo $bcode->_33->EditValue ?>"<?php echo $bcode->_33->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_34->Visible) { // 34 ?>
	<div id="r__34" class="form-group row">
		<label for="x__34" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__34"><?php echo $bcode->_34->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__34" id="z__34" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_34->cellAttributes() ?>>
			<span id="el_bcode__34">
<input type="text" data-table="bcode" data-field="x__34" name="x__34" id="x__34" placeholder="<?php echo HtmlEncode($bcode->_34->getPlaceHolder()) ?>" value="<?php echo $bcode->_34->EditValue ?>"<?php echo $bcode->_34->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_35->Visible) { // 35 ?>
	<div id="r__35" class="form-group row">
		<label for="x__35" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__35"><?php echo $bcode->_35->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__35" id="z__35" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_35->cellAttributes() ?>>
			<span id="el_bcode__35">
<input type="text" data-table="bcode" data-field="x__35" name="x__35" id="x__35" placeholder="<?php echo HtmlEncode($bcode->_35->getPlaceHolder()) ?>" value="<?php echo $bcode->_35->EditValue ?>"<?php echo $bcode->_35->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_36->Visible) { // 36 ?>
	<div id="r__36" class="form-group row">
		<label for="x__36" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__36"><?php echo $bcode->_36->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__36" id="z__36" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_36->cellAttributes() ?>>
			<span id="el_bcode__36">
<input type="text" data-table="bcode" data-field="x__36" name="x__36" id="x__36" placeholder="<?php echo HtmlEncode($bcode->_36->getPlaceHolder()) ?>" value="<?php echo $bcode->_36->EditValue ?>"<?php echo $bcode->_36->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_37->Visible) { // 37 ?>
	<div id="r__37" class="form-group row">
		<label for="x__37" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__37"><?php echo $bcode->_37->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__37" id="z__37" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_37->cellAttributes() ?>>
			<span id="el_bcode__37">
<input type="text" data-table="bcode" data-field="x__37" name="x__37" id="x__37" placeholder="<?php echo HtmlEncode($bcode->_37->getPlaceHolder()) ?>" value="<?php echo $bcode->_37->EditValue ?>"<?php echo $bcode->_37->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_38->Visible) { // 38 ?>
	<div id="r__38" class="form-group row">
		<label for="x__38" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__38"><?php echo $bcode->_38->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__38" id="z__38" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_38->cellAttributes() ?>>
			<span id="el_bcode__38">
<input type="text" data-table="bcode" data-field="x__38" name="x__38" id="x__38" placeholder="<?php echo HtmlEncode($bcode->_38->getPlaceHolder()) ?>" value="<?php echo $bcode->_38->EditValue ?>"<?php echo $bcode->_38->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_39->Visible) { // 39 ?>
	<div id="r__39" class="form-group row">
		<label for="x__39" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__39"><?php echo $bcode->_39->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__39" id="z__39" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_39->cellAttributes() ?>>
			<span id="el_bcode__39">
<input type="text" data-table="bcode" data-field="x__39" name="x__39" id="x__39" placeholder="<?php echo HtmlEncode($bcode->_39->getPlaceHolder()) ?>" value="<?php echo $bcode->_39->EditValue ?>"<?php echo $bcode->_39->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_40->Visible) { // 40 ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__40"><?php echo $bcode->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__40" id="z__40" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_40->cellAttributes() ?>>
			<span id="el_bcode__40">
<input type="text" data-table="bcode" data-field="x__40" name="x__40" id="x__40" placeholder="<?php echo HtmlEncode($bcode->_40->getPlaceHolder()) ?>" value="<?php echo $bcode->_40->EditValue ?>"<?php echo $bcode->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_41->Visible) { // 41 ?>
	<div id="r__41" class="form-group row">
		<label for="x__41" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__41"><?php echo $bcode->_41->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__41" id="z__41" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_41->cellAttributes() ?>>
			<span id="el_bcode__41">
<input type="text" data-table="bcode" data-field="x__41" name="x__41" id="x__41" placeholder="<?php echo HtmlEncode($bcode->_41->getPlaceHolder()) ?>" value="<?php echo $bcode->_41->EditValue ?>"<?php echo $bcode->_41->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_42->Visible) { // 42 ?>
	<div id="r__42" class="form-group row">
		<label for="x__42" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__42"><?php echo $bcode->_42->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__42" id="z__42" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_42->cellAttributes() ?>>
			<span id="el_bcode__42">
<input type="text" data-table="bcode" data-field="x__42" name="x__42" id="x__42" placeholder="<?php echo HtmlEncode($bcode->_42->getPlaceHolder()) ?>" value="<?php echo $bcode->_42->EditValue ?>"<?php echo $bcode->_42->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_43->Visible) { // 43 ?>
	<div id="r__43" class="form-group row">
		<label for="x__43" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__43"><?php echo $bcode->_43->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__43" id="z__43" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_43->cellAttributes() ?>>
			<span id="el_bcode__43">
<input type="text" data-table="bcode" data-field="x__43" name="x__43" id="x__43" placeholder="<?php echo HtmlEncode($bcode->_43->getPlaceHolder()) ?>" value="<?php echo $bcode->_43->EditValue ?>"<?php echo $bcode->_43->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_44->Visible) { // 44 ?>
	<div id="r__44" class="form-group row">
		<label for="x__44" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__44"><?php echo $bcode->_44->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__44" id="z__44" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_44->cellAttributes() ?>>
			<span id="el_bcode__44">
<input type="text" data-table="bcode" data-field="x__44" name="x__44" id="x__44" placeholder="<?php echo HtmlEncode($bcode->_44->getPlaceHolder()) ?>" value="<?php echo $bcode->_44->EditValue ?>"<?php echo $bcode->_44->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_45->Visible) { // 45 ?>
	<div id="r__45" class="form-group row">
		<label for="x__45" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__45"><?php echo $bcode->_45->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__45" id="z__45" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_45->cellAttributes() ?>>
			<span id="el_bcode__45">
<input type="text" data-table="bcode" data-field="x__45" name="x__45" id="x__45" placeholder="<?php echo HtmlEncode($bcode->_45->getPlaceHolder()) ?>" value="<?php echo $bcode->_45->EditValue ?>"<?php echo $bcode->_45->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_46->Visible) { // 46 ?>
	<div id="r__46" class="form-group row">
		<label for="x__46" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__46"><?php echo $bcode->_46->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__46" id="z__46" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_46->cellAttributes() ?>>
			<span id="el_bcode__46">
<input type="text" data-table="bcode" data-field="x__46" name="x__46" id="x__46" placeholder="<?php echo HtmlEncode($bcode->_46->getPlaceHolder()) ?>" value="<?php echo $bcode->_46->EditValue ?>"<?php echo $bcode->_46->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_47->Visible) { // 47 ?>
	<div id="r__47" class="form-group row">
		<label for="x__47" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__47"><?php echo $bcode->_47->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__47" id="z__47" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_47->cellAttributes() ?>>
			<span id="el_bcode__47">
<input type="text" data-table="bcode" data-field="x__47" name="x__47" id="x__47" placeholder="<?php echo HtmlEncode($bcode->_47->getPlaceHolder()) ?>" value="<?php echo $bcode->_47->EditValue ?>"<?php echo $bcode->_47->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_48->Visible) { // 48 ?>
	<div id="r__48" class="form-group row">
		<label for="x__48" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__48"><?php echo $bcode->_48->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__48" id="z__48" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_48->cellAttributes() ?>>
			<span id="el_bcode__48">
<input type="text" data-table="bcode" data-field="x__48" name="x__48" id="x__48" placeholder="<?php echo HtmlEncode($bcode->_48->getPlaceHolder()) ?>" value="<?php echo $bcode->_48->EditValue ?>"<?php echo $bcode->_48->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_49->Visible) { // 49 ?>
	<div id="r__49" class="form-group row">
		<label for="x__49" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__49"><?php echo $bcode->_49->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__49" id="z__49" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_49->cellAttributes() ?>>
			<span id="el_bcode__49">
<input type="text" data-table="bcode" data-field="x__49" name="x__49" id="x__49" placeholder="<?php echo HtmlEncode($bcode->_49->getPlaceHolder()) ?>" value="<?php echo $bcode->_49->EditValue ?>"<?php echo $bcode->_49->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->_50->Visible) { // 50 ?>
	<div id="r__50" class="form-group row">
		<label for="x__50" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode__50"><?php echo $bcode->_50->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__50" id="z__50" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->_50->cellAttributes() ?>>
			<span id="el_bcode__50">
<input type="text" data-table="bcode" data-field="x__50" name="x__50" id="x__50" placeholder="<?php echo HtmlEncode($bcode->_50->getPlaceHolder()) ?>" value="<?php echo $bcode->_50->EditValue ?>"<?php echo $bcode->_50->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label for="x_p_remarks" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_p_remarks"><?php echo $bcode->p_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_p_remarks" id="z_p_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->p_remarks->cellAttributes() ?>>
			<span id="el_bcode_p_remarks">
<input type="text" data-table="bcode" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" size="35" placeholder="<?php echo HtmlEncode($bcode->p_remarks->getPlaceHolder()) ?>" value="<?php echo $bcode->p_remarks->EditValue ?>"<?php echo $bcode->p_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bcode->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
	<div id="r_roll_no_qty_tmp" class="form-group row">
		<label for="x_roll_no_qty_tmp" class="<?php echo $bcode_search->LeftColumnClass ?>"><span id="elh_bcode_roll_no_qty_tmp"><?php echo $bcode->roll_no_qty_tmp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no_qty_tmp" id="z_roll_no_qty_tmp" value="="></span>
		</label>
		<div class="<?php echo $bcode_search->RightColumnClass ?>"><div<?php echo $bcode->roll_no_qty_tmp->cellAttributes() ?>>
			<span id="el_bcode_roll_no_qty_tmp">
<input type="text" data-table="bcode" data-field="x_roll_no_qty_tmp" name="x_roll_no_qty_tmp" id="x_roll_no_qty_tmp" size="30" placeholder="<?php echo HtmlEncode($bcode->roll_no_qty_tmp->getPlaceHolder()) ?>" value="<?php echo $bcode->roll_no_qty_tmp->EditValue ?>"<?php echo $bcode->roll_no_qty_tmp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bcode_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bcode_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_search->terminate();
?>